/* CONNECTIONS:
  pin 11 подключаем MAX7219 DataIn
  pin 13 подключаем MAX7219 CLK
  pin 10 подключаем MAX7219 LOAD/CS
  pins A4/A5 SDA/SCL контакты RTC модуля
  pin 2 - audio на базу через резистор 220ohm, эмитер GND, speaker на коллектор и через резистор 10ohm на VCC
  pin 4 - клавиатура 1 клавишa Mode/Set
  pin 5 - клавиатура 2 клавишa "+"/Next
  pin 6 - клавиатура 3 клавишa "-"/"+1"
  pin A0 - thermistor на VCC, A0 через R=10k на GND
  pin A1 - фоторезистор на корпус, 100К на +5в */
// NOKIA tunes:----------------------------------------------------------------------------------------------------------------------------------------------------------------------
const unsigned char mess[] PROGMEM = "Triple:d=8,o=5,b=635:c,e,g,c,e,g,c,e,g,c6,e6,g6,c6,e6,g6,c6,e6,g6,c7,e7,g7,c7,e7,g7,c7,e7,g7";
const unsigned char bday[] PROGMEM = "Happy birthday:d=4,o=5,b=125:8d.,16d,e,d,g,2f#,8d.,16d,e,d,a,2g,8d.,16d,d6,b,g,f#,2e,8c.6,16c6,b,g,a,2g";
const unsigned char alarm0[] PROGMEM = "MissionImp:d=16,o=6,b=95:32d,32d#,32d,32d#,32d,32d#,32d,32d#,32d,32d,32d#,32e,32f,32f#,32g,g,8p,g,8p,a#,p,c7,p,g,8p,g,8p,f,p,f#,p,g,8p,g,8p,a#,p,c7,p,g,8p,g,8p,f,p,f#,p,a#,g,2d,32p,a#,g,2c#,32p,a#,g,2c,a#5,8c,2p,32p,a#5,g5,2f#,32p,a#5,g5,2f,32p,a#5,g5,2e,d#,8d";
const unsigned char alarm1[] PROGMEM = "TakeOnMe:d=4,o=4,b=160:8f#5,8f#5,8f#5,8d5,8p,8b,8p,8e5,8p,8e5,8p,8e5,8g#5,8g#5,8a5,8b5,8a5,8a5,8a5,8e5,8p,8d5,8p,8f#5,8p,8f#5,8p,8f#5,8e5,8e5,8f#5,8e5,8f#5,8f#5,8f#5,8d5,8p,8b,8p,8e5,8p,8e5,8p,8e5,8g#5,8g#5,8a5,8b5,8a5,8a5,8a5,8e5,8p,8d5,8p,8f#5,8p,8f#5,8p,8f#5,8e5,8e5";
const unsigned char alarm2[] PROGMEM = "Mission Impossible:d=32,o=5,b=125:d6,d#6,d6,d#6,d6,d#6,d6,d#6,d6,d#6,d6,d#6,d6,d#6,d6,d#6,d6,d#6,d6,d#6,e6,f#6,d#6,8g.6,8g.,8g.,8a#,8c6,8g.,8g.,8f,8f#,8g.,8g.,8a#,8c6,8g.,8g.,8f,8f#,16a#6,16g6,2d6,16a#6,16g6,2c#6,16a#6,16g6,2c6,16a#,8c.6,4p,16a#,16g,2f#6,16a#,16g,2f6,16a#,16g,2e6,16d#6,8d.6";
const unsigned char alarm3[] PROGMEM = "Popcorn:d=4,o=5,b=160:8c6,8a#,8c6,8g,8d#,8g,c,8c6,8a#,8c6,8g,8d#,8g,c,8c6,8d6,8d#6,16c6,8d#6,16c6,8d#6,8d6,16a#,8d6,16a#,8d6,8c6,8a#,8g,8a#,c6";
const unsigned char alarm4[] PROGMEM = "Smurfs:d=32,o=5,b=200:4c#6,16p,4f#6,p,16c#6,p,8d#6,p,8b,p,4g#,16p,4c#6,p,16a#,p,8f#,p,8a#,p,4g#,4p,g#,p,a#,p,b,p,c6,p,4c#6,16p,4f#6,p,16c#6,p,8d#6,p,8b,p,4g#,16p,4c#6,p,16a#,p,8b,p,8f,p,4f#";
const unsigned char alarm5[] PROGMEM = "Indiana:d=4,o=5,b=250:e,8p,8f,8g,8p,1c6,8p.,d,8p,8e,1f,p.,g,8p,8a,8b,8p,1f6,p,a,8p,8b,2c6,2d6,2e6,e,8p,8f,8g,8p,1c6,p,d6,8p,8e6,1f.6,g,8p,8g,e.6,8p,d6,8p,8g,e.6,8p,d6,8p,8g,f.6,8p,e6,8p,8d6,2c6";
const unsigned char alarm6[] PROGMEM = "Entertainer:d=4,o=5,b=140:8d,8d#,8e,c6,8e,c6,8e,2c.6,8c6,8d6,8d#6,8e6,8c6,8d6,e6,8b,d6,2c6,p,8d,8d#,8e,c6,8e,c6,8e,2c.6,8p,8a,8g,8f#,8a,8c6,e6,8d6,8c6,8a,2d6";
//const unsigned char alarm7[] PROGMEM = "Muppets:d=4,o=5,b=250:c6,c6,a,b,8a,b,g,p,c6,c6,a,8b,8a,8p,g.,p,e,e,g,f,8e,f,8c6,8c,8d,e,8e,8e,8p,8e,g,2p,c6,c6,a,b,8a,b,g,p,c6,c6,a,8b,a,g.,p,e,e,g,f,8e,f,8c6,8c,8d,e,8e,d,8d,c";
//const unsigned char alarm8[] PROGMEM = "Xfiles:d=4,o=5,b=125:e,b,a,b,d6,2b.,1p,e,b,a,b,e6,2b.,1p,g6,f#6,e6,d6,e6,2b.,1p,g6,f#6,e6,d6,f#6,2b.,1p,e,b,a,b,d6,2b.,1p,e,b,a,b,e6,2b.,1p,e6,2b.";
//const unsigned char alarm9[] PROGMEM = "Looney:d=4,o=5,b=140:32p,c6,8f6,8e6,8d6,8c6,a.,8c6,8f6,8e6,8d6,8d#6,e.6,8e6,8e6,8c6,8d6,8c6,8e6,8c6,8d6,8a,8c6,8g,8a#,8a,8f";
//const unsigned char alarm10[] PROGMEM = "20thCenFox:d=16,o=5,b=140:b,8p,b,b,2b,p,c6,32p,b,32p,c6,32p,b,32p,c6,32p,b,8p,b,b,b,32p,b,32p,b,32p,b,32p,b,32p,b,32p,b,32p,g#,32p,a,32p,b,8p,b,b,2b,4p,8e,8g#,8b,1c#6,8f#,8a,8c#6,1e6,8a,8c#6,8e6,1e6,8b,8g#,8a,2b";
//const unsigned char alarm11[] PROGMEM = "Bond:d=4,o=5,b=80:32p,16c#6,32d#6,32d#6,16d#6,8d#6,16c#6,16c#6,16c#6,16c#6,32e6,32e6,16e6,8e6,16d#6,16d#6,16d#6,16c#6,32d#6,32d#6,16d#6,8d#6,16c#6,16c#6,16c#6,16c#6,32e6,32e6,16e6,8e6,16d#6,16d6,16c#6,16c#7,c.7,16g#6,16f#6,g#.6";
//const unsigned char alarm12[] PROGMEM = "MASH:d=8,o=5,b=140:4a,4g,f#,g,p,f#,p,g,p,f#,p,2e.,p,f#,e,4f#,e,f#,p,e,p,4d.,p,f#,4e,d,e,p,d,p,e,p,d,p,2c#.,p,d,c#,4d,c#,d,p,e,p,4f#,p,a,p,4b,a,b,p,a,p,b,p,2a.,4p,a,b,a,4b,a,b,p,2a.,a,4f#,a,b,p,d6,p,4e.6,d6,b,p,a,p,2b";
//const unsigned char alarm13[] PROGMEM = "StarWars:d=4,o=5,b=45:32p,32f#,32f#,32f#,8b.,8f#.6,32e6,32d#6,32c#6,8b.6,16f#.6,32e6,32d#6,32c#6,8b.6,16f#.6,32e6,32d#6,32e6,8c#.6,32f#,32f#,32f#,8b.,8f#.6,32e6,32d#6,32c#6,8b.6,16f#.6,32e6,32d#6,32c#6,8b.6,16f#.6,32e6,32d#6,32e6,8c#6";
//const unsigned char alarm14[] PROGMEM = "GoodBad:d=4,o=5,b=56:32p,32a#,32d#6,32a#,32d#6,8a#.,16f#.,16g#.,d#,32a#,32d#6,32a#,32d#6,8a#.,16f#.,16g#.,c#6,32a#,32d#6,32a#,32d#6,8a#.,16f#.,32f.,32d#.,c#,32a#,32d#6,32a#,32d#6,8a#.,16g#.,d#";
//const unsigned char alarm15[] PROGMEM = "TopGun:d=4,o=4,b=31:32p,16c#,16g#,16g#,32f#,32f,32f#,32f,16d#,16d#,32c#,32d#,16f,32d#,32f,16f#,32f,32c#,16f,d#,16c#,16g#,16g#,32f#,32f,32f#,32f,16d#,16d#,32c#,32d#,16f,32d#,32f,16f#,32f,32c#,g#";
//const unsigned char alarm16[] PROGMEM = "A-Team:d=8,o=5,b=125:4d#6,a#,2d#6,16p,g#,4a#,4d#.,p,16g,16a#,d#6,a#,f6,2d#6,16p,c#.6,16c6,16a#,g#.,2a#";
//const unsigned char alarm17[] PROGMEM = "Flinstones:d=4,o=5,b=40:32p,16f6,16a#,16a#6,32g6,16f6,16a#.,16f6,32d#6,32d6,32d6,32d#6,32f6,16a#,16c6,d6,16f6,16a#.,16a#6,32g6,16f6,16a#.,32f6,32f6,32d#6,32d6,32d6,32d#6,32f6,16a#,16c6,a#,16a6,16d.6,16a#6,32a6,32a6,32g6,32f#6,32a6,8g6,16g6,16c.6,32a6,32a6,32g6,32g6,32f6,32e6,32g6,8f6,16f6,16a#.,16a#6,32g6,16f6,16a#.,16f6,32d#6,32d6,32d6,32d#6,32f6,16a#,16c.6,32d6,32d#6,32f6,16a#,16c.6,32d6,32d#6,32f6,16a#6,16c7,8a#.6";
//const unsigned char alarm18[] PROGMEM = "Jeopardy:d=4,o=6,b=125:c,f,c,f5,c,f,2c,c,f,c,f,a.,8g,8f,8e,8d,8c#,c,f,c,f5,c,f,2c,f.,8d,c,a#5,a5,g5,f5,p,d#,g#,d#,g#5,d#,g#,2d#,d#,g#,d#,g#,c.7,8a#,8g#,8g,8f,8e,d#,g#,d#,g#5,d#,g#,2d#,g#.,8f,d#,c#,c,p,a#5,p,g#.5,d#,g#";
//const unsigned char alarm19[] PROGMEM = "Gadget:d=16,o=5,b=50:32d#,32f,32f#,32g#,a#,f#,a,f,g#,f#,32d#,32f,32f#,32g#,a#,d#6,4d6,32d#,32f,32f#,32g#,a#,f#,a,f,g#,f#,8d#";
//const unsigned char alarm20[] PROGMEM = "MahnaMahna:d=16,o=6,b=125:c#,c.,b5,8a#.5,8f.,4g#,a#,g.,4d#,8p,c#,c.,b5,8a#.5,8f.,g#.,8a#.,4g,8p,c#,c.,b5,8a#.5,8f.,4g#,f,g.,8d#.,f,g.,8d#.,f,8g,8d#.,f,8g,d#,8c,a#5,8d#.,8d#.,4d#,8d#.";
//const unsigned char alarm21[] PROGMEM = "LeisureSuit:d=16,o=6,b=56:f.5,f#.5,g.5,g#5,32a#5,f5,g#.5,a#.5,32f5,g#5,32a#5,g#5,8c#.,a#5,32c#,a5,a#.5,c#.,32a5,a#5,32c#,d#,8e,c#.,f.,f.,f.,f.,f,32e,d#,8d,a#.5,e,32f,e,32f,c#,d#.,c#";
//const unsigned char alarm22[] PROGMEM = "The Simpsons:d=4,o=5,b=160:c.6,e6,f#6,8a6,g.6,e6,c6,8a,8f#,8f#,8f#,2g,8p,8p,8f#,8f#,8f#,8g,a#.,8c6,8c6,8c6,c6";
//------------------------------------------------MAX7219 matrices----------------------------------------------------------------------------------------
#define NUM_MAX          10                         // Устанавливаем количество наших модулей с LED 8х8
#define DIN_PIN          11//D7//                        //
#define CS_PIN           10//D8//                        //
#define CLK_PIN          13//D5//                        //
//------------------------------------------------Kлавиатура, динамик, термистор, фоторезистор------------------------------------------------------------
#define BUTTON_1         4                         // Пин клавиши 1
#define BUTTON_2         5                         // Пин клавиши 2
#define BUTTON_3         6                         // Пин клавиши 3
#define AUDIO_PIN        2                         // Аудио пин
#define ONE_WIRE_PIN     A0                        // пин для подключения DS18B20
#define BRIGHT_PIN       A1                        // Пин фоторезистора
//------------------------------------------------Кукушка, Оповещения Дней рождения-----------------------------------------------------------------------
#define CHIME_START      6                         // от этого часа каждый час будет сигнал
#define CHIME_END        23                        // после этого часа ежечасного сигнала не будет
#define BDAY_START       15                        // С этого часа будет звуковое оповещение специального дня
#define BDAY_END         22                        // Конец оповещений специального дня
//------------------------------------------------Дневное врем, будильники--------------------------------------------------------------------------------
#define DAY_START        7                         // Время начала дневного режима
#define DAY_END          22                        // Время начала ночного режима
#define AMOUNT_ALARM     4                         // КОЛИЧЕСТВО БУДИЛЬНИКОВ (00-99) имейте совесь с количеством, вам же их потом настраивать)))
//------------------------------------------------Начальные установки будильников, времени и даты, позднее будут считаны из памяти модуля RTC-------------
int hourAlarm[AMOUNT_ALARM], minuteAlarm[AMOUNT_ALARM], modeAlarm[AMOUNT_ALARM];
int hour = 22, minute = 55, second = 0;            //
int year = 2020, month = 1, day = 7, dayOfWeek = 5; //
//------------------------------------------------Подключаем библиотеки внешние и в наших закладках-------------------------------------------------------
#include <Wire.h>                                  // Подключаем библиотеку I2C
#include "rtc.h"                                   // Подключаем нашу библиотеку часов
#include "audio.h"                                 // Подключаем нашу библиотеку аудио
#include "max7219.h"                               // Подключаем нашу библиотеку вывода на экран
#include "fonts.h"                                 // Подключаем нашу библиотеку шрифтов
#include <OneWire.h>
#include <EEPROM.h>                                  // 
#include "GyverTimer.h"
// -----------------------------------------------К переменным режимов привязываем значения---------------------------------------------------------------
#define CLOCKBIG    0                              // mode 1  (22:55) Большие часы 
#define CLOCKBIG1   1                              // mode 1  (22:55) Большие часы
#define CLOCKNOR    2                              // mode 1  (22:55) Большие часы
#define CLOCKNOR2   3                              // mode 1  (22:55) Большие часы
#define CLOCKMED    4                              // mode 2  (22:55_04)-  переберает режимы по списку АВТО
#define CLOCKMED3   5                              // mode 3  (22:55_04) 
#define CLOCK       6                              // mode 4  (22:55_04)-  переберает режимы по списку АВТО
#define CLOCK4      7                              // mode 5  (22:55_04) 
#define TEMP        8                              // mode 6  (+20,7oC)
#define CLOCKBIGJMP 9                              // mode 7  (большие часы летают по экрану)
#define DATE1       10                              // mode 8  дата
#define SPECIAL     14                              // дата или печатает текст специального дня
#define TEXT        15                             // текст специального дня
#define INIT_KEY    50                             // ключ первого запуска. 0-254, на выбор
#define INIT_ADDR 1023                             // номер резервной ячейки

//------------------------------------------------ Инициализируем переменные-------------------------------------------------------------------------------
OneWire oneWire(ONE_WIRE_PIN);
bool alarme = false;                               // флаг включенного будильника Нужен для отображения разного стиля точек на бигклоке)))
int dx = 0;                                        // начальные координаты на светодиодной матрице
int dy = 0;                                        // --//--
int alarmCnt = 0;                                  // 0 - не воспроизводим мелодию звонка. Eсли больше "0" - то это количество проиграшей мелодии
int  h1, h0, m1, m0, s1, s0, secFr, lastSec = 1, lastMin = 0; // h1 - десятки часов, h0 - еденицы часов и так далее, secFr- секунный цикл,
int lasth1, lasth0, lastm1, lastm0, lasts1, lasts0; // предыдущие h1 - десятки часов, h0 - еденицы часов и так далее,
int d1, d0, mn1, mn0, y1, y0, dw, lastDay = -1;    // d1 - десятки дней, d0 - еденицы дней и так далее...
int mode = 1, prevMode;                          // моде - режим вывода на экран, превмоде - предыдущий режим
int stx = 1, sty = 1;                              // напавление смещения для скачущего дисплея
int st = 1;                                        // направление смещения экранов -1 или +1
int disp = 1, prevDisp = 1;                        // номер текущего дисплея и предыдущего дисплея
int tr1 = 0, tr2 = 0;                              // временные координаты "х" старого и нового дисплея
int trdisp1 = 1, trdisp2 = 1;                      // временный дисплеи для режима смены дисплеев
int trans = 0, prevTrans = 0;                      // переменные для формирования числа 1-4 исп. для смены стиля режмимов дисплея (влево, вправо, сверху, снизу)
int dots = 0;                                      // необходима для мигания точек каждые 0,5 секунд
int dots2 = 0;                                     // меняет значение каждую секунду
float temp;                                      // Переменная температуры
uint32_t startTime;                                // какая то задержка 0,025 сек
int setMode = 0;                                   // режим настройки 0-выключен, 1-часы, 2-дата, 3-день недели, 4-будильники, 5-яркость экрана
int brightSet = 7;                                // яркость экрана 0-15, 16-автоматическая рег., 17-день/ночь
int key = 0;                                       // в зависимости от нажатых клавиш принимает значение 0, 1, 2, 3 - по номерам кнопок
int keyOld = 0;                                    // старое значение нажатой клавиши
int keySpeed = 0;                                  // переменная задает скорость повтора нажатых клавиш
unsigned long now;                                 // переменная для счетчиков реального времени
const int timerMenu = 10000;                       // время (в мс) перед автоматическим выходом из режима настроек


GTimer_ms myTimer;                // создать таймер
//------------------------------------------------ void SETUP----------------------------------------------------------------------------------------------
void setup() {                                     //
  Serial.begin (115200);                             //
  pinMode(AUDIO_PIN, OUTPUT);                      //
  digitalWrite(BUTTON_1, HIGH);                    //
  digitalWrite(BUTTON_2, HIGH);                    //
  digitalWrite(BUTTON_3, HIGH);                    //

 myTimer.setInterval(1000);   // настроить интервал 5 сек

  
  initMAX7219();
  clrAll();                                        //
  refreshAll();                                    //
  sendCmdAll(CMD_SHUTDOWN, 1);                     //
  sendCmdAll(CMD_INTENSITY, 5);                    // Яркость свечения при старте (0-5)


  Wire.begin();                                    //
  for (int i = 0; i < AMOUNT_ALARM; i++) {         // Загружаем из памяти RTC модуля значения будильников в переменные
    hourAlarm[i] = readRTCMem(i * 3);              //
    minuteAlarm[i] = readRTCMem(i * 3 + 1);        //
    modeAlarm[i] = readRTCMem(i * 3 + 2);          //
    Serial.print(i); Serial.print("\t"); Serial.print(hourAlarm[i]); Serial.print("\t"); Serial.print(minuteAlarm[i]); Serial.print("\t"); Serial.println(modeAlarm[i]);
  }                                                //

}
//======================================================================= void LOOP===============================================================================================
void loop() {                                                             //
  getRTCDateTime();                                                       // Получаем значения времени и даты
  if (secFr == 0) {                                                       //
    h1 = hour / 10;                                                       // записываем десятки часов
    h0 = hour % 10;                                                       // еденицы часов
    m1 = minute / 10;                                                     // десятки минут
    m0 = minute % 10;                                                     // еденицы минут
    s1 = second / 10;                                                     // десятки секунд
    s0 = second % 10;                                                     // еденицы секунд
    d1 = day / 10;                                                        // десятки дней
    d0 = day % 10;                                                        // еденицы дней
    mn1 = month / 10;                                                     // десятки месяца
    mn0 = month % 10;                                                     // еденицы месяца
    y1 = (year - 2000) / 10;                                              // десятки года
    y0 = (year - 2000) % 10;                                              // еденицы года

  }                                                                       //
  if (second != lastSec) {                                                // проверка начала новой секунды
    lastSec = second;                                                     // в переменную сатрой секунды устанавливаем значение новой секунды
    secFr = 0;                                                            // в начале новой секунды сбрасываем в "0"
  } else secFr++;                                                         // далее просто счетчик циклов
  dots = (secFr < 20) ? 1 : 0;                                            // dots - меняет значение каждые 0,5 сек (период 1 секунда)
  dots2 = (second % 2) ? 1 : 0;                                           // dots2 - меняет значение при смене четных и не четных секунд (период 2 секунды)

  startTime = millis()%15000;                                                   //
 if (startTime<10000) showAnimClock();
 if (startTime>10000) showTemp();
 //if (startTime==15000)startTime=0;   
} 
//==========================================КОНЕЦ void LOOP===============================================================================================

 void    showAnimClock(){
  
    for (int q = 0; q < 12;  ) {                              // для того чтобы отрисовать цифру состаящую из 12 точек (или шагов как правильно?)
    
    if (millis() % 2==0)q++ ;                                 // метод научного тыка! не знаю , что написал  
    
    if (s0 != lasts0){showDigit( s0 * 12 + q, 28, dig3x7q);}  // s0 * 12 + q - номер строки в масиве dig3x7q (смотрим вкладку "fonts.h") 
    else showDigit(s0, 28, dig3x7s);                           // s0 - номер строки в масиве dig3x7s (смотрим вкладку "fonts.h") 

    if (s1 != lasts1) showDigit( s1 * 12 + q, 24, dig3x7q);   //24- позиция экрана с которой начинать печать
    else showDigit(s1, 24, dig3x7s);                          //24- позиция экрана с которой начинать печать 
     
    if (m0 != lastm0) showDigit( m0 * 12 + q, 17, dig4x8q);   // dig3x7q - указатель на масив данных (смотрим вкладку "fonts.h") 
    else showDigit(m0, 17, dig4x8);                           // dig4x8 - указатель на масив данных  (смотрим вкладку "fonts.h") 
    
    if (m1 != lastm1) showDigit( m1 * 12 + q, 12, dig4x8q);   // (m1 != lastm1)- проверяем изменилась цифра или нет
    else  showDigit(m1, 12, dig4x8);
 
    if (h0 != lasth0) showDigit( h0 * 12 + q, 5, dig4x8q);
    else showDigit(h0, 5, dig4x8);
       
    if (h1>0){
    if (h1 != lasth1)showDigit( h1 * 12 + q, 0, dig4x8q);
    else showDigit(h1, 0, dig4x8);}
    
    int flag = millis() % 1000;                                                  // счетчик будет считать до тысячи и все заново(я так думаю, поправте если не прав)
    if ( flag > 500) { setCol(10, 0x24);}                                        // если флаг больше 500, рисуем точки

  refreshAll();                                                                    // вывод на экран (смотрим вкладку "max7219.h")
  clrAll();                                                                        // очищает экран полностью (смотрим вкладку "max7219.h")
    }
    lasth1 = h1; lasth0 = h0; lastm1 = m1; lastm0 = m0; lasts1 = s1; lasts0 = s0;  // для того чтобы знать изменилась цифра или нет
    temp=readDS18B20();                                                    // Считываем значение температуры

}

// ---------------------------------------------------------------------- Выводим символ из блока фонтов
void showDigit(char ch, int col, const uint8_t *data) {                   // ch- номер строки в масиве; col- позиция экрана с которой начинать печать; *data- указатель на масив данных
 
  if (dy < -8 || dy > 8) return;                                          //
  int len = pgm_read_byte(data);                                          // len - это количество символов в строке нашашего масива, считываем первый байт из масива и записываем его в len
  int w = pgm_read_byte(data + 1 + ch * len);                             // w - (ссылка намасив + 1 (первый байт)  + номер строки умноженный на длину строк) - считываем первый байт из нужной строки
  col += dx;                                                              // наша позиция для вывода + dx???
  for (int i = 0; i < w; i++)                                             // запускаем цикл размерностью нашего первого байта из нашей строки (размерность символа)
    if (col + i >= 0 && col + i < NUM_MAX * 8) {                          // Если наша новая позиция + i больше ноля и меньше количества точек в строке нашего экрана, то
      byte v = pgm_read_byte(data + 1 + ch * len + 1 + i);                // в v - считываем следующий байт из нашей строки масива
      if (!dy) scr[col + i].byte_data = v;                                //
      else scr[col + i].byte_data |= dy > 0 ? v >> dy : v << -dy;         // если dy(0)
    }                                                                     //
}
// ---------------------------------------------------------------------- Печатаем значение v в столбец col
void setCol(int col, byte v) {                                            //
  if (dy < - 8 | dy > 8) return;                                          //
  col += dx;                                                              //
  if (col >= 0 && col < 32)                                               //
      if (!dy) scr[col].byte_data = v; else scr[col].byte_data |= dy > 0 ? v >> dy : v << -dy;
}                                                                         //

//----------------------------------------------------------
// ---------------------------------------------------------------------- обращаемся к функции 
float readDS18B20(){
 
    oneWire.reset();                                                      // сброс шины
    oneWire.write(0xCC);                                                  //обращение ко всем датчикам (если всего один DS18B20)
    //oneWire.select(sensorAddress);                                      // выбор конкретного адреса - если несколько DS18B20
    oneWire.write(0x44);                                                  // начать преобразование (без паразитного питания)
    //delay(500);
    oneWire.reset();                                                      // сброс шины
    oneWire.write(0xCC);                                                  //обращение ко всем датчикам (если всего один DS18B20)
    //oneWire.select(sensorAddress);                                      // выбор конкретного адреса - если несколько DS18B20
    oneWire.write(0xBE);                                                  // Read Scratchpad (чтение регистров)
    temp = (oneWire.read() | oneWire.read() << 8) / 16.0;                 //прочитаны 2 байта
                                                                          //
}                                                                         //

// ---------------------------------------------------------------------- ВЫВОД ТЕМПЕРАТУРЫ НА ДИСПЛЕЕ
void showTemp(){                                                          //
   temp=readDS18B20();                                        // читаем датчик DS18B20. Для DS18S20 не подходит!
   if(temp<0) showDigit(11, 0, dig5x8rn);                                 // Если температура отрицательная печатаем в начале "-"
   else showDigit(10, 0, dig5x8rn);                                       // Иначе печатаем "+"
    int t1=(int)temp/10;                                                  // число десятков
    int t0=(int)temp%10;                                                  // число едениц
    int tf=(temp-int(temp))*10.0;                                         // число десятых
    if(t1) showDigit(t1, 4, dig4x8);                                    // если десяки = "0" то не печатаем
    showDigit(t0, 9, dig4x8);                                          // печатаем еденицы
    showDigit(tf, 16, dig4x8);                                          // печатаем десятые
  setCol(14, 0xC0);                                                       // выводим запятую между целыми и десятыми градусов
  showDigit(7, 22, dweek_ru);                                               // Выводим значек градусов и "С"
 
  refreshAll();                                                                    // вывод на экран (смотрим вкладку "max7219.h")
}                                                                         //


