// MAX7219 commands:    команды (в виде целых беззнаковых чисел 0-15) которые понимает микросхема MAX7219
#define CMD_NOOP   0                                     // 0xX0 - No-Op 
#define CMD_DIGIT0 1                                     // 0xX1 Digit 0
#define CMD_DIGIT1 2                                     // 0xX2 Digit 1
#define CMD_DIGIT2 3                                     // 0xX3 Digit 2
#define CMD_DIGIT3 4                                     // 0xX4 Digit 3
#define CMD_DIGIT4 5                                     // 0xX5 Digit 4
#define CMD_DIGIT5 6                                     // 0xX6 Digit 5
#define CMD_DIGIT6 7                                     // 0xX7 Digit 6
#define CMD_DIGIT7 8                                     // 0xX8 Digit 7
#define CMD_DECODEMODE  9                                // 0xX9 Режим декодирования
#define CMD_INTENSITY   10                               // 0xXA команда установки яркости экрана (0-15) (min-max)
#define CMD_SCANLIMIT   11                               // 0xXB Выбор отображаемых знакомест. Битами D0…D2 выбираются отображаемые знакоместа. При 111 отображаются всу
#define CMD_SHUTDOWN    12                                        // 0xXC 1 - рабочир режим, 0 - сон
#define CMD_DISPLAYTEST 15                                        // 0xXF 1 - засвечиваем все диоды

int pozMax = 1;                                                   // при "0" первый модуль матрицы будет последним. при "1" перавый модуль матрицы будет первымю

//byte scr[NUM_MAX*8 + 8]; // +8 for scrolled char                // вероятно ходетли сделать байтовый масив scr размерностью (количество модулей*8 (32) + 8 байт для буфера сдвига
struct bitfield                                                   // структура переменной bitfield
{
    unsigned char bit0:1;
    unsigned char bit1:1;
    unsigned char bit2:1;
    unsigned char bit3:1;
    unsigned char bit4:1;
    unsigned char bit5:1;
    unsigned char bit6:1;
    unsigned char bit7:1;
};

union                                                             //???
{
    struct bitfield bit_data;                                     //???
    unsigned char byte_data;                                      //???
}
scr1[NUM_MAX * 8 + 8], scr[NUM_MAX * 8 + 8];                      //   scr1 - масив хранит повернутые данные для вывода на экран.
                                                                  //   scr - масив которй хранит данне столбцов матрицы (32) +8 запасных :-) - перед их ковертированием в scr1
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//-------------------------------------------------------ПОСЫЛКА КОМАНДЫ В ИНДИКАТОР в определенный сегмент (1-4)
void sendCmd(int addr, byte cmd, byte data)                       // в addr указывам номер сегмента (0-3), cmd- содержит адрес команды (9-12, 15), data - к примеру уровень яркости
{
  digitalWrite(CS_PIN, LOW);                                      // устанавливаем "0" на SPI шине выбора устройства (в нашем случае дисплей)
  for (int i = NUM_MAX - 1; i >= 0; i--) {                        // создаем цикл по количеству наших сегментов (0-3 для 4 сегментов индикатора)
    shiftOut(DIN_PIN, CLK_PIN, MSBFIRST, i == addr ? cmd : 0);    // если совпадает наш адрес сегмента то передаем сначала команду, а потом ее значение
    shiftOut(DIN_PIN, CLK_PIN, MSBFIRST, i == addr ? data : 0);   // если не совпадает то передаем "0"
  }
  digitalWrite(CS_PIN, HIGH);                                     // снимаем выбор нашего устройства с шины SPI
}
/*
 shiftOut()
Выводит байт информации на порт вход/выхода последовательно (побитно). Вывод может осуществляться как с первого (левого), так и с последнего (правого) бита.
Каждый бит последовательно подается на заданный порт, после чего подается сигнал на синхронизирующий порт вход/выход, информируя о доступности к считыванию бита. 

Синтаксис
shiftOut(dataPin, clockPin, bitOrder, value)

Параметры
dataPin: номер порта вход/выхода, на который выводятся биты (int)
clockPin: номер порта по которому производится синхронизация (int)
bitOrder: используемая последовательность вывода бит. MSBFIRST (Most Significant Bit First) — слева или LSBFIRST (Least Significant Bit First) — справа.
value: значение (байт) для вывода (byte)
 */
//--------------------------------------------------------ПОСЫЛКА КОМАНДЫ В ИНДИКАТОР - управления на все сегменты  по очереди
void sendCmdAll(byte cmd, byte data)                              // Команда и ее значение
{
  digitalWrite(CS_PIN, LOW);                                      // Говорим устройству (индикатор) что начинаем передачу данных на шине SPI 
  for (int i = NUM_MAX - 1; i >= 0; i--) {                        // создаем цикл по количеству наших модулей
    shiftOut(DIN_PIN, CLK_PIN, MSBFIRST, cmd);                    // побитно передаем команду и ее значение
    shiftOut(DIN_PIN, CLK_PIN, MSBFIRST, data);                   //
  }
  digitalWrite(CS_PIN, HIGH);                                     // Отключаем устройсто от шины SPI
}
//------------------------------------------------------------------------------------------------
//void refresh(int addr) {                                  // Получаем какой то адрес сегмента и в него выводим данные из масива scr
  //for (int i = 0; i < 8; i++)                             // создаем цикл от 0 до 7
   // sendCmd(addr, i + CMD_DIGIT0, scr[addr * 8 + i]);     // Посылаем данные в программу отправки управляющих команд по шине SPI
//}                                                         // адрес - я так подозреваю сегмента (0-3), команда (от 1-8), данные из ячейки масива scr(адрес (0-7 или 8-15 и тд) +1



////////////////////////////////////////////////////////////////////////////////
void rotate (void) //-------индикаторы вертикальные - разворачиваем в горизонталь при этом данные из ячеек scr переворачиваем и помещаем в ячейки scr1
////////////////////////////////////////////////////////////////////////////////
{
    unsigned char bufAddr = 0;                                    // 0,8,16,32 Устанавливаем адрес буфера равный 0, далее к нему будем прибавлять 8
    unsigned char counter = NUM_MAX;                              // в переменную цикла записываем количесто наши сегментов
    
      while(counter--)                                            // Цикл будет проходить от 3 до 0 (количество наших сегментов) 
    {                                                             // Если сделать побайтное копирование то можно будет информацию менять между сегментами
       
      if (!pozMax){
        scr1[0 + 24-bufAddr].bit_data.bit0 = scr[7 + bufAddr].bit_data.bit0;   // побитно копируем в ячейки(биты) масива scr1 - биты масива ячейк scr 
        scr1[1 + 24-bufAddr].bit_data.bit0 = scr[7 + bufAddr].bit_data.bit1;   // фактически в болке сегмета 8х8 мы делаем поворт на 90* по часовой стрелке
        scr1[2 + 24-bufAddr].bit_data.bit0 = scr[7 + bufAddr].bit_data.bit2;   // и так для всех 4-х сегментов
        scr1[3 + 24-bufAddr].bit_data.bit0 = scr[7 + bufAddr].bit_data.bit3;
        scr1[4 + 24-bufAddr].bit_data.bit0 = scr[7 + bufAddr].bit_data.bit4;
        scr1[5 + 24-bufAddr].bit_data.bit0 = scr[7 + bufAddr].bit_data.bit5;
        scr1[6 + 24-bufAddr].bit_data.bit0 = scr[7 + bufAddr].bit_data.bit6;
        scr1[7 + 24-bufAddr].bit_data.bit0 = scr[7 + bufAddr].bit_data.bit7;
        
        scr1[0 + 24-bufAddr].bit_data.bit1 = scr[6 + bufAddr].bit_data.bit0;
        scr1[1 + 24-bufAddr].bit_data.bit1 = scr[6 + bufAddr].bit_data.bit1;
        scr1[2 + 24-bufAddr].bit_data.bit1 = scr[6 + bufAddr].bit_data.bit2;
        scr1[3 + 24-bufAddr].bit_data.bit1 = scr[6 + bufAddr].bit_data.bit3;
        scr1[4 + 24-bufAddr].bit_data.bit1 = scr[6 + bufAddr].bit_data.bit4;
        scr1[5 + 24-bufAddr].bit_data.bit1 = scr[6 + bufAddr].bit_data.bit5;
        scr1[6 + 24-bufAddr].bit_data.bit1 = scr[6 + bufAddr].bit_data.bit6;
        scr1[7 + 24-bufAddr].bit_data.bit1 = scr[6 + bufAddr].bit_data.bit7;
        
        scr1[0 + 24-bufAddr].bit_data.bit2 = scr[5 + bufAddr].bit_data.bit0;
        scr1[1 + 24-bufAddr].bit_data.bit2 = scr[5 + bufAddr].bit_data.bit1;
        scr1[2 + 24-bufAddr].bit_data.bit2 = scr[5 + bufAddr].bit_data.bit2;
        scr1[3 + 24-bufAddr].bit_data.bit2 = scr[5 + bufAddr].bit_data.bit3;
        scr1[4 + 24-bufAddr].bit_data.bit2 = scr[5 + bufAddr].bit_data.bit4;
        scr1[5 + 24-bufAddr].bit_data.bit2 = scr[5 + bufAddr].bit_data.bit5;
        scr1[6 + 24-bufAddr].bit_data.bit2 = scr[5 + bufAddr].bit_data.bit6;
        scr1[7 + 24-bufAddr].bit_data.bit2 = scr[5 + bufAddr].bit_data.bit7;
        
        scr1[0 + 24-bufAddr].bit_data.bit3 = scr[4 + bufAddr].bit_data.bit0;
        scr1[1 + 24-bufAddr].bit_data.bit3 = scr[4 + bufAddr].bit_data.bit1;
        scr1[2 + 24-bufAddr].bit_data.bit3 = scr[4 + bufAddr].bit_data.bit2;
        scr1[3 + 24-bufAddr].bit_data.bit3 = scr[4 + bufAddr].bit_data.bit3;
        scr1[4 + 24-bufAddr].bit_data.bit3 = scr[4 + bufAddr].bit_data.bit4;
        scr1[5 + 24-bufAddr].bit_data.bit3 = scr[4 + bufAddr].bit_data.bit5;
        scr1[6 + 24-bufAddr].bit_data.bit3 = scr[4 + bufAddr].bit_data.bit6;
        scr1[7 + 24-bufAddr].bit_data.bit3 = scr[4 + bufAddr].bit_data.bit7;
        
        scr1[0 + 24-bufAddr].bit_data.bit4 = scr[3 + bufAddr].bit_data.bit0;
        scr1[1 + 24-bufAddr].bit_data.bit4 = scr[3 + bufAddr].bit_data.bit1;
        scr1[2 + 24-bufAddr].bit_data.bit4 = scr[3 + bufAddr].bit_data.bit2;
        scr1[3 + 24-bufAddr].bit_data.bit4 = scr[3 + bufAddr].bit_data.bit3;
        scr1[4 + 24-bufAddr].bit_data.bit4 = scr[3 + bufAddr].bit_data.bit4;
        scr1[5 + 24-bufAddr].bit_data.bit4 = scr[3 + bufAddr].bit_data.bit5;
        scr1[6 + 24-bufAddr].bit_data.bit4 = scr[3 + bufAddr].bit_data.bit6;
        scr1[7 + 24-bufAddr].bit_data.bit4 = scr[3 + bufAddr].bit_data.bit7;
        
        scr1[0 + 24-bufAddr].bit_data.bit5 = scr[2 + bufAddr].bit_data.bit0;
        scr1[1 + 24-bufAddr].bit_data.bit5 = scr[2 + bufAddr].bit_data.bit1;
        scr1[2 + 24-bufAddr].bit_data.bit5 = scr[2 + bufAddr].bit_data.bit2;
        scr1[3 + 24-bufAddr].bit_data.bit5 = scr[2 + bufAddr].bit_data.bit3;
        scr1[4 + 24-bufAddr].bit_data.bit5 = scr[2 + bufAddr].bit_data.bit4;
        scr1[5 + 24-bufAddr].bit_data.bit5 = scr[2 + bufAddr].bit_data.bit5;
        scr1[6 + 24-bufAddr].bit_data.bit5 = scr[2 + bufAddr].bit_data.bit6;
        scr1[7 + 24-bufAddr].bit_data.bit5 = scr[2 + bufAddr].bit_data.bit7;
        
        scr1[0 + 24-bufAddr].bit_data.bit6 = scr[1 + bufAddr].bit_data.bit0;
        scr1[1 + 24-bufAddr].bit_data.bit6 = scr[1 + bufAddr].bit_data.bit1;
        scr1[2 + 24-bufAddr].bit_data.bit6 = scr[1 + bufAddr].bit_data.bit2;
        scr1[3 + 24-bufAddr].bit_data.bit6 = scr[1 + bufAddr].bit_data.bit3;
        scr1[4 + 24-bufAddr].bit_data.bit6 = scr[1 + bufAddr].bit_data.bit4;
        scr1[5 + 24-bufAddr].bit_data.bit6 = scr[1 + bufAddr].bit_data.bit5;
        scr1[6 + 24-bufAddr].bit_data.bit6 = scr[1 + bufAddr].bit_data.bit6;
        scr1[7 + 24-bufAddr].bit_data.bit6 = scr[1 + bufAddr].bit_data.bit7;
        
        scr1[0 + 24-bufAddr].bit_data.bit7 = scr[0 + bufAddr].bit_data.bit0;
        scr1[1 + 24-bufAddr].bit_data.bit7 = scr[0 + bufAddr].bit_data.bit1;
        scr1[2 + 24-bufAddr].bit_data.bit7 = scr[0 + bufAddr].bit_data.bit2;
        scr1[3 + 24-bufAddr].bit_data.bit7 = scr[0 + bufAddr].bit_data.bit3;
        scr1[4 + 24-bufAddr].bit_data.bit7 = scr[0 + bufAddr].bit_data.bit4;
        scr1[5 + 24-bufAddr].bit_data.bit7 = scr[0 + bufAddr].bit_data.bit5;
        scr1[6 + 24-bufAddr].bit_data.bit7 = scr[0 + bufAddr].bit_data.bit6;
        scr1[7 + 24-bufAddr].bit_data.bit7 = scr[0 + bufAddr].bit_data.bit7;
      }
      else {
        scr1[7 + bufAddr].bit_data.bit7 = scr[7 + bufAddr].bit_data.bit0;   // побитно копируем в ячейки(биты) масива scr1 - биты масива ячейк scr 
        scr1[6 + bufAddr].bit_data.bit7 = scr[7 + bufAddr].bit_data.bit1;   // фактически в болке сегмета 8х8 мы делаем поворт на 90* по часовой стрелке
        scr1[5 + bufAddr].bit_data.bit7 = scr[7 + bufAddr].bit_data.bit2;   // и так для всех 4-х сегментов
        scr1[4 + bufAddr].bit_data.bit7 = scr[7 + bufAddr].bit_data.bit3;
        scr1[3 + bufAddr].bit_data.bit7 = scr[7 + bufAddr].bit_data.bit4;
        scr1[2 + bufAddr].bit_data.bit7 = scr[7 + bufAddr].bit_data.bit5;
        scr1[1 + bufAddr].bit_data.bit7 = scr[7 + bufAddr].bit_data.bit6;
        scr1[0 + bufAddr].bit_data.bit7 = scr[7 + bufAddr].bit_data.bit7;
        
        scr1[7 + bufAddr].bit_data.bit6 = scr[6 + bufAddr].bit_data.bit0;
        scr1[6 + bufAddr].bit_data.bit6 = scr[6 + bufAddr].bit_data.bit1;
        scr1[5 + bufAddr].bit_data.bit6 = scr[6 + bufAddr].bit_data.bit2;
        scr1[4 + bufAddr].bit_data.bit6 = scr[6 + bufAddr].bit_data.bit3;
        scr1[3 + bufAddr].bit_data.bit6 = scr[6 + bufAddr].bit_data.bit4;
        scr1[2 + bufAddr].bit_data.bit6 = scr[6 + bufAddr].bit_data.bit5;
        scr1[1 + bufAddr].bit_data.bit6 = scr[6 + bufAddr].bit_data.bit6;
        scr1[0 + bufAddr].bit_data.bit6 = scr[6 + bufAddr].bit_data.bit7;
        
        scr1[7 + bufAddr].bit_data.bit5 = scr[5 + bufAddr].bit_data.bit0;
        scr1[6 + bufAddr].bit_data.bit5 = scr[5 + bufAddr].bit_data.bit1;
        scr1[5 + bufAddr].bit_data.bit5 = scr[5 + bufAddr].bit_data.bit2;
        scr1[4 + bufAddr].bit_data.bit5 = scr[5 + bufAddr].bit_data.bit3;
        scr1[3 + bufAddr].bit_data.bit5 = scr[5 + bufAddr].bit_data.bit4;
        scr1[2 + bufAddr].bit_data.bit5 = scr[5 + bufAddr].bit_data.bit5;
        scr1[1 + bufAddr].bit_data.bit5 = scr[5 + bufAddr].bit_data.bit6;
        scr1[0 + bufAddr].bit_data.bit5 = scr[5 + bufAddr].bit_data.bit7;
        
        scr1[7 + bufAddr].bit_data.bit4 = scr[4 + bufAddr].bit_data.bit0;
        scr1[6 + bufAddr].bit_data.bit4 = scr[4 + bufAddr].bit_data.bit1;
        scr1[5 + bufAddr].bit_data.bit4 = scr[4 + bufAddr].bit_data.bit2;
        scr1[4 + bufAddr].bit_data.bit4 = scr[4 + bufAddr].bit_data.bit3;
        scr1[3 + bufAddr].bit_data.bit4 = scr[4 + bufAddr].bit_data.bit4;
        scr1[2 + bufAddr].bit_data.bit4 = scr[4 + bufAddr].bit_data.bit5;
        scr1[1 + bufAddr].bit_data.bit4 = scr[4 + bufAddr].bit_data.bit6;
        scr1[0 + bufAddr].bit_data.bit4 = scr[4 + bufAddr].bit_data.bit7;
        
        scr1[7 + bufAddr].bit_data.bit3 = scr[3 + bufAddr].bit_data.bit0;
        scr1[6 + bufAddr].bit_data.bit3 = scr[3 + bufAddr].bit_data.bit1;
        scr1[5 + bufAddr].bit_data.bit3 = scr[3 + bufAddr].bit_data.bit2;
        scr1[4 + bufAddr].bit_data.bit3 = scr[3 + bufAddr].bit_data.bit3;
        scr1[3 + bufAddr].bit_data.bit3 = scr[3 + bufAddr].bit_data.bit4;
        scr1[2 + bufAddr].bit_data.bit3 = scr[3 + bufAddr].bit_data.bit5;
        scr1[1 + bufAddr].bit_data.bit3 = scr[3 + bufAddr].bit_data.bit6;
        scr1[0 + bufAddr].bit_data.bit3 = scr[3 + bufAddr].bit_data.bit7;
        
        scr1[7 + bufAddr].bit_data.bit2 = scr[2 + bufAddr].bit_data.bit0;
        scr1[6 + bufAddr].bit_data.bit2 = scr[2 + bufAddr].bit_data.bit1;
        scr1[5 + bufAddr].bit_data.bit2 = scr[2 + bufAddr].bit_data.bit2;
        scr1[4 + bufAddr].bit_data.bit2 = scr[2 + bufAddr].bit_data.bit3;
        scr1[3 + bufAddr].bit_data.bit2 = scr[2 + bufAddr].bit_data.bit4;
        scr1[2 + bufAddr].bit_data.bit2 = scr[2 + bufAddr].bit_data.bit5;
        scr1[1 + bufAddr].bit_data.bit2 = scr[2 + bufAddr].bit_data.bit6;
        scr1[0 + bufAddr].bit_data.bit2 = scr[2 + bufAddr].bit_data.bit7;
        
        scr1[7 + bufAddr].bit_data.bit1 = scr[1 + bufAddr].bit_data.bit0;
        scr1[6 + bufAddr].bit_data.bit1 = scr[1 + bufAddr].bit_data.bit1;
        scr1[5 + bufAddr].bit_data.bit1 = scr[1 + bufAddr].bit_data.bit2;
        scr1[4 + bufAddr].bit_data.bit1 = scr[1 + bufAddr].bit_data.bit3;
        scr1[3 + bufAddr].bit_data.bit1 = scr[1 + bufAddr].bit_data.bit4;
        scr1[2 + bufAddr].bit_data.bit1 = scr[1 + bufAddr].bit_data.bit5;
        scr1[1 + bufAddr].bit_data.bit1 = scr[1 + bufAddr].bit_data.bit6;
        scr1[0 + bufAddr].bit_data.bit1 = scr[1 + bufAddr].bit_data.bit7;
        
        scr1[7 + bufAddr].bit_data.bit0 = scr[0 + bufAddr].bit_data.bit0;
        scr1[6 + bufAddr].bit_data.bit0 = scr[0 + bufAddr].bit_data.bit1;
        scr1[5 + bufAddr].bit_data.bit0 = scr[0 + bufAddr].bit_data.bit2;
        scr1[4 + bufAddr].bit_data.bit0 = scr[0 + bufAddr].bit_data.bit3;
        scr1[3 + bufAddr].bit_data.bit0 = scr[0 + bufAddr].bit_data.bit4;
        scr1[2 + bufAddr].bit_data.bit0 = scr[0 + bufAddr].bit_data.bit5;
        scr1[1 + bufAddr].bit_data.bit0 = scr[0 + bufAddr].bit_data.bit6;
        scr1[0 + bufAddr].bit_data.bit0 = scr[0 + bufAddr].bit_data.bit7;
      }  

        bufAddr += 8; // к начальном адресу буфера (0- для первого сегмента) прибавляем 8 (для работы с битами следующего сегмента)
    
    }

    //copy
    //for(counter = 0; counter < NUM_MAX * 8; counter++)        // создаем цикл от 0 до 31, Если изменить ячейки приема, то можно будет отобразить значение с право на лево 
    //{
    //    scr[counter].byte_data = scr1[counter].byte_data;     // в ячейку масива scr - копируем (1 байт или 8 бит) значение ячейки масива scr1
    //}   
    
}

//------------------------------------------------ВЫВОД НА ИНДИКАТОР ДАННЫХ (из scr1 - Обновляем все сегменты индикатора)
void refreshAll() {                                                       //
  rotate();                                                               // поворачиваем данные из буфера sct и записываем их в буфер scr1 (ВЕРТИКАЛЬНЫЕ БАЙТЫ)
  for (int c = 0; c < 8; c++) {                                           // создаем цикл от 0 до 7
    digitalWrite(CS_PIN, LOW);                                            // Разрешаем нашему индикатору получать данные с шины SPI
    for(int i = NUM_MAX - 1; i>=0; i--) {                                 // создаем цикл от 3 до 0 Цикл по количеству индикаторов
      shiftOut(DIN_PIN, CLK_PIN, MSBFIRST, CMD_DIGIT0 + c);               // трансилруем команду (1+0)4раза,(1+1)4раза,(1+2)4раза,(1+3)4раза,(1+4)4раза,(1+5)4раза,(1+6)4раза,(1+7)4раза 
      shiftOut(DIN_PIN, CLK_PIN, MSBFIRST, scr1[i * 8 + c].byte_data);    // трансилруем данные (байт) из ячейки scr1 (3*8+0, 2*8+0, 1*8+0, 0*8+0)  24, 16,  8,  0
                                                                          //                 строки/столбцы            3*8+1, 2*8+1, 1*8+1, 0*8+1   25, 17,  9,  1
                                                                          //                                            .  .  .  .  .  .  .  .  . 
                                                                          //                                           3*8+7, 2*8+7, 1*8+7, 0*8+7   31, 23, 15,  7
    }
    digitalWrite(CS_PIN, HIGH);                                           //
  }
}
//--------------------------------------------------------------------------------Програма очистки экрана
void clrAll()
{
  for (int i = 0; i < NUM_MAX * 8; i++) scr[i].byte_data = 0;                     // Созадаем цикл 0-31 и записываем в scr(0-31) байты с "0"
}
//--------------------------------------------------------------------------------Програма очистки экрана
void clr(int ys, int ye)
{
  for (int i = 0; i < NUM_MAX * 8; i++){                                           // Созадаем цикл 0-31 и записываем в scr(0-31) байты с "0"
    if (ys <= i && ys+ye-1 >= i) scr[i].byte_data = 0;                             //  есил значение цикла совпадает с номером строки, то стираем
  }
}
//--------------------------------------------------------------------------------Програма сдвиг влево данных из масива scr на один байт 
void scrollLeft()
{
  for(int i = 0; i < NUM_MAX * 8 + 7; i++) scr[i].byte_data = scr[i+1].byte_data;   // создаем цикл 0-38 и свигаем байты на один влево 0<-1, 1<-2....38<-39
}
//--------------------------------------------------------------------------------Программа инверсии данных строк в массиве scr
void invert(int ys, int ye)    // 5 - начало, 4 - длина
{
  for (int i = 0; i < NUM_MAX * 8; i++){                                            // создаем цикл 0-31  по количеству столбцов экрана
    if (ys <= i && ys+ye-1 >= i) scr[i].byte_data = ~scr[i].byte_data;              // есил значение цикла совпадает с номером строки, то инвертируем данные
  }
}
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
void initMAX7219()                                                                  // инициализация модуля MAX7219
{
  pinMode(DIN_PIN, OUTPUT);                                                         // пин данных работает как выход
  pinMode(CLK_PIN, OUTPUT);                                                         // пин тактовый работает как выход
  pinMode(CS_PIN, OUTPUT);                                                          // пин выбора устройства работает как выход
  digitalWrite(CS_PIN, HIGH);                                                       // записываем в пин выбора устройства "1" - устройство отключено от шины SPI
  sendCmdAll(CMD_DISPLAYTEST, 0);                                                   // посылаем команду выключить режим теста
  sendCmdAll(CMD_SCANLIMIT, 7);                                                     // посылаем команду отображать все сотлбцы в матрице (8х8)
  sendCmdAll(CMD_DECODEMODE, 0);                                                    // не использовать декодирование данных (используется в 7-ми сегментных индикаторах)
  sendCmdAll(CMD_INTENSITY, 1);                                                     // устанавливаем яркость свечения матриц в 1 (0-15)
  sendCmdAll(CMD_SHUTDOWN, 0);                                                      // выключаем режим сна
  clrAll();                                                                         // записываем в масив scr() все ноли
  refreshAll();                                                                     // преобразовываем масив csr() в scr1() и передаем его на индикатор
}
