const uint8_t dig3x7q[] PROGMEM = { 4,      // Узкий цифровой 
0x03,0x00,0x02,0x00,//0
0x03,0x00,0x02,0x04,
0x03,0x00,0x02,0x0C,
0x03,0x00,0x02,0x1C,
0x03,0x00,0x02,0x3C,
0x03,0x00,0x02,0x7C,
0x03,0x00,0x82,0x7C,
0x03,0x40,0x82,0x7C,
0x03,0x60,0x82,0x7C,
0x03,0x70,0x82,0x7C,
0x03,0x78,0x82,0x7C,
0x03,0x7C,0x82,0x7C,
//------------
0x00,0x00,0x00,0x00,//1
0x00,0x00,0x00,0x00,
0x03,0x04,0x00,0x00,
0x03,0x04,0x02,0x00,
0x03,0x04,0x06,0x00,
0x03,0x04,0x0E,0x00,
0x03,0x04,0x1E,0x00,
0x03,0x04,0x3E,0x00,
0x03,0x04,0x7E,0x00,
0x03,0x84,0x7E,0x00,
0x03,0x84,0xFE,0x00,
0x03,0x84,0xFE,0x80,                              
//-------------
0x00,0x00,0x00,0x00,//2
0x00,0x00,0x00,0x00,
0x03,0x04,0x00,0x00,
0x03,0x04,0x02,0x00,
0x03,0x04,0x02,0x04,
0x03,0x04,0x02,0x0C,
0x03,0x04,0x02,0x1C,
0x03,0x04,0x22,0x1C,
0x03,0x44,0x22,0x1C,
0x03,0xC4,0x22,0x1C,
0x03,0xC4,0xA2,0x1C,
0x03,0xC4,0xA2,0x9C,
//-------------
0x00,0x00,0x00,0x00,//3
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x03,0x02,0x00,0x00,
0x03,0x02,0x02,0x00,
0x03,0x02,0x02,0x04,
0x03,0x02,0x02,0x0C,
0x03,0x02,0x12,0x0C,
0x03,0x02,0x12,0x2C,
0x03,0x02,0x12,0x6C,
0x03,0x02,0x92,0x6C,
0x03,0x82,0x92,0x6C,
//------------
0x03,0x02,0x00,0x00,//4
0x03,0x06,0x00,0x00,
0x03,0x0E,0x00,0x00,
0x03,0x1E,0x00,0x00,
0x03,0x3E,0x00,0x00,
0x03,0x3E,0x20,0x00,
0x03,0x3E,0x20,0x04,
0x03,0x3E,0x20,0x0C,
0x03,0x3E,0x20,0x1C,
0x03,0x3E,0x20,0x3C,
0x03,0x3E,0x20,0x7C,
0x03,0x3E,0x20,0xFC,
//-------------
0x00,0x00,0x00,0x00,//5
0x03,0x00,0x00,0x02,
0x03,0x00,0x02,0x02,
0x03,0x02,0x02,0x02,
0x03,0x06,0x02,0x02,
0x03,0x0E,0x02,0x02,
0x03,0x0E,0x0A,0x02,
0x03,0x0E,0x0A,0x12,
0x03,0x0E,0x0A,0x32,
0x03,0x0E,0x0A,0x72,
0x03,0x0E,0x8A,0x72,
0x03,0x8E,0x8A,0x72,
//-------------
0x03,0x02,0x00,0x00,//6
0x03,0x06,0x00,0x00,
0x03,0x00,0x02,0x00,
0x03,0x04,0x02,0x00,
0x03,0x0C,0x02,0x00,
0x03,0x1C,0x02,0x00,
0x03,0x3C,0x02,0x00,
0x03,0x7C,0x02,0x00,
0x03,0x7C,0x82,0x00,
0x03,0x7C,0x82,0x40,
0x03,0x7C,0x82,0x60,
0x03,0x7C,0x92,0x60,
//------------
0x00,0x00,0x00,0x00,//7
0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,
0x03,0x02,0x00,0x00,
0x03,0x02,0x02,0x00,
0x03,0x02,0x02,0x02,
0x03,0x02,0x02,0x06,
0x03,0x02,0x02,0x0E,
0x03,0x02,0x02,0x1E,
0x03,0x02,0x22,0x1E,
0x03,0x02,0x62,0x1E,
0x03,0x02,0xE2,0x1E,
//------------
0x00,0x00,0x00,0x00,//8
0x03,0x00,0x02,0x00,
0x03,0x04,0x02,0x00,
0x03,0x0C,0x02,0x00,
0x03,0x0C,0x02,0x04,
0x03,0x0C,0x02,0x0C,
0x03,0x0C,0x12,0x0C,
0x03,0x2C,0x12,0x0C,
0x03,0x6C,0x12,0x0C,
0x03,0x6C,0x92,0x0C,
0x03,0x6C,0x92,0x4C,
0x03,0x6C,0x92,0x6C,
//------------
0x00,0x00,0x00,0x00,//9
0x00,0x00,0x00,0x00,
0x03,0x00,0x10,0x00,
0x03,0x08,0x10,0x00,
0x03,0x0C,0x10,0x00,
0x03,0x0C,0x12,0x00,
0x03,0x0C,0x12,0x04,
0x03,0x0C,0x12,0x0C,
0x03,0x0C,0x12,0x1C,
0x03,0x0C,0x12,0x3C,
0x03,0x0C,0x12,0x7C,
0x03,0x0C,0x92,0x7C,
};

const uint8_t dig4x8q[] PROGMEM = { 5, // Крупные цифры (4 столбца) в полный рост - цифровые

//-----------------------// 0
0x04,0x00,0x01,0x01,0x0E,
0x04,0x00,0x01,0x01,0x1E,
0x04,0x00,0x01,0x01,0x3E,
0x04,0x00,0x01,0x01,0x7E,
0x04,0x00,0x01,0x81,0x7E,
0x04,0x00,0x81,0x81,0x7E,
0x04,0x40,0x81,0x81,0x7E,
0x04,0x60,0x81,0x81,0x7E,
0x04,0x70,0x81,0x81,0x7E,
0x04,0x78,0x81,0x81,0x7E,
0x04,0x7C,0x81,0x81,0x7E,
0x04,0x7E,0x81,0x81,0x7E,
//--------------------------  // 1                            
0x00,0x00,0x00,0x00,0x00,
0x01,0x02,0x00,0x00,0x00,
0x02,0x02,0x01,0x00,0x00,
0x02,0x02,0x03,0x00,0x00,
0x02,0x02,0x07,0x00,0x00,
0x02,0x02,0x0F,0x00,0x00,
0x02,0x02,0x1F,0x00,0x00,
0x02,0x02,0x3F,0x00,0x00,
0x02,0x02,0x7F,0x00,0x00,
0x02,0x82,0x7F,0x00,0x00,
0x02,0x82,0xFF,0x00,0x00,
0x03,0x82,0xFF,0x80,0x00,                           
//-------------------------- // 2
0x02,0x06,0x01,0x00,0x00,
0x03,0x06,0x01,0x01,0x00,
0x04,0x06,0x01,0x01,0x02,
0x04,0x06,0x01,0x01,0x06,
0x04,0x06,0x01,0x01,0x0E,
0x04,0x06,0x01,0x11,0x0E,
0x04,0x06,0x21,0x11,0x0E,
0x04,0x46,0x21,0x11,0x0E,
0x04,0xC6,0x21,0x11,0x0E,
0x04,0xC6,0xA1,0x11,0x0E,
0x04,0xC6,0xA1,0x91,0x0E,
0x04,0xC6,0xA1,0x91,0x8E,                          
//-------------------------- // 3
0x04,0x02,0x00,0x00,0x00,
0x04,0x02,0x01,0x00,0x00,
0x04,0x02,0x01,0x01,0x00,
0x04,0x02,0x01,0x01,0x02,
0x04,0x02,0x01,0x01,0x06,
0x04,0x02,0x01,0x09,0x06,
0x04,0x02,0x01,0x09,0x16,
0x04,0x02,0x01,0x09,0x36,
0x04,0x02,0x01,0x09,0x76,
0x04,0x02,0x01,0x89,0x76,
0x04,0x02,0x81,0x89,0x76,
0x04,0x42,0x81,0x89,0x76,                          
//-------------------------- // 4
0x04,0x07,0x00,0x00,0x00,
0x04,0x0F,0x00,0x00,0x00,
0x04,0x1F,0x00,0x00,0x00,
0x04,0x3F,0x00,0x00,0x00,
0x04,0x3F,0x20,0x00,0x00,
0x04,0x3F,0x20,0x20,0x00,
0x04,0x3F,0x20,0x20,0x20,
0x04,0x3F,0x20,0x24,0x20,
0x04,0x3F,0x20,0x2C,0x20,
0x04,0x3F,0x20,0x3C,0x20,
0x04,0x3F,0x20,0x7C,0x20,
0x04,0x3F,0x20,0xFC,0x20,                           
//-------------------------- // 5
0x04,0x40,0x80,0x80,0x40,
0x04,0x40,0x80,0x80,0x60,
0x04,0x40,0x80,0x80,0x70,
0x04,0x40,0x80,0x80,0x78,
0x04,0x40,0x80,0x84,0x78,
0x04,0x40,0x84,0x84,0x78,
0x04,0x44,0x84,0x84,0x78,
0x04,0x46,0x84,0x84,0x78,
0x04,0x47,0x84,0x84,0x78,
0x04,0x47,0x85,0x84,0x78,
0x04,0x47,0x85,0x85,0x78,
0x04,0x47,0x85,0x85,0x79,                           
//-------------------------- // 6
0x04,0x06,0x01,0x01,0x00,
0x04,0x0E,0x01,0x01,0x00,
0x04,0x1E,0x01,0x01,0x00,
0x04,0x3E,0x01,0x01,0x00,
0x04,0x7E,0x01,0x01,0x00,
0x04,0x7E,0x81,0x01,0x00,
0x04,0x7E,0x81,0x81,0x00,
0x04,0x7E,0x81,0x81,0x40,
0x04,0x7E,0x81,0x81,0x60,
0x04,0x7E,0x81,0x81,0x70,
0x04,0x7E,0x81,0x89,0x70,
0x04,0x7E,0x89,0x89,0x70,                          
//-------------------------- // 7
0x00,0x00,0x00,0x00,0x00,
0x01,0x01,0x00,0x00,0x00,
0x04,0x01,0x01,0x00,0x00,
0x04,0x01,0x01,0x01,0x00,
0x04,0x01,0x01,0x01,0x01,
0x04,0x01,0x01,0x01,0x03,
0x04,0x01,0x01,0x01,0x07,
0x04,0x01,0x01,0x09,0x07,
0x04,0x01,0x11,0x09,0x07,
0x04,0x01,0x31,0x09,0x07,
0x04,0x01,0x71,0x09,0x07,
0x04,0x01,0xF1,0x09,0x07,                         
//------------------------ // 8
0x04,0x06,0x01,0x01,0x02,
0x04,0x06,0x01,0x01,0x06,
0x04,0x06,0x01,0x09,0x06,
0x04,0x06,0x09,0x09,0x06,
0x04,0x16,0x09,0x09,0x06,
0x04,0x36,0x09,0x09,0x06,
0x04,0x76,0x09,0x09,0x06,
0x04,0x76,0x89,0x09,0x06,
0x04,0x76,0x89,0x89,0x06,
0x04,0x76,0x89,0x89,0x46,
0x04,0x76,0x89,0x89,0x66,
0x04,0x76,0x89,0x89,0x76, 
//------------------------ // 9
0x04,0x0C,0x10,0x10,0x00,
0x04,0x0E,0x10,0x10,0x00,
0x04,0x0E,0x11,0x10,0x00,
0x04,0x0E,0x11,0x11,0x00,
0x04,0x0E,0x11,0x11,0x02,
0x04,0x0E,0x11,0x11,0x06,
0x04,0x0E,0x11,0x11,0x0E,
0x04,0x0E,0x11,0x11,0x1E,
0x04,0x0E,0x11,0x11,0x3E,                           
0x04,0x0E,0x11,0x11,0x7E,
0x04,0x0E,0x11,0x91,0x7E,
0x04,0x0E,0x91,0x91,0x7E,                           
};


const uint8_t dig3x5[] PROGMEM = { 4,                   // Узкий цифровой (3 столбца) 5 строк
0x03, 0xF8, 0x88, 0xF8,                                 // 0
0x02, 0x10, 0xF8, 0x00,                                 // 1
0x03, 0xE8, 0xA8, 0xB8,                                 // 2
0x03, 0x88, 0xA8, 0xF8,                                 // 3
0x03, 0x38, 0x20, 0xF8,                                 // 4
0x03, 0xB8, 0xA8, 0xE8,                                 // 5
0x03, 0xF8, 0xA8, 0xE8,                                 // 6
0x03, 0x08, 0x08, 0xF8,                                 // 7
0x03, 0xF8, 0xA8, 0xF8,                                 // 8
0x03, 0xB8, 0xA8, 0xF8,                                 // 9
};

const uint8_t dig3x6[] PROGMEM = { 4,                   // Узкий цифровой (3 столбца) 6 строк
0x03, 0xFC, 0x84, 0xFC,                                 // 0
0x03, 0x10, 0x08, 0xFC,                                 // 1 
0x03, 0xF4, 0x94, 0x9C,                                 // 2
0x03, 0x84, 0x94, 0xFC,                                 // 3
0x03, 0x3C, 0x20, 0xF8,                                 // 4
0x03, 0x9C, 0x94, 0xF4,                                 // 5
0x03, 0xFC, 0x94, 0xF4,                                 // 6
0x03, 0x04, 0xE4, 0x1C,                                 // 7
0x03, 0xFC, 0x94, 0xFC,                                 // 8
0x03, 0xBC, 0xA4, 0xFC,                                 // 9
};

const uint8_t dig3x6alarm[] PROGMEM = { 4,              // Узкий цифровой (3 столбца) 6 строк по средине для будильника
0x03, 0x7E, 0x42, 0x7E,                                 // 0
0x03, 0x08, 0x04, 0x7E,                                 // 1 
0x03, 0x7A, 0x4A, 0x4E,                                 // 2
0x03, 0x42, 0x4A, 0x7E,                                 // 3
0x03, 0x1E, 0x10, 0x7C,                                 // 4
0x03, 0x4E, 0x4A, 0x7A,                                 // 5
0x03, 0x7E, 0x4A, 0x7A,                                 // 6
0x03, 0x02, 0x72, 0x0E,                                 // 7
0x03, 0x7E, 0x4A, 0x7E,                                 // 8
0x03, 0x4E, 0x4A, 0x7E,                                 // 9
0x02, 0x10, 0x10, 0x00,                                 // -
0x03, 0x78, 0x14, 0x78,                                 // А
0x03, 0x7C, 0x54, 0x24,                                 // Б
0x03, 0x7C, 0x54, 0x28,                                 // В
0x03, 0x58, 0x24, 0x58,                                 // Д
0x03, 0x7C, 0x54, 0x44,                                 // Е
0x03, 0x7C, 0x10, 0x6C,                                 // К
0x03, 0x7C, 0x10, 0x7C,                                 // Н
0x03, 0x38, 0x44, 0x38,                                 // О
0x03, 0x7C, 0x04, 0x7C,                                 // П
0x03, 0x7C, 0x14, 0x08,                                 // Р
0x03, 0x38, 0x44, 0x44,                                 // С
0x03, 0x04, 0x7C, 0x04,                                 // Т
0x03, 0x4C, 0x50, 0x3C,                                 // У
0x03, 0x0C, 0x10, 0x7C,                                 // Ч
0x03, 0x68, 0x14, 0x7C,                                 // Я
0x03, 0x78, 0x04, 0x7C,                                 // Л
0x03, 0x44, 0x54, 0x28,                                 // З
};

const uint8_t dig3x7[] PROGMEM = { 4,                   // Узкий цифровой (3 столбца) 7 строк
0x03, 0xFE, 0x82, 0xFE,                                 // 0
0x03, 0x08, 0x04, 0xFE,                                 // 1 
0x03, 0xF2, 0x92, 0x9E,                                 // 2
0x03, 0x82, 0x92, 0xFE,                                 // 3
0x03, 0x3E, 0x20, 0xFC,                                 // 4
0x03, 0x9E, 0x92, 0xF2,                                 // 5
0x03, 0xFE, 0x92, 0xF2,                                 // 6
0x03, 0x02, 0xE2, 0x1E,                                 // 7
0x03, 0xFE, 0x92, 0xFE,                                 // 8
0x03, 0x9E, 0x92, 0xFE,                                 // 9
};
const uint8_t dig3x7s[] PROGMEM = { 4,      // Узкий цифровой (3 столбца) 7 строк
0x03, 0x7C,0x82,0x7C,                                 // 0
0x03, 0x84,0xFE,0x80,                                 // 1 
0x03, 0xC4,0xA2,0x9C,                                 // 2
0x03, 0x82,0x92,0x6C,                                 // 3
0x03, 0x3E, 0x20, 0xFC,                                 // 4
0x03, 0x8E,0x8A,0x72,                                 // 5
0x03, 0x7C,0x92,0x60,                                // 6
0x03, 0x02, 0xE2, 0x1E,                                 // 7
0x03, 0x6C,0x92,0x6C,                                 // 8
0x03, 0x0C,0x92,0x7C,                                // 9
};
const uint8_t dig3x8[] PROGMEM = { 4,                   // Узкий цифровой (3 столбца) 8 строк электронные в полный рост))
0x03, 0xFF, 0x81, 0xFF,                                 // 0
0x02, 0x02, 0xFF, 0x00,                                 // 1
0x03, 0xF9, 0x89, 0x8F,                                 // 2
0x03, 0x81, 0x89, 0xFF,                                 // 3
0x03, 0x1F, 0x10, 0xFC,                                 // 4
0x03, 0x8F, 0x89, 0xF9,                                 // 5
0x03, 0xFF, 0x89, 0xF9,                                 // 6
0x03, 0x01, 0xF1, 0x0F,                                 // 7
0x03, 0xFF, 0x89, 0xFF,                                 // 8
0x03, 0x9F, 0x91, 0xFF,                                 // 9
};

const uint8_t dig4x8[] PROGMEM = { 5, // Крупные цифры (4 столбца) в полный рост - цифровые
0x04, 0x7E,0x81,0x81,0x7E,                           // 0
0x04, 0x82,0xFF,0x80,0x00,                           // 1
0x04, 0xC6,0xA1,0x91,0x8E,                           // 2
0x04, 0x42,0x81,0x89,0x76,                           // 3
0x04, 0x3F,0x20,0xFC,0x20,                           // 4
0x04, 0x47,0x85,0x85,0x79,                           // 5
0x04, 0x7E,0x89,0x89,0x70,                           // 6
0x04, 0x01,0xF1,0x09,0x07,                           // 7
0x04, 0x76,0x89,0x89,0x76,                           // 8
0x04, 0x0E,0x91,0x91,0x7E,                           // 9
0x04, 0x00,0x00,0x00,0x00,                           // 10 пробел  
};

const uint8_t dig5x8rn[] PROGMEM = { 6,                 // Шрифт широкий (5 столбцов) высокий - закругленный
0x05, 0x7E, 0x81, 0x81, 0xFF, 0x7E,                     // 0
0x05, 0x04, 0x02, 0xFF, 0xFF, 0x00,                     // 1
0x05, 0xF1, 0x89, 0x89, 0x8F, 0x86,                     // 2
0x05, 0x81, 0x89, 0x89, 0xFF, 0x76,                     // 3
0x05, 0x1F, 0x10, 0x10, 0xFE, 0xFE,                     // 4
0x05, 0x8F, 0x89, 0x89, 0xF9, 0x71,                     // 5
0x05, 0x7E, 0x89, 0x89, 0xF9, 0x70,                     // 6
0x05, 0x01, 0xC1, 0xF1, 0x3F, 0x0F,                     // 7
0x05, 0x76, 0x89, 0x89, 0xFF, 0x76,                     // 8
0x05, 0x0E, 0x91, 0x91, 0xFF, 0x7E,                     // 9
0x03, 0x10, 0x38, 0x10, 0x00, 0x00,                     // (10) +
0x03, 0x10, 0x10, 0x10, 0x00, 0x00,                     // (11) -
0x05, 0x20, 0x3C, 0x7E, 0x3C, 0x20,                     // (12) колокольчик 
0x05, 0x20, 0xBC, 0x7E, 0x3C, 0x20,                     // (13) колокольчик язычек на лево
0x05, 0x20, 0x3C, 0x7E, 0xBC, 0x20,                     // (14) колокольчик язычек на право
0x03, 0xF8, 0x28, 0x08, 0x00, 0x00,                     // (15) F
0x05, 0xE0, 0x20, 0x40, 0x20, 0xE0,                     // (16) м
0x04, 0x18, 0x18, 0x24, 0x7E, 0x00,                     // (17) значек динамика
0x03, 0x60, 0x78, 0x7E, 0x00, 0x00,                     // (18) значек звука после динамика
0x05, 0x72, 0x54, 0x5E, 0x54, 0x72,                     // (19) значек радио приемника
};

const uint8_t dig5x8sq[] PROGMEM = { 6,                 // Шрифт (5 строк) высокий цифровой
0x05, 0xFF, 0x81, 0x81, 0xFF, 0xFF,                     // 0
0x04, 0x04, 0x02, 0xFF, 0xFF, 0x00,                     // 1
0x05, 0xF9, 0x89, 0x89, 0x8F, 0x8F,                     // 2
0x05, 0x81, 0x89, 0x89, 0xFF, 0xFF,                     // 3
0x05, 0x1F, 0x10, 0x10, 0xFE, 0xFE,                     // 4
0x05, 0x8F, 0x89, 0x89, 0xF9, 0xF9,                     // 5
0x05, 0xFF, 0x89, 0x89, 0xF9, 0xF9,                     // 6
0x05, 0x01, 0x01, 0x01, 0xFF, 0xFF,                     // 7
0x05, 0xFF, 0x89, 0x89, 0xFF, 0xFF,                     // 8
0x05, 0x9F, 0x91, 0x91, 0xFF, 0xFF,                     // 9
0x05, 0x00, 0x00, 0x00, 0x00, 0x00,                // пробел
};

const uint8_t dig6x8[] PROGMEM = { 7,                   // Крупные цифры (6 столбцов) в полный рост - закругленные
0x06, 0x7E, 0xFF, 0x81, 0x81, 0xFF, 0x7E,               // 0
0x06, 0x00, 0x82, 0xFF, 0xFF, 0x80, 0x00,               // 1
0x06, 0xC2, 0xE3, 0xB1, 0x99, 0x8F, 0x86,               // 2
0x06, 0x42, 0xC3, 0x89, 0x89, 0xFF, 0x76,               // 3
0x06, 0x38, 0x3C, 0x26, 0x23, 0xFF, 0xFF,               // 4
0x06, 0x4F, 0xCF, 0x89, 0x89, 0xF9, 0x71,               // 5
0x06, 0x7E, 0xFF, 0x89, 0x89, 0xFB, 0x72,               // 6
0x06, 0x01, 0x01, 0xF1, 0xF9, 0x0F, 0x07,               // 7
0x06, 0x76, 0xFF, 0x89, 0x89, 0xFF, 0x76,               // 8
0x06, 0x4E, 0xDF, 0x91, 0x91, 0xFF, 0x7E,               // 9
0x06, 0x10, 0x10, 0x7C, 0x7C, 0x10, 0x10,               // +
0x05, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00,               // -
0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,               // пробел
}; 

const uint8_t dig6x8t[] PROGMEM = { 7,                   // Крупные цифры (6 столбцов) в полный рост - закругленные
0x06, 0x7E,0x81,0x81,0x81,0x81,0x7E,                // 0
0x06, 0x00,0x84,0x82,0xFF,0x80,0x80,               // 1
0x06, 0xE2,0x91,0x91,0x91,0x91,0x8E,               // 2
0x06, 0x42,0x81,0x89,0x89,0x89,0x76,             // 3
0x06, 0x38,0x24,0x22,0x21,0xFF,0x20,              // 4
0x06, 0x46,0x89,0x89,0x89,0x89,0x71,               // 5
0x06, 0x7E,0x89,0x89,0x89,0x89,0x72,              // 6
0x06, 0x03,0xC1,0x21,0x11,0x09,0x07,               // 7
0x06, 0x76,0x89,0x89,0x89,0x89,0x76,               // 8
0x06, 0x4E,0x91,0x91,0x91,0x91,0x7E,              // 9
0x06, 0x10,0x10,0x7C,0x10,0x10,0x00,            // +
0x05, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00,               // -
0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,               // пробел
}; 





const uint8_t dig8x8[] PROGMEM = { 9,                   //
0x08, 0x03, 0x03, 0x00, 0x7E, 0x81, 0x81, 0xC3, 0x42,   // знак градусов и буква "С"
0x07, 0x00, 0x08, 0x00, 0x2A, 0x00, 0x08, 0x00, 0x00,   // знак градусов и буква "С"
0x07, 0x08, 0x2A, 0x14, 0x63, 0x14, 0x2A, 0x08, 0x00,   // знак градусов и буква "С"
};

const uint8_t dweek_ua[] PROGMEM = { 11,                           // Шрифт дни недели (укр) 2 буквы
0x09, 0xFC, 0x10, 0x10, 0xFC, 0x00, 0xFC, 0x94, 0x94, 0x84, 0x00,  // не (неділя)
0x09, 0xFC, 0x04, 0x04, 0xFC, 0x00, 0x78, 0x84, 0x84, 0x78, 0x00,  // по (понеділок)
0x07, 0xFC, 0x94, 0x94, 0x68, 0x00, 0x00, 0xF4, 0x00, 0x00, 0x00,  // ві (вівторок)
0x09, 0x78, 0x84, 0x84, 0x48, 0x00, 0xFC, 0x94, 0x94, 0x84, 0x00,  // се (середа)
0x08, 0x1C, 0x20, 0x20, 0xFC, 0x00, 0x04, 0xFC, 0x04, 0x00, 0x00,  // че (четверг)
0x0A, 0xFC, 0x04, 0x04, 0xFC, 0x00, 0x02, 0x99, 0x64, 0x24, 0xFC,  // п'я (п'ятниця)
0x09, 0x78, 0x84, 0x84, 0x48, 0x00, 0x8C, 0x90, 0x90, 0x7C, 0x00,  // су (субота)
0x0A, 0x07, 0x05, 0x07, 0x00, 0x7E, 0xFF, 0x81, 0x81, 0xE7, 0x66,  // символ градуса и буква С
};

const uint8_t dweek_ua2[] PROGMEM = { 12,                                // Шрифт дни недели (укр) 3 буквы
0x0B, 0xFC, 0x10, 0xFC, 0x00, 0xFC, 0x94, 0x84, 0x00, 0xB8, 0x44, 0xB8,  // нед (неділя)
0x0B, 0xFC, 0x04, 0xFC, 0x00, 0x78, 0x84, 0x78, 0x00, 0xFC, 0x10, 0xFC,  // пон (понеділок)
0x09, 0xFC, 0x94, 0x68, 0x00, 0xF4, 0x00, 0xFC, 0x94, 0x68, 0x00, 0x00,  // вів (вівторок)
0x0B, 0x78, 0x84, 0x48, 0x00, 0xFC, 0x94, 0x84, 0x00, 0xFC, 0x14, 0x08,  // сер (середа)
0x0B, 0x1C, 0x20, 0xFC, 0x00, 0xFC, 0x94, 0x84, 0x00, 0x04, 0xFC, 0x04,  // чет (четверг)
0x0B, 0xFC, 0x04, 0xFC, 0x00, 0xE8, 0x14, 0xFC, 0x00, 0x04, 0xFC, 0x04,  // пят (п'ятниця)
0x0B, 0x78, 0x84, 0x48, 0x00, 0x8C, 0x90, 0x7C, 0x00, 0xFC, 0x94, 0x64,  // суб (субота)
0x0B, 0x06, 0x09, 0x09, 0x06, 0x00, 0x7E, 0xFF, 0x81, 0x81, 0xE7, 0x66,  // символ градуса и буква С
};

const uint8_t dweek_ru[] PROGMEM = { 11,                           // Шрифт дни недели (рус) 2 буквы
0x09, 0xFE, 0x92, 0x92, 0x6C, 0x00, 0x78, 0x84, 0x84, 0x48, 0x00,  // вс (воскресенье)
0x09, 0xFE, 0x02, 0x02, 0xFE, 0x00, 0xFC, 0x20, 0x20, 0xFC, 0x00,  // Пн (понедельник)
0x08, 0xFE, 0x92, 0x92, 0x6C, 0x00, 0x04, 0xFC, 0x04, 0x00, 0x00,  // Вт (вторник)
0x09, 0x7C, 0x82, 0x82, 0x44, 0x00, 0xFC, 0x14, 0x14, 0x08, 0x00,  // Ср (среда)
0x09, 0x1E, 0x20, 0x20, 0xFE, 0x00, 0x04, 0xFC, 0x04, 0x00, 0x00,  // Чт (четверг)
0x09, 0xFE, 0x02, 0x02, 0xFE, 0x00, 0x04, 0xFC, 0x04, 0x00, 0x00,  // Пт (пятница)
0x09, 0x7C, 0x82, 0x82, 0x44, 0x00, 0xFC, 0x94, 0x94, 0xF4, 0x00,  // Сб (суббота)
0x0A, 0x07, 0x05, 0x07, 0x00, 0x7E, 0xFF, 0x81, 0x81, 0xE7, 0x66,  // символ градуса и буква С
};


const uint8_t dweek_en[] PROGMEM = { 11,                           // Шрифт дни недели (анг) 2 буквы
0x09, 0x9C, 0x94, 0x94, 0xF4, 0x00, 0xFC, 0x80, 0x80, 0xFC, 0x00,  // su
0x0A, 0xFC, 0x04, 0x3C, 0x04, 0xFC, 0x00, 0xFC, 0x84, 0x84, 0xFC,  // mo
0x0A, 0x04, 0x04, 0xFC, 0x04, 0x04, 0x00, 0xFC, 0x80, 0x80, 0xFC,  // tu
0x0A, 0xFC, 0x80, 0xF0, 0x80, 0xFC, 0x00, 0xFC, 0x94, 0x94, 0x84,  // we
0x0A, 0x04, 0x04, 0xFC, 0x04, 0x04, 0x00, 0xFC, 0x10, 0x10, 0xFC,  // th
0x09, 0xFC, 0x24, 0x24, 0x04, 0x00, 0xFC, 0x24, 0x64, 0xBC, 0x00,  // fr
0x09, 0x9C, 0x94, 0x94, 0xF4, 0x00, 0xFC, 0x24, 0x24, 0xFC, 0x00,  // sa
0x0A, 0x07, 0x05, 0x07, 0x00, 0x7E, 0xFF, 0x81, 0x81, 0xE7, 0x66,  // oC
};

const uint8_t font[] PROGMEM = {6,
5, B00000000, B00000000, B00000000, B00000000, B00000000, // space      0     0x00
1, B01011111, B00000000, B00000000, B00000000, B00000000, // !                0x01
3, B00000011, B00000000, B00000011, B00000000, B00000000, // "                0x02
5, B00010100, B00111110, B00010100, B00111110, B00010100, // #                0x03
4, B00100100, B01101010, B00101011, B00010010, B00000000, // $                0x04
5, B01100011, B00010011, B00001000, B01100100, B01100011, // %                0x05
5, B00110110, B01001001, B01010110, B00100000, B01010000, // &                0x06
1, B00000011, B00000000, B00000000, B00000000, B00000000, // '                0x07
3, B00011100, B00100010, B01000001, B00000000, B00000000, // (                0x08
3, B01000001, B00100010, B00011100, B00000000, B00000000, // )                0x09
5, B00101000, B00011000, B00001110, B00011000, B00101000, // *          10    0x0A
5, B00001000, B00001000, B00111110, B00001000, B00001000, // +                0x0B
2, B10110000, B01110000, B00000000, B00000000, B00000000, // ,                0x0C
4, B00001000, B00001000, B00001000, B00001000, B00000000, // -                0x0D
2, B01100000, B01100000, B00000000, B00000000, B00000000, // .                0x0E
4, B01100000, B00011000, B00000110, B00000001, B00000000, // /                0x0F
4, B00111110, B01000001, B01000001, B00111110, B00000000, // 0                0x10
3, B01000010, B01111111, B01000000, B00000000, B00000000, // 1                0x11
4, B01100010, B01010001, B01001001, B01000110, B00000000, // 2                0x12
4, B00100010, B01000001, B01001001, B00110110, B00000000, // 3                0x13
4, B00011000, B00010100, B00010010, B01111111, B00000000, // 4         20     0x14
4, B00100111, B01000101, B01000101, B00111001, B00000000, // 5                0x15
4, B00111110, B01001001, B01001001, B00110010, B00000000, // 6                0x16
4, B01100001, B00010001, B00001001, B00000111, B00000000, // 7                0x17
4, B00110110, B01001001, B01001001, B00110110, B00000000, // 8                0x18
4, B00100110, B01001001, B01001001, B00111110, B00000000, // 9                0x19
1, B01000100, B00000000, B00000000, B00000000, B00000000, // :                0x1A
2, B10000000, B01010000, B00000000, B00000000, B00000000, // ;                0x1B
3, B00010000, B00101000, B01000100, B00000000, B00000000, // <                0x1C
3, B00010100, B00010100, B00010100, B00000000, B00000000, // =                0x1D
3, B01000100, B00101000, B00010000, B00000000, B00000000, // >         30     0x1E
4, B00000010, B01011001, B00001001, B00000110, B00000000, // ?         31     0x1F
5, B00111110, B01001001, B01010101, B01011101, B00001110, // @         32     0x20
4, B01111110, B00010001, B00010001, B01111110, B00000000, // A         33     0x21
4, B01111111, B01001001, B01001001, B00110110, B00000000, // B         34     0x22
4, B00111110, B01000001, B01000001, B00100010, B00000000, // C                0x23
4, B01111111, B01000001, B01000001, B00111110, B00000000, // D                0x24
4, B01111111, B01001001, B01001001, B01000001, B00000000, // E                0x25
4, B01111111, B00001001, B00001001, B00000001, B00000000, // F                0x26
4, B00111110, B01000001, B01001001, B01111010, B00000000, // G                0x27
4, B01111111, B00001000, B00001000, B01111111, B00000000, // H         40     0x28
3, B01000001, B01111111, B01000001, B00000000, B00000000, // I                0x29
4, B00110000, B01000000, B01000001, B00111111, B00000000, // J                0x2A
4, B01111111, B00001000, B00010100, B01100011, B00000000, // K                0x2B
4, B01111111, B01000000, B01000000, B01000000, B00000000, // L                0x2C
5, B01111111, B00000010, B00001100, B00000010, B01111111, // M                0x2D
5, B01111111, B00000100, B00001000, B00010000, B01111111, // N                0x2E
4, B00111110, B01000001, B01000001, B00111110, B00000000, // O                0x2F
4, B01111111, B00001001, B00001001, B00000110, B00000000, // P                0x30
4, B00111110, B01000001, B01000001, B10111110, B00000000, // Q                0x31
4, B01111111, B00001001, B00001001, B01110110, B00000000, // R         50     0x32
4, B00100110, B01001001, B01001001, B00110010, B00000000, // S                0x33
5, B00000001, B00000001, B01111111, B00000001, B00000001, // T                0x34
4, B00111111, B01000000, B01000000, B00111111, B00000000, // U                0x35
5, B00001111, B00110000, B01000000, B00110000, B00001111, // V                0x36
5, B00111111, B01000000, B00111000, B01000000, B00111111, // W                0x37
5, B01100011, B00010100, B00001000, B00010100, B01100011, // X                0x38
5, B00000111, B00001000, B01110000, B00001000, B00000111, // Y                0x39
4, B01100001, B01010001, B01001001, B01000111, B00000000, // Z                0x3A
2, B01111111, B01000001, B00000000, B00000000, B00000000, // [                0x3B
4, B00000001, B00000110, B00011000, B01100000, B00000000, // \ backslash 60   0x3C
2, B01000001, B01111111, B00000000, B00000000, B00000000, // ]                0x3D
3, B00000010, B00000001, B00000010, B00000000, B00000000, // hat              0x3E
4, B01000000, B01000000, B01000000, B01000000, B00000000, // _                0x3F
2, B00000001, B00000010, B00000000, B00000000, B00000000, // `                0x40
4, B00100000, B01010100, B01010100, B01111000, B00000000, // a                0x41
4, B01111111, B01000100, B01000100, B00111000, B00000000, // b                0x42
4, B00111000, B01000100, B01000100, B00101000, B00000000, // c                0x43
4, B00111000, B01000100, B01000100, B01111111, B00000000, // d                0x44
4, B00111000, B01010100, B01010100, B00011000, B00000000, // e                0x45
3, B00000100, B01111110, B00000101, B00000000, B00000000, // f          70    0x46 
4, B10011000, B10100100, B10100100, B01111000, B00000000, // g                0x47
4, B01111111, B00000100, B00000100, B01111000, B00000000, // h                0x48
3, B01000100, B01111101, B01000000, B00000000, B00000000, // i                0x49
4, B01000000, B10000000, B10000100, B01111101, B00000000, // j                0x4A
4, B01111111, B00010000, B00101000, B01000100, B00000000, // k                0x4B
3, B01000001, B01111111, B01000000, B00000000, B00000000, // l                0x4C
5, B01111100, B00000100, B01111100, B00000100, B01111000, // m                0x4D
4, B01111100, B00000100, B00000100, B01111000, B00000000, // n                0x4E
4, B00111000, B01000100, B01000100, B00111000, B00000000, // o                0x4F
4, B11111100, B00100100, B00100100, B00011000, B00000000, // p         80     0x50
4, B00011000, B00100100, B00100100, B11111100, B00000000, // q                0x51
4, B01111100, B00001000, B00000100, B00000100, B00000000, // r                0x52
4, B01001000, B01010100, B01010100, B00100100, B00000000, // s                0x53
3, B00000100, B00111111, B01000100, B00000000, B00000000, // t                0x54
4, B00111100, B01000000, B01000000, B01111100, B00000000, // u                0x55
5, B00011100, B00100000, B01000000, B00100000, B00011100, // v                0x56
5, B00111100, B01000000, B00111100, B01000000, B00111100, // w                0x57
5, B01000100, B00101000, B00010000, B00101000, B01000100, // x                0x58
4, B10011100, B10100000, B10100000, B01111100, B00000000, // y                0x59
3, B01100100, B01010100, B01001100, B00000000, B00000000, // z        90      0x5A
3, B00001000, B00110110, B01000001, B00000000, B00000000, // {        91      0x5B
1, B01111111, B00000000, B00000000, B00000000, B00000000, // |        92      0x5C
3, B01000001, B00110110, B00001000, B00000000, B00000000, // }        93      0x5D
4, B00001000, B00000100, B00001000, B00000100, B00000000, // ~        94      0x5E
5, B00111110, B01010101, B01100001, B01010101, B00111110, // :)       95
5, B00111110, B01100101, B01010001, B01100101, B00111110, // :(       96
5, B00111110, B01000101, B01010001, B01000101, B00111110, // :o       97
5,      0x06,      0x1F,      0x7E,      0x1F,      0x06, // heart    98
0, B00000000, B00000000, B00000000, B00000000, B00000000, //          99
0, B00000000, B00000000, B00000000, B00000000, B00000000, //         100
0, B00000000, B00000000, B00000000, B00000000, B00000000, //        
0, B00000000, B00000000, B00000000, B00000000, B00000000, //        
0, B00000000, B00000000, B00000000, B00000000, B00000000, //        
0, B00000000, B00000000, B00000000, B00000000, B00000000, //        
0, B00000000, B00000000, B00000000, B00000000, B00000000, //        
0, B00000000, B00000000, B00000000, B00000000, B00000000, //        
0, B00000000, B00000000, B00000000, B00000000, B00000000, //        
0, B00000000, B00000000, B00000000, B00000000, B00000000, //        
0, B00000000, B00000000, B00000000, B00000000, B00000000, //        
0, B00000000, B00000000, B00000000, B00000000, B00000000, //         110
0, B00000000, B00000000, B00000000, B00000000, B00000000, //         111
4, B01111110, B00010001, B00010001, B01111110, B00000000, // А       112  
4, B01111111, B01000101, B01000101, B00111001, B00000000, // Б       113  
4, B01111111, B01001001, B01001001, B00110110, B00000000, // В       114  
4, B01111111, B00000001, B00000001, B00000011, B00000000, // Г       115  
5, B11000000, B01111110, B01000001, B01111110, B11000000, // Д       116  
4, B01111111, B01001001, B01001001, B01000001, B00000000, // Е       117  
5, B01111011, B00000100, B01111111, B00000100, B01111011, // Ж       118  
4, B01000010, B01001001, B01001001, B00110110, B00000000, // З       199  
5, B01111111, B00010000, B00001000, B00000100, B01111111, // И       200  
5, B01111111, B00100000, B00010011, B00001000, B01111111, // Й       201  
4, B01111111, B00001000, B00010100, B01100011, B00000000, // К       202  
4, B01000000, B00111110, B00000001, B01111111, B00000000, // Л       203  
5, B01111111, B00000010, B00001100, B00000010, B01111111, // М       204  
4, B01111111, B00001000, B00001000, B01111111, B00000000, // Н       205  
4, B00111110, B01000001, B01000001, B00111110, B00000000, // О       206  
4, B01111111, B00000001, B00000001, B01111111, B00000000, // П       207  
4, B01111111, B00001001, B00001001, B00000110, B00000000, // Р       208  
4, B00111110, B01000001, B01000001, B00100010, B00000000, // C       209  
5, B00000001, B00000001, B01111111, B00000001, B00000001, // Т       210  
4, B01000111, B01001000, B01001000, B00111111, B00000000, // У       211  
5, B00001110, B00010001, B01111111, B00010001, B00001110, // Ф       212  
5, B01000001, B00110110, B00001000, B00110110, B01000001, // Х       213  
5, B01111111, B01000000, B01000000, B01111111, B11000000, // Ц       214  
4, B00001111, B00010000, B00010000, B01111111, B00000000, // Ч       215  
5, B01111111, B01000000, B01111100, B01000000, B01111111, // Ш       216  
5, B01111111, B01000000, B01111000, B01000000, B11111111, // Щ       217  
5, B00000001, B01111111, B01000100, B01000100, B00111000, // Ъ       218  
5, B01111111, B01000100, B00111000, B00000000, B01111111, // Ы       219  
4, B01111111, B01000100, B01000100, B00111000, B00000000, // Ь       220  
4, B00100010, B01001001, B01001001, B00111110, B00000000, // Э       221  
5, B01111111, B00001000, B00111110, B01000001, B00111110, // Ю       222  
4, B01001110, B00110001, B00010001, B01111111, B00000000, // Я       223  
/*224  а
225  б
226  в
227  г
228  д
229  е
230  ж
231  з
232  и
233  й
234  к
235  л
236  м
237  н
238  о
239  п
240  р
241  с
242  т
243  у
244  ф
245  х
246  ц
247  ч
248  ш
249  щ
250  ъ
251  ы
252  ь
253  э
254  ю
255  я
*/
};

const uint8_t font_ru[] PROGMEM = {6,
5, B00000000, B00000000, B00000000, B00000000, B00000000, // space      0     0x00
1, B01011111, B00000000, B00000000, B00000000, B00000000, // !                0x01
4, B00100010, B01001001, B01001001, B00111110, B00000000, // "(Э)             0x02
5, B01111111, B00001110, B00111000, B01111111, B01011000, //B01011000, // #(№)            0x03
2, B10000000, B01001000, B00000000, B00000000, B00000000, // $(;)             0x04
5, B01100011, B00010011, B00001000, B01100100, B01100011, // %                0x05
4, B00000010, B01011001, B00001001, B00000110, B00000000, // &(?)             0x06
4, B00101000, B01000100, B01010100, B00111000, B00000000, // '(э)             0x07
3, B00011100, B00100010, B01000001, B00000000, B00000000, // (                0x08
3, B01000001, B00100010, B00011100, B00000000, B00000000, // )                0x09
5, B00101000, B00011000, B00001110, B00011000, B00101000, // *          10    0x0A
5, B00001000, B00001000, B00111110, B00001000, B00001000, // +                0x0B
4, B00111010, B01000101, B01000101, B00111001, B00000000, // ,(б)             0x0C
4, B00001000, B00001000, B00001000, B00001000, B00000000, // -                0x0D
5, B01111100, B00010000, B00111000, B01000100, B00111000, // .(ю)             0x0E
1, B01000000, B00000000, B00000000, B00000000, B00000000, // /(.)             0x0F
4, B00111110, B01000001, B01000001, B00111110, B00000000, // 0                0x10
3, B01000010, B01111111, B01000000, B00000000, B00000000, // 1                0x11
4, B01100010, B01010001, B01001001, B01000110, B00000000, // 2                0x12
4, B00100010, B01000001, B01001001, B00110110, B00000000, // 3                0x13
4, B00011000, B00010100, B00010010, B01111111, B00000000, // 4         20     0x14
4, B00100111, B01000101, B01000101, B00111001, B00000000, // 5                0x15
4, B00111110, B01001001, B01001001, B00110010, B00000000, // 6                0x16
4, B01100001, B00010001, B00001001, B00000111, B00000000, // 7                0x17
4, B00110110, B01001001, B01001001, B00110110, B00000000, // 8                0x18
4, B00100110, B01001001, B01001001, B00111110, B00000000, // 9                0x19
5, B01111011, B00000100, B01111111, B00000100, B01111011, // :(Ж)             0x1A
5, B01101100, B00010000, B01111100, B00010000, B01101100, // ;(ж)             0x1B
4, B01111111, B01000101, B01000101, B00111001, B00000000, // <(Б)             0x1C
3, B00010100, B00010100, B00010100, B00000000, B00000000, // =                0x1D
5, B01111111, B00001000, B00111110, B01000001, B00111110, // >(Ю)      30     0x1E
2, B10000000, B01000000, B00000000, B00000000, B00000000, // ?(,)             0x1F
3, B00000011, B00000000, B00000011, B00000000, B00000000, // @(")             0x20
5, B00001110, B00010001, B01111111, B00010001, B00001110, // A(Ф)             0x21
5, B01111111, B00010000, B00001000, B00000100, B01111111, // B(И)             0x22
4, B00111110, B01000001, B01000001, B00100010, B00000000, // C                0x23
4, B01111111, B01001001, B01001001, B00110110, B00000000, // D(В)             0x24
4, B01000111, B01001000, B01001000, B00111111, B00000000, // E(У)             0x25
4, B01111110, B00010001, B00010001, B01111110, B00000000, // F(А)             0x26
4, B01111111, B00000001, B00000001, B01111111, B00000000, // G(П)             0x27
4, B01111111, B00001001, B00001001, B00000110, B00000000, // H(Р)      40     0x28
5, B01111111, B01000000, B01111100, B01000000, B01111111, // I(Ш)             0x29
4, B00111110, B01000001, B01000001, B00111110, B00000000, // J(О)             0x2A
4, B01000000, B00111110, B00000001, B01111111, B00000000, // K(Л)             0x2B
5, B11000000, B01111110, B01000001, B01111110, B11000000, // L(Д)             0x2C
4, B01111111, B01000100, B01000100, B00111000, B00000000, // M(Ь)             0x2D
5, B00000001, B00000001, B01111111, B00000001, B00000001, // N(Т)             0x2E
5, B01111111, B01000000, B01111000, B01000000, B11111111, // O(Щ)             0x2F
4, B01000010, B01001001, B01001001, B00110110, B00000000, // P(З)             0x30
5, B01111111, B00100000, B00010011, B00001000, B01111111, // Q(Й)             0x31
4, B01111111, B00001000, B00010100, B01100011, B00000000, // R(К)      50     0x32
5, B01111111, B01000100, B00111000, B00000000, B01111111, // S(Ы)             0x33
4, B01111111, B01001001, B01001001, B01000001, B00000000, // T(Е)             0x34
4, B01111111, B00000001, B00000001, B00000011, B00000000, // U(Г)             0x35
5, B01111111, B00000010, B00001100, B00000010, B01111111, // V(М)             0x36
5, B01111111, B01000000, B01000000, B01111111, B11000000, // W(Ц)             0x37
4, B00001111, B00010000, B00010000, B01111111, B00000000, // X(Ч)             0x38
4, B01111111, B00001000, B00001000, B01111111, B00000000, // Y(Н)             0x39
4, B01001110, B00110001, B00010001, B01111111, B00000000, // Z(Я)             0x3A
5, B01000100, B00101000, B00010000, B00101000, B01000100, // [(х)             0x3B
4, B00000001, B00000110, B00011000, B01100000, B00000000, // \ backslash 60   0x3C
5, B00000100, B01111100, B01010000, B01010000, B00100000, // ](ъ)             0x3D
1, B01001000, B00000000, B00000000, B00000000, B00000000, // ^(:)             0x3E
4, B01000000, B01000000, B01000000, B01000000, B00000000, // _                0x3F
4, B00111000, B01010101, B01010101, B01011000, B00000000, // `(ё)             0x40
5, B00011000, B00100100, B01111110, B00100100, B00011000, // a(ф)             0x41
4, B01111100, B00100000, B00010000, B01111100, B00000000, // b(и)             0x42
4, B00111000, B01000100, B01000100, B00101000, B00000000, // c                0x43
4, B01111100, B01010100, B01010100, B00101000, B00000000, // d(в)             0x44
4, B01001100, B01010000, B01010000, B00111100, B00000000, // e(у)             0x45
5, B00100000, B01010100, B01010100, B00111000, B01000000, // f(а)       70    0x46 
4, B01111100, B00000100, B00000100, B01111100, B00000000, // g(п)             0x47
4, B11111100, B00100100, B00100100, B00011000, B00000000, // h(р)             0x48
5, B01111100, B01000000, B01111000, B01000000, B01111100, // i(ш)             0x49
4, B00111000, B01000100, B01000100, B00111000, B00000000, // j(о)             0x4A
4, B01000000, B00111100, B00000100, B01111100, B00000000, // k(л)             0x4B
5, B11000000, B01111000, B01000100, B01111000, B11000000, // l(д)             0x4C
4, B01111100, B01001000, B01001000, B00110000, B00000000, // m(ь)             0x4D
3, B00000100, B01111100, B00000100, B00000000, B00000000, // n(т)             0x4E
5, B01111100, B01000000, B01111000, B01000000, B11111100, // o(щ)             0x4F
4, B01001000, B01000100, B01010100, B00101000, B00000000, // p(з)      80     0x50
4, B01111100, B00100010, B00010001, B01111100, B00000000, // q(й)             0x51
4, B01111100, B00010000, B00101000, B01000100, B00000000, // r(к)             0x52
5, B01111100, B01001000, B00110000, B00000000, B01111100, // s(ы)             0x53
4, B00111000, B01010100, B01010100, B01011000, B00000000, // t(е)             0x54
4, B01111100, B00000100, B00000100, B00001100, B00000000, // u(г)             0x55
5, B01111100, B00001000, B00010000, B00001000, B01111100, // v(м)             0x56
5, B01111100, B01000000, B01000000, B01111100, B11000000, // w(ц)             0x57
4, B00001100, B00010000, B00010000, B01111100, B00000000, // x(ч)             0x58
4, B01111100, B00010000, B00010000, B01111100, B00000000, // y(н)             0x59
4, B01001000, B00110100, B00010100, B01111100, B00000000, // z(я)     90      0x5A
5, B01000001, B00110110, B00001000, B00110110, B01000001, // {(Х)             0x5B
4, B01100000, B00011000, B00000110, B00000001, B00000000, // |(/)             0x5C
5, B00000001, B01111111, B01000100, B01000100, B00111000, // }(Ъ)             0x5D
5, B01111110, B01001011, B01001010, B01001011, B01000010, // ~(Ё)             0x5E

5, B00100000, B01010100, B01010100, B11111000, B10000000, // a       95       0x5F
4, B00111000, B01000100, B01000110, B00101001, B00000000, // c                0x60
4, B00111000, B01010100, B11010100, B10011000, B00000000, // e                0x61
3, B01010001, B01111111, B01000100, B00000000, B00000000, // l                0x62
4, B01111100, B00000100, B00000110, B01111001, B00000000, // n                0x63
4, B00111000, B01000100, B01000110, B00111001, B00000000, // o       100      0x64
4, B01001000, B01010100, B01010110, B00100101, B00000000, // s                0x65
3, B01100100, B01010110, B01001101, B00000000, B00000000, // z                0x66
3, B01100100, B01010101, B01001100, B00000000, B00000000, // z                0x67
5, B01111110, B00010001, B00010001, B11111110, B10000000, // A                0x68
4, B00111100, B01000010, B01000011, B00100101, B00000000, // C                0x69
5, B01111111, B01001001, B01001001, B11000001, B10000000, // E                0x6A
4, B01111111, B01001000, B01000100, B01000000, B00000000, // L                0x6B
5, B01111110, B00000100, B00001010, B00010001, B01111110, // N                0x6C
4, B00111100, B01000110, B01000011, B00111100, B00000000, // O                0x6D
4, B00100100, B01001010, B01001011, B00110000, B00000000, // S       110      0x6E
4, B01100010, B01010110, B01001011, B01000110, B00000000, // Z                0x6F
4, B01101001, B01011001, B01001101, B01001011, B00000000, // Z       112      0x70

5, B00111110, B01010101, B01100001, B01010101, B00111110, // :)      113      0x71
5, B00111110, B01100101, B01010001, B01100101, B00111110, // :(               0x72
5, B00111110, B01000101, B01010001, B01000101, B00111110, // :o               0x73
5, 0x06, 0x1F, 0x7E, 0x1F, 0x06                           // heart   116      0x74
};


/*
0    
1    
2    
3    
4    
5    
6    
7    
8    
9    
10   
11   
12   
13   
14   
15   
16   
17   
18   
19   
20   
21   
22   
23   
24   
25   
26    
27   
28   
29   
30   
31   
32   Пробел
33   !
34   "
35   #
36   $
37   %
38   &
39   '
40   (
41   )
42   *
43   +
44   ,
45   -
46   .
47   /
48   0
49   1
50   2
51   3
52   4
53   5
54   6
55   7
56   8
57   9
58   :
59   ;
60   <
61   =
62   >
63   ?
64   @
65   A
66   B
67   C
68   D
69   E
70   F
71   G
72   H
73   I
74   J
75   K
76   L
77   M
78   N
79   O
80   P
81   Q
82   R
83   S
84   T
85   U
86   V
87   W
88   X
89   Y
90   Z
91   [
92   \
93   ]
94   ^
95   _
96   `
97   a
98   b
99   c
100  d
101  e
102  f
103  g
104  h
105  i
106  j
107  k
108  l
109  m
110  n
111  o
112  p
113  q
114  r
115  s
116  t
117  u
118  v
119  w 
120  x
121  y
122  z
123  {
124  |
125  }
126  ~
127  
128  
129  
130  
131  
132
133
134
135
136
137
138
139
140
141
142
143
144
145
145
147
148
149
150
151
152
153
154
155
156
157
158
159
160
161
162
163
164
165  Ґ
166  
167
168  Ё
169  
170  Є
171  
172  
173  
174  
175  Ї
176  
177  
178  І
179  і
180  ґ
181  
182  
183  
184  ё
185  #
186  є
187  
188  
189  
190  
191  ї
192  А
193  Б
194  В
195  Г
196  Д
197  Е
198  Ж
199  З
200  И
201  Й
202  К
203  Л
204  М
205  Н
206  О
207  П
208  Р
209  С
210  Т
211  У
212  Ф
213  Х
214  Ц
215  Ч
216  Ш
217  Щ
218  Ъ
219  Ы
220  Ь
221  Э
222  Ю
223  Я
224  а
225  б
226  в
227  г
228  д
229  е
230  ж
231  з
232  и
233  й
234  к
235  л
236  м
237  н
238  о
239  п
240  р
241  с
242  т
243  у
244  ф
245  х
246  ц
247  ч
248  ш
249  щ
250  ъ
251  ы
252  ь
253  э
254  ю
255  я
  
*/
