#define TIM_CAR TIM17
#define TIM_ENV TIM16

u16 mt[4];//[sizeof(ir_tms[0])/sizeof(ir_tms[0][0])];

void cfg_irtms(int cr_frq = 38000)
{
 RCC->APB2ENR |= RCC_APB2ENR_TIM16EN | RCC_APB2ENR_TIM17EN;

 GPIO_PinAFConfig(GPIOA, GPIO_PinSource13, GPIO_AF_1); //ir_out


 /* Configure TIM_CAR as carrier signal */
 TIM17->ARR   = (u16)(SYSTEM_FRQ/cr_frq -1);
 TIM17->CCR1  = TIM17->ARR / 3;
 TIM17->CCMR1 = pwm1;
 TIM17->CCER  = TIM_CCER_CC1E;
 TIM17->BDTR  = TIM_BDTR_MOE;

 /* Configure TIM_ENV is the modulation envelope */
 TIM16->PSC   = 6;
 TIM16->ARR   = (u16)-1-1;
 TIM16->CCR1  = (u16)-1-1;
 TIM16->CCMR1 = pwm1;
 TIM16->CCER  = TIM_CCER_CC1E;
 TIM16->BDTR  = TIM_BDTR_MOE;

 TIM16->DIER  = TIM_DIER_UDE;

 TIM16->DCR   = 2<<8 | //3 transferts burst
                ((u32)&TIM16->ARR - (u32)&TIM16->CR1)/sizeof(u32); //11; //offset from CR1 to ARR

 TIM16->CNT   = 1;

 TIM17->CR1   = TIM_CR1_CEN;
 TIM16->CR1   = TIM_CR1_CEN;

 TIM17->SR    = 0;
 TIM16->SR    = 0;
 TIM16->EGR   = TIM_EGR_UG;
}

// send_data((u16*)ir_tms[0]);
//   GPIOA.13         flash
bool send_data(u16 *dmp = NULL)
{
 const int sz = 1;//sizeof(ir_tms[0])/sizeof(ir_tms[0][0])+sizeof(ir_tms[0])/sizeof(ir_tms[0][0])/2;

 u16 mss_2send[sz];
 static bool trg;
 static bool dmp_trg;

 if(!trg)
 {
  trg = true;

  if(dmp != NULL)
  {
   dmp_trg = 1;

   //       flash       RCRCNT
   int i=0;
   int u=0;

   for(;i<sz-3;)
   {
    mss_2send[i++] = *(dmp+(u++));
    mss_2send[i++] = 0;
    mss_2send[i++] = *(dmp+(u++));
   }



   //           dma
   //    .   ARR,   RCR( 0), CCR1
   RCC->AHBENR         |= RCC_AHBENR_DMA1EN;
   DMA1_Channel3->CPAR  = (uint32_t)&TIM16->DMAR;
   DMA1_Channel3->CMAR  = (uint32_t)mss_2send;
   DMA1_Channel3->CNDTR = i;
   DMA1_Channel3->CCR   = DMA_CCR_MINC    | //memory incremental mode
                          DMA_CCR_MSIZE_0 | //16 bit
                          DMA_CCR_PSIZE_0 | //16 bit
                          DMA_CCR_PL      | //vh priority
                          DMA_CCR_DIR     | //read from memory
                          DMA_CCR_EN;

   //       _  burst dma
   cfg_irtms();
  }
 }





 if(dmp_trg)
 {
  //  
  if(DMA1->ISR & DMA_ISR_TCIF3 || TIM16->ARR == 0 ||
     (TIM16->ARR == u16(-1) && TIM16->CCR1 == u16(-1)))
  {
   if(mss_2send[0])__no_operation(); //      

   //   dma1
   DMA1->IFCR = DMA_IFCR_CGIF3;
   //  
   DMA1_Channel3->CCR = 0;
   RCC->AHBENR       &= ~RCC_AHBENR_DMA1EN;

   //  SWDAT(pullup)     
   GPIO_PinAFConfig(GPIOA, GPIO_PinSource13, GPIO_AF_0);

   RCC->APB2ENR &= ~(RCC_APB2ENR_TIM16EN | RCC_APB2ENR_TIM17EN);

   trg = false;
   dmp_trg = false;
   return true;
  }
 }
 else
 {
  trg = false;
  return true;
 }

 return false;
}