
 void cfg_rcc()
 {
  RCC->AHBENR  |= RCC_AHBENR_GPIOAEN | RCC_AHBENR_GPIOBEN | RCC_AHBENR_GPIOFEN;
  RCC->APB1ENR |= RCC_APB1ENR_PWREN;
  RCC->AHBENR  |= RCC_AHBENR_DMA1EN;
 }

 void cfg_gpio()
 {
  GPIO_InitTypeDef GIS;

  GIS.GPIO_Speed = GPIO_Speed_2MHz;

 //PF1,PF0 - reset pullup
  GIS.GPIO_Pin   = GPIO_Pin_0|GPIO_Pin_1;
  GIS.GPIO_Mode  = GPIO_Mode_AN;
  GIS.GPIO_OType = GPIO_OType_OD;
  GIS.GPIO_PuPd  = GPIO_PuPd_UP;

  GPIO_Init(GPIOF, &GIS);

 //PA5,PA6,PA7 - lock out
  GIS.GPIO_Pin   = GPIO_Pin_5|GPIO_Pin_6|GPIO_Pin_7;
  GIS.GPIO_Mode  = GPIO_Mode_OUT;
  GIS.GPIO_OType = GPIO_OType_PP;
  GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;

  GPIO_Init(GPIOA, &GIS);
 }

 void cfg_systic(int frq)
 {
  SysTick->LOAD  = SYSTEM_FRQ/frq-1;
  NVIC_SetPriority (SysTick_IRQn, 3);
  SysTick->CTRL  = SysTick_CTRL_CLKSOURCE_Msk|SysTick_CTRL_TICKINT_Msk|SysTick_CTRL_ENABLE_Msk;
 }

 void cfg_exti()
 {
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_SYSCFG, ENABLE);
//  SYSCFG_EXTILineConfig(EXTI_PortSourceGPIOA,EXTI_PinSource6);
//  SYSCFG_EXTILineConfig(EXTI_PortSourceGPIOA,EXTI_PinSource7);
//  SYSCFG_EXTILineConfig(EXTI_PortSourceGPIOA,EXTI_PinSource9);
//  SYSCFG_EXTILineConfig(EXTI_PortSourceGPIOA,EXTI_PinSource10);
  SYSCFG_EXTILineConfig(EXTI_PortSourceGPIOA,EXTI_PinSource1);
//  RCC_APB2PeriphClockCmd(RCC_APB2Periph_SYSCFG, DISABLE);

  EXTI_InitTypeDef EIS;

  EIS.EXTI_Line    = EXTI_Line1;
  EIS.EXTI_Mode    = EXTI_Mode_Event;
  EIS.EXTI_Trigger = EXTI_Trigger_Falling;
  EIS.EXTI_LineCmd = ENABLE;

  EXTI_Init(&EIS);
  EXTI_ClearFlag(EXTI_Line1);
 }

//0x9f vdda_off parity_on, 0xdf vdda_off, 0xbf ram parity checking on
FLASH_Status FLASH_OB_UBC(uint8_t input_val)
{
  FLASH_Status status = FLASH_COMPLETE;

  if((OB->USER & 0xff) != input_val)
  {
   /* Wait for last operation to be completed */
   status = FLASH_WaitForLastOperation(FLASH_ER_PRG_TIMEOUT);

   if(status == FLASH_COMPLETE)
   {
    __disable_interrupt();
    FLASH_Unlock();
    FLASH_OB_Unlock();

    uint8_t tmp_mss[sizeof(*OB)/sizeof(uint16_t)];
    uint16_t *pt = (uint16_t *)OB;

    for(int i=0; i<sizeof(*OB)/sizeof(uint16_t);i++) tmp_mss[i] = uint8_t(*pt++);

     FLASH->CR |= FLASH_CR_OPTER;
     FLASH->CR |= FLASH_CR_STRT;

     while((FLASH_WaitForLastOperation(FLASH_ER_PRG_TIMEOUT)==FLASH_BUSY))__no_operation();

     FLASH->CR &= ~FLASH_CR_OPTER;
     FLASH->CR |= FLASH_CR_OPTPG;

     OB->USER = input_val;
     while((FLASH_WaitForLastOperation(FLASH_ER_PRG_TIMEOUT)==FLASH_BUSY))__no_operation();

     pt = (uint16_t *)OB;

     for(int i=0; i<sizeof(*OB)/sizeof(uint16_t);i++)
     {
      *(pt+i) = tmp_mss[i];

      if(i==((uint16_t *)&OB->USER -(uint16_t *)OB))i++;

      while((FLASH_WaitForLastOperation(FLASH_ER_PRG_TIMEOUT)==FLASH_BUSY))__no_operation();
     }

     /* Wait for last operation to be completed */
     status = FLASH_WaitForLastOperation(FLASH_ER_PRG_TIMEOUT);

     if(status != FLASH_TIMEOUT)
     {
       /* if the program operation is completed, disable the OPTPG Bit */
       FLASH->CR &= ~FLASH_CR_OPTPG;
       FLASH_OB_Lock();
       FLASH_Lock();

       FLASH_OB_Launch();
     }
   }
  }
  /* Return the Option Byte program Status */
  return status;
}








