/********************************************************
Workspace: IAR_ARM+SPL
MCU      : STM32f050f4/6
Project  : ir_code_lock
Version  :
Date     : AUG 2019
*********************************************************/

#include <stm32f0xx.h>
#include <stdbool.h>
#include <uchar.h>

#include "stm32f0xx_syscfg.c"
#include "stm32f0xx_rcc.c"
#include "stm32f0xx_gpio.c"
#include "stm32f0xx_flash.c"
#include "stm32f0xx_exti.c"
#include "stm32f0xx_misc.c"
#include "stm32f0xx_pwr.c"
#include "stm32f0xx_dma.c"

#include "bitset.c"
#include "defines.c"
#include "periph_cfg.c"

#include "eep_em.c"

#include "kb.c"
#include "led.c"
#include "pulse_work.c"
#include "ir_rcv_work.c"
#include "lock_unlock.c"

#include "interrupts.c"



void main()
{
 cfg_rcc();
 cfg_gpio();

 cfg_systic(1000);

 btn_init();

 led_pins_init();
 led(red, true);
 led(green, true);

 __enable_interrupt();

 tim0 = 500;
 while(tim0)continue;

// while(FLASH_OB_UBC(0xbf)==FLASH_BUSY)continue; //enable ram parity checking

 clear_rcvd();
 cfg_rcv_pin();
 cfg_rcv_tim();

 led(red, false);
 led(green, false);

 while(1)
 {
  static enum zz {L_open, L_close} L_state = L_open, tmp_state;
  static enum {code1, code2, code_ready, code_nocode}ics = code_ready;
  static keyst lb;


  //      
  if(lb != btn[0])
  {
   //   
   if(lb == rls)
   {
    //  
    if(btn[0]==hold)
    {
     //  
     if(L_state!=L_close) L_state = L_close;
     else                 L_state = L_open;
    }
   }

   //  ,    
   if(btn[0]!=prs) lb = btn[0];
  }

  //  
  if(rcvd_ready == true)
  {
   //    ""
   if(L_state == L_open)
   {
    static u8 tmp_buff[KNUM];

    //   OP_ENT_CLS  
    if(*mss_rcvd == (u8)OP_ENT_CLS) L_state = L_close;
    //   OP_ENT_BSP       
    else if(*mss_rcvd == (u8)OP_ENT_BSP) ics = code1;
    //     
    else if(ics == code1)
    {
     for(int i=0;i<KNUM;i++)tmp_buff[i] = mss_rcvd[i];
     ics = code2;
    }
    //         
    //         
    //      
    else if(ics == code2)
    {
     //           
     bool c_result = true;

     for(int i=0;i<KNUM;i++)
     {
      if(tmp_buff[i] != mss_rcvd[i])
      {
       c_result = false;
       ics = code1;
       break;
      }
     }

     if(c_result == true)
     {
      save_code_in_ee(tmp_buff);
      ics = code_ready;
     }
    }
   }
   //   
   else
   {
    //       
    ics=code_ready;

    //    rom
    //    
    int mindex = get_ee_index();
    //         
    //     
    if(mindex < PNUM)
    {
     //    flash      ""
     //     
     if(chk_code_in_flash(mindex) == false)
     {
      L_state = L_open;
      ics = code_nocode;
     }
     //       rom
     else
     {
      bool tmp = true;

      //          
      for(int i=0;i<KNUM && mss_rcvd[i]!=0xff;i++)
      {
       if(mss_rcvd[i]!= ir_tms[mindex][0][i])
       {
        tmp = false;
        break;
       }
      }

      if(tmp == true)L_state = L_open;
     }
    }
    //         ""
    else L_state = L_open;
   }

   rcvd_ready = false;
  }


  //      
  if(tmp_state != L_state)
  {
   tmp_state = L_state;

   //     
   if(L_state == L_open)
   {
    //      
    unlock();
   }
   else
   {
    lock();
   }
  }


  // 
  if(!tim_led)
  {
   static bool trg;

   tim_led = 500;
   trg^=1;

   if(L_state == L_open)
   {
    if(ics == code_ready)
    {
     //  
     led(green, true);
     led(red,   false);
    }
    else if(ics == code1)
    {
     //  ,  
     led(green, false);
     led(red, trg);
    }
    else if(ics == code2)
    {
     //  ,  
     led(green, trg);
     led(red, false);
    }
    else
    {
     //  
     led(green, !trg);
     led(red, trg);
    }
   }
   else if(L_state == L_close)
   {
    //  
    led(green, false);
    led(red,   true);
   }
  }
 }
}