enum led_colour{green, red};

struct led_stct
{
 GPIO_TypeDef *GPIOx;
 int shift;
};

led_stct led_set[2]=
{
 //green
 {
   GPIOA,
   3
 },
 //red
 {
   GPIOA,
   4
 }
};

//led_pins_init(led_set);
void led_pins_init(void)
{
 int size = sizeof(led_set)/sizeof(led_set[0]);

 GPIO_InitTypeDef GIS;

 GIS.GPIO_Speed = GPIO_Speed_2MHz;
 GIS.GPIO_Mode  = GPIO_Mode_OUT;
 GIS.GPIO_OType = GPIO_OType_PP;
 GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;

 for(int i=0;i<size;i++)
 {
  GIS.GPIO_Pin   = 1<<led_set[i].shift;
  GPIO_Init(led_set[i].GPIOx, &GIS);
 }
}

void led_on(led_stct *led)
{
 led->GPIOx->BSRR = 1<<led->shift;
}

void led_off(led_stct *led)
{
 led->GPIOx->BRR  = 1<<led->shift;
}

// led(red,true);
void led (led_colour lc, bool L)
{
 if(L==true) led_on(led_set+(int)lc);
 else        led_off(led_set+(int)lc);
}

//__________________
