#include "key_work.h"

enum oprt
{
 OP_NULL=0,
 OP_0,
 OP_1,
 OP_2,
 OP_3,
 OP_4,
 OP_5,
 OP_6,
 OP_7,
 OP_8,
 OP_9,
 OP_ENT,
 OP_BSP,

 OP_ENT_BSP
};

struct rkeys
{
 int k_am;
 oprt a_keys[COLS*ROWS];
};

#define O_BUFF_SIZE 32
oprt o_buff[O_BUFF_SIZE];

//      
void key_2_ops(int n_b, oprt *ops)
{
 switch (n_b)
 {
  case 0 : {*ops = OP_ENT;}break;
  case 1 : {*ops = OP_7;}break;
  case 2 : {*ops = OP_8;}break;
  case 3 : {*ops = OP_9;}break;
  case 4 : {*ops = OP_BSP;}break;
  case 5 : {*ops = OP_4;}break;
  case 6 : {*ops = OP_5;}break;
  case 7 : {*ops = OP_6;}break;
  case 8 : {*ops = OP_0;}break;
  case 9 : {*ops = OP_1;}break;
  case 10: {*ops = OP_2;}break;
  case 11: {*ops = OP_3;}break;

  default: {*ops = OP_NULL;}break;
 }
}

//    
//            
// true       
bool key_2_rkeys(rkeys *kb_s, volatile const keyst btn[])
{
 const int bsize = COLS*ROWS;
 bool retval = false;

 kb_s->k_am = 0;
 for(int i=0;i<bsize;i++) kb_s->a_keys[i] = OP_NULL;

 for(int i=0;i<bsize;i++)
 {
  if(btn[i]!=rls)
  {
   key_2_ops(i, kb_s->a_keys +kb_s->k_am);
   if(kb_s->a_keys[kb_s->k_am] > OP_9) retval = true;

   kb_s->k_am++;
  }
 }

 return retval;
}

//            
void ops_2_buffer(const rkeys kb_s, oprt o_buff[])
{
 const int bsize = O_BUFF_SIZE;

 //       
 for(int i=0;i<bsize;i++)
 {
  if(o_buff[i]==OP_NULL)
  {
   if(i < bsize-1) o_buff[i] = kb_s.a_keys[0];
   else
   {
    for(int n=0;n<bsize-1;n++) o_buff[n] = o_buff[n+1];
    o_buff[bsize-1] = kb_s.a_keys[0];
   }

   break;
  }
 }
}

void clear_buffer(oprt o_buff[])
{
 const int bsize = O_BUFF_SIZE;

 for(int i=0;i<bsize;i++) o_buff[i]=OP_NULL;
}

bool bsp_buffer(oprt o_buff[])
{
 const int bsize = O_BUFF_SIZE;
 bool retval = true;

 for(int i=bsize-1;i>=0;i--)
 {
  if(o_buff[i]!=OP_NULL)
  {
   o_buff[i] = OP_NULL;
   break;
  }
 }

 if(o_buff[0]==OP_NULL) retval = false;

 return retval;
}



