#define TIM_DIV 4
#define ETF SYSTEM_FRQ/TIM_DIV/1000 //2000

#define PAU  5*ETF/10 //500us pause   1000
#define P0T  5*ETF/10 //500us for '0' 1000
#define P1T 10*ETF/10 //1ms   for '1' 2000

#define IPP 130*ETF/10 //   13ms
#define IPT 90 *ETF/10 //   9ms

#define MDEV 5 //   

volatile u8 mss_rcvd [KNUM];
volatile bool rcvd_ready;

enum oprt
{
 OP_0,
 OP_1,
 OP_2,
 OP_3,
 OP_4,
 OP_5,
 OP_6,
 OP_7,
 OP_8,
 OP_9,
 OP_ENT,
 OP_BSP,
 OP_ENT_BSP,
 OP_ENT_CLS,

 OP_NULL=0xff,
};

void clear_rcvd(int i=0)
{
 const int bsize = sizeof(mss_rcvd)/sizeof(mss_rcvd[0]);

// if(mss_rcvd[0]!=(u8)OP_NULL)
 for(;i<bsize;i++)mss_rcvd[i]=(u8)OP_NULL;
}

void cfg_rcv_pin(void)
{
 static bool trg = false;

 if(!trg)
 {
  trg = true;

  GPIO_InitTypeDef GIS;

  GIS.GPIO_Speed = GPIO_Speed_2MHz;
  GIS.GPIO_Pin   = GPIO_Pin_1;
  GIS.GPIO_Mode  = GPIO_Mode_AF;
  GIS.GPIO_OType = GPIO_OType_OD;
  GIS.GPIO_PuPd  = GPIO_PuPd_UP;

  GPIO_Init(GPIOA, &GIS);
  GPIO_PinAFConfig(GPIOA, GPIO_PinSource1, GPIO_AF_2); //tim2ch2
 }
}

void cfg_rcv_tim(void)
{
 static bool trg = false;

 if(trg == false)
 {
  trg = true;

  RCC->APB1ENR |= RCC_APB1ENR_TIM2EN;

  TIM2->PSC   = TIM_DIV-1;
  TIM2->ARR   = (u16)-1;  //16ms

  TIM2->CCMR1 = 1<<12      |
                1<<4       |
                bin(01)<<8 |  //ic2 on timer input 2
                bin(10)    ;  //ic1 on timer input 2

  TIM2->SMCR  = bin(110)<<4;  //timer input 2
  TIM2->SMCR |= bin(100);     //reset mode

  TIM2->CCER  = TIM_CCER_CC2P | //ic2 & trg active on falling edge
                                //ic1 active on rising edge
                TIM_CCER_CC1E | TIM_CCER_CC2E;

  TIM2->DIER  = TIM_DIER_UIE;

  TIM2->SR    = 0;
  NVIC_SetPriority(TIM2_IRQn, 0);
  NVIC_EnableIRQ(TIM2_IRQn);

  TIM2->CR1  = TIM_CR1_CEN;
 }
}




