
volatile u32 tim0,tim1,tim2;
volatile u32 tim_led;

extern "C"
{
 void SysTick_Handler()
 {
  if(tim0)tim0--;
  if(tim1)tim1--;
  if(tim2)tim2--;
  if(tim_led)tim_led--;

  static bool trg=0;
  trg^=1;
  if(trg) kb_state = btn_scan();
 }

//-----------------------------------

 void TIM2_IRQHandler()
 {
  u32 tmp    = TIM2->SR;
  TIM2->SR   = 0;
  int pulse  = TIM2->CCR1;
  int period = TIM2->CCR2;

  bool reset_proc = false;
  //    
  static bool eor;
  //  
  static bool start_trg;
  //     
  static int im  = 0;
  //    
  static int idg = 0;

  if(rcvd_ready == false)
  {
   //         
   if(!(tmp & TIM_SR_TIF))
   {
    eor        = false;
    start_trg  = false;

    //     
    if(im || idg==7)
    {
     rcvd_ready = true;

     //  
     if(pulse < P1T-P1T/MDEV) mss_rcvd[im] &= ~(u8)1;

     im  = 0;
     idg = 0;
    }
   }
   //  
   else if(start_trg == false)
   {
    //       
    if(eor==false)
    {
     eor = true;
     reset_proc = true;
    }
    //     
    else if((period > IPP-IPP/MDEV && period < IPP+IPP/MDEV)&&
            (pulse > IPT-IPT/MDEV && pulse < IPT+IPT/MDEV))
    {
     start_trg  = true;
    }
    else eor = false;
   }

   //   
   if(reset_proc == true)
   {
    const int bsize = sizeof(mss_rcvd)/sizeof(mss_rcvd[0]);

    for(int i=0;i<bsize;i++)mss_rcvd[i]=(u8)OP_NULL;
    im  = 0;
    idg = 0;
   }
   //   
   else if(start_trg == true)
   {
    //     
    //      
    if(pulse > P0T-P0T/MDEV && pulse < P1T+P1T/MDEV)  //>800 <2400
    {
     //    
     if(pulse < P1T-P1T/MDEV)
     {
      mss_rcvd[im] &= ~(1<<7-idg);        //<1600
     }

     //        
     if(idg<7)idg++;
     else
     {
      idg = 0;

      if(im < sizeof(mss_rcvd)/sizeof(mss_rcvd[0])-1) im++;
      else start_trg = false;
     }
    }
   }
  }

  __DSB();
 }

//-----------------------------------

 void TIM16_IRQHandler()
 {
  TIM16->SR = 0;
  __DSB();
 }

//-----------------------------------

 void HardFault_Handler()
 {

  while(1)
  {
   __no_operation();

//   static volatile int k=0;
//   static bool trg;
//
//   if(k)k--;
//   else
//   {
//    trg ^=1;
//    k = 0xfffff;
//
//    if(trg)led(true);
//    else   led(false);
//   }
  }
 }

 void NMI_Handler()
 {
  //  ram parity checking fail,   
  while(1)__no_operation();
 }

 void Default_Handler()
 {

  while(1)__no_operation();
 }
}



//   Reset_Handler                  ; Reset Handler
//
//   NMI_Handler                    ; NMI Handler
//   HardFault_Handler              ; Hard Fault Handler
//   PendSV_Handler                 ; PendSV Handler
//   SysTick_Handler                ; SysTick Handler
//
//  ; External Interrupts
//   WWDG_IRQHandler                ; Window Watchdog
//   PVD_IRQHandler                 ; PVD through EXTI Line detect
//   RTC_IRQHandler                 ; RTC through EXTI Line
//   FLASH_IRQHandler               ; FLASH
//   RCC_IRQHandler                 ; RCC
//   EXTI0_1_IRQHandler             ; EXTI Line 0 and 1
//   EXTI2_3_IRQHandler             ; EXTI Line 2 and 3
//   EXTI4_MDEV_IRQHandler            ; EXTI Line 4 to MDEV
//   TS_IRQHandler                  ; TS
//   DMA1_Channel1_IRQHandler       ; DMA1 Channel 1
//   DMA1_Channel2_3_IRQHandler     ; DMA1 Channel 2 and Channel 3
//   DMA1_Channel4_5_IRQHandler     ; DMA1 Channel 4 and Channel 5
//   ADC1_COMP_IRQHandler           ; ADC1, COMP1 and COMP2
//   TIM1_BRK_UP_TRG_COM_IRQHandler ; TIM1 Break, Update, Trigger and Commutation
//   TIM1_CC_IRQHandler             ; TIM1 Capture Compare
//   TIM2_IRQHandler                ; TIM2
//   TIM3_IRQHandler                ; TIM3
//   TIM6_DAC_IRQHandler            ; TIM6 and DAC
//   0                              ; Reserved
//   TIM14_IRQHandler               ; TIM14
//   TIMMDEV_IRQHandler               ; TIMMDEV
//   TIM16_IRQHandler               ; TIM16
//   TIM17_IRQHandler               ; TIM17
//   I2C1_IRQHandler                ; I2C1
//   I2C2_IRQHandler                ; I2C2
//   SPI1_IRQHandler                ; SPI1
//   SPI2_IRQHandler                ; SPI2
//   USART1_IRQHandler              ; USART1
//   USART2_IRQHandler              ; USART2
//   0                              ; Reserved
//   CEC_IRQHandler                 ; CEC
//   0                              ; Reserved

