#pragma section=".ee_mem"
#define EE_END (u32)__section_end(".ee_mem")

#define PG_LN  0x400          //   
#define KNUM   32             //  
#define PNUM   PG_LN/(KNUM*2) //  
__no_init const u8 ir_tms[PNUM][2][KNUM] @ ".ee_mem"; //  

//  
const u32 eep_bgn = EE_END-PG_LN;


//      ir_tms  0xff   
int seek_last_free(void)
{
 int retval;
 int i;

 for(i=0;i<PNUM;i++)
 {
  for(int z=0;z<2;z++)
  for(int k=0;k<KNUM;k++)
  {
   if(ir_tms[i][z][k]!=0xff)
   {
    goto m_slf;
   }
  }

  break;

  m_slf:
  continue;
 }

 if(i == PNUM) retval = 0xff;
 else retval = i;

 return retval;
}

//    flash
//     
void save_code_in_ee(u8 *ptin)
{
 //      
 int ffrn = seek_last_free();

 __disable_interrupt();
 FLASH_Unlock();
 u16* pt_bgn;

 //     
 if(ffrn == 0xff)
 {
  // 
  while(FLASH_ErasePage((uint32_t)eep_bgn)==FLASH_BUSY) continue;
  //     
  pt_bgn = (u16*)ir_tms;
 }
 //    ,     
 else pt_bgn = (u16*)ir_tms[ffrn];

 // 
 for(int k = 0;k<KNUM/2;k++)
  while(FLASH_ProgramHalfWord((uint32_t)(pt_bgn+k), *((uint16_t*)ptin+k)) ==FLASH_BUSY) continue;

 pt_bgn = (u16*)ir_tms[ffrn][1];

 // 
 for(int k = 0;k<KNUM/2;k++)
  while(FLASH_ProgramHalfWord((uint32_t)(pt_bgn+k), ~*((uint16_t*)ptin+k)) ==FLASH_BUSY) continue;

 FLASH_Lock();
 __enable_interrupt();
}

//       
//      0xff
int get_ee_index(void)
{
 int ffrn = seek_last_free();

 if(ffrn == 0)        return 0xff;
 else if(ffrn !=0xff) return ffrn-1;
 else                 return PNUM-1;
}

//     
//   
bool chk_code_in_flash(int index=0)
{
 bool result = true;
 int k = index;

 for(int i=0;i<KNUM;i++)
 {
  u8 a0 = ir_tms[k][0][i];
  u8 a1 = ~ir_tms[k][1][i];

  if(a0 != a1)
  {
   result = false;
   break;
  }
 }

 return result;
}

//        flash
//    ram,     flash,    
bool cmp_code(const u8 rcode[], int index=0, u8 size = KNUM)
{
 bool result = true;

 for(u8 i = 0;i<size;i++)
 {
  if(ir_tms[index][0][i]!= rcode[i])
  {
   result = false;
   break;
  }
 }

 return result;
}