

void delay_us(u32 tus)
{
 TIM2->EGR = TIM_EGR_UG;
 TIM2->ARR = tus * (system_frq/(u32)1E6);  
 TIM2->CR1 = TIM_CR1_OPM|TIM_CR1_URS|TIM_CR1_CEN;
 TIM2->SR  = 0;

 while(TIM2->SR == 0)__NOP();
}

bool time_out(u32 tus)
{
 bool trg=0;
 
 if(!trg)
 {
  TIM2->EGR = TIM_EGR_UG;
  TIM2->ARR = tus * (system_frq/(u32)1E6);  
  TIM2->CR1 = TIM_CR1_OPM|TIM_CR1_URS|TIM_CR1_CEN;
  TIM2->SR  = 0;
 
  trg=1; 
 }
 
 if(TIM2->SR != 0) 
 {
  return 1;
  trg=0;
 }
 
 return 0; 
}

u32 check_time(bool start)
{
 if(start)
 {
  TIM2->EGR = TIM_EGR_UG;
  TIM2->ARR = (u32)((u64)2E32-1);  
  TIM2->CR1 = TIM_CR1_OPM|TIM_CR1_URS|TIM_CR1_CEN;
  TIM2->SR  = 0;  
 }
 
 return TIM2->CNT;  
}

void pulse_t16(u16 p_us)
{
 TIM16->CCMR1 = force_inactive|TIM_CCMR1_OC1PE;
 TIM16->CCR1  = p_us << 3;   //time_us * system_frq/1E6 
 TIM16->ARR   = TIM16->CCR1 + 0x0f;

 TIM16->CCMR1 = active_on_match|TIM_CCMR1_OC1PE;
 TIM16->EGR   = TIM_EGR_UG;
  
 TIM16->CR1   = TIM_CR1_OPM|TIM_CR1_CEN;  
}
