#define TIM_CAR TIM17
#define TIM_ENV TIM16

#define TIM_DIV 4
#define ETF SYSTEM_FRQ/TIM_DIV/1000
#define PAU  5*ETF/10 //500us pause
#define P0T  5*ETF/10 //500us for '0'
#define P1T 10*ETF/10 //1ms   for '1'

#define MSS2S_SZ (O_BUFF_SIZE*(sizeof(oprt)*8))*3 +3

int convert_m2s(u16 out[], const oprt in[], int bsize = O_BUFF_SIZE)
{
 int index = 0;

 out[index++] = 13*ETF;//   13ms
 out[index++] = 0;
 out[index++] = 9*ETF;//   9ms

 for(int i = 0;i<bsize;i++)
 {
  int y = (int)in[i];

  if((oprt)y == OP_NULL) break;

  for(int n=0;n<8;n++)
  {
   // 
   if(y & 0x80) out[index++] = P1T+PAU;
   else         out[index++] = P0T+PAU;

   out[index++] = 0;

   // 
   if(y & 0x80) out[index++] = P1T;
   else         out[index++] = P0T;

   y = y<<1;
  }
 }

 for(int i=index; i<MSS2S_SZ; i++) out[i]=0;

 return index;
}

void cfg_irtms(int cr_frq = 38000)
{
 RCC->APB2ENR |= RCC_APB2ENR_TIM16EN | RCC_APB2ENR_TIM17EN;

 GPIO_PinAFConfig(GPIOA, GPIO_PinSource13, GPIO_AF_1); //ir_out


 /* Configure TIM_CAR as carrier signal */
 TIM17->ARR   = (u16)(SYSTEM_FRQ/cr_frq -1);
 TIM17->CCR1  = TIM17->ARR / 3;
 TIM17->CCMR1 = pwm1;
 TIM17->CCER  = TIM_CCER_CC1E;
 TIM17->BDTR  = TIM_BDTR_MOE;

 /* Configure TIM_ENV is the modulation envelope */
 TIM16->PSC   = TIM_DIV-1;
 TIM16->ARR   = (u16)-1-1;
 TIM16->CCR1  = (u16)-1-1;
 TIM16->CCMR1 = pwm1;
 TIM16->CCER  = TIM_CCER_CC1E;
 TIM16->BDTR  = TIM_BDTR_MOE;

 TIM16->DIER  = TIM_DIER_UDE;

 TIM16->DCR   = 2<<8 | //3 transferts burst
                ((u32)&TIM16->ARR - (u32)&TIM16->CR1)/sizeof(u32); //11; //offset from CR1 to ARR

 TIM16->CNT   = 1;

 TIM17->CR1   = TIM_CR1_CEN;
 TIM16->CR1   = TIM_CR1_CEN;

 TIM17->SR    = 0;
 TIM16->SR    = 0;
 TIM16->EGR   = TIM_EGR_UG;
}

//   GPIOA.13         flash
bool send_data(u8 *dmp = NULL, int size = O_BUFF_SIZE)
{
 u16 mss_2send[MSS2S_SZ];
 static bool trg;
 static bool dmp_trg;

 if(!trg)
 {
  trg = true;

  if(dmp != NULL)
  {
   dmp_trg = 1;

   //     
   int i = convert_m2s(mss_2send, (oprt const*)dmp, size);


   //           dma
   //    .   ARR,   RCR( 0), CCR1
   RCC->AHBENR         |= RCC_AHBENR_DMA1EN;
   DMA1_Channel3->CPAR  = (uint32_t)&TIM16->DMAR;
   DMA1_Channel3->CMAR  = (uint32_t)mss_2send;
   DMA1_Channel3->CNDTR = i;
   DMA1_Channel3->CCR   = DMA_CCR_MINC    | //memory incremental mode
                          DMA_CCR_MSIZE_0 | //16 bit
                          DMA_CCR_PSIZE_0 | //16 bit
                          DMA_CCR_PL      | //vh priority
                          DMA_CCR_DIR     | //read from memory
                          DMA_CCR_EN;

   //       _  burst dma
   cfg_irtms();
  }
 }


 if(dmp_trg)
 {
  //  
  if(DMA1->ISR & DMA_ISR_TCIF3)
  {
   //   dma1
   DMA1->IFCR = DMA_IFCR_CGIF3;
   //  
   DMA1_Channel3->CCR = 0;
   RCC->AHBENR       &= ~RCC_AHBENR_DMA1EN;

   TIM16->SR = 0;
   __DSB();
   while(!TIM16->SR)void();

   //  SWDAT(pullup)     
   GPIO_PinAFConfig(GPIOA, GPIO_PinSource13, GPIO_AF_0);

   RCC->APB2ENR &= ~(RCC_APB2ENR_TIM16EN | RCC_APB2ENR_TIM17EN);

   trg = false;
   dmp_trg = false;
   return true;
  }
 }
 else
 {
  trg = false;
  return true;
 }

 return false;
}