
 void cfg_rcc()
 {
  RCC->AHBENR  |= RCC_AHBENR_GPIOAEN | RCC_AHBENR_GPIOBEN | RCC_AHBENR_GPIOFEN;
  RCC->APB1ENR |= RCC_APB1ENR_PWREN;
  RCC->AHBENR  |= RCC_AHBENR_DMA1EN;
 }

 void cfg_gpio()
 {
  GPIO_InitTypeDef GIS;

  GIS.GPIO_Speed = GPIO_Speed_2MHz;

  //PA9 - led output
  GIS.GPIO_Pin   = GPIO_Pin_9;
  GIS.GPIO_Mode  = GPIO_Mode_OUT;
  GIS.GPIO_OType = GPIO_OType_PP;
  GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;

  GPIO_Init(GPIOA, &GIS);
  
  //PF1,PF0 - reset pullup
  GIS.GPIO_Pin   = GPIO_Pin_0|GPIO_Pin_1;
  GIS.GPIO_Mode  = GPIO_Mode_AN;
  GIS.GPIO_OType = GPIO_OType_OD;
  GIS.GPIO_PuPd  = GPIO_PuPd_UP;

  GPIO_Init(GPIOF, &GIS);
 }

 void cfg_systic(int frq)
 {
  SysTick->LOAD  = SYSTEM_FRQ/frq-1;
  NVIC_SetPriority (SysTick_IRQn, 3);
  SysTick->CTRL  = SysTick_CTRL_CLKSOURCE_Msk|SysTick_CTRL_TICKINT_Msk|SysTick_CTRL_ENABLE_Msk;
 }

 void cfg_exti()
 {
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_SYSCFG, ENABLE);
//  SYSCFG_EXTILineConfig(EXTI_PortSourceGPIOA,EXTI_PinSource6);
//  SYSCFG_EXTILineConfig(EXTI_PortSourceGPIOA,EXTI_PinSource7);
//  SYSCFG_EXTILineConfig(EXTI_PortSourceGPIOA,EXTI_PinSource9);
//  SYSCFG_EXTILineConfig(EXTI_PortSourceGPIOA,EXTI_PinSource10);
  SYSCFG_EXTILineConfig(EXTI_PortSourceGPIOB,EXTI_PinSource1);
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_SYSCFG, DISABLE);

  EXTI_InitTypeDef EIS;

  EIS.EXTI_Line    = EXTI_Line1|EXTI_Line2|EXTI_Line5;
  EIS.EXTI_Mode    = EXTI_Mode_Interrupt;
  EIS.EXTI_Trigger = EXTI_Trigger_Rising;//EXTI_Trigger_Falling;
  EIS.EXTI_LineCmd = ENABLE;

  EXTI_Init(&EIS);
  EXTI_ClearFlag(EXTI_Line1|EXTI_Line6|EXTI_Line7|EXTI_Line9|EXTI_Line10);
 }

FLASH_Status FLASH_OB_UBC(uint8_t input_val) //0x9f vdda_off parity_on, 0xdf vdda_off
{
  FLASH_Status status = FLASH_COMPLETE;

  if((OB->USER & 0xff) != input_val)
  {
   /* Wait for last operation to be completed */
   status = FLASH_WaitForLastOperation(FLASH_ER_PRG_TIMEOUT);

   if(status == FLASH_COMPLETE)
   {
    __disable_interrupt();
    FLASH_Unlock();
    FLASH_OB_Unlock();

    uint8_t tmp_mss[sizeof(*OB)/sizeof(uint16_t)];
    uint16_t *pt = (uint16_t *)OB;

    for(int i=0; i<sizeof(*OB)/sizeof(uint16_t);i++) tmp_mss[i] = uint8_t(*pt++);

     FLASH->CR |= FLASH_CR_OPTER;
     FLASH->CR |= FLASH_CR_STRT;

     while((FLASH_WaitForLastOperation(FLASH_ER_PRG_TIMEOUT)==FLASH_BUSY))__no_operation();

     FLASH->CR &= ~FLASH_CR_OPTER;
     FLASH->CR |= FLASH_CR_OPTPG;

     OB->RDP  = tmp_mss[0];
     while((FLASH_WaitForLastOperation(FLASH_ER_PRG_TIMEOUT)==FLASH_BUSY))__no_operation();

     OB->USER = input_val; //ram parity on, vdda mon off //0xdf; vdda mon on

     for(int i=2; i<sizeof(*OB)/sizeof(uint16_t);i++)
     {
      pt    = (uint16_t *)OB +2;
      *pt++ = tmp_mss[i];
      while((FLASH_WaitForLastOperation(FLASH_ER_PRG_TIMEOUT)==FLASH_BUSY))__no_operation();
     }

     /* Wait for last operation to be completed */
     status = FLASH_WaitForLastOperation(FLASH_ER_PRG_TIMEOUT);

     if(status != FLASH_TIMEOUT)
     {
       /* if the program operation is completed, disable the OPTPG Bit */
       FLASH->CR &= ~FLASH_CR_OPTPG;
       FLASH_OB_Lock();
       FLASH_Lock();

       FLASH_OB_Launch();
     }
   }
  }
  /* Return the Option Byte program Status */
  return status;
}








