/********************************************************
Workspace: IAR_ARM+SPL
MCU      : STM32f050f4/6
Project  : code lock ir transmitter
Version  :
Date     : May 2019
*********************************************************/

#include <stm32f0xx.h>
#include <stdbool.h>
#include <uchar.h>

#include "stm32f0xx_syscfg.c"
#include "stm32f0xx_rcc.c"
#include "stm32f0xx_gpio.c"
#include "stm32f0xx_flash.c"
#include "stm32f0xx_exti.c"
#include "stm32f0xx_misc.c"
#include "stm32f0xx_pwr.c"
#include "stm32f0xx_dma.c"

#include "bitset.c"
#include "defines.c"
#include "periph_cfg.c"

#include "fae.c"
#include "kb.c"
#include "key_work.c"
#include "led.c"
#include "pulse_work.c"
#include "psu_mon.c"

#include "interrupts.c"



void main()
{
 cfg_rcc();
 cfg_gpio();

 cfg_systic(1000);

 kb_init();
 cfg_exti();

 led(true);

 __enable_interrupt();

 tim0 = 500;
 while(tim0)clear_buffer(o_buff);

// if((FLASH->OBR & FLASH_OBR_VDDA_MONITOR)!=0)
//  while(FLASH_OB_UBC(0x9f)==FLASH_BUSY)__no_operation();

 tim0 = 500;

 while(1)
 {
  if(tim0)
  {
   static bool kb_trg;
   static bool ent_trg;
   static bool bsp_trg;

   //   stop     
   if(kb_state==true)
   {
    tim0 = 1000;
    led(true);

    rkeys kb_s;
    //   
    if(key_2_rkeys(&kb_s, btn)==true)
    {
     for(int i=0;i<kb_s.k_am;i++)
     {
      if     (kb_s.a_keys[i] == OP_ENT) ent_trg = true;
      else if(kb_s.a_keys[i] == OP_BSP) bsp_trg = true;
     }
    }
    //       
    else
    {
     if(kb_trg==false)
     {
      kb_trg = true;
      ops_2_buffer(kb_s, o_buff);
     }
    }
   }
   else
   {
    kb_trg = 0;

   //   (<> 2,2V)
    if(PWR_GetFlagStatus(PWR_FLAG_PVDO)==SET)
    //Vdd < PVD trs
    {
     static bool trg;

     if(!tim2)
     {
      tim2 = 200;
      trg^=1;

      if(trg) led(true);
      else    led(false);
     }
    }
    //Vdd > PVD trs
    else led(false);
   //  

    //      
    if(ent_trg && bsp_trg)
    {
     u8 tmp = (u8)OP_ENT_BSP;

     //   
     while(send_data(&tmp, 1)==false)tim0 = 100;
    }
    else if(ent_trg)
    {
     //          OP_NULL
     if(o_buff[0] != OP_NULL)
     {
      while(send_data((u8*)o_buff)==false)tim0 = 100;
      clear_buffer(o_buff);
     }
     //         
     else
     {
      u8 tmp = (u8)OP_ENT_CLS;

      //   
      while(send_data(&tmp, 1)==false)tim0 = 100;
     }
    }
    else if(bsp_trg)
    {
     //     
     bsp_buffer(o_buff);
    }

    ent_trg = false;
    bsp_trg = false;
   }
  }
  else //   stop       
  {
//tim0 = 1000;
   disable_PVD();

   led(false);
   //    ,        
   kb_init();
   //             
   col_pull(GPIO_PuPd_UP);

   EXTI_ClearFlag(EXTI_Line1|EXTI_Line2|EXTI_Line5);
   NVIC_EnableIRQ(EXTI4_15_IRQn);
   NVIC_EnableIRQ(EXTI2_3_IRQn);
   NVIC_EnableIRQ(EXTI0_1_IRQn);

   PWR_EnterSTOPMode(PWR_Regulator_LowPower, PWR_STOPEntry_WFI);

   //  
   col_pull(GPIO_PuPd_NOPULL);
   //   
   enable_PVD();
  }
 }
}