#include <kb.h>

/*
 MODER  00->input, 01->output, 10->AF, 11->analog
 OTYPER 0->PP, 1->OD
 PUPDR  00-> nopull, 01-> pullup, 10-> pulldn

*/

void kb_init (void)
{
 //   PP 
 for(int i=0;i<sizeof(GPIO_cols)/sizeof(GDF);i++)
 {
  GPIO_cols[i].GPIOx->MODER  &= ~(3 << GPIO_cols[i].shift*2);
  GPIO_cols[i].GPIOx->MODER  |=   1 << GPIO_cols[i].shift*2; //output

  GPIO_cols[i].GPIOx->OTYPER &= ~(1 << GPIO_cols[i].shift);  //push pull

  GPIO_cols[i].GPIOx->PUPDR  &= ~(3 << GPIO_cols[i].shift*2);//no pull
  GPIO_cols[i].GPIOx->BSRR    =   1 << GPIO_cols[i].shift;   //pin up
 }

 //        
 for(int i=0;i<sizeof(GPIO_rows)/sizeof(GDF);i++)
 {
  GPIO_rows[i].GPIOx->MODER &= ~(3 << GPIO_rows[i].shift*2); //input

  GPIO_rows[i].GPIOx->PUPDR &= ~(3 << GPIO_rows[i].shift*2);
  GPIO_rows[i].GPIOx->PUPDR |=   2 << GPIO_rows[i].shift*2;  //pulldn
 }
}

void col_pull(GPIOPuPd_TypeDef pupd)
{
 for(int i=0;i<sizeof(GPIO_cols)/sizeof(GDF);i++)
 {
  GPIO_cols[i].GPIOx->PUPDR  &= ~(3 << GPIO_cols[i].shift*2);
  GPIO_cols[i].GPIOx->PUPDR  |= pupd << GPIO_cols[i].shift*2;
 }
}

//  
//   enum_ 
// true       
bool kb_scan(void)
{
 static u8 count[COLS*ROWS][3];
 bool retval = false;

 for(int k=0;k<COLS;k++)
 {
  //    
  GPIO_cols[k].GPIOx->MODER  &= ~(2 << GPIO_cols[k].shift*2); //moder: 01

  //     
  for(int i=0;i<ROWS;i++)
  {
   int pos = k + i*COLS;

   //     
   volatile bool input = !(GPIO_rows[i].GPIOx->IDR & (1<<GPIO_rows[i].shift));

   // 
   key_coll(input, count, (keyst*)btn, pos);

   if(btn[pos]!= rls) retval = true;
  }

  //     
  GPIO_cols[k].GPIOx->MODER  |= 2 << GPIO_cols[k].shift*2;   //moder 11
 }

 return retval;
}

void key_coll(const bool input, u8 count[][3], keyst btn[], const u8 pos)
{
 //  
 if (!input)
 {
  if(count[pos][0]>LP)
  {
   count[pos][0]=0;

   if(btn[pos]==rls) btn[pos]=prs;

   if(count[pos][1]>LH)
   {
    btn[pos]=hold;
    count[pos][1]=0;
   }
   else
    count[pos][1]++;
  }
  else
   count[pos][0]++;

  count[pos][2]=LR;
 }
 else //   ,       
 {
  if(count[pos][2])
   count[pos][2]--;
  else
  {
   count[pos][0]=0;
   count[pos][1]=0;

   btn[pos]=rls;
  }
 }
}

//________________________________________________

