#define IR_POW  GPIO_Pin_0
#define IR_DATA GPIO_Pin_1

const int szm = sizeof(ir_tms[0])/sizeof(ir_tms[0][0]);
volatile u16 mss_rcvd [szm];
volatile bool rcvd_ready;

void clear_rcvd(void)
{
 for(int i=0;i<szm;i++)mss_rcvd[i]=0;
}

bool rcv_on(volatile u32 *tmr)
{
 static bool trg=0;

 if(!trg)
 {
  trg = 1;
  *tmr = 100;

  GPIO_InitTypeDef GIS;

  GIS.GPIO_Speed = GPIO_Speed_2MHz;
  GIS.GPIO_Pin   = IR_POW;
  GIS.GPIO_Mode  = GPIO_Mode_OUT;
  GIS.GPIO_OType = GPIO_OType_PP;
  GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;

  GPIO_Init(GPIOA, &GIS);
  GPIOA->BSRR    = IR_POW;

  GIS.GPIO_Pin   = IR_DATA;
  GIS.GPIO_Mode  = GPIO_Mode_AF;
  GIS.GPIO_OType = GPIO_OType_OD;
  GIS.GPIO_PuPd  = GPIO_PuPd_UP;

  GPIO_Init(GPIOA, &GIS);
  GPIO_PinAFConfig(GPIOA, GPIO_PinSource1, GPIO_AF_2); //tim2ch2
 }

 if(!(*tmr))
 {
  trg = 0;
  return true;
 }

 return false;
}

void rcv_off(void)
{
  GPIO_InitTypeDef GIS;

  GIS.GPIO_Speed = GPIO_Speed_2MHz;
  GIS.GPIO_Pin   = IR_POW|IR_DATA;
  GIS.GPIO_Mode  = GPIO_Mode_AN;
  GIS.GPIO_OType = GPIO_OType_OD;
  GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;

  GPIO_Init(GPIOA, &GIS);
}

void init_rcv_tim(void)
{
 RCC->APB1ENR |= RCC_APB1ENR_TIM2EN;

 TIM2->PSC   = 6;
 TIM2->ARR   = (u16)-1;  //16ms

 TIM2->CCMR1 = 1<<12      |
               1<<4       |
               bin(01)<<8 |  //ic2 on timer input 2
               bin(10)    ;  //ic1 on timer input 2

 TIM2->SMCR  = bin(110)<<4;  //timer input 2
 TIM2->SMCR |= bin(100);     //reset mode

 TIM2->CCER  = TIM_CCER_CC2P | //ic2 & trg active on falling edge
                               //ic1 active on rising edge
               TIM_CCER_CC1E | TIM_CCER_CC2E;

 TIM2->DIER  = TIM_DIER_TIE;

 TIM2->SR    = 0;
 NVIC_SetPriority(TIM2_IRQn, 0);
 NVIC_EnableIRQ(TIM2_IRQn);
}

void deinit_rcv_tim(void)
{
 u32 tmp = RCC->APB1ENR;
 tmp &= ~RCC_APB1ENR_TIM2EN;
 RCC->APB1ENR = tmp;
}

int recieve_proc(volatile u32 *timeout)
{
 static bool trg=0;

 if(trg==false)
 {
  trg = true;
  rcvd_ready = false;

  while(rcv_on(timeout)==false) clear_rcvd();//__no_operation();
  init_rcv_tim();
  *timeout = 15000;
 }

 if(rcvd_ready == true)
 {
  trg = false;
  deinit_rcv_tim();

  return 1;
 }
 else if(*timeout == 0)
 {
  trg = false;
  deinit_rcv_tim();

  return -1;
 }

 return 0;
}


