
 void cfg_rcc()
 {
  RCC->AHBENR  |= RCC_AHBENR_GPIOAEN | RCC_AHBENR_GPIOBEN | RCC_AHBENR_GPIOFEN;
  RCC->APB1ENR |= RCC_APB1ENR_PWREN;
  RCC->AHBENR  |= RCC_AHBENR_DMA1EN;
 }

 void cfg_gpio()
 {
  GPIO_InitTypeDef GIS;

  GIS.GPIO_Speed = GPIO_Speed_2MHz;

  //PA2 - led output
  GIS.GPIO_Pin   = GPIO_Pin_2;
  GIS.GPIO_Mode  = GPIO_Mode_OUT;
  GIS.GPIO_OType = GPIO_OType_OD;
  GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;

  GPIO_Init(GPIOA, &GIS);

  //PA1 - data input from infrared reciever - AF for timer  2
  GIS.GPIO_Pin   = GPIO_Pin_1;
  GIS.GPIO_Mode  = GPIO_Mode_AN;
  GIS.GPIO_OType = GPIO_OType_OD;
  GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;

  GPIO_Init(GPIOA, &GIS);

  //PA0 - power for infrared reciever
  GIS.GPIO_Pin   = GPIO_Pin_0;
  GIS.GPIO_Mode  = GPIO_Mode_AN;
  GIS.GPIO_OType = GPIO_OType_OD;
  GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;

  GPIO_Init(GPIOA, &GIS);

 //PF1,PF0 - reset pullup
  GIS.GPIO_Pin   = GPIO_Pin_0|GPIO_Pin_1;
  GIS.GPIO_Mode  = GPIO_Mode_AN;
  GIS.GPIO_OType = GPIO_OType_OD;
  GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;

  GPIO_Init(GPIOF, &GIS);
 }

 void cfg_systic(int frq)
 {
  SysTick->LOAD  = SYSTEM_FRQ/frq-1;
  NVIC_SetPriority (SysTick_IRQn, 3);
  SysTick->CTRL  = SysTick_CTRL_CLKSOURCE_Msk|SysTick_CTRL_TICKINT_Msk|SysTick_CTRL_ENABLE_Msk;
 }

 void cfg_exti()
 {
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_SYSCFG, ENABLE);
//  SYSCFG_EXTILineConfig(EXTI_PortSourceGPIOA,EXTI_PinSource6);
//  SYSCFG_EXTILineConfig(EXTI_PortSourceGPIOA,EXTI_PinSource7);
//  SYSCFG_EXTILineConfig(EXTI_PortSourceGPIOA,EXTI_PinSource9);
//  SYSCFG_EXTILineConfig(EXTI_PortSourceGPIOA,EXTI_PinSource10);
  SYSCFG_EXTILineConfig(EXTI_PortSourceGPIOB,EXTI_PinSource1);
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_SYSCFG, DISABLE);

  EXTI_InitTypeDef EIS;

  EIS.EXTI_Line    = EXTI_Line1|EXTI_Line6|EXTI_Line7|EXTI_Line9|EXTI_Line10;
  EIS.EXTI_Mode    = EXTI_Mode_Interrupt;
  EIS.EXTI_Trigger = EXTI_Trigger_Rising;//EXTI_Trigger_Falling;
  EIS.EXTI_LineCmd = ENABLE;

  EXTI_Init(&EIS);
  EXTI_ClearFlag(EXTI_Line1|EXTI_Line6|EXTI_Line7|EXTI_Line9|EXTI_Line10);
 }








