/********************************************************
Workspace: IAR_ARM+SPL
MCU      : STM32f050f4/6
Project  : ir_repcom
Version  :
Date     : May 2019     VDDA   option   1uA
*********************************************************/

#include <stm32f0xx.h>
#include <stdbool.h>

#include "stm32f0xx_syscfg.c"
#include "stm32f0xx_rcc.c"
#include "stm32f0xx_gpio.c"
#include "stm32f0xx_flash.c"
#include "stm32f0xx_exti.c"
#include "stm32f0xx_misc.c"
#include "stm32f0xx_pwr.c"
#include "stm32f0xx_dma.c"

#include "bitset.c"
#include "defines.c"
#include "periph_cfg.c"

#include "fae.c"
#include "kb.c"
#include "led.c"
#include "pulse_work.c"
#include "ir_rcv_work.c"

#include "interrupts.c"



void main()
{
 cfg_rcc();
 cfg_gpio();

 cfg_systic(1000);

 kb_init();
 cfg_exti();

 led(true);
 tim0 = 2000;

 __enable_interrupt();


 while(1)
 {
//tim0 = 1000;
  if(tim0)
  {
   static int kb_subset=0;
   static bool upwerk_trg; //    

   bool kb_state = kb_scan();

   //   stop     
   if(kb_state==true)
   {
    tim0 = 1000;
    tim2 = 10;
   }

   if(tim2)led(true);
   else    led(false);

   //             
   //         ,
   //         _
   //       
   for(int i=0;i<3;i++)
   {
    if(btn[i]==prs)
    {
     kb_subset = i;     // 
     upwerk_trg = true; //     
    }
    else if(btn[i]==hold)
    {
     //        
     //        
     //  
     for(int y=3;y<COLS*ROWS;y++)
     {
      if(btn[y]!=rls)
      {
       //     
       led (true);

       m:

       //  
       int rp_rv = recieve_proc(&tim2);

       //    _
       if(rp_rv == 0) goto m;
       //   
       else if(rp_rv == -1)
       {

       }
       // 
       else
       {
        //   o flash
        save_position((u16*)mss_rcvd, (u16*)ir_tms[y+(kb_subset*KNUM/3)]);
       }

       led (false);

       i=4; //   
       break;
      }
     }
    }
   }

   //   _   
   //       
   if(upwerk_trg == true)
   {
    if(kb_state == false) upwerk_trg = false;
   }
   else
   {
    static u8 btrg[COLS*ROWS-3];

    //  
    for(int i=3;i<COLS*ROWS;i++)
    {
     if(btn[i]==prs)
     {
      if(!btrg[i-3])
      {
       btrg[i-3] = 1;
       send_data((u16*)ir_tms[i+(kb_subset*KNUM/3)]);
      }
      break;
     }
     else if(btn[i]==hold)
     {
      //    
      if(!tim1)
      {
       send_data((u16*)ir_tms[i+(kb_subset*KNUM/3)]);
       tim1 = 300;
      }
      break;
     }
     else
     {
      btrg[i-3] = 0;

     }
    }
   }

   PWR_EnterSleepMode(PWR_SLEEPEntry_WFI);
  }
  else //   stop       
  {
   led(false);
   //    ,        
   kb_init();
   //             
   col_pull(GPIO_PuPd_UP);

   EXTI_ClearFlag(EXTI_Line1|EXTI_Line6|EXTI_Line7|EXTI_Line9|EXTI_Line10);
   NVIC_EnableIRQ(EXTI4_15_IRQn);
   NVIC_EnableIRQ(EXTI0_1_IRQn);

   PWR_EnterSTOPMode(PWR_Regulator_LowPower, PWR_STOPEntry_WFI);

   //  
   col_pull(GPIO_PuPd_NOPULL);
  }
 }
}