#pragma section=".ee_mem"
#define EE_END (u32)__section_end(".ee_mem") 

#define PG_LN  0x400                   //   
#define PG_NUM 8                       //     flash
#define CBUF   PG_LN*PG_NUM/sizeof(u16)// 16_    flash
#define KNUM   39                      //  
#define BPC    CBUF/KNUM               //112      


__no_init const u16 ir_tms[KNUM][BPC] @ ".ee_mem"; //    
//  
const u32 pages_bgn[PG_NUM] =
{EE_END-PG_LN*(PG_NUM-7),EE_END-PG_LN*(PG_NUM-6),EE_END-PG_LN*(PG_NUM-5),EE_END-PG_LN*(PG_NUM-4),
 EE_END-PG_LN*(PG_NUM-3),EE_END-PG_LN*(PG_NUM-2),EE_END-PG_LN*(PG_NUM-1),EE_END-PG_LN*(PG_NUM-0)};


//  a 
//          
// u16 tms[BPC];  u16 tms[sizeof(ir_tms[0]/2);
// save_position(tms, (u16*)ir_tms[1]);
void save_position(u16 ir_tms[], u16* mpos)
{
 bool pages[4] ={0};

 u32 addr_fst = (u32)(mpos);      //   flash     
 u32 addr_lst = addr_fst + BPC*sizeof(u16); //   

 //           
 for(int i=0;i<PG_NUM;i++)
 {
  //    flash       
  //            
  //         flash  
  if(addr_fst >= pages_bgn[i])
  {
   pages[i] = 1;
   //    flash      
   if(!i) break;
   //           
   else if(addr_lst >= pages_bgn[i-1]) pages[i-1] = 1;

   break;
  }
 }

 //    
 for(int i=0;i<PG_NUM;i++)
 {
  //     
  if(pages[i]==true)
  {
   //       
   u16 *pt_bgn;
   u16 *pt_end;
   //       
   int index_bgn;
   int index_end;

   //   flash        
   if((u16*)addr_fst < (u16*)pages_bgn[i])
   {
    pt_bgn = (u16*)pages_bgn[i];
    index_bgn = int((u16*)pages_bgn[i] - (u16*)addr_fst);
   }
   //    
   //         flash
   else
   {
    pt_bgn = (u16*)addr_fst;
    index_bgn = 0;
   }

   //    
   if(i)  //     
   {
    //       
    if((u16*)addr_lst > (u16*)pages_bgn[i-1]) pt_end = (u16*)pages_bgn[i-1];
    else                                      pt_end = (u16*)addr_lst;
   }
   else
   {
    if((u16*)addr_lst > (u16*)EE_END)         pt_end = (u16*)EE_END;
    else                                      pt_end = (u16*)addr_lst;
   }

   index_end =  int(pt_end-pt_bgn) + index_bgn;

   bool trg = true;
   int n=0;

   //         
   for(int k = index_bgn;k<index_end;k++)
   {
    if(ir_tms[k] != *(pt_bgn+n))
    {
     trg = false;
     break;
    }
    n++;
   }

   //   
   if(trg==false)
   {
    trg = true;

    FLASH_Unlock();

    //      
    for(int k = 0;k<pt_end-pt_bgn;k++)
    {
     if(*(pt_bgn+k)!= 0xffff)
     {
      trg = false;
      break;
     }
    }

    //      
    if(trg == false)
    {
     u16 buffer[PG_LN/sizeof(u16)];
     u16 *pt = (u16*)pages_bgn[i];

     //   
     for(int k = 0;k < sizeof(buffer)/sizeof(u16);k++) buffer[k] = *pt++;

     //       
     int m_shift = (int)(pt_bgn - (u16*)pages_bgn[i]);

     n=0;

     //      
     for(int z = index_bgn;z<index_end;z++)
     {
      buffer[m_shift+n] = ir_tms[z];
      n++;
     }

     // 
     while(FLASH_ErasePage((uint32_t)pages_bgn[i])==FLASH_BUSY)__no_operation();

     //     
     for(int h=0;h<sizeof(buffer)/sizeof(u16);h++)
      while(FLASH_ProgramHalfWord((uint32_t)(pages_bgn[i]+h*2), buffer[h])==FLASH_BUSY)__no_operation();
    }
    //  ,       ram     flash
    //         flash
    else
    {
     n = 0;

     for(int k = index_bgn;k<index_end;k++)
     {
      while(FLASH_ProgramHalfWord((uint32_t)(pt_bgn+n), ir_tms[k]) ==FLASH_BUSY)__no_operation();

      n++;
     }
    }
   }
  }

  FLASH_Lock();
 }
}

//void void(void);




