/********************************************************
Workspace: IAR
Chip type: MEGA8A
Project  : Amplipulse_V2_AVR
Date     : Mar,2019
Version  : 1
*********************************************************/

#include <ioavr.h>
#include <intrinsics.h>
#include <stdbool.h>
#include <stdlib.h>
#include <math.h>

#include <bitset.c>

#include "defines.c"
#include "ee_work.c"
#include "periph_init.c"
#include "display_work.c"
#include "kb.c"
#include "adc_work.c"
#include "pwm_work.c"
#include "i_stab_process.c"


u16 tim0, //display
    tim1, //sigtimer
    tim2, //adc
    tim3; //display
u32 proc_timer; //  

volatile bool iwdg_t1;

u8* qwave_pt   = qw.lf_qwave;
u8  qwave_size = 1;
u8  psc        = 0;
u8  amp;

volatile bool eowr;

void devcon();

extern "C"
{
 #pragma vector = TIMER1_OVF_vect
 __interrupt void ih_a(void)
 {
  static bool eow = false;
  static u8* tmp_pt = qwave_pt;
  static u8  tmp_msize = qwave_size;
  static u8  tmp_psc;

  static u8  mp_psc=1;
  static u8  pwm_vol;
  static u8  i=0;

  //  
  if(eow == false)
  {
   tmp_pt    = qwave_pt;
   tmp_msize = qwave_size;
   tmp_psc   = psc;

   eowr = true;
   eow  = true;
  }

  if(TCCR1A)
  {
   #define DTV 1

   u8 oc_tmp =  128/2 + s8((s16)hf_wave[i]*pwm_vol >>9);

   if(oc_tmp<DTV)            oc_tmp = DTV;
   else if(oc_tmp > 128-DTV) oc_tmp = 128-DTV;

   OCR1AL = oc_tmp-DTV;
   OCR1BL = oc_tmp+DTV;

   (i < sizeof(hf_wave)-1)?i++:i=0;

   //       
   if(!i)
   {
    if(!mp_psc)
    {
     static u8 k;

     mp_psc = tmp_psc;

     static bool m_trg;
     if(m_trg)
     {
      if(k<tmp_msize-1)k++;
      else m_trg = 0;
     }
     else
     {
      if(k) k--;
      else
      {
       m_trg = 1;
       eow = false;
      }
     }

     //  
     pwm_vol = *(tmp_pt+k) *(u16)amp >>8;
    }
    else mp_psc--;
   }
  }
  else eow = 0;

  static u16 cntdn;

  if(cntdn)cntdn--;
  else
  {
   cntdn = SPWM_FRQ/1000;
   iwdg_t1   = 1;
  }
 }
}

void main()
{
 cfg.gpio();
 cfg.t1();
 cfg.iee();

#ifndef debug
 cfg.iwdg();
#endif

 __enable_interrupt();


m:
 {
  devcon();

  if(iwdg_t1)
  {
   static bool trg;

   iwdg_t1=0;

   if(tim0)tim0--;
   if(tim1)tim1--;
   if(tim2)tim2--;
   if(tim3)tim3--;

   if(proc_timer)proc_timer--;

   trg ^=1;
   if(trg) scan_keys ();
   else    display_data();

   __watchdog_reset();
  }
 }
goto m;
}


void devcon()
{
 static bool itr=0;

 static enum dst{wait,start,prog_run,setup} dev_st=wait;
 static bool bp_trg[BNUM];
 static bool ars_trg;

 static u8 prog_number = 0;
 static u8 *wave_pt_a = NULL;
 static u8 *wave_pt_b = NULL;
 static u8 wm_size_a;
 static u8 wm_size_b;
 static u8 psc_a;
 static u8 psc_b;

 #define PWM_OFF {TCCR1A = 0;}
 #define PWM_ON  {TCCR1A = bin(11100000);}


 u8 bcnt=0;
 for(u8 i=0;i<BNUM;i++) if(btn[i]==rls) {bcnt++;}
 if(bcnt==BNUM)ars_trg = 1;

 switch (dev_st)
 {
  //     
  case wait:
  {
   if(!itr)
   {
    itr=1;
    ars_trg = 0;

    // 
    PWM_OFF;

    //   
    dbuf[3]='P';dbuf[2]= prog_number;dbuf[1] = 0;dbuf[0] = 0;
    dpp[3] = 0; dpp[2] = 1; dpp[1] = 0; dpp[0] = 0;
    //  
   }

   if(ars_trg)
   {
    for(u8 i=0;i<BNUM;i++)
    {
     if(btn[i]==rls)
     {
      //      
      if(bp_trg[i])
      {
       bp_trg[i] = 0;

       //         
       if(i==0)
       {
        if(prog_number < RGM_NUM-1) prog_number++;
        else prog_number = 0;
       }
       if(i==1)
       {
        if(prog_number) prog_number--;
        else prog_number = RGM_NUM-1;
       }

       //          
       dbuf[2] = prog_number;
      }
     }
     else if(btn[i]==prs) bp_trg[i] = 1;
     else                 bp_trg[i] = 0;
    }

    if(btn[0]==hold && btn[1]==hold)
     dev_st = setup;
    else if((btn[0]==hold && btn[1]==rls) || (btn[1]==hold && btn[0]==rls))
     dev_st = start;
   }
   //   

   if(dev_st!=wait){itr=0;}
  }
  break;

  // 
  case start:
  {
   //   
   u8 tmp;
   if(get_Iset(tmp)==true)
   {
    if(tmp > 0xff/20)
    {
     dbuf[3]='S';dbuf[2]='t';dbuf[1]='L';dbuf[0]='o';
    }
    else         dev_st = prog_run;
   }

   //   
   if(dev_st == prog_run)
   {
    //       
    //      ==0
    //          
    //   .      

    if(ee[prog_number].wave_1_time == 0)
    {
     wm_size_a = calculate_lf_qsw(ee[prog_number].wave_0_frq,
                                  ee[prog_number].wave_0_mod,
                                  &psc_a,
                                  qw.lf_qwave,
                                  sizeof(qw.lf_qwave));
     wave_pt_a = qw.lf_qwave;
    }
    else
    {
     wm_size_a = calculate_lf_qsw(ee[prog_number].wave_0_frq,
                                  ee[prog_number].wave_0_mod,
                                  &psc_a,
                                  qw.lf_qw2[0],
                                  sizeof(qw.lf_qw2[0]));
     wave_pt_a   = (u8*)(qw.lf_qw2);

     wm_size_b = calculate_lf_qsw(ee[prog_number].wave_1_frq,
                                  ee[prog_number].wave_1_mod,
                                  &psc_b,
                                  qw.lf_qw2[1],
                                  sizeof(qw.lf_qw2[1]));
     wave_pt_b   = (u8*)(qw.lf_qw2+1);
    }

   }
  }break;

  //   
  case prog_run:
  {
   static u8 proc_stage;
   static bool proc_trg;
   static u8 max_i;

   if(!itr)
   {
    itr=1;
    ars_trg = 0;
    proc_stage = 0;
    proc_trg = 0;
    amp=0;

    max_i = ee[prog_number].max_i_val;

    //       eeprom
    proc_timer = (u32)ee[prog_number].proc_time*1000*60;
   }

   //     
   switch(proc_stage)
   {
    //  
    case 0:
    {
     if(!proc_trg)
     {
      proc_trg = 1;

      __disable_interrupt();
      qwave_pt   = wave_pt_a;
      qwave_size = wm_size_a;
      psc        = psc_a;
      __enable_interrupt();

      //    
      tim1 = ee[prog_number].wave_0_time *100;
      // 
      PWM_ON;
     }

     if(!tim1)
     {
      if(ee[prog_number].w2w_pause)        proc_stage = 1;
      else if(ee[prog_number].wave_1_time) proc_stage = 2;
     }


     if(proc_stage!=0){proc_trg=0;}
    }break;
    //   ,  
    case 1:
    {
     if(!proc_trg)
     {
      proc_trg = 1;

      tim1 = ee[prog_number].w2w_pause*10;
      PWM_OFF;
     }

     if(!tim1)
     {
      if(ee[prog_number].wave_1_time) proc_stage = 2;
      else                            proc_stage = 0;
     }


     if(proc_stage!=1){proc_trg=0;}
    }break;
    //  ,  
    case 2:
    {
     if(!proc_trg)
     {
      proc_trg = 1;

      __disable_interrupt();
      qwave_pt   = wave_pt_b;
      qwave_size = wm_size_b;
      psc        = psc_b;
      __enable_interrupt();

      //    
      tim1 = ee[prog_number].wave_1_time *100;
      // 
      PWM_ON;
     }

     if(!tim1)
     {
      if(ee[prog_number].w2w_pause)        proc_stage = 3;
      else                                 proc_stage = 0;
     }

     if(proc_stage!=2){proc_trg=0;}
    }break;
    //   ,  
    case 3:
    {
     if(!proc_trg)
     {
      proc_trg = 1;

      tim1 = ee[prog_number].w2w_pause*10;
      PWM_OFF;
     }

     if(!tim1) proc_stage = 0;

     if(proc_stage!=3){proc_trg=0;}
    }break;
    default: proc_stage=0;break;
   }


   //         
   static u8 I_set;
   static u8 I_val;
   static u8 tmp_iset;
   static bool i_trg;

   if(!tim2)
   {
    if(!i_trg)
    {
     if(get_Iset(I_set, ee[prog_number].max_i_val)==true)
     {
      i_trg = 1;
      tim2 = 50;
     }
    }
    else
    {
     if(get_I (I_val)==true)
     {
      //     
      //        
      if(ee[7].sys_val != 150) amp = I_set*0xff/100;
      //      
      else if(TCCR1A)
      {
       static u32 ncv;
       static u16 ncc;

       ncv += I_val;
       ncc ++;

       if(eowr==true)
       {
        eowr = false;

        I_val = ncv/ncc;
        ncc = 0;
        ncv = 0;

        if(ist_proc(max_i, I_val, I_set, &amp)==false)dev_st = wait;
       }
      }

      i_trg=0;
      tim2 = 50;
     }

    }
   }

   //        
   //     
   if((tmp_iset > I_set + 5)||(tmp_iset + 5 < I_set))
   {
    tmp_iset = I_set;
    tim3 = 3000;
   }

   //          
   if(ars_trg)
   {
    if(btn[0]==prs || btn[1]==prs) dev_st = wait;
   }

   //  
   if(!tim0)
   {
    //     
    if(!tim3)
    {
     if(ee[8].sys_val == 150)
     {
      dbuf[2] = prog_number;
      dpp[2]  = 1;
      ttd(dbuf, proc_timer);

      inwork_animation((dbuf+3), 1);
      tim0 = 400;
     }
     else
     {
      dbuf[3] = 'C';
      dpp[2]  = 0;

      convert_data(I_val,dbuf,3);
      tim0 = 100;
     }
    }
    //   
    else
    {
     dbuf[3] = ' ';
     dpp[2]  = 0;

     convert_data(I_set,dbuf,3);
     tim0 = 100;
    }
   }
   //  

   //     
   if(proc_timer==0)
   {
    dev_st = wait;
   }

   if(dev_st!=prog_run){itr=0;}
  }
  break;

  //   
  case setup:
  {
   static u8 rgm;
   static bool sch_trg;
   static u8 tmp_val[sizeof(eem)-5];
   static u8 __eeprom *pt;

   if(!itr)
   {
    itr=1;
    ars_trg = 0;
    rgm = 0;
    sch_trg = 0;

    pt = (__eeprom u8*)(ee+prog_number)+5;
    for(u8 i=0;i<10;i++) tmp_val[i] = *(pt+i);


    dbuf[3]= rgm ;dbuf[2] = 0;dbuf[1] = 0;dbuf[0] = 0;
    dpp[2] = 0;
   }

   //        
   //  
   if(!tim0)
   {
    tim0 = 300;
    if(sch_trg) dpp[3] ^= 1;
    else        dpp[3]  = 1;
   }

   //   
   static u8 r_tmp;

   if(!tim2)
   {
    if(get_Iset(r_tmp)==true)
    {
     tim2 = 100;

     if(rgm==2 || rgm==5) dpp[1] = 1; //   P.mm.c
     else                 dpp[1] = 0;

     //  
     if(sch_trg)
     switch(rgm)
     {
      case 0: //wave_0_frq
      {
       if(!r_tmp) r_tmp = 1;
       tmp_val[rgm] = r_tmp;

      }break;
      case 1: //wave_0_mod
      {
       tmp_val[rgm] = r_tmp*100/0xff;

      }break;
      case 2: //wave_0_time
      {
       if(!r_tmp) r_tmp = 1;
       tmp_val[rgm] = r_tmp;

      }break;
      case 3: //wave_1_frq
      {
       if(!r_tmp) r_tmp = 1;
       tmp_val[rgm] = r_tmp;

      }break;
      case 4: //wave_1_mod
      {
       tmp_val[rgm] = r_tmp*100/0xff;

      }break;
      case 5: //wave_1_time
      {
       if(r_tmp <5) r_tmp = 0;
       tmp_val[rgm] = r_tmp;

      }break;
      case 6: //max_i_val
      {
       tmp_val[rgm] = r_tmp*100/0xff;
       if(tmp_val[rgm]==0) tmp_val[rgm] = 10;
      }break;
      case 7: //w2w_pause
      {
       if(r_tmp <2) r_tmp = 0;
       tmp_val[rgm] = r_tmp;

      }break;
      case 8: //proc_time
      {
       tmp_val[rgm] = r_tmp*99/0xff;
       if(tmp_val[rgm]==0) tmp_val[rgm] = 1;

      }break;
      case 9: //sys_val
      {
       //      
       if(prog_number == 9) tmp_val[rgm] = (r_tmp>>1)+25;
       //        
       //        
       else if(prog_number == 8 || prog_number == 7)
       {
        //       
        // 
        if(r_tmp > 0xff/2) tmp_val[rgm] = 150;
        //         
        //   
        else tmp_val[rgm] = 0;
       }

      }break;

      default:break;
     }

     convert_data(tmp_val[rgm], dbuf, 3);
    }
   }

   //   ->      
   //   ->   
   if(ars_trg)
   {
    for(u8 i=0;i<BNUM;i++)
    {
     if(btn[i]==rls)
     {
      if(bp_trg[i])
      {
       bp_trg[i] = 0;

       if(sch_trg) sch_trg = 0;
       else
       {
        //         
        if(i==0)
        {
         //        
         if(prog_number > 6)
         {
          if(rgm < 9) rgm++;
          else rgm = 0;
         }
         else
         {
          if(rgm < 8) rgm++;
          else rgm = 0;
         }
        }
        else
        {
         //        
         if(prog_number > 6)
         {
          if(rgm) rgm--;
          else rgm = 9;
         }
         else
         {
          if(rgm) rgm--;
          else rgm = 8;
         }
        }

        //    
        dbuf[3] = rgm;
       }
      }
     }
     else if(btn[i]==prs) bp_trg[i] = 1;
     else                 bp_trg[i] = 0;
    }

    if(btn[0]==hold && btn[1]==hold) dev_st = wait;
    else if((btn[0]==hold && btn[1]==rls)||(btn[1]==hold && btn[0]==rls))
     sch_trg = 1;
   }
   //   

   if(dev_st!=setup)
   {
    itr=0;

    //   prom,     
    for(u8 i=0;i<sizeof(eem)-5;i++) if(tmp_val[i] != *(pt+i)) *(pt+i) = tmp_val[i];

    set_checksum(ee+prog_number);
   }
  }break;

  default:break;
 }
}

