#define RGM_NUM 10

#define IV_0 100
#define IV_1 50
#define IV_2 255
#define IV_3 0
#define IV_4 0
#define IV_5 0
#define IV_6 100
#define IV_7 0
#define IV_8 20
#define IV_9 150
#define IV_ACTIVITY 0
#define IV_CHKSUM IV_0+IV_1+IV_2+IV_3+IV_4+IV_5+IV_6+IV_7+IV_8+IV_9

struct eem
{
 u32 checksum;
 u8 activity;   //       
 u8 wave_0_frq; //0_255 Hz
 u8 wave_0_mod; //0_100 %
 u8 wave_0_time;//ms*100 1..255
 u8 wave_1_frq; //0_255 Hz
 u8 wave_1_mod; //0_100 %
 u8 wave_1_time;//ms*100 0..255
 u8 max_i_val;  //0_100 mA
 u8 w2w_pause;  //0_255 ms
 u8 proc_time;  //0_99 min
 u8 sys_val;    //   5V    , 150  
}__eeprom ee[RGM_NUM];

eem const defval=
{
 IV_CHKSUM,
 IV_ACTIVITY,
 IV_0,
 IV_1,
 IV_2,
 IV_3,
 IV_4,
 IV_5,
 IV_6,
 IV_7,
 IV_8,
 IV_9
};

void set_checksum(eem __eeprom *eep)
{
 u8 __eeprom *pt  = (__eeprom u8*)eep + sizeof(u32) + 1;
 u8 __eeprom *pt2 = (__eeprom u8*)eep + sizeof(eem);
 u8 dpt = u8(pt2 - pt);

 u16 tmp = 0;


 for(u8 i=0;i<dpt;i++) tmp += *pt++;

 if(eep->checksum != tmp) eep->checksum = tmp;
}

bool get_checksum(eem __eeprom *eep)
{
 u16 tmp=0;

 u8 __eeprom *pt  = (__eeprom u8*)eep + sizeof(u32) + 1;
 u8 __eeprom *pt2 = (__eeprom u8*)eep + sizeof(eem);
 u8 dpt = u8(pt2 - pt);

 for(u8 i=0;i<dpt;i++) tmp += *pt++;

 if(tmp == eep->checksum) return true;

 return false;
}