
#define A  PORTD_Bit1
#define B  PORTD_Bit2
#define C  PORTD_Bit3
#define D  PORTD_Bit4
#define E  PORTC_Bit5
#define F  PORTC_Bit4
#define G  PORTC_Bit3
#define H  PORTC_Bit2

#define N0 PORTB_Bit0
#define N1 PORTD_Bit7
#define N2 PORTD_Bit6
#define N3 PORTD_Bit5

u8 dbuf[4];
bool dpp[4];


void display_data()
{
 static u8 pc; u8 tmp;

 (pc)?(pc--):(pc = 3);

 N3=N2=N1=N0=0;
 A= B= C= D= E= F= G= H= 1;


 switch (dbuf[pc])
 {
  case 0:   tmp = bin(00000010); break;
  case 1:   tmp = bin(10011110); break;
  case 2:   tmp = bin(00100100); break;
  case 3:   tmp = bin(00001100); break;
  case 4:   tmp = bin(10011000); break;
  case 5:   tmp = bin(01001000); break;
  case 6:   tmp = bin(01000000); break;
  case 7:   tmp = bin(00011110); break;
  case 8:   tmp = bin(00000000); break;
  case 9:   tmp = bin(00001000); break;

  case 10:  tmp = bin(01111110); break;
  case 11:  tmp = bin(10111110); break;
  case 12:  tmp = bin(11011110); break;
  case 13:  tmp = bin(11101110); break;
  case 14:  tmp = bin(11110110); break;
  case 15:  tmp = bin(11111010); break;
  case 16:  tmp = bin(11111100); break;

  case 17:  tmp = bin(11101100); break;
  case 18:  tmp = bin(01101100); break;

  case ' ': tmp = bin(11111110); break;
  case 'v':
  case 'u': tmp = bin(11000110); break;
  case 'c': tmp = bin(11100100); break;
  case 'b': tmp = bin(11000000); break;
  case 't': tmp = bin(11100000); break;
  case 'l': tmp = bin(11100110); break;
  case 'o': tmp = bin(11000100); break;
  case 'A': tmp = bin(00010000); break;
  case 'H': tmp = bin(10010000); break;
  case 'C': tmp = bin(01100010); break;
  case 'P': tmp = bin(00110000); break;
  case 'E': tmp = bin(01100000); break;
  case 'U': tmp = bin(10000010); break;
  case 'f':
  case 'F': tmp = bin(01110000); break;
  case 'L': tmp = bin(11100010); break;
  case 'r': tmp = bin(11110100); break;
  case 'd': tmp = bin(10000100); break;
  case 'n': tmp = bin(11010100); break;
  case 'G': tmp = bin(01000010); break;
  case 'N': tmp = bin(00010010); break;
  case 'O': tmp = bin(00000010); break;
  case 'i': tmp = bin(11110110); break;
  case 'I': tmp = bin(11110010); break;
  case 'S': tmp = bin(01001000); break;
  case 'J': tmp = bin(10001110); break;
  case 'h': tmp = bin(11010000); break;
  case '_': tmp = bin(11101110); break;
  default:  tmp = bin(11111100); break; //-
 }

  //     
 if(dpp[pc]==false) tmp |= 1;


 switch (pc)
 {
  case 0: N0=1; break;
  case 1: N1=1; break;
  case 2: N2=1; break;
  case 3: N3=1; break;
 }


 (tmp&(1<<7))?(A=1):(A=0);
 (tmp&(1<<6))?(B=1):(B=0);
 (tmp&(1<<5))?(C=1):(C=0);
 (tmp&(1<<4))?(D=1):(D=0);
 (tmp&(1<<3))?(E=1):(E=0);
 (tmp&(1<<2))?(F=1):(F=0);
 (tmp&(1<<1))?(G=1):(G=0);
 (tmp&    1 )?(H=1):(H=0);
}

void convert_data (u16 d, u8 dbuf[], u8 dnum = 4)
{
 u8 tmp[4];

 for (u8 k=0;k<dnum;k++) {tmp[k]=d%10; d/=10;}

 //  
 for (u8 k=dnum-1;k;k--) {if(!tmp[k])tmp[k]=' '; else break;}

 for(u8 k=0;k<dnum;k++)dbuf[k] = tmp[k];
}

void inwork_animation(u8 *dbuf, bool cond = false)
{
 static u8 stage;
 static u8 tmp_dbuf = ' ';
 static bool tmp_trg=0;

 //    
 if(tmp_trg && cond==false)
 {
  stage = 0;

  *dbuf = tmp_dbuf;
  tmp_trg = 0;
 }
 //     
 else if(!tmp_trg && cond==true)
 {
  tmp_trg = 1;
  tmp_dbuf = *dbuf;
 }

 if(cond==true)
 {
  stage<3?stage++:stage=0;

  //    
  switch(stage)
  {
   case 0: *dbuf = '_'; break;
   case 1: *dbuf = 17; break;
   case 2: *dbuf = 18; break;
   default: break;
  }
 }
}

void ttd(u8 *dbuf, u32 t_val)
{
 u16 tmp;

 if(t_val > 60UL*1000) tmp = t_val/60/1000 +1;
 else                  tmp = t_val/1000;

 convert_data (tmp, dbuf, 2);
}

