#define I_SNS   0
#define I_SET   1

#define MAX_IEE ee[9].sys_val
#define MAX_VADC 2560


bool get_adc(const u8 cnl, u8 &result)
{
 static bool trg=0;
 static u8 cnt;
 static u16 tmp_val;

 if(!trg)
 {
  trg = 1;

  if(cnl == I_SNS) ADMUX = 1<<REFS1|1<<REFS0|1<<ADLAR|cnl;
  else             ADMUX =          1<<REFS0|1<<ADLAR|cnl;

  cnt = 0;
  tmp_val = 0;

  ADCSR = 1<<ADEN|1<<ADSC|1<<ADPS2|1<<ADPS1|1<<ADPS0;
 }

 if(bool(ADCSR & 1<<ADSC) == false)
 {
  if(!cnt)       __no_operation();
  else if(cnt<9) tmp_val += ADCH;
  else
  {
   result = tmp_val>>3;
   trg=0;

   return 1;
  }

  ADCSR = 1<<ADEN|1<<ADSC|1<<ADPS2|1<<ADPS1|1<<ADPS0;
  cnt++;
 }

 return 0;
}

bool get_Iset(u8 &result, u8 max_i=0xff)
{
 u8 adc_in;

 if(get_adc(I_SET, adc_in)==1)
 {
  result  = (u32)adc_in*max_i >>8;
  return 1;
 }
 return 0;
}

bool get_I (u8 &result)
{
 u8 adc_in;

 if(get_adc(I_SNS, adc_in)==1)
 {
  result = (u32)adc_in*MAX_IEE >>8;

  return 1;
 }
 return 0;
}



