//
// ICC-TINYAVR ver 6.11A
// Target: TINY15
//
//    4     RC5 
//
//   04.05.2009
//
//    VMLAB :
//                          - 2.2 mA
//                      Sleep Idle      - 912 mkA
//                      Sleep PowerDown -   1 mkA
//

// Program size 474 bytes, device 46% full

#include <iotiny15v.h>
#include <macros.h>

#define SetBit(x,y) (x|=(1<<y)) 
#define ClrBit(x,y) (x&=~(1<<y))
#define TestBit(x,y) (x&(1<<y)) 

#define ON  1
#define OFF 0

//extern char readflash(int addr); // -  .
//   PonyProg2000     OSCCAL 

unsigned int TR_out = 0x0003;  // 0000 0000 0000 0011;
//
// 00 000000 00000 0 1 1
//  | |    | |   | | | |
//  | |    | |   | | |   -  "1"
//  | |    | |   | | |
//  | |    | |   | |   ( . RC5  C6 )
//  | |    | |  |  | 
//  | |   |  | |    
//  | |  |   ||
//  | | |      (A0, A1, A2, A3, A4)
//  | ||   
//  |   (C0, C1, C2, C3, C4, C5)
//  |
//    16 
//

			  
//-------------- external interupt on INT0 ------------------
#pragma interrupt_handler int0_isr:2
void int0_isr(void)
{
 NOP();
}
//-----------------------------------------------------------


//-----------------------------------------------------------
void delay_10ms(void) {
	 unsigned int ms = 2000;
	 while (ms) {
	 	NOP();
	 	ms--;
	 }
}
//-----------------------------------------------------------


//-----------------------------------------------------------
//call this routine to initialise all peripherals
void init_devices(void)
{
 CLI();		//disable all interrupts
  
 //******************************************************************
 // Port init
 DDRB  = 0x10;	//portb direction  0001 0000 (bit 4 out; bit`s 3,2,1,0 in)
 PORTB = 0x0F;	//portb bits       0000 1111 (pullup - bit`s 3,2,1,0)
 //******************************************************************
 
 
 //******************************************************************
 // Timer1 init
 TCCR1 = 0x00;	// Timer1 stop
 OCR1A = 0xFF;	//   
 OCR1B = 0xFF;	//
 TCNT1 = 0x00;	//    
 //******************************************************************


 //******************************************************************
 MCUCR = 0x30; // MCU control register - x011 0x00  
 // Pull-up Disable = OFF  (PUD = 0)
 // Sleep enable = OFF     (SE = 0)
 // Sleep mode - Idle mode       (SM1 = 0,SM0 = 0)
 //            - Power Down mode (SM1 = 1,SM0 = 0)
 // Interrupt sence control
 //             - Low level                      (ISC01 = 0, ISC00 = 0)
 //             - Falling edge [ ] (ISC01 = 1, ISC00 = 0) 
 // PUD - bit6, SE - bit5, SM1 - bit4
 // SM0 - bit3, ISC01 - bit1, ISC00 - bit0   
 //******************************************************************


 //******************************************************************
 GIMSK = 0x40; // General interrupt mask register - x10x xxxx
 // External interrupt request 0 enable = ON (INT0 = 1) 
 // Pin change interrupt enable = OFF (PCIE = 0) 
 // INT0 - bit6, PCIE - bit5
 //******************************************************************
 
 
 //******************************************************************
 TIMSK = 0x00; // Timer/Counter interrupt mask register - x0xx x00x
 // Timer/Counter1 output compare interrupt enable = OFF (OCIE1A = 0) 
 // Timer/Counter1 overflow interrupt enable = OFF (TOIE1 = 0)
 // Timer/Counter0 overflow interrupt enable = OFF (TOIE0 = 0)
 // OCIE1A - bit6,  TOIE1 - bit2, TOIE0 - bit1
 //******************************************************************

 
 //******************************************************************
 EECR = 0x00; // EEPROM control register - 0000 0000
 // EEPROM ready interrupt enable = OFF (EERIE = 0)
 // EEPROM master write enable = OFF (EEMWE = 0)
 // EEPROM write enable = OFF (EEWE = 0)
 // EEPROM read enable = OFF (EERE = 0)
 // EERIE - bit3, EEMWE - bit2, EEWE - bit1, EERE - bit0
 //******************************************************************
 
 SEI(); //re-enable interrupts
}
//-----------------------------------------------------------


//-=-=-=-=-=-=-=-=-=-=-=-=-=-=- main -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
void main(void) {
 unsigned char old_key, key, valuePB2, i, bit_num;
      
 init_devices();  //  
 
 //OSCCAL = readflash(0x000); //   ..
 OSCCAL = 0x77; //    PonyProg2000   

 ClrBit(PORTB,4); //   

 asm("sleep"); //  (  .)


 // ====================   ================================
 while(1) {
	CLI(); // disable all interrupts

	old_key = (~PINB) & 0x0F; //   
	delay_10ms();
	key = (~PINB) & 0x0F;

	if ((old_key == key) && (valuePB2 != 0)) {
		//          PB3 PB2 PB1 PB0
		// key 1 ->   0   1   1   0  = 4+2  = 6  
		// key 2 ->   0   1   0   0  =        4 
		// key 3 ->   1   1   0   0  = 8+4  = 12
		// key 4 ->   0   1   0   1  = 4+1  = 5
 
		if ( key == 6)  TR_out = 0x2003; // 0010 0000 0000 0011
		if ( key == 4)  TR_out = 0x1003; // 0001 0000 0000 0011
		if ( key == 12) TR_out = 0x3003; // 0011 0000 0000 0011
		if ( key == 5)  TR_out = 0x0803; // 0000 1000 0000 0011

		for (bit_num = 0; bit_num < 14; bit_num++) {
			if ( TR_out & 0x0001 != 0) {
				for (i = 0; i < 190; i++) {NOP();} // 889 
				for (i = 0; i < 32; i++) { // 27 
					SetBit(PORTB,4); 
					NOP();NOP();NOP();NOP();NOP();
					NOP();NOP();NOP();NOP();NOP();
					NOP();NOP();NOP();NOP();NOP();
					ClrBit(PORTB,4);
					NOP();NOP();NOP();NOP();NOP();
					NOP();NOP();NOP();NOP();NOP();
					NOP();NOP();NOP();NOP();NOP();
				}
			} else {
				for (i = 0; i < 32; i++) { // 27 
					SetBit(PORTB,4);
					NOP();NOP();NOP();NOP();NOP();
					NOP();NOP();NOP();NOP();NOP();
					NOP();NOP();NOP();NOP();NOP();
					ClrBit(PORTB,4);
					NOP();NOP();NOP();NOP();NOP();
					NOP();NOP();NOP();NOP();NOP();
					NOP();NOP();NOP();NOP();NOP();
				}
				for (i = 0; i < 190; i++) {NOP();} // 889 
			}
			TR_out = TR_out >> 1; 
	   }
	}
	valuePB2 = TestBit(PINB,2); //   PB2

	SEI(); // enable interrupts
	asm("sleep"); //  (  .)
	
 }; // ======================= end   ==========================

 
 
 
} //-=-=-=-=-=-=-=-=-=-=-=-=-=- end main -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
