;     - , ;
;    
;- Fo    
;- Fr  
;- To  
;- Tr  
;  Fr=Fo*Tr/To

; 09.04.2018 
; 08.07.2010
 
.include "tn2313def.inc"

;.equ	Fo=1000000
.equ	Fo=4000000

;R5- 
;R6- 
;R7- 
;R8- 

.def DC=R18

.def R_SEC=R25
.def R_MIN=R24
.def R_HOUR=R23

.cseg
.org 0
RESET:
	LDI	R16,RAMEND
	OUT	SPL,R16		;  

	RJMP	START
;**********************************************************
;**********************************************************
;**********************************************************
.ORG	$0004
TIMER_COMP1:
	OUT	PORTB,ZH	;    
	OUT	PORTD,R2	;  

	LDI	ZL,LOW(TB_DC*2)
	ADD	ZL,DC
	LPM

	LDI	XL,5		;   XH,XL  R5
	CLR	XH
	ADD	XL,DC
	LD	R16,X		;    R5...R8  R16
POINT:
	BST	R_SEC,0
	CPI	DC,1
	BRNE	PC+2
	BLD	R16,5		;       
	OUT	PORTD,R0
	OUT	PORTB,R16	;   
	
	INC	DC
	ANDI	DC,3
;     
COMP1_1:
	SBIW	YL,1
	BRMI	SEC_OUT
	BRNE	COMP1_1_OUT
	
	OUT	OCR1AH,R3
	OUT	OCR1AL,R4	;    OCR1A R3:R4
COMP1_1_OUT:
	RETI
SEC_OUT:
;  1'000'000  
	CBI	PORTD,4
	RET
;*************************************************
;*************************************************
;*************************************************
TB_DIG:
	;     edhcgafb   edhcgafb
	.db 0b11010111,0b00010001 ;01
	.db 0b11001101,0b01011101 ;23
	.db 0b00011011,0b01011110 ;45
	.db 0b11011110,0b00010101 ;67
	.db 0b11011111,0b01011111 ;89
	.db 0b00000000,0b00000000 ;  
TB_DC:
	; 	 
	.db 0b11111011,	0b11110111
	;    
	.db 0b11011111, 0b10111111
;******************************************
START:
	CLR	ZH	

	LDI	R16,0b11111111
	MOV	R2,R16
	OUT	DDRA,R16
	OUT	DDRB,R16	;   B
	OUT	DDRD,R16	;  
	OUT	PORTD,R16

	LDI	R16,0b11111100
	OUT	DDRD,R16
;	CBI	PORTD,4		;  1 

	RJMP	TIME_BEGIN
;*************************************************
GO:
	CLR	DC
	
	LDI	YH,HIGH(1599)
	LDI	YL,LOW(1599)	;  

	LDI	XH,HIGH(Fo-Fo/1600*1599-1)
	LDI	XL,LOW(Fo-Fo/1600*1599-1)
	MOV	R3,XH			;     1 
	MOV	R4,XL			;  

	LDI	XH,HIGH(Fo/1600-1)	;     
	LDI	XL,LOW(Fo/1600-1)
	OUT	OCR1AH,XH
	OUT	OCR1AL,XL

	LDI	R16,1<<SE
	OUT	MCUCR,R16		; SLEEP ENABLE
	
	LDI	R16,1<<OCIE1A
	OUT	TIMSK,R16	;   Timer1_comp1
	OUT	TIFR,R16
	
	LDI	R16,1<<WGM12|1<<CS10
	OUT	TCCR1B,R16	;  Fo/1 CTC

	SEI 			;   
WAIT:
	SLEEP
	BRIE	WAIT
;**********************************************************
KEY_MIN:
	SBIC	PIND,1
	RJMP	KEY_HOUR	;    HOUR
 	INC	R_MIN		;  MIN
 	CPI	R_MIN,60
 	BRLO	MIN_60
 	CLR	R_MIN
MIN_60: 	
KEY_HOUR: 	
	SBIC	PIND,0
	RJMP	INC_TIME
 	INC	R_HOUR
 	CPI	R_HOUR,24
 	BRLO	INC_TIME
 	CLR	R_HOUR
INC_TIME:
	INC	R_SEC
	CPI	R_SEC,60
	BRLO	GO_TIME
	CLR	R_SEC
INC_MIN:
	INC	R_MIN
	CPI	R_MIN,60
	BRLO	GO_TIME
	CLR	R_MIN
	SBR	R22,$04
INC_HOUR:
	INC	R_HOUR
	CPI	R_HOUR,24
	BRLO	GO_TIME
TIME_BEGIN:	
	CLR	R_SEC
	CLR	R_MIN
	CLR	R_HOUR
GO_TIME:
	MOV	R16,R_HOUR
	CLR	R5
	CLR	R6
HOUR_10:
	SUBI	R16,10
	BRMI	HOUR_1
	INC	R5
	RJMP	HOUR_10
HOUR_1:
	SUBI	R16,-10
	MOV	R6,R16

	LDI	R17,10

;	TST	R5
;	BRNE	PC+2
;	MOV	R5,R17
	LDI	ZL,LOW(TB_DIG*2)
	ADD	ZL,R5
	LPM	R5,Z
	
	LDI	ZL,LOW(TB_DIG*2)
	ADD	ZL,R6
	LPM	R6,Z
;**********************
	MOV	R16,R_MIN
	CLR	R7
	CLR	R8
MIN_10:
	SUBI	R16,10
	BRMI	MIN_1
	INC	R7
	RJMP	MIN_10
MIN_1:
	SUBI	R16,-10
	MOV	R8,R16
	LDI	ZL,LOW(TB_DIG*2)
	ADD	ZL,R7
	LPM	R7,Z
	LDI	ZL,LOW(TB_DIG*2)
	ADD	ZL,R8
	LPM	R8,Z

	RJMP	GO
;**********************************************************
.EXIT

