



   ;UPS_INV
   ;MEGA  88

.EQU ADCL=0x78   ;  . 
.EQU ADCH=0x79    ;  . 
.EQU ADCSRA=0x7A  ;  
.equ ADSC =6
.EQU ADMUX=0x7C   ;  
.equ ADLAR =5

.EQU PIND=0x09    ;  
.EQU DDRD=0x0A    ; 
.EQU PORTD=0x0B   ;  
;.equ  FAULT        =3

.EQU PINC=0x06    ;  
.EQU DDRC=0x07    ; 
.EQU PORTC=0x08   ;  



.EQU  PINB=0x03   ;  
.EQU  DDRB=0x04   ; 
.EQU  PORTB=0x05  ;  
.equ  LED          =0


.EQU WDTCSR=0x60   ; 
.equ   WDIF 	=7
.equ   WDIE 	=6
.equ   WDP3 	=5
.equ   WDCE 	=4
.equ   WDE   	=3
.equ   WDP2 	=2
.equ   WDP1 	=1
.equ   WDP0 	=0

.EQU TCCR0A=0x44    ;   TC0
.EQU TCCR0B=0x45    ;   TC0
.EQU TCNT0=0x46     ; TC0

.EQU TCCR1A=0x80   ;   1
.equ COM1B0  =4 
.equ COM1B1  =5 
.EQU TCCR1B=0x81   ;   1
.EQU TCNT1H=0x85
.EQU TCNT1L=0x84
.EQU OCR1AH=0x89   ;  1 .   
.EQU OCR1AL=0x88  
.EQU SH_MOST_H=0x88
.EQU OCR1BH=0x8B   ;  1 . 
.EQU OCR1BL=0x8A   ;  1 .  
.EQU SH_MOST_L=0x8A   
.EQU ICR1H=0x87   ;
.EQU ICR1L=0x86   ;

.EQU TCCR2A=0xB0   ;  2
.EQU TCCR2B=0xB1
.EQU TCNT2=0xB2
.EQU OCR2A=0xB3    ;  2 
.EQU OCR2B=0xB4    ;  2 
.EQU ASSR=0xB6

.EQU TIMSK0=0x6E    ;   
.EQU TIFR0=0x15
.EQU TIMSK1=0x6F    ;   
.EQU TIFR1=0x16

.EQU EICRA=0x69    ;  INT0
.equ ISC11   =3
.equ ISC10   =2
.equ ISC01   =1
.equ ISC00   =0

.EQU EIMSK=0x3D     ;   INT0
.equ INT1    =1
.equ INT0    =0

.EQU EIFR=0x3C      ;   INT0
.equ INTF1    =1
.equ INTF0    =0

.EQU SPL=0x3D
.EQU SPH=0x3E
.EQU SREG=0x3F


.EQU UDR=0xC6     ; USART
.EQU UCSRA=0xC0   ; USART
.equ RXC   =7 
.equ TXC   =6 
.equ UDRE  =5
.equ FE    =4
.equ DOR   =3
.equ UPE   =2
.equ U2X   =1
.equ MPCM  =0

.EQU UCSRB=0xC1   ; USART
.equ RXCIE   =7 
.equ TXCIE   =6 
.equ UDRIE   =5
.equ RXEN    =4
.equ TXEN    =3
.equ UCSZ2   =2
.equ RXB8    =1
.equ TXB8    =0

.EQU UCSRC=0xC2   ; USART
.equ UMSEL1  =7
.equ UMSEL0  =6 

.EQU UBRRH=0xC5   ; USART
.EQU UBRRL=0xC4   ; USART

.EQU OSCCAL=0x31   ;KALIBRATOR




.def  DEL_01CEK         =r2
.def  PAUZ_OBM          =r3
.def  ZAD1_INV          =r4
.def  ZAD2_INV          =r5
;.def  REZ1_INV          =r6
.def  VR_K_OBM          =r7
.def  SHG_CKL_RAB       =r8
.def  SYM_OBM           =r9


.def  FL_SIS_INV      =r16
.equ  F_RABOT_INV         =0

.def  FL_AVR_INV      =r17
.equ  F_AVR_TOK_INV      =0
.equ  F_AVR_OBM_INV      =1
.equ  F_AVR_SM_OBM_INV   =2
.equ  F_FOT_AVR_INV      =7

.def  FL_TR_RAB_INV     =r18
.equ  F_TR_RAB_INV        =0


.def  KONT_PRX_PROG     =r19
.def  SHAG_OBM          =r20
.def  SHAG_SIN          =r21
.def  KL_AVR_TOK_INV    =r22


.def A  =r24
.def B  =r25
.def XL =r26
.def XH =r27
.def YL =r28
.def YH =r29
.def ZL =r30
.def ZH =r31


.EQU DEL_1CEK              =0x100  ;BLOK RAM
.EQU DEL_1MINYT            =0x101
.EQU DEL_1CZAS             =0x102
.EQU SHIM_IND              =0x103
.EQU KOL_IMP_IND           =0x104
.EQU PAYZA_IND             =0x105
.EQU LED_IMPL              =0x106
.EQU KOL_PEREZ             =0x107
.EQU VR_PEREZ              =0x108
.EQU VR_PDG_STAPT          =0x109


.EQU BUF_OBM0                =0x110
.EQU BUF_OBM1                =0x111
.EQU BUF_OBM2                =0x112
.EQU BUF_OBM3                =0x113
.EQU BUF_OBM4                =0x114
.EQU BUF_OBM5                =0x115
.EQU BUF_OBM6                =0x116
.EQU BUF_OBM7                =0x117
.EQU BUF_OBM8                =0x118
.EQU BUF_OBM9                =0x119

.EQU  K_VR_PEREZ         =50   ;1SEK



.ORG    0x000       
        rjmp  NACZALO
.ORG    0x002       
        rjmp  INT_1
.ORG    0x00D
        rjmp  PEREP_TC1       ;  71MKC
.ORG    0x010
        rjmp  PEREP_TC0       ;  2MC
.ORG    0x012
        RJMP  RD_UART_INVER   ;  USART
;.ORG    0x014
 ;       RJMP  WR_UART_INVER   ;  USART
 


.ORG 0x30      
NACZALO:  CLI
          ldi A,0B00111001     ; PORT B
          out DDRB,A      
          ldi A,0B00000001     ;DAN PORT B
          out PORTB,A     
          ldi A,0B00111111     ; PORT C
          out DDRC,A 
          ldi A,0B01000000     ;DAN PORT C  
          out PORTC,A 
          ldi A,0B11110100     ; PORT D
          out DDRD,A 
          ldi A,0B00001010     ;DAN PORT D  
          out PORTD,A 
	      CBI PORTB,LED

          ldi A,0               ;UKAZAT STEKA
          out SPL,A
          ldi A,$04             ;UKAZAT STEKA
          out SPH,A
          RCALL VREM_2C     ;==================

          ldi A,0
          STS TCNT1H,A          ; DAN TC1H
          ldi A,$FF
          STS TCNT1L,A          ; DAN TC1L
          ldi A,0B10110001      ;   1
          STS TCCR1A,A             
          ldi A,0B00000001      ;   1
          STS TCCR1B,A   
          ldi A,0               ; A 1
          STS OCR1AH,A  
          ldi A,10
          STS OCR1AL,A   
          ldi A,0               ; B 1
          STS OCR1BH,A  
          ldi A,245
          STS OCR1BL,A  
          LDS A,TIMSK1          ;TIMSK TC1
		  SBR A,0B00000001
          STS TIMSK1,A  		  
		   
		  ldi A,1               ;DAN TC0
          STS TCNT0,A 
		  ldi A,0B00000011      ;  0
          STS TCCR0A,A 
          LDS A,TIMSK0          ;TIMSK TC0
		  SBR A,0B00000001
          STS TIMSK0,A  	
		  LDI A,0B00000011
          STS TCCR0B,A  

          ldi  ZH,high(KONS_RG*2)   ;ZAGR REG 1-23
          ldi  ZL,low(KONS_RG*2)
          ldi  YH,0                 ;KUDA  R1
          ldi  YL,1
          ldi  A,23                 ;KOL-VO
ZAGR_REG: lpm
          st    Y+,r0
          adiw  ZL,1                ; +1
          dec   A
          BRNE  ZAGR_REG

NACZL2:   ldi ZH,high(KONS_100H*2)  ;ZAGR RAM 
          ldi ZL,low(KONS_100H*2)   ;100H-11FH
          ldi YH,$01 
          ldi YL,$00
RD_K_1:   lpm
          st Y+,r0
          adiw ZL,1
          CPI YL,$20
	      BRNE RD_K_1

	      ldi A,0B00001000      ;  INT0
          STS EICRA,A 
		  ldi A,0B00000010      ;  INT0
          STS EIMSK,A 

          LDI A,0B00000010        ;ZAGRUZ  USART
		  STS UCSRA,A
          LDI A,0B00000110
		  STS UCSRC,A
          LDI A,0B10010100
		  STS UCSRB,A 
          LDI A,$01 
		  STS UBRRH,A 
          LDI A,$60            ;$50 $6F
		  STS UBRRL,A 

          WDR                  ;RES STOR TAIM
          LDS A,WDTCSR         ;ZAG STOR TAIM
          SBR A,(1<<WDCE)|(1<<WDE)
          STS WDTCSR,A
          LDI A,(1<<WDE)|(1<<WDP1)  ;64  
          STS WDTCSR,A
          WDR                  ;RES STOR TAIM
          SEI                  ;  

NACZL1:   RJMP NACZL1


VREM_2C:   PUSH A
           IN   A,SREG
           PUSH A
           PUSH B     
           LDI A,40
VREM2:     LDI B,255
VREM1:     DEC B
           BRNE  VREM1
           DEC A
           BRNE  VREM2
           POP B
           POP A
           OUT SREG,A
           POP A
		   RET


INT_1:   PUSH A
         IN   A,SREG
         PUSH A
		 CBI  PORTB,LED
         CPI  KL_AVR_TOK_INV,5
		 BREQ INT_1_1
         INC  KL_AVR_TOK_INV
         RJMP RINT1
INT_1_1: SBR  FL_AVR_INV,(1<<F_AVR_TOK_INV) 
RINT1:   POP  A
         OUT  SREG,A
         POP  A
         RETI


RD_UART_INVER:        ;  USART
            push A 
            in   A,SREG
            push A
            push B
            LDS  B,UCSRB
            LDS  A,UDR
            SEI
            SBRS B,RXB8 
            RJMP RD_USR_1
            CPI  A,0B11000000
			BREQ RD_USR_2
            LDS  B,UCSRB
            CBR  B,(1<<TXEN) 
            STS  UCSRB,B
            CLR  SHAG_OBM
            RJMP RRD_USR
RD_USR_2:  	LDI  SHAG_OBM,1
            LDI  XL,$10       ;ADR_BUF_OBM
            LDI  XH,$01 
            MOV  SYM_OBM,A
            RJMP RRD_USR
RD_USR_1:   TST  SHAG_OBM
            BREQ RRD_USR
            CPI  SHAG_OBM,1
            BREQ RD_USR_3
            CPI  SHAG_OBM,2
            BREQ RD_USR_3
            CPI  SHAG_OBM,3
            BRNE RD_USR_4
RD_USR_3:   ADD  SYM_OBM,A
            ST   X+,A
            RJMP RD_USR_5
RD_USR_4:  	CP   SYM_OBM,A
            BREQ RD_USR_6
            SBR  FL_AVR_INV,(1<<F_AVR_SM_OBM_INV)
            CLR  SHAG_OBM
            RJMP RRD_USR
RD_USR_6:   CBR  FL_AVR_INV,(1<<F_AVR_SM_OBM_INV)
            LDS  B,UCSRB
            SBR  B,(1<<TXEN) 
            STS  UCSRB,B
            RCALL OBR_BUF_OBM
            MOV  SYM_OBM,FL_AVR_INV
        	STS  UDR,FL_AVR_INV
            LDI  A,2
            MOV  PAUZ_OBM,A
RD_USR_5:   INC  SHAG_OBM
RRD_USR:    POP B
            POP A
            OUT SREG,A
            POP A
            RETI




OBR_BUF_OBM:
         LDI XL,$10       ;ADR_BUF_OBM
         LDI XH,$01 
         LD  FL_TR_RAB_INV,X+
         LD  ZAD1_INV,X+
         LD  ZAD2_INV,X+
         RET


WR_UART_INVER:
            push A         ; USART
            in A,SREG
            push A
            push B
            CPI  SHAG_OBM,8
            BRNE WR_USR_1
            LDS  B,UCSRB
            CBR  B,(1<<TXEN) 
            STS  UCSRB,B
            CLR  SHAG_OBM
			LDI  A,70
			MOV  VR_K_OBM,A
            RJMP WR_USR_8
WR_USR_1:   CPI  SHAG_OBM,5
            BRNE WR_USR_5
        	MOV  A,FL_SIS_INV
            RJMP WR_USR_3
WR_USR_5:   CPI  SHAG_OBM,6
            BRNE WR_USR_6
            MOV  A,VR_K_OBM ;---------------------
        	;MOV A,REZ1_INV ;============
WR_USR_3:   ADD  SYM_OBM,A
            RJMP WR_USR_7
WR_USR_6:   CPI  SHAG_OBM,7
            BRNE RWR_USR
            MOV  A,SYM_OBM  	
WR_USR_7:   STS  UDR,A
            INC  SHAG_OBM
            LDI  A,3
            MOV  PAUZ_OBM,A
WR_USR_8:   LDS  A,UCSRA
            SBR  A,(1<<TXC) 
            STS  UCSRA,A
RWR_USR:    POP B
            POP A
            OUT SREG,A
            POP A
            RET



PEREP_TC0: SEI                   ; TC0  2
           push B
           push A
           in   A,SREG
           push A
           WDR                   ;RES STOR TAIMER
           LDI  KONT_PRX_PROG,40
           TST  PAUZ_OBM
		   BREQ DEL_7
		   DEC  PAUZ_OBM
           RJMP DEL_8
DEL_7:     LDS  A,UCSRA
           SBRS A,TXC 
           RJMP DEL_8
           RCALL WR_UART_INVER
DEL_8:     TST  DEL_01CEK
	       BREQ DEL5
		   DEC  DEL_01CEK
           RJMP RDEL
DEL5:      LDI  A,43
           MOV  DEL_01CEK,A
           RCALL OBR_01SEK
DEL1:      LDS  A,DEL_1CEK
           TST  A
		   BREQ DEL2
		   DEC  A
		   STS  DEL_1CEK,A
           RJMP RDEL
DEL2:      LDI  A,9
		   STS  DEL_1CEK,A
           RCALL OBR_1SEK
DEL6:      LDS  A,DEL_1MINYT
           TST  A
		   BREQ DEL3
		   DEC  A
		   STS  DEL_1MINYT,A
           RJMP RDEL
DEL3:      LDI  A,60
		   STS  DEL_1MINYT,A
           RCALL OBR_1MIN
           LDS  A,DEL_1CZAS
           TST  A
		   BREQ DEL4
		   DEC  A
		   STS  DEL_1CZAS,A
           RJMP RDEL
DEL4:      LDI  A,60
		   STS  DEL_1CZAS,A
           RCALL OBR_1CZAS
RDEL:      POP A
           OUT SREG,A
           POP A
           POP B
           RETI



OBR_01SEK: 
         RCALL OBR_IND
         TST   VR_K_OBM
         BREQ  OB01S_1
         DEC   VR_K_OBM
         RJMP  ROB01S
OB01S_1: SBR   FL_AVR_INV,(1<<F_AVR_OBM_INV)
ROB01S:  RET


OBR_1SEK: LDS  A,VR_PDG_STAPT
		  TST  A
		  BREQ OB1S_1
          DEC  A
		  STS  VR_PDG_STAPT,A
OB1S_1:   RCALL CIKL_RAB
ROB1S:    RET


OBR_1MIN:    
ROB_1M:    RET

OBR_1CZAS: LDI A,5
           STS KOL_PEREZ,A
ROB_1CZ:   RET



CIKL_RAB:   TST  SHG_CKL_RAB
            BRNE CL_RAB_1
            LDI  A,5
			STS  VR_PDG_STAPT,A
            INC  SHG_CKL_RAB
            RJMP RCKL_RAB
CL_RAB_1:   MOV  A,SHG_CKL_RAB
            CPI  A,1
            BRNE CL_RAB_2
            LDS  A,VR_PDG_STAPT
			TST  A
			BRNE RCKL_RAB
            CLR  FL_AVR_INV
            LDI  A,3
			MOV  SHG_CKL_RAB,A
            RJMP RCKL_RAB
CL_RAB_2:   SBRS FL_AVR_INV,F_FOT_AVR_INV
            RJMP CL_RAB_3
            CBR  FL_SIS_INV,(1<<F_RABOT_INV)
            RJMP RCKL_RAB
CL_RAB_3:   SBRS FL_AVR_INV,F_AVR_OBM_INV 
            RJMP CL_RAB_9
            CBR  FL_AVR_INV,(1<<F_AVR_OBM_INV)
            RJMP CL_RAB_5
CL_RAB_9:   SBRC FL_TR_RAB_INV,F_TR_RAB_INV
            RJMP CL_RAB_6
CL_RAB_5:   CBR  FL_SIS_INV,(1<<F_RABOT_INV)
            LDI  A,K_VR_PEREZ
			STS  VR_PEREZ,A
            LDI  A,3
			MOV  SHG_CKL_RAB,A
            RJMP RCKL_RAB
CL_RAB_6:   CPI  A,2
            BRNE CL_RAB_7
            SBRC FL_AVR_INV,F_AVR_TOK_INV
            RJMP CL_RAB_4
            TST  KL_AVR_TOK_INV
			BREQ RCKL_RAB
			DEC  KL_AVR_TOK_INV
            RJMP RCKL_RAB
CL_RAB_4:   LDS  A,KOL_PEREZ
			TST  A
			BRNE CL_RAB_8
            SBR  FL_AVR_INV,(1<<F_FOT_AVR_INV)
            RJMP RCKL_RAB
CL_RAB_8:   DEC  A
			STS  KOL_PEREZ,A     ;====================
            LDI  A,K_VR_PEREZ
			STS  VR_PEREZ,A
			INC  SHG_CKL_RAB
            RJMP RCKL_RAB
CL_RAB_7:   LDS  A,VR_PEREZ
			TST  A
			BREQ CL_RAB_10
            DEC  A
	        STS  VR_PEREZ,A
            RJMP RCKL_RAB
CL_RAB_10:  CBR  FL_AVR_INV,(1<<F_AVR_TOK_INV)
            SBR  FL_SIS_INV,(1<<F_RABOT_INV)
            LDI  A,2
			MOV  SHG_CKL_RAB,A
            CLR  KL_AVR_TOK_INV
RCKL_RAB:   RET



OBR_IND:    LDS A,VR_PDG_STAPT
            TST A
			BRNE OBR_IND_5
            SBRS FL_AVR_INV,F_AVR_TOK_INV
            RJMP OBR_IND_6
            LDI A,2
			STS LED_IMPL,A
            RJMP OBR_IND_5
OBR_IND_6:	SBRS FL_AVR_INV,F_AVR_OBM_INV 
            RJMP OBR_IND_8
            LDI A,3
			STS LED_IMPL,A
            RJMP OBR_IND_5
OBR_IND_8:	SBRS FL_AVR_INV,F_AVR_SM_OBM_INV 
            RJMP OBR_IND_5
            LDI A,4
			STS LED_IMPL,A
OBR_IND_5:  LDS A,SHIM_IND
            CPI A,1
            BRNE OBR_IND1
			SBI PORTB,LED
            RJMP OBR_IND2
OBR_IND1:   CPI A,6
            BRNE OBR_IND2
            LDS A,KOL_IMP_IND
            CPI A,0
            BRNE OBR_IND3
            LDS A,PAYZA_IND
            CPI A,0
            BRNE OBR_IND4
			LDS A,LED_IMPL
            STS  KOL_IMP_IND,A
            RJMP R_OBR_IND
OBR_IND4:	DEC A
            STS PAYZA_IND,A
            RJMP R_OBR_IND
OBR_IND3:	DEC A
            STS KOL_IMP_IND,A
			LDI A,0
            STS SHIM_IND,A
			CBI PORTB,LED
			LDI A,10
            STS  PAYZA_IND,A
            RJMP R_OBR_IND
OBR_IND2:   INC A
            STS SHIM_IND,A
R_OBR_IND:  RET


PEREP_TC1:                     ; TC1   
         push A
         in   A,SREG
         push A
         TST  KONT_PRX_PROG
		 BRNE PRTC1_3
         CBI  DDRB,1
         CBI  DDRB,2
         JMP  NACZALO
PRTC1_3: DEC  KONT_PRX_PROG
         SBRC FL_AVR_INV,F_FOT_AVR_INV
         RJMP PRTC1_7
         SBRS FL_SIS_INV,F_RABOT_INV
         RJMP PRTC1_7
         SBRS FL_AVR_INV,F_AVR_TOK_INV
         RJMP PRTC1_1
PRTC1_7: CBI  DDRB,1
         CBI  DDRB,2
         LDI  SHAG_SIN,255
         RJMP RPERTC1
PRTC1_1: SBI  DDRB,1
         SBI  DDRB,2
         INC  SHAG_SIN
         PUSH R0 
         PUSH ZL 
         PUSH ZH 
         LDI  ZL,LOW(TAB_SIN*2)
         LDI  ZH,HIGH(TAB_SIN*2)
         ADD  ZL,SHAG_SIN
		 CLR  A
		 ADC  ZH,A
         LPM 
		 MOV  A,R0
		 LDI  ZL,2
		 SUB  A,ZL
         STS  OCR1AL,A
         ADD  A,ZL
         ADD  A,ZL
         STS  OCR1BL,A
         POP  ZH
         POP  ZL
         POP  R0
RPERTC1: POP  A
         OUT  SREG,A
         POP  A
         RETI


KONS_RG:
.DB 0,1,2,0,0,0,70,0                   ;1
.DB 0,0,0,0,0,0,0,0B00000000           ;9
.DB 0B00000000,0,40,0,255,0,0,0        ;17
.DB 0,0,0,0,0,0,0,0                    ;25

KONS_100H:
.DB 1,1,1,0,0,0,1,5         ;100
.DB 5,5,0,0,0,0,0,0         ;108
.DB 0,0,0,0,0,0,0,0         ;110
.DB 0,0,0,0,0,0,0,0         ;118




;TAB_SIN1:
	.db	128,131,134,137,140,144,147,150,153,156,159,162,165,168,171,174
	.db	177,179,182,185,188,191,193,196,199,201,204,206,209,211,213,216
	.db	218,220,222,224,226,228,230,232,234,235,237,239,240,241,243,244
	.db	245,246,248,249,250,250,251,252,253,253,254,254,254,254,254,254
	.db	254,254,254,254,254,254,254,253,253,252,251,250,250,249,248,246
	.db	245,244,243,241,240,239,237,235,234,232,230,228,226,224,222,220
	.db	218,216,213,211,209,206,204,201,199,196,193,191,188,185,182,179
	.db	177,174,171,168,165,162,159,156,153,150,147,144,140,137,134,131
	.db	128,125,122,119,116,112,109,106,103,100,97,94,91,88,85,82
	.db	79,77,74,71,68,65,63,60,57,55,52,50,47,45,43,40
	.db	38,36,34,32,30,28,26,24,22,21,19,17,16,15,13,12
	.db	11,10,8,7,6,6,5,4,3,3,2,2,2,1,1,1
	.db	1,1,1,1,2,2,2,3,3,4,5,6,6,7,8,10
	.db	11,12,13,15,16,17,19,21,22,24,26,28,30,32,34,36
	.db	38,40,43,45,47,50,52,55,57,60,63,65,68,71,74,77
	.db	79,82,85,88,91,94,97,100,103,106,109,112,116,119,122,125



TAB_SIN:
	.db	128,131,134,137,140,144,147,150,153,156,159,162,165,168,171,174
	.db	177,179,182,185,188,191,193,196,199,201,204,206,209,211,213,216
	.db	218,220,222,224,226,228,230,232,234,235,237,239,240,241,243,244
	.db	245,246,248,249,250,250,251,252,253,253,253,253,253,253,253,253
	.db	253,253,253,253,253,253,253,253,253,252,251,250,250,249,248,246
	.db	245,244,243,241,240,239,237,235,234,232,230,228,226,224,222,220
	.db	218,216,213,211,209,206,204,201,199,196,193,191,188,185,182,179
	.db	177,174,171,168,165,162,159,156,153,150,147,144,140,137,134,131
	.db	128,125,122,119,116,112,109,106,103,100,97,94,91,88,85,82
	.db	79,77,74,71,68,65,63,60,57,55,52,50,47,45,43,40
	.db	38,36,34,32,30,28,26,24,22,21,19,17,16,15,13,12
	.db	11,10,8,7,6,6,4,3,2,2,2,2,2,2,2,2
	.db	2,2,2,2,2,2,2,2,2,3,4,6,6,7,8,10
	.db	11,12,13,15,16,17,19,21,22,24,26,28,30,32,34,36
	.db	38,40,43,45,47,50,52,55,57,60,63,65,68,71,74,77
	.db	79,82,85,88,91,94,97,100,103,106,109,112,116,119,122,125



;TAB_MSIN:
	.db	$80,$80,$80,$80,$80,$80,$80,$80,$80,$80,$80,$80,$80,$80,$80,$80
	.db	$88,$90,$98,$A0,$A8,$B0,$B8,$C0,$C8,$D0,$D8,$E0,$E8,$F0,$F8,$FD
	.db	$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD
	.db	$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD
	.db	$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD
	.db	$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD,$FD
	.db	$FD,$F8,$F0,$E8,$E0,$D8,$D0,$C8,$C0,$B8,$B0,$A8,$A0,$98,$90,$88
	.db	$80,$80,$80,$80,$80,$80,$80,$80,$80,$80,$80,$80,$80,$80,$80,$80
	.db	$80,$80,$80,$80,$80,$80,$80,$80,$80,$80,$80,$80,$80,$80,$80,$80
	.db	$78,$70,$68,$60,$58,$50,$48,$40,$38,$30,$28,$20,$18,$10,$08,$02
	.db	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
	.db	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
	.db	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
	.db	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
	.db	$08,$10,$18,$20,$28,$30,$38,$40,$48,$50,$58,$60,$68,$70,$78,$80
	.db	$80,$80,$80,$80,$80,$80,$80,$80,$80,$80,$80,$80,$80,$80,$80,$80




