       ;UPS IND_2

.EQU  PINB=0x03   ;  
.EQU  DDRB=0x04   ; 
.EQU  PORTB=0x05  ;  
.equ  E             =0
.equ  KLAV_L        =1
.equ  VKL_AKM       =2
.equ  KLAV_X        =3
.equ  KLAV_H        =4
.equ  GEN           =5
.equ  RS            =6
.equ  RW            =7


.EQU PINC=0x06    ;  
.EQU DDRC=0x07    ; 
.EQU PORTC=0x08   ;  
.equ  LED           =2


.EQU PIND=0x09    ;  
.EQU DDRD=0x0A    ; 
.EQU PORTD=0x0B   ;  
.equ  ZYMER         =2
.equ  U_LDS         =3
.equ  D0            =4
.equ  D4            =4
.equ  D1            =5
.equ  D5            =5
.equ  D2            =6
.equ  D6            =6
.equ  D3            =7
.equ  D7            =7


.EQU EECR=0x1F    ;  EEPROM
.equ   EERE 	=0
.equ   EEPE 	=1
.equ   EEMPE 	=2
.equ   EERIE 	=3
.equ   EEPM0 	=4
.equ   EEPM1 	=5

.EQU EEDR=0x20    ;DAN EEPROM
.EQU EEARL=0x21   ;ADR  EEPROM
.EQU EEARH=0x22   ;ADR  EEPROM

.EQU WDTCSR=0x60   ; 
.equ   WDIF 	=7
.equ   WDIE 	=6
.equ   WDP3 	=5
.equ   WDCE 	=4
.equ   WDE   	=3
.equ   WDP2 	=2
.equ   WDP1 	=1
.equ   WDP0 	=0

.EQU TCCR2A=0xB0   ;  2
.EQU TCCR2B=0xB1
.EQU TCNT2=0xB2
.EQU OCR2A=0xB3    ;  2 
.EQU OCR2B=0xB4    ;  2 
.EQU ASSR=0xB6

.EQU TCCR1A=0x80   ;   1
.equ COM1B0  =4 
.equ COM1B1  =5 
.EQU TCCR1B=0x81   ;   1
.EQU TCNT1H=0x85
.EQU TCNT1L=0x84
.EQU OCR1AH=0x89   ;  1 .   
.EQU OCR1AL=0x88  
.EQU SH_MOST_H=0x88
.EQU OCR1BH=0x8B   ;  1 . 
.EQU OCR1BL=0x8A   ;  1 .  
.EQU SH_MOST_L=0x8A   
.EQU ICR1H=0x87   ;
.EQU ICR1L=0x86   ;

.EQU TCCR0A=0x44    ;   TC0
.EQU TCCR0B=0x45    ;   TC0
.EQU TCNT0=0x46     ; TC0
.EQU OCR0A=0x47     ;  0 
.EQU OCR0B=0x48     ;  0 

.EQU TIMSK0=0x6E    ;   0
.EQU TIFR0=0x15


.EQU TIMSK1=0x6F    ;   
.EQU TIFR1=0x16

.EQU EICRA=0x69    ;  INT0
.equ ISC11   =3
.equ ISC10   =2
.equ ISC01   =1
.equ ISC00   =0

.EQU EIMSK=0x3D     ;   INT0
.equ INT1    =1
.equ INT0    =0

.EQU EIFR=0x3C      ;   INT0
.equ INTF1    =1
.equ INTF0    =0

.EQU SPL=0x3D
.EQU SPH=0x3E
.EQU SREG=0x3F

.EQU UDR=0xC6     ; USART
.EQU UCSRA=0xC0   ; USART
.equ RXC   =7 
.equ TXC   =6 
.equ UDRE  =5
.equ FE    =4
.equ DOR   =3
.equ UPE   =2
.equ U2X   =1
.equ MPCM  =0

.EQU UCSRB=0xC1   ; USART
.equ RXCIE   =7 
.equ TXCIE   =6 
.equ UDRIE   =5
.equ RXEN    =4
.equ TXEN    =3
.equ UCSZ2   =2
.equ RXB8    =1
.equ TXB8    =0

.EQU UCSRC=0xC2   ; USART
.equ UMSEL1  =7
.equ UMSEL0  =6 

.EQU UBRRH=0xC5   ; USART
.EQU UBRRL=0xC4   ; USART

.EQU ADCL=0x78    ;  . 
.EQU ADCH=0x79    ;  . 
.EQU ADCSRA=0x7A  ;  
.equ ADSC =6
.EQU ADMUX=0x7C   ;  
.equ ADLAR =5

.EQU OSCCAL=0x66

.def RAB_BYF              =r2
.def SYM_OBM              =r3
.def ADR_BUF_OBM          =r4
.def INTG_TOK_ZAR         =r5  ;  
.def REZ1_ZAR             =r6
.def REZ_300V             =r7  ;   DC12-330
.def INTG_TOK_AKM         =r8  ;   DC12-330



.def  FL_SIST_IND         =r16 ;10    
.equ  F_RABOT             =0
.equ  F_WR_EPROM          =1   ;   EPROM
.equ  F_IND_AVR           =2   ;   
.equ  F_GOT_LCD           =3   ;  LCD
.equ  F_NTG1_TOK_AKM      =4
.equ  F_GEN               =5   ;   
.equ  F_SISTEM            =7

.def  FL_AVR_IND          =r17  ;11    
.equ  F_ERR_EPROM         =0    ;   EPROM
.equ  F_AVR_SET           =1    ;   
.equ  F_MIN_V_AKM         =2    ;   .
.equ  F_AVR_TERM_ZAR_IND  =3
.equ  F_AVR_TERM_DC3_IND  =4
.equ  F_FAT_AVR_IND       =7

.def  TREB_FL_IND         =r18  ;12     
.equ  F_TR_WR_EPROM       =0    ; .  EPROM
.equ  F_TR_SIS            =1    ; . . 
                                ;    
			                    ; ,,  
.equ  F_TR_OTV_OBM        =2
.equ  F_RAZR_OBM          =3
.equ  F_NAGRZ             =4    ; 
.equ  F_TR_UST_IND        =5    ; .
.equ  F_TR_RST_KONC       =6    ; .   

.def  VLT_ZAR             =r19  ;13
.def  VLT_SET             =r20  ;14
.def  SHAG_OBM            =r21  ;15

.def  FL_AVR_OBM_IND      =r22  ;16     
.equ  F_AVR_OBM_DC3_2       =0  ; .   DC12-330
.equ  F_AVR_OBM_ZAR_2       =1
.equ  F_AVR_OBM_INV_2       =2
.equ  F_AVR_SYM_OBM_DC3_2   =3  ; .     DC12-330
.equ  F_AVR_SYM_OBM_INV_2   =4
.equ  F_AVR_SYM_OBM_ZAR_2   =5

.def A  =r23
.def B  =r24
.def C  =r25
.def XL =r26      ;
.def XH =r27
.def YL =r28      ;
.def YH =r29  
.def ZL =r30      ;
.def ZH =r31      ;


.EQU Z_VLT_ZAR_1          =0x100  ;$A0
.EQU Z_TOK_AKM_1          =0x101  ;$0B
.EQU Z_VLT_ZAR_2          =0x102  ;$A7
.EQU Z_TOK_AKM_2          =0x103  ;$0F
.EQU Z_MIN_VLT_AKM        =0x104  ;$90
.EQU Z_KMP_TOK_AKM        =0x105  ;$03
.EQU Z_KPD_TOK_AKM        =0x106  ;70
.EQU Z_MAKS_VLT_SET       =0x107  ;$C0
.EQU Z_MIN_VLT_SET        =0x108  ;$7D
.EQU Z_VLT_OUT            =0x109  ;40
.EQU SYM_TOK_AKM_H        =0x10A  ;$0
.EQU SYM_TOK_AKM_L        =0x10B  ;$19
.EQU Z_PI_VLT_DC3         =0x10C  ;6
.EQU Z_VR_SHM_DC3         =0x10D  ;1
.EQU Z_PI_ZAR_H           =0x10E  ;$10  
.EQU Z_PI_ZAR_L           =0x10F  ;$09  
.EQU Z_PI_OGR_TOK_AKM     =0x110  ;$03  
.EQU Z_PI_TOK_ZAR         =0x111  ;$05  
.EQU KN_AVR_TOK_ZAR       =0x112  ;$1E  
.EQU KN_0_INTG_TOK_AKM    =0x113  ;$80
;.EQU KN_KF_MOSH_AKM       =0x114  ;14
;.EQU KN_KF_MOSH_SET       =0x115  ;5
.EQU KN_KF_TOK_IND_AKM    =0x116  ;9
.EQU KN_MAKS_TERM_ZAR     =0x117  ;80-46C
.EQU KN_MAKS_TERM_DC      =0x118  ;80
;.EQU KN_MAKS_TERM         =0x119  ;$50
.EQU KN_0_VLT_OUT         =0x11A  ;$4B
;.EQU KN_135_VLT_SET       =0x11B  ;$83

.EQU TREB_FL_RAB          =0x12D  ;1
.equ F_TR_ZVUK      =0
.equ F_TR_EKONOM    =1
;.EQU KONT_EPROM           =0x12E  ;$83

.EQU Z_VLT_ZAR             =0x140  ;$A7
.EQU Z_TOK_AKM             =0x141  ;$0B
.EQU VR_VLT_ZAR            =0x142  ;$0

.EQU BUF_OBM0              =0x150  ; 
.EQU BUF_OBM1              =0x151
.EQU BUF_OBM2              =0x152
.EQU BUF_OBM3              =0x153
.EQU BUF_OBM4              =0x154
.EQU BUF_OBM5              =0x155
.EQU BUF_OBM6              =0x156
.EQU BUF_OBM7              =0x157
.EQU BUF_OBM8              =0x158
.EQU BUF_OBM9              =0x159
.EQU ADR_BUF_OBML          =0x15A
.EQU ADR_BUF_OBMH          =0x15B
.EQU REZ_TOK_AKM           =0x15C
.EQU YKZ_OBM               =0x160   ;$03
.EQU DEL_01CEK             =0x161
.EQU DEL_1CEK              =0x162
.EQU DEL_1MINYT            =0x163
.EQU DEL_1CZAS             =0x164
.EQU YDER_KLAV             =0x165
.EQU SHAG_IND              =0x166
.EQU SHAG_IND_BIL          =0x167
.EQU VR_U_LDS              =0x168
.EQU ZN1                   =0x169
.EQU ZN2                   =0x16A
.EQU ZN3                   =0x16B
.EQU ZN4                   =0x16C
.EQU ZN5                   =0x16D
.EQU CELOE_N               =0x16E
;.EQU OSTAT_N               =0x16F
.EQU DEL_32MC              =0x170
.EQU ZNAK_IND              =0x171
.EQU VR_IND_ZAD            =0x172
.EQU VR_OJD_OBM            =0x173

.EQU FL_AVR_INV            =0x174 ; .   * 50*
.equ  F_AVR_TOK_INV        =0     ; .    
.equ  F_AVR_OBM_INV        =1     ; .   
.equ  F_AVR_SM_OBM_INV     =2     ; .     
.equ  F_FAT_AVR_INV        =7     ;     



.EQU FL_SIS_INV            =0x175 ; .   * 50*
.equ  F_RABOT_INV          =0

.EQU FL_TR_RAB_INV         =0x176
.equ  F_TR_RAB_INV         =0

.EQU ZAD1_INV              =0x177
.EQU ZAD2_INV              =0x178
.EQU REZ1_INV              =0x179

.EQU FL_AVR_DC3            =0x17A ; .  DC12-330
.equ  F_AVR_TOK_DC3        =0
.equ  F_AVR_12V            =1     ;..  . 
.equ  F_AVR_TERM_DC3       =2     ; .   DC12-330 
.equ  F_AVR_OBM_DC3        =3
.equ  F_AVR_SM_OBM_DC3     =4
.equ  F_FAT_AVR_DC3        =7      ;    DC12-330 

.EQU FL_SIS_DC3            =0x17B
.equ  F_NACL_DC3           =0
.equ  F_RAB_DC3            =1

.EQU FL_TR_RAB_DC3         =0x17C
.equ  F_TR_RAB_DC3      =0
.equ  F_TR_UST_DC3      =1
.equ  F_TR_RAB_AKM_DC3  =2


.EQU TERM_DC3              =0x17D

.EQU FL_AVR_ZAR            =0x17E  ; .   
.equ  F_AVR_TOK_ZAR	       =0      ; .     
.equ  F_AVR_TERM_ZAR	   =1      ; .    
.equ  F_SET_MIN	           =2      ;  .  
.equ  F_SET_MAKC           =3      ;  .  
.equ  F_AVR_OBM_ZAR        =4
.equ  F_AVR_SM_OBM_ZAR     =5
.equ  F_FAT_AVR_ZAR        =7      ;     

.EQU FL_SIS_ZAR            =0x17F ;02
.equ  F_START_ZAR          =0
.equ  F_NACL_ZAR           =1   ;   
.equ  F_VKL_SIL            =2   ;     
.equ  F_TERM_OGR_TOK       =3   ;      
.equ  F_SET_OGR_TOK        =4   ;      .
.equ  F_REZ_TOK_AKM        =5
.equ  F_REZ_TOK_ZAR        =6

.EQU FL_TR_RAB_ZAR         =0x180
.equ  F_TR_RAB_ZAR         =0
.equ  F_TR_UST_ZAR         =1

.EQU TERM_ZAR              =0x181    ;    
.EQU VR_IND_AVR            =0x182
.EQU AVR_SH_OBM_ZAR        =0x183
.EQU AVR_SH_OBM_DC3        =0x184
.EQU AVR_SH_OBM_INV        =0x185 ;5
.EQU KL_AVR_OBM_ZAR        =0x186
.EQU KL_AVR_OBM_DC3        =0x187
.EQU KL_AVR_OBM_INV        =0x188 ;3
.EQU SHG_CKL_RAB           =0x189
.EQU SHIM_ZVUK             =0x18A
.EQU KOL_IMP_ZVUK          =0x18B
.EQU BF_INTG_TOK_AKM_L     =0x18C
.EQU BF_INTG_TOK_AKM_H     =0x18D
.EQU KONT_PRX_PROG         =0x18E ;8
.EQU VR_DOSTYP             =0x18F
.EQU VR_K_12V              =0x190 ;10
.EQU DEL_01C_TC0           =0x191
.EQU KLAV_PRED             =0x192  ;   
.EQU KLAV_NAST             =0x193  ;    
.equ  F_KL_L               =0
.equ  F_KL_X               =1
.equ  F_KL_H               =2
;.equ  F_KL_PR             =3
.equ  F_YD_KL_30MS         =4      ;   30 
.equ  F_YD_KL_06S          =5
.equ  F_YD_KL_MAKS         =6
.equ  F_IZM_DAN_KL         =7      ;   

.EQU VR_WR_EPROM           =0x194
.EQU Z_TOK_FEN             =0x195  ;  
.EQU BF_INTG_VLT_ZAR_L     =0x196 ; $95
.EQU BF_INTG_VLT_ZAR_H     =0x197
.EQU INTG_VLT_ZAR          =0x198  ;$95
.EQU DEL_28C               =0x199
.EQU INTG1_TOK_AKM         =0x19A 
.EQU KL_SYM_TOK_AKM        =0x19B  ;28cek
.EQU SYM_H_TOK_AKM_H       =0x19C
.EQU SYM_H_TOK_AKM_L       =0x19D
.EQU SYM_L_TOK_AKM_H       =0x19E
.EQU SYM_L_TOK_AKM_L       =0x19F
.EQU OSTAT_SYM_H_TOK       =0x1A0
.EQU OSTAT_KPD_SYM_TOK     =0x1A1
.EQU INTG2_TOK_AKM         =0x1A2
.EQU KL_SYM_INTG_TOK_AKM   =0x1A3
.EQU SYM_INTG_TOK_AKM_H    =0x1A4
.EQU SYM_INTG_TOK_AKM_L    =0x1A5
.EQU PAYZA_ZVUK            =0x1A6
.EQU VR_K_GEN              =0x1A7
.EQU VR_NAGRZ              =0x1A8
.EQU VR_PAYZ_NAGRZ         =0x1A9
.EQU VR_START              =0x1AA
.EQU VR_RABOT              =0x1AB
.EQU VR_SHG_CKL            =0x1AC


;.EQU BF2_INTG_TOK_AKM_H    =0x1A3
;.EQU BF2_INTG_TOK_AKM_L    =0x1A4


.EQU  K_KF_MOSH_SET         =10   ;
.EQU  K_KF_MOSH_AKM         =14   ;

;.EQU  K_KF_TOK_IND_AKM     =9   ;12 11 10

.EQU  K_KF_TOK_IND_ZAR     =6    ;7 8 9 10


.EQU  K_0_TERM_DC          =36    ;      DC12-330
.EQU  K_KF_TERM_DC         =17    ;.  .    DC12-330
.EQU  K_0_TERM_ZAR         =36    ;
.EQU  K_KF_TERM_ZAR        =17    ;

.EQU  K_VKL_FEN            =60   ;.   
.EQU  K_OTK_FEN            =56   ;.   
.EQU  K_KF_VLT_ZAR         =73   ;.  .  

.EQU  K_0_VLT_OUT          =60   ;
.EQU  K_KF_VLT_OUT         =20   ;.  .  
.EQU  K_199_VLT_OUT        =200  ;

.EQU  K_135_VLT_SET        =25   ;
.EQU  K_KF_VLT_SET         =14   ;.  .  

.EQU  K_VLT_ZAR_GEN        =2    ;
.EQU  K_TOK_NAGRZ          =5    ;    



.ORG 0x00       
        rjmp  NACZALO
.ORG    0x1A
        rjmp  PEREP_TC1     ;  8MC
.ORG    0x1C
        rjmp  COMP_TC0A     ;  32MC
.ORG    0x24
        RJMP  RD_USART_IND    ;  USART
.ORG    0x28
        RJMP  WR_USART_IND    ;  USART


.ORG 0x30  
NACZALO:  CLI
 		  ;LDI A,$A5            ;KALIBRATOR
          ;STS OSCCAL,A 
          ldi A,0B00001100     ;RECZIM  PORT D
          out DDRD,A 
          ldi A,0B00001110     ;DAN     PORT D
          out PORTD,A     
          ldi A,0B11100101     ;RECZIM  PORT B
          out DDRB,A      
          ldi A,0B00011010     ;DAN     PORT B
          out PORTB,A     
          ldi A,0B00111111      ;RECZIM  PORT C
          out DDRC,A 
          ldi A,0B00000000     ;DAN     PORT C
          out PORTC,A     
          CBI PORTD,ZYMER
          SBI PORTC,LED
 

          LDI  C,20
VREM3:    LDI  A,255
VREM2:    LDI  B,255
VREM1:    DEC  B
          BRNE VREM1
	      DEC  A
          BRNE VREM2
	      DEC  C
          BRNE VREM3

          ldi A,0               ;ZAGR STEKA
          out SPL,A
          ldi A,$04             ;ZAGR STEKA

          out  SPH,A
          ldi  ZH,high(KONS_140*2)  ;ZAGR RAM 
          ldi  ZL,low(KONS_140*2)   ;140H-1AFH
          ldi  YH,$01               ;KUDA
          ldi  YL,$40
NCZL_6:   lpm
          st   Y+,r0
          adiw ZL,1
          CPI  YL,$AF
	  BRNE NCZL_6

          ldi  ZH,high(TABLE*2)   ;REG 1-22 
          ldi  ZL,low(TABLE*2)
          ldi  YH,0               ;KUDA  R1
          ldi  YL,1 
          ldi  A,22               ;KOL-VO
NCZL_7:   lpm
          st    Y+,r0
          adiw  ZL,1              ; +1
          dec   A
          brne  NCZL_7
          CALL RD_EPROM
          SBRS FL_AVR_IND,F_ERR_EPROM
          RJMP NCZL_1
          ldi  ZH,high(KONS_EPR100*2)  ;ZAGR RAM 
          ldi  ZL,low(KONS_EPR100*2)   ;100H-12FH
          ldi  YH,$01                  ;KUDA
          ldi  YL,$00
NCZL_5:   lpm
          st    Y+,r0
          adiw  ZL,1
          CPI   YL,$2F
	      BRNE  NCZL_5
          CALL  WR_EPROM
          SBR   TREB_FL_IND,(1<<F_TR_UST_IND)

NCZL_1:   LDI   A,0B00000010        ;ZAGRUZ  USART
	      STS   UCSRA,A
          LDI   A,0B00000110
	      STS   UCSRC,A
          LDI   A,0B11011100
	      STS   UCSRB,A 
          LDI   A,$01 
	      STS   UBRRH,A 
          LDI   A,$98             ;4.5MC
	      STS   UBRRL,A 

          CALL NAST_LCD     ;==================

          LDS A,TIMSK1          ;TIMSK TC1
	      SBR A,0B00000001
          STS TIMSK1,A  	
	      ldi A,0B00000000 
          STS TCCR1A,A 
	      LDI A,0B00000001
          STS TCCR1B,A  
		   
	      ldi A,1               ;TC0
          STS TCNT0,A 
          ldi A,250 
          STS OCR0A,A 
          STS OCR0B,A 
	      ldi A,0B00000010 
          STS TCCR0A,A 
	      LDI A,0B00000101
          STS TCCR0B,A  
          LDS A,TIMSK0     
	      SBR A,0B00000010
          STS TIMSK0,A  	

        ldi A,0B00011010      ;   
	    out TIFR0,A  

        SBI  PORTD,ZYMER
        ldi  YH,$00            ;IND SIST
        ldi  YL,$15

        WDR                      ;RES STOR TAIM
        LDS  A,WDTCSR            ;ZAG STOR TAIM
        SBR  A,(1<<WDCE)|(1<<WDE)
        STS  WDTCSR,A
        LDI  A,(1<<WDE)|(1<<WDP3)  ;4  
        STS  WDTCSR,A
        WDR                      ;RES STOR TAIM

        SBI  PORTB,VKL_AKM
        SEI
        CBI  PORTC,LED

NCZL_3: SBRS  TREB_FL_IND,F_TR_RST_KONC
        RJMP  NCZL_4
        SBRS  FL_SIST_IND,F_WR_EPROM
        RJMP  NCZL_4
        ldi   ZH,high(KONS_EPR100*2)  ;ZAGR RAM 
        ldi   ZL,low(KONS_EPR100*2)   ;100H-12FH
        ldi   YH,$01                  ;KUDA
        ldi   YL,$00
NCZL_2: lpm
        st    Y+,r0
        adiw  ZL,1
        CPI   YL,$2F
	    BRNE  NCZL_2
        CALL  WR_EPROM
        CBR   TREB_FL_IND,(1<<F_TR_RST_KONC)
        RJMP  NCZL_3
NCZL_4: SBRS  FL_SIST_IND,F_WR_EPROM
        RJMP  NCZL_3
       ; CBI  PORTD,ZYMER
        CALL  WR_EPROM
       ; SBI  PORTD,ZYMER
        RJMP  NCZL_3


OBR_SYM_TOK_AKM:        ; 28C
           PUSH XL
           PUSH XH
           PUSH YL
           PUSH YH
           PUSH B
           SBRS FL_SIST_IND,F_NTG1_TOK_AKM
           RJMP ROB_STA 
           CBR  FL_SIST_IND,(1<<F_NTG1_TOK_AKM)
           LDS  YL,SYM_INTG_TOK_AKM_L
           LDS  YH,SYM_INTG_TOK_AKM_H
           LDS  A,KL_SYM_INTG_TOK_AKM
           CALL DIV_16_8
           STS  INTG2_TOK_AKM,YL
           CLR  A
	       STS  SYM_INTG_TOK_AKM_H,A
	       STS  SYM_INTG_TOK_AKM_L,A
	       STS  KL_SYM_INTG_TOK_AKM,A
           MOV  A,YL
           LDS  B,KN_0_INTG_TOK_AKM
           SUB  A,B
           BREQ OB_STA_1
	       BRCC OB_STA_2
           NEG  A
           LDS  B,Z_KMP_TOK_AKM
	       CP   A,B
	       BRCS OB_STA_1
	       LDS  XL,SYM_H_TOK_AKM_L
           LDS  XH,SYM_H_TOK_AKM_H
           ADD  XL,A
	       CLR  A
	       ADC  XH,A
           STS  SYM_H_TOK_AKM_L,XL
	       STS  SYM_H_TOK_AKM_H,XH
           RJMP OB_STA_1
OB_STA_2:  LDS  B,Z_KMP_TOK_AKM
	       CP   A,B
	       BRCS OB_STA_1
           LDS  XL,SYM_L_TOK_AKM_L
           LDS  XH,SYM_L_TOK_AKM_H
           ADD  XL,A
	       CLR  A
	       ADC  XH,A
           STS  SYM_L_TOK_AKM_L,XL
	       STS  SYM_L_TOK_AKM_H,XH
OB_STA_1:  LDS  A,KL_SYM_TOK_AKM
           CPI  A,127
	       BREQ OB_STA_5
	       INC  A
	       STS  KL_SYM_TOK_AKM,A
           RJMP ROB_STA
OB_STA_8D: RJMP OB_STA_8
OB_STA_5: ; LDS A,SYM_H_TOK_AKM_H
          ; TST A
	      ; BRNE OB_STA_3
         ;  LDS A,SYM_H_TOK_AKM_L
         ;  CPI A,240
	      ; BRCC OB_STA_3
          ; LDS A,SYM_L_TOK_AKM_H
         ;  TST A
	      ; BRNE OB_STA_3
          ; LDS A,SYM_L_TOK_AKM_L
          ; CPI A,10
	    ;  BRCS OB_STA_8D
OB_STA_3:  RCALL OBR_KPD_TOK_AKM
           LDS  XL,SYM_H_TOK_AKM_L
           LDS  XH,SYM_H_TOK_AKM_H
           LDS  A,OSTAT_SYM_H_TOK
           ADD  XL,A
           CLR  A
	       ADC  XH,A
           STS  SYM_H_TOK_AKM_L,XL
	       STS  SYM_H_TOK_AKM_H,XH
	       CLR A
           STS OSTAT_SYM_H_TOK,A
           LDS XL,SYM_L_TOK_AKM_L
           LDS XH,SYM_L_TOK_AKM_H
           LDS A,SYM_H_TOK_AKM_L
           LDS B,SYM_H_TOK_AKM_H
           SUB A,XL
           SBC B,XH
	       BRCS OB_STA_6
           MOV YL,A
           MOV YH,B
           LDI A,127
           CALL DIV_16_8
           STS OSTAT_SYM_H_TOK,A
           MOV A,YL
           LDS XL,SYM_TOK_AKM_L
           LDS XH,SYM_TOK_AKM_H
           ADD XL,A
	       CLR A
	       ADC XH,A
	       BRCC OB_STA_7
           LDI XL,255
           LDI XH,255
OB_STA_7:  STS SYM_TOK_AKM_L,XL
	       STS SYM_TOK_AKM_H,XH
           RJMP OB_STA_8
OB_STA_6:  NEG A
           COM B
           MOV YL,A
           MOV YH,B
           LDI A,127
           CALL DIV_16_8
           MOV A,YL
           LDS XL,SYM_TOK_AKM_L
           LDS XH,SYM_TOK_AKM_H
           SUB XL,A
	       CLR A
	       SBC XH,A
	       BRCC  OB_STA_9
           CLR XL
           CLR XH
OB_STA_9:  STS SYM_TOK_AKM_L,XL
	       STS SYM_TOK_AKM_H,XH
OB_STA_8:  CLR A
           STS SYM_H_TOK_AKM_L,A
	       STS SYM_H_TOK_AKM_H,A
           STS SYM_L_TOK_AKM_L,A
	       STS SYM_L_TOK_AKM_H,A
     	   STS KL_SYM_TOK_AKM,A
ROB_STA:   POP B
           POP YH
           POP YL
           POP XH
           POP XL
	       RET


OBR_KPD_TOK_AKM:
             PUSH YL
             PUSH YH
             PUSH B
             PUSH R1
             PUSH R0
             LDS A,Z_KPD_TOK_AKM
			 CPI A,100
			 BREQ ROB_KP_TA
			 BRCC ROB_KP_TA
             LDS YL,SYM_H_TOK_AKM_L
             LDS YH,SYM_H_TOK_AKM_H
             TST YH
			 BRNE OB_KP_TA_1
			 CPI YL,100
			 BRCS ROB_KP_TA
OB_KP_TA_1:  LDS A,OSTAT_KPD_SYM_TOK
             ADD YL,A
		     CLR A
		     ADC YH,A
             LDI A,100
             CALL DIV_16_8
             STS OSTAT_KPD_SYM_TOK,A
             LDS A,Z_KPD_TOK_AKM
             MOVW XL,YL
             CALL MU_16_8     ; 2  XH:XL 
             STS SYM_H_TOK_AKM_L,XL
			 STS SYM_H_TOK_AKM_H,XH
ROB_KP_TA:   POP R0
             POP R1
             POP B
             POP YH
             POP YL
		     RET


PDG_IND_UMKS_AKM: 
           LDS  XL,SYM_TOK_AKM_L
           LDS  XH,SYM_TOK_AKM_H
           LDI  A,10
           CALL MU_16_8
           MOVW YL,XL
           LDS  A,KN_KF_TOK_IND_AKM
           CALL DIV_16_8
           MOVW XL,YL
		   RET



COMP_TC0A: PUSH A                  ;  32MC
           in A,SREG
           PUSH A
		   PUSH B
 		   LDS   A,KONT_PRX_PROG
           CPI   A,8
		   BRCS  PR_TC0_3
           RCALL NACZALO
PR_TC0_3:  LDI   A,10
           STS   KONT_PRX_PROG,A
           SEI  
 		   LDS   A,DEL_01C_TC0
           TST   A
	       BREQ  PR_TC0_2
		   DEC   A
		   STS   DEL_01C_TC0,A
           RJMP  RPR_TC0
PR_TC0_2:  LDI   A,2
           STS   DEL_01C_TC0,A
           CALL  KNT_GOT_LCD
           SBRC  FL_SIST_IND,F_GOT_LCD
           RJMP  PR_TC0_1
           CALL  NAST_LCD
		   LDI   A,15
		   STS   SHAG_IND_BIL,A
PR_TC0_1:  RCALL OBR_KLAV
           RCALL OBSL_LCD
RPR_TC0:   POP B
           POP A
           OUT SREG,A
           POP A
           RETI


PEREP_TC1: PUSH A              ;  8MC
           in   A,SREG
           PUSH A
		   PUSH B
           PUSH XL
		   PUSH XH
 		   LDS  A,KONT_PRX_PROG
           CPI  A,0
		   BRNE DEL_8
           RCALL NACZALO
DEL_8:     DEC   A
           STS   KONT_PRX_PROG,A
           ;SEI                     
           WDR               ;RES STOR TAIMER 
 		   LDS   A,DEL_32MC
           TST   A
	       BREQ  DEL_6
		   DEC   A
		   STS   DEL_32MC,A
           RJMP  DEL_7
DEL_6:     LDI   A,2
           STS   DEL_32MC,A
           RCALL FORM_OBM
DEL_7: 	   LDS   A,DEL_01CEK
           TST   A
	       BREQ  DEL_1
		   DEC   A
		   STS   DEL_01CEK,A
           RJMP  R_DEL
DEL_1:     LDI   A,12
           STS   DEL_01CEK,A
           RCALL OBR_01C
           LDS   A,DEL_1CEK
           TST   A
		   BREQ  DEL2
		   DEC   A
		   STS   DEL_1CEK,A
           RJMP  R_DEL
DEL2:      LDI   A,9
		   STS   DEL_1CEK,A
           LDS   A,VR_RABOT
           TST   A
		   BREQ  DEL3
		   DEC   A
		   STS   VR_RABOT,A
           RJMP  DEL9
DEL3:      SBR   FL_SIST_IND,(1<<F_RABOT)
DEL9:      RCALL OBR_1CEK
           LDS   A,DEL_1MINYT  
           TST   A
		   BREQ  DEL4
		   DEC   A
		   STS   DEL_1MINYT,A
           RJMP  R_DEL
DEL4:      LDI   A,59
		   STS   DEL_1MINYT,A
           LDS   A,DEL_1CZAS
           TST   A
		   BREQ  DEL5
		   DEC   A
		   STS   DEL_1CZAS,A
           RJMP  R_DEL
DEL5:      LDI   A,180
		   STS   DEL_1CZAS,A
           SBR   TREB_FL_IND,(1<<F_TR_WR_EPROM)
R_DEL:     POP XH
           POP XL
           POP B
           POP A
           OUT SREG,A
           POP A
           RETI


OBR_01C:   RCALL OBR_CIKL
           RCALL OBR_ZVUK      
           RET

OBR_ZVUK:   SBIS  PINB,VKL_AKM
            RJMP  OBR_ZV6
            SBRC FL_SIST_IND,F_SISTEM
            RJMP OBR_ZV6
            LDS A,VR_IND_AVR
            TST A
			BRNE OBR_ZV6
            LDS A,TREB_FL_RAB
            SBRC A,F_TR_ZVUK
            RJMP OBR_ZV5
OBR_ZV6:    SBI PORTD,ZYMER
            RJMP R_OBR_ZV
OBR_ZV5:    LDS A,SHIM_ZVUK
            CPI A,10
            BRNE OBR_ZV1
			SBI PORTD,ZYMER
            RJMP OBR_ZV2
OBR_ZV1:    CPI A,20
            BREQ OBR_ZV2
            INC A
            STS SHIM_ZVUK,A
            RJMP R_OBR_ZV
OBR_ZV2:    LDS A,KOL_IMP_ZVUK
            CPI A,0
            BREQ OBR_ZV3
        	DEC A
            STS KOL_IMP_ZVUK,A
			LDI A,0
            STS SHIM_ZVUK,A
			CBI PORTD,ZYMER
			LDI A,50
            STS  PAYZA_ZVUK,A
            RJMP R_OBR_ZV
OBR_ZV3:    LDS A,PAYZA_ZVUK
            CPI A,0
            BREQ OBR_ZV4
        	DEC A
            STS PAYZA_ZVUK,A
            RJMP R_OBR_ZV
OBR_ZV4:    SBRS FL_SIST_IND,F_IND_AVR 
            RJMP R_OBR_ZV
            LDI A,1
            STS  KOL_IMP_ZVUK,A
R_OBR_ZV:   RET


OBR_CIKL:  LDS   A,FL_AVR_DC3
           SBRC  A,F_FAT_AVR_DC3
           RJMP  OB_CKL_1
		   LDS   A,FL_AVR_INV
           SBRC  A,F_FAT_AVR_INV
           RJMP  OB_CKL_1
           SBRS  FL_AVR_OBM_IND,F_AVR_OBM_INV_2
           RJMP  OB_CKL_2
OB_CKL_1:  LDS   A,FL_TR_RAB_ZAR
           CBR   A,(1<<F_TR_RAB_ZAR)
		   STS   FL_TR_RAB_ZAR,A
           LDS   A,FL_TR_RAB_DC3
           CBR   A,(1<<F_TR_RAB_DC3)
		   STS   FL_TR_RAB_DC3,A
           LDS   A,FL_TR_RAB_INV
           CBR   A,(1<<F_TR_RAB_INV)
		   STS   FL_TR_RAB_INV,A
           CLR   A
		   STS   SHG_CKL_RAB,A
           LDI   A,50
		   STS   VR_SHG_CKL,A
           LDS   A,VR_START
		   TST   A
		   BRNE  ROB_CKLD
           CBI   PORTB,VKL_AKM
ROB_CKLD:  RJMP  ROB_CKL
OB_CKL_2:  LDI   A,30
		   STS   VR_START,A
           SBRS  TREB_FL_IND,F_TR_RST_KONC
           RJMP  OB_CKL_24
           SBR   FL_SIST_IND,(1<<F_WR_EPROM)
           RJMP  OB_CKL_25
OB_CKL_24: SBRS  TREB_FL_IND,F_TR_UST_IND
           RJMP  OB_CKL_12
OB_CKL_25: CBR   TREB_FL_IND,(1<<F_TR_UST_IND)
           LDS   A,FL_TR_RAB_ZAR
           CBR   A,(1<<F_TR_RAB_ZAR)
		   STS   FL_TR_RAB_ZAR,A
           LDS   A,FL_TR_RAB_DC3
           CBR   A,(1<<F_TR_RAB_DC3)
		   STS   FL_TR_RAB_DC3,A
           CLR   A
		   STS   SHG_CKL_RAB,A
           LDI   A,250
		   STS   VR_SHG_CKL,A
           RJMP  ROB_CKL
OB_CKL_12: LDS   A,FL_AVR_ZAR
           SBRC  A,F_SET_MAKC
           RJMP  OB_CKL_7
           SBRS  A,F_SET_MIN
           RJMP  OB_CKL_8
OB_CKL_7:  SBR   FL_AVR_IND,(1<<F_AVR_SET)
           RJMP  OB_CKL_9
OB_CKL_8:  CBR   FL_AVR_IND,(1<<F_AVR_SET)
OB_CKL_9:  LDS   A,SHG_CKL_RAB
           CPI   A,0
		   BRNE  OB_CKL_3D
           SBI   PORTB,VKL_AKM
           LDS   A,VR_SHG_CKL
		   CPI   A,240
		   BRNE  OB_CKL_19
           LDS   A,FL_TR_RAB_ZAR
           SBR   A,(1<<F_TR_UST_ZAR)
		   STS   FL_TR_RAB_ZAR,A
           LDS   A,FL_TR_RAB_INV
           SBR   A,(1<<F_TR_RAB_INV)
		   STS   FL_TR_RAB_INV,A
           RJMP  OB_CKL_20
OB_CKL_3D: RJMP  OB_CKL_3
OB_CKL_19: CPI   A,15
		   BRNE  OB_CKL_21
           STS   KN_0_INTG_TOK_AKM,INTG_TOK_AKM
           STS   KN_0_VLT_OUT,REZ_300V
           LDS   A,FL_TR_RAB_ZAR
           CBR   A,(1<<F_TR_UST_ZAR)
		   STS   FL_TR_RAB_ZAR,A
           RJMP  OB_CKL_20
OB_CKL_21: CPI   A,0
		   BREQ  OB_CKL_22
OB_CKL_20: LDS   A,VR_SHG_CKL
           DEC   A
		   STS   VR_SHG_CKL,A
           RJMP  ROB_CKL
OB_CKL_22: SBRS  FL_AVR_IND,F_AVR_TERM_DC3_IND
           RJMP  OB_CKL_13
           LDS   A,FL_TR_RAB_DC3
           CBR   A,(1<<F_TR_RAB_DC3)
		   STS   FL_TR_RAB_DC3,A
           LDS   A,FL_TR_RAB_INV
           CBR   A,(1<<F_TR_RAB_INV)
		   STS   FL_TR_RAB_INV,A
           RJMP  ROB_CKL
OB_CKL_13: LDS   A,FL_TR_RAB_DC3
           SBR   A,(1<<F_TR_RAB_DC3)
		   STS   FL_TR_RAB_DC3,A
           LDI   A,1
		   STS   SHG_CKL_RAB,A
           RJMP  ROB_CKL
OB_CKL_3:  CPI   A,1
		   BRNE  OB_CKL_4
           SBRS  FL_AVR_IND,F_AVR_TERM_DC3_IND
           RJMP  OB_CKL_18
           LDS   A,FL_TR_RAB_DC3
           CBR   A,(1<<F_TR_RAB_DC3)
		   STS   FL_TR_RAB_DC3,A
           LDS   A,FL_TR_RAB_INV
           CBR   A,(1<<F_TR_RAB_INV)
		   STS   FL_TR_RAB_INV,A
           LDS   A,FL_SIS_DC3
           SBR   A,(1<<F_NACL_DC3)
		   STS   FL_SIS_DC3,A
           RJMP  ROB_CKL
OB_CKL_18: LDS   A,FL_TR_RAB_DC3
           SBR   A,(1<<F_TR_RAB_DC3)
		   STS   FL_TR_RAB_DC3,A
           LDS   A,FL_SIS_DC3
           SBRS  A,F_NACL_DC3
           RJMP  OB_CKL_5 
           LDS   A,FL_TR_RAB_INV
           CBR   A,(1<<F_TR_RAB_INV)
		   STS   FL_TR_RAB_INV,A
           RJMP  ROB_CKL
OB_CKL_5:  SBRS  FL_AVR_IND,F_AVR_TERM_ZAR_IND
           RJMP  OB_CKL_14
           LDS   A,FL_TR_RAB_ZAR
           CBR   A,(1<<F_TR_RAB_ZAR)
		   STS   FL_TR_RAB_ZAR,A
           RJMP  ROB_CKL
OB_CKL_14: LDS   A,FL_TR_RAB_ZAR
           SBR   A,(1<<F_TR_RAB_ZAR)
		   STS   FL_TR_RAB_ZAR,A
           LDI   A,2
		   STS   SHG_CKL_RAB,A
           RJMP  ROB_CKL
OB_CKL_4:  CPI   A,2
		   BRNE  OB_CKL_6D
           SBRS  FL_AVR_IND,F_AVR_TERM_ZAR_IND
           RJMP  OB_CKL_16
           LDS   A,FL_TR_RAB_ZAR
           CBR   A,(1<<F_TR_RAB_ZAR)
		   STS   FL_TR_RAB_ZAR,A
           RJMP  OB_CKL_15
OB_CKL_6D: RJMP  OB_CKL_6
OB_CKL_16: LDS   A,FL_TR_RAB_ZAR
           SBR   A,(1<<F_TR_RAB_ZAR)
		   STS   FL_TR_RAB_ZAR,A
OB_CKL_15: SBRS  FL_AVR_IND,F_AVR_TERM_DC3_IND
           RJMP  OB_CKL_17
           LDS   A,FL_TR_RAB_DC3
           CBR   A,(1<<F_TR_RAB_DC3)
		   STS   FL_TR_RAB_DC3,A
           LDS   A,FL_TR_RAB_INV
           CBR   A,(1<<F_TR_RAB_INV)
		   STS   FL_TR_RAB_INV,A
           LDS   A,FL_SIS_DC3
           SBR   A,(1<<F_NACL_DC3)
		   STS   FL_SIS_DC3,A
           LDI   A,1
		   STS   SHG_CKL_RAB,A
           RJMP  ROB_CKL
OB_CKL_17: SBRS  FL_AVR_IND,F_AVR_SET
           RJMP  OB_CKL_11
           LDS   A,FL_TR_RAB_DC3
           SBR   A,(1<<F_TR_RAB_AKM_DC3)
		   STS   FL_TR_RAB_DC3,A
           SBRC   FL_AVR_IND,F_MIN_V_AKM
           RJMP   OB_CKL_10
           RCALL  OBR_EKONOM
           RJMP   ROB_CKL
OB_CKL_10: CLR   A
		   STS   SYM_TOK_AKM_H,A
		   STS   SYM_TOK_AKM_L,A
           LDS   A,FL_TR_RAB_INV
           CBR   A,(1<<F_TR_RAB_INV)
		   STS   FL_TR_RAB_INV,A
           SBR   TREB_FL_IND,(1<<F_TR_WR_EPROM)
           LDI   A,3
		   STS   SHG_CKL_RAB,A
           RJMP  ROB_CKL
OB_CKL_11: LDS   A,FL_TR_RAB_ZAR
           SBRS  A,F_TR_RAB_ZAR
           RJMP  OB_CKL_23
           LDS   A,FL_TR_RAB_DC3
           CBR   A,(1<<F_TR_RAB_AKM_DC3)
		   STS   FL_TR_RAB_DC3,A
           RJMP  OB_CKL_26
OB_CKL_23: LDS   A,FL_TR_RAB_DC3
           SBR   A,(1<<F_TR_RAB_AKM_DC3)
		   STS   FL_TR_RAB_DC3,A
OB_CKL_26: LDS   A,FL_TR_RAB_INV
           SBR   A,(1<<F_TR_RAB_INV)
		   STS   FL_TR_RAB_INV,A
           LDI   A,10
		   STS   VR_NAGRZ,A
           RJMP  ROB_CKL
OB_CKL_6:  CPI   A,3
		   BRNE  ROB_CKL
           SBRC  TREB_FL_IND,F_TR_WR_EPROM
           RJMP  ROB_CKL          
           SBRC  FL_SIST_IND,F_WR_EPROM
           RJMP  ROB_CKL        
           CBI   PORTB,VKL_AKM
           LDS   A,FL_SIS_DC3
           SBR   A,(1<<F_NACL_DC3)
           CBR   A,(1<<F_RAB_DC3)
		   STS   FL_SIS_DC3,A
           LDS   A,FL_SIS_ZAR
           SBRS  A,F_START_ZAR
           RJMP  ROB_CKL          
           CLR   A
		   STS   SHG_CKL_RAB,A
           LDI   A,250
		   STS   VR_SHG_CKL,A
ROB_CKL:   RET


OBR_EKONOM:
           LDS   A,TREB_FL_RAB
           SBRC  A,F_TR_EKONOM
           RJMP  OB_EKN_1
           LDS   A,FL_TR_RAB_INV
           SBR   A,(1<<F_TR_RAB_INV)
		   STS   FL_TR_RAB_INV,A
           RJMP  ROB_EKN
OB_EKN_1:  LDS   A,VR_PAYZ_NAGRZ
           TST   A
		   BREQ  OB_EKN_2
           CPI   A,3
           BRNE  ROB_EKN
           LDS   A,FL_TR_RAB_INV
           SBR   A,(1<<F_TR_RAB_INV)
		   STS   FL_TR_RAB_INV,A
           RJMP  ROB_EKN
OB_EKN_2:  SBRS  TREB_FL_IND,F_NAGRZ
           RJMP  OB_EKN_3       
           LDI   A,10
		   STS   VR_NAGRZ,A
           RJMP  ROB_EKN
OB_EKN_3:  LDS   A,VR_NAGRZ
           TST   A
		   BRNE  ROB_EKN
           LDI   A,30
		   STS   VR_PAYZ_NAGRZ,A
           LDS   A,FL_TR_RAB_INV
           CBR   A,(1<<F_TR_RAB_INV)
		   STS   FL_TR_RAB_INV,A
ROB_EKN:   RET



OBR_1CEK:  LDS   A,DEL_28C
           TST   A
	       BREQ  OB_1C_5
		   DEC   A
		   STS   DEL_28C,A
           RJMP  OB_1C_6
OB_1C_5:   LDI   A,27
           STS   DEL_28C,A
           RCALL OBR_SYM_TOK_AKM
OB_1C_6:   RCALL OBR_MIN_VLT_AKM
           RCALL OBR_GENERATOR
           RCALL OBR_TOK_ZAR
           CALL  OBR_TERM
           RCALL OBR_LED
           LDS  A,VR_START
           TST  A
		   BREQ OB_1C_9
		   DEC  A
		   STS  VR_START,A
OB_1C_9:   LDS  A,VR_DOSTYP
           TST  A
		   BREQ OB_1C_2
		   DEC  A
		   STS  VR_DOSTYP,A
OB_1C_2:   LDS  A,VR_IND_AVR
           TST  A
		   BREQ OB_1C_1
		   DEC  A
		   STS  VR_IND_AVR,A
OB_1C_1:   LDS  A,VR_NAGRZ
           TST  A
		   BREQ OB_1C_7
		   DEC  A
		   STS  VR_NAGRZ,A
OB_1C_7:   LDS  A,VR_PAYZ_NAGRZ
           TST  A
		   BREQ OB_1C_8
		   DEC  A
		   STS  VR_PAYZ_NAGRZ,A
OB_1C_8:   SBRS TREB_FL_IND,F_TR_WR_EPROM
           RJMP OB_1C_3 
           LDI  A,10
		   STS  VR_WR_EPROM,A
           CBR  TREB_FL_IND,(1<<F_TR_WR_EPROM)
           RJMP ROB_1C
OB_1C_3:   LDS  A,VR_WR_EPROM
           TST  A
		   BREQ ROB_1C
		   CPI  A,1
		   BRNE OB_1C_4
           SBR  FL_SIST_IND,(1<<F_WR_EPROM)
OB_1C_4:   DEC  A
		   STS  VR_WR_EPROM,A
ROB_1C:    RET


OBR_MIN_VLT_AKM:
             LDS  A,INTG_VLT_ZAR
             LDS  B,Z_MIN_VLT_AKM
             CP   A,B
             BRCS OB_12V_1
             LDS  A,VR_K_12V
             CPI  A,10
			 BRCC OB_12V_4
			 INC  A
			 STS  VR_K_12V,A 
             RJMP ROB_12V
OB_12V_4:    CBR  FL_AVR_IND,(1<<F_MIN_V_AKM)
             RJMP ROB_12V
OB_12V_1:    LDS  A,VR_K_12V
             TST  A
			 BREQ OB_12V_2
             DEC  A
			 STS  VR_K_12V,A
             RJMP ROB_12V
OB_12V_2:    SBR  FL_AVR_IND,(1<<F_MIN_V_AKM)
ROB_12V:     RET



OBR_LED:   SBIS  PINB,VKL_AKM
           RJMP  OB_LD_1
OB_LD_5:   SBRS  FL_SIST_IND,F_SISTEM
           RJMP  OB_LD_3
           CBI   PORTD,U_LDS
           RJMP  ROB_LD
OB_LD_3:   SBRS  FL_SIST_IND,F_IND_AVR
           RJMP  OB_LD_2
           SBIS  PORTD,U_LDS
           RJMP  OB_LD_4
           CBI   PORTD,U_LDS
           RJMP  ROB_LD
OB_LD_4:   SBI   PORTD,U_LDS
           RJMP  ROB_LD
OB_LD_2:   LDS   A,VR_U_LDS
           TST   A
		   BREQ  OB_LD_1
           DEC   A
		   STS   VR_U_LDS,A
           RJMP  ROB_LD
OB_LD_1:   SBI   PORTD,U_LDS
ROB_LD:    RET


OBR_GENERATOR:
           SBRS  FL_AVR_IND,F_AVR_SET
           RJMP  OB_GN_1
           LDS   A,Z_VLT_ZAR_2
		   CP    VLT_ZAR,A
		   BRCC  OB_GN_1
           LDS   A,Z_MIN_VLT_AKM
		   INC   A
		   INC   A
		   INC   A
           CP    VLT_ZAR,A
		   BRCS  OB_GN_4
           LDS   A,VR_K_GEN
		   TST   A
		   BREQ  ROB_GN
           DEC   A
           STS   VR_K_GEN,A
           RJMP  ROB_GN
OB_GN_4:   LDS   A,VR_K_GEN
		   CPI   A,5
		   BRNE  OB_GN_2
           SBR   FL_SIST_IND,(1<<F_GEN)
           SBI   PORTB,GEN
           RJMP  ROB_GN
OB_GN_2:   INC   A
           STS   VR_K_GEN,A
           RJMP  ROB_GN
OB_GN_1:   LDS   A,VR_K_GEN
		   TST   A
		   BRNE  OB_GN_3
           CBR   FL_SIST_IND,(1<<F_GEN)
           CBI   PORTB,GEN
           RJMP  ROB_GN
OB_GN_3:   DEC   A
           STS   VR_K_GEN,A
ROB_GN:    RET



OBR_TOK_ZAR: LDS  A,INTG_VLT_ZAR
             LDS  B,Z_VLT_ZAR_1
             CP   A,B
             BRCC OB_TZ_1
             LDS  A,VR_VLT_ZAR
             TST  A
			 BREQ OB_TZ_2
			 DEC  A
			 STS  VR_VLT_ZAR,A 
             RJMP ROB_TZ
OB_TZ_2:     LDS  A,Z_VLT_ZAR_1
             INC  A
             INC  A
			 STS  Z_VLT_ZAR,A 
             LDS  A,Z_TOK_AKM_1
			 STS  Z_TOK_AKM,A
             RJMP ROB_TZ
OB_TZ_1:     LDS  A,VR_VLT_ZAR
             CPI  A,10
			 BREQ OB_TZ_3
             INC  A
			 STS  VR_VLT_ZAR,A 
             RJMP ROB_TZ
OB_TZ_3:     LDS  A,Z_TOK_AKM_2
			 STS  Z_TOK_AKM,A
             LDS  A,Z_VLT_ZAR_2
			 STS  Z_VLT_ZAR,A 
ROB_TZ:      RET




OBR_KLAV:  LDS  A,KLAV_NAST
           SBIC PINB,KLAV_H
           RJMP KL_1
           SBR  A,(1<<F_KL_H)
           RJMP KL_2
KL_1:      CBR  A,(1<<F_KL_H)
KL_2:      SBIC PINB,KLAV_L
           RJMP KL_3
           SBR  A,(1<<F_KL_L)
           RJMP KL_4
KL_3:      CBR  A,(1<<F_KL_L)
KL_4:      SBIC PINB,KLAV_X
           RJMP KL_5
           SBR  A,(1<<F_KL_X)
           RJMP KL_6
KL_5:      CBR  A,(1<<F_KL_X)
KL_6:      STS  KLAV_NAST,A
           CBR  A,0B11111000
           LDS  B,KLAV_PRED
           CBR  B,0B11111000
	       CP   A,B
		   BREQ KL_7
           LDS  A,KLAV_NAST
           CBR  A,0B01111000
           STS  KLAV_NAST,A
           LDS  B,KLAV_PRED
           CBR  B,0B00000111
		   OR   B,A
           STS  KLAV_PRED,B
		   LDI  A,0
		   STS  YDER_KLAV,A
           RJMP KL_13
KL_7:      LDS  A,YDER_KLAV
           CPI  A,50
           BRNE KL_8
           LDS  A,KLAV_NAST
           SBR  A,(1<<F_YD_KL_MAKS)
           STS  KLAV_NAST,A
           RJMP KL_13
KL_8:      CPI  A,1
           BRNE KL_9
           LDS  A,KLAV_NAST
           SBR  A,(1<<F_YD_KL_30MS)
           STS  KLAV_NAST,A
           RJMP KL_11
KL_9:      CPI  A,7
           BRNE KL_10
           LDS  A,KLAV_NAST
           SBR  A,(1<<F_YD_KL_06S)
           CBR  A,(1<<F_YD_KL_30MS)
           STS  KLAV_NAST,A
           RJMP KL_11
KL_10:     LDS  A,KLAV_NAST
           CBR  A,(1<<F_YD_KL_30MS)
           STS  KLAV_NAST,A
KL_11:     LDS  A,YDER_KLAV
           INC  A
           STS  YDER_KLAV,A
           SBIS PINB,VKL_AKM
           RJMP KL_13
           CBI  PORTD,U_LDS
           LDI  A,100
		   STS  VR_U_LDS,A
KL_13:     SBRC FL_SIST_IND,F_SISTEM
           RJMP KL_12
	       RCALL KLAV_PRIKL
           RJMP RKL
KL_12:     CALL KL_SIS
RKL:       RET


KLAV_PRIKL:
         PUSH XL
		 PUSH XH
         SBIC  PINB,VKL_AKM       ;=====================
         RJMP  KL_PR1
         LDS   A,KLAV_NAST
         SBRS  A,F_YD_KL_06S
         RJMP  RKL_PR
         LDS   A,KLAV_PRED
         CBR   A,0B11111000
         CPI   A,0B00000101
		 BRNE  RKL_PR
         RJMP  NACZALO
KL_PR1:  LDS   A,KLAV_NAST
         SBRS  A,F_YD_KL_MAKS
         RJMP  KL_PR2
         SBRS  A,F_KL_X
         RJMP  KL_PR2
		 SBR   TREB_FL_IND,(1<<F_TR_SIS)
         RJMP  RKL_PR
KL_PR2:  SBRC  A,F_YD_KL_30MS
         RJMP  KL_PR3
         SBRS  A,F_YD_KL_06S
         RJMP  RKL_PR
KL_PR3:  LDS   A,KLAV_PRED
         CBR   A,0B11111000
         CPI   A,0B00000110    ;F_KL_X H
		 BRNE  KL_PR7
         RCALL OBR_KLAV_XL
         RJMP  RKL_PR
KL_PR7:  CPI   A,0B00000011    ;F_KL_X L
		 BRNE  KL_PR4
         RCALL OBR_KLAV_XH
         RJMP  RKL_PR
KL_PR4:  LDS  A,KLAV_PRED
         CBR  A,0B11111000
         CPI  A,0B00000101
		 BRNE KL_PR6
         LDI  A,255
		 STS  VR_DOSTYP,A
         RJMP RKL_PR
KL_PR6:  LDS  A,VR_DOSTYP
         TST  A
		 BREQ RKL_PR
         LDS  A,KLAV_PRED
         CBR  A,0B11111000
         CPI  A,0B00000100
		 BRNE KL_PR5
         RCALL OBR_KLAV_H
         RJMP KL_PR8
KL_PR5:  CPI  A,0B00000001
		 BRNE RKL_PR
         RCALL OBR_KLAV_L
KL_PR8:  LDI  A,255
		 STS  VR_DOSTYP,A
RKL_PR:  POP  XH
		 POP  XL
         RET


OBR_KLAV_XL:
           LDS  A,SHAG_IND
           CPI  A,0
		   BREQ ROB_KL_XL
           DEC  A
		   STS  SHAG_IND,A
ROB_KL_XL: RET


OBR_KLAV_XH:
           LDS  A,SHAG_IND
           CPI  A,16
		   BREQ ROB_KL_XH
           INC  A
		   STS  SHAG_IND,A
ROB_KL_XH: RET



OBR_KLAV_H:LDS  A,SHAG_IND
           CPI  A,0
		   BRNE OB_KL_H_1
           LDS  A,Z_VLT_ZAR_1
           CPI  A,250         ;
		   BRCC ROB_KL_HD
		   INC  A
           STS  Z_VLT_ZAR_1,A 
           RJMP OBKLH_2
ROB_KL_HD: RJMP ROBKLH
OB_KL_H_1: CPI  A,1
		   BRNE OB_KL_H_3
           LDS  A,Z_TOK_AKM_1
           CPI  A,200          ;100= 65A
		   BRCC ROB_KL_HD
		   INC  A
           STS  Z_TOK_AKM_1,A 
           RJMP OBKLH_2
OB_KL_H_3: CPI  A,2
		   BRNE OB_KL_H_4
           LDS  A,Z_VLT_ZAR_2
           CPI  A,250         ;
		   BRCC ROB_KL_HD
		   INC  A
           STS  Z_VLT_ZAR_2,A 
           RJMP OBKLH_2
OB_KL_H_4: CPI  A,3
		   BRNE OB_KL_H_5
           LDS  A,Z_TOK_AKM_2
           CPI  A,200          ;100= 65A
		   BRCC ROB_KL_HD
		   INC  A
           STS  Z_TOK_AKM_2,A 
           RJMP OBKLH_2
OB_KL_H_5: CPI  A,4
		   BRNE OB_KL_H_6
           LDS  A,Z_MIN_VLT_AKM
           LDS  B,Z_VLT_ZAR_2
		   SUBI B,5
		   CP   A,B
		   BREQ ROB_KL_HD
           INC  A
		   STS  Z_MIN_VLT_AKM,A
           RJMP OBKLH_2
OB_KL_H_6: CPI  A,5
		   BRNE OB_KL_H_7
           LDS  A,Z_KMP_TOK_AKM
           CPI  A,10
		   BRCC ROB_KL_HD
		   INC  A
           STS  Z_KMP_TOK_AKM,A 
           RJMP OBKLH_2
OB_KL_H_7: CPI  A,6
		   BRNE OB_KL_H_8 
           LDS  A,Z_KPD_TOK_AKM
           CPI  A,100
		   BRCC ROB_KL_HD
		   INC  A
           STS  Z_KPD_TOK_AKM,A 
           RJMP OBKLH_2
OB_KL_H_8: CPI  A,7
		   BRNE OB_KL_H_9 
		   CLR  A
		   STS  SYM_H_TOK_AKM_L,A
		   STS  SYM_H_TOK_AKM_H,A
		   STS  SYM_L_TOK_AKM_L,A
		   STS  SYM_L_TOK_AKM_H,A
		   STS  KL_SYM_TOK_AKM,A
		   STS  OSTAT_SYM_H_TOK,A
		   STS  OSTAT_KPD_SYM_TOK,A
           LDS  XH,SYM_TOK_AKM_H
           LDS  XL,SYM_TOK_AKM_L
           ADIW XL,1
           STS  SYM_TOK_AKM_H,XH
           STS  SYM_TOK_AKM_L,XL
           RJMP OBKLH_2
OB_KL_H_9: CPI  A,9
		   BRNE OBKLH_10
           LDS  A,Z_MAKS_VLT_SET
           CPI  A,200           ;
		   BRCC ROBKLH
		   INC  A
           STS  Z_MAKS_VLT_SET,A 
           RJMP OBKLH_2
OBKLH_10:  CPI  A,10
		   BRNE OBKLH_11
           LDS  A,Z_MIN_VLT_SET
           LDS  B,Z_MAKS_VLT_SET
		   SUBI B,10
		   CP   A,B
		   BREQ ROBKLH
		   INC  A
           STS  Z_MIN_VLT_SET,A 
           RJMP OBKLH_2
OBKLH_11:  CPI  A,11
		   BRNE OBKLH_12
           SBRC TREB_FL_IND,F_TR_UST_IND
           RJMP ROBKLH
           SBR  TREB_FL_IND,(1<<F_TR_UST_IND)
           RJMP ROBKLH
OBKLH_12:  CPI  A,12
		   BRNE OBKLH_13
           LDS  A,TREB_FL_RAB
           SBRC A,F_TR_ZVUK
           RJMP ROBKLH
           SBR  A,(1<<F_TR_ZVUK)
           STS  TREB_FL_RAB,A 
           RJMP OBKLH_2
OBKLH_13:  CPI  A,13
		   BRNE OBKLH_14
           LDS  A,TREB_FL_RAB
           SBRC A,F_TR_EKONOM
           RJMP ROBKLH
           SBR  A,(1<<F_TR_EKONOM)
           STS  TREB_FL_RAB,A 
           RJMP OBKLH_2
OBKLH_14:  CPI  A,14
		   BRNE OBKLH_15
           SBRC TREB_FL_IND,F_TR_RST_KONC
           RJMP ROBKLH
           SBR  TREB_FL_IND,(1<<F_TR_RST_KONC)
           RJMP OBKLH_2
OBKLH_15:  CPI  A,16
		   BRNE ROBKLH
           LDS  A,Z_VLT_OUT
           CPI  A,80         ;
		   BRCC ROBKLH
		   INC  A
           STS  Z_VLT_OUT,A 
OBKLH_2:   SBR  TREB_FL_IND,(1<<F_TR_WR_EPROM)
ROBKLH:    RET




OBR_KLAV_L:LDS  A,SHAG_IND
           CPI  A,0
		   BRNE OB_KL_L_1
           LDI  B,5         ;
           LDS  A,Z_MIN_VLT_AKM
		   ADD  A,B
           LDS  B,Z_VLT_ZAR_1 
           CP   B,A
		   BREQ ROB_KL_LD
		   DEC  B
           STS  Z_VLT_ZAR_1,B 
           RJMP OBKLL_2
OB_KL_L_1: CPI  A,1
		   BRNE OB_KL_L_3
           LDS  A,Z_TOK_AKM_1
           CPI  A,1
		   BREQ ROB_KL_LD
		   DEC  A
           STS  Z_TOK_AKM_1,A 
           RJMP OBKLL_2
OB_KL_L_3: CPI  A,2
		   BRNE OB_KL_L_4
           LDI  B,5            ;
           LDS  A,Z_MIN_VLT_AKM
		   ADD  A,B
           LDS  B,Z_VLT_ZAR_2 
           CP   B,A
		   BREQ ROB_KL_LD
		   DEC  B
           STS  Z_VLT_ZAR_2,B 
           RJMP OBKLL_2
OB_KL_L_4: CPI  A,3
		   BRNE OB_KL_L_5
           LDS  A,Z_TOK_AKM_2
           CPI  A,1
		   BREQ ROB_KL_LD
		   DEC  A
           STS  Z_TOK_AKM_2,A 
           RJMP OBKLL_2
OB_KL_L_5: CPI  A,4
		   BRNE OB_KL_L_6
           LDS  A,Z_MIN_VLT_AKM
		   CPI  A,100
		   BREQ ROB_KL_LD
           DEC  A
		   STS  Z_MIN_VLT_AKM,A 
           RJMP OBKLL_2
ROB_KL_LD: RJMP ROBKLL
OB_KL_L_6: CPI  A,5
		   BRNE OB_KL_L_7
           LDS  A,Z_KMP_TOK_AKM
           CPI  A,1
		   BREQ ROB_KL_LD
		   DEC  A
           STS  Z_KMP_TOK_AKM,A 
           RJMP OBKLL_2
OB_KL_L_7: CPI  A,6
		   BRNE OB_KL_L_8
           LDS  A,Z_KPD_TOK_AKM
           TST  A
		   BREQ ROB_KL_LD
		   DEC  A
           STS  Z_KPD_TOK_AKM,A 
           RJMP OBKLL_2
OB_KL_L_8: CPI  A,7
		   BRNE OB_KL_L_9
		   CLR  A
		   STS  SYM_H_TOK_AKM_L,A
		   STS  SYM_H_TOK_AKM_H,A
		   STS  SYM_L_TOK_AKM_L,A
		   STS  SYM_L_TOK_AKM_H,A
		   STS  KL_SYM_TOK_AKM,A
		   STS  OSTAT_KPD_SYM_TOK,A
		   STS  OSTAT_SYM_H_TOK,A
           LDS  XH,SYM_TOK_AKM_H
           LDS  XL,SYM_TOK_AKM_L
           SBIW XL,1
           STS  SYM_TOK_AKM_H,XH
           STS  SYM_TOK_AKM_L,XL
           RJMP OBKLL_2
OB_KL_L_9: CPI  A,9
		   BRNE OBKLL_10
           LDI  B,10
           LDS  A,Z_MIN_VLT_SET
		   ADD  A,B
           LDS  B,Z_MAKS_VLT_SET 
           CP    B,A
		   BREQ ROBKLL
		   DEC  B
           STS  Z_MAKS_VLT_SET,B 
           RJMP OBKLL_2
OBKLL_10: CPI  A,10
		  BRNE OBKLL_12
          LDS  A,Z_MIN_VLT_SET
          CPI  A,80
		  BREQ  ROBKLL
		  DEC  A
          STS  Z_MIN_VLT_SET,A 
          RJMP OBKLL_2
OBKLL_12: CPI  A,12
		  BRNE OBKLL_13
          LDS  A,TREB_FL_RAB
          SBRS A,F_TR_ZVUK
          RJMP ROBKLL
          CBR  A,(1<<F_TR_ZVUK)
          STS  TREB_FL_RAB,A 
          RJMP OBKLL_2
OBKLL_13: CPI  A,13
		  BRNE OBKLL_14
          LDS  A,TREB_FL_RAB
          SBRS A,F_TR_EKONOM
          RJMP ROBKLL
          CBR  A,(1<<F_TR_EKONOM)
          STS  TREB_FL_RAB,A 
          RJMP OBKLL_2
OBKLL_14: CPI  A,16
		  BRNE ROBKLL
          LDS  A,Z_VLT_OUT
          LDS  B,KN_0_VLT_OUT
		  CP   A,B
          BRCS ROBKLL
		  DEC  A
          STS  Z_VLT_OUT,A 
OBKLL_2:  SBR  TREB_FL_IND,(1<<F_TR_WR_EPROM)
ROBKLL:   RET



FORM_OBM:   push A
            in   A,SREG
            push A
            SBRS TREB_FL_IND,F_TR_OTV_OBM
            RJMP FM_OBM_8
			LDS  A,VR_OJD_OBM
            TST  A
			BREQ FM_OBM_2
            DEC  A
			STS  VR_OJD_OBM,A
            RJMP RFM_OBM
FM_OBM_2:   LDS  A,YKZ_OBM
            CPI  A,1
			BRNE FM_OBM_9
            LDS  A,KL_AVR_OBM_DC3
            CPI  A,3
			BREQ FM_OBM_1
            INC  A
			STS  KL_AVR_OBM_DC3,A
            RJMP FM_OBM_13
FM_OBM_1:   SBR  FL_AVR_OBM_IND,(1<<F_AVR_OBM_DC3_2)
FM_OBM_13:  STS  AVR_SH_OBM_DC3,SHAG_OBM
            LDI  A,2
			STS  YKZ_OBM,A
            RJMP FM_OBM_10
FM_OBM_9:   CPI  A,2
			BRNE FM_OBM_11
            LDS  A,KL_AVR_OBM_ZAR
            CPI  A,3
			BREQ FM_OBM_14
            INC  A
			STS  KL_AVR_OBM_ZAR,A
            RJMP FM_OBM_15
FM_OBM_14:  SBR  FL_AVR_OBM_IND,(1<<F_AVR_OBM_ZAR_2)
FM_OBM_15:  STS  AVR_SH_OBM_ZAR,SHAG_OBM
            LDI  A,3
			STS  YKZ_OBM,A
            RJMP FM_OBM_10
FM_OBM_11:  LDS  A,KL_AVR_OBM_INV
            CPI  A,3
			BREQ FM_OBM_16
            INC  A
			STS  KL_AVR_OBM_INV,A
            RJMP FM_OBM_17
FM_OBM_16:  SBR  FL_AVR_OBM_IND,(1<<F_AVR_OBM_INV_2)
FM_OBM_17:  STS  AVR_SH_OBM_INV,SHAG_OBM
            LDI  A,1
			STS  YKZ_OBM,A
FM_OBM_10:  CLR  SHAG_OBM
            CBR  TREB_FL_IND,(1<<F_TR_OTV_OBM)
            RJMP FM_OBM_12
FM_OBM_8:   SBRS TREB_FL_IND,F_RAZR_OBM
            RJMP RFM_OBM
FM_OBM_12:  CBR  TREB_FL_IND,(1<<F_RAZR_OBM)
            LDI  A,100
            STS  VR_OJD_OBM,A
        	LDS  A,YKZ_OBM
            CPI  A,1
			BRNE FM_OBM_3
			MOV  A,SHAG_OBM
            CPI  A,12
			BREQ FM_OBM_4
            RCALL OBM_DC_300V
            RJMP RFM_OBM
FM_OBM_4:   CBR  FL_AVR_OBM_IND,(1<<F_AVR_OBM_DC3_2)
            CLR  SHAG_OBM
            LDI  A,2
			STS  YKZ_OBM,A
            RCALL OBM_ZAR
            RJMP RFM_OBM
FM_OBM_3:   CPI  A,2
			BRNE FM_OBM_5
			MOV  A,SHAG_OBM
            CPI  A,21
			BREQ FM_OBM_6
            RCALL OBM_ZAR
            RJMP  RFM_OBM
FM_OBM_6:   CBR  FL_AVR_OBM_IND,(1<<F_AVR_OBM_ZAR_2)
            CLR  SHAG_OBM
            LDI  A,3
			STS  YKZ_OBM,A
            RCALL OBM_INVER
            RJMP RFM_OBM
FM_OBM_5:	MOV  A,SHAG_OBM
            CPI  A,9
			BREQ FM_OBM_7
            RCALL OBM_INVER
            RJMP RFM_OBM
FM_OBM_7:   CBR  FL_AVR_OBM_IND,(1<<F_AVR_OBM_INV_2)
            CLR  SHAG_OBM
            LDI  A,1 
			STS  YKZ_OBM,A
            RCALL OBM_DC_300V
RFM_OBM:    POP A
            OUT SREG,A
            POP A
            RET


OBM_RD_ZAR: PUSH B
            PUSH XH
            PUSH XL
            LDS B,UCSRB
            LDS A,UDR
            ;SEI
            CPI  SHAG_OBM,13
			BRNE OB_RD_ZR_1
            LDI  XH,$01               ;ADR_BUF_OBM
            LDI  XL,$50 
            MOV  SYM_OBM,A
            RJMP OB_RD_ZR_5
OB_RD_ZR_1: CPI  SHAG_OBM,14
			BREQ OB_RD_ZR_2
            CPI  SHAG_OBM,15
			BREQ OB_RD_ZR_2
            CPI  SHAG_OBM,16
			BREQ OB_RD_ZR_2
            CPI  SHAG_OBM,17
			BREQ OB_RD_ZR_2
            CPI  SHAG_OBM,18
			BREQ OB_RD_ZR_2
            CPI  SHAG_OBM,19
			BRNE OB_RD_ZR_3
OB_RD_ZR_2: ADD  SYM_OBM,A
            LDS  XL,ADR_BUF_OBML
            LDS  XH,ADR_BUF_OBMH
OB_RD_ZR_5: ST   X+,A
            RJMP OB_RD_ZR_6
OB_RD_ZR_3: CPI  SHAG_OBM,20
			BRNE ROB_RD_ZR
            CBR  TREB_FL_IND,(1<<F_TR_OTV_OBM)
            CP   SYM_OBM,A
			BREQ OB_RD_ZR_4
            SBR  FL_AVR_OBM_IND,(1<<F_AVR_SYM_OBM_ZAR_2)
            LDS  A,KL_AVR_OBM_ZAR
            CPI  A,3
			BREQ OB_RD_ZR_7
            INC  A
			STS  KL_AVR_OBM_ZAR,A
            RJMP OB_RD_ZR_6
OB_RD_ZR_7: SBR  FL_AVR_OBM_IND,(1<<F_AVR_OBM_ZAR_2)
            RJMP OB_RD_ZR_6
OB_RD_ZR_4: CLR  A
            STS  KL_AVR_OBM_ZAR,A
            CBR  FL_AVR_OBM_IND,(1<<F_AVR_SYM_OBM_ZAR_2)
            RCALL OBR_BUF_OBM_ZAR
            RCALL OBR_INTG_VLT_ZAR
OB_RD_ZR_6: INC  SHAG_OBM
            STS  ADR_BUF_OBML,XL
            STS  ADR_BUF_OBMH,XH
ROB_RD_ZR:  POP XL
            POP XH
            POP B
            RET

OBR_BUF_OBM_ZAR:
            PUSH A
            PUSH XH
            PUSH XL
            LDI  XH,$01            ;ADR_BUF_OBM
            LDI  XL,$50 
            LD   A,X+
			STS  FL_AVR_ZAR,A
            LD   A,X+
			STS  FL_SIS_ZAR,A
            LD   A,X+
			MOV  INTG_TOK_ZAR,A
            LD   A,X+
			MOV  VLT_ZAR,A
            LD   A,X+
			MOV  VLT_SET,A
            LD   A,X+
			STS  TERM_ZAR,A
            LD   A,X+
			MOV  REZ1_ZAR,A
            POP  XL
            POP  XH
            POP  A
            RET


OBM_ZAR:    CPI  SHAG_OBM,0
            BRNE OB_ZR_1
            LDS  A,UCSRB
            SBR  A,(1<<TXB8) 
            STS  UCSRB,A
			LDI  A,0B10000000
            MOV  SYM_OBM,A
            RJMP OB_ZR_7
OB_ZR_1:    LDS  A,UCSRB
            CBR  A,(1<<TXB8) 
            STS  UCSRB,A
            CPI  SHAG_OBM,1
            BRNE OB_ZR_2
            LDS  A,FL_TR_RAB_ZAR
            RJMP OB_ZR_6
OB_ZR_2:    CPI  SHAG_OBM,2
            BRNE OB_ZR_3
            LDS  A,Z_VLT_ZAR
            RJMP OB_ZR_6
OB_ZR_3:    CPI  SHAG_OBM,3
            BRNE OB_ZR_4
            LDS  A,Z_TOK_AKM
            RJMP OB_ZR_6
OB_ZR_4:    CPI  SHAG_OBM,4
            BRNE OB_ZR_5
            LDS  A,Z_MIN_VLT_SET
            RJMP OB_ZR_6
OB_ZR_5:    CPI  SHAG_OBM,5
            BRNE OB_ZR_8
            LDS  A,Z_MAKS_VLT_SET
            RJMP OB_ZR_6
OB_ZR_8:    CPI  SHAG_OBM,6
            BRNE OB_ZR_9
            LDS  A,Z_PI_OGR_TOK_AKM
            RJMP OB_ZR_6
OB_ZR_9:    CPI  SHAG_OBM,7
            BRNE OB_ZR_11
            RCALL OBR_FEN
            LDS  A,Z_TOK_FEN
            RJMP OB_ZR_6
OB_ZR_11:   CPI  SHAG_OBM,8
            BRNE OB_ZR_12
            LDS  A,Z_PI_ZAR_H
            RJMP OB_ZR_6
OB_ZR_12:   CPI  SHAG_OBM,9
            BRNE OB_ZR_13
            LDS  A,Z_PI_ZAR_L
            RJMP OB_ZR_6
OB_ZR_13:   CPI  SHAG_OBM,10
            BRNE OB_ZR_14
            LDS  A,Z_PI_TOK_ZAR
            RJMP OB_ZR_6
OB_ZR_14:   CPI  SHAG_OBM,11
            BRNE OB_ZR_10
            LDS  A,KN_AVR_TOK_ZAR
OB_ZR_6:    ADD  SYM_OBM,A
            RJMP OB_ZR_7
OB_ZR_10:   CPI  SHAG_OBM,12
            BRNE ROB_ZR
            SBR  TREB_FL_IND,(1<<F_TR_OTV_OBM)
            MOV  A,SYM_OBM
OB_ZR_7:  	STS  UDR,A
        	INC  SHAG_OBM
ROB_ZR:     RET



OBR_FEN:   LDS   A,TERM_ZAR
		   SUBI  A,K_0_TERM_ZAR
           BRCS  OB_FN_1
		   BREQ  OB_FN_1
           MOV   B,A
           RJMP  OB_FN_2
OB_FN_1:   CLR   B
OB_FN_2:   LDS   A,TERM_DC3
		   SUBI  A,K_0_TERM_DC
           BRCS  OB_FN_3
		   BREQ  OB_FN_3
           CP    A,B
           BRCC  OB_FN_4
OB_FN_3:   MOV   A,B
OB_FN_4:   CPI   A,K_VKL_FEN
		   BRCS  OB_FN_7
           SUBI  A,K_VKL_FEN
		   BRCC  OB_FN_5
           CLR   A
OB_FN_5:   LSL   A
		   BRCS  OB_FN_9
           LSL   A
		   BRCS  OB_FN_9
           LSL   A
		   BRCS  OB_FN_9
           LSL   A
		   BRCS  OB_FN_9
		   LDI   B,110
		   ADD   A,B
		   BRCC  OB_FN_6 
OB_FN_9:   LDI   A,255
OB_FN_6:   STS   Z_TOK_FEN,A
           RJMP  ROB_FN
OB_FN_7:   CPI   A,K_OTK_FEN
		   BRCC  ROB_FN
           CLR   A 
		   STS   Z_TOK_FEN,A
ROB_FN:    RET



RD_USART_IND:
         push A         ;  USART
         in   A,SREG
         push A
		 LDS   A,YKZ_OBM
         CPI   A,1
	     BRNE  RD_US_1
         RCALL OBM_RD_300V
         RJMP  RRD_USR
RD_US_1: CPI   A,2
	     BRNE  RD_US_3
         RCALL OBM_RD_ZAR
         RJMP  RRD_USR
RD_US_3: RCALL OBM_RD_INVER
RRD_USR: SBR   TREB_FL_IND,(1<<F_RAZR_OBM)
         POP A
         OUT SREG,A
         POP A
         RETI


WR_USART_IND:
            push A    ;  USART
            in A,SREG
            push A
            SBR TREB_FL_IND,(1<<F_RAZR_OBM)
            POP A
            OUT SREG,A
            POP A
            RETI


OBM_INVER:  CPI SHAG_OBM,0
            BRNE OB_IV_1
            LDS A,UCSRB
            SBR A,(1<<TXB8) 
            STS UCSRB,A
			LDI A,0B11000000
            MOV  SYM_OBM,A
            RJMP OB_IV_7
OB_IV_1:    LDS A,UCSRB
            CBR A,(1<<TXB8) 
            STS UCSRB,A
            CPI SHAG_OBM,1
            BRNE OB_IV_2
            LDS A,FL_TR_RAB_INV
            RJMP OB_IV_6
OB_IV_2:    CPI SHAG_OBM,2
            BRNE OB_IV_3
            LDS A,ZAD1_INV
            RJMP OB_IV_6
OB_IV_3:    CPI SHAG_OBM,3
            BRNE OB_IV_5
            LDS A,ZAD2_INV
            RJMP OB_IV_6
OB_IV_5:    CPI SHAG_OBM,4
            BREQ OB_IV_4
            RJMP ROB_IV
OB_IV_6:    ADD SYM_OBM,A
            RJMP OB_IV_7
OB_IV_4:    ;CBI PORTD,ZYM   ;---------------------
            SBR TREB_FL_IND,(1<<F_TR_OTV_OBM)
            MOV A,SYM_OBM
OB_IV_7:  	STS UDR,A
        	INC SHAG_OBM
ROB_IV:     RET


OBM_RD_INVER:
            PUSH B
            PUSH XH
            PUSH XL
            LDS B,UCSRB
            LDS A,UDR
            ;SEI
            CPI SHAG_OBM,5
			BRNE OB_RD_IV_1
            LDI  XH,$01               ;ADR_BUF_OBM
            LDI  XL,$50 
            MOV SYM_OBM,A
            RJMP OB_RD_IV_5
OB_RD_IV_1: CPI SHAG_OBM,6
			BREQ OB_RD_IV_2
            CPI SHAG_OBM,7
			BREQ OB_RD_IV_2
            CPI SHAG_OBM,8
			BREQ OB_RD_IV_3
            RJMP ROB_RD_IV
OB_RD_IV_2: ADD SYM_OBM,A
            LDS XL,ADR_BUF_OBML
            LDS XH,ADR_BUF_OBMH
OB_RD_IV_5: ST  X+,A
            RJMP OB_RD_IV_6
OB_RD_IV_3: CBR TREB_FL_IND,(1<<F_TR_OTV_OBM)
            CP SYM_OBM,A
			BREQ OB_RD_IV_4
            SBR FL_AVR_OBM_IND,(1<<F_AVR_SYM_OBM_INV_2)
            LDS A,KL_AVR_OBM_INV
            CPI A,3
			BREQ OB_RD_IV_7
            INC A
			STS KL_AVR_OBM_INV,A
            RJMP OB_RD_IV_6
OB_RD_IV_7: SBR FL_AVR_OBM_IND,(1<<F_AVR_OBM_INV_2)
            RJMP OB_RD_IV_6
OB_RD_IV_4: CLR A
            STS KL_AVR_OBM_INV,A
            CBR FL_AVR_OBM_IND,(1<<F_AVR_SYM_OBM_INV_2)
            RCALL OBR_BUF_OBM_INV
OB_RD_IV_6: INC SHAG_OBM
            STS ADR_BUF_OBML,XL
            STS ADR_BUF_OBMH,XH
ROB_RD_IV:  POP XL
            POP XH
            POP B
            RET

OBR_BUF_OBM_INV:
            PUSH A
            PUSH XH
            PUSH XL
            LDI  XH,$01               ;ADR_BUF_OBM
            LDI  XL,$50 
            LD A,X+
			STS FL_AVR_INV,A
            LD A,X+
			STS FL_SIS_INV,A
            LD A,X+
			STS REZ1_INV,A
            POP XL
            POP XH
            POP A
            RET

OBM_DC_300V:
            CPI SHAG_OBM,0
            BRNE OB_DC_1
            LDS A,UCSRB
            SBR A,(1<<TXB8) 
            STS UCSRB,A
			LDI A,0B01000000
            MOV  SYM_OBM,A
            RJMP OB_DC_7
OB_DC_1:    LDS A,UCSRB
            CBR A,(1<<TXB8) 
            STS UCSRB,A
            CPI SHAG_OBM,1
            BRNE OB_DC_2
            LDS A,FL_TR_RAB_DC3
            RJMP OB_DC_6
OB_DC_2:    CPI SHAG_OBM,2
            BRNE OB_DC_3
            LDS A,Z_VLT_OUT
            RJMP OB_DC_6
OB_DC_3:    CPI SHAG_OBM,3
            BRNE OB_DC_4
            LDS A,Z_PI_VLT_DC3
            RJMP OB_DC_6
OB_DC_4:    CPI SHAG_OBM,4
            BRNE OB_DC_5
            LDS A,Z_VR_SHM_DC3 
            RJMP OB_DC_6
OB_DC_5:    CPI SHAG_OBM,5
            BRNE ROB_DC
            RJMP OB_DC_8
OB_DC_6:    ADD SYM_OBM,A
            RJMP OB_DC_7
OB_DC_8:    SBR TREB_FL_IND,(1<<F_TR_OTV_OBM)
            MOV A,SYM_OBM
OB_DC_7:  	STS UDR,A
        	INC SHAG_OBM
ROB_DC:     RET


OBM_RD_300V:
            PUSH B
            PUSH XH
            PUSH XL
            LDS B,UCSRB
            LDS A,UDR
            ;SEI
            CPI SHAG_OBM,6
			BRNE OB_RD_DC_1
            LDI  XH,$01               ;ADR_BUF_OBM
            LDI  XL,$50 
            MOV SYM_OBM,A
            RJMP OB_RD_DC_5
OB_RD_DC_1: CPI SHAG_OBM,7
			BREQ OB_RD_DC_2
            CPI SHAG_OBM,8
			BREQ OB_RD_DC_2
            CPI SHAG_OBM,9
			BREQ OB_RD_DC_2
            CPI SHAG_OBM,10
			BREQ OB_RD_DC_2
            CPI SHAG_OBM,11
			BRNE ROB_RD_DC
            RJMP OB_RD_DC_3
OB_RD_DC_2: ADD SYM_OBM,A
            LDS XL,ADR_BUF_OBML
            LDS XH,ADR_BUF_OBMH
OB_RD_DC_5: ST  X+,A
            RJMP OB_RD_DC_6
OB_RD_DC_3: CBR TREB_FL_IND,(1<<F_TR_OTV_OBM)
            CP SYM_OBM,A
			BREQ OB_RD_DC_4
            SBR FL_AVR_OBM_IND,(1<<F_AVR_SYM_OBM_DC3_2)
            LDS A,KL_AVR_OBM_DC3
            CPI A,3
			BREQ OB_RD_DC_7
            INC A
			STS KL_AVR_OBM_DC3,A
            RJMP OB_RD_DC_6
OB_RD_DC_7: SBR FL_AVR_OBM_IND,(1<<F_AVR_OBM_DC3_2)
            RJMP OB_RD_DC_6
OB_RD_DC_4: CLR A
            STS KL_AVR_OBM_DC3,A
            CBR FL_AVR_OBM_IND,(1<<F_AVR_SYM_OBM_DC3_2)
            RCALL OBR_BUF_OBM_DC3
            RCALL OBR_INTG1_TOK_AKM
OB_RD_DC_6: INC SHAG_OBM
            STS ADR_BUF_OBML,XL
            STS ADR_BUF_OBMH,XH
ROB_RD_DC:  POP XL
            POP XH
            POP B
            RET

OBR_BUF_OBM_DC3:
            PUSH A
            PUSH XH
            PUSH XL
            LDI  XH,$01               ;ADR_BUF_OBM
            LDI  XL,$50 
            LD   A,X+
			STS  FL_AVR_DC3,A
            LD   A,X+
			STS  FL_SIS_DC3,A
            LD   A,X+
            MOV  REZ_300V,A
            LD   INTG_TOK_AKM,X+
            LD   A,X+
			STS  TERM_DC3,A
            POP XL
            POP XH
            POP A
            RET


OBR_INTG1_TOK_AKM:
           PUSH XL
           PUSH XH
           PUSH B
           PUSH A
           LDS A,KL_SYM_INTG_TOK_AKM
		   CPI A,200
		   BREQ OB_IG_T_2
           INC A
		   STS KL_SYM_INTG_TOK_AKM,A
           LDS XL,SYM_INTG_TOK_AKM_L
           LDS XH,SYM_INTG_TOK_AKM_H
           MOV A,INTG_TOK_AKM
           ADD XL,A
		   CLR A
		   ADC XH,A
		   STS SYM_INTG_TOK_AKM_L,XL
	       STS SYM_INTG_TOK_AKM_H,XH
OB_IG_T_2: MOV  A,INTG_TOK_AKM
           LDI  B,2                 ;6 KOL OTCZETOV
           LDS  XL,BF_INTG_TOK_AKM_L
           LDS  XH,BF_INTG_TOK_AKM_H
           CALL INTG
		   STS  BF_INTG_TOK_AKM_L,XL
	       STS  BF_INTG_TOK_AKM_H,XH
		   STS  INTG1_TOK_AKM,A
           LDS  B,KN_0_INTG_TOK_AKM
           SUB  A,B
		   BRCC OB_IG_T_1
           NEG  A
		   STS  REZ_TOK_AKM,A
           CPI  A,K_TOK_NAGRZ
           BRCS OB_IG_T_3
           SBR  TREB_FL_IND,(1<<F_NAGRZ)
           RJMP RING_T_IN  
OB_IG_T_1: CLR  A
           STS  REZ_TOK_AKM,A
OB_IG_T_3: CBR  TREB_FL_IND,(1<<F_NAGRZ)
RING_T_IN: SBR  FL_SIST_IND,(1<<F_NTG1_TOK_AKM)
           POP A
           POP B
           POP XH
           POP XL
           RET


;OBR_INTG1_TOK_AKM:
  ;         PUSH XL
  ;         PUSH XH
  ;         PUSH B
   ;        PUSH A
   ;        MOV A,INTG_TOK_AKM
  ;         LDI B,2            ;6 KOL OTCZETOV
   ;        LDS XL,BF_INTG_TOK_AKM_L
   ;        LDS XH,BF_INTG_TOK_AKM_H
   ;        RCALL INTG
;		   STS BF_INTG_TOK_AKM_L,XL
;	       STS BF_INTG_TOK_AKM_H,XH
;		   STS INTG1_TOK_AKM,A
    ;       LDI B,6            ;6 KOL OTCZETOV
 ;          LDS XL,BF2_INTG_TOK_AKM_L
  ;         LDS XH,BF2_INTG_TOK_AKM_H
     ;      RCALL INTG
;		   STS BF2_INTG_TOK_AKM_L,XL
;	       STS BF2_INTG_TOK_AKM_H,XH
;		   STS INTG2_TOK_AKM,A
   ;        LDS A,INTG1_TOK_AKM
     ;      SUBI A,K_0_INTG_TOK_AKM
;		   BRCC OB_IG_T_1
     ;      NEG A
	;	   STS REZ_TOK_AKM,A
     ;      RJMP RING_T_IN  
;OB_IG_T_1: CLR A
       ;    STS REZ_TOK_AKM,A
;RING_T_IN: SBR FL_SIST_IND,(1<<F_NTG1_TOK_AKM)
     ;      POP A
     ;      POP B
     ;      POP XH
     ;      POP XL
     ;      RET


OBR_INTG_VLT_ZAR:
           PUSH XL
           PUSH XH
           PUSH B
           PUSH A
           MOV A,VLT_ZAR              ;UART
           LDI B,2                    ;2 KOL OTCZETOV
           LDS XL,BF_INTG_VLT_ZAR_L
           LDS XH,BF_INTG_VLT_ZAR_H
           CALL INTG
		   STS BF_INTG_VLT_ZAR_L,XL
	       STS BF_INTG_VLT_ZAR_H,XH
		   STS INTG_VLT_ZAR,A
RING_VZ:   POP A
           POP B
           POP XH
           POP XL
           RET



OBSL_LCD:  PUSH YL
           PUSH YH
           SBRS TREB_FL_IND,F_TR_SIS
           RJMP OBS_LCD_1
           CBR TREB_FL_IND,(1<<F_TR_SIS)
           SBR FL_SIST_IND,(1<<F_SISTEM)
           RCALL NAST_LCD_SYS
           RJMP OBS_LCD_2
OBS_LCD_1: SBRC FL_SIST_IND,F_SISTEM
           RJMP OBS_LCD_2
           RCALL IND_PRIKL
           RJMP R_OBSL_LCD
OBS_LCD_2: CALL RW_ADR_SYS_LCD
		   LD A,Y
           RCALL RW_DAN_SYS_LCD
           MOV A,RAB_BYF
           RCALL RW_BUF_SYS_LCD
R_OBSL_LCD:POP YH
           POP YL
           RET


IND_PRIKL: SBIC  PINB,VKL_AKM
           RJMP  ID_PR_19
           RCALL IND_SON
           RJMP  RID_PR
ID_PR_19:  RCALL IND_AVR
           SBRC  FL_SIST_IND,F_IND_AVR
           RJMP  RID_PR
		   LDS   A,KLAV_NAST
           SBRS  A,F_YD_KL_MAKS
           RJMP  ID_PR_1
           SBRC  A,F_KL_X 
           RJMP  ID_PR_1
           SBRC  A,F_KL_H 
           RJMP  ID_PR_1
           SBRC  A,F_KL_L 
           RJMP  ID_PR_1
           LDS   A,SHAG_IND
           CPI   A,0
		   BREQ  ID_PR_18
           CPI   A,2
		   BRNE  ID_PR_2
ID_PR_18:  RCALL IND_REZ_TOK_VLT_AKM
           RJMP  RID_PR
ID_PR_2:   CPI   A,1
		   BREQ  ID_PR_3
           CPI   A,3
		   BRNE  ID_PR_1
ID_PR_3:   RCALL IND_REZ_TOK
           RJMP  RID_PR
ID_PR_1:   LDS   A,SHAG_IND
           CPI   A,0
		   BRNE  ID_PR_4
           RCALL IND_ZAD_VLT_ZAR_AKM1
           RJMP  RID_PR
ID_PR_4:   CPI A,1
		   BRNE  ID_PR_5
           RCALL IND_ZAD_TOK_ZAR_AKM1
           RJMP  RID_PR
ID_PR_5:   CPI A,2
		   BRNE ID_PR_6
           RCALL IND_ZAD_VLT_ZAR_AKM2
           RJMP RID_PR
ID_PR_6:   CPI A,3
		   BRNE ID_PR_7
           RCALL IND_ZAD_TOK_ZAR_AKM2
           RJMP RID_PR
ID_PR_7:   CPI A,4
		   BRNE ID_PR_8
           RCALL IND_ZAD_MIN_VLT_AKM
           RJMP RID_PR
ID_PR_8:   CPI A,5
		   BRNE ID_PR_9
           RCALL IND_ZAD_KMP_TOK_AKM
           RJMP RID_PR
ID_PR_9:   CPI A,6
		   BRNE ID_PR_10
           RCALL IND_KPD_TOK_AKM
           RJMP RID_PR
ID_PR_10:  CPI A,7
		   BRNE ID_PR_11
           RCALL IND_UMKS_AKM
           RJMP RID_PR
ID_PR_11:  CPI A,8
		   BRNE ID_PR_12
           RCALL IND_MOSHN_NAGR
           RJMP RID_PR
ID_PR_12:  CPI A,9
		   BRNE ID_PR_13
           RCALL IND_ZAD_MAKS_VLT_SET
           RJMP RID_PR
ID_PR_13:  CPI A,10
		   BRNE ID_PR_14
           RCALL IND_ZAD_MIN_VLT_SET
           RJMP RID_PR
ID_PR_14:  CPI A,11
		   BRNE ID_PR_15
           RCALL IND_USTIROV
           RJMP RID_PR
ID_PR_15:  CPI A,12
		   BRNE ID_PR_16
           RCALL IND_RAZR_ZYMER
           RJMP RID_PR
ID_PR_16:  CPI   A,13
		   BRNE  ID_PR_17
           RCALL IND_RAZR_EKONOM
           RJMP  RID_PR
ID_PR_17:  CPI   A,14
		   BRNE  ID_PR_20
           RCALL IND_RESET_KONC
           RJMP  RID_PR
ID_PR_20:  CPI   A,15
		   BRNE  ID_PR_21
           RCALL IND_TERMO
           RJMP  RID_PR
ID_PR_21:  CPI   A,16
		   BRNE  RID_PR
           RCALL IND_VLT_OUT
RID_PR:    RET


IND_ZAD_MIN_VLT_AKM:
            PUSH ZL
            PUSH ZH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
            LDS   A,SHAG_IND
            LDS   B,SHAG_IND_BIL
            CP    A,B
			BREQ  IN_ZVA_1
			STS   SHAG_IND_BIL,A
            LDI   ZH,high(TXT_Z_MIN_V_AKM_1S*2)
            LDI   ZL,low(TXT_Z_MIN_V_AKM_1S*2)
            RCALL RW_TEKCT_LCD
            LDI   ZH,high(TXT_Z_R_2STR*2)
            LDI   ZL,low(TXT_Z_R_2STR*2)
            RCALL RW_TEKCT_LCD
IN_ZVA_1:   LDI   A,0B11000010
            CALL RW_KOM_LCD
            LDS   A,Z_MIN_VLT_AKM
            RCALL IND_VLT_ZAR
        	LDI   A,0B11001000
            CALL RW_KOM_LCD
            LDS   A,INTG_VLT_ZAR
            RCALL IND_VLT_ZAR
            POP B
            POP A
            OUT SREG,A
            POP A
		    POP ZH
		    POP ZL
            RET


IND_RAZR_ZYMER:
            PUSH ZL
            PUSH ZH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
            LDS A,SHAG_IND
            LDS B,SHAG_IND_BIL
            CP A,B
			BREQ IN_RZZ_1
			STS SHAG_IND_BIL,A
            LDI ZH,high(TXT_ZVYK_1S*2)
            LDI ZL,low(TXT_ZVYK_1S*2)
            RCALL RW_TEKCT_LCD
            LDI ZH,high(TXT_CLR_2S*2)
            LDI ZL,low(TXT_CLR_2S*2)
            RCALL RW_TEKCT_LCD
IN_RZZ_1:   LDS A,TREB_FL_RAB
            SBRS A,F_TR_ZVUK
            RJMP IN_RZZ_2
            LDI ZH,high(TXT_RAZRESHON_2S*2)
            LDI ZL,low(TXT_RAZRESHON_2S*2)
            RCALL RW_TEKCT_LCD
            RJMP RIN_RZZ
IN_RZZ_2:   LDI ZH,high(TXT_ZAPRET_2S*2)
            LDI ZL,low(TXT_ZAPRET_2S*2)
            RCALL RW_TEKCT_LCD
RIN_RZZ:    POP B
            POP A
            OUT SREG,A
            POP A
		    POP ZH
		    POP ZL
            RET


IND_RAZR_EKONOM:
            PUSH ZL
            PUSH ZH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
            LDS A,SHAG_IND
            LDS B,SHAG_IND_BIL
            CP A,B
			BREQ IN_RZE_1
			STS SHAG_IND_BIL,A
            LDI ZH,high(TXT_EKONOM_1S*2)
            LDI ZL,low(TXT_EKONOM_1S*2)
            RCALL RW_TEKCT_LCD
            LDI ZH,high(TXT_CLR_2S*2)
            LDI ZL,low(TXT_CLR_2S*2)
            RCALL RW_TEKCT_LCD
IN_RZE_1:   LDS A,TREB_FL_RAB
            SBRS A,F_TR_EKONOM
            RJMP IN_RZE_2
            LDI ZH,high(TXT_RAZRESHON_2S*2)
            LDI ZL,low(TXT_RAZRESHON_2S*2)
            RCALL RW_TEKCT_LCD
            RJMP RIN_RZE
IN_RZE_2:   LDI ZH,high(TXT_ZAPRET_2S*2)
            LDI ZL,low(TXT_ZAPRET_2S*2)
            RCALL RW_TEKCT_LCD
RIN_RZE:    POP B
            POP A
            OUT SREG,A
            POP A
		    POP ZH
		    POP ZL
            RET


IND_RESET_KONC:
            PUSH ZL
            PUSH ZH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
            LDS   A,SHAG_IND
            LDS   B,SHAG_IND_BIL
            CP    A,B
			BREQ  IN_RSK_1
			STS   SHAG_IND_BIL,A
            LDI   ZH,high(TXT_ZAVOD_KONC_1S*2)
            LDI   ZL,low(TXT_ZAVOD_KONC_1S*2)
            RCALL RW_TEKCT_LCD
            LDI   ZH,high(TXT_ZAVOD_KONC_2S*2)
            LDI   ZL,low(TXT_ZAVOD_KONC_2S*2)
            RCALL RW_TEKCT_LCD
IN_RSK_1:   LDI   A,0B11001010
            RCALL RW_KOM_LCD
            SBRS  TREB_FL_IND,F_TR_RST_KONC
            RJMP  IN_RSK_2
            LDI   A,32                    ;"  "
            RCALL RW_DAN_LCD
            LDI   A,224                   ;"  "
            RCALL RW_DAN_LCD
            LDI   A,65                    ;"  "
            RCALL RW_DAN_LCD
            RJMP  RIN_RSK
IN_RSK_2:   LDI   A,32                    ;"  "
            RCALL RW_DAN_LCD
            RCALL RW_DAN_LCD
            RCALL RW_DAN_LCD
RIN_RSK:    POP B
            POP A
            OUT SREG,A
            POP A
		    POP ZH
		    POP ZL
            RET



IND_USTIROV:
            PUSH ZL
            PUSH ZH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
            LDS  A,SHAG_IND
            LDS  B,SHAG_IND_BIL
            CP    A,B
			BREQ  IN_UST_1
			STS   SHAG_IND_BIL,A
            LDI   ZH,high(TXT_USTIROV_1S*2)
            LDI   ZL,low(TXT_USTIROV_1S*2)
            RCALL RW_TEKCT_LCD
            LDI   ZH,high(TXT_CLR_2S*2)
            LDI   ZL,low(TXT_CLR_2S*2)
            RCALL RW_TEKCT_LCD
IN_UST_1:   LDI A,0B11000110
            RCALL RW_KOM_LCD
            SBRS  TREB_FL_IND,F_TR_UST_IND
            RJMP  IN_UST_2
            LDI   A,32                    ;"  "
            RCALL RW_DAN_LCD
            LDI   A,224                   ;"  "
            RCALL RW_DAN_LCD
            LDI   A,65                    ;"  "
            RCALL RW_DAN_LCD
            RJMP  RIN_UST
IN_UST_2:   LDI   A,32                    ;"  "
            RCALL RW_DAN_LCD
            LDI   A,32                    ;"  "
            RCALL RW_DAN_LCD
            LDI   A,32                    ;"  "
            RCALL RW_DAN_LCD
RIN_UST:    POP B
            POP A
            OUT SREG,A
            POP A
		    POP ZH
		    POP ZL
            RET


IND_SON:    PUSH ZL
            PUSH ZH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
			LDI   A,41
			STS   SHAG_IND_BIL,A
            LDI   ZH,high(TXT_SON_1S*2)
            LDI   ZL,low(TXT_SON_1S*2)
            RCALL RW_TEKCT_LCD
            LDI   ZH,high(TXT_CLR_2S*2)
            LDI   ZL,low(TXT_CLR_2S*2)
            RCALL RW_TEKCT_LCD
            POP B
            POP A
            OUT SREG,A
            POP A
		    POP ZH
		    POP ZL
            RET



IND_REZ_TOK_VLT_AKM:
            PUSH ZL
            PUSH ZH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
            LDS A,SHAG_IND_BIL
            CPI A,40
			BREQ IN_RTV_1
			LDI A,40
			STS SHAG_IND_BIL,A
            LDI ZH,high(TXT_REZ_AKM_1S*2)
            LDI ZL,low(TXT_REZ_AKM_1S*2)
            RCALL RW_TEKCT_LCD
            LDI ZH,high(TXT_V_A_2STR*2)
            LDI ZL,low(TXT_V_A_2STR*2)
            RCALL RW_TEKCT_LCD
IN_RTV_1:   LDI A,0B11000010
            RCALL RW_KOM_LCD
            LDS  A,INTG_VLT_ZAR
            RCALL IND_VLT_ZAR
        	LDI A,0B11001000
            RCALL RW_KOM_LCD
            LDS A,INTG1_TOK_AKM
            RCALL IND_TOK_AKM
            RCALL RW_TOK_AKM_LCD
            POP B
            POP A
            OUT SREG,A
            POP A
		    POP ZH
		    POP ZL
            RET


IND_REZ_TOK:
            PUSH ZL
            PUSH ZH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
            LDS A,SHAG_IND_BIL
            CPI A,40
			BREQ IN_RT_1
			LDI A,40
			STS SHAG_IND_BIL,A
            LDI ZH,high(TXT_TOK_IST_AKM*2)
            LDI ZL,low(TXT_TOK_IST_AKM*2)
            RCALL RW_TEKCT_LCD
            LDI ZH,high(TXT_CLR_2S*2)
            LDI ZL,low(TXT_CLR_2S*2)
            RCALL RW_TEKCT_LCD
IN_RT_1:    LDI A,0B11000001
            RCALL RW_KOM_LCD
            MOV  A,INTG_TOK_ZAR
            RCALL IND_TOK_ZAR
        	LDI A,0B11000111
            RCALL RW_KOM_LCD
            LDS A,INTG1_TOK_AKM
            RCALL IND_TOK_AKM
            RCALL RW_TOK_AKM_LCD
            POP B
            POP A
            OUT SREG,A
            POP A
		    POP ZH
		    POP ZL
            RET


IND_ZAD_VLT_ZAR_AKM1:  
            PUSH ZL
            PUSH ZH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
            LDS A,SHAG_IND
            LDS B,SHAG_IND_BIL
            CP A,B
			BREQ IN_ZVZ_1
			STS SHAG_IND_BIL,A
            LDI ZH,high(TXT_ZAD_VLT_ZAR1_1S*2)
            LDI ZL,low(TXT_ZAD_VLT_ZAR1_1S*2)
            RCALL RW_TEKCT_LCD
            LDI ZH,high(TXT_Z_R_2STR*2)
            LDI ZL,low(TXT_Z_R_2STR*2)
            RCALL RW_TEKCT_LCD
IN_ZVZ_1:   LDI A,0B11000010
            RCALL RW_KOM_LCD
            LDS  A,Z_VLT_ZAR_1
            RCALL IND_VLT_ZAR
        	LDI A,0B11001000
            RCALL RW_KOM_LCD
            MOV  A,VLT_ZAR
            RCALL IND_VLT_ZAR
            POP B
            POP A
            OUT SREG,A
            POP A
		    POP ZH
		    POP ZL
            RET

IND_ZAD_VLT_ZAR_AKM2:  
            PUSH ZL
            PUSH ZH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
            LDS A,SHAG_IND
            LDS B,SHAG_IND_BIL
            CP A,B
			BREQ IN_ZVZ2_1
			STS SHAG_IND_BIL,A
            LDI ZH,high(TXT_ZAD_VLT_ZAR2_1S*2)
            LDI ZL,low(TXT_ZAD_VLT_ZAR2_1S*2)
            RCALL RW_TEKCT_LCD
            LDI ZH,high(TXT_Z_R_2STR*2)
            LDI ZL,low(TXT_Z_R_2STR*2)
            RCALL RW_TEKCT_LCD
IN_ZVZ2_1:  LDI A,0B11000010
            RCALL RW_KOM_LCD
            LDS  A,Z_VLT_ZAR_2
            RCALL IND_VLT_ZAR
        	LDI A,0B11001000
            RCALL RW_KOM_LCD
            MOV  A,VLT_ZAR
            RCALL IND_VLT_ZAR
            POP B
            POP A
            OUT SREG,A
            POP A
		    POP ZH
		    POP ZL
            RET


IND_ZAD_TOK_ZAR_AKM1:
            PUSH ZL
            PUSH ZH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
            LDS A,SHAG_IND
            LDS B,SHAG_IND_BIL
            CP A,B
			BREQ IN_ZTZ_1
			STS SHAG_IND_BIL,A
            LDI ZH,high(TXT_ZAD_TOK_ZAR1_1S*2)
            LDI ZL,low(TXT_ZAD_TOK_ZAR1_1S*2)
            RCALL RW_TEKCT_LCD
            LDI ZH,high(TXT_Z_R_2STR*2)
            LDI ZL,low(TXT_Z_R_2STR*2)
            RCALL RW_TEKCT_LCD
IN_ZTZ_1:   LDI A,0B11000010
            RCALL RW_KOM_LCD
            LDS  A,Z_TOK_AKM_1 
            RCALL IND_Z_TOK_AKM
        	LDI A,0B11001000
            RCALL RW_KOM_LCD
            LDS  A,INTG1_TOK_AKM
            RCALL IND_TOK_AKM
            RCALL RW_TOK_AKM_LCD
            POP B
            POP A
            OUT SREG,A
            POP A
		    POP ZH
		    POP ZL
            RET


IND_ZAD_TOK_ZAR_AKM2:
            PUSH ZL
            PUSH ZH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
            LDS A,SHAG_IND
            LDS B,SHAG_IND_BIL
            CP A,B
			BREQ IN_ZTZ2_1
			STS SHAG_IND_BIL,A
            LDI ZH,high(TXT_ZAD_TOK_ZAR2_1S*2)
            LDI ZL,low(TXT_ZAD_TOK_ZAR2_1S*2)
            RCALL RW_TEKCT_LCD
            LDI ZH,high(TXT_Z_R_2STR*2)
            LDI ZL,low(TXT_Z_R_2STR*2)
            RCALL RW_TEKCT_LCD
IN_ZTZ2_1:   LDI A,0B11000010
            RCALL RW_KOM_LCD
            LDS  A,Z_TOK_AKM_2 
            RCALL IND_Z_TOK_AKM
        	LDI A,0B11001000
            RCALL RW_KOM_LCD
            LDS  A,INTG1_TOK_AKM
            RCALL IND_TOK_AKM
            RCALL RW_TOK_AKM_LCD
            POP B
            POP A
            OUT SREG,A
            POP A
		    POP ZH
		    POP ZL
            RET


IND_ZAD_KMP_TOK_AKM:
            PUSH ZL
            PUSH ZH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
            LDS A,SHAG_IND
            LDS B,SHAG_IND_BIL
            CP A,B
			BREQ IN_ZKTA_1
			STS SHAG_IND_BIL,A
            LDI ZH,high(TXT_Z_KMP_TOK_AKM_1S*2)
            LDI ZL,low(TXT_Z_KMP_TOK_AKM_1S*2)
            RCALL RW_TEKCT_LCD
            LDI ZH,high(TXT_Z_R_2STR*2)
            LDI ZL,low(TXT_Z_R_2STR*2)
            RCALL RW_TEKCT_LCD
IN_ZKTA_1:  LDI A,0B11000010
            RCALL RW_KOM_LCD
            LDS  A,Z_KMP_TOK_AKM
            RCALL IND_Z_TOK_AKM
        	LDI A,0B11001000
            RCALL RW_KOM_LCD
            LDS  A,INTG1_TOK_AKM
            RCALL IND_TOK_AKM
            RCALL RW_TOK_AKM_LCD
            POP B
            POP A
            OUT SREG,A
            POP A
		    POP ZH
		    POP ZL
            RET




IND_ZAD_MAKS_VLT_SET:
            PUSH ZL
            PUSH ZH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
            LDS A,SHAG_IND
            LDS B,SHAG_IND_BIL
            CP A,B
			BREQ IN_ZHS_1
			STS SHAG_IND_BIL,A
            LDI ZH,high(TXT_MAKS_VLT_SET_1S*2)
            LDI ZL,low(TXT_MAKS_VLT_SET_1S*2)
            RCALL RW_TEKCT_LCD
            LDI ZH,high(TXT_Z_R_2STR*2)
            LDI ZL,low(TXT_Z_R_2STR*2)
            RCALL RW_TEKCT_LCD
IN_ZHS_1:   LDI   A,0B11000010
            RCALL RW_KOM_LCD
            LDS   A,Z_MAKS_VLT_SET
            RCALL LSD_VLT_SET
        	LDI   A,0B11001000
            RCALL RW_KOM_LCD
            MOV   A,VLT_SET
            RCALL LSD_VLT_SET
            POP B
            POP A
            OUT SREG,A
            POP A
		    POP ZH
		    POP ZL
            RET


IND_ZAD_MIN_VLT_SET:
            PUSH ZL
            PUSH ZH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
            LDS A,SHAG_IND
            LDS B,SHAG_IND_BIL
            CP A,B
			BREQ IN_ZLS_1
			STS SHAG_IND_BIL,A
            LDI ZH,high(TXT_MIN_VLT_SET_1S*2)
            LDI ZL,low(TXT_MIN_VLT_SET_1S*2)
            RCALL RW_TEKCT_LCD
            LDI ZH,high(TXT_Z_R_2STR*2)
            LDI ZL,low(TXT_Z_R_2STR*2)
            RCALL RW_TEKCT_LCD
IN_ZLS_1:   LDI   A,0B11000010
            RCALL RW_KOM_LCD
            LDS   A,Z_MIN_VLT_SET
            RCALL LSD_VLT_SET
        	LDI   A,0B11001000
            RCALL RW_KOM_LCD
            MOV   A,VLT_SET
            RCALL LSD_VLT_SET
            POP B
            POP A
            OUT SREG,A
            POP A
		    POP ZH
		    POP ZL
            RET



IND_VLT_OUT:
            PUSH ZL
            PUSH ZH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
            LDS   A,SHAG_IND
            LDS   B,SHAG_IND_BIL
            CP    A,B
			BREQ  IN_ZVO_1
			STS   SHAG_IND_BIL,A
            LDI   ZH,high(TXT_VLT_OUT_1S*2)
            LDI   ZL,low(TXT_VLT_OUT_1S*2)
            RCALL RW_TEKCT_LCD
            LDI   ZH,high(TXT_Z_R_2STR*2)
            LDI   ZL,low(TXT_Z_R_2STR*2)
            RCALL RW_TEKCT_LCD
IN_ZVO_1:   LDI   A,0B11000010
            RCALL RW_KOM_LCD
            LDS   A,Z_VLT_OUT
            LDS   B,KN_0_VLT_OUT
			SUB   A,B
			BRCC  IN_ZVO_3
            CLR   A
IN_ZVO_3:   RCALL LSD_VLT_OUT
        	LDI   A,0B11001000
            RCALL RW_KOM_LCD
            MOV   A,REZ_300V
            LDS   B,KN_0_VLT_OUT
			SUB   A,B
			BRCC  IN_ZVO_2
            CLR   A
IN_ZVO_2:   RCALL LSD_VLT_OUT
            POP   B
            POP   A
            OUT   SREG,A
            POP   A
		    POP   ZH
		    POP   ZL
            RET

IND_KPD_TOK_AKM:
            PUSH ZL
            PUSH ZH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
            LDS A,SHAG_IND
            LDS B,SHAG_IND_BIL
            CP A,B
			BREQ IN_KPD_1
			STS SHAG_IND_BIL,A
            LDI ZH,high(TXT_KPD_TOK_AKM_1S*2)
            LDI ZL,low(TXT_KPD_TOK_AKM_1S*2)
            RCALL RW_TEKCT_LCD
            LDI ZH,high(TXT_CLR_2S*2)
            LDI ZL,low(TXT_CLR_2S*2)
            RCALL RW_TEKCT_LCD
IN_KPD_1:   LDI A,0B11000011
            RCALL RW_KOM_LCD
            LDS A,Z_KPD_TOK_AKM 
            RCALL IND_DAN_LSD
            LDI A,32
            RCALL RW_DAN_LCD
            LDI A,37                ;"%"
            RCALL RW_DAN_LCD
            POP B
            POP A
            OUT SREG,A
            POP A
		    POP ZH
		    POP ZL
            RET


IND_MOSHN_NAGR:
            PUSH ZL
            PUSH ZH
            PUSH YL
            PUSH YH
            PUSH XL
            PUSH XH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
            PUSH R0
            PUSH R1
            LDS   A,SHAG_IND
            LDS   B,SHAG_IND_BIL
            CP    A,B
			BREQ  IN_WO_1
			STS   SHAG_IND_BIL,A
            LDI   ZH,high(TXT_MOSHN_1S*2)
            LDI   ZL,low(TXT_MOSHN_1S*2)
            RCALL RW_TEKCT_LCD
            LDI   ZH,high(TXT_CLR_2S*2)
            LDI   ZL,low(TXT_CLR_2S*2)
            RCALL RW_TEKCT_LCD
IN_WO_1:    LDS   A,FL_TR_RAB_DC3
            SBRC  A,F_TR_RAB_AKM_DC3
            RJMP  IN_WO_2
            LDI   ZH,high(TXT_CLR_2S*2)
            LDI   ZL,low(TXT_CLR_2S*2)
            RCALL RW_TEKCT_LCD
            RJMP  RIN_WO
IN_WO_2:    LDI   A,0B11000100
            RCALL RW_KOM_LCD
            LDS   A,INTG1_TOK_AKM
            LDS   B,KN_0_INTG_TOK_AKM
            SUB   A,B
            MUL   A,VLT_ZAR
            MOVW  YL,R0
            LDI   A,K_KF_MOSH_AKM
            RCALL DIV_16_8
            MOVW  XL,YL
            RCALL B16_BCD_5
            LDI   B,$30
            LDS   A,ZN2
			TST   A
			BRNE  IN_WO_5
            LDI   A,32
            RCALL RW_DAN_LCD
            LDS   A,ZN3
			TST   A
			BRNE  IN_WO_6
            LDI   A,32
            RCALL RW_DAN_LCD
            LDS   A,ZN4
			TST   A
			BRNE  IN_WO_7
            LDI   A,32
            RCALL RW_DAN_LCD
            RJMP  IN_WO_8
IN_WO_5:    ADD   A,B
            RCALL RW_DAN_LCD
IN_WO_6:    LDS   A,ZN3
            ADD   A,B
            RCALL RW_DAN_LCD
IN_WO_7:    LDS   A,ZN4
            ADD   A,B
            RCALL RW_DAN_LCD
IN_WO_8:    LDS   A,ZN5
            ADD   A,B
            RCALL RW_DAN_LCD
RIN_WO:     POP R1
            POP R0
            POP B
            POP A
            OUT SREG,A
            POP A
            POP XH
            POP XL
            POP YH
            POP YL
		    POP ZH
		    POP ZL
            RET


IND_UMKS_AKM:
            PUSH ZL
            PUSH ZH
            PUSH YL
            PUSH YH
            PUSH XL
            PUSH XH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
            PUSH R0
            PUSH R1
            LDS A,SHAG_IND
            LDS B,SHAG_IND_BIL
            CP A,B
			BREQ IN_US_A_1
			STS SHAG_IND_BIL,A
            LDI ZH,high(TXT_UMKS_AKM*2)
            LDI ZL,low(TXT_UMKS_AKM*2)
            RCALL RW_TEKCT_LCD
            LDI ZH,high(TXT_CLR_2S*2)
            LDI ZL,low(TXT_CLR_2S*2)
            RCALL RW_TEKCT_LCD
IN_US_A_1:  LDI A,0B11000000
            RCALL RW_KOM_LCD
            CALL PDG_IND_UMKS_AKM
            RCALL B16_BCD_5
            LDI B,$30
            LDS A,ZN2
			TST A
			BRNE IN_US_A_2
            LDI A,32
            RCALL RW_DAN_LCD
            LDS A,ZN3
			TST A
			BRNE IN_US_A_3
            LDI A,32
            RCALL RW_DAN_LCD
            LDS A,ZN4
			TST A
			BRNE IN_US_A_4
            LDI A,32
            RCALL RW_DAN_LCD
            RJMP IN_US_A_5
IN_US_A_2:  ADD A,B
            RCALL RW_DAN_LCD
IN_US_A_3:  LDS A,ZN3
            ADD A,B
            RCALL RW_DAN_LCD
IN_US_A_4:  LDS A,ZN4
            ADD A,B
            RCALL RW_DAN_LCD
IN_US_A_5:  LDS A,ZN5
            ADD A,B
            RCALL RW_DAN_LCD
            LDI A,65                   ;"A"
            RCALL RW_DAN_LCD
            RCALL IND_VR_RAB_AKM
RIN_US_A:   POP R1
            POP R0
            POP B
            POP A
            OUT SREG,A
            POP A
            POP XH
            POP XL
            POP YH
            POP YL
		    POP ZH
		    POP ZL
            RET


IND_VR_RAB_AKM:
            PUSH ZL
            PUSH ZH
            PUSH YL
            PUSH YH
            PUSH XL
            PUSH XH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
            LDS   A,INTG2_TOK_AKM
            LDS   B,KN_0_INTG_TOK_AKM
            SUB   A,B
		    BREQ  IN_V_R_A_2
		    BRCC  IN_V_R_A_2
            NEG   A
IN_V_R_A_2: LDI   B,12
            MUL   A,B
            MOVW  YL,R0
            LDS   A,KN_KF_TOK_IND_AKM
            RCALL DIV_16_8
            MOVW  ZL,YL
            MOV   A,YL
            LDS   YL,SYM_TOK_AKM_L
            LDS   YH,SYM_TOK_AKM_H
            RCALL DIV_16_8
            MOVW  XL,YL
            RCALL B16_BCD_5
            LDI   B,$30
            LDS   A,ZN2
			TST   A
			BRNE  IN_V_R_A_4
            LDI   A,32
            RCALL RW_DAN_LCD
            LDS   A,ZN3
			TST   A
			BRNE  IN_V_R_A_5
            LDI   A,32
            RCALL RW_DAN_LCD
            LDS   A,ZN4
			TST   A
			BRNE  IN_V_R_A_6
            LDI   A,32
            RCALL RW_DAN_LCD
            RJMP  IN_V_R_A_7
IN_V_R_A_4: ADD   A,B
            RCALL RW_DAN_LCD
IN_V_R_A_5: LDS   A,ZN3
            ADD   A,B
            RCALL RW_DAN_LCD
IN_V_R_A_6: LDS   A,ZN4
            ADD   A,B
            RCALL RW_DAN_LCD
IN_V_R_A_7: LDS   A,ZN5
            ADD   A,B
            RCALL RW_DAN_LCD
            LDI   A,44                    ;","
            RCALL RW_DAN_LCD
            MOVW  YL,ZL
			CLR   YH
            LDI   A,6
            RCALL DIV_16_8
            MOV   YH,A        ;OSTAT_N
            MOV   A,YL
            MOV   YL,YH
			CLR   YH
            RCALL DIV_16_8
            CPI   YL,6
			BRCC  IN_V_R_A_1
            MOV   A,YL
            RJMP  IN_V_R_A_3
IN_V_R_A_1: LDI   A,5
IN_V_R_A_3: ADD   A,B
            RCALL RW_DAN_LCD
            LDI   A,192                   ;""
            RCALL RW_DAN_LCD
            POP B
            POP A
            OUT SREG,A
            POP A
            POP XH
            POP XL
            POP YH
            POP YL
		    POP ZH
		    POP ZL
            RET


IND_TERMO:  PUSH ZL
            PUSH ZH
            PUSH A
            IN   A,SREG
            PUSH A
            PUSH B
            LDS  A,SHAG_IND
            LDS  B,SHAG_IND_BIL
            CP   A,B
			BREQ IN_TM_1
			STS  SHAG_IND_BIL,A
            LDI  ZH,high(TXT_TERMO_1S*2)
            LDI  ZL,low(TXT_TERMO_1S*2)
            RCALL RW_TEKCT_LCD
            LDI  ZH,high(TXT_CLR_2S*2)
            LDI  ZL,low(TXT_CLR_2S*2)
            RCALL RW_TEKCT_LCD
IN_TM_1:    LDI   A,0B11000001
            RCALL RW_KOM_LCD
            RCALL MASH_TERM_ZAR
            LDI   A,0B11000111
            RCALL RW_KOM_LCD
            RCALL MASH_TERM_DC
            POP B
            POP A
            OUT SREG,A
            POP A
		    POP ZH
		    POP ZL
            RET



MASH_TERM_ZAR:
            PUSH B
            PUSH R0
            PUSH R1
            PUSH XL
            PUSH XH
            PUSH YL
            PUSH YH
            LDS   A,TERM_ZAR
			SUBI  A,K_0_TERM_ZAR
            BRCS  MH_TRZ_2
			BRNE  MH_TRZ_1
MH_TRZ_2:   LDI   A,32
            STS   ZNAK_IND,A
            LDI   A,0
            STS   ZN1,A
            STS   ZN2,A
            STS   ZN3,A
            RJMP  RMH_TRZ
MH_TRZ_1:   LDI   B,10
            MUL   A,B
            MOV   YL,R0
            MOV   YH,R1
            LDI   A,K_KF_TERM_ZAR
            RCALL DIV_16_8
            MOVW  XL,YL
            RCALL B16_BCD_5
            LDS   B,ZN3
            LDS   A,ZN5
			STS   ZN3,A
            LDS   A,ZN4
			STS   ZN2,A
			STS   ZN1,B
RMH_TRZ:    RCALL  RW_TOK_LCD
            POP YH
            POP YL
            POP XH
            POP XL
            POP R1
			POP R0
            POP B
            RET



MASH_TERM_DC:
            PUSH B
            PUSH R0
            PUSH R1
            PUSH XL
            PUSH XH
            PUSH YL
            PUSH YH
            LDS   A,TERM_DC3
			SUBI  A,K_0_TERM_DC
            BRCS  MH_TRD_2
			BRNE  MH_TRD_1
MH_TRD_2:   LDI   A,32
            STS   ZNAK_IND,A
            LDI   A,0
            STS   ZN1,A
            STS   ZN2,A
            STS   ZN3,A
            RJMP  RMH_TRD
MH_TRD_1:   LDI   B,10
            MUL   A,B
            MOV   YL,R0
            MOV   YH,R1
            LDI   A,K_KF_TERM_DC
            RCALL DIV_16_8
            MOVW  XL,YL
            RCALL B16_BCD_5
            LDS   B,ZN3
            LDS   A,ZN5
			STS   ZN3,A
            LDS   A,ZN4
			STS   ZN2,A
			STS   ZN1,B
RMH_TRD:    RCALL  RW_TOK_LCD
            POP YH
            POP YL
            POP XH
            POP XL
            POP R1
			POP R0
            POP B
            RET



OBR_TERM:   LDS   A,TERM_ZAR
			SUBI  A,K_0_TERM_ZAR
            BRCS  OB_TM_2
			BREQ  OB_TM_2
            LDS   B,KN_MAKS_TERM_ZAR
            CP    A,B
			BRCC  OB_TM_3
            DEC   B
            DEC   B
            DEC   B
            DEC   B
            DEC   B
            CP    A,B
			BRCC  OB_TM_4
OB_TM_2:    CBR   FL_AVR_IND,(1<<F_AVR_TERM_ZAR_IND)
            RJMP  OB_TM_4
OB_TM_3:    SBR   FL_AVR_IND,(1<<F_AVR_TERM_ZAR_IND)
OB_TM_4:    LDS   A,TERM_DC3
			SUBI  A,K_0_TERM_DC
            BRCS  OB_TM_5
			BREQ  OB_TM_5
            LDS   B,KN_MAKS_TERM_DC
            CP    A,B
			BRCC  OB_TM_6
            DEC   B
            DEC   B
            DEC   B
            DEC   B
            DEC   B
            CP    A,B
			BRCC  OB_TM_7
OB_TM_5:    CBR   FL_AVR_IND,(1<<F_AVR_TERM_DC3_IND)
            RJMP  OB_TM_7
OB_TM_6:    SBR   FL_AVR_IND,(1<<F_AVR_TERM_DC3_IND)
OB_TM_7:    RET


IND_AVR:     SBRS  FL_SIST_IND,F_RABOT
             RJMP  RIND_AV
             LDS   A,KLAV_PRED
             CBR   A,0B11111000
 		     BREQ  IN_AV_2
             LDI   A,100
			 STS   VR_IND_AVR,A
             CBR   FL_SIST_IND,(1<<F_IND_AVR)
             CBR   FL_AVR_IND,(1<<F_ERR_EPROM)
             RJMP  RIND_AV
IN_AV_2:     LDS   A,VR_IND_AVR
             TST   A
			 BRNE  RIND_AV
             SBRS  FL_AVR_IND,F_ERR_EPROM
             RJMP  IN_AV_6
			 RCALL IND_AVR_EPROM
             RJMP  IN_AV_7
IN_AV_6:     LDS   A,FL_AVR_ZAR
             SBRC  A,F_AVR_TOK_ZAR
             RJMP  IN_AV_11
             LDS   A,FL_AVR_DC3
             SBRC  A,F_AVR_TOK_DC3 
             RJMP  IN_AV_11
             LDS   A,FL_AVR_INV
             SBRS  A,F_AVR_TOK_INV
             RJMP  IN_AV_1
IN_AV_11:	 RCALL IND_AVR_TOK
             RJMP  IN_AV_7
IN_AV_1:     SBRC  FL_AVR_OBM_IND,F_AVR_OBM_DC3_2
             RJMP  IN_AV_8
             SBRC  FL_AVR_OBM_IND,F_AVR_OBM_ZAR_2
             RJMP  IN_AV_8
             SBRS  FL_AVR_OBM_IND,F_AVR_OBM_INV_2
             RJMP  IN_AV_9
IN_AV_8:     RCALL IND_AVR_OBM
             RJMP  IN_AV_7
IN_AV_9:     LDS   A,FL_AVR_ZAR
             SBRC  A,F_FAT_AVR_ZAR
             RJMP  IN_AV_13
             LDS   A,FL_AVR_DC3
             SBRC  A,F_FAT_AVR_DC3
             RJMP  IN_AV_13
             LDS   A,FL_AVR_INV
             SBRS  A,F_FAT_AVR_INV
             RJMP  IN_AV_5
IN_AV_13:	 RCALL IND_FOT_AVR
             RJMP  IN_AV_7
IN_AV_5:     SBRC  FL_AVR_IND,F_AVR_TERM_ZAR_IND
             RJMP  IN_AV_4
             SBRS  FL_AVR_IND,F_AVR_TERM_DC3_IND
             RJMP  IN_AV_3
IN_AV_4:	 RCALL IND_AVR_TERM
             RJMP  IN_AV_7
IN_AV_3:     SBRS  FL_AVR_IND,F_AVR_SET
             RJMP  RIND_AV
             RCALL IND_AVR_SET
IN_AV_7:     SBR   FL_SIST_IND,(1<<F_IND_AVR)
RIND_AV:     RET


IND_AVR_EPROM:
            PUSH ZL
            PUSH ZH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
			LDI A,41
			STS SHAG_IND_BIL,A
            LDI ZH,high(TEKC_AVAR*2)
            LDI ZL,low(TEKC_AVAR*2)
            RCALL RW_TEKCT_LCD
            LDI ZH,high(TEKC_POTER_DAN*2)
            LDI ZL,low(TEKC_POTER_DAN*2)
            RCALL RW_TEKCT_LCD
            POP B
            POP A
            OUT SREG,A
            POP A
		    POP ZH
		    POP ZL
            RET



IND_AVR_OBM:
            PUSH ZL
            PUSH ZH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
			LDI  A,41
			STS  SHAG_IND_BIL,A
            LDI  ZH,high(TXT_CLR_2S*2)
            LDI  ZL,low(TXT_CLR_2S*2)
            RCALL RW_TEKCT_LCD
            SBRS  FL_AVR_OBM_IND,F_AVR_OBM_ZAR_2
            RJMP  IN_AV_OB_1
            LDI   ZH,high(TXT_AVR_OBM_ZAR*2)
            LDI   ZL,low(TXT_AVR_OBM_ZAR*2)
            RCALL RW_TEKCT_LCD
            LDI   A,0B11000010
            RCALL RW_KOM_LCD
            LDS   A,AVR_SH_OBM_ZAR
            RCALL IND_DAN_LSD
            RJMP  RIN_AV_OB
IN_AV_OB_1: SBRS  FL_AVR_OBM_IND,F_AVR_OBM_DC3_2
            RJMP  IN_AV_OB_2
            LDI   ZH,high(TXT_AVR_OBM_DC3*2)
            LDI   ZL,low(TXT_AVR_OBM_DC3*2)
            RCALL RW_TEKCT_LCD
            LDI   A,0B11000010
            RCALL RW_KOM_LCD
            LDS   A,AVR_SH_OBM_DC3
            RCALL IND_DAN_LSD
            RJMP  RIN_AV_OB
IN_AV_OB_2: LDI   ZH,high(TXT_AVR_OBM_INV*2)
            LDI   ZL,low(TXT_AVR_OBM_INV*2)
            RCALL RW_TEKCT_LCD
            LDI   A,0B11000010
            RCALL RW_KOM_LCD
            LDS   A,AVR_SH_OBM_INV
            RCALL IND_DAN_LSD
RIN_AV_OB:  POP B
            POP A
            OUT SREG,A
            POP A
		    POP ZH
		    POP ZL
            RET


IND_AVR_TOK:
            PUSH ZL
            PUSH ZH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
			LDI   A,41
			STS   SHAG_IND_BIL,A
            LDI   ZH,high(TXT_AVR_TOK*2)
            LDI   ZL,low(TXT_AVR_TOK*2)
            RCALL RW_TEKCT_LCD
            LDS   A,FL_AVR_ZAR
            SBRS  A,F_AVR_TOK_ZAR
            RJMP  IN_AV_TK_1
            LDI   ZH,high(TXT_AVR_TOK_ZAR*2)
            LDI   ZL,low(TXT_AVR_TOK_ZAR*2)
            RCALL RW_TEKCT_LCD
            RJMP  RIN_AV_TK
IN_AV_TK_1: LDS   A,FL_AVR_DC3
            SBRS  A,F_AVR_TOK_DC3
            RJMP  IN_AV_TK_2
            LDI   ZH,high(TXT_AVR_TOK_DC_300V*2)
            LDI   ZL,low(TXT_AVR_TOK_DC_300V*2)
            RCALL RW_TEKCT_LCD
            RJMP  RIN_AV_TK
IN_AV_TK_2: LDS   A,FL_AVR_INV
            SBRS  A,F_AVR_TOK_INV
            RJMP  RIN_AV_TK
            LDI   ZH,high(TXT_INVER*2)
            LDI   ZL,low(TXT_INVER*2)
            RCALL RW_TEKCT_LCD
RIN_AV_TK:  POP B
            POP A
            OUT SREG,A
            POP A
		    POP ZH
		    POP ZL
            RET


IND_FOT_AVR: 
            PUSH ZL
            PUSH ZH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
			LDI   A,41
			STS   SHAG_IND_BIL,A
            LDI   ZH,high(TXT_FOT_AVR*2)
            LDI   ZL,low(TXT_FOT_AVR*2)
            RCALL RW_TEKCT_LCD
            LDS   A,FL_AVR_ZAR
            SBRS  A,F_FAT_AVR_ZAR
            RJMP  IN_AV_FT_1
            LDI   ZH,high(TXT_ZAR*2)
            LDI   ZL,low(TXT_ZAR*2)
            RCALL RW_TEKCT_LCD
            RJMP  RIN_AV_FT
IN_AV_FT_1: LDS   A,FL_AVR_DC3
            SBRS  A,F_FAT_AVR_DC3
            RJMP  IN_AV_FT_2
            LDI   ZH,high(TXT_DC_300V*2)
            LDI   ZL,low(TXT_DC_300V*2)
            RCALL RW_TEKCT_LCD
            RJMP  RIN_AV_FT
IN_AV_FT_2: LDS   A,FL_AVR_INV
            SBRS  A,F_FAT_AVR_INV
            RJMP  RIN_AV_FT
            LDI   ZH,high(TXT_INVER*2)
            LDI   ZL,low(TXT_INVER*2)
            RCALL RW_TEKCT_LCD
RIN_AV_FT:  POP B
            POP A
            OUT SREG,A
            POP A
		    POP ZH
		    POP ZL
            RET


IND_AVR_TERM:
            PUSH ZL
            PUSH ZH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
			LDI   A,41
			STS   SHAG_IND_BIL,A
            LDI   ZH,high(TXT_AVR_TERM*2)
            LDI   ZL,low(TXT_AVR_TERM*2)
            RCALL RW_TEKCT_LCD
            SBRS  FL_AVR_IND,F_AVR_TERM_ZAR_IND
            RJMP  IN_AV_TR_1
            LDI   ZH,high(TXT_ZAR*2)
            LDI   ZL,low(TXT_ZAR*2)
            RCALL RW_TEKCT_LCD
            RJMP  RIN_AV_TR
IN_AV_TR_1: LDI   ZH,high(TXT_DC_300V*2)
            LDI   ZL,low(TXT_DC_300V*2)
            RCALL RW_TEKCT_LCD
RIN_AV_TR:  POP B
            POP A
            OUT SREG,A
            POP A
		    POP ZH
		    POP ZL
            RET


IND_AVR_SET:
            PUSH ZL
            PUSH ZH
            PUSH A
            IN A,SREG
            PUSH A
            PUSH B
			LDI   A,41
			STS   SHAG_IND_BIL,A
            LDI   ZH,high(TXT_CLR_2S*2)
            LDI   ZL,low(TXT_CLR_2S*2)
            RCALL RW_TEKCT_LCD
            LDS   A,FL_AVR_ZAR
            SBRS A,F_SET_MAKC
            RJMP IN_AV_ST_1
            LDI ZH,high(TXT_SET_BOLEE*2)
            LDI ZL,low(TXT_SET_BOLEE*2)
            RCALL RW_TEKCT_LCD
            LDI A,0B11000010
            RCALL RW_KOM_LCD
            LDS  A,Z_MAKS_VLT_SET
            RJMP RIN_AV_ST
IN_AV_ST_1: LDI ZH,high(TXT_SET_MENEE*2)
            LDI ZL,low(TXT_SET_MENEE*2)
            RCALL RW_TEKCT_LCD
            LDI A,0B11000010
            RCALL RW_KOM_LCD
            LDS  A,Z_MIN_VLT_SET
RIN_AV_ST:  RCALL LSD_VLT_SET
            POP B
            POP A
            OUT SREG,A
            POP A
		    POP ZH
		    POP ZL
            RET


IND_VLT_ZAR:
            PUSH B
            PUSH R0
            PUSH R1
            PUSH XL
            PUSH XH
            PUSH YL
            PUSH YH
            TST A
            BRNE IN_VL_ZR_1
            LDI A,0
            STS ZN3,A
            STS ZN4,A
            STS ZN5,A
            RJMP IN_VL_ZR_2
IN_VL_ZR_1: LDI B,49
            MUL A,B
            MOV YL,R0
            MOV YH,R1
            LDI A,K_KF_VLT_ZAR
            RCALL DIV_16_8
            MOVW XL,YL
            RCALL B16_BCD_5
IN_VL_ZR_2: LDI B,$30
            LDS A,ZN3
            TST A
			BRNE IN_VL_ZR_3
            LDI A,32
            RCALL RW_DAN_LCD
            RJMP IN_VL_ZR_4
IN_VL_ZR_3: ADD A,B
            RCALL RW_DAN_LCD
IN_VL_ZR_4: LDS A,ZN4
            ADD A,B
            RCALL RW_DAN_LCD
            LDI A,44                    ;","
            RCALL RW_DAN_LCD
            LDS A,ZN5
            ADD A,B
            RCALL RW_DAN_LCD
            POP YH
            POP YL
            POP XH
            POP XL
            POP R1
			POP R0
            POP B
            RET


LSD_VLT_OUT:
            PUSH B
            PUSH R0
            PUSH R1
            PUSH XL
            PUSH XH
            PUSH YL
            PUSH YH
			TST   A
			BRNE  LD_VO_1
            CLR   XH
			LDI   XL,0
            RJMP  LD_VO_2
LD_VO_1:    LDI   B,10
            MUL   A,B
            MOV   YL,R0
            MOV   YH,R1
            LDI   A,K_KF_VLT_OUT
            RCALL DIV_16_8
            MOVW  XL,YL
            LDI   A,K_199_VLT_OUT
            ADD   XL,A
			CLR   A
			ADC   XH,A
LD_VO_2:    RCALL B16_BCD_5
            LDS   B,ZN3
            LDS   A,ZN5
			STS   ZN3,A
            LDS   A,ZN4
			STS   ZN2,A
			STS   ZN1,B
            RCALL RW_TOK_LCD
            POP YH
            POP YL
            POP XH
            POP XL
            POP R1
			POP R0
            POP B
            RET



IND_TOK_ZAR:
            PUSH B
            PUSH R0
            PUSH R1
            PUSH XL
            PUSH XH
            PUSH YL
            PUSH YH
            TST  A
			BRNE IN_TZ_1
            LDI  A,32
            STS  ZNAK_IND,A
            LDI  A,0
            STS  ZN1,A
            STS  ZN2,A
            STS  ZN3,A
            RJMP RIN_TZ
IN_TZ_1:    LDI  B,10
            MUL  A,B
            MOV  YL,R0
            MOV  YH,R1
            LDI  A,K_KF_TOK_IND_ZAR
            RCALL DIV_16_8
            MOVW  XL,YL
            RCALL B16_BCD_5
            LDS   B,ZN3
            LDS   A,ZN5
			STS   ZN3,A
            LDS A,ZN4
			STS ZN2,A
			STS ZN1,B
RIN_TZ:     RCALL RW_TOK_LCD
            POP YH
            POP YL
            POP XH
            POP XL
            POP R1
			POP R0
            POP B
            RET


IND_TOK_AKM:
            PUSH B
            PUSH R0
            PUSH R1
            PUSH XL
            PUSH XH
            PUSH YL
            PUSH YH
            LDS  B,KN_0_INTG_TOK_AKM
            SUB  A,B
			BRNE IN_TA_1
            LDI  A,32
            STS  ZNAK_IND,A
            LDI  A,0
            STS  ZN1,A
            STS  ZN2,A
            STS  ZN3,A
            RJMP RIN_TA
IN_TA_1:    BRCC IN_TA_2
            LDI B,43         ;+
            STS ZNAK_IND,B
            NEG A
            RJMP IN_TA_3
IN_TA_2:    LDI B,45
            STS ZNAK_IND,B    ;-
IN_TA_3:    CPI A,1
            BRNE IN_TA_4
            CLR XH
			MOV XL,A
            RJMP IN_TA_5
IN_TA_4:    LDI B,10
            MUL A,B
            MOV YL,R0
            MOV YH,R1
            LDS  A,KN_KF_TOK_IND_AKM
            RCALL DIV_16_8
            MOVW XL,YL
IN_TA_5:    RCALL B16_BCD_5
            LDS B,ZN3
            LDS A,ZN5
			STS ZN3,A
            LDS A,ZN4
			STS ZN2,A
			STS ZN1,B
RIN_TA:     POP YH
            POP YL
            POP XH
            POP XL
            POP R1
			POP R0
            POP B
            RET


IND_Z_TOK_AKM:
            PUSH B
            PUSH R0
            PUSH R1
            PUSH XL
            PUSH XH
            PUSH YL
            PUSH YH
            TST A
			BRNE IN_ZTA_1
            LDI A,32
            STS ZNAK_IND,A
            LDI A,0
            STS ZN1,A
            STS ZN2,A
            STS ZN3,A
            RJMP RIN_ZTA
IN_ZTA_1:   LDI   B,10
            MUL   A,B
            MOV   YL,R0
            MOV   YH,R1
            LDS   A,KN_KF_TOK_IND_AKM
            RCALL DIV_16_8
            MOVW  XL,YL
            RCALL B16_BCD_5
            LDS B,ZN3
            LDS A,ZN5
			STS ZN3,A
            LDS A,ZN4
			STS ZN2,A
			STS ZN1,B
RIN_ZTA:    RCALL RW_TOK_LCD
            POP YH
            POP YL
            POP XH
            POP XL
            POP R1
			POP R0
            POP B
            RET


LSD_VLT_SET:
            PUSH B
            PUSH R0
            PUSH R1
            PUSH XL
            PUSH XH
            PUSH YL
            PUSH YH
			SUBI  A,K_135_VLT_SET
			;BRCC IN_VS_1
            ;LDI  A,32
            ;STS  ZNAK_IND,A
           ; LDI  A,0
           ; STS  ZN1,A
           ; STS  ZN2,A
            ;STS  ZN3,A
            ;RJMP RIN_VS
IN_VS_1:    LDI  B,32
            MUL  A,B
            MOV  YL,R0
            MOV  YH,R1
            LDI  A,K_KF_VLT_SET
            RCALL DIV_16_8
            MOVW XL,YL
            LDI  A,2       ;K_140_VLT_SET
            ADD  XL,A
			CLR  A
			ADC  XH,A
            RCALL B16_BCD_5
            LDS  B,ZN3
            LDS  A,ZN5
			STS  ZN3,A
            LDS  A,ZN4
			STS  ZN2,A
			STS  ZN1,B
RIN_VS:     RCALL RW_TOK_LCD
            POP YH
            POP YL
            POP XH
            POP XL
            POP R1
			POP R0
            POP B
            RET

IND_DAN_LSD:
            PUSH XL
            PUSH XH
            TST A
			BRNE IN_DL_1
            LDI A,32
            STS ZNAK_IND,A
            LDI A,0
            STS ZN1,A
            STS ZN2,A
            STS ZN3,A
            RJMP RIN_DL
IN_DL_1:    MOV XL,A
            CLR XH
            RCALL B16_BCD_5
            LDS B,ZN3
            LDS A,ZN5
			STS ZN3,A
            LDS A,ZN4
			STS ZN2,A
			STS ZN1,B
RIN_DL:     RCALL RW_TOK_LCD
            POP XH
            POP XL
            RET

RW_TOK_LCD: PUSH B
            LDI B,$30
            LDS A,ZN1
			TST A
			BREQ RW_TL_2
            ADD A,B
            RCALL RW_DAN_LCD
            LDS A,ZN2
		    RJMP RW_TL_1	
RW_TL_2:    LDI A,32
            RCALL RW_DAN_LCD
            LDS A,ZN2
			TST A
			BREQ RW_TL_3
RW_TL_1:    ADD A,B
            RCALL RW_DAN_LCD
		    RJMP RW_TL_4	
RW_TL_3:    LDI A,32
            RCALL RW_DAN_LCD
RW_TL_4:    LDS A,ZN3
            ADD A,B
            RCALL RW_DAN_LCD
            POP B
            RET
   
RW_TOK_AKM_LCD:
            PUSH B
            LDS A,ZNAK_IND
            RCALL RW_DAN_LCD
            LDI B,$30
            LDS A,ZN1
			TST A
			BREQ RW_TAL_2
            ADD A,B
            RCALL RW_DAN_LCD
            LDS A,ZN2
		    RJMP RW_TAL_1	
RW_TAL_2:   LDI A,32
            RCALL RW_DAN_LCD
            LDS A,ZN2
			TST A
			BREQ RW_TAL_3
RW_TAL_1:   ADD A,B
            RCALL RW_DAN_LCD
		    RJMP RW_TAL_4	
RW_TAL_3:   LDI A,32
            RCALL RW_DAN_LCD
RW_TAL_4:   LDS A,ZN3
            ADD A,B
            RCALL RW_DAN_LCD
            POP B
            RET


NAST_LCD_SYS:
      PUSH ZL
      PUSH ZH
      PUSH A
      IN   A,SREG
      PUSH A
      LDI   ZH,high(TEKC_CLR_1STR*2)
      LDI   ZL,low(TEKC_CLR_1STR*2)
      RCALL RW_TEKCT_LCD
      LDI   ZH,high(TEKCT_SYS*2)
      LDI   ZL,low(TEKCT_SYS*2)
      RCALL RW_TEKCT_LCD
      POP A
      OUT SREG,A
      POP A
	  POP ZH
	  POP ZL
      RET


NAST_LCD:  CBI PORTB,E
           CBI PORTB,RS
           CBI PORTB,RW
           SBI DDRD,D7
           SBI DDRD,D6
           SBI DDRD,D5
           SBI DDRD,D4
           CBI PORTD,D7
           CBI PORTD,D6
           SBI PORTD,D5
           SBI PORTD,D4
           NOP
           SBI PORTB,E
           NOP
           NOP
           NOP
           NOP
           CBI PORTB,E
           RCALL VREM_5MC      ;5MC
           SBI PORTB,E
           NOP
           NOP
           NOP
           NOP
           CBI PORTB,E
           RCALL VREM_5MC      ;5MC
           SBI PORTB,E
           NOP
           NOP
           NOP
           NOP
           CBI PORTB,E
           RCALL VREM_5MC      ;5MC
           CBI PORTD,D4
           NOP
           SBI PORTB,E
           NOP
           NOP
           NOP
           NOP
           CBI PORTB,E
           RCALL VR_100MKC
           LDI A,0B00101000
           RCALL RW_KOM_LCD
           LDI A,0B00001100
           RCALL RW_KOM_LCD
           LDI A,0B00000001
           RCALL RW_KOM_LCD
           LDI A,0B00000110
           RCALL RW_KOM_LCD
           RET


VREM_5MC:  PUSH A
           IN A,SREG
           PUSH A
           PUSH B
           LDI A,53
VR_5MC_2:  LDI B,250
VR_5MC_1:  DEC B
		   BRNE VR_5MC_1
           DEC A
		   BRNE VR_5MC_2
           POP B
           POP A
           OUT SREG,A
           POP A
           RET

VR_100MKC: PUSH A
           IN A,SREG
           PUSH A
           LDI A,255
VR_1MK_1:  DEC A
           NOP
		   BRNE VR_1MK_1
           POP A
           OUT SREG,A
           POP A
           RET



RW_TEKCT_LCD:
        LPM
        MOV   A,R0
        CPI   A,$9F
		BREQ  RTLD
		SBR   A,0B10000000
        RCALL RW_KOM_LCD
RWTLC1: ADIW  ZL,1 
        LPM
        MOV   A,R0
        CPI   A,$9F
	    BREQ  RTLD
        RCALL RW_DAN_LCD
        RJMP  RWTLC1
RTLD:   RET


RW_DAN_SYS_LCD:
        PUSH  B
        MOV   B,A
	    LDI   A,0B10000100
        RCALL RW_KOM_LCD
        RCALL RW_SIS_DAN_LCD
        POP   B
        RET

RW_BUF_SYS_LCD:
           PUSH B
           MOV B,A
		   LDI A,0B10001001
           RCALL RW_KOM_LCD
           RCALL RW_SIS_DAN_LCD
           POP B
           RET



RW_SIS_DAN_LCD:
           PUSH C
           MOV  A,B
           SWAP A
           CBR  A,0B11110000
		   CPI  A,10
		   BRCS RWSD_L1
           LDI  C,$37
           ADD  A,C
           RJMP RWSD_L2
RWSD_L1:   LDI  C,$30
           ADD  A,C
RWSD_L2:   RCALL RW_DAN_LCD
		   MOV  A,B
           CBR  A,0B11110000
		   CPI  A,10
		   BRCS RWSD_L3
           LDI  C,$37
           ADD  A,C
           RJMP RWSD_L4
RWSD_L3:   LDI  C,$30
           ADD  A,C
RWSD_L4:   RCALL RW_DAN_LCD
           POP C
           RET

RW_ADR_SYS_LCD:
           PUSH B
           PUSH C
		   LDI   A,0B10000000
           RCALL RW_KOM_LCD
           MOV   A,YH
           CBR   A,0B11110000
		   CPI   A,10
		   BRCS  RW_AS_L_1
           LDI   C,$37
           ADD   A,C
           RJMP  RW_AS_L_2
RW_AS_L_1: LDI   C,$30
           ADD   A,C
RW_AS_L_2: RCALL RW_DAN_LCD
           MOV   A,YL
           SWAP  A
           CBR   A,0B11110000
		   CPI   A,10
		   BRCS  RW_AS_L_3
           LDI   C,$37
           ADD   A,C
           RJMP  RW_AS_L_4
RW_AS_L_3: LDI   C,$30
           ADD   A,C
RW_AS_L_4: RCALL RW_DAN_LCD
		   MOV   A,YL
           CBR   A,0B11110000
		   CPI   A,10
		   BRCS  RW_AS_L_5
           LDI   C,$37
           ADD   A,C
           RJMP  RW_AS_L_6
RW_AS_L_5: LDI   C,$30
           ADD   A,C
RW_AS_L_6: RCALL RW_DAN_LCD
           POP C
           POP B
           RET


KNT_GOT_LCD:
           PUSH A    
           IN   A,SREG
           PUSH A
           RCALL RD_KOM_LCD
		   SBRC A,7
           RJMP K_GT_L_1
	       SBR  FL_SIST_IND,(1<<F_GOT_LCD)
           RJMP RK_GT_L
K_GT_L_1:  CBR  FL_SIST_IND,(1<<F_GOT_LCD)
RK_GT_L:   POP A
           OUT SREG,A
           POP A
           RET


RD_KOM_LCD:CBI DDRD,D7
           CBI DDRD,D6
           CBI DDRD,D5
           CBI DDRD,D4
           CBI PORTB,RS
           SBI PORTB,RW
           RCALL RD_LCD
           RET

RD_LCD:    SBI PORTB,E
           NOP 
           NOP 
           NOP 
           NOP 
           NOP  
           SBIS PIND,D7
           RJMP RD_LC_1
           SBR  A,0B10000000
           RJMP RD_LC_2
RD_LC_1:   CBR  A,0B10000000
RD_LC_2:   SBIS PIND,D6
           RJMP RD_LC_3
           SBR  A,0B01000000
           RJMP RD_LC_4
RD_LC_3:   CBR  A,0B01000000
RD_LC_4:   SBIS PIND,D5
           RJMP RD_LC_5
           SBR  A,0B00100000
           RJMP RD_LC_6
RD_LC_5:   CBR  A,0B00100000
RD_LC_6:   SBIS PIND,D4
           RJMP RD_LC_7
           SBR  A,0B00010000
           RJMP RD_LC_8
RD_LC_7:   CBR  A,0B00010000
RD_LC_8:   CBI  PORTB,E
           NOP  
           NOP  
           NOP  
           NOP  
           NOP  
           SBI PORTB,E
           NOP  
           NOP  
           NOP  
           NOP
           NOP
           SBIS PIND,D3
           RJMP RD_LC_9
           SBR  A,0B00001000
           RJMP RD_LC_10
RD_LC_9:   CBR  A,0B00001000
RD_LC_10:  SBIS PIND,D2
           RJMP RD_LC_11
           SBR  A,0B00000100
           RJMP RD_LC_12
RD_LC_11:  CBR  A,0B00000100
RD_LC_12:  SBIS PIND,D1
           RJMP RD_LC_13
           SBR  A,0B00000010
           RJMP RD_LC_14
RD_LC_13:  CBR  A,0B00000010
RD_LC_14:  SBIS PIND,D0
           RJMP RD_LC_15
           SBR  A,0B00000001
           RJMP RD_LC_16
RD_LC_15:  CBR  A,0B00000001
RD_LC_16:  CBI  PORTB,E
           NOP
           NOP
           NOP 
           NOP 
           NOP 
           RET



RW_KOM_LCD:CBI PORTB,RS
           RCALL RW_LCD
           RET

RW_DAN_LCD:SBI PORTB,RS
           RCALL RW_LCD
           RET


RW_LCD:    SBI DDRD,D7
           SBI DDRD,D6
           SBI DDRD,D5
           SBI DDRD,D4
           CBI PORTB,RW
           SBI PORTB,E
           SBRS A,7
           RJMP RW_LC_1
		   SBI  PORTD,D7
           RJMP RW_LC_2
RW_LC_1:   CBI  PORTD,D7
RW_LC_2:   SBRS A,6
           RJMP RW_LC_3
		   SBI  PORTD,D6
           RJMP RW_LC_4
RW_LC_3:   CBI  PORTD,D6
RW_LC_4:   SBRS A,5
           RJMP RW_LC_5
		   SBI  PORTD,D5
           RJMP RW_LC_6
RW_LC_5:   CBI  PORTD,D5
RW_LC_6:   SBRS A,4
           RJMP RW_LC_7
		   SBI  PORTD,D4
           RJMP RW_LC_8
RW_LC_7:   CBI  PORTD,D4
RW_LC_8:   NOP
           NOP
           CBI  PORTB,E
           NOP
           NOP
           SBI  PORTB,E
           SBRS A,3
           RJMP RW_LC_9
		   SBI  PORTD,D3
           RJMP RW_LC_10
RW_LC_9:   CBI  PORTD,D3
RW_LC_10:  SBRS A,2
           RJMP RW_LC_11
		   SBI  PORTD,D2
           RJMP RW_LC_12
RW_LC_11:  CBI  PORTD,D2
RW_LC_12:  SBRS A,1
           RJMP RW_LC_13
		   SBI  PORTD,D1
           RJMP RW_LC_14
RW_LC_13:  CBI  PORTD,D1
RW_LC_14:  SBRS A,0
           RJMP RW_LC_15
		   SBI  PORTD,D0
           RJMP RW_LC_16
RW_LC_15:  CBI  PORTD,D0
RW_LC_16:  NOP 
           NOP
           CBI  PORTB,E
           RCALL VR_100MKC
           RET

KL_SIS:  LDS  A,KLAV_NAST
         CBR  A,0B11111000
		 CPI  A,0B00000101    ;F_KL_H / L
		 BRNE KL_SIS8
         CBR  FL_SIST_IND,(1<<F_SISTEM)
		 LDI  A,13
		 STS  SHAG_IND_BIL,A
         CLR  A
		 STS   SHAG_IND,A
         RJMP R_KL_SIS
KL_SIS8: CPI  A,0B00000010    ;F_KL_X
		 BRNE KL_SIS5
         LDS  A,KLAV_NAST
         SBRS A,F_YD_KL_06S
         RJMP R_KL_SIS
         SBRS A,F_IZM_DAN_KL
         RJMP R_KL_SIS
         ST   Y,RAB_BYF    ;RAB_BYF > ( ADR_RAM )
         LDS  A,KLAV_NAST
         CBR  A,(1<<F_IZM_DAN_KL)
		 STS  KLAV_NAST,A
         RJMP R_KL_SIS
KL_SIS5: CPI  A,0B00000100     ;F_KL_H
		 BRNE KL_SIS1
         LDS  A,KLAV_NAST
         SBRC A,F_YD_KL_30MS
         RJMP KL_SIS2
         SBRS A,F_YD_KL_06S
         RJMP R_KL_SIS
KL_SIS2: INC  RAB_BYF
         LDS  A,KLAV_NAST
         SBR  A,(1<<F_IZM_DAN_KL)
		 STS  KLAV_NAST,A
         RJMP R_KL_SIS
KL_SIS1: CPI  A,0B00000001     ;F_KL_L
		 BRNE KL_SIS4
         LDS  A,KLAV_NAST
         SBRC A,F_YD_KL_30MS
         RJMP KL_SIS3
         SBRS A,F_YD_KL_06S
         RJMP R_KL_SIS
KL_SIS3: DEC  RAB_BYF
         LDS  A,KLAV_NAST
         SBR  A,(1<<F_IZM_DAN_KL)
		 STS  KLAV_NAST,A
         RJMP R_KL_SIS
KL_SIS4: CPI  A,0B00000011
		 BRNE KL_SIS6
         LDS  A,KLAV_NAST
         SBRC A,F_YD_KL_30MS
         RJMP KL_SIS7
         SBRS A,F_YD_KL_06S
         RJMP R_KL_SIS
KL_SIS7: SBRC A,F_IZM_DAN_KL
         RJMP KL_SIS10
         ADIW  YL,1
		 LD   RAB_BYF,Y
         RJMP R_KL_SIS
KL_SIS6: CPI  A,0B00000110
		 BRNE R_KL_SIS
         LDS  A,KLAV_NAST
         SBRC A,F_YD_KL_30MS
         RJMP KL_SIS9
         SBRS A,F_YD_KL_06S
         RJMP R_KL_SIS
KL_SIS9: SBRC A,F_IZM_DAN_KL
         RJMP KL_SIS10
         SBIW  YL,1
		 LD   RAB_BYF,Y
         RJMP R_KL_SIS
KL_SIS10:ST   Y,RAB_BYF    ;RAB_BYF > ( ADR_RAM )
         LDS  A,KLAV_NAST
         CBR  A,(1<<F_IZM_DAN_KL)
		 STS  KLAV_NAST,A
R_KL_SIS:RET



WR_EPROM:PUSH A
         IN   A,SREG
         PUSH A
         PUSH B
         PUSH C
         PUSH ZH
         PUSH ZL
		 LDI  ZH,$01        ; RAM
		 LDI  ZL,$00
		 LDI  B,0          ; 
		 LDI  A,0          ; EEPROM
WR_EP3:  SBIC EECR,EEPE   ;
         RJMP WR_EP3
		 OUT  EEARH,A
WR_EP1:  SBIC EECR,EEPE   ; 
         RJMP WR_EP1
         OUT  EEARL,A
         LD   C,Z+
		 OUT  EEDR,C       ;  EEPROM
         CLI
		 SBI  EECR,EEMPE
		 SBI  EECR,EEPE
         SEI
		 ADD  B,C          ;+ 
         INC  A
         CPI  A,$2F
         BRNE WR_EP1
WR_EP2:  SBIC EECR,EEPE   ;
         RJMP WR_EP2
         OUT  EEARL,A
		 OUT  EEDR,B       ;  EEPROM
         CLI
		 SBI  EECR,EEMPE
		 SBI  EECR,EEPE
         SEI
WR_EP4:  SBIC EECR,EEPE   ;
         RJMP WR_EP4
		 CBR  FL_SIST_IND,(1<<F_WR_EPROM)
         POP ZL
         POP ZH
         POP C
         POP B
         POP A
         OUT SREG,A
         POP A
         RET


RD_EPROM:PUSH A
         IN A,SREG
         PUSH A
         PUSH B
         PUSH C
         PUSH ZH
         PUSH ZL
RD_EP3:  SBIC EECR,EEPE   ;
         RJMP RD_EP3
		 LDI  ZH,$01         ; RAM 100
		 LDI  ZL,$00
		 LDI  B,0          ; 
		 LDI  A,0          ; EEPROM
		 OUT  EEARH,A
RD_EP1:  OUT   EEARL,A
		 SBI   EECR,EERE
		 IN    C,EEDR
		 ST    Z+,C
		 ADD   B,C          ; 
         INC   A            ; +1
         CPI   A,$2F
         BRNE  RD_EP1
         OUT   EEARL,A
		 SBI   EECR,EERE
		 IN    C,EEDR       ;E_KONT_SYM
         CPSE  C,B
         SBR   FL_AVR_IND,(1<<F_ERR_EPROM)
RD_EP_R: POP ZL
         POP ZH
         POP C
         POP B
         POP A
         OUT SREG,A
         POP A
         RET


;//////////////////////////////////////////////////////////
;  16-  
;   XH:XL  A 
;  2  XH:XL 

MU_16_8:
        PUSH YL
        PUSH YH
        PUSH R0
        PUSH R1
        mul  XL,A       ;   
        mov  YL,r0      ;     mul 
        mov  YH,r1      ; rl    mul 
        mul  XH,A       ;     
        adc  YH,r0      ; rl    mul 
        MOVW XL,YL
		POP  R1
		POP  R0
		POP  YH
		POP  YL
        RET 


;//////////////////////////////////////////////////////////
; YH:YL        
; A  
;   
; A   
;  C   
;  C = 1    ( = 0)
;   = 0     
; XH, XL   

DIV_16_8:PUSH C
         PUSH B
         PUSH XL
         PUSH XH
         tst   A        ; R20=0   
         breq  dv3      ;   C=1
         clr   B        ;  R18,R19,R21   
 	     clr   C        ;    
         clr   XL
         ldi   XH,16    ;        
dv1:     lsl   YL       ;  R17:R16     
  	     rol   YH       ;   
         rol   B        ;C,R18       
	     rol   C
	     sub   B,A      ;   
	     sbc   C,XL     ;R19:R18 - R20   R19:R18 > R20, 
	     ori   YL,0x01  ;  zi=1      
	     brcc  dv2
	     add   B,A      ;    
	     adc   C,XL
	     andi  YL,0xFE  ;  zi=0      
dv2:     dec   XH         
	     brne  dv1      ;  n=16    
         clc            ;  
		 RJMP RD_16_8   ;  =0
dv3:     sec               ; -   
RD_16_8: MOV A,B
         POP XH
         POP XL
         POP B
         POP C
         RET               ;  =1   

;//////////////////////////////////////////////////////////
; =XL            ; 
; =XH            ; 

; =XH_H          ; ----X     ZN5
; =XH_L          ; ---X-     ZN4
; =YL_H          ; --X--     ZN3
; =YL_L          ; -X---     ZN2
; =YH_H          ; X----     ZN1 

; =XH            ;BCD   1  0
; =YL            ;BCD   3  2
; =YH            ;BCD   4

B16_BCD_5:  PUSH    A
            ldi     YH, -1
B16_BC_5_1: inc     YH
            subi    XL, low(10000)
            sbci    XH, high(10000)
            brsh    B16_BC_5_1
            subi    XL, low(-10000)
            sbci    XH, high(-10000)
            ldi     YL, -0x11
B16_BC_5_2: subi    YL, -0x10
            subi    XL, low(1000)
            sbci    XH, high(1000)
            brsh    B16_BC_5_2
            subi    XL, low(-1000)
            sbci    XH, high(-1000)
B16_BC_5_3: inc     YL
            subi    XL, low(100)
            sbci    XH, high(100)
            brsh    B16_BC_5_3
            subi    XL, -100
            ldi     XH, -0x10
B16_BC_5_4: subi    XH, -0x10
            subi    XL, 10
            brsh    B16_BC_5_4
            subi    XL, -10
            add     XH, XL
            MOV   A,XH
		    CBR   A,$F0
		    STS   ZN5,A
            MOV   A,XH
		    SWAP  A
		    CBR   A,$F0
		    STS   ZN4,A
            MOV   A,YL
		    CBR   A,$F0
		    STS   ZN3,A
            MOV   A,YL
		    SWAP  A
		    CBR   A,$F0
		    STS   ZN2,A
            MOV   A,YH
		    CBR   A,$F0
		    STS   ZN1,A
            POP   A
            RET


;////////////////////////////////////////////////////////////
;VXOD   DAN    A   
;B      KOL_INTG
;XL     SUM_INTG_L
;XH     SUM_INTG_H
 
;VIXOD  DAN    A
;XL     SUM_INTG_L
;XH     SUM_INTG_H

INTG:     PUSH YL
          PUSH YH
          ADD  XL,A
		  CLR  A
		  ADC  XH,A
		  BRCS  ING_2     ;PEREPOL
          MOV   YL,XL
          MOV  YH,XH   
ING_1:    LSR  XH
          ROR  XL
		  DEC  B
		  BRNE ING_1 
          MOV  A,XL 
          SUB  YL,XL
		  CLR  XL
		  SBC  YH,XL
		  BRCS ING_3      ;PEREPOL
          MOV  XL,YL
          MOV  XH,YH
          RJMP RING
ING_2:    LDI  XL,255
          LDI  XH,255
		  LDI  A,255
          RJMP RING
ING_3:    CLR  XL
          CLR  XH
		  CLR  A
RING:     POP  YH
          POP  YL
          RET
;////////////////////////////////////////////////////////////



TABLE:
.DB 1,2,200,1,0,5,$14,1            ;R1
.DB 0,0,0,0,0,0,0,0B00000000       ;R9
.DB 0,0B00001000,10,2,12,0,0,0     ;R17
.DB 0,0,0,0,0,0,0,0                ;R25

KONS_EPR100:
.DB $B6,$09,$CA,$05,$B1,$02,70,$B0    ;100
.DB $83,40,$00,$19,5,$8C,16,9         ;108
.DB $09,$03,$29,$80,$0E,$0B,$09,100   ;110
.DB 100,$60,$4B,$83,0,0,0,0           ;118
.DB 0,0,0,0,0,0,0,0                   ;120
.DB 0,0,0,0,0,1,1,0                   ;128

KONS_140:
.DB $A7,$0B,$0,0,0,0,0,0       ;140
.DB 0,0,0,0,0,0,0,0            ;148
.DB 0,0,0,0,0,0,0,0            ;150
.DB 0,0,0,0,30,0,0,0           ;158
.DB 1,1,10,50,30,10,0,1        ;160
.DB 0,0,0,0,0,0,5,0            ;168
.DB 0,1,10,10,0,0,0,0          ;170
.DB 0,0,0,1,1,0,0,0            ;178
.DB 0,0,0,0,0,0,0,0            ;180
.DB 0,0,0,0,$79,0,8,0          ;188
.DB 30,0,0,0,0,0,$95,0         ;190
.DB 200,0,$79,0,0,0,0,0        ;198
.DB 0,0,$79,0,0,0,0,0          ;1A0
.DB 0,0,20,3,50,0,0,0          ;1A8

TEKCT_SYS:
.DB 40,$61,$E3,$70,$20,$E3,$61,$BD
.DB $20,$20,$B2,$79,$E4,$9F,0,0

TEKC_CLR_1STR:
.DB 00,32,32,32,32,32,32,32
.DB 32,32,32,32,32,$9F,0,0

TXT_CLR_2S:
.DB 40,32,32,32,32,32,32,32
.DB 32,32,32,32,32,$9F,0,0

TEKC_AVAR:                       ;
.DB 00,32,32,32,65,66,65,80
.DB 165,177,32,32,32,$9F,0,0

TEKC_POTER_DAN:                 ; 
.DB 40,168,79,84,69,80,177,32
.DB 224,65,72,72,32,$9F,0,0

TXT_FOT_AVR:
.DB 0,32,228,65,84,65,167,32    ;  
.DB 65,66,65,80,32,$9F,0,0

TXT_AVR_TOK:
.DB 0,32,32,65,66,65,80,32      ;   
.DB 84,79,75,32,32,$9F,0,0

TXT_AVR_TERM:
.DB 0,32,65,66,65,80,32,84      ;  
.DB 69,80,77,79,32,$9F,0,0

TXT_AVR_TOK_ZAR:                 ; 
.DB 40,32,164,65,80,177,224,72
.DB 165,75,65,32,32,$9F,0,0

TXT_AVR_TOK_DC_300V:             ;DC 12-300V
.DB 40,32,68,67,32,49,50,45
.DB 51,48,48,86,32,$9F,0,0
   
TXT_INVER:                       ;
.DB 40,32,165,72,66,69,80,84
.DB 79,80,65,32,32,$9F,0,0

TXT_AVR_OBM_ZAR:                  ;  
.DB 0,65,66,80,32,79,160,77  
.DB 32,164,65,80,32,$9F,0,0

TXT_AVR_OBM_DC3:                  ;  DC3
.DB 0,65,66,80,32,79,160,77   
.DB 32,68,67,51,32,$9F,0,0

TXT_AVR_OBM_INV:                  ;  
.DB 0,65,66,80,32,79,160,77   
.DB 32,165,72,66,32,$9F,0,0

TXT_SET_BOLEE:                    ;    
.DB 0,179,32,99,101,191,184,32 
.DB 178,111,187,101,101,$9F,0,0

TXT_SET_MENEE:                    ;    
.DB 0,179,32,99,101,191,184,32 
.DB 188,101,189,101,101,$9F,0,0

TXT_ZAR:                          ;
.DB 40,32,164,65,80,177,224,72
.DB 165,75,65,32,32,$9F,0,0

TXT_DC_300V:                      ;DC 12-300V
.DB 40,32,68,67,32,49,50,45
.DB 51,48,48,86,32,$9F,0,0

TXT_REZ_AKM_1S:                   ; 
.DB 0,32,80,69,164,32,65,75
.DB 75,169,77,169,167,$9F,0,0

TXT_V_A_2STR:
.DB 40,86,32,32,32,32,32,32        ;V     A      
.DB 65,32,32,32,32,$9F,0,0

TXT_ZAD_VLT_ZAR1_1S:              ;  1
.DB 0,72,65,168,80,32,164,65
.DB 80,177,224,32,49,$9F,0,0

TXT_ZAD_VLT_ZAR2_1S:              ;  2
.DB 0,72,65,168,80,32,164,65
.DB 80,177,224,32,50,$9F,0,0

TXT_ZAD_TOK_ZAR1_1S:              ;  1 
.DB 0,84,79,75,32,164,65,80
.DB 177,224,65,32,49,$9F,0,0

TXT_ZAD_TOK_ZAR2_1S:              ;  2 
.DB 0,84,79,75,32,164,65,80
.DB 177,224,65,32,50,$9F,0,0

TXT_TOK_IST_AKM:                   ;  
.DB 0,84,79,75,32,165,67,84
.DB 32,65,75,77,32,$9F,0,0

TXT_Z_R_2STR:
.DB 40,164,95,32,32,32,32,80       ;_    _     
.DB 95,32,32,32,32,$9F,0,0

TXT_MAKS_VLT_SET_1S:               ; V  
.DB 0,188,97,186,99,32,86,32
.DB 99,101,191,184,32,$9F,0,0

TXT_MIN_VLT_SET_1S:                ; V  
.DB 0,32,188,184,189,32,86,32
.DB 99,101,191,184,32,$9F,0,0

TXT_Z_KMP_TOK_AKM_1S:              ; .  
.DB 0,75,77,168,46,84,79,75
.DB 32,65,75,77,46,$9F,0,0

TXT_VLT_OUT_1S:                    ;  "
.DB 0,189,97,190,112,32,179,195
.DB 120,111,227,97,32,$9F,0,0

TXT_MOSHN_1S:                      ; "
.DB 0,188,111,230,189,111,99,191
.DB 196,32,179,191,32,$9F,0,0

TXT_TERMO_1S:                      ; "
.DB 0,84,101,188,190,101,112,97
.DB 191,121,112,97,32,$9F,0,0

TXT_UMKS_AKM:                      ;  "
.DB 0,32,181,188,186,111,99,191
.DB 196,32,65,75,77,$9F,0,0
 
TXT_ZVYK_1S:                       ; 
.DB 0,32,32,32,32,164,66,169
.DB 75,32,32,32,32,$9F,0,0

TXT_EKONOM_1S:                     ; 
.DB 0,32,175,186,111,189,111,188
.DB 32,112,101,182,32,$9F,0,0

TXT_RAZRESHON_2S:                  ;"
.DB 40,32,32,80,65,164,80,69     
.DB 172,69,72,32,32,$9F,0,0

TXT_ZAPRET_2S:                    ;٨  "
.DB 40,32,32,164,65,168,80,69    
.DB 226,162,72,32,32,$9F,0,0

TXT_Z_MIN_V_AKM_1S:               ;  "
.DB 0,188,184,189,32,189,97,190
.DB 112,32,97,186,188,$9F,0,0

TXT_KPD_TOK_AKM_1S:               ;  
.DB 0,32,75,168,224,32,65,75
.DB 75,169,77,32,32,$9F,0,0

TXT_ZAVOD_KONC_1S:               ; 
.DB 0,32,72,65,67,84,80,79
.DB 166,75,165,32,32,$9F,0,0

TXT_ZAVOD_KONC_2S:               ; ?
.DB 40,32,67,160,80,79,67,165
.DB 84,98,63,32,32,$9F,0,0

TXT_SON_1S:                      ; 
.DB 0,32,77,174,32,164,65,67
.DB 72,169,167,165,32,$9F,0,0

TXT_USTIROV_1S:                  ;  ?
.DB 0,176,67,84,165,80,79,66
.DB 65,84,98,32,63,$9F,0,0





