

           ;ZAR FORUM


.EQU PIND=0x09    ;  
.EQU DDRD=0x0A    ; 
.EQU PORTD=0x0B   ;  


.EQU PINC=0x06    ;  
.EQU DDRC=0x07    ; 
.EQU PORTC=0x08   ;  

.EQU  PINB=0x03   ;  
.EQU  DDRB=0x04   ; 
.EQU  PORTB=0x05  ;  
.equ  MOST_H       =1
.equ  MOST_L       =2
.equ  SILA         =4
.equ  LED          =5



.EQU ADCL=0x78    ;  . 
.EQU ADCH=0x79    ;  . 
.EQU ADCSRA=0x7A  ;  
.equ ADSC =6
.EQU ADMUX=0x7C   ;  
.equ ADLAR =5


.EQU WDTCSR=0x60   ; 
.equ   WDIF 	=7
.equ   WDIE 	=6
.equ   WDP3 	=5
.equ   WDCE 	=4
.equ   WDE   	=3
.equ   WDP2 	=2
.equ   WDP1 	=1
.equ   WDP0 	=0


.EQU TCCR0A=0x44    ;   TC0
.EQU TCCR0B=0x45    ;   TC0
.EQU TCNT0=0x46     ; TC0
.EQU TIMSK0=0x6E    ;   
.EQU TIFR0=0x15


.EQU TIMSK1=0x6F   ;   1
.EQU TIFR1=0x36
.EQU TCCR1A=0x80   ;   1
.equ COM1B0  =4 
.equ COM1B1  =5 
.EQU TCCR1B=0x81   ;   1
.EQU TCCR1C=0x82   ;   1
.EQU TCNT1H=0x85
.EQU TCNT1L=0x84
.EQU OCR1AH=0x89   ;  1 .   
.EQU OCR1AL=0x88  
.EQU OCR1BH=0x8B   ;  1 . 
.EQU OCR1BL=0x8A   ;  1 .  
.EQU ICR1H=0x87   ;
.EQU ICR1L=0x86   ;


.EQU TIMSK2=0x70
.EQU TIFR2=0x37
.EQU TCCR2A=0xB0   ;  2
.EQU TCCR2B=0xB1
.EQU TCNT2=0xB2
.EQU OCR2A=0xB3    ;  2 
.EQU OCR2B=0xB4    ;  2 
.EQU ASSR=0xB6


.EQU EICRA=0x69    ;  INT0
.equ ISC11   =3
.equ ISC10   =2
.equ ISC01   =1
.equ ISC00   =0

.EQU EIMSK=0x3D    ;   INT0
.equ INT1    =1
.equ INT0    =0

.EQU EIFR=0x3C     ;   INT0
.equ INTF1    =1
.equ INTF0    =0

.EQU SPL=0x3D
.EQU SPH=0x3E
.EQU SREG=0x3F



.EQU UDR=0xC6     ; USART
.EQU UCSRA=0xC0   ; USART
.equ RXC   =7 
.equ TXC   =6 
.equ UDRE  =5
.equ FE    =4
.equ DOR   =3
.equ UPE   =2
.equ U2X   =1
.equ MPCM  =0

.EQU UCSRB=0xC1   ; USART
.equ RXCIE   =7 
.equ TXCIE   =6 
.equ UDRIE   =5
.equ RXEN    =4
.equ TXEN    =3
.equ UCSZ2   =2
.equ RXB8    =1
.equ TXB8    =0

.EQU UCSRC=0xC2   ; USART
.equ UMSEL1  =7
.equ UMSEL0  =6 

.EQU UBRRH=0xC5   ; USART
.EQU UBRRL=0xC4   ; USART


.def YK_TKT_ADC            =r2  ;
.def SYM_OBM               =r3  
.def NACL_VR_SHIM          =r4
.def DAN_ADCH              =r5
.def KONT_PRX_PROG         =r6   ;
.def VLT_ZAR               =r7
.def Z_PI_OGR_TOK_AKM      =r8
.def Z_TOK_AKM             =r9   ;USART
.def Z_VLT_ZAR             =r10  ;USART
.def KN_0_TOK_AKM_ZAR      =r11  ; UST
.def Z_PI_H                =r12  ;USART
.def Z_PI_L                =r13  ;USART
.def TOK_AKM_ZAR           =r14  ;0
.def KN_0_TOK_ZAR          =r15  ; UST

.def  FL_SIS_ZAR         =r16     ;02
.equ  F_START                =0
.equ  F_NACL                 =1
.equ  F_VKL_SIL              =2
;.equ  F_TERM_OGR_TOK         =3
.equ  F_SET_OGR_TOK          =4
.equ  F_REZ_TOK_AKM          =5
.equ  F_REZ_TOK_ZAR          =6
.equ  F_FRNT_TOK_ZAR         =7


.def  FL_AVR_ZAR         =r17 
.equ  F_AVR_TOK_ZAR	         =0
;.equ  F_AVR_TERM_ZAR	     =1
.equ  F_SET_MIN	             =2
.equ  F_SET_MAKC             =3
.equ  F_AVR_OBM_ZAR          =4
.equ  F_AVR_SM_OBM_ZAR       =5
.equ  F_FAT_AVR_ZAR          =7


.def  FL_TR_RAB_ZAR      =r18
.equ  F_TR_RAB_ZAR          =0
.equ  F_TR_UST_ZAR          =1

.def SHAG_OBM             =r19
.def KL_AVR_TOK_ZAR       =r20 
.def TOK_ZAR              =r21
.def DL_SHIM              =r22  ;$00    


.def A  =r23      ;
.def B  =r24      ;
.def C  =r25

.def XL =r26
.def XH =r27
.def YL =r28      ;
.def YH =r29      ;
.def ZL =r30      ;
.def ZH =r31      ;


.EQU VR_START       =0x100
.EQU VR_10MC        =0x101
.EQU VR_01S         =0x102
.EQU VR_1S          =0x103
.EQU PAYZA_IND      =0x104
.EQU SHIM_IND       =0x105
.EQU KOL_IMP_IND    =0x106
.EQU VR_K_TERM      =0x107
.EQU Z_VLT_SET_MAKC =0x108
.EQU Z_VLT_SET_MIN  =0x109
.EQU VR_K_SET       =0x10A
.EQU KOL_PEREZ      =0x10B
.EQU VR_K_OBM       =0x10C

.EQU SUM_INTG_TOK_ZAR_L      =0x10D
.EQU SUM_INTG_TOK_ZAR_H      =0x10E
.EQU SUM_INTG_VLT_SET_L      =0x10F
.EQU SUM_INTG_VLT_SET_H      =0x110
.EQU VR_REZ_TOK_AKM          =0x111
.EQU INTG_TOK_ZAR            =0x112
.EQU SUM_INTG_VLT_ZAR_IND_L  =0x113
.EQU SUM_INTG_VLT_ZAR_IND_H  =0x114
.EQU VLT_ZAR_IND             =0x115
.EQU TOK_ZAR_IND             =0x116
.EQU VLT_SET                 =0x117
.EQU TERM_ZAR                =0x118
.EQU Z_TOK_FEN               =0x119 ;USART
.EQU PAUZ_OBM                =0x11A
.EQU LED_IMPL                =0x11B
.EQU VR_PODG_STAPT           =0x11C
.EQU SUM_INTG_TOK_AKM_L      =0x11D
.EQU SUM_INTG_TOK_AKM_H      =0x11E
;.EQU                        =0x11F ;

.EQU BUF_OBM0                =0x120  ; 
.EQU BUF_OBM1                =0x121
.EQU BUF_OBM2                =0x122
.EQU BUF_OBM3                =0x123
.EQU BUF_OBM4                =0x124
.EQU BUF_OBM5                =0x125
.EQU BUF_OBM6                =0x126
.EQU BUF_OBM7                =0x127
.EQU BUF_OBM8                =0x128
.EQU BUF_OBM9                =0x129
.EQU VR_4M                   =0x12A
.EQU Z_PI_TOK_ZAR            =0x12B
.EQU KN_AVR_TOK_ZAR          =0x12C
.EQU REZ1_ZAR                =0x12D
.EQU KL_VLT_SET              =0x12E
.EQU SUM_VLT_SET_L           =0x12F
.EQU SUM_VLT_SET_H           =0x130
.EQU VR_VLT_SET              =0x131

.EQU K_SM_SH_KAN_B            =250 ;  
.EQU K_SM_SH_KAN_A            =5   ;  
.EQU K_MAKC_DL_SHIM           =100  ;  127 
                                    ;    
                                    ;  1     
                                    ; 16  
                                    ;1=0,125  (1/0,125=8)
                                    ;  
                                    ;127-8=119 
.EQU K_MIN_DL_SHIM            =5    ; 5 
.EQU K_SET_OGR_TOK            =5

.EQU K_NACL_VR_SHIM       =40
;.EQU K_PI_H               =8   ;18
;.EQU K_PI_L               =8   ;28
;.EQU K_VR_SHM             =8 ;

;.EQU K_0GR_TERM           =25
;.EQU K_OBR_TERM           =10
;.EQU K_MAKS_TERM          =178  ;65C
;.EQU K_MIN_TERM           =145  ;50C
;.EQU K_TRM_OGR_TOK        =130  ;35C

;.EQU K_0_TOK_ZAR          =127  ;
;.EQU K_AVAR_TOK_ZAR       =30  ;180
.EQU K_0_VLT_SET           =140 ;132 140




.ORG    0x000       
        rjmp  NACZALO
.ORG    0x001       
        rjmp  INT_0
.ORG    0x010
        rjmp  PEREP_TC0     ;  1MC
.ORG    0x012
        RJMP  RD_USART_ZAR   ; USART
.ORG    0x014
;        RJMP  WR_USART_ZAR   ;  USART
.ORG    0x015
        rjmp  ADC0          ;  27k   
      

.ORG 0x30      
NACZALO:  CLI    
          ldi A,0B00111001     ;RECZIM  PORT B
          out DDRB,A      
          ldi A,0B00000000     ;DAN     PORT B
          out PORTB,A     
          ldi A,0B11111000     ;RECZIM  PORT D
          out DDRD,A 
          ldi A,0B00000110     ;DAN     PORT D
          out PORTD,A     
          ldi A,0B00000010     ;RECZIM  PORT C
          out DDRC,A 
          ldi A,0B00000000     ;DAN     PORT C
          out PORTC,A     
          ldi A,0               ;ZAGR STEKA
          out SPL,A
          ldi A,$04             ;ZAGR STEKA
          out SPH,A

          CBI PORTB,LED   ;===================
          RCALL VREM     ;==================

          ldi A,0
          STS TCNT1H,A          ;ZAGRUZ DAN TC1H
          ldi A,$FF
          STS TCNT1L,A          ;ZAGRUZ DAN TC1L
          ldi A,0B10110001      ;   1
          STS TCCR1A,A             
          ldi A,0B00000001      ;   1
          STS TCCR1B,A   
          ldi A,0               ; A 1
          STS OCR1AH,A  
          ldi A,10
          STS OCR1AL,A   
          ldi A,0               ; B 1
          STS OCR1BH,A  
          ldi A,245
          STS OCR1BL,A  
          LDS A,TIMSK1            ;TIMSK TC1
		  SBR A,0B00000000
          STS TIMSK1,A  		  
		   

          LDS A,TIMSK2            ;TIMSK TC2
		  SBR A,0B00000000
          STS TIMSK2,A  
	      ldi A,0B00000000      ;   
		  out TIFR2,A   		  
          ldi A,0B10000001      ;   2
          STS TCCR2A,A     
          ldi A,0B00000010     ;   2
          STS TCCR2B,A   
          ldi A,0B00000001
          STS TCNT2,A          ;ZAGRUZ DAN TC2
          ldi A,0              ; A 2
          STS OCR2A,A  
          ldi A,0               ; B 2
          STS OCR2B,A  


		  ldi A,1               ;ZAGRUZ DAN TC0
          STS TCNT0,A 
		  ldi A,0B00000011      ;  0
          STS TCCR0A,A 
          LDS A,TIMSK0            ;TIMSK TC0
		  SBR A,0B00000001
          STS TIMSK0,A  	
		  LDI A,0B00000011
          STS TCCR0B,A  
		  	  
          ldi A,0B01100000      ; 
		  STS ADMUX,A
          ldi A,0B11001101
		  STS ADCSRA,A
          ldi A,0B00011010      ;   
		  out TIFR0,A  
          SBI PORTB,LED
 
		  ldi A,0B00000010      ;  INT0
          STS EICRA,A 
		  ldi A,0B00000001      ;  INT0
          STS EIMSK,A 


          ldi  ZH,high(TABLE*2)   ;ZAGR REG 1-22 
          ldi  ZL,low(TABLE*2)
          ldi  YH,0               ;KUDA  R1
          ldi  YL,1 
          ldi  A,22               ;KOL-VO
ZAGR_REG: lpm
          st    Y+,r0
          adiw  ZL,1              ; +1
          dec   A
          brne  ZAGR_REG


NACZL2:   ldi ZH,high(KONS_100H*2)  ;ZAGR RAM 
          ldi ZL,low(KONS_100H*2)   ;100H-13FH
          ldi YH,$01 
          ldi YL,$00
RD_K_1:   lpm
          st Y+,r0
          adiw ZL,1
          CPI YL,$40
	      BRNE RD_K_1


           ;LDI A,200       ;------------------
          ; MOV Z_VLT_ZAR,A
           ;LDI A,170     
          ; MOV VLT_ZAR,A
          ; LDI A,10       
         ;  MOV Z_PI_ZAR,A
         ;  LDI DL_SHIM ,50     
         ;  SBR FL_SIS_ZAR,(1<<F_START)
;NACZ_1:    RCALL  STAB_12V   ;------------------
         ;  RJMP NACZ_1

          LDI A,0B00000000        ;ZAGRUZ  USART
		  STS UCSRA,A
          LDI A,0B00000110
		  STS UCSRC,A
          LDI A,0B10010100
		  STS UCSRB,A 
          LDI A,$01 
		  STS UBRRH,A 
          LDI A,$98
		  STS UBRRL,A 

          WDR                  ;RES STOR TAIM
          LDS A,WDTCSR         ;ZAG STOR TAIM
          SBR A,(1<<WDCE)|(1<<WDE)
          STS WDTCSR,A
          LDI A,(1<<WDE)|(1<<WDP1)  ;64  
          STS WDTCSR,A
          WDR                  ;RES STOR TAIM

          SBI PORTB,LED   ;===================


         ; LDI  A,0B11000111
         ; STS  ADCH,A
          ;MOV  DAN_ADCH,A
         ; LDI  B,0B11000000
         ; CALL OBR_VLT_SET


          SEI                   ;  
NACZL3:   RJMP NACZL3


VREM:      PUSH B
           in B,SREG
           PUSH B
           PUSH C
VREM3:     LDI C,100  ;55
VREM2:     LDI B,255
VREM1:     DEC B
           BRNE  VREM1
	       DEC C
           BRNE  VREM2
	       DEC A
           BRNE  VREM3
           POP C
           POP B
           OUT SREG,B
           POP B
		   RET


INT_0:   PUSH A
         IN   A,SREG
         PUSH A
		 ;CBI PORTB,LED
         CPI  KL_AVR_TOK_ZAR,5
		 BREQ INT_0_1
         INC  KL_AVR_TOK_ZAR
         RJMP RINT_0
INT_0_1: SBR  FL_AVR_ZAR,(1<<F_AVR_TOK_ZAR) 
RINT_0:  POP  A
         OUT  SREG,A
         POP  A
         RETI


INT_1:   RETI



RD_USART_ZAR:
            push A 
            in   A,SREG
            push A
            push B
            LDS  B,UCSRB
            LDS  A,UDR
            SEI
            SBRS B,RXB8 
            RJMP RD_USR_1
            CPI  A,0B10000000
			BREQ RD_USR_2
            LDS  B,UCSRB
            CBR  B,(1<<TXEN) 
            STS  UCSRB,B
            CLR  SHAG_OBM
            RJMP RRD_USR
RD_USR_2:   LDI  SHAG_OBM,1
            LDI  XL,$20       ;ADR_BUF_OBM
            LDI  XH,$01 
            MOV  SYM_OBM,A
            RJMP RRD_USR
RD_USR_1:   TST  SHAG_OBM
            BREQ RRD_USR
            CPI  SHAG_OBM,12
            BREQ RD_USR_4
RD_USR_3:   ADD  SYM_OBM,A
            ST   X+,A
            RJMP RD_USR_5
RD_USR_4:   CP   SYM_OBM,A
            BREQ RD_USR_6
            SBR  FL_AVR_ZAR,(1<<F_AVR_SM_OBM_ZAR)
            CLR  SHAG_OBM
            RJMP RRD_USR
RD_USR_6:   CBR  FL_AVR_ZAR,(1<<F_AVR_SM_OBM_ZAR)
            LDS  B,UCSRB
            SBR  B,(1<<TXEN) 
            STS  UCSRB,B
            RCALL OBR_BUF_OBM_ZAR
            MOV  SYM_OBM,FL_AVR_ZAR
        	STS  UDR,FL_AVR_ZAR
            LDI  A,6
            STS  PAUZ_OBM,A
RD_USR_5:   INC  SHAG_OBM
RRD_USR:    POP B
            POP A
            OUT SREG,A
            POP A
            RETI


OBR_BUF_OBM_ZAR:
            LDI XL,$20       ;ADR_BUF_OBM
            LDI XH,$01 
            LD  FL_TR_RAB_ZAR,X+
            LD  Z_VLT_ZAR,X+
            LD  Z_TOK_AKM,X+
            LD  A,X+
            STS Z_VLT_SET_MIN,A 
            LD  A,X+
            STS Z_VLT_SET_MAKC,A 
            LD  Z_PI_OGR_TOK_AKM,X+
            LD  A,X+
            STS Z_TOK_FEN,A 
            LD  Z_PI_H,X+
            LD  Z_PI_L,X+
            LD  A,X+
            STS Z_PI_TOK_ZAR,A 
            LD  A,X+
            STS KN_AVR_TOK_ZAR,A 
            RET


WR_USART_ZAR:               ; USART
            push A     
            in   A,SREG
            push A
            CPI  SHAG_OBM,20
            BRNE WR_USR_1
            LDS  B,UCSRB
            CBR  B,(1<<TXEN) 
            STS  UCSRB,B
            CLR  SHAG_OBM
            CBR  FL_AVR_ZAR,(1<<F_AVR_OBM_ZAR) 
			LDI  A,60
			STS  VR_K_OBM,A
            RJMP RWR_USR
WR_USR_1:   CPI  SHAG_OBM,13
            BRNE WR_USR_2
        	MOV  A,FL_SIS_ZAR
            RJMP WR_USR_3
WR_USR_2:   CPI  SHAG_OBM,14
            BRNE WR_USR_4
        	LDS  A,INTG_TOK_ZAR
            RJMP WR_USR_3
WR_USR_4:   CPI  SHAG_OBM,15
            BRNE WR_USR_5
        	LDS  A,VLT_ZAR_IND
            RJMP WR_USR_3
WR_USR_5:   CPI  SHAG_OBM,16
            BRNE WR_USR_8
        	LDS  A,VLT_SET
            RJMP WR_USR_3
WR_USR_8:   CPI  SHAG_OBM,17
            BRNE WR_USR_9
        	LDS  A,TERM_ZAR
            RJMP WR_USR_3
WR_USR_9:   CPI  SHAG_OBM,18
            BRNE WR_USR_6
        	LDS  A,REZ1_ZAR
WR_USR_3:   ADD  SYM_OBM,A
            RJMP WR_USR_7
WR_USR_6:   MOV  A,SYM_OBM  	
WR_USR_7:   STS  UDR,A
            INC  SHAG_OBM
            LDI  A,6
            STS  PAUZ_OBM,A
RWR_USR:    LDS  A,UCSRA
            SBR  A,(1<<TXC) 
            STS  UCSRA,A
            POP A
            OUT SREG,A
            POP A
            RET


PEREP_TC0: PUSH B         ; TC0  1
           PUSH A
           IN   A,SREG
           PUSH A
           WDR                 ;RESET STOR
           LDI  A,15
           MOV  KONT_PRX_PROG,A
           SEI
           LDS  A,PAUZ_OBM
           TST  A
		   BREQ DEL_7
		   DEC  A
           STS  PAUZ_OBM,A
           RJMP DEL_8
DEL_7:     LDS  A,UCSRA
           SBRS A,TXC 
           RJMP DEL_8
           RCALL WR_USART_ZAR
DEL_8: 	   LDS  A,VR_10MC
           TST  A
           BREQ TC0_6
           DEC  A
		   STS  VR_10MC,A
           RJMP TC0_2
TC0_6:     LDI  A,9
           STS  VR_10MC,A
           LDS  A,VR_01S
           TST  A
           BREQ TC0_1
           DEC  A
		   STS  VR_01S,A
           RJMP TC0_2
TC0_1:     LDI  A,9
           STS  VR_01S,A
           RCALL OBR_01S
           LDS  A,VR_1S
           TST  A
           BREQ TC0_3
           DEC  A
		   STS  VR_1S,A
           RJMP TC0_2
TC0_3:     LDI  A,10
           STS  VR_1S,A
           RCALL OBR_1CEK
           LDS  A,VR_4M
           TST  A
           BREQ TC0_4
           DEC  A
		   STS  VR_4M,A
           RJMP TC0_2
TC0_4:     LDI  A,250
           STS  VR_4M,A
           LDS  A,KOL_PEREZ
           TST  A
           BREQ TC0_2
           DEC  A
		   STS  KOL_PEREZ,A
TC0_2:     POP A
           OUT SREG,A
           POP A
           POP B
           RETI


OBR_01S:   RCALL OBR_V_SET
           RCALL OBR_AVR
           RCALL OBR_IND
           RET


OBR_1CEK:  LDS  A,VR_PODG_STAPT
	       TST  A
	       BREQ OB_1C_2
           DEC  A
	       STS  VR_PODG_STAPT,A
OB_1C_2:   LDS  A,VR_START
	       TST  A
	       BREQ OB_1C_1
           DEC  A
	       STS  VR_START,A
OB_1C_1:   LDS  A,Z_TOK_FEN
           STS  OCR2A,A
           CLR  KL_AVR_TOK_ZAR
ROB_1C:    RET



INTG_VLT_ZAR_IND:
         PUSH XL
         PUSH XH
         PUSH B
         PUSH A
         MOV A,VLT_ZAR
         LDI B,5                        ;KOL OTCZETOV
         LDS XL,SUM_INTG_VLT_ZAR_IND_L
         LDS XH,SUM_INTG_VLT_ZAR_IND_H
         RCALL INTG
	     STS SUM_INTG_VLT_ZAR_IND_L,XL
	     STS SUM_INTG_VLT_ZAR_IND_H,XH
	     STS VLT_ZAR_IND,A
         POP A
         POP B
         POP XH
         POP XL
         RET


OBR_AVR:   LDS A,VR_K_OBM
           TST A
	       BREQ OB_AV_5
           DEC A
	       STS VR_K_OBM,A
           RJMP OB_AV_7
OB_AV_5:   SBR FL_AVR_ZAR,(1<<F_AVR_OBM_ZAR)
OB_AV_7:   SBRS FL_AVR_ZAR,F_FAT_AVR_ZAR
           RJMP OB_AV_6
           CBR FL_SIS_ZAR,(1<<F_VKL_SIL)
           CBR FL_SIS_ZAR,(1<<F_START)
           CBI PORTB,SILA
           RJMP ROB_AV
OB_AV_6:   SBRS FL_AVR_ZAR,F_AVR_TOK_ZAR 
           RJMP OB_AV_4
           LDS A,KOL_PEREZ
	       CPI A,5
	       BRNE OB_AV_8
           SBR FL_AVR_ZAR,(1<<F_FAT_AVR_ZAR)
           RJMP OB_AV_1
OB_AV_8:   INC A
	       STS KOL_PEREZ,A
           CBR FL_AVR_ZAR,(1<<F_AVR_TOK_ZAR)
           RJMP OB_AV_1
OB_AV_4:   SBRC FL_AVR_ZAR,F_SET_MAKC 
           RJMP OB_AV_1
           SBRC FL_AVR_ZAR,F_SET_MIN
           RJMP OB_AV_1
           SBRC FL_AVR_ZAR,F_AVR_OBM_ZAR
           RJMP OB_AV_3
           SBRS FL_TR_RAB_ZAR,F_TR_RAB_ZAR
           RJMP OB_AV_3
           RJMP OB_AV_2
OB_AV_1:   CBR  FL_SIS_ZAR,(1<<F_VKL_SIL)
           CBI  PORTB,SILA
OB_AV_3:   LDI  A,5
           STS  VR_START,A
           CBR  FL_SIS_ZAR,(1<<F_START)
           SBR  FL_SIS_ZAR,(1<<F_NACL)
           RJMP ROB_AV
OB_AV_2:   LDS  A,VR_START
           CPI  A,1
	       BRNE OB_AV_9
           SBR  FL_SIS_ZAR,(1<<F_VKL_SIL)
           SBI  PORTB,SILA
           RJMP ROB_AV
OB_AV_9:   TST  A
	       BRNE ROB_AV
           SBR  FL_SIS_ZAR,(1<<F_START)
ROB_AV:    RET


OBR_V_SET: LDS  A,VR_VLT_SET
           TST  A
	       BRNE OB_VS_1
           SBR  FL_AVR_ZAR,(1<<F_SET_MIN)
           CBR  FL_AVR_ZAR,(1<<F_SET_MAKC)
	       CLR  A
	       STS  VLT_SET,A
           RJMP ROB_3V
OB_VS_1:   DEC  A
           STS  VR_VLT_SET,A
           SBRC FL_AVR_ZAR,F_SET_MIN
           RJMP OB_3V_1
           SBRS FL_AVR_ZAR,F_SET_MAKC
           RJMP OB_3V_2
OB_3V_1:   LDS  A,Z_VLT_SET_MIN
           LDI  B,3
           ADD  A,B
           LDS  B,VLT_SET
           CP   B,A
	       BRCS ROB_3VD
           LDS  A,Z_VLT_SET_MAKC
           SUBI A,1
           LDS  B,VLT_SET
           CP   B,A
	       BRCC ROB_3V
           LDS  A,VR_K_SET
           CPI  A,5
	       BRCS OB_3V_3
           CBR  FL_AVR_ZAR,(1<<F_SET_MAKC)
           CBR  FL_AVR_ZAR,(1<<F_SET_MIN)
ROB_3VD:   RJMP ROB_3V
OB_3V_3:   INC  A
           STS  VR_K_SET,A
           RJMP ROB_3V
OB_3V_2:   LDS  A,VLT_SET
           LDS  B,Z_VLT_SET_MAKC
           CP   A,B
           BRCS OB_3V_4
           LDS  A,VR_K_SET
           TST  A
	       BREQ OB_3V_5
           DEC  A
           STS  VR_K_SET,A
           RJMP ROB_3V
OB_3V_5:   SBR  FL_AVR_ZAR,(1<<F_SET_MAKC)
           RJMP ROB_3V
OB_3V_4:   LDS  B,Z_VLT_SET_MIN
           CP   A,B
           BRCC OB_3V_9
           SBR  FL_SIS_ZAR,(1<<F_SET_OGR_TOK)
           LDS  A,VR_K_SET
           TST  A
           BREQ OB_3V_8
           DEC  A
           STS  VR_K_SET,A
           RJMP ROB_3V
OB_3V_8:   SBR  FL_AVR_ZAR,(1<<F_SET_MIN)
           RJMP ROB_3V
OB_3V_9:   LDS  A,Z_VLT_SET_MIN
           LDI  B,K_SET_OGR_TOK
           ADD  A,B
           LDS  B,VLT_SET
           CP   B,A
           BRCC OB_3V_10
           SBR  FL_SIS_ZAR,(1<<F_SET_OGR_TOK)
           RJMP OB_3V_7
OB_3V_10:  CBR  FL_SIS_ZAR,(1<<F_SET_OGR_TOK)
OB_3V_7:   LDI  A,5
           STS  VR_K_SET,A
ROB_3V:    RET


OBR_IND:    LDS A,VR_PODG_STAPT
            TST A
	        BRNE OBR_IND_5
            SBRS FL_AVR_ZAR,F_AVR_TOK_ZAR
            RJMP OBR_IND6
            LDI A,2
            STS  LED_IMPL,A
            RJMP OBR_IND_5
OBR_IND6:   SBRS FL_AVR_ZAR,F_AVR_OBM_ZAR
            RJMP OBR_IND7
            LDI A,3
            STS  LED_IMPL,A
            RJMP OBR_IND_5
OBR_IND7:   SBRS FL_AVR_ZAR,F_AVR_SM_OBM_ZAR
            RJMP OBR_IND9
            LDI A,4
            STS  LED_IMPL,A
            RJMP OBR_IND_5
OBR_IND9:   ;SBRS FL_AVR_ZAR,F_AVR_TERM_ZAR
           ; RJMP OBR_IND10
           ; LDI A,5
           ; STS  LED_IMPL,A
           ; RJMP OBR_IND_5
OBR_IND10:  SBRS FL_AVR_ZAR,F_SET_MAKC
            RJMP OBR_IND11
            LDI A,6
            STS  LED_IMPL,A
            RJMP OBR_IND_5
OBR_IND11:  SBRS FL_AVR_ZAR,F_SET_MIN
            RJMP OBR_IND_5
            LDI A,7
            STS  LED_IMPL,A
OBR_IND_5:  LDS A,SHIM_IND
            CPI A,1
            BRNE OBR_IND1
	        ;SBI PORTB,LED
            RJMP OBR_IND2
OBR_IND1:   CPI A,6
            BRNE OBR_IND2
            LDS A,KOL_IMP_IND
            CPI A,0
            BRNE OBR_IND3
            LDS A,PAYZA_IND
            CPI A,0
            BRNE OBR_IND4
	        ;LDS A,TERM_ZAR      ;----------------------
	        LDS A,LED_IMPL
            STS  KOL_IMP_IND,A
            RJMP R_OBR_IND
OBR_IND4:   DEC A
            STS PAYZA_IND,A
            RJMP R_OBR_IND
OBR_IND3:   DEC A
            STS KOL_IMP_IND,A
	        LDI A,0
            STS SHIM_IND,A
	        ;CBI PORTB,LED
	        LDI A,10
            STS  PAYZA_IND,A
            RJMP R_OBR_IND
OBR_IND2:   INC A
            STS SHIM_IND,A
R_OBR_IND:  RET


ADC0:    push A           ; 
         in A,SREG
         push A
         push B
         LDS   B,ADCL
         LDS   DAN_ADCH,ADCH
         MOV   A,YK_TKT_ADC
         TST   A
	     BRNE  ADC_1
	     LDS   A,ADMUX            ;   D_SET
	     CBR   A,0B00001111
	     SBR   A,0B00000011
	     STS   ADMUX,A
	     LDS   A,ADCSRA
         SBR   A,(1<<ADSC)
	     STS   ADCSRA,A
         RCALL STAB_12V
         INC   YK_TKT_ADC
         RJMP  RADC
ADC_1:   CPI   A,1
	     BRNE  ADC_2
         LDS   A,ADMUX           ;  TOK ZAR
	     CBR   A,0B00001111
	     STS   ADMUX,A
	     LDS   A,ADCSRA
         SBR   A,(1<<ADSC)
	     STS   ADCSRA,A
         RCALL OBR_VLT_SET
         INC   YK_TKT_ADC
         RJMP  RADC
ADC_2:   CPI   A,2
	     BRNE  ADC_3
         LDS   A,ADMUX           ;  TOK AKM
	     CBR   A,0B00001111
	     SBR   A,0B00000100
	     STS   ADMUX,A
	     LDS   A,ADCSRA
         SBR   A,(1<<ADSC)
	     STS   ADCSRA,A
	     MOV   TOK_ZAR,DAN_ADCH
         RCALL OBR_INTG_TOK_ZAR 
         INC   YK_TKT_ADC
         RJMP  RADC

ADC_3:   CPI   A,3
	     BRNE  ADC_4
         LDS   A,ADMUX           ;   12V
	     CBR   A,0B00001111
	     SBR   A,0B00000101
	     STS   ADMUX,A
	     LDS   A,ADCSRA
         SBR   A,(1<<ADSC)
	     STS   ADCSRA,A
         RCALL OBR_TOK_AKM_ZAR
         INC   YK_TKT_ADC
         RJMP  RADC

ADC_4:   CPI   A,4
	     BRNE  ADC_5
         LDS   A,ADMUX           ;   TERM
	     CBR   A,0B00001111
	     SBR   A,0B00000010
	     STS   ADMUX,A
	     LDS   A,ADCSRA
         SBR   A,(1<<ADSC)
	     STS   ADCSRA,A
         RCALL STAB_12V
         INC   YK_TKT_ADC
         RJMP  RADC

ADC_5:   CPI   A,5
	     BRNE  ADC_6
         LDS   A,ADMUX           ;  TOK ZAR
	     CBR   A,0B00001111
	     STS   ADMUX,A
	     LDS   A,ADCSRA
         SBR   A,(1<<ADSC)
	     STS   ADCSRA,A
         MOV   A,DAN_ADCH
	     COM   A
         STS   TERM_ZAR,A
         RCALL INTG_VLT_ZAR_IND
         INC   YK_TKT_ADC
         RJMP  RADC

ADC_6:   CPI   A,6
	     BRNE  ADC_7
         LDS   A,ADMUX           ;  TOK AKM
	     CBR   A,0B00001111
	     SBR   A,0B00000100
	     STS   ADMUX,A
	     LDS   A,ADCSRA
         SBR   A,(1<<ADSC)
	     STS   ADCSRA,A
	     MOV   TOK_ZAR,DAN_ADCH
         RCALL OBR_INTG_TOK_ZAR 
         INC   YK_TKT_ADC
         RJMP  RADC

ADC_7:   LDS   A,ADMUX            ;   12V
	     CBR   A,0B00001111
	     SBR   A,0B00000101
	     STS   ADMUX,A
	     LDS   A,ADCSRA
         SBR   A,(1<<ADSC)
	     STS   ADCSRA,A
         RCALL OBR_TOK_AKM_ZAR
         LDI   A,0
         MOV   YK_TKT_ADC,A
         TST   KONT_PRX_PROG
	     BRNE  ADC_9
         CBI   DDRB,MOST_H
         CBI   DDRB,MOST_L
         JMP   NACZALO
ADC_9:   DEC   KONT_PRX_PROG
RADC:    POP B
         POP A
         OUT SREG,A
         POP A
         RETI




OBR_VLT_SET:
          PUSH XH
          PUSH XL
          LDS   XL,SUM_VLT_SET_L
          LDS   XH,SUM_VLT_SET_H
          MOV   A,DAN_ADCH
          CPI   A,K_0_VLT_SET      ;132
          BRCC  OB_VLS_2
          CBI   PORTB,LED   ;-------------------------
          RJMP  ROB_VLS
OB_VLS_2: SBI   PORTB,LED   ;-------------------------
          LDI   A,10
	      STS   VR_VLT_SET,A
          LDS   A,KL_VLT_SET
	      INC   A
          STS   KL_VLT_SET,A
	      CPI   A,255
          BRNE  OB_VLS_1
          LDS   A,SUM_VLT_SET_H
          RCALL INTG_VLT_SET
	      CLR   A
	      STS   SUM_VLT_SET_H,A
	      STS   SUM_VLT_SET_L,A
          RJMP  ROB_VLS
OB_VLS_1: MOV   A,DAN_ADCH
          LSL   B
          ROL   A 
          LSL   B
          ROL   A 
          ;STS   REZ1_ZAR,A          ;--------59H
          ADD   XL,A
          CLR   A
	      ADC   XH,A
          STS   SUM_VLT_SET_H,XH
          STS   SUM_VLT_SET_L,XL
ROB_VLS:  POP  XL
          POP  XH
          RET

INTG_VLT_SET:
         PUSH XL
         PUSH XH
         PUSH B
         LDI  B,3                        ;KOL OTCZETOV
         LDS  XL,SUM_INTG_VLT_SET_L
         LDS  XH,SUM_INTG_VLT_SET_H
         RCALL INTG
	     STS  SUM_INTG_VLT_SET_L,XL
	     STS  SUM_INTG_VLT_SET_H,XH
	     STS  VLT_SET,A
         POP  B
         POP  XH
         POP  XL
         RET


OBR_TOK_AKM_ZAR:
         NEG   DAN_ADCH
         SBRS  FL_TR_RAB_ZAR,F_TR_UST_ZAR
         RJMP  OTAZ_3
         MOV   KN_0_TOK_AKM_ZAR,DAN_ADCH
OTAZ_3:  SUB   DAN_ADCH,KN_0_TOK_AKM_ZAR
		 BRCC  OTAZ_1
         CLR   TOK_AKM_ZAR
         RJMP  OTAZ_2
OTAZ_1:  MOV   TOK_AKM_ZAR,DAN_ADCH
OTAZ_2:  SBR   FL_SIS_ZAR,(1<<F_REZ_TOK_AKM)
         RET

;OBR_INTG_TOK_AKM_ZAR:
         PUSH A
         PUSH B
         PUSH XH
         PUSH XL
         MOV  A,TOK_AKM_ZAR
         LDI  B,1                         ;5 KOL OTCZETOV
         LDS  XL,SUM_INTG_TOK_AKM_L
         LDS  XH,SUM_INTG_TOK_AKM_H
         RCALL INTG
	     STS  SUM_INTG_TOK_AKM_L,XL
	     STS  SUM_INTG_TOK_AKM_H,XH
        ; MOV  INTG_TOK_AKM_ZAR,A
         POP  XL
         POP  XH
         POP  B
         POP  A
         RET


OBR_INTG_TOK_ZAR:
         PUSH A
         PUSH B
         PUSH XH
         PUSH XL
         SBRS  FL_TR_RAB_ZAR,F_TR_UST_ZAR
         RJMP  OITZ_1
         MOV   KN_0_TOK_ZAR,TOK_ZAR
OITZ_1:  MOV   A,TOK_ZAR
         LDI   B,8                  ;KOL OTCZETOV
         LDS   XL,SUM_INTG_TOK_ZAR_L
         LDS   XH,SUM_INTG_TOK_ZAR_H
         RCALL INTG
	     STS   SUM_INTG_TOK_ZAR_L,XL
	     STS   SUM_INTG_TOK_ZAR_H,XH
	     STS   INTG_TOK_ZAR,A
RITG_T:  POP  XL
         POP  XH
         POP  B
         POP  A
         RET



STAB_12V:
         MOV   VLT_ZAR,DAN_ADCH
         SBRC  FL_AVR_ZAR,F_AVR_OBM_ZAR
         RJMP  ST_V_1
         SBRC  FL_AVR_ZAR,F_AVR_SM_OBM_ZAR
         RJMP  ST_V_1
         SBRC  FL_AVR_ZAR,F_AVR_TOK_ZAR
         RJMP  ST_V_1
         SBRC  FL_SIS_ZAR,F_START
         RJMP  ST_V_2
ST_V_1:  CBI   DDRB,MOST_H
         CBI   DDRB,MOST_L
         LDI   DL_SHIM,K_MIN_DL_SHIM
		 RJMP  ST_V_8
ST_V_2:  MOV   A,TOK_AKM_ZAR
		 SUB   A,Z_TOK_AKM
		 BRCS  ST_V_4
		 BREQ  ST_V_4
         CBR   FL_SIS_ZAR,(1<<F_NACL)
         CPI   DL_SHIM,K_MIN_DL_SHIM
         BREQ  ST_V_8D
         BRCS  ST_V_8D
         MOV   B,Z_PI_OGR_TOK_AKM
         RCALL DELEN
         TST   A
	     BRNE  ST_V_19
         DEC   DL_SHIM
ST_V_8D: RJMP  ST_V_8
ST_V_19: MOV   B,DL_SHIM
		 SUB   B,A
		 BRCS  ST_V_26
		 CPI   B,K_MIN_DL_SHIM
		 BRCS  ST_V_26
		 MOV   DL_SHIM,B
		 RJMP  ST_V_8
ST_V_26: LDI   DL_SHIM,K_MIN_DL_SHIM
 		 RJMP  ST_V_8
ST_V_4:  MOV   A,Z_VLT_ZAR 
         SUB   A,VLT_ZAR
         BREQ  ST_V_8
         BRCC  ST_V_20
         CBR   FL_SIS_ZAR,(1<<F_NACL)
         CPI   DL_SHIM,K_MIN_DL_SHIM
         BREQ  ST_V_8
         BRCS  ST_V_8
         NEG   A
         MOV   B,Z_PI_L
         RCALL DELEN
         TST   A
	     BRNE  ST_V_6
         DEC   DL_SHIM
		 RJMP  ST_V_8
ST_V_6:  MOV   B,DL_SHIM
		 SUB   B,A
		 BRCS  ST_V_7
		 CPI   B,K_MIN_DL_SHIM
		 BRCS  ST_V_7
		 MOV   DL_SHIM,B
		 RJMP  ST_V_8
ST_V_7:  LDI   DL_SHIM,K_MIN_DL_SHIM
 		 RJMP  ST_V_8
ST_V_20: CPI   DL_SHIM,K_MAKC_DL_SHIM
         BRNE  ST_V_5
         CBR   FL_SIS_ZAR,(1<<F_NACL)
 		 RJMP  ST_V_8
ST_V_5:  SBRS  FL_SIS_ZAR,F_NACL
         RJMP  ST_V_9
         TST   NACL_VR_SHIM
		 BREQ  ST_V_10
         DEC   NACL_VR_SHIM
 		 RJMP  ST_V_8
ST_V_10: LDI   A,K_NACL_VR_SHIM
         MOV   NACL_VR_SHIM,A
         INC   DL_SHIM
		 RJMP  ST_V_8
ST_V_9:  MOV   B,Z_PI_H
         RCALL DELEN
         TST   A
		 BRNE  ST_V_21
         INC   DL_SHIM
		 RJMP  ST_V_8
ST_V_21: MOV   B,DL_SHIM
		 ADD   B,A
		 BRCS  ST_V_22
		 CPI   B,K_MAKC_DL_SHIM
		 BRCS  ST_V_23
ST_V_22: LDI   DL_SHIM,K_MAKC_DL_SHIM
		 RJMP  ST_V_8
ST_V_23: MOV   DL_SHIM,B
ST_V_8:  CPI   DL_SHIM,K_MIN_DL_SHIM
         BREQ  ST_V_24
         BRCS  ST_V_24
         SBI   DDRB,MOST_H
         SBI   DDRB,MOST_L
		 RJMP  ST_V_25
ST_V_24: CBI   DDRB,MOST_H
         CBI   DDRB,MOST_L
ST_V_25: LDI   B,20
 		 ADD   B,KN_0_TOK_ZAR
         MOV   A,TOK_ZAR
         SUB   A,B
		 BRCS  ST_V_11
		 BREQ  ST_V_11
         ;CBI   PORTB,LED   ;-------------------------
         LDI   A,250
         SUB   A,DL_SHIM
         STS   OCR1BL,A          ; B 1
         LDI   A,15
         ADD   A,DL_SHIM
         STS   OCR1AL,A          ; A 1
		 RJMP  RSTVL
ST_V_11: MOV   B,KN_0_TOK_ZAR
 		 SUBI  B,20
         MOV   A,TOK_ZAR
         SUB   A,B
		 BRCC  ST_V_12
		 BREQ  ST_V_12
         ;CBI   PORTB,LED   ;-------------------------
         LDI   A,240
         SUB   A,DL_SHIM
         STS   OCR1BL,A          ; B 1
         LDI   A,5
         ADD   A,DL_SHIM
         STS   OCR1AL,A          ; A 1
		 RJMP  RSTVL
ST_V_12: ;SBI   PORTB,LED   ;-------------------------
         LDI   A,250
         SUB   A,DL_SHIM
         STS   OCR1BL,A          ; B 1
         LDI   A,5
         ADD   A,DL_SHIM
         STS   OCR1AL,A          ; A 1
RSTVL:   RET



DELEN: 	PUSH C
        TST B
		BRNE d8u_17
        rjmp RD8u
d8u_17: sub	C,C
    	rol	A
    	rol	C
	    sub	C,B
    	brcc	d8u_1
     	add	C,B
        clc
        rjmp	d8u_2
d8u_1:	sec  
d8u_2:	rol	A	   	
     	rol	C	   
    	sub	C,B
    	brcc	d8u_3
    	add	C,B
        clc	
        rjmp	d8u_4
d8u_3:	sec	
d8u_4:	rol	A	
    	rol	C
    	sub	C,B
    	brcc	d8u_5
    	add	C,B
        clc	
        rjmp	d8u_6
d8u_5:	sec	
d8u_6:	rol	A	
    	rol	C
    	sub	C,B
    	brcc	d8u_7
    	add	C,B	
        clc
        rjmp	d8u_8
d8u_7:	sec
d8u_8:	rol	A
    	rol	C
    	sub	C,B
    	brcc	d8u_9
    	add	C,B
        clc
        rjmp	d8u_10
d8u_9:	sec
d8u_10:	rol	A
    	rol	C
    	sub	C,B
    	brcc	d8u_11
    	add	C,B
        clc
        rjmp	d8u_12
d8u_11:	sec	
d8u_12:	rol	A
    	rol	C
    	sub	C,B
    	brcc	d8u_13
	    add	C,B
        clc
        rjmp	d8u_14
d8u_13:	sec
d8u_14:	rol	A
    	rol	C
    	sub	C,B
    	brcc	d8u_15
    	add	C,B	
        clc
        rjmp	d8u_16
d8u_15:	sec
d8u_16:	rol	A
RD8u:   POP C
    	RET



;////////////////////////////////////////////////////////////
;VXOD   DAN    A   
;B      KOL_INTG
;XL     SUM_INTG_L
;XH     SUM_INTG_H
 
;VIXOD  DAN    A
;XL     SUM_INTG_L
;XH     SUM_INTG_H

INTG:     PUSH YL
          PUSH YH
          ADD XL,A
		  CLR A
		  ADC XH,A
		  BRCS  ING_2     ;PEREPOL
          MOV YL,XL
          MOV YH,XH   
ING_1:    LSR XH
          ROR XL
		  DEC B
		  BRNE ING_1 
          MOV A,XL 
          SUB YL,XL
		  CLR XL
		  SBC YH,XL
		  BRCS ING_3      ;PEREPOL
          MOV XL,YL
          MOV XH,YH
          RJMP RING
ING_2:    LDI XL,255
          LDI XH,255
		  LDI A,255
          RJMP RING
ING_3:    CLR XL
          CLR XH
		  CLR A
RING:     POP YH
          POP YL
          RET


TABLE:
.DB 0,0,2,0,6,30,0,0                   ;1
.DB 10,180,127,20,20,0,54,0B00000010   ;9
.DB 0,0,30,0,0,5,0,0                   ;17
.DB 0,0,0,0,0,0,0,0

KONS_100H:
.DB 5,0,0,0,0,0,0,0         ;100
.DB 100,50,20,0,60,0,0,0    ;108
.DB 0,2,0,0,0,0,0,0         ;110
.DB 0,2,3,1,8,0,0,0         ;118
.DB 0,0,0,0,0,0,0,0         ;120
.DB 0,0,2,5,30,0,0,0        ;128
.DB 0,0,0,0,0,0,0,0         ;130
.DB 0,0,0,0,0,0,0,0         ;138
