



       ;UPS2_12_330_FRM

.EQU ADCL=0x78   ;  . 
.EQU ADCH=0x79    ;  . 
.EQU ADCSRA=0x7A  ;  
.equ ADSC =6
.EQU ADMUX=0x7C   ;  
.equ ADLAR =5

.EQU PIND=0x09    ;  
.EQU DDRD=0x0A    ; 
.EQU PORTD=0x0B   ;  
;.equ  INT_0       =2
;.equ  BAT_12      =6

.EQU PINC=0x06    ;  
.EQU DDRC=0x07    ; 
.EQU PORTC=0x08   ;  

.EQU  PINB=0x03   ;  
.EQU  DDRB=0x04   ; 
.EQU  PORTB=0x05  ;  
.equ  LED          =0
.equ  MOST_H       =1
.equ  MOST_L       =2

.EQU WDTCSR=0x60   ; 
.equ   WDIF 	=7
.equ   WDIE 	=6
.equ   WDP3 	=5
.equ   WDCE 	=4
.equ   WDE   	=3
.equ   WDP2 	=2
.equ   WDP1 	=1
.equ   WDP0 	=0


.EQU TCCR2A=0xB0   ;  2
.EQU TCCR2B=0xB1
.EQU TCNT2=0xB2
.EQU OCR2A=0xB3    ;  2 
.EQU OCR2B=0xB4    ;  2 
.EQU ASSR=0xB6

.EQU TCCR1A=0x80   ;   1
.equ COM1B0  =4 
.equ COM1B1  =5 
.EQU TCCR1B=0x81   ;   1
.EQU TCNT1H=0x85
.EQU TCNT1L=0x84
.EQU OCR1AH=0x89   ;  1 .   
.EQU OCR1AL=0x88  
.EQU SH_MOST_H=0x88
.EQU OCR1BH=0x8B   ;  1 . 
.EQU OCR1BL=0x8A   ;  1 .  
.EQU SH_MOST_L=0x8A   
.EQU ICR1H=0x87   ;
.EQU ICR1L=0x86   ;

.EQU TCCR0A=0x44    ;   TC0
.EQU TCCR0B=0x45    ;   TC0
.EQU TCNT0=0x46     ; TC0

.EQU TIMSK0=0x6E    ;   
.EQU TIFR0=0x15
.EQU TIMSK1=0x6F    ;   
.EQU TIFR1=0x16

.EQU EICRA=0x69    ;  INT0
.equ ISC11   =3
.equ ISC10   =2
.equ ISC01   =1
.equ ISC00   =0

.EQU EIMSK=0x3D     ;   INT0
.equ INT1    =1
.equ INT0    =0


.EQU SPL=0x3D
.EQU SPH=0x3E
.EQU SREG=0x3F



.EQU UDR=0xC6     ; USART
.EQU UCSRA=0xC0   ; USART
.equ RXC   =7 
.equ TXC   =6 
.equ UDRE  =5
.equ FE    =4
.equ DOR   =3
.equ UPE   =2
.equ U2X   =1
.equ MPCM  =0

.EQU UCSRB=0xC1   ; USART
.equ RXCIE   =7 
.equ TXCIE   =6 
.equ UDRIE   =5
.equ RXEN    =4
.equ TXEN    =3
.equ UCSZ2   =2
.equ RXB8    =1
.equ TXB8    =0

.EQU UCSRC=0xC2   ; USART
.equ URSEL   =7 
.equ UMSEL   =6 

.EQU UBRRH=0xC5   ; USART
.EQU UBRRL=0xC4   ; USART


.def SUM_300V             =r3
.def YK_TKT_ADC           =r4
.def KONT_PRX_PROG        =r5
.def DAN_12V              =r6
.def DAN_300V             =r7
.def VR_SHM               =r8
.def Z_PI_VOLT            =r9
.def Z_VR_SHM             =r10 ;NO
.def PAUZ_OBM             =r11
.def KL_AVR_TOK_DC3       =r12
.def NACL_VR_SHIM         =r13
.def SYM_OBM              =r14
.def Z_VLT_OUT            =r15


.def  FL_SIS_DC3         =r16
.equ  F_NACL_DC3          =0
.equ  F_RAB_DC3           =1

.def  FL_AVR_DC3         =r17
.equ  F_AVR_TOK_DC3        =0
.equ  F_AVR_12V            =1
;.equ  F_AVR_TERM_DC3       =2
.equ  F_AVR_OBM_DC3        =3
.equ  F_AVR_SM_OBM_DC3     =4
.equ  F_FOT_AVR_DC3        =7

.def  FL_TR_RAB_DC3      =r18
.equ  F_TR_RAB_DC3      =0
.equ  F_TR_UST_DC3      =1
.equ  F_TR_RAB_AKM_DC3  =2


.def DAN_TOK              =r19
.def SHAG_OBM             =r20
.def DL_SHIM              =r21
.def DAN_ADCH             =r22


.def A  =r23
.def B  =r24
.def C  =r25
.def XL =r26
.def XH =r27
.def YL =r28 
.def YH =r29 
.def ZL =r30
.def ZH =r31



.EQU DEL_01CEK               =0x100
.EQU DEL_1CEK                =0x101
.EQU DEL_1MINYT              =0x102
.EQU DEL_1CZAS               =0x103
.EQU DEL_SUTOK               =0x104
.EQU VR_PODG_STAPT           =0x105
.EQU SHIM_IND                =0x106
.EQU KOL_IMP_IND             =0x107
.EQU PAYZA_IND               =0x108
.EQU VR_K_12V                =0x109
;.EQU VR_K_TEMP               =0x10A
.EQU VR_RAB_CKL              =0x10B
.EQU KOL_PEREZ               =0x10C
.EQU SHG_CKL_RAB             =0x10D
.EQU TERM_DC3                =0x10E
.EQU VR_K_OBM                =0x10F

.EQU BUF_OBM0                =0x110
.EQU BUF_OBM1                =0x111
.EQU BUF_OBM2                =0x112
.EQU BUF_OBM3                =0x113
.EQU BUF_OBM4                =0x114
.EQU BUF_OBM5                =0x115
.EQU BUF_OBM6                =0x116
.EQU BUF_OBM7                =0x117
.EQU BUF_OBM8                =0x118
.EQU BUF_OBM9                =0x119

.EQU LED_IMPL                =0x11B
.EQU INTG_TOK_AKM            =0x11C
.EQU IND_300V                =0x11D
.EQU SUM_INTG_TOK_IND_L      =0x11E
.EQU SUM_INTG_TOK_IND_H      =0x11F
.EQU SUM_INTG_VLT_IND_L      =0x120
.EQU SUM_INTG_VLT_IND_H      =0x121

.EQU  K_MAKC_DL_SHIM    =105   ;105
.EQU  K_MIN_DL_SHIM     =3

.EQU  K_SM_SH_KAN_B     =253
.EQU  K_SM_SH_KAN_A     =2

.EQU  K_MAKS_12V        =170  ;160=13.5V
.EQU  K_MIN_12V         =110  ;100=8.2V 110=9.2V 

.EQU  K_VR_PEREZ        =10   ;1SEK

.EQU  K_MAKS_TOK        =220  ;200
.EQU  K_NACL_VR_SHIM    =80



.ORG    0x000       
        rjmp  NACZALO
.ORG    0x001       
        rjmp  INT_0
.ORG    0x010
        rjmp  PEREP_TC0     ;  1MC
.ORG    0x012
        RJMP  RD_UART_DC_300V       ;  USART
;.ORG    0x014
 ;       RJMP  WR_UART_DC_300V       ;  USART
.ORG    0x015
        rjmp  ADC0          ;  28kc 
   

.ORG 0x030  
NACZALO:  CLI    
          ldi A,0B00111001     ;RECZIM  PORT B
          out DDRB,A      
          ldi A,0B00000000     ;DAN     PORT B
          out PORTB,A     
          ldi A,0B11111000     ;RECZIM  PORT D
          out DDRD,A 
          ldi A,0B00000111     ;DAN     PORT D
          out PORTD,A     
          ldi A,0B00010010     ;RECZIM  PORT C
          out DDRC,A 
          ldi A,0B00000000     ;DAN     PORT C
          out PORTC,A     
          ldi A,0               ;ZAGR STEKA
          out SPL,A
          ldi A,$04             ;ZAGR STEKA
          out SPH,A
          SBI PORTB,LED
          RCALL VREM_2C     ;==================

          ldi A,0
          STS TCNT1H,A          ;ZAGRUZ DAN TC1H
          ldi A,$FF
          STS TCNT1L,A          ;ZAGRUZ DAN TC1L
          ldi A,0B10110000      ;   1
          STS TCCR1A,A             
          ldi A,0B00010001      ;   1
          STS TCCR1B,A   
          ldi A,0               ;  
          STS ICR1H,A   
          ldi A,255               ;  
          STS ICR1L,A   
          ldi A,0               ; A 1
          STS OCR1AH,A  
          ldi A,10
          STS OCR1AL,A   
          ldi A,0               ; B 1
          STS OCR1BH,A  
          ldi A,245
          STS OCR1BL,A  
          LDS A,TIMSK1            ;TIMSK TC1
		  SBR A,0B00000000
          STS TIMSK1,A  		  
		   
		  ldi A,1               ;ZAGRUZ DAN TC0
          STS TCNT0,A 
		  ldi A,0B00000011      ;  0
          STS TCCR0A,A 
          LDS A,TIMSK0            ;TIMSK TC0
		  SBR A,0B00000001
          STS TIMSK0,A  	
		  LDI A,0B00000011
          STS TCCR0B,A  
		  	  
          ldi A,0B01100000      ; 
		  STS ADMUX,A
          ldi A,0B11001101
		  STS ADCSRA,A
          ;ldi A,0B00000011      ;   
		  ;out MCUCR,A
          ldi A,0B00011010      ;   
		  out TIFR0,A  
          SBI PORTB,LED
 
		  ldi A,0B00000010      ;  INT0
          STS EICRA,A 
		  ldi A,0B00000001      ;  INT0
          STS EIMSK,A 

          ldi  ZH,high(TABLE*2)   ;ZAGR REG 1-22 
          ldi  ZL,low(TABLE*2)
          ldi  YH,0               ;KUDA  R1
          ldi  YL,1 
          ldi  A,22               ;KOL-VO
ZAGR_REG: lpm
          st    Y+,r0
          adiw  ZL,1              ; +1
          dec   A
          brne  ZAGR_REG

NACZL2:   ldi ZH,high(KONS_100H*2)  ;ZAGR RAM 
          ldi ZL,low(KONS_100H*2)   ;100H-12FH
          ldi YH,01 
          ldi YL,$00
RD_K_1:   lpm
          st Y+,r0
          adiw ZL,1
          CPI YL,$30
	      BRNE RD_K_1

;TST_1:    LDI DAN_TOK,100
;          RCALL INTG_TOK_AKM
;          RJMP TST_1

          LDI A,0B00000000        ;ZAGRUZ  USART
		  STS UCSRA,A
          LDI A,0B10000110
		  STS UCSRC,A
          LDI A,0B10010100
		  STS UCSRB,A 
          LDI A,$01 
		  STS UBRRH,A 
          LDI A,$98
		  STS UBRRL,A 

          WDR                  ;RES STOR TAIM
          LDS A,WDTCSR         ;ZAG STOR TAIM
          SBR A,(1<<WDCE)|(1<<WDE)
          STS WDTCSR,A
          LDI A,(1<<WDE)|(1<<WDP1)  ;64  
          STS WDTCSR,A
          WDR                  ;RES STOR TAIM

          SEI                   ;  
          CBI PORTB,LED   ;===================

NACZL4:   NOP
          RJMP NACZL4


VREM_2C:   push A
           in A,SREG
           push A
           push B     
           push C
           LDI C,100
VREM3:     LDI A,255
VREM2:     LDI B,255
VREM1:     DEC B
           BRNE  VREM1
	       DEC A
           BRNE  VREM2
	       DEC C
           BRNE  VREM3
           POP C
           POP B
           POP A
           OUT SREG,A
           POP A
		   RET

INT_0:   PUSH A
         IN A,SREG
         PUSH A
		 SBI PORTB,LED
		 MOV A,KL_AVR_TOK_DC3
         CPI A,10
		 BREQ INT_0_1
         INC KL_AVR_TOK_DC3
         RJMP RINT_0
INT_0_1: SBR FL_AVR_DC3,(1<<F_AVR_TOK_DC3) 
RINT_0:  POP A
         OUT SREG,A
         POP A
         RETI


RD_UART_DC_300V:        ;  USART
            push A 
            in A,SREG
            push A
            push B
            LDS  B,UCSRB
            LDS  A,UDR
            SEI
            SBRS B,RXB8 
            RJMP RD_USR_1
            CPI  A,0B01000000
			BREQ RD_USR_2
            LDS  B,UCSRB
            CBR  B,(1<<TXEN) 
            STS  UCSRB,B
            CLR  SHAG_OBM
            RJMP RRD_USR
RD_USR_2:   LDI  SHAG_OBM,1
            LDI  XL,$10       ;ADR_BUF_OBM
            LDI  XH,$01 
            MOV  SYM_OBM,A
            RJMP RRD_USR
RD_USR_1:   TST  SHAG_OBM
            BREQ RRD_USR
            CPI  SHAG_OBM,1
            BREQ RD_USR_3
            CPI  SHAG_OBM,2
            BREQ RD_USR_3
            CPI  SHAG_OBM,3
            BREQ RD_USR_3
            CPI  SHAG_OBM,4
            BRNE RD_USR_4
RD_USR_3:   ADD  SYM_OBM,A
            ST   X+,A
            RJMP RD_USR_5
RD_USR_4:   CP   SYM_OBM,A
            BREQ RD_USR_6
            SBR  FL_AVR_DC3,(1<<F_AVR_SM_OBM_DC3)
            CLR  SHAG_OBM
            RJMP RRD_USR
RD_USR_6:   CBR  FL_AVR_DC3,(1<<F_AVR_SM_OBM_DC3)
            LDS  B,UCSRB
            SBR  B,(1<<TXEN) 
            STS  UCSRB,B
            RCALL OBR_BUF_OBM
            MOV  SYM_OBM,FL_AVR_DC3
        	STS  UDR,FL_AVR_DC3
            LDI  A,6
            MOV  PAUZ_OBM,A
RD_USR_5:   INC  SHAG_OBM
RRD_USR:    POP B
            POP A
            OUT SREG,A
            POP A
            RETI

OBR_BUF_OBM:
            LDI  XL,$10       ;ADR_BUF_OBM
            LDI  XH,$01 
            LD   FL_TR_RAB_DC3,X+
            LD   Z_VLT_OUT,X+
            LD   Z_PI_VOLT,X+
            LD   Z_VR_SHM,X+
            RET


WR_UART_DC_300V:
            push A         ; USART
            in   A,SREG
            push A
            CPI  SHAG_OBM,11
            BRNE WR_USR_1
            LDS  B,UCSRB
            CBR  B,(1<<TXEN) 
            STS  UCSRB,B
            CLR  SHAG_OBM
            CBR  FL_AVR_DC3,(1<<F_AVR_OBM_DC3) 
			LDI  A,40
			STS  VR_K_OBM,A
            RJMP RWR_USR
WR_USR_1:   CPI  SHAG_OBM,6
            BRNE WR_USR_2
        	MOV  A,FL_SIS_DC3
            RJMP WR_USR_3
WR_USR_2:   CPI  SHAG_OBM,7
            BRNE WR_USR_4
        	LDS  A,IND_300V
            RJMP WR_USR_3
WR_USR_4:   CPI  SHAG_OBM,8
            BRNE WR_USR_5
        	LDS  A,INTG_TOK_AKM
            RJMP WR_USR_3
WR_USR_5:   CPI  SHAG_OBM,9
            BRNE WR_USR_6
        	LDS  A,TERM_DC3 
WR_USR_3:   ADD  SYM_OBM,A
            RJMP WR_USR_7
WR_USR_6:   MOV  A,SYM_OBM  	
WR_USR_7:   STS  UDR,A
            INC  SHAG_OBM
            LDI  A,6
            MOV  PAUZ_OBM,A
RWR_USR:    LDS  A,UCSRA
            SBR  A,(1<<TXC) 
            STS  UCSRA,A
            POP  A
            OUT  SREG,A
            POP  A
            RET


CIKL_RAB:   SBRC FL_AVR_DC3,F_FOT_AVR_DC3
            RJMP CL_RAB_1
            SBRS FL_TR_RAB_DC3,F_TR_RAB_DC3
            RJMP CL_RAB_1
            SBRC FL_AVR_DC3,F_AVR_12V 
            RJMP CL_RAB_1
            SBRS FL_AVR_DC3,F_AVR_OBM_DC3
            RJMP CL_RAB_2
CL_RAB_1:   SBI  PORTB,LED         ;------------------------
            CBR  FL_SIS_DC3,(1<<F_RAB_DC3)
            SBR  FL_SIS_DC3,(1<<F_NACL_DC3)
            LDI  A,K_NACL_VR_SHIM
            MOV  NACL_VR_SHIM,A
            LDI  A,5
			STS  VR_RAB_CKL,A
            CLR  A
			STS  SHG_CKL_RAB,A
            RJMP RCKL_RAB
CL_RAB_2:   LDS  A,SHG_CKL_RAB
            TST  A
            BRNE CL_RAB_3
            LDS  A,VR_RAB_CKL
			TST  A
			BREQ CL_RAB_4
			DEC  A
			STS  VR_RAB_CKL,A
            RJMP RCKL_RAB
CL_RAB_4:   CBR  FL_AVR_DC3,(1<<F_AVR_TOK_DC3)
            CLR  KL_AVR_TOK_DC3
            SBR  FL_SIS_DC3,(1<<F_RAB_DC3)
            LDI  A,1
			STS  SHG_CKL_RAB,A
            RJMP RCKL_RAB
CL_RAB_3:   CPI  A,1
            BRNE RCKL_RAB
            SBRC FL_AVR_DC3,F_AVR_TOK_DC3
            RJMP CL_RAB_5
            TST  KL_AVR_TOK_DC3
            BREQ RCKL_RAB
            DEC  KL_AVR_TOK_DC3
            RJMP RCKL_RAB
CL_RAB_5:   LDS  A,KOL_PEREZ
			TST  A
			BRNE CL_RAB_6
            SBR  FL_AVR_DC3,(1<<F_FOT_AVR_DC3)
            RJMP RCKL_RAB
CL_RAB_6:   DEC  A
			STS  KOL_PEREZ,A
            CBR  FL_SIS_DC3,(1<<F_RAB_DC3)
            SBR  FL_SIS_DC3,(1<<F_NACL_DC3)
            LDI  A,K_NACL_VR_SHIM
            MOV  NACL_VR_SHIM,A
            LDI  A,5
			STS  VR_RAB_CKL,A
            CLR  A
			STS  SHG_CKL_RAB,A
RCKL_RAB:   RET


OBR_12V:  MOV  A,DAN_12V
          CPI  A,K_MAKS_12V
          BRCC OB_12V_1
          CPI  A,K_MIN_12V
          BRCS OB_12V_1
          LDS  A,VR_K_12V
          CPI  A,50
		  BREQ OB_12V_4
	      INC  A
		  STS  VR_K_12V,A 
          RJMP ROB_12V
OB_12V_4: CBR  FL_AVR_DC3,(1<<F_AVR_12V)
          RJMP ROB_12V
OB_12V_1: LDS  A,VR_K_12V
          TST  A
		  BREQ OB_12V_2
          DEC  A
		  STS  VR_K_12V,A
          RJMP ROB_12V
OB_12V_2: SBR  FL_AVR_DC3,(1<<F_AVR_12V)
ROB_12V:  RET


PEREP_TC0: SEI            ;1MC
           push B
           push A
           in A,SREG
           push A
           WDR                  ;RES STOR TAIMER
           LDI  A,43
		   MOV  KONT_PRX_PROG,A
           TST  PAUZ_OBM
		   BREQ DEL_7
		   DEC  PAUZ_OBM
           RJMP DEL_8
DEL_7:     LDS  A,UCSRA
           SBRS A,TXC 
           RJMP DEL_8
           RCALL WR_UART_DC_300V
DEL_8: 	   LDS  A,DEL_01CEK
           TST  A
	       BREQ DEL1
		   DEC  A
		   STS  DEL_01CEK,A
           RJMP R_DEL
DEL1:      LDI  A,97
           STS  DEL_01CEK,A
           RCALL OBR_01S
           LDS A,DEL_1CEK
           TST A
		   BREQ DEL2
		   DEC A
		   STS DEL_1CEK,A
           RJMP R_DEL
DEL2:      LDI A,9
		   STS DEL_1CEK,A
		   RCALL OBR_1SEK
           LDS A,DEL_1MINYT  
           TST A
		   BREQ DEL4
		   DEC A
		   STS DEL_1MINYT,A
           RJMP R_DEL
DEL4:      LDI A,60
		   STS DEL_1MINYT,A
           LDS A,DEL_1CZAS
           TST A
		   BREQ DEL5
		   DEC A
		   STS DEL_1CZAS,A
           RJMP R_DEL
DEL5:      LDI  A,60
		   STS  DEL_1CZAS,A
           LDS  A,KOL_PEREZ
		   TST  A
		   BREQ R_DEL
		   CPI  A,5
		   BRCC R_DEL
           INC  A
		   STS  KOL_PEREZ,A
R_DEL:     POP A
           OUT SREG,A
           POP A
           POP B
           RETI

OBR_01S:    LDS A,VR_K_OBM
            TST A
            BREQ OB_01S_1
            DEC A
			STS VR_K_OBM,A
			RJMP OB_01S_2
OB_01S_1:   SBR FL_AVR_DC3,(1<<F_AVR_OBM_DC3)
OB_01S_2:	RCALL OBR_12V
            RCALL OBR_IND
ROB_01S:    RET


OBR_INTG_TOK_AKM:
           PUSH XL
           PUSH XH
           PUSH B
           PUSH A
           MOV  A,DAN_TOK
           LDI  B,8            ; KOL OTCZETOV
           LDS  XL,SUM_INTG_TOK_IND_L
           LDS  XH,SUM_INTG_TOK_IND_H
           RCALL INTG
		   STS  SUM_INTG_TOK_IND_L,XL
	       STS  SUM_INTG_TOK_IND_H,XH
		   STS  INTG_TOK_AKM,A
RING_T_IN: POP A
           POP B
           POP XH
           POP XL
           RET


INTG_300V_IND:
           PUSH XL
           PUSH XH
           PUSH B
           PUSH A
           MOV A,SUM_300V
           LDI B,8            ;KOL OTCZETOV
           LDS XL,SUM_INTG_VLT_IND_L
           LDS XH,SUM_INTG_VLT_IND_H
           RCALL INTG
		   STS SUM_INTG_VLT_IND_L,XL
	       STS SUM_INTG_VLT_IND_H,XH
		   STS IND_300V,A
RING_V_IN: POP A
           POP B
           POP XH
           POP XL
           RET




;////////////////////////////////////////////////////////////
;VXOD   DAN    A   
;B      KOL_INTG
;XL     SUM_INTG_L
;XH     SUM_INTG_H
 
;VIXOD  DAN    A
;XL     SUM_INTG_L
;XH     SUM_INTG_H

INTG:     PUSH YL
          PUSH YH
          ADD XL,A
		  CLR A
		  ADC XH,A
		  BRCS  ING_2                ;PEREPOL
          MOV YL,XL
          MOV YH,XH   
ING_1:    LSR XH
          ROR XL
		  DEC B
		  BRNE ING_1 
          MOV A,XL 
          SUB YL,XL
		  CLR XL
		  SBC YH,XL
		  BRCS ING_3                ;PEREPOL
          MOV XL,YL
          MOV XH,YH
          RJMP RING
ING_2:    LDI XL,255
          LDI XH,255
		  LDI A,255
          RJMP RING
ING_3:    CLR XL
          CLR XH
		  CLR A
RING:     POP YH
          POP YL
          RET



OBR_1SEK:   RCALL CIKL_RAB
            LDS A,VR_PODG_STAPT
            TST A
		    BREQ OB_1S_1
            DEC A
            STS VR_PODG_STAPT,A
OB_1S_1:    ;LDS A,VR_PEREZ
           ; TST A
		   ; BREQ ROB_1S
           ; DEC A
           ; STS VR_PEREZ,A
ROB_1S:     RET



OBR_IND:    LDS A,VR_PODG_STAPT
            TST A
			BRNE OBR_IND_5
            SBRS FL_AVR_DC3,F_AVR_TOK_DC3
            RJMP OBR_IND_6
            LDI A,2
            STS  LED_IMPL,A
            RJMP OBR_IND_5
OBR_IND_6:  SBRS FL_AVR_DC3,F_AVR_OBM_DC3
            RJMP OBR_IND_7
            LDI A,3
            STS  LED_IMPL,A
            RJMP OBR_IND_5
OBR_IND_7:  SBRS FL_AVR_DC3,F_AVR_SM_OBM_DC3
            RJMP OBR_IND_8
            LDI A,4
            STS  LED_IMPL,A
            RJMP OBR_IND_5
OBR_IND_8:  ;SBRS FL_AVR_DC3,F_AVR_TERM_DC3
            ;RJMP OBR_IND_9
           ; LDI A,5
           ; STS  LED_IMPL,A
           ; RJMP OBR_IND_5
OBR_IND_9:  SBRS FL_AVR_DC3,F_AVR_12V
            RJMP OBR_IND_10
            LDI A,6
            STS  LED_IMPL,A
            RJMP OBR_IND_5
OBR_IND_10: SBRS FL_AVR_DC3,F_FOT_AVR_DC3 
            RJMP OBR_IND_11
            LDI A,7
            STS  LED_IMPL,A
            RJMP OBR_IND_5
OBR_IND_11: LDI A,1
            STS  LED_IMPL,A
OBR_IND_5:  LDS A,SHIM_IND
            CPI A,1
            BRNE OBR_IND1
			CBI PORTB,LED
            RJMP OBR_IND2
OBR_IND1:   CPI A,6
            BRNE OBR_IND2
            LDS A,KOL_IMP_IND
            CPI A,0
            BRNE OBR_IND3
            LDS A,PAYZA_IND
            CPI A,0
            BRNE OBR_IND4
			LDS A,LED_IMPL
            STS  KOL_IMP_IND,A
            RJMP R_OBR_IND
OBR_IND4:	DEC A
            STS PAYZA_IND,A
            RJMP R_OBR_IND
OBR_IND3:	DEC A
            STS KOL_IMP_IND,A
			LDI A,0
            STS SHIM_IND,A
			SBI PORTB,LED
			LDI A,10
            STS  PAYZA_IND,A
            RJMP R_OBR_IND
OBR_IND2:   INC A
            STS SHIM_IND,A
R_OBR_IND:  RET







ADC0:    push A           ; 
         in A,SREG
         push A
         push B
         TST KONT_PRX_PROG
		 BRNE ADC_6
         CBI DDRB,MOST_H
         CBI DDRB,MOST_L
         RCALL NACZALO
ADC_6:	 DEC KONT_PRX_PROG
         LDS DAN_ADCH,ADCH
         MOV A,YK_TKT_ADC
         TST A
		 BRNE ADC_1
		 LDS A,ADMUX              ;   TOK
		 CBR A,0B00001111
		 STS ADMUX,A
		 LDS A,ADCSRA
         SBR A,(1<<ADSC)
		 STS ADCSRA,A
         MOV A,DAN_ADCH
         STS TERM_DC3,A
         RCALL INTG_300V_IND
         INC YK_TKT_ADC
         RJMP RADC
ADC_1:   CPI A,1
		 BRNE ADC_2
		 LDS A,ADMUX           ;   300V
		 CBR A,0B00001111
		 SBR A,0B00000011
		 STS ADMUX,A
		 LDS A,ADCSRA
         SBR A,(1<<ADSC)
		 STS ADCSRA,A
         MOV DAN_TOK,DAN_ADCH 
         RCALL OBR_INTG_TOK_AKM
         INC YK_TKT_ADC
         RJMP RADC
ADC_2:   CPI   A,2
		 BRNE  ADC_3
         LDS   A,ADMUX             ;   12V
		 CBR   A,0B00001111
		 SBR   A,0B00000101
		 STS   ADMUX,A
		 LDS   A,ADCSRA
         SBR   A,(1<<ADSC)
		 STS   ADCSRA,A
         ADD   SUM_300V,DAN_ADCH
		 LSR   SUM_300V
         MOV   DAN_300V,DAN_ADCH
         RCALL STAB_300V
         INC   YK_TKT_ADC
         RJMP  RADC
ADC_3:   CPI   A,3
		 BRNE  ADC_4
		 LDS   A,ADMUX              ;   TOK
		 CBR   A,0B00001111
		 STS   ADMUX,A
		 LDS   A,ADCSRA
         SBR   A,(1<<ADSC)
		 STS   ADCSRA,A
         ADD   DAN_ADCH,DAN_12V
		 ROR   DAN_ADCH
		 MOV   DAN_12V,DAN_ADCH
         RCALL INTG_300V_IND
         INC   YK_TKT_ADC
         RJMP  RADC
ADC_4:   CPI   A,4
		 BRNE  ADC_5
		 LDS   A,ADMUX              ;   300V
		 CBR   A,0B00001111
		 SBR   A,0B00000011
		 STS   ADMUX,A
		 LDS   A,ADCSRA
         SBR   A,(1<<ADSC)
		 STS   ADCSRA,A
         MOV   DAN_TOK,DAN_ADCH 
         RCALL OBR_INTG_TOK_AKM
         INC   YK_TKT_ADC
         RJMP  RADC
ADC_5:   LDS   A,ADMUX              ;   TERM
		 CBR   A,0B00001111
		 SBR   A,0B00000010
		 STS   ADMUX,A
		 LDS   A,ADCSRA
         SBR   A,(1<<ADSC)
		 STS   ADCSRA,A
         ADD   SUM_300V,DAN_ADCH
		 LSR   SUM_300V
         MOV   DAN_300V,DAN_ADCH
         RCALL STAB_300V
         LDI   A,0
         MOV   YK_TKT_ADC,A
RADC:    POP B
         POP A
         OUT SREG,A
         POP A
         RETI


STAB_300V:
         SBRC  FL_AVR_DC3,F_AVR_TOK_DC3
         RJMP  ST_V_1
         SBRS  FL_SIS_DC3,F_RAB_DC3
         RJMP  ST_V_1
         MOV   A,DAN_300V
         CPI   A,15
		 BRCC  ST_V_2
ST_V_1:  CBI   DDRB,MOST_H
         CBI   DDRB,MOST_L
         LDI   DL_SHIM,K_MIN_DL_SHIM
		 RJMP  ST_V_8
ST_V_2:  SBRC  FL_TR_RAB_DC3,F_TR_RAB_AKM_DC3
         RJMP  ST_V_3
         CPI   DAN_TOK,K_MAKS_TOK
		 BRCS  ST_V_3
         CBR   FL_SIS_DC3,(1<<F_NACL_DC3)
         SBI   PORTB,LED        ;--------------------------
         CPI   DL_SHIM,K_MIN_DL_SHIM
         BREQ  RSTVL1
         BRCS  RSTVL1
         DEC   DL_SHIM
		 RJMP  ST_V_8
RSTVL1:	 RJMP  RSTVL
ST_V_3:  MOV   A,Z_VLT_OUT
         SUB   A,DAN_300V
         BRCC  ADC_12
         CBR   FL_SIS_DC3,(1<<F_NACL_DC3)
         CPI   DL_SHIM,K_MIN_DL_SHIM
         BREQ  RSTVL
         BRCS  RSTVL
         NEG   A
         MOV   B,Z_PI_VOLT
         RCALL DELEN
         TST   A
	     BRNE  ST_V_6
         DEC   DL_SHIM
		 RJMP  ST_V_8
ST_V_6:  MOV   B,DL_SHIM
		 SUB   B,A
		 BRCS  ST_V_7
		 CPI   B,K_MIN_DL_SHIM
		 BRCS  ST_V_7
		 MOV   DL_SHIM,B
		 RJMP  ST_V_8
ST_V_7:  LDI   DL_SHIM,K_MIN_DL_SHIM
 		 RJMP  ST_V_8
ADC_12:  CPI   DL_SHIM,K_MAKC_DL_SHIM
         BRNE  ST_V_5
         CBR   FL_SIS_DC3,(1<<F_NACL_DC3)
 		 RJMP  RSTVL
ST_V_5:  SBRS  FL_SIS_DC3,F_NACL_DC3
         RJMP  ST_V_9
         TST   NACL_VR_SHIM
		 BREQ  ST_V_10
         DEC   NACL_VR_SHIM
 		 RJMP  RSTVL
ST_V_10: LDI   A,K_NACL_VR_SHIM
         MOV   NACL_VR_SHIM,A
         INC   DL_SHIM
		 RJMP  ST_V_8
ST_V_9:  MOV   B,Z_PI_VOLT
         RCALL DELEN
         TST   A
		 BRNE  ADC_16
         INC   DL_SHIM
		 RJMP  ST_V_8
ADC_16:  MOV   B,DL_SHIM
		 ADD   B,A
		 BRCS  ADC_17
		 CPI   B,K_MAKC_DL_SHIM
		 BRCS  ADC_15
ADC_17:  LDI   DL_SHIM,K_MAKC_DL_SHIM
		 RJMP  ST_V_8
ADC_15:  MOV   DL_SHIM,B
ST_V_8:  CPI   DL_SHIM,K_MIN_DL_SHIM
         BREQ  ADC_20
         BRCS  ADC_20
         SBI   DDRB,MOST_H
         SBI   DDRB,MOST_L
		 RJMP  ADC_21
ADC_20:  CBI   DDRB,MOST_H
         CBI   DDRB,MOST_L
ADC_21:  LDI   A,K_SM_SH_KAN_A
         ADD   A,DL_SHIM
         STS   OCR1AL,A          ; A 1
         LDI   A,K_SM_SH_KAN_B
         SUB   A,DL_SHIM
         STS   OCR1BL,A          ; B 1
RSTVL:   RET

DELEN: 	PUSH C
        sub	C,C
    	rol	A
    	rol	C
	    sub	C,B
    	brcc	d8u_1
     	add	C,B
        clc
        rjmp	d8u_2
d8u_1:	sec  
d8u_2:	rol	A	   	
     	rol	C	   
    	sub	C,B
    	brcc	d8u_3
    	add	C,B
        clc	
        rjmp	d8u_4
d8u_3:	sec	
d8u_4:	rol	A	
    	rol	C
    	sub	C,B
    	brcc	d8u_5
    	add	C,B
        clc	
        rjmp	d8u_6
d8u_5:	sec	
d8u_6:	rol	A	
    	rol	C
    	sub	C,B
    	brcc	d8u_7
    	add	C,B	
        clc
        rjmp	d8u_8
d8u_7:	sec
d8u_8:	rol	A
    	rol	C
    	sub	C,B
    	brcc	d8u_9
    	add	C,B
        clc
        rjmp	d8u_10
d8u_9:	sec
d8u_10:	rol	A
    	rol	C
    	sub	C,B
    	brcc	d8u_11
    	add	C,B
        clc
        rjmp	d8u_12
d8u_11:	sec	
d8u_12:	rol	A
    	rol	C
    	sub	C,B
    	brcc	d8u_13
	    add	C,B
        clc
        rjmp	d8u_14
d8u_13:	sec
d8u_14:	rol	A
    	rol	C
    	sub	C,B
    	brcc	d8u_15
    	add	C,B	
        clc
        rjmp	d8u_16
d8u_15:	sec
d8u_16:	rol	A
        POP C
    	RET




TABLE:
.DB 0,0,30,0,50,0,0,1                       ;R1
.DB 1,3,2,0,50,0,50,0B00000001              ;R9
.DB 0,0B00000000,0,0,10,0,0,0               ;R17
.DB 0,0,0,0,0,0,0,0                         ;R25


KONS_100H:
.DB 0,0,0,0,0,5,0,0                ;100
.DB 0,20,0,0,5,0,0,40              ;108
.DB 0,0,0,0,0,0,0,0                ;110
.DB 0,0,0,1,0,0,0,0                ;118
.DB 1,1,1,1,3,0,0,0                ;120
.DB 1,40,0,0,0,2,10,0              ;128


