/*****************************************************
This program was produced by the
CodeWizardAVR V2.03.4 Standard
Automatic Program Generator
 Copyright 1998-2008 Pavel Haiduc, HP InfoTech s.r.l.
http://www.hpinfotech.com

Project : 
Version : 2.1
Date    : 19.04.2016
Author  : 
Company : 
Comments: 


Chip type           : ATmega328P/ATmega168P
Program type        : Application
Clock frequency     : 16,000000 MHz / 8Mhz

Memory model        : Small
External RAM size   : 0
Data Stack size     : 512
*****************************************************/


//#define M168P //ATmega168P
//#define C8MHZ  //8MHZ
//#define DLOCKEN // 


#ifdef M168P 
#include <mega168p.h>
#else
#include <mega328p.h>
#endif

#define M590_POWERPIN PORTB.0
#define M590_ONPIN PORTB.1
#define M590_SLEEPPIN PORTD.6


#define RELEY1PIN PORTB.2
#define RELEY2PIN PORTB.3
#define RELEY3PIN PORTB.4
#define RELEY4PIN PORTB.5

#define ALARMPIN PIND.7
#define IGNITION PIND.4
#define DOORPIN PIND.5

#define LEDPIN PORTC.2

#define DORLOCKPIN PINC.1           // 0  


#ifdef M168P 
#define RXFIFO_BUFFER_SIZE0 240
#define RXbufersize 200
#else
#define RXFIFO_BUFFER_SIZE0 512
#define RXbufersize 254
#endif

#define tmpbufsize 64


char RX_text[RXbufersize];
char RX_text_tmp[tmpbufsize];


bit alarmflag;
bit alarmsending;
bit lovbatsending;
bit lovlevelbat;

unsigned char  flag1sec;

unsigned int  count10min;
unsigned int  count1dey;
unsigned int  countalarmsend;
unsigned char countalarmdial;


char counter,netststus;
unsigned char uarttimeout;
unsigned char alarmimeout;

unsigned int adcdata;
float volt;
char voltstr[6]; 

unsigned char masterpass[5];
unsigned char userpass[5];
unsigned char alarmphone[13];
unsigned char ballanscomand[9];
unsigned char reley1command[7];
unsigned char reley1delay;
unsigned int reley1ontime;
unsigned int reley1counter;
unsigned char reley2command[7];
unsigned char reley2delay;
unsigned int reley2ontime;
unsigned int reley2counter;
unsigned char reley3command[7];
unsigned char reley3delay;
unsigned int reley3ontime;
unsigned int reley3counter;
unsigned char reley4command[7];
unsigned char reley4delay;
unsigned int reley4ontime;
unsigned int reley4counter;
unsigned char phone[13];

//#pragma warn-
unsigned char eeprom eemasterpass[5] ="WE32";
unsigned char eeprom eeuserpass[5] ="1234";
unsigned char eeprom eealarmphone[13] ="+70000000000" ;
unsigned char eeprom eeballanscomand[9] ="*100#";
unsigned char eeprom eereley1command[7] ="OPEN";
unsigned char eeprom eereley1delay=1;
unsigned char eeprom eereley2command[7] ="CLOSE";
unsigned char eeprom eereley2delay=1;
unsigned char eeprom eereley3command[7] ="HEAT";
unsigned char eeprom eereley3delay=240;
unsigned char eeprom eereley4command[7] ="CAM";
unsigned char eeprom eereley4delay=240;

const float voltdev =0.02685546875; // 1/25-devider(1k+24k)  1.1V/1024*25=0.02685546875
//#pragma warn+



// External Interrupt 1 service routine
interrupt [EXT_INT1] void ext_int1_isr(void)
{
//ALARM
    alarmflag=1;
}


#define RXB8 1
#define TXB8 0
#define UPE 2
#define OVR 3
#define FE 4
#define UDRE 5
#define RXC 7

#define FRAMING_ERROR (1<<FE)
#define PARITY_ERROR (1<<UPE)
#define DATA_OVERRUN (1<<OVR)
#define DATA_REGISTER_EMPTY (1<<UDRE)
#define RX_COMPLETE (1<<RXC)

// USART Receiver buffer

char rx_buffer0[RXFIFO_BUFFER_SIZE0];

#if RXFIFO_BUFFER_SIZE0<256
unsigned char rx_wr_index0,rx_rd_index0,rx_counter0;
#else
unsigned int rx_wr_index0,rx_rd_index0,rx_counter0;
#endif

// This flag is set on USART Receiver buffer overflow
bit rx_buffer_overflow0;

// USART Receiver interrupt service routine
interrupt [USART_RXC] void usart_rx_isr(void)
{
    char status,data;
    status=UCSR0A;
    data=UDR0;
    
    
    if ((status & (FRAMING_ERROR | PARITY_ERROR | DATA_OVERRUN))==0){
        rx_buffer0[rx_wr_index0]=data;
        if (++rx_wr_index0 == RXFIFO_BUFFER_SIZE0) rx_wr_index0=0;
        if (++rx_counter0 == RXFIFO_BUFFER_SIZE0){
            rx_counter0=0;
            rx_buffer_overflow0=1;
        };
    };
}

#ifndef _DEBUG_TERMINAL_IO_
// Get a character from the USART Receiver buffer
#define _ALTERNATE_GETCHAR_
#pragma used+
char getchar(void)
{
    char data;
    while (rx_counter0==0) {
        
        #asm("wdr")
    }; 
   
    data=rx_buffer0[rx_rd_index0];
    #asm("wdr")
    if (++rx_rd_index0 == RXFIFO_BUFFER_SIZE0) rx_rd_index0=0;
    #asm("cli")
    --rx_counter0;
    #asm("sei")
   
    #asm("wdr")
return data;
}
#pragma used-
#endif

 


// Timer 1 overflow interrupt service routine
interrupt [TIM1_OVF] void timer1_ovf_isr(void)
{
#ifdef C8MHZ  
    TCNT1H=0xE1;
    TCNT1L=0x7B; //1Hz for 8MHz
#else    
    TCNT1H=0xC2;
    TCNT1L=0xF7; //1Hz for 16MHz
#endif    
    if (uarttimeout>0)
        uarttimeout--;
    if (alarmimeout>0)
        alarmimeout--;

    if (reley1counter>0){reley1counter--; RELEY1PIN =1;} else  RELEY1PIN =0;
    if (reley2counter>0){reley2counter--; RELEY2PIN =1;} else  RELEY2PIN =0;
    if (reley3counter>0){reley3counter--; RELEY3PIN =1;} else  RELEY3PIN =0; 
    if (reley4counter>0){reley4counter--; RELEY4PIN =1;} else  RELEY4PIN =0;

    flag1sec=1;//1sec
        
}

#include <delay.h>


#define ADC_VREF_TYPE 0xC0

// Read the AD conversion result
unsigned int read_adc(void)
{
    ADMUX= 3 | (ADC_VREF_TYPE & 0xff);    //ADC3
    #asm("wdr")
    // Delay needed for the stabilization of the ADC input voltage
    delay_us(10);
    #asm("wdr")
    // Start the AD conversion
    ADCSRA|=0x40;
    // Wait for the AD conversion to complete
    while ((ADCSRA & 0x10)==0) { #asm("wdr") };
    ADCSRA|=0x10;
return ADCW;
}




void eeprom2var (void){
    unsigned char counter;
    counter=0;
    
    while (eemasterpass[counter]){
        masterpass[counter] = eemasterpass[counter];
        counter++;
        #asm("wdr")
    }    
    
    counter=0;
    while (eeuserpass[counter]){
        userpass[counter] = eeuserpass[counter];
        counter++;
        #asm("wdr")
    } 
 
    counter=0;
    while (eealarmphone[counter]){
        alarmphone[counter] = eealarmphone[counter];
        phone[counter] = eealarmphone[counter];
        counter++;
        #asm("wdr")
    }
    
    counter=0;
    while (eeballanscomand[counter]){
        ballanscomand[counter] = eeballanscomand[counter];
        counter++;
        #asm("wdr")
    }
    
    
    counter=0;
    while (eereley1command[counter]){
        reley1command[counter] = eereley1command[counter];
        counter++;
        #asm("wdr")
    }
    reley1delay=eereley1delay;
    #asm("wdr")
        
    counter=0;
    while (eereley2command[counter]){
        reley2command[counter] = eereley2command[counter];
        counter++;
        #asm("wdr")
    }
    reley2delay=eereley2delay;
    #asm("wdr")
    
    counter=0;
    while (eereley3command[counter]){
        reley3command[counter] = eereley3command[counter];
        counter++;
        #asm("wdr")
    }
    reley3delay=eereley3delay;
    #asm("wdr")    
    
    counter=0;
    while (eereley4command[counter]){
        reley4command[counter] = eereley4command[counter];
        counter++;
        #asm("wdr")
    }
    reley4delay=eereley4delay;
    #asm("wdr")
    
    
}

char uppchar(char s) {
    char o;
      if (s >= 'a' && s <= 'z') {
        #asm("wdr")
         o = s - 32;
      }else o=s;
      #asm("wdr")
    return o;      
}





void resetsistem(void){
  delay_ms(200);
  #asm("wdr")
  delay_ms(200);
  #asm("wdr") 
  M590_POWERPIN=0;
  delay_ms(200);
  #asm("wdr")
  delay_ms(200);
  #asm("wdr")
  delay_ms(200);
  #asm("wdr")
  delay_ms(200);
  #asm("wdr")
   delay_ms(200);
  #asm("wdr")
  delay_ms(200);
  #asm("wdr")
  delay_ms(200);
  #asm("wdr")
  delay_ms(200);
  #asm("wdr")
  WDTCSR=0x18; 
  WDTCSR=0x08; 
  #asm("wdr") 
  while(1); 

}

void clearFIFO(void)
{
    while (rx_counter0!=0) {
        #asm("wdr")
        if (++rx_rd_index0 == RXFIFO_BUFFER_SIZE0) rx_rd_index0=0;
        #asm("cli")
        --rx_counter0;
        #asm("sei")
    }
    #asm("cli")
    rx_buffer_overflow0=0;
    #asm("sei")
    #asm("wdr")
}

unsigned char getstring(char *readbuf, unsigned int lenbuf)
{
    char data;
    unsigned int count;
    count=0;
    delay_ms(100);
    #asm("wdr")
    #asm("cli")
    uarttimeout=30;//~30sec
    #asm("sei")
        while (count<=lenbuf-1){
                while (rx_counter0==0) {
                    #asm("wdr")
                    if (uarttimeout==0){    //  
                        readbuf[count]='\r';
                        count++;
                        readbuf[count]='\n';
                        count++;
                        readbuf[count]='\0';
                        return count;
                    }
                }; 
                data=rx_buffer0[rx_rd_index0];
                #asm("wdr")
                if (++rx_rd_index0 == RXFIFO_BUFFER_SIZE0) rx_rd_index0=0;
                #asm("cli")
                --rx_counter0;
                #asm("sei")
                
                readbuf[count]=data;
                #asm("wdr")
                if (count!=0)
                    if ((readbuf[count-1]=='\r')&&(data=='\n')) break;
                if (count==lenbuf-1){
                    readbuf[count-1]='\r';
                    readbuf[count]='\n';
                    count++;
                    readbuf[count]='\0';
                    #asm("wdr")
                    clearFIFO();
                    return count;
                }
                count++;
        };
        
        #asm("wdr")
        count++;
        readbuf[count]='\0';
    
    #asm("wdr")
return count;
}

#include <string.h>
#include <stdio.h>

unsigned char strtoup(char *readbuf){
     unsigned char count=0;
     char data;
     while (count<=strlen(readbuf)){
       data =readbuf[count];
       readbuf[count]=uppchar(data);
       count++;
     }
 return  count-1;
}

char ansvercmp(char *str1, char flash *str2){
    char len =strlenf(str2);
    char status=strncmpf(str1, str2,len);
    
return status;
} 

char okststusM590(void){
    char status=2;
        delay_ms(200);
        #asm("wdr")
        do{
            if (rx_counter0!=0) getstring(RX_text_tmp,tmpbufsize);
            else  status=0;
            #asm("wdr")
            if (ansvercmp(RX_text_tmp, "OK")==0) status=0;
            #asm("wdr")
            if (ansvercmp(RX_text_tmp, "ERROR")==0) status=1;
        }while (status==2);
        
return status;
}

char m590command(char flash *command){

    char status=2;
    printf(command);
    putchar('\r');
    putchar('\n');
    delay_ms(200);
     #asm("wdr")
     do{
            if (rx_counter0==0) {
                return 255;  //m590 not ansver
            }
            getstring(RX_text_tmp,tmpbufsize);
            #asm("wdr")
             if (ansvercmp(RX_text_tmp, "ERROR")==0) break;
    } while ((ansvercmp(RX_text_tmp, command)!=0)&&(ansvercmp(RX_text_tmp, "\r\n")!=0));//if ATE1 "AT\r\n",else ATE0 "\r\n"
    
    status=okststusM590();
    
    
return status;
}



char netstatusM590(void){
    char status=10;
    
    printf("AT+CREG?\r");
    putchar('\n');
    delay_ms(200);
     #asm("wdr")
    do{
            if (rx_counter0==0) {
                return 255;  //m590 not ansver
            }
            getstring(RX_text_tmp,tmpbufsize);
            #asm("wdr")
            if (ansvercmp(RX_text_tmp, "ERROR")==0) break;
    } while ((ansvercmp(RX_text_tmp, "AT+CREG?")!=0)&&(ansvercmp(RX_text_tmp, "\r\n")!=0));//if ATE1 "AT\r\n",else ATE0 "\r\n"
    do{
        getstring(RX_text_tmp,tmpbufsize);
        #asm("wdr")
        if (ansvercmp(RX_text_tmp, "ERROR")==0) break;
    } while (ansvercmp(RX_text_tmp, "+CREG:")!=0) ;
    if ((strstrf(RX_text_tmp,",0")!=NULL)) status=0;
    #asm("wdr")
    if ((strstrf(RX_text_tmp,",1")!=NULL)) status=1; //home net
    #asm("wdr")
    if ((strstrf(RX_text_tmp,",2")!=NULL)) status=2;
    #asm("wdr")
    if ((strstrf(RX_text_tmp,",3")!=NULL)) status=3;
    #asm("wdr")
    if ((strstrf(RX_text_tmp,",4")!=NULL)) status=4;
    #asm("wdr")
    if ((strstrf(RX_text_tmp,",5")!=NULL)) status=5; //rouming
    okststusM590();
return status;
}



#include <stdlib.h>

char m590init( void ){
    char status=2;
    
    
    
    LEDPIN=1;
    M590_POWERPIN=1;
    
    #asm("wdr")
    delay_ms(500);
    #asm("wdr")
    delay_ms(500);
    
    #asm("wdr")
    delay_ms(500);
    #asm("wdr")
    delay_ms(500);
    #asm("wdr")
    M590_ONPIN=1;
    do{
        getstring(RX_text_tmp,tmpbufsize);
    }while (ansvercmp(RX_text_tmp,"\r\n")!=0);// 
    
    
    getstring(RX_text_tmp,tmpbufsize);
    
    if (ansvercmp(RX_text_tmp,"MODEM:STARTUP")!=0) {   
        M590_POWERPIN=0;
        while(1){              //error modem
            LEDPIN=0;
            delay_ms(100);
            #asm("wdr")
            LEDPIN=1;
            delay_ms(100);
            #asm("wdr")
        };
    };   
    
    #asm("wdr")
    
    LEDPIN=1; 
 
    delay_ms(500);
    #asm("wdr")
    delay_ms(500);
    #asm("wdr")
    delay_ms(500);
    #asm("wdr")
    delay_ms(500);
    #asm("wdr")
    delay_ms(500);
    #asm("wdr")
    delay_ms(500);
    #asm("wdr") 
 
    M590_ONPIN=0;  //3 sec
    M590_SLEEPPIN=1;
    #asm("wdr") 

    
    do{
     getstring(RX_text_tmp,tmpbufsize);
    }while (ansvercmp(RX_text_tmp,"\r\n")!=0);// 
    getstring(RX_text_tmp,tmpbufsize);
    if (ansvercmp(RX_text_tmp,"+PBREADY")!=0) {
        M590_POWERPIN=0;   
        while(1){              //error SIM
            LEDPIN=0;
            delay_ms(400);
            #asm("wdr")
            LEDPIN=1;
            delay_ms(100);
            #asm("wdr")
        };
    };   
    
    LEDPIN=1;
    
    m590command("AT");
    delay_ms(200);
    #asm("wdr") 
    
    /*m590command("AT&F");
    delay_ms(200);
    #asm("wdr")*/ 
    
    m590command("ATE1");
    delay_ms(200);    
     #asm("wdr")
    m590command("AT+CLIP=0");
    delay_ms(200);    
     #asm("wdr")
   /* m590command("AT+CREG=1"); //      
    delay_ms(200);    
     #asm("wdr")
   */ 
    m590command("AT+CMGF=1");  // 
    delay_ms(200);    
     #asm("wdr")
  
    m590command("AT+CSCS=\"GSM\""); 
    delay_ms(200);    
     #asm("wdr")
    
    /*m590command("AT&W"); 
    delay_ms(200);    
     #asm("wdr")*/
    
    LEDPIN=0;
    while(1) {     //registration
        netststus=netstatusM590();
        if(netststus==1) break;
        if(netststus==5) break;
        LEDPIN=0;
        delay_ms(500);
        #asm("wdr")
        delay_ms(500);
        #asm("wdr")
        LEDPIN=1;
        delay_ms(500);
        #asm("wdr")
        delay_ms(500);
        #asm("wdr")
    };
    LEDPIN=1;
    
     m590command("AT+CNMI=2,2,0,0,0");      
    delay_ms(200);    
     #asm("wdr")
     
     m590command("AT+ENPWRSAVE=1"); //enable savemode
    delay_ms(200);    
     #asm("wdr")
    M590_SLEEPPIN=0;
    LEDPIN=0;
  
return status;
}

char alarmDial(void){
        char status=3;
        
        printf("ATD%s;\r",alarmphone);
        putchar('\n');
        #asm("wdr")
        do{
            getstring(RX_text_tmp,tmpbufsize);
            #asm("wdr")
            if (ansvercmp(RX_text_tmp, "ERROR")==0) break;
        }while ((ansvercmp(RX_text_tmp, "ATD")!=0)&&(ansvercmp(RX_text_tmp, "\r\n")!=0));
        delay_ms(200);
        #asm("wdr")
        if (okststusM590()==0)
            do{ 
               getstring(RX_text_tmp,tmpbufsize);
               if (ansvercmp(RX_text_tmp, "ERROR")==0) break; 
                #asm("wdr")
                if ((ansvercmp(RX_text_tmp,"CONNECT")==0)){
                    #asm("wdr")
                    delay_ms(200);
                    m590command("ATH");
                    status=0;
                }
                if ((ansvercmp(RX_text_tmp,"NO CARRIER")==0)){
                    #asm("wdr")
                    delay_ms(200);
                    m590command("ATH");
                    status=0;
                }
                if ((ansvercmp(RX_text_tmp,"BUSY")==0)){
                    #asm("wdr")
                    delay_ms(200);
                    m590command("ATH");
                    status=1;
                }
                if ((ansvercmp(RX_text_tmp,"NO ANSWER")==0)){
                    #asm("wdr")
                    delay_ms(200);
                    m590command("ATH");
                    status=1;
                }
            }while (status==3);
   
    
return status;
}

char alarmSMS(void){
        char status;
        
        printf("AT+CMGS=\"%s\"\r",alarmphone);
        putchar('\n');
        #asm("wdr")
                
        while (getchar()!='>'){#asm("wdr")};
        getchar();
        delay_ms(200);
        printf("ALARM: ");
        
        if (IGNITION) {
            printf("IGNITION ON!");
        }else if (!DOORPIN){
            printf("DOOR OPEN!");
        }else{
            printf("SHOCK! ");
            #ifdef  DLOCKEN
            if (!DORLOCKPIN){
                printf("DOOR UNLOCK ");
            }
            #asm("wdr")
            #endif
        }

        delay_ms(200);
        #asm("wdr")
        putchar(0x1A); //ctrl+Z
        putchar('\n');
        #asm("wdr")
        delay_ms(200);
        #asm("wdr")
        delay_ms(200);
        #asm("wdr")
        status=okststusM590();
        if (status==0) {
            alarmsending=1;
            countalarmsend=0;
        }
        
        
return status;
}

char statusSMS(void){
        char status=2;
        #asm("wdr")
        read_adc();
        adcdata=read_adc();
        #asm("wdr")
        volt = (float) adcdata * voltdev;
        #asm("wdr")
        ftoa(volt,1,voltstr);
        #asm("wdr")
        
        printf("AT+CMGS=\"%s\"\r",phone);
        putchar('\n');
  
        #asm("wdr")
        while (getchar()!='>'){#asm("wdr")};
        getchar();
        #asm("wdr")
        delay_ms(200);
        #asm("wdr")
        printf("STATUS: ");
        if (alarmflag){
            printf("ALLARM, ");
        }else{
            printf("NO ALLARM, ");
        } 
        #asm("wdr") 
        if (IGNITION) {
            printf("IGNITION ON, ");
        }else{
            printf("IGNITION OFF, ");
        }
        #asm("wdr")
        if (!DOORPIN){
            printf("DOOR OPEN, ");
        }else{
            printf("DOOR CLOSE, ");
        }
        #asm("wdr")
        
#ifdef  DLOCKEN
        if (DORLOCKPIN){
            printf("DOOR LOCK, ");
        }else{
            printf("DOOR UNLOCK, ");
        }
        #asm("wdr")
#endif
        printf("VOLTAGE: %sV", voltstr);
        #asm("wdr")
        delay_ms(200);
        #asm("wdr")
        putchar(0x1A); //ctrl+Z
        putchar('\n');
        #asm("wdr")
        delay_ms(200);
        #asm("wdr")
        delay_ms(200);
        #asm("wdr")
        status=okststusM590();
        
return status;
}

char statusSMSOK(void){
        char status=2;
        
        printf("AT+CMGS=\"%s\"\r",phone);
        putchar('\n');
  
        #asm("wdr")
        while (getchar()!='>'){#asm("wdr")};
        getchar();
        #asm("wdr")
        delay_ms(200);
        #asm("wdr")
        printf("COMMAND OK");
        delay_ms(100);
        #asm("wdr")
        putchar(0x1A); //ctrl+Z
        putchar('\n');
        #asm("wdr")
        delay_ms(200);
        #asm("wdr")
        delay_ms(200);
        #asm("wdr")
        status=okststusM590();
        
return status;
}


char billingSMS(void){
        
        char status=2;
        unsigned char count;
        char *ptr_to_ram;
        m590command("AT+CNMI=1,0,0,0,0");
        delay_ms(200);
        //m590command("AT+CSCS=\"UCS2\"");
        //delay_ms(200);        
        //printf("ATD%s;\r",ballanscomand);
        printf("AT+CUSD=1,\"%s\",15\r",ballanscomand);
                
        putchar('\n');
        delay_ms(200);
         
        #asm("wdr")
        status=2;
        /*do{
            getstring(RX_text_tmp,tmpbufsize);
            if (ansvercmp(RX_text_tmp, "ERROR")==0) break;
            #asm("wdr")
        }while ((ansvercmp(RX_text_tmp, "AT+CUSD")!=0)&&(ansvercmp(RX_text_tmp, "\r\n")!=0)); */ 
         
        do {
            getstring(RX_text,RXbufersize);
            if (ansvercmp(RX_text, "OK")==0) status=1;
            #asm("wdr")
            if (ansvercmp(RX_text, "ERROR")==0) status=1;
            #asm("wdr")
            if(ansvercmp(RX_text,"+CUSD:")==0) {
                status= okststusM590();
            }
        }while (status==2);
        m590command("AT+CNMI=2,2,0,0,0");
        delay_ms(200);
        #asm("wdr")
        if (status==0) {
        
            //ptr_to_ram=RX_text;
            strtok(RX_text,",");
            ptr_to_ram=  strtok(NULL,",");
            
                
            printf("AT+CMGS=\"%s\"\r",phone);
            putchar('\n');
            #asm("wdr")       
            while (getchar()!='>') {#asm("wdr")};
            getchar();
            #asm("wdr")
            delay_ms(200);
            #asm("wdr")
            printf("BILLING:%s",ptr_to_ram);
            #asm("wdr")
            delay_ms(100);
            #asm("wdr")
            putchar(0x1A); //ctrl+Z
            putchar('\n');
            
        
            #asm("wdr")
            delay_ms(200);
            #asm("wdr")
            status=okststusM590();
        };
        
        
        
return status;
}

char helpSMS(void){
        char status;
        printf("AT+CMGS=\"%s\"\r",phone);
        putchar('\n');
        
        #asm("wdr")        
        while (getchar()!='>'){#asm("wdr")};
        getchar();
        delay_ms(200);
        printf("HELP: ");
        #asm("wdr")
        printf("\"*pasw#STATUS\" ");
        #asm("wdr")
        printf("\"*pasw#BILLING\" ");
        #asm("wdr")
        printf("\"*pasw#BALANS\" ");
        #asm("wdr")
       // printf("\"*pasw#CLEARSMS\" ");
        #asm("wdr")
        printf("\"*pasw#RELEY\" ");
        #asm("wdr")
        printf("\"*pasw#RELEY:02\" ");
        #asm("wdr")
        printf("\"*pasw#RELEY:02M\" ");
        #asm("wdr")
        printf("RELEY: %s,",reley1command);
        #asm("wdr")
        printf("%s,",reley2command);
           #asm("wdr")
        printf("%s,",reley3command);
           #asm("wdr")
        printf("%s ",reley4command);
        //printf("\"*pasw#SETPASS:pasw\" ");
        //printf("\"*pasw#SETPHONE:+71234567890\" ");
        //printf("\"*pasw#SETBALANSCOM:*102#\" ");
        delay_ms(200);
        putchar(0x1A); //ctrl+Z
        putchar('\n');
        putchar('\r');
        putchar('\n');
        #asm("wdr")
        delay_ms(200);
        #asm("wdr")
        status=okststusM590();
        
return status;
}



void parseSMS(void){
    unsigned char counter=0;
   unsigned char counter1;
    char password[5];
    bit durflag;
    char *ptr_to_ram; 
    char *comand;
    char *argument;
    const char bilsimbols[]="*#0123456789";
    const char telsimbols[]="+0123456789";
    
               counter=0;
               counter1=0;
               #asm("wdr")
               do {
                if (RX_text[counter]=='"') break;
		         #asm("wdr")
                counter++;
               } while (counter<RXbufersize) ;
               counter++;
               do{
                    if (RX_text[counter]!='"'){ 
                        phone[counter1] = RX_text[counter];
                        counter1++;
                        counter++;
                        #asm("wdr")
                        if (counter1>12) break;
                    }else break ;
		            #asm("wdr")   
                    
               }while (counter<RXbufersize);
               phone[counter1]='\0';
               getstring(RX_text,RXbufersize); 
               clearFIFO();            
               #asm("wdr")
               if (RX_text[0]=='*'){
                    for (counter=0; counter<=3; counter++){
                        password[counter]=RX_text[counter+1];
                    }
                    password[4]=0;
                    #asm("wdr")
                    if ((strcmp(password,masterpass)==0)||(strcmp(password,userpass)==0)){
                        
                        counter=0;
                       
                        ptr_to_ram=RX_text;
			            #asm("wdr")
                        strtoup(ptr_to_ram);
                        ptr_to_ram+=6; //*PASS# 
                        
                        #asm("wdr")
                        if(ansvercmp(ptr_to_ram,"STATUS")==0){
                            statusSMS();
                        }else if(ansvercmp(ptr_to_ram,"BALANS")==0){
                            billingSMS();                        
                        }else if(ansvercmp(ptr_to_ram,"BILLING")==0){
                            billingSMS();
                        /*}else if(ansvercmp(ptr_to_ram,"CLEARSMS")==0){
                            m590command("AT+CMGD=1,4");*/
                        }else if(ansvercmp(ptr_to_ram,"HELP")==0){
                            helpSMS();
                        }else{
                            if (strstrf(ptr_to_ram,":")!=NULL){
                                comand=  strtok(ptr_to_ram,":");
                                argument=  strtok(NULL,":");
                                if(strcmpf(comand,"SETPASS")==0){
                                   // password setting
                                    for (counter=0; counter<=3; counter++){
                                        #asm("cli")
                                        eeuserpass[counter] = argument[counter];
                                        #asm("sei")
                                        #asm("wdr")
                                        userpass[counter] = argument[counter];
                                    }
                                    #asm("wdr")
                                    statusSMSOK();
                                }else if((strcmp(password,masterpass)==0)&&(strcmpf(comand,"SETPHONE")==0)){ //masrerpassword only
                                //}else if (strcmpf(comand,"SETPHONE")==0){
                                   // phone allarm setting
                                    durflag=0;
                                   
                                    if ((argument[0] == '+')||(argument[0] == '8')) durflag=1;
                                    #asm("wdr")
                                    while ((argument[counter]!='\r')&&(counter<12)){
                                        if (strchr(telsimbols,argument[counter])==NULL) {
                                            durflag=0;
                                            break;
                                        }
                                        #asm("wdr")
                                        counter++; 
                                    }
                                    counter=0;
                                    if (durflag>0){ 
                                            while ((argument[counter]!='\r')&&(counter<12)){
                                                #asm("cli")
                                                eealarmphone[counter] = argument[counter];
                                                #asm("sei")
                                                #asm("wdr")
                                                alarmphone[counter] = argument[counter];
                                                counter++;
                                            }
                                            alarmphone[counter]=0;
                                            eealarmphone[counter] =0;
                                            statusSMSOK();
                                    }
                                }else if((strcmp(password,masterpass)==0)&&(strcmpf(comand,"SETBALANSCOM")==0)){ //masrerpassword only
                                //}else if (strcmpf(comand,"SETBALANSCOM")==0){
                                   //    
                                    durflag=1;
                                    while ((argument[counter]!='\r')&&(counter<9)){
                                        if (strchr(bilsimbols,argument[counter])==NULL) {
                                            durflag=0;
                                            break;
                                        }
                                        #asm("wdr")
                                        counter++; 
                                    }
                                    #asm("wdr")
                                    counter=0;
                                    if (durflag==1){ 
                                            while ((argument[counter]!='\r')&&(counter<9)){
                                                #asm("cli")
                                                eeballanscomand[counter] = argument[counter];
                                                #asm("sei")
                                                #asm("wdr")
                                                ballanscomand[counter] = argument[counter];
                                                counter++;
                                            }
                                            eeballanscomand[counter] =0;
                                            ballanscomand[counter]=0;
                                            
                                            statusSMSOK();
                                    }    
                                }else if(strstr(comand,reley1command)!=NULL){
                                        reley1ontime=0;
                                        if ( (argument[0] >= '0') && (argument[0] <= '9') ){ 
                                            reley1ontime=argument[0]-'0';
                                            #asm("wdr") 
                                            if ( (argument[1] >= '0') && (argument[1] <= '9') ){
                                                reley1ontime*=10;
                                                #asm("wdr") 
                                                reley1ontime+=argument[1]-'0';
                                                #asm("wdr")
                                                if ( (argument[2] >= '0') && (argument[2] <= '9') ){
                                                    reley1ontime*=10;
                                                    #asm("wdr") 
                                                    reley1ontime+=argument[2]-'0';
                                                    #asm("wdr")
                                                }else if  (argument[2] == 'M')  
                                                    reley1ontime*=60;
                                                #asm("wdr")
                                            }else if  (argument[1] == 'M') { 
                                                reley1ontime*=60;
                                            };    
                                        };
                                        #asm("wdr") 
                                        if (reley1ontime>0){
                                            #asm("cli")
                                            reley1counter= reley1ontime;
                                            #asm("sei")
                                        }else{
                                            #asm("cli")
                                            reley1counter = reley1delay;
                                            #asm("sei")
                                        }
                                        #asm("wdr")     
                                }else if(strstr(comand,reley2command)!=NULL){
                                        reley1ontime=0;
                                        if ( (argument[0] >= '0') && (argument[0] <= '9') ){ 
                                            reley2ontime=argument[0]-'0';
                                            #asm("wdr") 
                                            if ( (argument[1] >= '0') && (argument[1] <= '9') ){
                                                reley2ontime*=10;
                                                #asm("wdr") 
                                                reley2ontime+=argument[1]-'0';
                                                #asm("wdr")
                                                if ( (argument[2] >= '0') && (argument[2] <= '9') ){
                                                    reley2ontime*=10;
                                                    #asm("wdr") 
                                                    reley2ontime+=argument[2]-'0';
                                                    #asm("wdr")
                                                }else if  (argument[2] == 'M')  
                                                    reley2ontime*=60;
                                                #asm("wdr")
                                            }else if  (argument[1] == 'M') { 
                                                reley2ontime*=60;
                                            };    
                                        };
                                        #asm("wdr") 
                                        if (reley2ontime>0){
                                            #asm("cli")
                                            reley2counter= reley2ontime;
                                            #asm("sei")
                                        }else{
                                            #asm("cli")
                                            reley2counter = reley2delay;
                                            #asm("sei")
                                        }
                                        #asm("wdr")     
                                }else if(strstr(comand,reley3command)!=NULL){
                                        reley3ontime=0;
                                        if ( (argument[0] >= '0') && (argument[0] <= '9') ){ 
                                            reley3ontime=argument[0]-'0';
                                            #asm("wdr") 
                                            if ( (argument[1] >= '0') && (argument[1] <= '9') ){
                                                reley3ontime*=10;
                                                #asm("wdr") 
                                                reley3ontime+=argument[1]-'0';
                                                #asm("wdr")
                                                if ( (argument[2] >= '0') && (argument[2] <= '9') ){
                                                    reley3ontime*=10;
                                                    #asm("wdr") 
                                                    reley3ontime+=argument[2]-'0';
                                                    #asm("wdr")
                                                }else if  (argument[2] == 'M')  
                                                    reley3ontime*=60;
                                                #asm("wdr")
                                            }else if  (argument[1] == 'M') { 
                                                reley3ontime*=60;
                                            };    
                                        };
                                        #asm("wdr") 
                                        if (reley3ontime>0){
                                            #asm("cli")
                                            reley3counter= reley3ontime;
                                            #asm("sei")
                                        }else{
                                            #asm("cli")
                                            reley3counter = reley3delay;
                                            #asm("sei")
                                        }
                                        #asm("wdr")
                                        statusSMSOK();     
                                }else if(strstr(comand,reley4command)!=NULL){
                                        reley4ontime=0;
                                        if ( (argument[0] >= '0') && (argument[0] <= '9') ){ 
                                            reley4ontime=argument[0]-'0';
                                            #asm("wdr") 
                                            if ( (argument[1] >= '0') && (argument[1] <= '9') ){
                                                reley4ontime*=10;
                                                #asm("wdr") 
                                                reley4ontime+=argument[1]-'0';
                                                #asm("wdr")
                                                if ( (argument[2] >= '0') && (argument[2] <= '9') ){
                                                    reley4ontime*=10;
                                                    #asm("wdr") 
                                                    reley4ontime+=argument[2]-'0';
                                                    #asm("wdr")
                                                }else if  (argument[2] == 'M')  
                                                    reley4ontime*=60;
                                                #asm("wdr")
                                            }else if  (argument[1] == 'M') { 
                                                reley4ontime*=60;
                                            };    
                                        };
                                        #asm("wdr") 
                                        if (reley4ontime>0){
                                            #asm("cli")
                                            reley4counter= reley4ontime;
                                            #asm("sei")
                                        }else{
                                            #asm("cli")
                                            reley4counter = reley4delay;
                                            #asm("sei")
                                        }
                                        #asm("wdr")
                                       statusSMSOK(); 
                                }
                            }else{
                                if(strstr(ptr_to_ram,reley1command)!=NULL){
                                    #asm("cli")
                                    reley1counter=reley1delay;
                                    #asm("sei")
                                }else if(strstr(ptr_to_ram,reley2command)!=NULL){
                                    #asm("cli")
                                    reley2counter=reley2delay;
                                    #asm("sei")
                                }else if(strstr(ptr_to_ram,reley3command)!=NULL){
                                    #asm("cli")
                                    reley3counter=reley3delay;
                                    #asm("sei")
                                }else if(strstr(ptr_to_ram,reley4command)!=NULL){
                                    #asm("cli")
                                    reley4counter=reley4delay;
                                    #asm("sei")
                                }
                            }
                        } 
                    }
               }
        #asm("wdr")
}

#include <sleep.h>


void main(void)
{
// Declare your local variables here

// Crystal Oscillator division factor: 1
#pragma optsize-
CLKPR=0x80;
CLKPR=0x00;
#ifdef _OPTIMIZE_SIZE_
#pragma optsize+
#endif

// Input/Output Ports initialization
// Port B initialization
// Func7=In Func6=In Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out 
// State7=T State6=T State5=0 State4=0 State3=0 State2=0 State1=0 State0=0 
PORTB=0x00;
DDRB=0x3F;


// Port C initialization
// Func6=In Func5=In Func4=In Func3=In Func2=Out Func1=Out Func0=Out 
// State6=T State5=T State4=T State3=T State2=0 State1=0 State0=0 
PORTC=0x00;
DDRC=0x07;

#ifdef DLOCKEN // 
DDRC=0x05;
#endif


// Port D initialization
// Func7=In Func6=Out Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State7=T State6=0 State5=T State4=T State3=T State2=T State1=T State0=T 
PORTD=0x00;
DDRD=0x40;

 /*

  //=================================
    M590_POWERPIN=1;
    
    #asm("wdr")
    delay_ms(500);
    #asm("wdr")
    delay_ms(500);
    
    #asm("wdr")
    delay_ms(500);
    #asm("wdr")
    delay_ms(500);
    #asm("wdr")
    M590_ONPIN=1; 
    
    
     
    while(1){
        // PORTB.5= PINC.1;
    }    
  //====================================

  */



// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: Timer 0 Stopped
// Mode: Normal top=FFh
// OC0A output: Disconnected
// OC0B output: Disconnected
TCCR0A=0x00;
TCCR0B=0x00;
TCNT0=0x00;
OCR0A=0x00;
OCR0B=0x00;

// Timer/Counter 1 initialization
// Clock source: System Clock
// Clock value: 15,625 kHz  (7,813 kHz for 8 MHz)
// Mode: Normal top=FFFFh
// OC1A output: Discon.
// OC1B output: Discon.
// Noise Canceler: Off
// Input Capture on Falling Edge
// Timer 1 Overflow Interrupt: On
// Input Capture Interrupt: Off
// Compare A Match Interrupt: Off
// Compare B Match Interrupt: Off
TCCR1A=0x00;
TCCR1B=0x05;

#ifdef C8MHZ  
    TCNT1H=0xE1;
    TCNT1L=0x7B; //1Hz for 8MHz
#else    
    TCNT1H=0xC2;
    TCNT1L=0xF7; //1Hz for 16MHz
#endif 



ICR1H=0x00;
ICR1L=0x00;
OCR1AH=0x00;
OCR1AL=0x00;
OCR1BH=0x00;
OCR1BL=0x00;

// Timer/Counter 2 initialization
// Clock source: System Clock
// Clock value: Timer 2 Stopped
// Mode: Normal top=FFh
// OC2A output: Disconnected
// OC2B output: Disconnected
ASSR=0x00;
TCCR2A=0x00;
TCCR2B=0x00;
TCNT2=0x00;
OCR2A=0x00;
OCR2B=0x00;

// External Interrupt(s) initialization
// INT0: Off
// INT1: On
// INT1 Mode: Rising Edge
// Interrupt on any change on pins PCINT0-7: Off
// Interrupt on any change on pins PCINT8-14: Off
// Interrupt on any change on pins PCINT16-23: Off
EICRA=0x0C;
EIMSK=0x02;
EIFR=0x02;
PCICR=0x00;





// Timer/Counter 0 Interrupt(s) initialization
TIMSK0=0x00;
// Timer/Counter 1 Interrupt(s) initialization
TIMSK1=0x01;
// Timer/Counter 2 Interrupt(s) initialization
TIMSK2=0x00;

// USART initialization
// Communication Parameters: 8 Data, 1 Stop, No Parity
// USART Receiver: On
// USART Transmitter: On
// USART0 Mode: Asynchronous
// USART Baud Rate: 9600
UCSR0A=0x00;
UCSR0B=0x98;
UCSR0C=0x06;
UBRR0H=0x00;
#ifdef C8MHZ 
    UBRR0L=0x33; //8MHz
#else
    UBRR0L=0x67; //16MHz
#endif


// Analog Comparator initialization
// Analog Comparator: Off
// Analog Comparator Input Capture by Timer/Counter 1: Off
ACSR=0x80;
ADCSRB=0x00;

// ADC initialization
// ADC Clock frequency: 125,000 kHz   (62,500  kHz for 8 MHz)

// ADC Voltage Reference: Int., cap. on AREF
// ADC Auto Trigger Source: Free Running
// Digital input buffers on ADC0: On, ADC1: On, ADC2: On, ADC3: On
// ADC4: On, ADC5: On
DIDR0=0x00;
ADMUX=ADC_VREF_TYPE & 0xff;
ADCSRA=0xA7;
ADCSRB&=0xF8;



// Watchdog Timer initialization
// Watchdog Timer Prescaler: OSC/1024k
// Watchdog Timer interrupt: Off
#pragma optsize-
#asm("wdr")
WDTCSR=0x39;
WDTCSR=0x29;
#ifdef _OPTIMIZE_SIZE_
#pragma optsize+
#endif

#asm("wdr")

// Global enable interrupts


            
RELEY1PIN =0;
RELEY2PIN=0; 
RELEY3PIN =0;
RELEY4PIN=0; 
       
reley1counter=0;
reley2counter=0;
reley3counter=0;
reley4counter=0;

#asm("wdr")        
eeprom2var();

#asm("sei")
m590init();
sleep_enable();
count10min=0;
count1dey=0;
alarmsending=0;
lovlevelbat=0;
lovbatsending=0;
#asm("cli")
alarmflag=0;
flag1sec=0;
#asm("sei")

while (1)
    {
      if (rx_counter0==0) idle();
      #asm("wdr")
      #asm("wdr")
      
      
      if (rx_buffer_overflow0==1) clearFIFO();
      #asm("wdr")
       
       if (alarmflag){
            
            LEDPIN=1;
            #asm("cli")
            alarmflag=0;
            alarmimeout=2; //3 sec
            #asm("sei")
            while (alarmimeout!=0){
                #asm("wdr")
            };
            
            if(ALARMPIN==1){
                clearFIFO(); 
                M590_SLEEPPIN=1;
                delay_ms(200);
                #asm("wdr")
                while(1) {
                    netststus=netstatusM590();
		            if (netststus==255) resetsistem();
                    if(netststus==1) break;
                    if(netststus==5) break;
                    LEDPIN=0;
                    delay_ms(500);
                    #asm("wdr")
                    delay_ms(500);
                    #asm("wdr")
                    LEDPIN=1;
                    delay_ms(500);
                    #asm("wdr")
                    delay_ms(500);
                    #asm("wdr")
                };
                #asm("wdr")
                
                LEDPIN=1;
                #asm("wdr")
                countalarmdial=2;
            
                do {
                    LEDPIN=1;
                    if (alarmDial()==0) break;
                    #asm("wdr")
                    countalarmdial--;
                    LEDPIN=0;
                }while (countalarmdial>0);
                
                if ((IGNITION==1)||(DOORPIN==0)) alarmsending=0;
                if (alarmsending==0){
                    alarmSMS();
                    #asm("wdr")
                }
                
                M590_SLEEPPIN=0;
                LEDPIN=0;
            }
            LEDPIN=0;
      }else if (rx_counter0!=0) {
        M590_SLEEPPIN=1;
        LEDPIN=1;
               
        getstring(RX_text,RXbufersize);
        
        if (ansvercmp(RX_text, "+CMT")==0){ //SMS
                parseSMS();
                #asm("wdr")
        }else if (ansvercmp(RX_text, "RING")==0){ //RING
            	m590command("ATH");
	        #asm("wdr")
        }; 
        
        delay_ms(200);
        LEDPIN=0;
        #asm("wdr")
        M590_SLEEPPIN=0;
      }else if (flag1sec){
            #asm("cli")
            flag1sec=0;
            #asm("sei")
            
            
            
           #asm("wdr")
           if  (count10min==600) {  //10min
                count10min=0;
               
                LEDPIN=1;
                #asm("wdr")
                M590_SLEEPPIN=1;
                delay_ms(200);
                #asm("wdr")
                delay_ms(200);
                #asm("wdr")
                delay_ms(200);
                #asm("wdr")
                delay_ms(200);
                #asm("wdr")
                
                if (m590command("AT")==255) resetsistem();
                if ((reley1counter==0)&&(reley2counter==0)&&(reley3counter==0)&&(reley4counter==0)) count1dey++;
                if (count1dey==144){  // - 
                    #asm("wdr")
                    //  
                    m590command("AT+CMGD=1,4");
                    resetsistem();
                } 
                #asm("wdr")
                if (IGNITION==0) {
                    adcdata=read_adc(); 
                    #asm("wdr")
                    volt = (float) adcdata * voltdev;
                    if (volt>11.7){ //bat <10%
                        lovbatsending=0;
                        lovlevelbat=0;
                    }else { 
                        if ((lovlevelbat==1)&&(lovbatsending==0)){
                            delay_ms(200);
                            #asm("wdr")
                            clearFIFO();
                            counter=0;
                            for (counter=0; counter<=strlen(alarmphone); counter++){
                                phone[counter] = alarmphone[counter];
                                #asm("wdr")
                            }
                            while(1) {
                                netststus=netstatusM590();
				                if (netststus==255) resetsistem();
                                if(netststus==1) break;
                                if(netststus==5) break;
                                LEDPIN=0;
                                delay_ms(500);
                                #asm("wdr")
                                delay_ms(500);
                                #asm("wdr")
                                LEDPIN=1;
                                delay_ms(500);
                                #asm("wdr")
                                delay_ms(500);
                                #asm("wdr")
                            };
                            statusSMS();
                            #asm("wdr")
                            lovbatsending=1;
                        }
                        lovlevelbat=1;
                    }
                }
                M590_SLEEPPIN=0;
                LEDPIN=0;
           } else count10min++;
          
           #asm("wdr")
           
           if (alarmsending==1){
                #asm("wdr")
                countalarmsend++;
                if  (countalarmsend>=180) { //3min
                countalarmsend=0;
                alarmsending=0;
                }
           }
           #asm("wdr")
      }
      #asm("wdr")
    };
}
