/*****************************************************************************
Group ASCII-code:
0: ANY - Different symbols
1: ACT - Actions symbols, like !#$%&*+-/<=>^|~
2: SRV - Service symbols, like :; (m... forget)
3: OCT - Numbers 0..7
4: HEX - Numbers 0..9 A..F
5: DEC - Numbers 0..9
6: TAG - Numbers 0..9, Letters A..Z
7: TAG - Letters a..z, "_" and "@"

Input:
[6:0] - ASCII-code
[9:7] - Currently active group
Output:
[5:0] - Processing code
[7:5] - New index of group

In the circuit the ADDR [9:7]
must be connected to DATA [7:5]
as loop through the flip-flop.
*****************************************************************************/
module
Rom2708(
        output [7:0] DATA,
        input  [9:0] ADDR
        );
wire [127:0] Data;
assign
Data = (//                        .0.1.2.3.4.5.6.7.8.9.A.B.C.D.E.F
        ADDR[9:4] == 6'o00 ? 128'h000102030405060708494A0B0C4D0E0F : // ANY
        ADDR[9:4] == 6'o01 ? 128'h101112131415161718191A4B1C1D1E1F :
        ADDR[9:4] == 6'o02 ? 128'h402152232425265758592A2B5C2D5E2F :
        ADDR[9:4] == 6'o03 ? 128'h60A1A2A3A4A5A6A7A8A95A5B2C292E5F :
        ADDR[9:4] == 6'o04 ? 128'hE0CACBCCCDCECFFBFCFDFEDBDCDDDEDF :
        ADDR[9:4] == 6'o05 ? 128'hD0D1D2D3D4D5D6D7D8D9DA545D5527FF :
        ADDR[9:4] == 6'o06 ? 128'h50E1E2E3E4E5E6E7E8E9EAEBECEDEEEF :
        ADDR[9:4] == 6'o07 ? 128'hF0F1F2F3F4F5F6F7F8F9FA532856224F :
        ADDR[9:4] == 6'o10 ? 128'h000102030405060708494A0B0C4D0E0F : // ACT
        ADDR[9:4] == 6'o11 ? 128'h101112131415161718191A4B1C1D1E1F :
        ADDR[9:4] == 6'o12 ? 128'h402152232425265758592A2B5C2D5E2F :
        ADDR[9:4] == 6'o13 ? 128'h60A1A2A3A4A5A6A7A8A95A5B2C292E5F :
        ADDR[9:4] == 6'o14 ? 128'hE0CACBCCCDCECFFBFCFDFEDBDCDDDEDF :
        ADDR[9:4] == 6'o15 ? 128'hD0D1D2D3D4D5D6D7D8D9DA545D5527FF :
        ADDR[9:4] == 6'o16 ? 128'h50E1E2E3E4E5E6E7E8E9EAEBECEDEEEF :
        ADDR[9:4] == 6'o17 ? 128'hF0F1F2F3F4F5F6F7F8F9FA532856224F :
        ADDR[9:4] == 6'o20 ? 128'h000102030405060708494A0B0C4D0E0F : // SRV
        ADDR[9:4] == 6'o21 ? 128'h101112131415161718191A4B1C1D1E1F :
        ADDR[9:4] == 6'o22 ? 128'h402152232425265758592A2B5C2D5E2F :
        ADDR[9:4] == 6'o23 ? 128'h60A1A2A3A4A5A6A7A8A95A5B2C292E5F :
        ADDR[9:4] == 6'o24 ? 128'hE0CACBCCCDCECFFBFCFDFEDBDCDDDEDF :
        ADDR[9:4] == 6'o25 ? 128'hD0D1D2D3D4D5D6D7D8D9DA545D5527FF :
        ADDR[9:4] == 6'o26 ? 128'h50E1E2E3E4E5E6E7E8E9EAEBECEDEEEF :
        ADDR[9:4] == 6'o27 ? 128'hF0F1F2F3F4F5F6F7F8F9FA532856224F :
        ADDR[9:4] == 6'o30 ? 128'h000102030405060708494A0B0C4D0E0F : // OCT
        ADDR[9:4] == 6'o31 ? 128'h101112131415161718191A4B1C1D1E1F :
        ADDR[9:4] == 6'o32 ? 128'h402152232425265758592A2B5C2D5E2F :
        ADDR[9:4] == 6'o33 ? 128'h6061626364656667A8A95A5B2C292E5F :
        ADDR[9:4] == 6'o34 ? 128'hE0CACBCCCDCECFFBFCFDFEDBDCDDDEDF :
        ADDR[9:4] == 6'o35 ? 128'hD0D1D2D3D4D5D6D7D8D9DA545D5527FF :
        ADDR[9:4] == 6'o36 ? 128'h50E1E2E3E4E5E6E7E8E9EAEBECEDEEEF :
        ADDR[9:4] == 6'o37 ? 128'hF0F1F2F3F4F5F6F780F9FA532856224F :
        ADDR[9:4] == 6'o40 ? 128'h000102030405060708494A0B0C4D0E0F : // HEX
        ADDR[9:4] == 6'o41 ? 128'h101112131415161718191A4B1C1D1E1F :
        ADDR[9:4] == 6'o42 ? 128'h402152232425265758592A2B5C2D5E2F :
        ADDR[9:4] == 6'o43 ? 128'h808182838485868788895A5B2C292E5F :
        ADDR[9:4] == 6'o44 ? 128'hE08A8B8C8D8E8FFBFCFDFEDBDCDDDEDF :
        ADDR[9:4] == 6'o45 ? 128'hD0D1D2D3D4D5D6D7D8D9DA545D5527FF :
        ADDR[9:4] == 6'o46 ? 128'h50E1E2E3E4E5E6E7E8E9EAEBECEDEEEF :
        ADDR[9:4] == 6'o47 ? 128'hF0F1F2F3F4F5F6F7F8F9FA532856224F :
        ADDR[9:4] == 6'o50 ? 128'h000102030405060708494A0B0C4D0E0F : // DEC
        ADDR[9:4] == 6'o51 ? 128'h101112131415161718191A4B1C1D1E1F :
        ADDR[9:4] == 6'o52 ? 128'h402152232425265758592A2B5C2D5E2F :
        ADDR[9:4] == 6'o53 ? 128'hA0A1A2A3A4A5A6A7A8A95A5B2C292E5F :
        ADDR[9:4] == 6'o54 ? 128'hE0CACBCCCDCECFFBFCFDFEDBDCDDDEDF :
        ADDR[9:4] == 6'o55 ? 128'hD0D1D2D3D4D5D6D7D8D9DA545D5527FF :
        ADDR[9:4] == 6'o56 ? 128'h50E1E2E3E4E5E6E7E8E9EAEBECEDEEEF :
        ADDR[9:4] == 6'o57 ? 128'hF0F1F2F3F4F5F6F7F8F9FA532856224F :
        ADDR[9:4] == 6'o60 ? 128'h000102030405060708494A0B0C4D0E0F : // TAG
        ADDR[9:4] == 6'o61 ? 128'h101112131415161718191A4B1C1D1E1F :
        ADDR[9:4] == 6'o62 ? 128'h402152232425265758592A2B5C2D5E2F :
        ADDR[9:4] == 6'o63 ? 128'hC0C1C2C3C4C5C6C7C8C95A5B2C292E5F :
        ADDR[9:4] == 6'o54 ? 128'hE0CACBCCCDCECFFBFCFDFEDBDCDDDEDF :
        ADDR[9:4] == 6'o65 ? 128'hD0D1D2D3D4D5D6D7D8D9DA545D5527FF :
        ADDR[9:4] == 6'o66 ? 128'h50E1E2E3E4E5E6E7E8E9EAEBECEDEEEF :
        ADDR[9:4] == 6'o67 ? 128'hF0F1F2F3F4F5F6F7F8F9FA532856224F :
        ADDR[9:4] == 6'o70 ? 128'h000102030405060708494A0B0C4D0E0F : // TAG
        ADDR[9:4] == 6'o71 ? 128'h101112131415161718191A4B1C1D1E1F :
        ADDR[9:4] == 6'o72 ? 128'h402152232425265758592A2B5C2D5E2F :
        ADDR[9:4] == 6'o73 ? 128'hC0C1C2C3C4C5C6C7C8C95A5B2C292E5F :
        ADDR[9:4] == 6'o74 ? 128'hE0CACBCCCDCECFFBFCFDFEDBDCDDDEDF :
        ADDR[9:4] == 6'o75 ? 128'hD0D1D2D3D4D5D6D7D8D9DA545D5527FF :
        ADDR[9:4] == 6'o76 ? 128'h50E1E2E3E4E5E6E7E8E9EAEBECEDEEEF :
        ADDR[9:4] == 6'o77 ? 128'hF0F1F2F3F4F5F6F7F8F9FA532856224F :
                             128'hFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF) >> (((ADDR & 4'hF) ^ 4'hF) << 3);
assign DATA = Data[7:0];
endmodule