/*&call %~d0%~p0\start.bat %0&rem*********************************************
******************************************************************************

******************************************************************************
module
processor_unit(
        input                   RESET,
        input                   CLOCK,
        inout      [7:0]        DATA,
        output reg[31:0]        ADDR,
        output                  READ,
        output                  WRITE
        );
    assign CAP = CAM | JOB;
    assign DATA = JOB[1] ? data : 8'bz;
    assign READ = CAP[0];
    assign WRITE = CAP[1];
    always @(posedge CLOCK)
    begin
        CAM[0] <= ~CAM[1];
        CAM[1] <= CAM[0];
    end
    always @(CAM)
    begin
        case(CAM)
        2'b00:
        2'b11:
            begin
                JOB <= job;
                ADDR <= addr;
            end
        endcase
    end
ͻ
 JOB  CAM  W|R ADDRDATADESCRIPTION                                     
͹
2'b002'b11 H-H --------                                                
2'b002'b10 H-L --------                                                
2'b002'b00 L-L --------                                                
2'b002'b01 L-H --------                                                
Ķ
2'b012'b11 H-H LOCK-""-ADDR <= addr; JOB <= job                        
2'b012'b10 H-H -""-LOCKdata <= information                             
2'b012'b00 L-H -""--""-                                                
2'b012'b01 L-H -""-FREE                                                
Ķ
2'b102'b11 H-H LOCKFREEADDR <= addr; JOB <= job                        
2'b102'b10 H-L -""-FREE                                                
2'b102'b00 H-L -""-READdata <= DATA                                    
2'b102'b01 H-H -""-FREE                                                
Ķ
2'b112'b11 H-H FREEFREEJOB <= job                                      
2'b112'b10 H-H FREEFREE                                                
2'b112'b00 H-H FREEFREE                                                
2'b112'b01 H-H FREEFREE                                                
ͼ
******************************************************************************
RESET:
  ந ⠭  ஢  뢮 RESET  256
⠪⮢ १ CLOCK.  ⮬ ᯮ ⥬ ॣ-稪 ___rc 
ணࠬ  ।⠭.

Clock of read:
ͻ
CYCLECLOCKWRITEREADADDRDATA
͹
READ   0    1    1 Addrload
 CHAR  1    1    0 ----zzzz
       0    1    1 Addrload
       1    1    0 ----zzzz
Ķ
READ   0    1    1 Addrload
 BYTE  1    1    0 ----zzzz
                           
                           
Ķ
                           
                           
                           
                           
ͼ

   Ŀ   Ŀ   Ŀ   Ŀ   Ŀ   Ŀ   Ŀ   Ŀ   |CLOCK
                           |
- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - |
Ŀ       |RESET
                                                               |
- - - - - _____ - - - - - - - - - - - - - - - - - - - - - - - - - - - - |
_________/Reset\|Init;
         \Words/|
- - - - - - - - - ____- - - - - - - - - - - - - - - - - - - - - - - - - |
_________________/Addr\__
                 \Dash/
- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - |
_________________....GET

******************************************************************************
01debug = 1 2 3 + *;
01debug = 1 * (2 + 3);
01debug = 3 + 2 * 1;
01debug = 3 2 + * 1;
01debug = 3 + 2 1 *;
//////////////////////
01debug = x y + 01z -;
01debug = x + y - 01z;
*****************************************************************************/
`timescale 1ns/1ns
`include "cpu_rom.inc"
//////////////////////////////////////////////////////////////////////////////

// state
// 00:Reset all
// 01:Get command
// 02:Read data
// 03:Write data
// class
// 00:ANY
// 01:ACT
// 02:SRV
// 03:OCT
// 04:HEX
// 05:DEC
// 06:TAG
// 07:TAG

module
processor(
        input                   RESET,
        input                   CLOCK,
        inout      [7:0]        DATA,
        output reg[31:0]        ADDR,
        output                  READ,
        output                  WRITE
        );
    parameter _Toil = 2;        // Number of digits sleep counter for reset
    parameter _Ask = 2'b00;     // Ask for Listing ASCII
    parameter _Get = 2'b01;     // Get the data word
    parameter _Put = 2'b10;     // Put the data word
    parameter _Job = 2'b11;     // 
    reg [1:0] state; // 00: ask for char; 01: get the word; 10: put the word; 11: process;
    reg [_Toil - 1:0] ___rc;
    reg[31:0] ___wp;
    reg[31:0] value;
    reg [4:0] width;

    reg  [2:0] class;
    wire [7:0] xlat;
    wire [9:0] code;

    assign code[6:0] = DATA[6:0];
    assign code[9:7] = class[2:0];
    assign READ = CLOCK | state[1];
    assign WRITE = CLOCK | state[0] | ~state[1];
    assign DATA = state == 2 ? value[7:0] : 8'bz;

    Rom2708 chrt(.DATA(xlat), .ADDR(code));

    always @(___rc)
        if(___rc == 0 && !RESET)
            begin
                ___wp <= 0;
                state <= _Ask;
            end

    always @(negedge RESET) ___rc <= (1 << _Toil) - 1;
    always @(posedge RESET) ___rc <= 0;
    always @(negedge CLOCK) ___rc <= ___rc == 0 ? 0 : ___rc - 1;
    always @(posedge CLOCK)
        if(___wp != 32'hFFFFFFFF)
        begin
            case(state)
            _Ask:
            begin
                value <= DATA;
                class <= xlat[7:5];
                if(value[7:0] == 8'h65)
                begin ADDR <= 32'o003; value <= 32'h1A2B3C4D*0; width <= 4'hC; state <= _Get; end
                else begin
                ___wp <= ___wp + 1;
                    ADDR <= ___wp;
                end
            end
            _Get:
            begin
                value <= value | ((32'h0 + DATA[7:0]) << ((5'b0 | width[1:0]) << 3));
                if(width[3:2] != 0)
                begin
                    ADDR = ADDR + 1;
                    width[1:0] <= width[1:0] + 1;
                    width[3:2] <= width[3:2] - 1;
                end
                else
                begin
                    ___wp <= ___wp + 1;
                    ADDR <= ___wp;
                    state <= _Ask;
                end
            end
            _Put:
            begin
                value <= value >> 8;
                if(width[3:2] != 0)
                begin
                    ADDR = ADDR + 1;
                    width[3:2] <= width[3:2] - 1;
                end
                else
                begin
                    ___wp <= ___wp + 1;
                    ADDR <= ___wp;
                    state <= _Ask;
                end
            end
            _Job:
            begin
                state <= 0;
                ADDR <= ___wp;
            end
            endcase
        end

    initial
    begin
        state <= _Ask;
        ___rc <= (1 << _Toil) - 1;
        ___wp <= 32'hFFFFFFFF;
    end
endmodule

module
processor1(
        input             RESET,    // negate initialization
        input             CLOCK,    // negate clock frequency
        output reg        WRITE,    // negate activity
        output reg        READ,     // negate activity
        output reg [31:0] ADDR,     // address bus
        inout  wire [7:0] DATA      // data bus
        );
    reg  [3:0] state;   // CPU state
    reg  [7:0] ascii;   // 
    reg  [2:0] class;
    wire [7:0] xlat;
    wire [9:0] code;
    ///////////////////
    reg [31:0] Data;
    wire [2:0] ScaleA;
    wire [2:0] ScaleB;
    wire[31:0] Summ;
    ///////////////////
    reg [15:0] action;  // Action signature
    reg [31:0] factor;  // Factor of Vector
    reg [31:0] vector;  // Vector of name
    reg [31:0] ___wp;   // Word Pointer

    assign DATA = WRITE ? 8'bz : Data[7:0];

    assign code[6:0] = ascii[6:0];
    assign code[9:7] = class[2:0];
    assign ScaleA[0] = ~class[1] | class[2];
    assign ScaleA[2] = class[1] & class[2];
    assign ScaleA[1] = ~ScaleA[2];
    assign ScaleB[0] = ScaleA[0];
    assign ScaleB[2] = ScaleA[2];
    assign ScaleB[1] = ~class[2] | (class[1] |~ class[0]);
    assign Summ = (Data << ScaleA) + (Data << ScaleB);

    Rom2708 chrt(.DATA(xlat), .ADDR(code));

    always @(negedge CLOCK)
        if(!RESET)
        begin
            Data <= 32'h00000000;
            ___wp <= 32'h00000000;
            ADDR <= 32'h00000000;
            READ <= 1'b1;
            WRITE <= 1'b1;
            state <= 4'h0;
            class <= 3'b000;
            ascii <= 0;
            action <= 0;
            factor <= 0;
            vector <= 0;
        end else
        begin
// 000: 011 011
// 001: 011 011
// 010: 010 010
// 011: 010 010
// 100: 011 011
// 101: 011 001
// 110: 101 101
// 111: 101 101
            case(class)
            1:  Data <= Summ + xlat[3:0]; // ACT
            3:  Data <= Summ + xlat[2:0]; // OCT
            4:  Data <= Summ + xlat[3:0]; // HEX
            5:  Data <= Summ + xlat[3:0]; // DEC
            6,7:Data <= Summ + xlat[5:0]; // TAG
            endcase
            case(state)
            4'o0:
                state <= 4'o1;
            4'o1: begin
                ascii <= DATA;
                ADDR <= ADDR + 1;
                end
            4'hD: begin // Read data
                ADDR <= ADDR + 1;
                end
            endcase
            READ <= 1;
            WRITE <= 1;
        end

    always @(posedge CLOCK)
        if(RESET) begin
            case(state)
            4'o1: begin
                if(class != xlat[7:5])
                begin
                    case(class)
                    1: begin action <= Data[15:0]; factor <= 0; vector <= 0; end
                    3: begin factor <= Data; vector <= 0; end
                    4: begin factor <= Data; vector <= 0; end
                    5: begin factor <= Data; vector <= 0; end
                    6: vector <= Data;
                    7: vector <= Data;
                    endcase
                    Data <= 0;
                end
                class <= xlat[7:5];
                end
            endcase
            READ <= 0;
            WRITE <= 1;
        end
endmodule

module main;
    reg [23:0] Class;
    reg [7:0] ram[0:23];
    reg init, tick;
    wire [31:0] addr;
    wire [7:0] data;
    wire [7:0] char;
    wire [7:0] code;
    wire load, save;
    wire [31:0] summ;
    wire [9:0] ascii;
    processor proc(.RESET(init), .CLOCK(tick), .ADDR(addr), .DATA(data), .READ(load), .WRITE(save));
    assign data = !load ? ram[addr] : 8'bz;
    assign char = !load && (data !== 8'bx) ? data : 32;
/*    always @(proc.class)
        case(proc.class)
        0: Class = "ANY";
        1: Class = "ACT";
        2: Class = "SRV";
        3: Class = "OCT";
        4: Class = "HEX";
        5: Class = "DEC";
        6: Class = "TAG";
        7: Class = "TAG";
        endcase
*/
    always @(negedge save)
    begin
        ram[addr] = data;
    end
    always @(posedge tick)
    begin
        if(addr > 20000)
            $finish;
    end

    always #5 tick = ~tick;
    initial begin
/**/    $dumpfile("out.vcd"); $dumpvars(0,main);
        $readmemh("cpu.txt", ram);
        //ram[11] = 49;
        $display("Time IT WR Address_Bus Data Class:DB St:Acts:__Factor_:__Vector___");
        $monitor("%4d %d%d %d%d %011o %02H%1C %d %08x", $realtime, init, tick, save, load, addr, data, char, proc.state, proc.value);
/*
        $monitor("%4d %d%d %d%d %011o %02H%1C %3s%1o:%1H %d>%04H:%09d:%010o %010o %d%d"
                , $realtime, init, tick, save, load, addr, data, char,
                  Class,
                  proc.class, proc.ascii, proc.state, proc.action, proc.factor, proc.vector, proc.Data
                  ,proc.ScaleA,proc.ScaleB);*/
        $monitoron;
        Class = "...";
        init = 1;
        tick = 1;
        #10
        init = 0;
        #(((1 << proc._Toil) - 1) * 10)
        init = 1;
    end
    always #290 $finish;

endmodule