//----------------------------------------------------------------------------

//   

//-----------------------  : ------------------------------

//  (  )   
//   PB13 (  TIM1_CH1N).   - .

//----------------------------------------------------------------------------

#include "main.h"
#include "sound.h"

//------------------------------- : ---------------------------------

#define TIM1_PRESCALER    10  // 
#define TIM1_PERIOD     2400  //  

//---------------------------  : -----------------------------

#define BEEP_F  1000  //  , 
#define BEEP_D   100  //  , 

#define TICK_F  1000  //  , 
#define TICK_D    40  //  , 

#define HIGH_F  1600  //  , 
#define HIGH_D   100  //  , 

#define CLICK_F  400  //   , 
#define CLICK_D   20  //   , 

#define BELL_F   360  //  , 
#define BELL_D   300  //  , 

//----------------------------------------------------------------------------
//-----------------------------  TSound: --------------------------------
//----------------------------------------------------------------------------

//----------------------------- : ---------------------------------

TSound::TSound(void)
{
  SoundMode = SND_ON;
  SoundTimer = new TSoftTimer();
  SoundTimer->Oneshot = 1;

  RCC->APB2ENR |= RCC_APB2ENR_TIM1EN; //  TIM1
  TIM1->PSC = TIM1_PRESCALER - 1;     // 
  TIM1->ARR = TIM1_PERIOD - 1;        //
  TIM1->CCMR1 = TIM_CCMR1_OC1M_0 * 3; //toggle output
  TIM1->CCR1 = 0;                     // 
  TIM1->BDTR |= TIM_BDTR_MOE;         //main output enable
  TIM1->CR1 = TIM_CR1_CEN;            // 
  
  Pin_SND.Init(AF_PP_2M);             // 
}

//----------------------------  : ------------------------------

void TSound::Execute(void)
{
  if(SoundTimer->Over())
    TIM1->CCER &= ~TIM_CCER_CC1NE;
}

//---------------------------  : ------------------------------

void TSound::Off(void)
{
  TIM1->CCER &= ~TIM_CCER_CC1NE;
}

//--------------------    : ---------------------

void TSound::SetMode(SndMode_t m)
{
  SoundMode = m;
}

//----------------------   : -------------------------

//,    SND_ON.
//f -  f []
//d -  d []

void TSound::PlayNormal(uint16_t f, uint16_t d)
{
  if(SoundMode == SND_ON)
    PlayAlarm(f, d);
}

//----------------------   : --------------------------

//,    SND_ON  SND_ALARM.
//f -  f []
//d -  d []

void TSound::PlayAlarm(uint16_t f, uint16_t d)
{
  if(SoundMode != SND_OFF)
  {
    SoundTimer->Start(d);
    TIM1->ARR = (SYSTEM_CORE_CLOCK / TIM1_PRESCALER / 2) / f - 1;
    TIM1->CCER = TIM_CCER_CC1NE;
  }
}

//---------------------------  : -----------------------------

void TSound::Beep(void)  { PlayNormal(BEEP_F,  BEEP_D);  }
void TSound::Tick(void)  { PlayNormal(TICK_F,  TICK_D);  }
void TSound::High(void)  { PlayNormal(HIGH_F,  HIGH_D);  }
void TSound::Click(void) { PlayNormal(CLICK_F, CLICK_D); }
void TSound::Bell(void)  { PlayNormal(BELL_F,  BELL_D);  }
void TSound::Alarm(void) { PlayAlarm(BEEP_F,   BEEP_D);  }
void TSound::Alert(void) { PlayAlarm(HIGH_F,   HIGH_D);  }
void TSound::ABell(void) { PlayAlarm(BELL_F,   BELL_D);  }

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
