/*
 * Indicator.c
 *
 * Created: 25.11.2013 13:25:39
 *  Author: orc
 */ 

#define F_CPU 9600000UL // 

#include <avr/io.h>
#include <util/delay.h>
#include <avr/interrupt.h>


#define LED_R_OFF PORTB &= ~_BV(2);
#define LED_R_ON PORTB |= _BV(2);

#define LED_G_OFF PORTB &= ~_BV(1);
#define LED_G_ON PORTB |= _BV(1);

unsigned char x=0, divider=0, r, g, do_check=0;
volatile unsigned int VoltLevel, VL; 
unsigned long cntr, light=0;
const unsigned long blink_rate=400000; // ,  Ѩ  1 ,    
const unsigned long blink_length=45000;
// proto
void check_accumulator();


ISR (ADC_vect) //  
{
	 VL=(long)(ADC-1)*46/100;
//	VL=(int)(ADCH); //
}

ISR(TIM0_OVF_vect) // -
{
// TCNT0=200;	//  ,   
if (light)
{
if (x==1) { if(g) LED_G_ON; if (r) LED_R_ON;} // 
if (x++ > 254) {x=0;}
if (x==r) LED_R_OFF;
if (x==g) LED_G_OFF;
light--;

if (light==1) //
	{
	LED_G_OFF; LED_R_OFF; //  
do_check=1;	
	}    
}

if (cntr++ > blink_rate)
 {
	cntr=0;
MCUCR &=~ (1 << SE);
light=blink_length;
} 
 
}



void check_accumulator()
{
unsigned char MCUCR_status;	
unsigned int temporary_VL=0, voltpercent=0;
// * * ** **
ADCSRA =	(1 << ADEN) // 
			|(0 << ADSC) //  
			|(0 << ADATE) //  
			|(1 << ADIE) //  
			|(1 << ADPS2)|(1 << ADPS1)|(1 << ADPS0); //   128 (  50-125kHz   9.6mHz)

ADMUX = (1 << REFS0) //   1,1
		|(0 << ADLAR) //     , ADCL  
		|(1 << MUX1)|(0 << MUX0); //  ADC3, PB4
		MCUCR_status=MCUCR;
		MCUCR = (1 << SE)|(1 << SM0)|(0 << SM1); //     		
_delay_us(125); //    

ADCSRA |= (1 << ADSC);    // 
while (ADIF == 0); //   


for (unsigned char i=0; i<64; i++) //
{
ADCSRA |= (1 << ADSC);    // 
 asm("sleep"); //-
while (ADIF == 0); //   
//VL = ((unsigned int)(ADC-1)*110)/1024;
// VL=(110*1024)/(unsigned int)(ADC-1); // 1.1 
temporary_VL += VL;
}
		VoltLevel=(temporary_VL>>6);
		MCUCR=MCUCR_status;
ADCSRA &=~ (1 << ADEN); // 


VoltLevel = VoltLevel-110; 

if (VoltLevel>340) VoltLevel=400;
if (VoltLevel<300) VoltLevel=300;

g=(VoltLevel-300);
r=100-g;

	MCUCR |= (1 << SE);
}


int main(void)
{
cli();

// 
DDRB  |=  (1 << DDB2)|(1 << DDB1);
PORTB |=  (0 << PB2)|(0 << PB1);

DDRB |= (0 << DDB4);
PORTB |= (1 << PB4);


DIDR0 |=  (1 << ADC2D);

TCCR0B |= (1<<CS00); // 1 
sei();	

TIMSK0|= (1<<TOIE0); //    .
r=0; g=0;
MCUCR = (1 << SE)|(0 << SM0)|(0 << SM1);	
    while(1)
    {
	if (do_check) {do_check=0; check_accumulator();}
asm("sleep"); //-
    }
}