#include <mega8.h>
#include <delay.h>
// SPI functions
#include <spi.h>

#define RES PORTD.7
#define TRANZ PORTD.5                   
// Declare your global variables here 
// sel speed  PD1,2,3.
bit AU;    // 
bit BU;
bit CU;

unsigned char num; //

void ports(void)
{
// Declare your local variables here

// Input/Output Ports initialization
// Port B initialization
// Func7=In Func6=Out Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out 
// State7=T State6=0 State5=0 State4=0 State3=0 State2=0 State1=0 State0=0 
PORTB=0x00;
DDRB=0xFF;

// Port C initialization
// Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
PORTC=0x00;
DDRC=0xFF;

// Port D initialization
// Func7=Out Func6=Out Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out 
// State7=0 State6=0 State5=0 State4=0 State3=0 State2=0 State1=0 State0=0 
PORTD=0x00;
DDRD=0b11110001;

// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: Timer 0 Stopped
TCCR0=0x00;
TCNT0=0x00;

// Timer/Counter 1 initialization
// Clock source: System Clock
// Clock value: Timer 1 Stopped
// Mode: Normal top=FFFFh
// OC1A output: Discon.
// OC1B output: Discon.
// Noise Canceler: Off
// Input Capture on Falling Edge
// Timer 1 Overflow Interrupt: Off
// Input Capture Interrupt: Off
// Compare A Match Interrupt: Off
// Compare B Match Interrupt: Off
TCCR1A=0x00;
TCCR1B=0x00;
TCNT1H=0x00;
TCNT1L=0x00;
ICR1H=0x00;
ICR1L=0x00;
OCR1AH=0x00;
OCR1AL=0x00;
OCR1BH=0x00;
OCR1BL=0x00;

// Timer/Counter 2 initialization
// Clock source: System Clock
// Clock value: Timer 2 Stopped
// Mode: Normal top=FFh
// OC2 output: Disconnected
ASSR=0x00;
TCCR2=0x00;
TCNT2=0x00;
OCR2=0x00;

// External Interrupt(s) initialization
// INT0: Off
// INT1: Off
MCUCR=0x00;

// Timer(s)/Counter(s) Interrupt(s) initialization
TIMSK=0x00;

// Analog Comparator initialization
// Analog Comparator: Off
// Analog Comparator Input Capture by Timer/Counter 1: Off
ACSR=0x80;
SFIOR=0x00;

// SPI initialization
// SPI Type: Master
// SPI Clock Rate: 250,000 kHz
// SPI Clock Phase: Cycle Half
// SPI Clock Polarity: Low
// SPI Data Order: MSB First
SPCR=0x50;
SPSR=0x00; 

}

void res(void){   //
RES=0;       
delay_us(10);       
RES=1;       
delay_us(5); 
}
void speed (void){   // 
AU=PIND.1;
BU=PIND.2;
CU=PIND.3;
num=AU+BU+BU+CU+CU+CU;
}   

void show(void){     //
TRANZ=1;
if(num==6){
delay_ms(2);
delay_us(344);
};
if(num==5){
delay_ms(1);
delay_us(563);
};
if(num==4){
delay_ms(1);
delay_us(172);
};
if(num==3){
delay_us(937);
}; 
if(num==2){
delay_us(791);
};
if(num==1){
delay_us(675);
};
TRANZ=0;
}
void writedata(char x, char y, char z){   // 
res();
spi(z);  
spi(y);
spi(x); 
show();
} 
void test(void){               //  
writedata (0xFF,0x00,0x00);
TRANZ=1;  
delay_ms(50);   
TRANZ=0;
writedata (0x00,0xFF,0x00);
TRANZ=1;
delay_ms(50);
TRANZ=0;
writedata(0x00,0x00,0xFF);
TRANZ=1;
delay_ms(50);
TRANZ=0;
res();
}
void main(void)
{

ports(); //
res();  //
speed(); // 
delay_ms(15);
test();      //
while(1){    // 

writedata(0b10000000,0x00,0x00);
writedata(0b00000001,0x00,0x00);
writedata(0b1000000,0x00,0x00);
writedata(0b00000010,0x00,0x00);
writedata(0b00100000,0,0x00);
writedata(0b00010000,0,0x00);
writedata(0b00000100,0x00,0);
writedata(0b00001000,0x00,00); 
writedata(0x00,0,0); 
writedata(0x00,0,0);
writedata(0x00,0,0); 
writedata(0x00,0b10000000,0x00);
writedata(0x00,0b00000001,0x00);
writedata(0x00,0b1000000,0x00);
writedata(0x00,0b00000010,0x00);
writedata(0x00,0b00100000,0);
writedata(0x00,0b00010000,0);
writedata(0x00,0b00000100,0x00);
writedata(0x00,0b00001000,0x00); 
writedata(0x00,0,0); 
writedata(0x00,0,0);
writedata(0x00,0,0); 
writedata(0x00,0x00,0b10000000);
writedata(0x00,0x00,0b00000001);
writedata(0x00,0x00,0b1000000);
writedata(0x00,0x00,0b00000010);
writedata(0x00,0x00,0b00100000);
writedata(0x00,0x00,0b00010000);
writedata(0x00,0x00,0b00000100);
writedata(0x00,0x00,0b00001000); 
};
}
