// CodeVisionAVR C Compiler
// (C) 1998-2004 Pavel Haiduc, HP InfoTech S.R.L.

// I/O registers definitions for the ATmega8


#pragma used+
#pragma used+
sfrb TWBR=0;
sfrb TWSR=1;
sfrb TWAR=2;
sfrb TWDR=3;
sfrb ADCL=4;
sfrb ADCH=5;
sfrw ADCW=4;      // 16 bit access
sfrb ADCSRA=6;
sfrb ADMUX=7;
sfrb ACSR=8;
sfrb UBRRL=9;
sfrb UCSRB=0xa;
sfrb UCSRA=0xb;
sfrb UDR=0xc;
sfrb SPCR=0xd;
sfrb SPSR=0xe;
sfrb SPDR=0xf;
sfrb PIND=0x10;
sfrb DDRD=0x11;
sfrb PORTD=0x12;
sfrb PINC=0x13;
sfrb DDRC=0x14;
sfrb PORTC=0x15;
sfrb PINB=0x16;
sfrb DDRB=0x17;
sfrb PORTB=0x18;
sfrb EECR=0x1c;
sfrb EEDR=0x1d;
sfrb EEARL=0x1e;
sfrb EEARH=0x1f;
sfrw EEAR=0x1e;   // 16 bit access
sfrb UBRRH=0x20;
sfrb UCSRC=0X20;
sfrb WDTCR=0x21;
sfrb ASSR=0x22;
sfrb OCR2=0x23;
sfrb TCNT2=0x24;
sfrb TCCR2=0x25;
sfrb ICR1L=0x26;
sfrb ICR1H=0x27;
sfrw ICR1=0x26;   // 16 bit access
sfrb OCR1BL=0x28;
sfrb OCR1BH=0x29;
sfrw OCR1B=0x28;  // 16 bit access
sfrb OCR1AL=0x2a;
sfrb OCR1AH=0x2b;
sfrw OCR1A=0x2a;  // 16 bit access
sfrb TCNT1L=0x2c;
sfrb TCNT1H=0x2d;
sfrw TCNT1=0x2c;  // 16 bit access
sfrb TCCR1B=0x2e;
sfrb TCCR1A=0x2f;
sfrb SFIOR=0x30;
sfrb OSCCAL=0x31;
sfrb TCNT0=0x32;
sfrb TCCR0=0x33;
sfrb MCUCSR=0x34;
sfrb MCUCR=0x35;
sfrb TWCR=0x36;
sfrb SPMCR=0x37;
sfrb TIFR=0x38;
sfrb TIMSK=0x39;
sfrb GIFR=0x3a;
sfrb GICR=0x3b;
sfrb SPL=0x3d;
sfrb SPH=0x3e;
sfrb SREG=0x3f;
#pragma used-

// Interrupt vectors definitions


// Needed by the power management functions (sleep.h)
#asm
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x80
	.EQU __sm_mask=0x70
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0x60
	.EQU __sm_ext_standby=0x70
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif
#endasm


// CodeVisionAVR C Compiler
// (C) 1998-2000 Pavel Haiduc, HP InfoTech S.R.L.


#pragma used+
#pragma used+

void delay_us(unsigned int n);
void delay_ms(unsigned int n);

#pragma used-

// SPI functions
/*
  CodeVisionAVR C Compiler
  (C) 1998-2004 Pavel Haiduc, HP InfoTech S.R.L.

  Prototype for SPI access function */
  

#pragma used+
#pragma used+
unsigned char spi(unsigned char data);
#pragma used-

#pragma library spi.lib


// Declare your global variables here 
// sel speed  PD1,2,3.
bit AU;    // 
bit BU;
bit CU;

unsigned char num; //

void ports(void)
{
// Declare your local variables here

// Input/Output Ports initialization
// Port B initialization
// Func7=In Func6=Out Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out 
// State7=T State6=0 State5=0 State4=0 State3=0 State2=0 State1=0 State0=0 
PORTB=0x00;
DDRB=0xFF;

// Port C initialization
// Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
PORTC=0x00;
DDRC=0xFF;

// Port D initialization
// Func7=Out Func6=Out Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out 
// State7=0 State6=0 State5=0 State4=0 State3=0 State2=0 State1=0 State0=0 
PORTD=0x00;
DDRD=0b11110001;

// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: Timer 0 Stopped
TCCR0=0x00;
TCNT0=0x00;

// Timer/Counter 1 initialization
// Clock source: System Clock
// Clock value: Timer 1 Stopped
// Mode: Normal top=FFFFh
// OC1A output: Discon.
// OC1B output: Discon.
// Noise Canceler: Off
// Input Capture on Falling Edge
// Timer 1 Overflow Interrupt: Off
// Input Capture Interrupt: Off
// Compare A Match Interrupt: Off
// Compare B Match Interrupt: Off
TCCR1A=0x00;
TCCR1B=0x00;
TCNT1H=0x00;
TCNT1L=0x00;
ICR1H=0x00;
ICR1L=0x00;
OCR1AH=0x00;
OCR1AL=0x00;
OCR1BH=0x00;
OCR1BL=0x00;

// Timer/Counter 2 initialization
// Clock source: System Clock
// Clock value: Timer 2 Stopped
// Mode: Normal top=FFh
// OC2 output: Disconnected
ASSR=0x00;
TCCR2=0x00;
TCNT2=0x00;
OCR2=0x00;

// External Interrupt(s) initialization
// INT0: Off
// INT1: Off
MCUCR=0x00;

// Timer(s)/Counter(s) Interrupt(s) initialization
TIMSK=0x00;

// Analog Comparator initialization
// Analog Comparator: Off
// Analog Comparator Input Capture by Timer/Counter 1: Off
ACSR=0x80;
SFIOR=0x00;

// SPI initialization
// SPI Type: Master
// SPI Clock Rate: 250,000 kHz
// SPI Clock Phase: Cycle Half
// SPI Clock Polarity: Low
// SPI Data Order: MSB First
SPCR=0x50;
SPSR=0x00; 

}

void res(void){   //
PORTD.7=0;       
delay_us(10);       
PORTD.7=1;       
delay_us(5); 
}
void speed (void){   // 
AU=PIND.1;
BU=PIND.2;
CU=PIND.3;
num=AU+BU+BU+CU+CU+CU;
}   

void show(void){     //
PORTD.5                   =1;
if(num==6){
delay_ms(2);
delay_us(344);
};
if(num==5){
delay_ms(1);
delay_us(563);
};
if(num==4){
delay_ms(1);
delay_us(172);
};
if(num==3){
delay_us(937);
}; 
if(num==2){
delay_us(791);
};
if(num==1){
delay_us(675);
};
PORTD.5                   =0;
}
void writedata(char x, char y, char z){   // 
res();
spi(z);  
spi(y);
spi(x); 
show();
} 
void test(void){               //  
writedata (0xFF,0x00,0x00);
PORTD.5                   =1;  
delay_ms(50);   
PORTD.5                   =0;
writedata (0x00,0xFF,0x00);
PORTD.5                   =1;
delay_ms(50);
PORTD.5                   =0;
writedata(0x00,0x00,0xFF);
PORTD.5                   =1;
delay_ms(50);
PORTD.5                   =0;
res();
}
void main(void)
{

ports(); //
res();  //
speed(); // 
delay_ms(15);
test();      //
while(1){    // 

writedata(0b10000000,0x00,0x00);
writedata(0b00000001,0x00,0x00);
writedata(0b1000000,0x00,0x00);
writedata(0b00000010,0x00,0x00);
writedata(0b00100000,0,0x00);
writedata(0b00010000,0,0x00);
writedata(0b00000100,0x00,0);
writedata(0b00001000,0x00,00); 
writedata(0x00,0,0); 
writedata(0x00,0,0);
writedata(0x00,0,0); 
writedata(0x00,0b10000000,0x00);
writedata(0x00,0b00000001,0x00);
writedata(0x00,0b1000000,0x00);
writedata(0x00,0b00000010,0x00);
writedata(0x00,0b00100000,0);
writedata(0x00,0b00010000,0);
writedata(0x00,0b00000100,0x00);
writedata(0x00,0b00001000,0x00); 
writedata(0x00,0,0); 
writedata(0x00,0,0);
writedata(0x00,0,0); 
writedata(0x00,0x00,0b10000000);
writedata(0x00,0x00,0b00000001);
writedata(0x00,0x00,0b1000000);
writedata(0x00,0x00,0b00000010);
writedata(0x00,0x00,0b00100000);
writedata(0x00,0x00,0b00010000);
writedata(0x00,0x00,0b00000100);
writedata(0x00,0x00,0b00001000); 
};
}
