    .nolist
    .include "C:\Program Files\Atmel\AVR Tools\AvrAssembler2\Appnotes\tn2313def.inc"
    .list
;======================================================================
;      5-44.
; 
;      :
; -D[0/3] -  -    
;           .      ,   
;                  
;                .      
;              1559,  - 
;              +Vcc.      
;                  
;                  -OE.
; -[] -       []   
;           
; -    -        [],    
;              -[].
; -OE     -  ,   ,   
;            ,   .
; 
;      :
; -[0/3] -  ( )   .
; 
;     6- (3: + 3:)
; 7-          -
; .       -[].
;  ,     ,   
;     ~0,5 .     
;   .
; 
;  ,     
;    "0"   :   .
;       .
;     .     
;    []    "0"    -[]  
;  -[]   ,     
;     . 
;  ""  "0"    .    
;      .
;======================================================================
; "The device is shipped with CKSEL = "0100", SUT = "10", and CKDIV8 
; programmed. The default  clock source setting  is the Internal  RC 
; Oscillator with longest start-up time and  an initial system clock 
; prescaling of 8, resulting in  1.0 MHz  system clock. This default 
; setting ensures that all users can make their desired clock source 
; setting using an In-System or Parallel programmer".
;                                                   (8246A-AVR-11/09)
;======================================================================
;   :
;   SPIEN     = 0
;   CKDIV8    = 0
;   SUT0      = 0
;   CKSEL3    = 0
;   CKSEL1    = 0
;   CKSEL0    = 0
;   BODLEVEL0 = 0
;   BODLEVEL1 = 0
;
;  I/O Clock == System Clock:
;   CLKPS[3/0] = 0000 -> 1/(8 /8) = 1 
;  TimerPreScaler- (TCCRxB.CS[]):
;   CS[x2/x0] = 101 ->     = 1,024 
;======================================================================
;   :
; reeDat = RdEEbyte(reeAdr)     EEPROM  reeDat    reeAdr
; rTmp0 = GetBtnEvent()           rTmp0 
; rTmp0 = RdInpLines()             rTmp0 
; WrEEbyte(reeDat, reeAdr)      reeDat  EEPROM    reeAdr
; OnTmr1compA()                   1
; OnTmr0compA()                   0
; OnReset()                        BOD
; ProcBtnEvt(rTmp0)          - -   
; StartTimer0()                  
; Sub3bcd()                   : [r0:r1:r2] -= [r3:r4:r5]
; Add3bcd()                    : [r0:r1:r2] += [r3:r4:r5]
; LoadDACreg()                   
;======================================================================
;   :    EEPROM
;======================================================================
            .eseg
eeStart:
EeUx10:     .db     0               ;    
EeUx1:      .db     0               ;    
EeUx01:     .db     0               ;     

EeIx100:    .db     0               ;    
EeIx10:     .db     0               ;    
EeIx1:      .db     0               ;    
eeLastSet:
.equ        SettingsCnt = (eeLastSet - eeStart)
.equ        MaxLoopNo   = (SettingsCnt - 1)

;======================================================================
;   :  
;======================================================================
.equ        offsR0  =0              ;     SRAM

            .dseg                   ; at SRAM_START = 0x60
img1st:
imgD0:      .byte   1               ;  ,   .
imgD1:      .byte   1               ;     
imgD2:      .byte   1               ;  FLASH  RAM,  "" 
imgD3:      .byte   1               ;      
imgD4:      .byte   1               ; FLASH    Atmel 
imgD5:      .byte   1               ; .
imgD6:      .byte   1
imgD7:      .byte   1
imgD8:      .byte   1
imgD9:      .byte   1

EEWRdelay:  .byte   1               ;      EEPROM

;======================================================================
;   :     ...
;   ...   -
;         -   
;      ,    ,    , 
;          RAM  ;
;   ...    -
;          ,  ,
;         /    
;       ,     .
;======================================================================
            .org    offsR0          ; =0
lineFilter:                         ;      T0
op1_3bcd:                           ; -Rd  3-. b[inary]c[oded]d[ecimal]   
            .byte   1               ; R0:     Ux10
            .byte   1               ; R1:     Ux1
            .byte   1               ; R2:     Ux0,1

op2_3bcd:                           ; -Rr  3-. b[inary]c[oded]d[ecimal]
            .byte   1               ; R3:     Ix100
            .byte   1               ; R4:     Ix10
            .byte   1               ; R5:     Ix1

new1st:                             ; {LDD|STD} rpReg + new1st
nUx10:      .byte   1               ; R6:      
nUx1:       .byte   1               ; R7:      
nUx01:      .byte   1               ; R8:       
nIx100:     .byte   1               ; R9:      
nIx10:      .byte   1               ; R10:     
nIx1:       .byte   1               ; R11:     

wrk1st:                             ; {LDD|STD} rpReg + wrk1st
Ux10:       .byte   1               ; R12:     
Ux1:        .byte   1               ; R13:     
Ux01:       .byte   1               ; R14:      
Ix100:      .byte   1               ; R15:     
Ix10:       .byte   1               ; R16:     
Ix1:        .byte   1               ; R17:     

;======================================================================
;    - :
;=====================================================================
.equ        rFlags      =GPIOR0     ;   

.def        rUx10       =r6         ;     Ux10
.def        rUx1        =r7         ;     Ux1
.def        rUx01       =r8         ;     Ux0,1
.def        rIx100      =r9         ;     Ix100
.def        rIx10       =r10        ;     Ix10
.def        rIx1        =r11        ;     Ix1

.def        roUx10      =r12        ;     Ux10
.def        roUx1       =r13        ;     Ux1
.def        roUx01      =r14        ;     Ux0,1
.def        roIx100     =r15        ;     Ix100
.def        roIx10      =r16        ;     Ix10
.def        roIx1       =r17        ;     Ix1

.equ        lpnoUx10    =0          ;   Ux10
.equ        lpnoIx100   =3          ;   Ix100
.equ        lpnoIx10    =4          ;   Ix10

.equ        maxUx10     =3          ; .   Ux10

.def        rConstm1    =r18        ;    -1   

.def        rWrk        =r18        ;    
.def        rNew        =r19        ;    

.def        rDspCathode =r20        ;    
.def        rDspAnodes  =r21        ;  ,   

.def        rTmp0       =r22        ;  .   .  
.def        rTmp1       =r23        ;  .   .  
.def        rTmp2       =r24        ;  .   .  

.def        reeDat      =r23        ;   / / EEPROM.
.def        reeAdr      =r24        ;   / / EEPROM.

.def        rBtn        =r25        ;    

#define     rpDsp       X           ;     
.undef      XL
.undef      XH
.def        rpDspL      =r26        ; LOW(    )
.def        rpDspH      =r27        ; HIGH(    )

#define     rpIdx       Y           ;   
.undef      YL
.undef      YH
.def        rLpCnt      =r28        ;     /
.def        rConst0     =r29        ;    0

#define     rpReg       Z           ;     
.def        rpRegL      =r30        ; LOW(    )
.def        rpRegH      =r31        ; HIGH(    )

.def        rLpMainCnt  =r30        ; .   ::=   

;======================================================================
;    - :
;======================================================================
.equ        TmrPreScale   =0b00000101       ;  5  : Fclk/1024
.equ        TmrTrembling  =98               ;   : ~100,4 
.equ        TmrBlinking   =489              ;  : /  ~500,7 
.equ        TmrEEWRdelay  =120              ;     EEPROM ~60 

.equ        flgDACenabled =7                ; GPIOR0[7]:   
.equ        flgDACload    =6                ; GPIOR0[6]:    
.equ        flgT0Started  =5                ; GPIOR0[5]:  0 ( )
.equ        flgBtnEvent   =4                ; GPIOR0[4]:  , . 
.equ        flgBtnPressed =3                ; GPIOR0[3]: []  
.equ        flgBtnPending =2                ; GPIOR0[2]:   
.equ        flgSuspendEEWR=1                ; GPIOR0[1]:   EEPROM   1 

.equ        cmdDACdisable =0b10000000       ; :   

;==========       GetBtnEvent():
.equ        BtnNoEvent    =0                ;    
.equ        BtnOE         =0b10000000       ;   / 
.equ        BtnIncUx10    =0b00000001       ;   Ux10 ++
.equ        BtnDecUx10    =0b01000001       ;   Ux10 --
.equ        BtnIncUx1     =0b00000010       ;   Ux1 ++
.equ        BtnDecUx1     =0b01000010       ;   Ux1 --
.equ        BtnIncUx01    =0b00000100       ;   Ux0,1 ++
.equ        BtnDecUx01    =0b01000100       ;   Ux0,1 --
.equ        BtnIncIx100   =0b00001000       ;   Ix100 ++
.equ        BtnDecIx100   =0b01001000       ;   Ix100 --
.equ        BtnIncIx10    =0b00010000       ;   Ix10 ++
.equ        BtnDecIx10    =0b01010000       ;   Ix10 --
.equ        BtnIncIx1     =0b00100000       ;   Ix1 ++
.equ        BtnDecIx1     =0b01100000       ;   Ix1 --
.equ        BtnDecPressed =0b01000000       ;   
.equ        BitPosDEC     =6                ;   

;========== ,   PinA:
.equ        mskBtnLines   =0b00000011       ; XOR-   
.equ        LinePosDEC    =0                ;     PinA
.equ        mskLineDec    =0b00000001       ;   
.equ        mskLineInc    =0b00000010       ;   

;========== ,   PortB:
.equ        mskNibble     =0b10001111       ;    - D[0/3]
                                            ; + : " "
;========== ,   PortD:
.equ        cmdPosUx10    =0b11111110       ; - Ux10/[Ux10]/[Ux10]
.equ        cmdPosUx1     =0b11111101       ; - Ux1/[Ux1]/[Ux1]
.equ        cmdPosUx01    =0b11111011       ; - Ux0,1/[Ux0,1]/[Ux0,1]
.equ        cmdPosIx100   =0b11110111       ; - Ix100/[Ix100]/[Ix100]
.equ        cmdPosIx10    =0b11101111       ; - Ix10/[Ix10]/[Ix10]
.equ        cmdPosIx1     =0b11011111       ; - Ix1/[Ix1]/[Ix1]
.equ        cmdDataGateCtl=0b01000000       ; -
.equ        mskCathodes   =0b00111111       ;    

            .cseg
            .org    0
;======================================================================
;    
;======================================================================
            rjmp    OnReset                 ; RESET -   . 
            reti                            ; n/u - INT0
            reti                            ; n/u - INT1
            reti                            ; n/u - Timer1 Capture Handler
            rjmp    OnTmr1compA             ; Timer1 Compare A - 
            reti                            ; n/u - Timer1 Overflow Handler
            reti                            ; n/u - Timer0 Overflow Handler
            reti                            ; n/u - USART0 RX Complete Handler
            reti                            ; n/u - USART0,UDR Empty Handler
            reti                            ; n/u - USART0 TX Complete Handler
            reti                            ; n/u - Analog Comparator Handler
            reti                            ; n/u - PCINT0 Handler
            reti                            ; n/u - Timer1 Compare B Handler
            rjmp    OnTmr0compA             ; Timer0 Compare A - . 
            reti                            ; n/u - Timer0 Compare B Handler
            reti                            ; n/u - USI Start Handler
            reti                            ; n/u - USI Overflow Handler
            reti                            ; n/u - EEPROM Ready Handler
            reti                            ; n/u - Watchdog Overflow Handler
            reti                            ; n/u - PCINT1 Handler
            reti                            ; n/u - PCINT2 Handler

;======================================================================
;            ,   
;======================================================================
;                       cdegfba; "1"    
.equ        ledA    =0b10000001             ;  A     AAA
.equ        ledB    =0b10000010             ;  B    F   B
.equ        ledC    =0b11000000             ;  C    F   B
.equ        ledD    =0b10100000             ;  D     GGG
.equ        ledE    =0b10010000             ;  E    E   C
.equ        ledF    =0b10000100             ;  F    E   C
.equ        ledG    =0b10001000             ;  G     DDD
;                      |cdegfba     - 
;                      |         => "1"    
;                     "1" - : " "
pm1stImage:         ; (0|(1<<8)), (2|(3<<8)), (4|(5<<8)), (6|(7<<8)), (8|(9<<8))
            .dw     (ledA|ledB|ledC|ledD|ledE|ledF     |((ledB|ledC) << 8))
            .dw     (ledA|ledB|ledD|ledE|ledG          |((ledA|ledB|ledC|ledD|ledG) << 8))
            .dw     (ledB|ledC|ledF|ledG               |((ledA|ledC|ledD|ledF|ledG) << 8))
            .dw     (ledA|ledC|ledD|ledE|ledF|ledG     |((ledA|ledB|ledC) << 8))
            .dw     (ledA|ledB|ledC|ledD|ledE|ledF|ledG|((ledA|ledB|ledC|ledD|ledF|ledG) << 8))

;======================================================================
;     3-   ,
;      000...999: op1_3bcd -= op2_3bcd
;   :
;       op1_3bcd:  1  ""   [r0:r1:r2]:
;               r0    10^2
;               r1    10^1
;               r2    10^0
;       op2_3bcd:  2  ""   [r3:r4:r5]:
;               r3    10^2
;               r4    10^1
;               r5    10^0
;   :
;       op1_3bcd  .
;               r0    10^2
;               r1    10^1
;               r2    10^0
;         <0,   N,  
;       rTmp0 
;======================================================================
Sub3bcd:    ldi     rTmp0,10

            sub     r2,r5                   ;   10^0
            brge    dif1ge0                 ;    10^1  
            add     r2,rTmp0                ;    10^0
            dec     r1                      ;    10^1

dif1ge0:    sub     r1,r4                   ;   10^1
            brge    dif10ge0                ;    10^2  
            add     r1,rTmp0                ;    10^1
            dec     r0                      ;    10^2

dif10ge0:   sub     r0,r3                   ;   10^2
            ret

;======================================================================
;     3-   ,
;      000...999: op1_3bcd += op2_3bcd
;   :
;       op1_3bcd:  1  ""   [r0:r1:r2]:
;               r0    10^2
;               r1    10^1
;               r2    10^0
;       op2_3bcd:  2  ""   [r3:r4:r5]:
;               r3    10^2
;               r4    10^1
;               r5    10^0
;   :
;       op1_3bcd  .
;               r0    10^2
;               r1    10^1
;               r2    10^0
;         >999,  (op1_3bcd % 1000)   C
;       rTmp0 
;======================================================================
Add3bcd:    ldi     rTmp0,10

            add     r2,r5                   ;   10^0
            cp      r2,rTmp0                ;    ?
            brmi    sumlt10                 ;  -  
            sub     r2,rTmp0                ;    10^0
            inc     r1                      ;    10^1

sumlt10:    add     r1,r4                   ;   10^1
            cp      r1,rTmp0                ;    ?
            brmi    sumlt100                ;  -  
            sub     r1,rTmp0                ;    10^1
            inc     r0                      ;    10^2

sumlt100:   add     r0,r3                   ;   10^2
            cp      r0,rTmp0                ;    ?
            brmi    sumlt1000               ;  -  
            sub     r0,rTmp0                ;    10^2
            sec                             ;  
            ret

sumlt1000:  clc                             ;  
            ret

;======================================================================
;          EEPROM.
;   :
;       reeDat: ,   
;       reeAdr: ,    
;   :
;       rTmp0 
;======================================================================
WrEEbyte:   ;ret                             ;<---- TODO ----- STUB CODE
            cli                             ;   EEPROM  
            sbic    EECR,EEPE               ;     ?
            rjmp    PC-1                    ;  -    EEPE
                                            ;  :
            clr     rTmp0
            out     EECR,rTmp0              ;  atomic write  EEPROM
            out     EEAR,reeAdr             ;   
            out     EEDR,reeDat             ;    
            sbi     EECR,EEMPE              ;     EEPROM
            sbi     EECR,EEPE               ;     EEPROM
            reti

;======================================================================
;          EEPROM.
;   :
;       reeAdr: ,    
;   :
;       reeDat: ,    EEPROM.
;       rTmpX 
;======================================================================
RdEEbyte:   cli                             ;   EEPROM  
            sbic    EECR,EEPE               ;     ?
            rjmp    PC-1                    ;  -    EEPE

            out     EEAR,reeAdr             ;   
            sbi     EECR,EERE               ;     EEPROM
            in      reeDat,EEDR             ;  
            reti

;======================================================================
;     .   
;     EEPROM   flgSuspendEEWR   rFlags.
;
;           1  
;   .    T=1.
;======================================================================
OnTmr1compA:sbis    rFlags,flgSuspendEEWR   ;    ,
            rjmp    ChkDACen                ;     

            push    rTmp0
            lds     rTmp0,EEWRdelay
            dec     rTmp0
            sts     EEWRdelay,rTmp0         ; EEWRdelay --
            pop     rTmp0
            brne    ChkDACen				;   

            cbi     rFlags,flgSuspendEEWR   ; :   

ChkDACen:   sbic    rFlags,flgDACenabled    ; RETI if flgDACenabled = 1
            reti                            ;  OE=1,    !

            brts    RstOddInd               ; T-  ? -  
            set                             ;  - ==  
            reti

RstOddInd:  clt                             ;  -
            reti

;======================================================================
;           T0.
;     :   ,  
;    T0,    .
;         
;    ;     T0.
;======================================================================
OnTmr0compA:cbi     rFlags,flgT0Started     ;   
            reti

;======================================================================
;      T0    .
;   :
;   :
;       rTmp1 
;======================================================================
StartTimer0:sbic    rFlags,flgT0Started     ;   0  , 
            ret                             ;   

            cli                             ;    
            out     TCNT0,rConst0           ;   0  OCR0A * 1,024 
            in      rTmp1,TIFR              ;     A
            sbr     rTmp1,(1 << OCF0A)      ;  0,  - :
            out     TIFR,rTmp1
            sbi     rFlags,flgT0Started     ;   
            reti                            ; ,  0  

;======================================================================
;        .
;   :
;       rTmp0 = {    Btn[] | BtnNoEvent }
;       rBtn = rTmp0      
;       rFlags.flgBtnPressed:   1 - , 0 - 
;       rFlags.flgBtnEvent:     1 -  , 0 -   
;       rTmpX 
;   : rFlags.flgBtnEvent     .
;                    .
;======================================================================
GetBtnEvent:rcall   RdInpLines              ; rTmp0 =   
            tst     rTmp0                   ;   ?
            brne    BtnIsPressed            ;   -     
                                            ;  :
            sbis    rFlags,flgBtnPressed    ;      , 
            ret                             ;   BtnNoEvent
                                            ;    :
            cbi     rFlags,flgBtnPressed    ;      
            clr     rBtn                    ;  BtnNoEvent  rBtn
            ret                             ; (rTmp0   == BtnNoEvent)

BtnIsPressed:                               ;  :
            sbi     rFlags,flgBtnPressed    ;   - 
            cp      rBtn,rTmp0              ;   vs :
            brne    BtnHasChanged           ;   
                                            ;  -     :
            clr     rTmp0                   ; rTmp0 = BtnNoEvent
            ret

BtnHasChanged:                              ;  - :
            mov     rBtn,rTmp0              ;   
            sbi     rFlags,flgBtnEvent      ;    
            ret                             ;  rTmp0 -   

;======================================================================
;       .
;      1-   
;     :
;   -  OE
;   - BtnNoEvent
;   -    -/-
;   :
;       rLpMainCnt  -     - 5...0
;       rDspCathode -   
;   :
;       rTmp0   -   
;       rTmp1,2 - 
;======================================================================
RdInpLines: in      rTmp0,PinA
            ldi     rTmp1,mskBtnLines       ; rTmp1 =    
            and     rTmp0,rTmp1             ; rTmp0 =    
            brne    OtherState              ;     0b00
                                            ;   OE: "0"   
            ldi     rTmp1,BtnOE             ;   () ,
            rjmp    SmoothData              ;   

OtherState: eor     rTmp1,rTmp0             ;     
            breq    SmoothData              ;   
                                            ;    -/-:
            mov     rTmp1,rDspCathode       ;   
            com     rTmp1                   ;     "1"  "0"
            andi    rTmp1,mskCathodes       ; "1"     
            sbrc    rTmp0,LinePosDEC        ;    - ?
            sbr     rTmp1,BtnDecPressed     ;     

SmoothData: std     rpReg+lineFilter,rTmp1  ;     R[rLpMainCnt]

            clr     rTmp0                   ; rTmp0 = BtnNoEvent
            sbic    rFlags,flgT0Started     ;  
            ret                             ;  BtnNoEvent,   T0
                                            ;  0  :
            sbic    rFlags,flgBtnPending
            rjmp    BtnPending              ;    
                                            ;   :
            sbic    rFlags,flgBtnPressed
            rjmp    DepPending              ;    
                                            ;   :
            tst     rTmp1                   ;      -[p] ?
            breq    NoBtnRdy                ;    : BtnNoEvent

            rcall   StartTimer0             ;    
            sbi     rFlags,flgBtnPending    ;    
NoBtnRdy:   ret                             ;  BtnNoEvent

BtnPending: cbi     rFlags,flgBtnPending    ;    

DepPending: or      rTmp0,r0                ;  
            or      rTmp0,r1
            or      rTmp0,r2
            or      rTmp0,r3
            or      rTmp0,r4
            or      rTmp0,r5
            ret                             ; ,  rTmp0   :

;======================================================================
;        
;   :
;       rTmp0   -   
;   :
;         New[] 
;       rTmpX 
;======================================================================
ProcBtnEvt: cbi     rFlags,flgBtnEvent      ;    

            cpi     rTmp0,BtnOE             ;  OE/OD ?
            brne    AdjBtns                 ; ,   

            sbic    rFlags,flgDACenabled    ;   ?
            rjmp    DACdisable              ;  ,   
                                            ;  -   1-   
            cbi     rFlags,flgSuspendEEWR   ;      EEPROM
            sbi     rFlags,flgDACenabled    ;   
            reti
                                            ;   :
DACdisable: sbr     rDspAnodes,cmdDACdisable
            out     PortB,rDspAnodes
            cbi     rFlags,flgDACenabled    ;   
            ret                             ; 

AdjBtns:    push    r0
            push    r1
            push    r2
            push    r3
            push    r4
            push    r5                      ;     

            mov     rTmp1,rTmp0             ;    
                                            ;  rLpCnt (  rpIdx) 
                                            ;     :
            clr     rLpCnt                  ;   Ux10
FindOffs:   sbrc    rTmp0,0                 ;  0  ->   
            rjmp    OffsFound               ;  0  ->  
            lsr     rTmp0                   ;     0
            inc     rLpCnt                  ;  
            cpi     rLpCnt,SettingsCnt      ;    ?
            brmi    FindOffs                ;  
            rjmp    NoChanges               ; - :    

OffsFound:  push    rLpCnt                  ;    
            cpi     rLpCnt,lpnoIx100        ;     ?
            brmi    LoadU                   ;   -  
                                            ;  -    op1_3bcd
LoadI:      subi    rLpCnt,3                ;  "1"   bcd-
            mov     r0,rIx100               ; op1_3bcd = bcd(New[I])
            mov     r1,rIx10                ;               r9    r10  r11
            mov     r2,rIx1                 ; [r0:r1:r2] = [I100:I10:I1]
            rjmp    UnpackChg

LoadU:      mov     r0,rUx10                ; op1_3bcd = bcd(New[U])
            mov     r1,rUx1                 ;               r6   r7  r8
            mov     r2,rUx01                ; [r0:r1:r2] = [Ux10:Ux1:Ux01]

UnpackChg:  clr     r3                      ;    
            clr     r4                      ;  "" 
            clr     r5
            ldi     rTmp2,1
            std     rpIdx+op2_3bcd,rTmp2    ; op2_3bcd = {1:0:0, 0:1:0, 0:0:1}[rLpCnt]
            pop     rLpCnt                  ; .   

            sbrc    rTmp1,BitPosDEC         ;  0  ->   
            rjmp    DecNeed                 ;  0  ->   

            rcall   Add3bcd                 ;  
            brcs    NoChanges               ;     > 999
            rjmp    CheckSet

DecNeed:    rcall   Sub3bcd                 ;  
            brmi    NoChanges               ;     < 0

CheckSet:   cpi     rLpCnt,lpnoIx100        ;     ?
            brmi    ChkUpperU               ;  -    U
                                            ;  New[I] = op1_3bcd:
StoreI:     mov     rIx100,r0               ;   nIx100 = r0
            mov     rIx10,r1                ;   nIx10  = r1
            mov     rIx1,r2                 ;   nIx1   = r2
            rjmp    SuspEEWR                ;   

ChkUpperU:  mov     r3,r0                   ; op2_3bcd = op1_3bcd
            mov     r4,r1
            mov     r5,r2                   ;     op2_3bcd
            
            ldi     rTmp0,3                 ; ,    , 
            mov     r0,rTmp0                ; : 00,0...30,0 -> op1_3bcd = 300
            clr     r1
            clr     r2                      ; [r0:r1:r2] = [3:0:0]
            rcall   Sub3bcd                 ; = <> - < >
            brmi    NoChanges               ;    30,0
                                            ;  New[U] = op2_3bcd:
StoreU:     mov     rUx10,r3                ;   nUx10 = r3
            mov     rUx1,r4                 ;   nUx1  = r4
            mov     rUx01,r5                ;   nUx01 = r5
                                            ;   :
SuspEEWR:   ldi     rTmp1,TmrEEWRdelay      ;     
            sts     EEWRdelay,rTmp1         ; []  
            sbic    rFlags,flgDACenabled    ;   ->   
            sbi     rFlags,flgSuspendEEWR   ;   ->     EEPROM
            sbi     rFlags,flgDACload       ;   

NoChanges:  pop     r5
            pop     r4
            pop     r3
            pop     r2
            pop     r1
            pop     r0                      ;    
            ret

;======================================================================
;         
;   :
;        New[]      
;       rDspAnodes       
;   :
;       rTmpX 
;       flgDACload 
;======================================================================
LoadDACreg: cli
            ldi     rLpCnt,MaxLoopNo        ;   Ix1
            ldi     rTmp0,cmdPosIx1         ;     

GetDACdata: ldd     rTmp1,rpIdx+new1st      ;      
            com     rTmp1                   ;      
            andi    rTmp1,mskNibble         ;      PortB[0/3],
                                            ;     
            out     PortB,rTmp1             ;      
            cbr     rTmp0,cmdDataGateCtl    ; rTmp0 = - | ~[rLpCnt]
            out     PortD,rTmp0             ;  
            sbr     rTmp0,cmdDataGateCtl    ; rTmp0 = ~[rLpCnt]
            out     PortD,rTmp0             ;   =>  

SelNextReg: sec                             ; CY = 1 <-   MSB rTmp0
            ror     rTmp0                   ;    
            dec     rLpCnt
            brpl    GetDACdata

            cbi     rFlags,flgDACload       ;   
            reti                            ;    

;======================================================================
;      
;======================================================================
OnReset:    ldi     rTmp0,RAMEND            ;  
            out     SPL,rTmp0
;======================================================================
;     
;======================================================================
            clr     rConst0                 ; = 0x00
            ser     rConstm1                ; = 0xFF
            ldi     rTmp0,cmdDACdisable     ; = 0x80

            out     PortB,rTmp0             ; : PB7 -> Pull-up ON
                                            ;    B:
            out     DDRB,rConstm1           ; PB0 (12 o): +  / -  D[0]
                                            ; PB1 (13 o): + B / -  D[1]
                                            ; PB2 (14 o): + F / -  D[2]
                                            ; PB3 (15 o): + G / -  D[3]
                                            ; PB4 (16 o): + E
                                            ; PB5 (17 o): + D
                                            ; PB6 (18 o): + C
                                            ; PB7 (19 o): -O[utput]E[nable]
            out     PortB,rTmp0             ;    -> 0, -OE - 
                                            ;    D:
            out     DDRD,rConstm1           ; PD0 ( 2 o): - Ux10  == - Ux10
                                            ; PD1 ( 3 o): - Ux1   == - Ux1
                                            ; PD2 ( 6 o): - Ux01  == - Ux0,1
                                            ; PD3 ( 7 o): - Ix100 == - Ix100
                                            ; PD4 ( 8 o): - Ix10  == - Ix10
                                            ; PD5 ( 9 o): - Ix1   == - Ix1
                                            ; PD6 (10 o): - -   
            out     PortD,rConstm1          ;    -> +Vcc
                                            ;    A:
            out     DDRA,rConst0            ; PA1 ( 4 i): -    
                                            ; PA0 ( 5 i): -    
            out     PortA,rConstm1          ; DDRA{n} = {0}, PortA{n} = {1} => Pull-up ON

;======================================================================
;    
;======================================================================
                                            ;  :
            ldi     rTmp0,TmrTrembling
            out     OCR0A,rTmp0             ;   0 (  )

            ldi     rTmp0,LOW(TmrBlinking)
            ldi     rTmp1,HIGH(TmrBlinking)
            out     OCR1AL,rTmp0
            out     OCR1AH,rTmp1            ;   1 ( )
                                            ;    =1024:
            ldi     rTmp0,TmrPreScale
            out     TCCR0B,rTmp0            ;   0
            sbr     rTmp0,(1 << WGM12)      ; 1    
            out     TCCR1B,rTmp0            ;  +   1
                                            ;    0  1:
            ldi     rTmp0,(1 << OCIE0A)|(1 << OCIE1A)
            out     TIMSK,rTmp0             ;      

;======================================================================
;     -  
;======================================================================
            out     rFlags,rConst0          ;   

            clr     r0                      ;   ...
            clr     r1
            clr     r2
            clr     r3
            clr     r4
            clr     r5
            clr     rBtn                    ; ...   
                                            ;     ROM  RAM:
            ldi     ZL,LOW(pm1stImage << 1)
            ldi     ZH,HIGH(pm1stImage << 1); ZH:ZL ->   "0"  ROM
            ldi     rpDspL,LOW(img1st)
            ldi     rpDspH,HIGH(img1st)     ; rDspH:rDspL ->   "0"  RAM
            ldi     rLpCnt,10               ;   : 0...9
CopyImages: lpm     rTmp0,Z+                ; rTmp0 = FLASH[Z++].  "-Z" - ! - 
            st      rpDsp+,rTmp0            ; [rpDsp++] = rTmp0
            dec     rLpCnt
            brne    CopyImages              ; memcpy(img1st,pm1stImage,rLpCnt);

;======================================================================
;    ,   EEPROM,   n?x[]
;======================================================================
            clr     reeAdr                  ; reeAdr =    
            clr     rpRegL
            clr     rpRegH                  ; rpReg ->  
            ldi     rLpCnt,SettingsCnt      ; - ,   
GetEeSets:  rcall   RdEEbyte                ; reeDat = EEPROM(reeAdr)
            std     rpReg+new1st,reeDat     ; new?[] =  
            std     rpReg+wrk1st,rConstm1   ; wrk?[] = -1:   
            inc     reeAdr                  ;     EEPROM
            inc     rpRegL                  ; ++  
            dec     rLpCnt
            brne    GetEeSets
            rcall   LoadDACreg

;**********************************************************************
;**********************************************************************
;     -     
;   -
;**********************************************************************
;**********************************************************************
MainCycle:  ldi     rDspCathode,cmdPosIx1   ;    Ix1
                                            ;    :
            ldi     rLpMainCnt,MaxLoopNo    ; rpReg ->  1 

;======================================================================
;      -  
;======================================================================
ByCathodes: out     PortD,rDspCathode       ;  
            ldd     rNew,rpReg+new1st       ; rNew = New[rLpMainCnt]
                                            ;    :
            ldi     rDspAnodes,cmdDACdisable;   +  . 
            sbic    rFlags,flgDACenabled
            rjmp    ShowDigit               ;   -  
            brts    SetAnodes               ;  -    0,5 
                                            ;     
ShowDigit:  tst     rNew                    ;    , ,  0 ?
            brne    SelImage                ;  -    
                                            ;    - 0:
            tst     rLpMainCnt              ;   Ux10 ?
            breq    SetDACctl               ;  -  

            cpi     rLpMainCnt,lpnoIx100    ;   Ix100 ?
            breq    SetDACctl               ;  -  

            cpi     rLpMainCnt,lpnoIx10     ;   Ix10 ?
            brne    SelImage                ;     

            tst     rIx100                  ; Ix100   0 ?
            breq    SetDACctl               ;  -       Ix10
                                            ;  -  0   Ix10
SelImage:   ldi     rpDspL,LOW(img1st)
            ldi     rpDspH,HIGH(img1st)     ; rpDspH:rpDspL ->    
            add     rpDspL,rNew             ;  ,  
            ld      rDspAnodes,rpDsp        ;    + . 

SetDACctl:  sbic    rFlags,flgDACenabled    ;     :
            cbr     rDspAnodes,cmdDACdisable;  PB7,  .  

SetAnodes:  out     PortB,rDspAnodes        ;    +   

            ldd     rWrk,rpReg+wrk1st       ; rWrk = Wrk[rLpMainCnt]
            tst     rWrk                    ; , ,    ?
            brmi    ItIsIPL                 ; :      -   EEPROM

            cp      rWrk,rNew               ;      ?
            breq    CheckKbd                ;  -    

            sbis    rFlags,flgDACenabled    ;      EEPROM ?
            rjmp    CheckKbd                ;    EEPROM   OE
                                            ;     :
            sbic    rFlags,flgSuspendEEWR   ;    ,   
            rjmp    CheckKbd                ;   EEPROM    " "

            mov     reeDat,rNew             ;    rNew  EEPROM
            mov     reeAdr,rLpMainCnt
            rcall   WrEEbyte                ; EEPROM[reeAdr] = reeDat (== rNew)
                                            ;  rDspCathode  -[rLpMainCnt] == 0
ItIsIPL:    std     rpReg+wrk1st,rNew       ;  : Wrk[rLpMainCnt] = rNew

CheckKbd:   rcall   GetBtnEvent             ; rTmp0 =   , flgBtnEvent
            sbic    rFlags,flgBtnEvent      ;    ,
            rcall   ProcBtnEvt              ;  ProcBtnEvt()   

            in      rTmp0,TCNT0             ;    ~1...2  -
Delay:      in      rTmp1,TCNT0             ;    
            sub     rTmp1,rTmp0             ;   
            cpi     rTmp1,2                 ; >= 1,024 
            brne    Delay

            sbic    rFlags,flgDACload       ;    ,
            rcall   LoadDACreg              ;  LoadDACreg()   

            dec     rLpMainCnt              ; --   
            brge    PC+2
            rjmp    MainCycle               ; ,  < 0

            sec                             ; CY = 1 <-   MSB rDspCathode
            ror     rDspCathode             ;    
            rjmp    ByCathodes              ;     
;======================================================================
            .exit
