
#pragma used+
sfrb PINB=3;
sfrb DDRB=4;
sfrb PORTB=5;
sfrb PINC=6;
sfrb DDRC=7;
sfrb PORTC=8;
sfrb PIND=9;
sfrb DDRD=0xa;
sfrb PORTD=0xb;
sfrb TIFR0=0x15;
sfrb TIFR1=0x16;
sfrb TIFR2=0x17;
sfrb PCIFR=0x1b;
sfrb EIFR=0x1c;
sfrb EIMSK=0x1d;
sfrb GPIOR0=0x1e;
sfrb EECR=0x1f;
sfrb EEDR=0x20;
sfrb EEARL=0x21;
sfrb EEARH=0x22;
sfrw EEAR=0x21;   
sfrb GTCCR=0x23;
sfrb TCCR0A=0x24;
sfrb TCCR0B=0x25;
sfrb TCNT0=0x26;
sfrb OCR0A=0x27;
sfrb OCR0B=0x28;
sfrb GPIOR1=0x2a;
sfrb GPIOR2=0x2b;
sfrb SPCR=0x2c;
sfrb SPSR=0x2d;
sfrb SPDR=0x2e;
sfrb ACSR=0x30;
sfrb MONDR=0x31;
sfrb SMCR=0x33;
sfrb MCUSR=0x34;
sfrb MCUCR=0x35;
sfrb SPMCSR=0x37;
sfrb SPL=0x3d;
sfrb SPH=0x3e;
sfrb SREG=0x3f;
#pragma used-

#asm
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x01
	.EQU __sm_mask=0x0E
	.EQU __sm_adc_noise_red=0x02
	.EQU __sm_powerdown=0x04
	.EQU __sm_powersave=0x06
	.EQU __sm_standby=0x0C
	.EQU __sm_ext_standby=0x0E
	.SET power_ctrl_reg=smcr
	#endif
#endasm

char RX_text[254];
char RX_text_tmp[64];

bit alarmflag;
bit alarmsending;
bit lovbatsending;
bit lovlevelbat;

unsigned char  flag1sec;

unsigned int  count10min;
unsigned int  count1dey;
unsigned int  countalarmsend;
unsigned char countalarmdial;

char counter,netststus;
unsigned char uarttimeout;
unsigned char alarmimeout;

unsigned int adcdata;
float volt;
char voltstr[6]; 

unsigned char masterpass[5];
unsigned char userpass[5];
unsigned char alarmphone[13];
unsigned char ballanscomand[9];
unsigned char reley1command[7];
unsigned char reley1delay;
unsigned int reley1ontime;
unsigned int reley1counter;
unsigned char reley2command[7];
unsigned char reley2delay;
unsigned int reley2ontime;
unsigned int reley2counter;
unsigned char reley3command[7];
unsigned char reley3delay;
unsigned int reley3ontime;
unsigned int reley3counter;
unsigned char reley4command[7];
unsigned char reley4delay;
unsigned int reley4ontime;
unsigned int reley4counter;
unsigned char phone[13];

unsigned char eeprom eemasterpass[5] ="WE32";
unsigned char eeprom eeuserpass[5] ="1234";
unsigned char eeprom eealarmphone[13] ="+70000000000" ;
unsigned char eeprom eeballanscomand[9] ="*100#";
unsigned char eeprom eereley1command[7] ="OPEN";
unsigned char eeprom eereley1delay=1;
unsigned char eeprom eereley2command[7] ="CLOSE";
unsigned char eeprom eereley2delay=1;
unsigned char eeprom eereley3command[7] ="HEAT";
unsigned char eeprom eereley3delay=240;
unsigned char eeprom eereley4command[7] ="CAM";
unsigned char eeprom eereley4delay=240;

float eeprom voltdev =0.02685546875; 

interrupt [3] void ext_int1_isr(void)
{

alarmflag=1;
}

char rx_buffer0[512];

unsigned int rx_wr_index0,rx_rd_index0,rx_counter0;

bit rx_buffer_overflow0;

interrupt [19] void usart_rx_isr(void)
{
char status,data;
status=(*(unsigned char *) 0xc0);
data=(*(unsigned char *) 0xc6);

if ((status & ((1<<4) | (1<<2) | (1<<3)))==0){
rx_buffer0[rx_wr_index0]=data;
if (++rx_wr_index0 == 512) rx_wr_index0=0;
if (++rx_counter0 == 512){
rx_counter0=0;
rx_buffer_overflow0=1;
};
};
}

#pragma used+
char getchar(void)
{
char data;
while (rx_counter0==0) {

#asm("wdr")
}; 

data=rx_buffer0[rx_rd_index0];
#asm("wdr")
if (++rx_rd_index0 == 512) rx_rd_index0=0;
#asm("cli")
--rx_counter0;
#asm("sei")

#asm("wdr")
return data;
}
#pragma used-

interrupt [14] void timer1_ovf_isr(void)
{
(*(unsigned char *) 0x85)=0xC2;
(*(unsigned char *) 0x84)=0xF7; 
if (uarttimeout>0)
uarttimeout--;
if (alarmimeout>0)
alarmimeout--;

if (reley1counter>0){reley1counter--; PORTB.2 =1;} else  PORTB.2 =0;
if (reley2counter>0){reley2counter--; PORTB.3 =1;} else  PORTB.3 =0;
if (reley3counter>0){reley3counter--; PORTB.4 =1;} else  PORTB.4 =0; 
if (reley4counter>0){reley4counter--; PORTB.5 =1;} else  PORTB.5 =0;

flag1sec=1;

}

#pragma used+

void delay_us(unsigned int n);
void delay_ms(unsigned int n);

#pragma used-

unsigned int read_adc(void)
{
(*(unsigned char *) 0x7c)= 3 | (0xC0 & 0xff);    
#asm("wdr")

delay_us(10);
#asm("wdr")

(*(unsigned char *) 0x7a)|=0x40;

while (((*(unsigned char *) 0x7a) & 0x10)==0) { #asm("wdr") };
(*(unsigned char *) 0x7a)|=0x10;
return (*(unsigned int *) 0x78) ;
}

void eeprom2var (void){
unsigned char counter;
counter=0;

while (eemasterpass[counter]){
masterpass[counter] = eemasterpass[counter];
counter++;
#asm("wdr")
}    

counter=0;
while (eeuserpass[counter]){
userpass[counter] = eeuserpass[counter];
counter++;
#asm("wdr")
} 

counter=0;
while (eealarmphone[counter]){
alarmphone[counter] = eealarmphone[counter];
phone[counter] = eealarmphone[counter];
counter++;
#asm("wdr")
}

counter=0;
while (eeballanscomand[counter]){
ballanscomand[counter] = eeballanscomand[counter];
counter++;
#asm("wdr")
}

counter=0;
while (eereley1command[counter]){
reley1command[counter] = eereley1command[counter];
counter++;
#asm("wdr")
}
reley1delay=eereley1delay;
#asm("wdr")

counter=0;
while (eereley2command[counter]){
reley2command[counter] = eereley2command[counter];
counter++;
#asm("wdr")
}
reley2delay=eereley2delay;
#asm("wdr")

counter=0;
while (eereley3command[counter]){
reley3command[counter] = eereley3command[counter];
counter++;
#asm("wdr")
}
reley3delay=eereley3delay;
#asm("wdr")    

counter=0;
while (eereley4command[counter]){
reley4command[counter] = eereley4command[counter];
counter++;
#asm("wdr")
}
reley4delay=eereley4delay;
#asm("wdr")

}

char uppchar(char s) {
char o;
if (s >= 'a' && s <= 'z') {
#asm("wdr")
o = s - 32;
}else o=s;
#asm("wdr")
return o;      
}

void resetsistem(void){
delay_ms(200);
#asm("wdr")
delay_ms(200);
#asm("wdr") 
PORTB.0=0;
delay_ms(200);
#asm("wdr")
delay_ms(200);
#asm("wdr")
delay_ms(200);
#asm("wdr")
delay_ms(200);
#asm("wdr")
delay_ms(200);
#asm("wdr")
delay_ms(200);
#asm("wdr")
delay_ms(200);
#asm("wdr")
delay_ms(200);
#asm("wdr")
(*(unsigned char *) 0x60)=0x18; 
(*(unsigned char *) 0x60)=0x08; 
#asm("wdr") 
while(1); 

}

void clearFIFO(void)
{
while (rx_counter0!=0) {
#asm("wdr")
if (++rx_rd_index0 == 512) rx_rd_index0=0;
#asm("cli")
--rx_counter0;
#asm("sei")
}
#asm("cli")
rx_buffer_overflow0=0;
#asm("sei")
#asm("wdr")
}

unsigned char getstring(char *readbuf, unsigned int lenbuf)
{
char data;
unsigned int count;
count=0;
delay_ms(100);
#asm("wdr")
#asm("cli")
uarttimeout=30;
#asm("sei")
while (count<=lenbuf-1){
while (rx_counter0==0) {
#asm("wdr")
if (uarttimeout==0){    
readbuf[count]='\r';
count++;
readbuf[count]='\n';
count++;
readbuf[count]='\0';
return count;
}
}; 
data=rx_buffer0[rx_rd_index0];
#asm("wdr")
if (++rx_rd_index0 == 512) rx_rd_index0=0;
#asm("cli")
--rx_counter0;
#asm("sei")

readbuf[count]=data;
#asm("wdr")
if (count!=0)
if ((readbuf[count-1]=='\r')&&(data=='\n')) break;
if (count==lenbuf-1){
readbuf[count-1]='\r';
readbuf[count]='\n';
count++;
readbuf[count]='\0';
#asm("wdr")
clearFIFO();
return count;
}
count++;
};

#asm("wdr")
count++;
readbuf[count]='\0';

#asm("wdr")
return count;
}

#pragma used+

char *strcat(char *str1,char *str2);
char *strcatf(char *str1,char flash *str2);
char *strchr(char *str,char c);
signed char strcmp(char *str1,char *str2);
signed char strcmpf(char *str1,char flash *str2);
char *strcpy(char *dest,char *src);
char *strcpyf(char *dest,char flash *src);
unsigned int strlenf(char flash *str);
char *strncat(char *str1,char *str2,unsigned char n);
char *strncatf(char *str1,char flash *str2,unsigned char n);
signed char strncmp(char *str1,char *str2,unsigned char n);
signed char strncmpf(char *str1,char flash *str2,unsigned char n);
char *strncpy(char *dest,char *src,unsigned char n);
char *strncpyf(char *dest,char flash *src,unsigned char n);
char *strpbrk(char *str,char *set);
char *strpbrkf(char *str,char flash *set);
char *strrchr(char *str,char c);
char *strrpbrk(char *str,char *set);
char *strrpbrkf(char *str,char flash *set);
char *strstr(char *str1,char *str2);
char *strstrf(char *str1,char flash *str2);
char *strtok(char *str1,char flash *str2);

unsigned int strlen(char *str);
void *memccpy(void *dest,void *src,char c,unsigned n);
void *memchr(void *buf,unsigned char c,unsigned n);
signed char memcmp(void *buf1,void *buf2,unsigned n);
signed char memcmpf(void *buf1,void flash *buf2,unsigned n);
void *memcpy(void *dest,void *src,unsigned n);
void *memcpyf(void *dest,void flash *src,unsigned n);
void *memmove(void *dest,void *src,unsigned n);
void *memset(void *buf,unsigned char c,unsigned n);
unsigned int strcspn(char *str,char *set);
unsigned int strcspnf(char *str,char flash *set);
int strpos(char *str,char c);
int strrpos(char *str,char c);
unsigned int strspn(char *str,char *set);
unsigned int strspnf(char *str,char flash *set);

#pragma used-
#pragma library string.lib

typedef char *va_list;

#pragma used+

char getchar(void);
void putchar(char c);
void puts(char *str);
void putsf(char flash *str);

char *gets(char *str,unsigned int len);

void printf(char flash *fmtstr,...);
void sprintf(char *str, char flash *fmtstr,...);
void snprintf(char *str, unsigned int size, char flash *fmtstr,...);
void vprintf (char flash * fmtstr, va_list argptr);
void vsprintf (char *str, char flash * fmtstr, va_list argptr);
void vsnprintf (char *str, unsigned int size, char flash * fmtstr, va_list argptr);
signed char scanf(char flash *fmtstr,...);
signed char sscanf(char *str, char flash *fmtstr,...);

#pragma used-

#pragma library stdio.lib

unsigned char strtoup(char *readbuf){
unsigned char count=0;
char data;
while (count<=strlen(readbuf)){
data =readbuf[count];
readbuf[count]=uppchar(data);
count++;
}
return  count-1;
}

char ansvercmp(char *str1, char flash *str2){
char len =strlenf(str2);
char status=strncmpf(str1, str2,len);

return status;
} 

char okststusM590(void){
char status=2;
delay_ms(200);
#asm("wdr")
do{
if (rx_counter0!=0) getstring(RX_text_tmp,64);
else  status=0;
#asm("wdr")
if (ansvercmp(RX_text_tmp, "OK")==0) status=0;
#asm("wdr")
if (ansvercmp(RX_text_tmp, "ERROR")==0) status=1;
}while (status==2);

return status;
}

char m590command(char flash *command){

char status=2;
printf(command);
putchar('\r');
putchar('\n');
delay_ms(200);
#asm("wdr")
do{
if (rx_counter0==0) {
return 255;  
}
getstring(RX_text_tmp,64);
#asm("wdr")
if (ansvercmp(RX_text_tmp, "ERROR")==0) break;
} while ((ansvercmp(RX_text_tmp, command)!=0)&&(ansvercmp(RX_text_tmp, "\r\n")!=0));

status=okststusM590();

return status;
}

char netstatusM590(void){
char status=10;

printf("AT+CREG?\r");
putchar('\n');
delay_ms(200);
#asm("wdr")
do{
if (rx_counter0==0) {
return 255;  
}
getstring(RX_text_tmp,64);
#asm("wdr")
if (ansvercmp(RX_text_tmp, "ERROR")==0) break;
} while ((ansvercmp(RX_text_tmp, "AT+CREG?")!=0)&&(ansvercmp(RX_text_tmp, "\r\n")!=0));
do{
getstring(RX_text_tmp,64);
#asm("wdr")
if (ansvercmp(RX_text_tmp, "ERROR")==0) break;
} while (ansvercmp(RX_text_tmp, "+CREG:")!=0) ;
if ((strstrf(RX_text_tmp,",0")!=0)) status=0;
#asm("wdr")
if ((strstrf(RX_text_tmp,",1")!=0)) status=1; 
#asm("wdr")
if ((strstrf(RX_text_tmp,",2")!=0)) status=2;
#asm("wdr")
if ((strstrf(RX_text_tmp,",3")!=0)) status=3;
#asm("wdr")
if ((strstrf(RX_text_tmp,",4")!=0)) status=4;
#asm("wdr")
if ((strstrf(RX_text_tmp,",5")!=0)) status=5; 
okststusM590();
return status;
}

#pragma used+

unsigned char cabs(signed char x);
unsigned int abs(int x);
unsigned long labs(long x);
float fabs(float x);
int atoi(char *str);
long int atol(char *str);
float atof(char *str);
void itoa(int n,char *str);
void ltoa(long int n,char *str);
void ftoa(float n,unsigned char decimals,char *str);
void ftoe(float n,unsigned char decimals,char *str);
void srand(int seed);
int rand(void);
void *malloc(unsigned int size);
void *calloc(unsigned int num, unsigned int size);
void *realloc(void *ptr, unsigned int size); 
void free(void *ptr);

#pragma used-
#pragma library stdlib.lib

char m590init( void ){
char status=2;

PORTC.2=1;
PORTB.0=1;

#asm("wdr")
delay_ms(500);
#asm("wdr")
delay_ms(500);

#asm("wdr")
delay_ms(500);
#asm("wdr")
delay_ms(500);
#asm("wdr")
PORTB.1=1;
do{
getstring(RX_text_tmp,64);
}while (ansvercmp(RX_text_tmp,"\r\n")!=0);

getstring(RX_text_tmp,64);

if (ansvercmp(RX_text_tmp,"MODEM:STARTUP")!=0) {   
PORTB.0=0;
while(1){              
PORTC.2=0;
delay_ms(100);
#asm("wdr")
PORTC.2=1;
delay_ms(100);
#asm("wdr")
};
};   

#asm("wdr")

PORTC.2=1; 

delay_ms(500);
#asm("wdr")
delay_ms(500);
#asm("wdr")
delay_ms(500);
#asm("wdr")
delay_ms(500);
#asm("wdr")
delay_ms(500);
#asm("wdr")
delay_ms(500);
#asm("wdr") 

PORTB.1=0;  
PORTD.6=1;
#asm("wdr") 

do{
getstring(RX_text_tmp,64);
}while (ansvercmp(RX_text_tmp,"\r\n")!=0);
getstring(RX_text_tmp,64);
if (ansvercmp(RX_text_tmp,"+PBREADY")!=0) {
PORTB.0=0;   
while(1){              
PORTC.2=0;
delay_ms(400);
#asm("wdr")
PORTC.2=1;
delay_ms(100);
#asm("wdr")
};
};   

PORTC.2=1;

m590command("AT");
delay_ms(200);
#asm("wdr") 

m590command("ATE1");
delay_ms(200);    
#asm("wdr")
m590command("AT+CLIP=0");
delay_ms(200);    
#asm("wdr")

m590command("AT+CMGF=1");  
delay_ms(200);    
#asm("wdr")

m590command("AT+CSCS=\"GSM\""); 
delay_ms(200);    
#asm("wdr")

PORTC.2=0;
while(1) {     
netststus=netstatusM590();
if(netststus==1) break;
if(netststus==5) break;
PORTC.2=0;
delay_ms(500);
#asm("wdr")
delay_ms(500);
#asm("wdr")
PORTC.2=1;
delay_ms(500);
#asm("wdr")
delay_ms(500);
#asm("wdr")
};
PORTC.2=1;

m590command("AT+CNMI=2,2");      
delay_ms(200);    
#asm("wdr")

m590command("AT+ENPWRSAVE=1"); 
delay_ms(200);    
#asm("wdr")
PORTD.6=0;
PORTC.2=0;

return status;
}

char alarmDial(void){
char status=3;

printf("ATD%s;\r",alarmphone);
putchar('\n');
#asm("wdr")
do{
getstring(RX_text_tmp,64);
#asm("wdr")
if (ansvercmp(RX_text_tmp, "ERROR")==0) break;
}while ((ansvercmp(RX_text_tmp, "ATD")!=0)&&(ansvercmp(RX_text_tmp, "\r\n")!=0));
delay_ms(200);
#asm("wdr")
if (okststusM590()==0)
do{ 
getstring(RX_text_tmp,64);
if (ansvercmp(RX_text_tmp, "ERROR")==0) break; 
#asm("wdr")
if ((ansvercmp(RX_text_tmp,"CONNECT")==0)){
#asm("wdr")
delay_ms(200);
m590command("ATH");
status=0;
}
if ((ansvercmp(RX_text_tmp,"NO CARRIER")==0)){
#asm("wdr")
delay_ms(200);
m590command("ATH");
status=0;
}
if ((ansvercmp(RX_text_tmp,"BUSY")==0)){
#asm("wdr")
delay_ms(200);
m590command("ATH");
status=1;
}
if ((ansvercmp(RX_text_tmp,"NO ANSWER")==0)){
#asm("wdr")
delay_ms(200);
m590command("ATH");
status=1;
}
}while (status==3);

return status;
}

char alarmSMS(void){
char status;

printf("AT+CMGS=\"%s\"\r",alarmphone);
putchar('\n');
#asm("wdr")

while (getchar()!='>'){#asm("wdr")};
getchar();
delay_ms(200);
printf("ALARM: ");

if (PIND.4==1) {
printf("IGNITION ON!");
}else if (PIND.5==0){
printf("DOOR OPEN!");
}else{
printf("SHOCK!");
}
delay_ms(200);
#asm("wdr")
putchar(0x1A); 
putchar('\n');
#asm("wdr")
status=okststusM590();
if (status==0) {
alarmsending=1;
countalarmsend=0;
}

return status;
}

char statusSMS(void){
char status=2;
#asm("wdr")
read_adc();
adcdata=read_adc();
#asm("wdr")
volt = (float) adcdata * voltdev;
#asm("wdr")
ftoa(volt,1,voltstr);
#asm("wdr")

printf("AT+CMGS=\"%s\"\r",phone);
putchar('\n');

#asm("wdr")
while (getchar()!='>'){#asm("wdr")};
getchar();
#asm("wdr")
delay_ms(200);
#asm("wdr")
printf("STATUS: ");
if (alarmflag){
printf("ALLARM, ");
}else{
printf("NO ALLARM, ");
} 
#asm("wdr") 
if (PIND.4) {
printf("IGNITION ON, ");
}else{
printf("IGNITION OFF, ");
}
#asm("wdr")
if (PIND.5==0){
printf("DOOR OPEN, ");
}else{
printf("DOOR CLOSE, ");
}
#asm("wdr")
printf("VOLTAGE: %sV", voltstr);
#asm("wdr")
delay_ms(200);
#asm("wdr")
putchar(0x1A); 
putchar('\n');
#asm("wdr")
status=okststusM590();

return status;
}

char statusSMSOK(void){
char status=2;

printf("AT+CMGS=\"%s\"\r",phone);
putchar('\n');

#asm("wdr")
while (getchar()!='>'){#asm("wdr")};
getchar();
#asm("wdr")
delay_ms(200);
#asm("wdr")
printf("COMMAND OK");
delay_ms(100);
#asm("wdr")
putchar(0x1A); 
putchar('\n');
#asm("wdr")
status=okststusM590();

return status;
}

char billingSMS(void){

char status=2;
unsigned char count;
char *ptr_to_ram;
m590command("AT+CNMI=0,0");
delay_ms(200);
printf("ATD%s;\r",ballanscomand);

putchar('\n');
delay_ms(200);

#asm("wdr")
status=0;
do{
getstring(RX_text_tmp,64);
if (ansvercmp(RX_text_tmp, "ERROR")==0) break;
#asm("wdr")
}while ((ansvercmp(RX_text_tmp, "ATD")!=0)&&(ansvercmp(RX_text_tmp, "\r\n")!=0));

do {
getstring(RX_text,254);
if (ansvercmp(RX_text, "OK")==0) status=1;
#asm("wdr")
if (ansvercmp(RX_text, "ERROR")==0) status=1;
#asm("wdr")
if(ansvercmp(RX_text,"+CUSD")==0) {
status= okststusM590();
}
}while (status==2);
#asm("wdr")
if (status==0) {
ptr_to_ram=RX_text;

while (*ptr_to_ram!='"') {

ptr_to_ram++;
}
ptr_to_ram++;

count=1;
while (ptr_to_ram[count]!='"') count++;
ptr_to_ram[count]='\0';

printf("AT+CMGS=\"%s\"\r",phone);
putchar('\n');
#asm("wdr")       
while (getchar()!='>') {#asm("wdr")};
getchar();
#asm("wdr")
delay_ms(200);
#asm("wdr")
printf("BILLING:%s",ptr_to_ram);
putchar(0x0D);
#asm("wdr")
delay_ms(200);
#asm("wdr")
putchar(0x1A); 
putchar('\n');
status=okststusM590();
};

delay_ms(200);
m590command("AT+CNMI=2,2");

return status;
}

char helpSMS(void){
char status;
printf("AT+CMGS=\"%s\"\r",phone);
putchar('\n');

#asm("wdr")        
while (getchar()!='>'){#asm("wdr")};
getchar();
delay_ms(200);
printf("HELP: ");
#asm("wdr")
printf("\"*pasw#STATUS\" ");
#asm("wdr")
printf("\"*pasw#BILLING\" ");
#asm("wdr")
printf("\"*pasw#BALANS\" ");
#asm("wdr")

#asm("wdr")
printf("\"*pasw#RELEY\" ");
#asm("wdr")
printf("\"*pasw#RELEY:02\" ");
#asm("wdr")
printf("\"*pasw#RELEY:02M\" ");
#asm("wdr")
printf("RELEY: %s,",reley1command);
#asm("wdr")
printf("%s,",reley2command);
#asm("wdr")
printf("%s,",reley3command);
#asm("wdr")
printf("%s ",reley4command);

delay_ms(200);
putchar(0x1A); 
putchar('\n');
status=okststusM590();

return status;
}

void parseSMS(void){
unsigned char counter=0;
unsigned char counter1;
char password[5];
bit durflag;
char *ptr_to_ram; 
char *comand;
char *argument;

counter=0;
counter1=0;
#asm("wdr")
do {
if (RX_text[counter]=='"') break;
#asm("wdr")
counter++;
} while (counter<254) ;
counter++;
do{
if (RX_text[counter]!='"'){ 
phone[counter1] = RX_text[counter];
counter1++;
counter++;
#asm("wdr")
if (counter1>12) break;
}else break ;
#asm("wdr")   

}while (counter<254);
phone[counter1]='\0';
getstring(RX_text,254); 
clearFIFO();            
#asm("wdr")
if (RX_text[0]=='*'){
for (counter=0; counter<=3; counter++){
password[counter]=RX_text[counter+1];
}
password[4]=0;
#asm("wdr")
if ((strcmp(password,masterpass)==0)||(strcmp(password,userpass)==0)){

counter=0;

ptr_to_ram=RX_text;
#asm("wdr")
strtoup(ptr_to_ram);
ptr_to_ram+=6; 

#asm("wdr")
if(ansvercmp(ptr_to_ram,"STATUS")==0){
statusSMS();
}else if(ansvercmp(ptr_to_ram,"BALANS")==0){
billingSMS();                        
}else if(ansvercmp(ptr_to_ram,"BILLING")==0){
billingSMS();

}else if(ansvercmp(ptr_to_ram,"HELP")==0){
helpSMS();
}else{
if (strstrf(ptr_to_ram,":")!=0){
comand=  strtok(ptr_to_ram,":");
argument=  strtok(0,":");
if(strcmpf(comand,"SETPASS")==0){

for (counter=0; counter<=3; counter++){
#asm("cli")
eeuserpass[counter] = argument[counter];
#asm("sei")
#asm("wdr")
userpass[counter] = argument[counter];
}
#asm("wdr")
statusSMSOK();

}else if (strcmpf(comand,"SETPHONE")==0){

durflag=0;

if ((argument[0] == '+')||(argument[0] == '8')) durflag=1;
#asm("wdr")
counter=0;
if (durflag==1){ 
while ((argument[counter]!='\r')&&(counter<=12)){
#asm("cli")
eealarmphone[counter] = argument[counter];
#asm("sei")
#asm("wdr")
alarmphone[counter] = argument[counter];
counter++;
}
statusSMSOK();
}
}else if(strstr(comand,reley1command)!=0){
reley1ontime=0;
if ( (argument[0] >= '0') && (argument[0] <= '9') ){ 
reley1ontime=argument[0]-'0';
#asm("wdr") 
if ( (argument[1] >= '0') && (argument[1] <= '9') ){
reley1ontime*=10;
#asm("wdr") 
reley1ontime+=argument[1]-'0';
#asm("wdr")
if ( (argument[2] >= '0') && (argument[2] <= '9') ){
reley1ontime*=10;
#asm("wdr") 
reley1ontime+=argument[2]-'0';
#asm("wdr")
}else if  (argument[2] == 'M')  
reley1ontime*=60;
#asm("wdr")
}else if  (argument[1] == 'M') { 
reley1ontime*=60;
};    
};
#asm("wdr") 
if (reley1ontime>0){
#asm("cli")
reley1counter= reley1ontime;
#asm("sei")
}else{
#asm("cli")
reley1counter = reley1delay;
#asm("sei")
}
#asm("wdr")     
}else if(strstr(comand,reley2command)!=0){
reley1ontime=0;
if ( (argument[0] >= '0') && (argument[0] <= '9') ){ 
reley2ontime=argument[0]-'0';
#asm("wdr") 
if ( (argument[1] >= '0') && (argument[1] <= '9') ){
reley2ontime*=10;
#asm("wdr") 
reley2ontime+=argument[1]-'0';
#asm("wdr")
if ( (argument[2] >= '0') && (argument[2] <= '9') ){
reley2ontime*=10;
#asm("wdr") 
reley2ontime+=argument[2]-'0';
#asm("wdr")
}else if  (argument[2] == 'M')  
reley2ontime*=60;
#asm("wdr")
}else if  (argument[1] == 'M') { 
reley2ontime*=60;
};    
};
#asm("wdr") 
if (reley2ontime>0){
#asm("cli")
reley2counter= reley2ontime;
#asm("sei")
}else{
#asm("cli")
reley2counter = reley2delay;
#asm("sei")
}
#asm("wdr")     
}else if(strstr(comand,reley3command)!=0){
reley3ontime=0;
if ( (argument[0] >= '0') && (argument[0] <= '9') ){ 
reley3ontime=argument[0]-'0';
#asm("wdr") 
if ( (argument[1] >= '0') && (argument[1] <= '9') ){
reley3ontime*=10;
#asm("wdr") 
reley3ontime+=argument[1]-'0';
#asm("wdr")
if ( (argument[2] >= '0') && (argument[2] <= '9') ){
reley3ontime*=10;
#asm("wdr") 
reley3ontime+=argument[2]-'0';
#asm("wdr")
}else if  (argument[2] == 'M')  
reley3ontime*=60;
#asm("wdr")
}else if  (argument[1] == 'M') { 
reley3ontime*=60;
};    
};
#asm("wdr") 
if (reley3ontime>0){
#asm("cli")
reley3counter= reley3ontime;
#asm("sei")
}else{
#asm("cli")
reley3counter = reley3delay;
#asm("sei")
}
#asm("wdr")
statusSMSOK();     
}else if(strstr(comand,reley4command)!=0){
reley4ontime=0;
if ( (argument[0] >= '0') && (argument[0] <= '9') ){ 
reley4ontime=argument[0]-'0';
#asm("wdr") 
if ( (argument[1] >= '0') && (argument[1] <= '9') ){
reley4ontime*=10;
#asm("wdr") 
reley4ontime+=argument[1]-'0';
#asm("wdr")
if ( (argument[2] >= '0') && (argument[2] <= '9') ){
reley4ontime*=10;
#asm("wdr") 
reley4ontime+=argument[2]-'0';
#asm("wdr")
}else if  (argument[2] == 'M')  
reley4ontime*=60;
#asm("wdr")
}else if  (argument[1] == 'M') { 
reley4ontime*=60;
};    
};
#asm("wdr") 
if (reley4ontime>0){
#asm("cli")
reley4counter= reley4ontime;
#asm("sei")
}else{
#asm("cli")
reley4counter = reley4delay;
#asm("sei")
}
#asm("wdr")
statusSMSOK(); 
}
}else{
if(strstr(ptr_to_ram,reley1command)!=0){
#asm("cli")
reley1counter=reley1delay;
#asm("sei")
}else if(strstr(ptr_to_ram,reley2command)!=0){
#asm("cli")
reley2counter=reley2delay;
#asm("sei")
}else if(strstr(ptr_to_ram,reley3command)!=0){
#asm("cli")
reley3counter=reley3delay;
#asm("sei")
}else if(strstr(ptr_to_ram,reley4command)!=0){
#asm("cli")
reley4counter=reley4delay;
#asm("sei")
}
}
} 
}
}
#asm("wdr")
}

#pragma used+
void sleep_enable(void);
void sleep_disable(void);
void idle(void);

void powerdown(void);

void powersave(void);

void standby(void);

void extended_standby(void);
#pragma used-

#pragma library sleep.lib

void main(void)
{

#pragma optsize-
(*(unsigned char *) 0x61)=0x80;
(*(unsigned char *) 0x61)=0x00;
#pragma optsize+

PORTB=0x00;
DDRB=0x3F;

PORTC=0x00;
DDRC=0x07;

PORTD=0x00;
DDRD=0x40;

TCCR0A=0x00;
TCCR0B=0x00;
TCNT0=0x00;
OCR0A=0x00;
OCR0B=0x00;

(*(unsigned char *) 0x80)=0x00;
(*(unsigned char *) 0x81)=0x05;

(*(unsigned char *) 0x85)=0xC2;
(*(unsigned char *) 0x84)=0xF7; 

(*(unsigned char *) 0x87)=0x00;
(*(unsigned char *) 0x86)=0x00;
(*(unsigned char *) 0x89)=0x00;
(*(unsigned char *) 0x88)=0x00;
(*(unsigned char *) 0x8b)=0x00;
(*(unsigned char *) 0x8a)=0x00;

(*(unsigned char *) 0xb6)=0x00;
(*(unsigned char *) 0xb0)=0x00;
(*(unsigned char *) 0xb1)=0x00;
(*(unsigned char *) 0xb2)=0x00;
(*(unsigned char *) 0xb3)=0x00;
(*(unsigned char *) 0xb4)=0x00;

(*(unsigned char *) 0x69)=0x0C;
EIMSK=0x02;
EIFR=0x02;
(*(unsigned char *) 0x68)=0x00;

(*(unsigned char *) 0x6e)=0x00;

(*(unsigned char *) 0x6f)=0x01;

(*(unsigned char *) 0x70)=0x00;

(*(unsigned char *) 0xc0)=0x00;
(*(unsigned char *) 0xc1)=0x98;
(*(unsigned char *) 0xc2)=0x06;
(*(unsigned char *) 0xc5)=0x00;
(*(unsigned char *) 0xc4)=0x67; 

ACSR=0x80;
(*(unsigned char *) 0x7b)=0x00;

(*(unsigned char *) 0x7e)=0x37;
(*(unsigned char *) 0x7c)=0xC0 & 0xff;
(*(unsigned char *) 0x7a)=0xA7;
(*(unsigned char *) 0x7b)&=0xF8;

#pragma optsize-
#asm("wdr")
(*(unsigned char *) 0x60)=0x39;
(*(unsigned char *) 0x60)=0x29;
#pragma optsize+

#asm("wdr")

PORTB.2 =0;
PORTB.3=0; 
PORTB.4 =0;
PORTB.5=0; 

reley1counter=0;
reley2counter=0;
reley3counter=0;
reley4counter=0;

#asm("wdr")        
eeprom2var();

#asm("sei")
m590init();
sleep_enable();
count10min=0;
count1dey=0;
alarmsending=0;
lovlevelbat=0;
lovbatsending=0;
#asm("cli")
alarmflag=0;
flag1sec=0;
#asm("sei")

while (1)
{
if (rx_counter0==0) idle();
#asm("wdr")
#asm("wdr")

if (rx_buffer_overflow0==1) clearFIFO();
#asm("wdr")

if (alarmflag){

PORTC.2=1;
#asm("cli")
alarmflag=0;
alarmimeout=2; 
#asm("sei")
while (alarmimeout!=0){
#asm("wdr")
};

if(PIND.7==1){
clearFIFO(); 
PORTD.6=1;
delay_ms(200);
#asm("wdr")
while(1) {
netststus=netstatusM590();
if (netststus==255) resetsistem();
if(netststus==1) break;
if(netststus==5) break;
PORTC.2=0;
delay_ms(500);
#asm("wdr")
delay_ms(500);
#asm("wdr")
PORTC.2=1;
delay_ms(500);
#asm("wdr")
delay_ms(500);
#asm("wdr")
};
#asm("wdr")

PORTC.2=1;
#asm("wdr")
countalarmdial=2;

do {
PORTC.2=1;
if (alarmDial()==0) break;
#asm("wdr")
countalarmdial--;
PORTC.2=0;
}while (countalarmdial>0);

if ((PIND.4==1)||(PIND.5==0)) alarmsending=0;
if (alarmsending==0){
alarmSMS();
#asm("wdr")
}

PORTD.6=0;
PORTC.2=0;
}
PORTC.2=0;
}else if (rx_counter0!=0) {
PORTD.6=1;
PORTC.2=1;

getstring(RX_text,254);

if (ansvercmp(RX_text, "+CMT")==0){ 
parseSMS();
#asm("wdr")
}else if (ansvercmp(RX_text, "RING")==0){ 
m590command("ATH");
#asm("wdr")
}; 

delay_ms(200);
PORTC.2=0;
#asm("wdr")
PORTD.6=0;
}else if (flag1sec){
#asm("cli")
flag1sec=0;
#asm("sei")

#asm("wdr")
if  (count10min==600) {  
count10min=0;

PORTC.2=1;
#asm("wdr")
PORTD.6=1;
delay_ms(200);
#asm("wdr")
delay_ms(200);
#asm("wdr")
delay_ms(200);
#asm("wdr")
delay_ms(200);
#asm("wdr")

if (m590command("AT")==255) resetsistem();
if ((reley1counter==0)&&(reley2counter==0)&&(reley3counter==0)&&(reley4counter==0)) count1dey++;
if (count1dey==144){  
#asm("wdr")

m590command("AT+CMGD=1,4");
resetsistem();
} 
#asm("wdr")
if (PIND.4==0) {
adcdata=read_adc(); 
#asm("wdr")
volt = (float) adcdata * voltdev;
if (volt>11.7){ 
lovbatsending=0;
lovlevelbat=0;
}else { 
if ((lovlevelbat==1)&&(lovbatsending==0)){
delay_ms(200);
#asm("wdr")
clearFIFO();
counter=0;
for (counter=0; counter<=strlen(alarmphone); counter++){
phone[counter] = alarmphone[counter];
#asm("wdr")
}
while(1) {
netststus=netstatusM590();
if (netststus==255) resetsistem();
if(netststus==1) break;
if(netststus==5) break;
PORTC.2=0;
delay_ms(500);
#asm("wdr")
delay_ms(500);
#asm("wdr")
PORTC.2=1;
delay_ms(500);
#asm("wdr")
delay_ms(500);
#asm("wdr")
};
statusSMS();
#asm("wdr")
lovbatsending=1;
}
lovlevelbat=1;
}
}
PORTD.6=0;
PORTC.2=0;
} else count10min++;

#asm("wdr")

if (alarmsending==1){
#asm("wdr")
countalarmsend++;
if  (countalarmsend>=180) { 
countalarmsend=0;
alarmsending=0;
}
}
#asm("wdr")
}
#asm("wdr")
};
}
