
;CodeVisionAVR C Compiler V2.03.4 Standard
;(C) Copyright 1998-2008 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type              : ATmega328P
;Program type           : Application
;Clock frequency        : 16,000000 MHz
;Memory model           : Small
;Optimize for           : Size
;(s)printf features     : int, width
;(s)scanf features      : int, width
;External RAM size      : 0
;Data Stack size        : 512 byte(s)
;Heap size              : 0 byte(s)
;Promote char to int    : Yes
;char is unsigned       : Yes
;global const stored in FLASH  : No
;8 bit enums            : Yes
;Enhanced core instructions    : On
;Smart register allocation : On
;Automatic register allocation : On

	#pragma AVRPART ADMIN PART_NAME ATmega328P
	#pragma AVRPART MEMORY PROG_FLASH 32768
	#pragma AVRPART MEMORY EEPROM 1024
	#pragma AVRPART MEMORY INT_SRAM SIZE 2048
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x100

	.LISTMAC
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU EECR=0x1F
	.EQU EEDR=0x20
	.EQU EEARL=0x21
	.EQU EEARH=0x22
	.EQU SPSR=0x2D
	.EQU SPDR=0x2E
	.EQU SMCR=0x33
	.EQU MCUSR=0x34
	.EQU MCUCR=0x35
	.EQU WDTCSR=0x60
	.EQU UCSR0A=0xC0
	.EQU UDR0=0xC6
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F
	.EQU GPIOR0=0x1E

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+@1
	ANDI R30,LOW(@2)
	STS  @0+@1,R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+@1
	ANDI R30,LOW(@2)
	STS  @0+@1,R30
	LDS  R30,@0+@1+1
	ANDI R30,HIGH(@2)
	STS  @0+@1+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+@1
	ORI  R30,LOW(@2)
	STS  @0+@1,R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+@1
	ORI  R30,LOW(@2)
	STS  @0+@1,R30
	LDS  R30,@0+@1+1
	ORI  R30,HIGH(@2)
	STS  @0+@1+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __CLRD1S
	LDI  R30,0
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+@1)
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+@1)
	LDI  R31,HIGH(@0+@1)
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	LDI  R22,BYTE3(2*@0+@1)
	LDI  R23,BYTE4(2*@0+@1)
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+@1)
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+@2)
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+@3)
	LDI  R@1,HIGH(@2+@3)
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+@3)
	LDI  R@1,HIGH(@2*2+@3)
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+@1
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+@1
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	LDS  R22,@0+@1+2
	LDS  R23,@0+@1+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+@2
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+@3
	LDS  R@1,@2+@3+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+@1
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+@1
	LDS  R27,@0+@1+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+@1
	LDS  R27,@0+@1+1
	LDS  R24,@0+@1+2
	LDS  R25,@0+@1+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+@1,R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+@1,R30
	STS  @0+@1+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+@1,R30
	STS  @0+@1+1,R31
	STS  @0+@1+2,R22
	STS  @0+@1+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	CALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	CALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	CALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+@1,R0
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+@1,R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+@1,R@2
	STS  @0+@1+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	CALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	CALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	CALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	CLR  R0
	ST   Z+,R0
	ST   Z,R0
	.ENDM

	.MACRO __CLRD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	CLR  R0
	ST   Z+,R0
	ST   Z+,R0
	ST   Z+,R0
	ST   Z,R0
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R@1
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRR0
	MULS R@0,R@1
	.ENDM

	.MACRO __MULBRRU0
	MUL  R@0,R@1
	.ENDM

	.MACRO __MULBNWRU
	LDI  R26,@2
	MUL  R26,R@0
	MOVW R30,R0
	MUL  R26,R@1
	ADD  R31,R0
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _flag1sec=R5
	.DEF _count10min=R6
	.DEF _count1dey=R8
	.DEF _countalarmsend=R10
	.DEF _countalarmdial=R4
	.DEF _counter=R13
	.DEF _netststus=R12

	.CSEG
	.ORG 0x00

;INTERRUPT VECTORS
	JMP  __RESET
	JMP  0x00
	JMP  _ext_int1_isr
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  _timer1_ovf_isr
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  _usart_rx_isr
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00

_tbl10_G101:
	.DB  0x10,0x27,0xE8,0x3,0x64,0x0,0xA,0x0
	.DB  0x1,0x0
_tbl16_G101:
	.DB  0x0,0x10,0x0,0x1,0x10,0x0,0x1,0x0

;GPIOR0 INITIALIZATION
	.EQU  __GPIOR0_INIT=0x00

_0x0:
	.DB  0x4F,0x4B,0x0,0x45,0x52,0x52,0x4F,0x52
	.DB  0x0,0xD,0xA,0x0,0x41,0x54,0x2B,0x43
	.DB  0x52,0x45,0x47,0x3F,0xD,0x0,0x41,0x54
	.DB  0x2B,0x43,0x52,0x45,0x47,0x3F,0x0,0x2B
	.DB  0x43,0x52,0x45,0x47,0x3A,0x0,0x2C,0x30
	.DB  0x0,0x2C,0x31,0x0,0x2C,0x32,0x0,0x2C
	.DB  0x33,0x0,0x2C,0x34,0x0,0x2C,0x35,0x0
	.DB  0x4D,0x4F,0x44,0x45,0x4D,0x3A,0x53,0x54
	.DB  0x41,0x52,0x54,0x55,0x50,0x0,0x2B,0x50
	.DB  0x42,0x52,0x45,0x41,0x44,0x59,0x0,0x41
	.DB  0x54,0x0,0x41,0x54,0x45,0x31,0x0,0x41
	.DB  0x54,0x2B,0x43,0x4C,0x49,0x50,0x3D,0x30
	.DB  0x0,0x41,0x54,0x2B,0x43,0x4D,0x47,0x46
	.DB  0x3D,0x31,0x0,0x41,0x54,0x2B,0x43,0x53
	.DB  0x43,0x53,0x3D,0x22,0x47,0x53,0x4D,0x22
	.DB  0x0,0x41,0x54,0x2B,0x43,0x4E,0x4D,0x49
	.DB  0x3D,0x32,0x2C,0x32,0x0,0x41,0x54,0x2B
	.DB  0x45,0x4E,0x50,0x57,0x52,0x53,0x41,0x56
	.DB  0x45,0x3D,0x31,0x0,0x41,0x54,0x44,0x25
	.DB  0x73,0x3B,0xD,0x0,0x41,0x54,0x44,0x0
	.DB  0x43,0x4F,0x4E,0x4E,0x45,0x43,0x54,0x0
	.DB  0x41,0x54,0x48,0x0,0x4E,0x4F,0x20,0x43
	.DB  0x41,0x52,0x52,0x49,0x45,0x52,0x0,0x42
	.DB  0x55,0x53,0x59,0x0,0x4E,0x4F,0x20,0x41
	.DB  0x4E,0x53,0x57,0x45,0x52,0x0,0x41,0x54
	.DB  0x2B,0x43,0x4D,0x47,0x53,0x3D,0x22,0x25
	.DB  0x73,0x22,0xD,0x0,0x41,0x4C,0x41,0x52
	.DB  0x4D,0x3A,0x20,0x0,0x49,0x47,0x4E,0x49
	.DB  0x54,0x49,0x4F,0x4E,0x20,0x4F,0x4E,0x21
	.DB  0x0,0x44,0x4F,0x4F,0x52,0x20,0x4F,0x50
	.DB  0x45,0x4E,0x21,0x0,0x53,0x48,0x4F,0x43
	.DB  0x4B,0x21,0x0,0x53,0x54,0x41,0x54,0x55
	.DB  0x53,0x3A,0x20,0x0,0x41,0x4C,0x4C,0x41
	.DB  0x52,0x4D,0x2C,0x20,0x0,0x4E,0x4F,0x20
	.DB  0x41,0x4C,0x4C,0x41,0x52,0x4D,0x2C,0x20
	.DB  0x0,0x49,0x47,0x4E,0x49,0x54,0x49,0x4F
	.DB  0x4E,0x20,0x4F,0x4E,0x2C,0x20,0x0,0x49
	.DB  0x47,0x4E,0x49,0x54,0x49,0x4F,0x4E,0x20
	.DB  0x4F,0x46,0x46,0x2C,0x20,0x0,0x44,0x4F
	.DB  0x4F,0x52,0x20,0x4F,0x50,0x45,0x4E,0x2C
	.DB  0x20,0x0,0x44,0x4F,0x4F,0x52,0x20,0x43
	.DB  0x4C,0x4F,0x53,0x45,0x2C,0x20,0x0,0x56
	.DB  0x4F,0x4C,0x54,0x41,0x47,0x45,0x3A,0x20
	.DB  0x25,0x73,0x56,0x0,0x43,0x4F,0x4D,0x4D
	.DB  0x41,0x4E,0x44,0x20,0x4F,0x4B,0x0,0x41
	.DB  0x54,0x2B,0x43,0x4E,0x4D,0x49,0x3D,0x30
	.DB  0x2C,0x30,0x0,0x2B,0x43,0x55,0x53,0x44
	.DB  0x0,0x42,0x49,0x4C,0x4C,0x49,0x4E,0x47
	.DB  0x3A,0x25,0x73,0x0,0x48,0x45,0x4C,0x50
	.DB  0x3A,0x20,0x0,0x22,0x2A,0x70,0x61,0x73
	.DB  0x77,0x23,0x53,0x54,0x41,0x54,0x55,0x53
	.DB  0x22,0x20,0x0,0x22,0x2A,0x70,0x61,0x73
	.DB  0x77,0x23,0x42,0x49,0x4C,0x4C,0x49,0x4E
	.DB  0x47,0x22,0x20,0x0,0x22,0x2A,0x70,0x61
	.DB  0x73,0x77,0x23,0x42,0x41,0x4C,0x41,0x4E
	.DB  0x53,0x22,0x20,0x0,0x22,0x2A,0x70,0x61
	.DB  0x73,0x77,0x23,0x52,0x45,0x4C,0x45,0x59
	.DB  0x22,0x20,0x0,0x22,0x2A,0x70,0x61,0x73
	.DB  0x77,0x23,0x52,0x45,0x4C,0x45,0x59,0x3A
	.DB  0x30,0x32,0x22,0x20,0x0,0x22,0x2A,0x70
	.DB  0x61,0x73,0x77,0x23,0x52,0x45,0x4C,0x45
	.DB  0x59,0x3A,0x30,0x32,0x4D,0x22,0x20,0x0
	.DB  0x52,0x45,0x4C,0x45,0x59,0x3A,0x20,0x25
	.DB  0x73,0x2C,0x0,0x25,0x73,0x20,0x0,0x53
	.DB  0x54,0x41,0x54,0x55,0x53,0x0,0x42,0x41
	.DB  0x4C,0x41,0x4E,0x53,0x0,0x42,0x49,0x4C
	.DB  0x4C,0x49,0x4E,0x47,0x0,0x48,0x45,0x4C
	.DB  0x50,0x0,0x53,0x45,0x54,0x50,0x41,0x53
	.DB  0x53,0x0,0x53,0x45,0x54,0x50,0x48,0x4F
	.DB  0x4E,0x45,0x0,0x2B,0x43,0x4D,0x54,0x0
	.DB  0x52,0x49,0x4E,0x47,0x0,0x41,0x54,0x2B
	.DB  0x43,0x4D,0x47,0x44,0x3D,0x31,0x2C,0x34
	.DB  0x0
_0x204005F:
	.DB  0x1
_0x2040000:
	.DB  0x2D,0x4E,0x41,0x4E,0x0

__GLOBAL_INI_TBL:
	.DW  0x01
	.DW  __seed_G102
	.DW  _0x204005F*2

_0xFFFFFFFF:
	.DW  0

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  MCUCR,R31
	OUT  MCUCR,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	WDR
	IN   R26,MCUSR
	CBR  R26,8
	OUT  MCUSR,R26
	STS  WDTCSR,R31
	STS  WDTCSR,R30

;CLEAR R2-R14
	LDI  R24,(14-2)+1
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(0x800)
	LDI  R25,HIGH(0x800)
	LDI  R26,LOW(0x100)
	LDI  R27,HIGH(0x100)
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;GPIOR0 INITIALIZATION
	LDI  R30,__GPIOR0_INIT
	OUT  GPIOR0,R30

;STACK POINTER INITIALIZATION
	LDI  R30,LOW(0x8FF)
	OUT  SPL,R30
	LDI  R30,HIGH(0x8FF)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(0x300)
	LDI  R29,HIGH(0x300)

	JMP  _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x300

	.CSEG
;/*****************************************************
;This program was produced by the
;CodeWizardAVR V2.03.4 Standard
;Automatic Program Generator
; Copyright 1998-2008 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com
;
;Project :
;Version : 2
;Date    : 09.02.2016
;Author  :
;Company :
;Comments:
;
;
;Chip type           : ATmega328P/ATmega168P
;Program type        : Application
;Clock frequency     : 16,000000 MHz / 8Mhz
;
;Memory model        : Small
;External RAM size   : 0
;Data Stack size     : 512
;*****************************************************/
;
;
;//#define M168P //ATmega168P
;//#define C8MHZ  //8MHZ
;
;
;
;#ifdef M168P
;#include <mega168p.h>
;#else
;#include <mega328p.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x01
	.EQU __sm_mask=0x0E
	.EQU __sm_adc_noise_red=0x02
	.EQU __sm_powerdown=0x04
	.EQU __sm_powersave=0x06
	.EQU __sm_standby=0x0C
	.EQU __sm_ext_standby=0x0E
	.SET power_ctrl_reg=smcr
	#endif
;#endif
;
;#define M590_POWERPIN PORTB.0
;#define M590_ONPIN PORTB.1
;#define M590_SLEEPPIN PORTD.6
;
;
;#define RELEY1PIN PORTB.2
;#define RELEY2PIN PORTB.3
;#define RELEY3PIN PORTB.4
;#define RELEY4PIN PORTB.5
;
;#define ALARMPIN PIND.7
;#define IGNITION PIND.4
;#define DOORPIN PIND.5
;
;#define LEDPIN PORTC.2
;
;#ifdef M168P
;#define RXFIFO_BUFFER_SIZE0 240
;#define RXbufersize 200
;#else
;#define RXFIFO_BUFFER_SIZE0 512
;#define RXbufersize 254
;#endif
;
;#define tmpbufsize 64
;
;
;char RX_text[RXbufersize];
;char RX_text_tmp[tmpbufsize];
;
;
;bit alarmflag;
;bit alarmsending;
;bit lovbatsending;
;bit lovlevelbat;
;
;unsigned char  flag1sec;
;
;unsigned int  count10min;
;unsigned int  count1dey;
;unsigned int  countalarmsend;
;unsigned char countalarmdial;
;
;
;char counter,netststus;
;unsigned char uarttimeout;
;unsigned char alarmimeout;
;
;unsigned int adcdata;
;float volt;
;char voltstr[6];
;
;unsigned char masterpass[5];
;unsigned char userpass[5];
;unsigned char alarmphone[13];
;unsigned char ballanscomand[9];
;unsigned char reley1command[7];
;unsigned char reley1delay;
;unsigned int reley1ontime;
;unsigned int reley1counter;
;unsigned char reley2command[7];
;unsigned char reley2delay;
;unsigned int reley2ontime;
;unsigned int reley2counter;
;unsigned char reley3command[7];
;unsigned char reley3delay;
;unsigned int reley3ontime;
;unsigned int reley3counter;
;unsigned char reley4command[7];
;unsigned char reley4delay;
;unsigned int reley4ontime;
;unsigned int reley4counter;
;unsigned char phone[13];
;
;//#pragma warn-
;unsigned char eeprom eemasterpass[5] ="WE32";
;unsigned char eeprom eeuserpass[5] ="1234";
;unsigned char eeprom eealarmphone[13] ="+70000000000" ;
;unsigned char eeprom eeballanscomand[9] ="*100#";
;unsigned char eeprom eereley1command[7] ="OPEN";
;unsigned char eeprom eereley1delay=1;
;unsigned char eeprom eereley2command[7] ="CLOSE";
;unsigned char eeprom eereley2delay=1;
;unsigned char eeprom eereley3command[7] ="HEAT";
;unsigned char eeprom eereley3delay=240;
;unsigned char eeprom eereley4command[7] ="CAM";
;unsigned char eeprom eereley4delay=240;
;
;float eeprom voltdev =0.02685546875; // 1/25-devider(1k+24k)  1.1V/1024*25=0.02685546875
;//#pragma warn+
;
;
;
;// External Interrupt 1 service routine
;interrupt [EXT_INT1] void ext_int1_isr(void)
; 0000 0084 {

	.CSEG
_ext_int1_isr:
; 0000 0085 //ALARM
; 0000 0086     alarmflag=1;
	SBI  0x1E,0
; 0000 0087 }
	RETI
;
;
;#define RXB8 1
;#define TXB8 0
;#define UPE 2
;#define OVR 3
;#define FE 4
;#define UDRE 5
;#define RXC 7
;
;#define FRAMING_ERROR (1<<FE)
;#define PARITY_ERROR (1<<UPE)
;#define DATA_OVERRUN (1<<OVR)
;#define DATA_REGISTER_EMPTY (1<<UDRE)
;#define RX_COMPLETE (1<<RXC)
;
;// USART Receiver buffer
;
;char rx_buffer0[RXFIFO_BUFFER_SIZE0];
;
;#if RXFIFO_BUFFER_SIZE0<256
;unsigned char rx_wr_index0,rx_rd_index0,rx_counter0;
;#else
;unsigned int rx_wr_index0,rx_rd_index0,rx_counter0;
;#endif
;
;// This flag is set on USART Receiver buffer overflow
;bit rx_buffer_overflow0;
;
;// USART Receiver interrupt service routine
;interrupt [USART_RXC] void usart_rx_isr(void)
; 0000 00A7 {
_usart_rx_isr:
	ST   -Y,R26
	ST   -Y,R27
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 00A8     char status,data;
; 0000 00A9     status=UCSR0A;
	ST   -Y,R17
	ST   -Y,R16
;	status -> R17
;	data -> R16
	LDS  R17,192
; 0000 00AA     data=UDR0;
	LDS  R16,198
; 0000 00AB 
; 0000 00AC 
; 0000 00AD     if ((status & (FRAMING_ERROR | PARITY_ERROR | DATA_OVERRUN))==0){
	CALL SUBOPT_0x0
	LDI  R30,LOW(28)
	LDI  R31,HIGH(28)
	AND  R30,R26
	AND  R31,R27
	SBIW R30,0
	BRNE _0x5
; 0000 00AE         rx_buffer0[rx_wr_index0]=data;
	LDS  R30,_rx_wr_index0
	LDS  R31,_rx_wr_index0+1
	SUBI R30,LOW(-_rx_buffer0)
	SBCI R31,HIGH(-_rx_buffer0)
	ST   Z,R16
; 0000 00AF         if (++rx_wr_index0 == RXFIFO_BUFFER_SIZE0) rx_wr_index0=0;
	LDI  R26,LOW(_rx_wr_index0)
	LDI  R27,HIGH(_rx_wr_index0)
	CALL SUBOPT_0x1
	BRNE _0x6
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	STS  _rx_wr_index0,R30
	STS  _rx_wr_index0+1,R31
; 0000 00B0         if (++rx_counter0 == RXFIFO_BUFFER_SIZE0){
_0x6:
	LDI  R26,LOW(_rx_counter0)
	LDI  R27,HIGH(_rx_counter0)
	CALL SUBOPT_0x1
	BRNE _0x7
; 0000 00B1             rx_counter0=0;
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	STS  _rx_counter0,R30
	STS  _rx_counter0+1,R31
; 0000 00B2             rx_buffer_overflow0=1;
	SBI  0x1E,4
; 0000 00B3         };
_0x7:
; 0000 00B4     };
_0x5:
; 0000 00B5 }
	LD   R16,Y+
	LD   R17,Y+
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	RETI
;
;#ifndef _DEBUG_TERMINAL_IO_
;// Get a character from the USART Receiver buffer
;#define _ALTERNATE_GETCHAR_
;#pragma used+
;char getchar(void)
; 0000 00BC {
_getchar:
; 0000 00BD     char data;
; 0000 00BE     while (rx_counter0==0) {
	ST   -Y,R17
;	data -> R17
_0xA:
	CALL SUBOPT_0x2
	BRNE _0xC
; 0000 00BF 
; 0000 00C0         #asm("wdr")
	wdr
; 0000 00C1     };
	RJMP _0xA
_0xC:
; 0000 00C2 
; 0000 00C3     data=rx_buffer0[rx_rd_index0];
	CALL SUBOPT_0x3
; 0000 00C4     #asm("wdr")
	wdr
; 0000 00C5     if (++rx_rd_index0 == RXFIFO_BUFFER_SIZE0) rx_rd_index0=0;
	CALL SUBOPT_0x4
	BRNE _0xD
	CALL SUBOPT_0x5
; 0000 00C6     #asm("cli")
_0xD:
	cli
; 0000 00C7     --rx_counter0;
	CALL SUBOPT_0x6
; 0000 00C8     #asm("sei")
	sei
; 0000 00C9 
; 0000 00CA     #asm("wdr")
	wdr
; 0000 00CB return data;
	MOV  R30,R17
	RJMP _0x20C000B
; 0000 00CC }
;#pragma used-
;#endif
;
;
;
;
;// Timer 1 overflow interrupt service routine
;interrupt [TIM1_OVF] void timer1_ovf_isr(void)
; 0000 00D5 {
_timer1_ovf_isr:
	ST   -Y,R0
	ST   -Y,R26
	ST   -Y,R27
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 00D6 #ifdef C8MHZ
; 0000 00D7     TCNT1H=0xE1;
; 0000 00D8     TCNT1L=0x7B; //1Hz for 8MHz
; 0000 00D9 #else
; 0000 00DA     TCNT1H=0xC2;
	CALL SUBOPT_0x7
; 0000 00DB     TCNT1L=0xF7; //1Hz for 16MHz
; 0000 00DC #endif
; 0000 00DD     if (uarttimeout>0)
	LDS  R26,_uarttimeout
	CPI  R26,LOW(0x1)
	BRLO _0xE
; 0000 00DE         uarttimeout--;
	LDS  R30,_uarttimeout
	SUBI R30,LOW(1)
	STS  _uarttimeout,R30
; 0000 00DF     if (alarmimeout>0)
_0xE:
	LDS  R26,_alarmimeout
	CPI  R26,LOW(0x1)
	BRLO _0xF
; 0000 00E0         alarmimeout--;
	LDS  R30,_alarmimeout
	SUBI R30,LOW(1)
	STS  _alarmimeout,R30
; 0000 00E1 
; 0000 00E2     if (reley1counter>0){reley1counter--; RELEY1PIN =1;} else  RELEY1PIN =0;
_0xF:
	LDS  R26,_reley1counter
	LDS  R27,_reley1counter+1
	CALL __CPW02
	BRSH _0x10
	LDI  R26,LOW(_reley1counter)
	LDI  R27,HIGH(_reley1counter)
	CALL SUBOPT_0x8
	SBI  0x5,2
	RJMP _0x13
_0x10:
	CBI  0x5,2
; 0000 00E3     if (reley2counter>0){reley2counter--; RELEY2PIN =1;} else  RELEY2PIN =0;
_0x13:
	LDS  R26,_reley2counter
	LDS  R27,_reley2counter+1
	CALL __CPW02
	BRSH _0x16
	LDI  R26,LOW(_reley2counter)
	LDI  R27,HIGH(_reley2counter)
	CALL SUBOPT_0x8
	SBI  0x5,3
	RJMP _0x19
_0x16:
	CBI  0x5,3
; 0000 00E4     if (reley3counter>0){reley3counter--; RELEY3PIN =1;} else  RELEY3PIN =0;
_0x19:
	LDS  R26,_reley3counter
	LDS  R27,_reley3counter+1
	CALL __CPW02
	BRSH _0x1C
	LDI  R26,LOW(_reley3counter)
	LDI  R27,HIGH(_reley3counter)
	CALL SUBOPT_0x8
	SBI  0x5,4
	RJMP _0x1F
_0x1C:
	CBI  0x5,4
; 0000 00E5     if (reley4counter>0){reley4counter--; RELEY4PIN =1;} else  RELEY4PIN =0;
_0x1F:
	LDS  R26,_reley4counter
	LDS  R27,_reley4counter+1
	CALL __CPW02
	BRSH _0x22
	LDI  R26,LOW(_reley4counter)
	LDI  R27,HIGH(_reley4counter)
	CALL SUBOPT_0x8
	SBI  0x5,5
	RJMP _0x25
_0x22:
	CBI  0x5,5
; 0000 00E6 
; 0000 00E7     flag1sec=1;//1sec
_0x25:
	LDI  R30,LOW(1)
	MOV  R5,R30
; 0000 00E8 
; 0000 00E9 }
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	LD   R0,Y+
	RETI
;
;#include <delay.h>
;
;
;#define ADC_VREF_TYPE 0xC0
;
;// Read the AD conversion result
;unsigned int read_adc(void)
; 0000 00F2 {
_read_adc:
; 0000 00F3     ADMUX= 3 | (ADC_VREF_TYPE & 0xff);    //ADC3
	LDI  R30,LOW(195)
	STS  124,R30
; 0000 00F4     #asm("wdr")
	wdr
; 0000 00F5     // Delay needed for the stabilization of the ADC input voltage
; 0000 00F6     delay_us(10);
	__DELAY_USB 53
; 0000 00F7     #asm("wdr")
	wdr
; 0000 00F8     // Start the AD conversion
; 0000 00F9     ADCSRA|=0x40;
	CALL SUBOPT_0x9
	ORI  R30,0x40
	ST   X,R30
; 0000 00FA     // Wait for the AD conversion to complete
; 0000 00FB     while ((ADCSRA & 0x10)==0) { #asm("wdr") };
_0x28:
	LDS  R30,122
	LDI  R31,0
	ANDI R30,LOW(0x10)
	BRNE _0x2A
	wdr
	RJMP _0x28
_0x2A:
; 0000 00FC     ADCSRA|=0x10;
	CALL SUBOPT_0x9
	ORI  R30,0x10
	ST   X,R30
; 0000 00FD return ADCW;
	LDS  R30,120
	LDS  R31,120+1
	RET
; 0000 00FE }
;
;
;
;
;void eeprom2var (void){
; 0000 0103 void eeprom2var (void){
_eeprom2var:
; 0000 0104     unsigned char counter;
; 0000 0105     counter=0;
	ST   -Y,R17
;	counter -> R17
	LDI  R17,LOW(0)
; 0000 0106 
; 0000 0107     while (eemasterpass[counter]){
_0x2B:
	CALL SUBOPT_0x0
	SUBI R26,LOW(-_eemasterpass)
	SBCI R27,HIGH(-_eemasterpass)
	CALL __EEPROMRDB
	CPI  R30,0
	BREQ _0x2D
; 0000 0108         masterpass[counter] = eemasterpass[counter];
	CALL SUBOPT_0xA
	SUBI R30,LOW(-_masterpass)
	SBCI R31,HIGH(-_masterpass)
	MOVW R0,R30
	CALL SUBOPT_0x0
	SUBI R26,LOW(-_eemasterpass)
	SBCI R27,HIGH(-_eemasterpass)
	CALL SUBOPT_0xB
; 0000 0109         counter++;
; 0000 010A         #asm("wdr")
	wdr
; 0000 010B     }
	RJMP _0x2B
_0x2D:
; 0000 010C 
; 0000 010D     counter=0;
	LDI  R17,LOW(0)
; 0000 010E     while (eeuserpass[counter]){
_0x2E:
	CALL SUBOPT_0x0
	SUBI R26,LOW(-_eeuserpass)
	SBCI R27,HIGH(-_eeuserpass)
	CALL __EEPROMRDB
	CPI  R30,0
	BREQ _0x30
; 0000 010F         userpass[counter] = eeuserpass[counter];
	CALL SUBOPT_0xA
	SUBI R30,LOW(-_userpass)
	SBCI R31,HIGH(-_userpass)
	MOVW R0,R30
	CALL SUBOPT_0x0
	SUBI R26,LOW(-_eeuserpass)
	SBCI R27,HIGH(-_eeuserpass)
	CALL SUBOPT_0xB
; 0000 0110         counter++;
; 0000 0111         #asm("wdr")
	wdr
; 0000 0112     }
	RJMP _0x2E
_0x30:
; 0000 0113 
; 0000 0114     counter=0;
	LDI  R17,LOW(0)
; 0000 0115     while (eealarmphone[counter]){
_0x31:
	CALL SUBOPT_0x0
	SUBI R26,LOW(-_eealarmphone)
	SBCI R27,HIGH(-_eealarmphone)
	CALL __EEPROMRDB
	CPI  R30,0
	BREQ _0x33
; 0000 0116         alarmphone[counter] = eealarmphone[counter];
	CALL SUBOPT_0xA
	SUBI R30,LOW(-_alarmphone)
	SBCI R31,HIGH(-_alarmphone)
	MOVW R0,R30
	CALL SUBOPT_0x0
	SUBI R26,LOW(-_eealarmphone)
	SBCI R27,HIGH(-_eealarmphone)
	CALL __EEPROMRDB
	MOVW R26,R0
	ST   X,R30
; 0000 0117         phone[counter] = eealarmphone[counter];
	CALL SUBOPT_0xA
	SUBI R30,LOW(-_phone)
	SBCI R31,HIGH(-_phone)
	MOVW R0,R30
	CALL SUBOPT_0x0
	SUBI R26,LOW(-_eealarmphone)
	SBCI R27,HIGH(-_eealarmphone)
	CALL SUBOPT_0xB
; 0000 0118         counter++;
; 0000 0119         #asm("wdr")
	wdr
; 0000 011A     }
	RJMP _0x31
_0x33:
; 0000 011B 
; 0000 011C     counter=0;
	LDI  R17,LOW(0)
; 0000 011D     while (eeballanscomand[counter]){
_0x34:
	CALL SUBOPT_0x0
	SUBI R26,LOW(-_eeballanscomand)
	SBCI R27,HIGH(-_eeballanscomand)
	CALL __EEPROMRDB
	CPI  R30,0
	BREQ _0x36
; 0000 011E         ballanscomand[counter] = eeballanscomand[counter];
	CALL SUBOPT_0xA
	SUBI R30,LOW(-_ballanscomand)
	SBCI R31,HIGH(-_ballanscomand)
	MOVW R0,R30
	CALL SUBOPT_0x0
	SUBI R26,LOW(-_eeballanscomand)
	SBCI R27,HIGH(-_eeballanscomand)
	CALL SUBOPT_0xB
; 0000 011F         counter++;
; 0000 0120         #asm("wdr")
	wdr
; 0000 0121     }
	RJMP _0x34
_0x36:
; 0000 0122 
; 0000 0123 
; 0000 0124     counter=0;
	LDI  R17,LOW(0)
; 0000 0125     while (eereley1command[counter]){
_0x37:
	CALL SUBOPT_0x0
	SUBI R26,LOW(-_eereley1command)
	SBCI R27,HIGH(-_eereley1command)
	CALL __EEPROMRDB
	CPI  R30,0
	BREQ _0x39
; 0000 0126         reley1command[counter] = eereley1command[counter];
	CALL SUBOPT_0xA
	SUBI R30,LOW(-_reley1command)
	SBCI R31,HIGH(-_reley1command)
	MOVW R0,R30
	CALL SUBOPT_0x0
	SUBI R26,LOW(-_eereley1command)
	SBCI R27,HIGH(-_eereley1command)
	CALL SUBOPT_0xB
; 0000 0127         counter++;
; 0000 0128         #asm("wdr")
	wdr
; 0000 0129     }
	RJMP _0x37
_0x39:
; 0000 012A     reley1delay=eereley1delay;
	LDI  R26,LOW(_eereley1delay)
	LDI  R27,HIGH(_eereley1delay)
	CALL __EEPROMRDB
	STS  _reley1delay,R30
; 0000 012B     #asm("wdr")
	wdr
; 0000 012C 
; 0000 012D     counter=0;
	LDI  R17,LOW(0)
; 0000 012E     while (eereley2command[counter]){
_0x3A:
	CALL SUBOPT_0x0
	SUBI R26,LOW(-_eereley2command)
	SBCI R27,HIGH(-_eereley2command)
	CALL __EEPROMRDB
	CPI  R30,0
	BREQ _0x3C
; 0000 012F         reley2command[counter] = eereley2command[counter];
	CALL SUBOPT_0xA
	SUBI R30,LOW(-_reley2command)
	SBCI R31,HIGH(-_reley2command)
	MOVW R0,R30
	CALL SUBOPT_0x0
	SUBI R26,LOW(-_eereley2command)
	SBCI R27,HIGH(-_eereley2command)
	CALL SUBOPT_0xB
; 0000 0130         counter++;
; 0000 0131         #asm("wdr")
	wdr
; 0000 0132     }
	RJMP _0x3A
_0x3C:
; 0000 0133     reley2delay=eereley2delay;
	LDI  R26,LOW(_eereley2delay)
	LDI  R27,HIGH(_eereley2delay)
	CALL __EEPROMRDB
	STS  _reley2delay,R30
; 0000 0134     #asm("wdr")
	wdr
; 0000 0135 
; 0000 0136     counter=0;
	LDI  R17,LOW(0)
; 0000 0137     while (eereley3command[counter]){
_0x3D:
	CALL SUBOPT_0x0
	SUBI R26,LOW(-_eereley3command)
	SBCI R27,HIGH(-_eereley3command)
	CALL __EEPROMRDB
	CPI  R30,0
	BREQ _0x3F
; 0000 0138         reley3command[counter] = eereley3command[counter];
	CALL SUBOPT_0xA
	SUBI R30,LOW(-_reley3command)
	SBCI R31,HIGH(-_reley3command)
	MOVW R0,R30
	CALL SUBOPT_0x0
	SUBI R26,LOW(-_eereley3command)
	SBCI R27,HIGH(-_eereley3command)
	CALL SUBOPT_0xB
; 0000 0139         counter++;
; 0000 013A         #asm("wdr")
	wdr
; 0000 013B     }
	RJMP _0x3D
_0x3F:
; 0000 013C     reley3delay=eereley3delay;
	LDI  R26,LOW(_eereley3delay)
	LDI  R27,HIGH(_eereley3delay)
	CALL __EEPROMRDB
	STS  _reley3delay,R30
; 0000 013D     #asm("wdr")
	wdr
; 0000 013E 
; 0000 013F     counter=0;
	LDI  R17,LOW(0)
; 0000 0140     while (eereley4command[counter]){
_0x40:
	CALL SUBOPT_0x0
	SUBI R26,LOW(-_eereley4command)
	SBCI R27,HIGH(-_eereley4command)
	CALL __EEPROMRDB
	CPI  R30,0
	BREQ _0x42
; 0000 0141         reley4command[counter] = eereley4command[counter];
	CALL SUBOPT_0xA
	SUBI R30,LOW(-_reley4command)
	SBCI R31,HIGH(-_reley4command)
	MOVW R0,R30
	CALL SUBOPT_0x0
	SUBI R26,LOW(-_eereley4command)
	SBCI R27,HIGH(-_eereley4command)
	CALL SUBOPT_0xB
; 0000 0142         counter++;
; 0000 0143         #asm("wdr")
	wdr
; 0000 0144     }
	RJMP _0x40
_0x42:
; 0000 0145     reley4delay=eereley4delay;
	LDI  R26,LOW(_eereley4delay)
	LDI  R27,HIGH(_eereley4delay)
	CALL __EEPROMRDB
	STS  _reley4delay,R30
; 0000 0146     #asm("wdr")
	wdr
; 0000 0147 
; 0000 0148 
; 0000 0149 }
_0x20C000B:
	LD   R17,Y+
	RET
;
;char uppchar(char s) {
; 0000 014B char uppchar(char s) {
_uppchar:
; 0000 014C     char o;
; 0000 014D       if (s >= 'a' && s <= 'z') {
	ST   -Y,R17
;	s -> Y+1
;	o -> R17
	LDD  R26,Y+1
	CPI  R26,LOW(0x61)
	BRLO _0x44
	CPI  R26,LOW(0x7B)
	BRLO _0x45
_0x44:
	RJMP _0x43
_0x45:
; 0000 014E         #asm("wdr")
	wdr
; 0000 014F          o = s - 32;
	LDD  R30,Y+1
	LDI  R31,0
	SBIW R30,32
	MOV  R17,R30
; 0000 0150       }else o=s;
	RJMP _0x46
_0x43:
	LDD  R17,Y+1
; 0000 0151       #asm("wdr")
_0x46:
	wdr
; 0000 0152     return o;
	MOV  R30,R17
	LDD  R17,Y+0
	ADIW R28,2
	RET
; 0000 0153 }
;
;
;
;
;
;void resetsistem(void){
; 0000 0159 void resetsistem(void){
_resetsistem:
; 0000 015A   delay_ms(200);
	CALL SUBOPT_0xC
; 0000 015B   #asm("wdr")
	wdr
; 0000 015C   delay_ms(200);
	CALL SUBOPT_0xC
; 0000 015D   #asm("wdr")
	wdr
; 0000 015E   M590_POWERPIN=0;
	CBI  0x5,0
; 0000 015F   delay_ms(200);
	CALL SUBOPT_0xC
; 0000 0160   #asm("wdr")
	wdr
; 0000 0161   delay_ms(200);
	CALL SUBOPT_0xC
; 0000 0162   #asm("wdr")
	wdr
; 0000 0163   delay_ms(200);
	CALL SUBOPT_0xC
; 0000 0164   #asm("wdr")
	wdr
; 0000 0165   delay_ms(200);
	CALL SUBOPT_0xC
; 0000 0166   #asm("wdr")
	wdr
; 0000 0167    delay_ms(200);
	CALL SUBOPT_0xC
; 0000 0168   #asm("wdr")
	wdr
; 0000 0169   delay_ms(200);
	CALL SUBOPT_0xC
; 0000 016A   #asm("wdr")
	wdr
; 0000 016B   delay_ms(200);
	CALL SUBOPT_0xC
; 0000 016C   #asm("wdr")
	wdr
; 0000 016D   delay_ms(200);
	CALL SUBOPT_0xC
; 0000 016E   #asm("wdr")
	wdr
; 0000 016F   WDTCSR=0x18;
	LDI  R30,LOW(24)
	STS  96,R30
; 0000 0170   WDTCSR=0x08;
	LDI  R30,LOW(8)
	STS  96,R30
; 0000 0171   #asm("wdr")
	wdr
; 0000 0172   while(1);
_0x49:
	RJMP _0x49
; 0000 0173 
; 0000 0174 }
;
;void clearFIFO(void)
; 0000 0177 {
_clearFIFO:
; 0000 0178     while (rx_counter0!=0) {
_0x4C:
	CALL SUBOPT_0x2
	BREQ _0x4E
; 0000 0179         #asm("wdr")
	wdr
; 0000 017A         if (++rx_rd_index0 == RXFIFO_BUFFER_SIZE0) rx_rd_index0=0;
	CALL SUBOPT_0x4
	BRNE _0x4F
	CALL SUBOPT_0x5
; 0000 017B         #asm("cli")
_0x4F:
	cli
; 0000 017C         --rx_counter0;
	CALL SUBOPT_0x6
; 0000 017D         #asm("sei")
	sei
; 0000 017E     }
	RJMP _0x4C
_0x4E:
; 0000 017F     #asm("cli")
	cli
; 0000 0180     rx_buffer_overflow0=0;
	CBI  0x1E,4
; 0000 0181     #asm("sei")
	sei
; 0000 0182     #asm("wdr")
	wdr
; 0000 0183 }
	RET
;
;unsigned char getstring(char *readbuf, unsigned int lenbuf)
; 0000 0186 {
_getstring:
; 0000 0187     char data;
; 0000 0188     unsigned int count;
; 0000 0189     count=0;
	CALL __SAVELOCR4
;	*readbuf -> Y+6
;	lenbuf -> Y+4
;	data -> R17
;	count -> R18,R19
	__GETWRN 18,19,0
; 0000 018A     delay_ms(100);
	CALL SUBOPT_0xD
; 0000 018B     #asm("wdr")
	wdr
; 0000 018C     #asm("cli")
	cli
; 0000 018D     uarttimeout=30;//~30sec
	LDI  R30,LOW(30)
	STS  _uarttimeout,R30
; 0000 018E     #asm("sei")
	sei
; 0000 018F         while (count<=lenbuf-1){
_0x52:
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	SBIW R30,1
	CP   R30,R18
	CPC  R31,R19
	BRSH PC+3
	JMP _0x54
; 0000 0190                 while (rx_counter0==0) {
_0x55:
	CALL SUBOPT_0x2
	BRNE _0x57
; 0000 0191                     #asm("wdr")
	wdr
; 0000 0192                     if (uarttimeout==0){    //  
	LDS  R30,_uarttimeout
	CPI  R30,0
	BRNE _0x58
; 0000 0193                         readbuf[count]='\r';
	CALL SUBOPT_0xE
	LDI  R30,LOW(13)
	CALL SUBOPT_0xF
; 0000 0194                         count++;
; 0000 0195                         readbuf[count]='\n';
	LDI  R30,LOW(10)
	CALL SUBOPT_0xF
; 0000 0196                         count++;
; 0000 0197                         readbuf[count]='\0';
	LDI  R30,LOW(0)
	ST   X,R30
; 0000 0198                         return count;
	RJMP _0x20C000A
; 0000 0199                     }
; 0000 019A                 };
_0x58:
	RJMP _0x55
_0x57:
; 0000 019B                 data=rx_buffer0[rx_rd_index0];
	CALL SUBOPT_0x3
; 0000 019C                 #asm("wdr")
	wdr
; 0000 019D                 if (++rx_rd_index0 == RXFIFO_BUFFER_SIZE0) rx_rd_index0=0;
	CALL SUBOPT_0x4
	BRNE _0x59
	CALL SUBOPT_0x5
; 0000 019E                 #asm("cli")
_0x59:
	cli
; 0000 019F                 --rx_counter0;
	CALL SUBOPT_0x6
; 0000 01A0                 #asm("sei")
	sei
; 0000 01A1 
; 0000 01A2                 readbuf[count]=data;
	MOVW R30,R18
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADD  R30,R26
	ADC  R31,R27
	ST   Z,R17
; 0000 01A3                 #asm("wdr")
	wdr
; 0000 01A4                 if (count!=0)
	MOV  R0,R18
	OR   R0,R19
	BREQ _0x5A
; 0000 01A5                     if ((readbuf[count-1]=='\r')&&(data=='\n')) break;
	CALL SUBOPT_0x10
	LD   R26,X
	CPI  R26,LOW(0xD)
	BRNE _0x5C
	CPI  R17,10
	BREQ _0x5D
_0x5C:
	RJMP _0x5B
_0x5D:
	RJMP _0x54
; 0000 01A6                 if (count==lenbuf-1){
_0x5B:
_0x5A:
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	SBIW R30,1
	CP   R30,R18
	CPC  R31,R19
	BRNE _0x5E
; 0000 01A7                     readbuf[count-1]='\r';
	CALL SUBOPT_0x10
	LDI  R30,LOW(13)
	ST   X,R30
; 0000 01A8                     readbuf[count]='\n';
	CALL SUBOPT_0xE
	LDI  R30,LOW(10)
	CALL SUBOPT_0xF
; 0000 01A9                     count++;
; 0000 01AA                     readbuf[count]='\0';
	LDI  R30,LOW(0)
	ST   X,R30
; 0000 01AB                     #asm("wdr")
	wdr
; 0000 01AC                     clearFIFO();
	RCALL _clearFIFO
; 0000 01AD                     return count;
	RJMP _0x20C000A
; 0000 01AE                 }
; 0000 01AF                 count++;
_0x5E:
	__ADDWRN 18,19,1
; 0000 01B0         };
	RJMP _0x52
_0x54:
; 0000 01B1 
; 0000 01B2         #asm("wdr")
	wdr
; 0000 01B3         count++;
	__ADDWRN 18,19,1
; 0000 01B4         readbuf[count]='\0';
	CALL SUBOPT_0xE
	LDI  R30,LOW(0)
	ST   X,R30
; 0000 01B5 
; 0000 01B6     #asm("wdr")
	wdr
; 0000 01B7 return count;
_0x20C000A:
	MOVW R30,R18
	CALL __LOADLOCR4
	ADIW R28,8
	RET
; 0000 01B8 }
;
;#include <string.h>
;#include <stdio.h>
;
;unsigned char strtoup(char *readbuf){
; 0000 01BD unsigned char strtoup(char *readbuf){
_strtoup:
; 0000 01BE      unsigned char count=0;
; 0000 01BF      char data;
; 0000 01C0      while (count<=strlen(readbuf)){
	ST   -Y,R17
	ST   -Y,R16
;	*readbuf -> Y+2
;	count -> R17
;	data -> R16
	LDI  R17,0
_0x5F:
	LDD  R30,Y+2
	LDD  R31,Y+2+1
	CALL SUBOPT_0x11
	CALL SUBOPT_0x0
	CP   R30,R26
	CPC  R31,R27
	BRLO _0x61
; 0000 01C1        data =readbuf[count];
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	CLR  R30
	ADD  R26,R17
	ADC  R27,R30
	LD   R16,X
; 0000 01C2        readbuf[count]=uppchar(data);
	MOV  R30,R17
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	PUSH R31
	PUSH R30
	ST   -Y,R16
	CALL _uppchar
	POP  R26
	POP  R27
	ST   X,R30
; 0000 01C3        count++;
	SUBI R17,-1
; 0000 01C4      }
	RJMP _0x5F
_0x61:
; 0000 01C5  return  count-1;
	CALL SUBOPT_0x0
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	CALL __SWAPW12
	SUB  R30,R26
	SBC  R31,R27
	LDD  R17,Y+1
	LDD  R16,Y+0
	JMP  _0x20C0008
; 0000 01C6 }
;
;char ansvercmp(char *str1, char flash *str2){
; 0000 01C8 char ansvercmp(char *str1, char flash *str2){
_ansvercmp:
; 0000 01C9     char len =strlenf(str2);
; 0000 01CA     char status=strncmpf(str1, str2,len);
; 0000 01CB 
; 0000 01CC return status;
	ST   -Y,R17
	ST   -Y,R16
;	*str1 -> Y+4
;	*str2 -> Y+2
;	len -> R17
;	status -> R16
	LDD  R30,Y+2
	LDD  R31,Y+2+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _strlenf
	MOV  R17,R30
	CALL SUBOPT_0x12
	CALL SUBOPT_0x12
	ST   -Y,R17
	CALL _strncmpf
	MOV  R16,R30
	MOV  R30,R16
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,6
	RET
; 0000 01CD }
;
;char okststusM590(void){
; 0000 01CF char okststusM590(void){
_okststusM590:
; 0000 01D0     char status=2;
; 0000 01D1         delay_ms(200);
	ST   -Y,R17
;	status -> R17
	LDI  R17,2
	CALL SUBOPT_0xC
; 0000 01D2         #asm("wdr")
	wdr
; 0000 01D3         do{
_0x63:
; 0000 01D4             if (rx_counter0!=0) getstring(RX_text_tmp,tmpbufsize);
	CALL SUBOPT_0x2
	BREQ _0x65
	CALL SUBOPT_0x13
	CALL SUBOPT_0x14
; 0000 01D5             else  status=0;
	RJMP _0x66
_0x65:
	LDI  R17,LOW(0)
; 0000 01D6             #asm("wdr")
_0x66:
	wdr
; 0000 01D7             if (ansvercmp(RX_text_tmp, "OK")==0) status=0;
	CALL SUBOPT_0x13
	CALL SUBOPT_0x15
	BRNE _0x67
	LDI  R17,LOW(0)
; 0000 01D8             #asm("wdr")
_0x67:
	wdr
; 0000 01D9             if (ansvercmp(RX_text_tmp, "ERROR")==0) status=1;
	CALL SUBOPT_0x13
	CALL SUBOPT_0x16
	BRNE _0x68
	LDI  R17,LOW(1)
; 0000 01DA         }while (status==2);
_0x68:
	CPI  R17,2
	BREQ _0x63
; 0000 01DB 
; 0000 01DC return status;
	JMP  _0x20C0006
; 0000 01DD }
;
;char m590command(char flash *command){
; 0000 01DF char m590command(char flash *command){
_m590command:
; 0000 01E0 
; 0000 01E1     char status=2;
; 0000 01E2     printf(command);
	ST   -Y,R17
;	*command -> Y+1
;	status -> R17
	LDI  R17,2
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	CALL SUBOPT_0x17
; 0000 01E3     putchar('\r');
	LDI  R30,LOW(13)
	CALL SUBOPT_0x18
; 0000 01E4     putchar('\n');
; 0000 01E5     delay_ms(200);
	CALL SUBOPT_0xC
; 0000 01E6      #asm("wdr")
	wdr
; 0000 01E7      do{
_0x6A:
; 0000 01E8             if (rx_counter0==0) {
	CALL SUBOPT_0x2
	BRNE _0x6C
; 0000 01E9                 return 255;  //m590 not ansver
	LDI  R30,LOW(255)
	RJMP _0x20C0009
; 0000 01EA             }
; 0000 01EB             getstring(RX_text_tmp,tmpbufsize);
_0x6C:
	CALL SUBOPT_0x13
	CALL SUBOPT_0x14
; 0000 01EC             #asm("wdr")
	wdr
; 0000 01ED              if (ansvercmp(RX_text_tmp, "ERROR")==0) break;
	CALL SUBOPT_0x13
	CALL SUBOPT_0x16
	BREQ _0x6B
; 0000 01EE     } while ((ansvercmp(RX_text_tmp, command)!=0)&&(ansvercmp(RX_text_tmp, "\r\n")!=0));//if ATE1 "AT\r\n",else ATE0 "\r\n"
	CALL SUBOPT_0x13
	LDD  R30,Y+3
	LDD  R31,Y+3+1
	CALL SUBOPT_0x19
	BREQ _0x6E
	CALL SUBOPT_0x13
	CALL SUBOPT_0x1A
	BRNE _0x6F
_0x6E:
	RJMP _0x6B
_0x6F:
	RJMP _0x6A
_0x6B:
; 0000 01EF 
; 0000 01F0     status=okststusM590();
	RCALL _okststusM590
	MOV  R17,R30
; 0000 01F1 
; 0000 01F2 
; 0000 01F3 return status;
	MOV  R30,R17
_0x20C0009:
	LDD  R17,Y+0
	ADIW R28,3
	RET
; 0000 01F4 }
;
;
;
;char netstatusM590(void){
; 0000 01F8 char netstatusM590(void){
_netstatusM590:
; 0000 01F9     char status=10;
; 0000 01FA 
; 0000 01FB     printf("AT+CREG?\r");
	ST   -Y,R17
;	status -> R17
	LDI  R17,10
	__POINTW1FN _0x0,12
	CALL SUBOPT_0x17
; 0000 01FC     putchar('\n');
	CALL SUBOPT_0x1B
; 0000 01FD     delay_ms(200);
	CALL SUBOPT_0xC
; 0000 01FE      #asm("wdr")
	wdr
; 0000 01FF     do{
_0x71:
; 0000 0200             if (rx_counter0==0) {
	CALL SUBOPT_0x2
	BRNE _0x73
; 0000 0201                 return 255;  //m590 not ansver
	LDI  R30,LOW(255)
	JMP  _0x20C0007
; 0000 0202             }
; 0000 0203             getstring(RX_text_tmp,tmpbufsize);
_0x73:
	CALL SUBOPT_0x13
	CALL SUBOPT_0x14
; 0000 0204             #asm("wdr")
	wdr
; 0000 0205             if (ansvercmp(RX_text_tmp, "ERROR")==0) break;
	CALL SUBOPT_0x13
	CALL SUBOPT_0x16
	BREQ _0x72
; 0000 0206     } while ((ansvercmp(RX_text_tmp, "AT+CREG?")!=0)&&(ansvercmp(RX_text_tmp, "\r\n")!=0));//if ATE1 "AT\r\n",else ATE0 "\r\n"
	CALL SUBOPT_0x13
	__POINTW1FN _0x0,22
	CALL SUBOPT_0x19
	BREQ _0x75
	CALL SUBOPT_0x13
	CALL SUBOPT_0x1A
	BRNE _0x76
_0x75:
	RJMP _0x72
_0x76:
	RJMP _0x71
_0x72:
; 0000 0207     do{
_0x78:
; 0000 0208         getstring(RX_text_tmp,tmpbufsize);
	CALL SUBOPT_0x13
	CALL SUBOPT_0x14
; 0000 0209         #asm("wdr")
	wdr
; 0000 020A         if (ansvercmp(RX_text_tmp, "ERROR")==0) break;
	CALL SUBOPT_0x13
	CALL SUBOPT_0x16
	BREQ _0x79
; 0000 020B     } while (ansvercmp(RX_text_tmp, "+CREG:")!=0) ;
	CALL SUBOPT_0x13
	__POINTW1FN _0x0,31
	CALL SUBOPT_0x19
	BRNE _0x78
_0x79:
; 0000 020C     if ((strstrf(RX_text_tmp,",0")!=NULL)) status=0;
	CALL SUBOPT_0x13
	__POINTW1FN _0x0,38
	CALL SUBOPT_0x1C
	BREQ _0x7B
	LDI  R17,LOW(0)
; 0000 020D     #asm("wdr")
_0x7B:
	wdr
; 0000 020E     if ((strstrf(RX_text_tmp,",1")!=NULL)) status=1; //home net
	CALL SUBOPT_0x13
	__POINTW1FN _0x0,41
	CALL SUBOPT_0x1C
	BREQ _0x7C
	LDI  R17,LOW(1)
; 0000 020F     #asm("wdr")
_0x7C:
	wdr
; 0000 0210     if ((strstrf(RX_text_tmp,",2")!=NULL)) status=2;
	CALL SUBOPT_0x13
	__POINTW1FN _0x0,44
	CALL SUBOPT_0x1C
	BREQ _0x7D
	LDI  R17,LOW(2)
; 0000 0211     #asm("wdr")
_0x7D:
	wdr
; 0000 0212     if ((strstrf(RX_text_tmp,",3")!=NULL)) status=3;
	CALL SUBOPT_0x13
	__POINTW1FN _0x0,47
	CALL SUBOPT_0x1C
	BREQ _0x7E
	LDI  R17,LOW(3)
; 0000 0213     #asm("wdr")
_0x7E:
	wdr
; 0000 0214     if ((strstrf(RX_text_tmp,",4")!=NULL)) status=4;
	CALL SUBOPT_0x13
	__POINTW1FN _0x0,50
	CALL SUBOPT_0x1C
	BREQ _0x7F
	LDI  R17,LOW(4)
; 0000 0215     #asm("wdr")
_0x7F:
	wdr
; 0000 0216     if ((strstrf(RX_text_tmp,",5")!=NULL)) status=5; //rouming
	CALL SUBOPT_0x13
	__POINTW1FN _0x0,53
	CALL SUBOPT_0x1C
	BREQ _0x80
	LDI  R17,LOW(5)
; 0000 0217     okststusM590();
_0x80:
	RCALL _okststusM590
; 0000 0218 return status;
	JMP  _0x20C0006
; 0000 0219 }
;
;/*char statusM590(void){
;    char status=0;
;
;
;    printf("AT+CPAS\r");
;    putchar('\n');
;    delay_ms(200);
;     #asm("wdr")
;    do{
;            if (rx_counter0==0) {
;                return 255;  //m590 not ansver
;            }
;            getstring(RX_text_tmp,tmpbufsize);
;            #asm("wdr")
;            if (ansvercmp(RX_text_tmp, "ERROR")==0) break;
;    } while ((ansvercmp(RX_text_tmp, "AT+CPAS")!=0)&&(ansvercmp(RX_text_tmp, "\r\n")!=0));//if ATE1 "AT\r\n",else ATE0 "\r\n"
;    do{
;        getstring(RX_text_tmp,tmpbufsize);
;        #asm("wdr")
;        if (ansvercmp(RX_text_tmp, "ERROR")==0) break;
;    } while (ansvercmp(RX_text_tmp, "+CPAS:")==0) ;
;
;    #asm("wdr")
;    if ((ansvercmp(RX_text_tmp,"+CPAS:")==0)){
;        if ((strstrf(RX_text_tmp,"1")!=NULL)) status=1;
;
;    };
;    okststusM590();
;return status;
;}*/
;
;
;
;#include <stdlib.h>
;
;char m590init( void ){
; 0000 023E char m590init( void ){
_m590init:
; 0000 023F     char status=2;
; 0000 0240 
; 0000 0241 
; 0000 0242 
; 0000 0243     LEDPIN=1;
	ST   -Y,R17
;	status -> R17
	LDI  R17,2
	SBI  0x8,2
; 0000 0244     M590_POWERPIN=1;
	SBI  0x5,0
; 0000 0245 
; 0000 0246     #asm("wdr")
	wdr
; 0000 0247     delay_ms(500);
	CALL SUBOPT_0x1D
; 0000 0248     #asm("wdr")
	wdr
; 0000 0249     delay_ms(500);
	CALL SUBOPT_0x1D
; 0000 024A 
; 0000 024B     #asm("wdr")
	wdr
; 0000 024C     delay_ms(500);
	CALL SUBOPT_0x1D
; 0000 024D     #asm("wdr")
	wdr
; 0000 024E     delay_ms(500);
	CALL SUBOPT_0x1D
; 0000 024F     #asm("wdr")
	wdr
; 0000 0250     M590_ONPIN=1;
	SBI  0x5,1
; 0000 0251     do{
_0x88:
; 0000 0252         getstring(RX_text_tmp,tmpbufsize);
	CALL SUBOPT_0x13
	CALL SUBOPT_0x14
; 0000 0253     }while (ansvercmp(RX_text_tmp,"\r\n")!=0);// 
	CALL SUBOPT_0x13
	CALL SUBOPT_0x1A
	BRNE _0x88
; 0000 0254 
; 0000 0255 
; 0000 0256     getstring(RX_text_tmp,tmpbufsize);
	CALL SUBOPT_0x13
	CALL SUBOPT_0x14
; 0000 0257 
; 0000 0258     if (ansvercmp(RX_text_tmp,"MODEM:STARTUP")!=0) {
	CALL SUBOPT_0x13
	__POINTW1FN _0x0,56
	CALL SUBOPT_0x19
	BREQ _0x8A
; 0000 0259         M590_POWERPIN=0;
	CBI  0x5,0
; 0000 025A         while(1){              //error modem
_0x8D:
; 0000 025B             LEDPIN=0;
	CBI  0x8,2
; 0000 025C             delay_ms(100);
	CALL SUBOPT_0xD
; 0000 025D             #asm("wdr")
	wdr
; 0000 025E             LEDPIN=1;
	SBI  0x8,2
; 0000 025F             delay_ms(100);
	CALL SUBOPT_0xD
; 0000 0260             #asm("wdr")
	wdr
; 0000 0261         };
	RJMP _0x8D
; 0000 0262     };
_0x8A:
; 0000 0263 
; 0000 0264     #asm("wdr")
	wdr
; 0000 0265 
; 0000 0266     LEDPIN=1;
	SBI  0x8,2
; 0000 0267 
; 0000 0268     delay_ms(500);
	CALL SUBOPT_0x1D
; 0000 0269     #asm("wdr")
	wdr
; 0000 026A     delay_ms(500);
	CALL SUBOPT_0x1D
; 0000 026B     #asm("wdr")
	wdr
; 0000 026C     delay_ms(500);
	CALL SUBOPT_0x1D
; 0000 026D     #asm("wdr")
	wdr
; 0000 026E     delay_ms(500);
	CALL SUBOPT_0x1D
; 0000 026F     #asm("wdr")
	wdr
; 0000 0270     delay_ms(500);
	CALL SUBOPT_0x1D
; 0000 0271     #asm("wdr")
	wdr
; 0000 0272     delay_ms(500);
	CALL SUBOPT_0x1D
; 0000 0273     #asm("wdr")
	wdr
; 0000 0274 
; 0000 0275     M590_ONPIN=0;  //3 sec
	CBI  0x5,1
; 0000 0276     M590_SLEEPPIN=1;
	SBI  0xB,6
; 0000 0277     #asm("wdr")
	wdr
; 0000 0278 
; 0000 0279 
; 0000 027A     do{
_0x9B:
; 0000 027B      getstring(RX_text_tmp,tmpbufsize);
	CALL SUBOPT_0x13
	CALL SUBOPT_0x14
; 0000 027C     }while (ansvercmp(RX_text_tmp,"\r\n")!=0);// 
	CALL SUBOPT_0x13
	CALL SUBOPT_0x1A
	BRNE _0x9B
; 0000 027D     getstring(RX_text_tmp,tmpbufsize);
	CALL SUBOPT_0x13
	CALL SUBOPT_0x14
; 0000 027E     if (ansvercmp(RX_text_tmp,"+PBREADY")!=0) {
	CALL SUBOPT_0x13
	__POINTW1FN _0x0,70
	CALL SUBOPT_0x19
	BREQ _0x9D
; 0000 027F         M590_POWERPIN=0;
	CBI  0x5,0
; 0000 0280         while(1){              //error SIM
_0xA0:
; 0000 0281             LEDPIN=0;
	CBI  0x8,2
; 0000 0282             delay_ms(400);
	LDI  R30,LOW(400)
	LDI  R31,HIGH(400)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
; 0000 0283             #asm("wdr")
	wdr
; 0000 0284             LEDPIN=1;
	SBI  0x8,2
; 0000 0285             delay_ms(100);
	CALL SUBOPT_0xD
; 0000 0286             #asm("wdr")
	wdr
; 0000 0287         };
	RJMP _0xA0
; 0000 0288     };
_0x9D:
; 0000 0289 
; 0000 028A     LEDPIN=1;
	SBI  0x8,2
; 0000 028B 
; 0000 028C     m590command("AT");
	CALL SUBOPT_0x1E
; 0000 028D     delay_ms(200);
	CALL SUBOPT_0xC
; 0000 028E     #asm("wdr")
	wdr
; 0000 028F 
; 0000 0290     /*m590command("AT&F");
; 0000 0291     delay_ms(200);
; 0000 0292     #asm("wdr")*/
; 0000 0293 
; 0000 0294     m590command("ATE1");
	__POINTW1FN _0x0,82
	CALL SUBOPT_0x1F
; 0000 0295     delay_ms(200);
; 0000 0296      #asm("wdr")
	wdr
; 0000 0297     m590command("AT+CLIP=0");
	__POINTW1FN _0x0,87
	CALL SUBOPT_0x1F
; 0000 0298     delay_ms(200);
; 0000 0299      #asm("wdr")
	wdr
; 0000 029A    /* m590command("AT+CREG=1"); //      
; 0000 029B     delay_ms(200);
; 0000 029C      #asm("wdr")
; 0000 029D    */
; 0000 029E     m590command("AT+CMGF=1");  // 
	__POINTW1FN _0x0,97
	CALL SUBOPT_0x1F
; 0000 029F     delay_ms(200);
; 0000 02A0      #asm("wdr")
	wdr
; 0000 02A1 
; 0000 02A2     m590command("AT+CSCS=\"GSM\"");
	__POINTW1FN _0x0,107
	CALL SUBOPT_0x1F
; 0000 02A3     delay_ms(200);
; 0000 02A4      #asm("wdr")
	wdr
; 0000 02A5 
; 0000 02A6     /*m590command("AT&W");
; 0000 02A7     delay_ms(200);
; 0000 02A8      #asm("wdr")*/
; 0000 02A9 
; 0000 02AA     LEDPIN=0;
	CBI  0x8,2
; 0000 02AB     while(1) {     //registration
_0xAB:
; 0000 02AC         netststus=netstatusM590();
	CALL _netstatusM590
	MOV  R12,R30
; 0000 02AD         if(netststus==1) break;
	LDI  R30,LOW(1)
	CP   R30,R12
	BREQ _0xAD
; 0000 02AE         if(netststus==5) break;
	LDI  R30,LOW(5)
	CP   R30,R12
	BREQ _0xAD
; 0000 02AF         LEDPIN=0;
	CBI  0x8,2
; 0000 02B0         delay_ms(500);
	CALL SUBOPT_0x1D
; 0000 02B1         #asm("wdr")
	wdr
; 0000 02B2         delay_ms(500);
	CALL SUBOPT_0x1D
; 0000 02B3         #asm("wdr")
	wdr
; 0000 02B4         LEDPIN=1;
	SBI  0x8,2
; 0000 02B5         delay_ms(500);
	CALL SUBOPT_0x1D
; 0000 02B6         #asm("wdr")
	wdr
; 0000 02B7         delay_ms(500);
	CALL SUBOPT_0x1D
; 0000 02B8         #asm("wdr")
	wdr
; 0000 02B9     };
	RJMP _0xAB
_0xAD:
; 0000 02BA     LEDPIN=1;
	SBI  0x8,2
; 0000 02BB 
; 0000 02BC      m590command("AT+CNMI=2,2");
	__POINTW1FN _0x0,121
	CALL SUBOPT_0x1F
; 0000 02BD     delay_ms(200);
; 0000 02BE      #asm("wdr")
	wdr
; 0000 02BF 
; 0000 02C0      m590command("AT+ENPWRSAVE=1"); //enable savemode
	__POINTW1FN _0x0,133
	CALL SUBOPT_0x1F
; 0000 02C1     delay_ms(200);
; 0000 02C2      #asm("wdr")
	wdr
; 0000 02C3     M590_SLEEPPIN=0;
	CBI  0xB,6
; 0000 02C4     LEDPIN=0;
	CBI  0x8,2
; 0000 02C5 
; 0000 02C6 return status;
	JMP  _0x20C0006
; 0000 02C7 }
;
;char alarmDial(void){
; 0000 02C9 char alarmDial(void){
_alarmDial:
; 0000 02CA         char status=3;
; 0000 02CB 
; 0000 02CC         printf("ATD%s;\r",alarmphone);
	ST   -Y,R17
;	status -> R17
	LDI  R17,3
	__POINTW1FN _0x0,148
	CALL SUBOPT_0x20
; 0000 02CD         putchar('\n');
; 0000 02CE         #asm("wdr")
	wdr
; 0000 02CF         do{
_0xBB:
; 0000 02D0             getstring(RX_text_tmp,tmpbufsize);
	CALL SUBOPT_0x13
	CALL SUBOPT_0x14
; 0000 02D1             #asm("wdr")
	wdr
; 0000 02D2             if (ansvercmp(RX_text_tmp, "ERROR")==0) break;
	CALL SUBOPT_0x13
	CALL SUBOPT_0x16
	BREQ _0xBC
; 0000 02D3         }while ((ansvercmp(RX_text_tmp, "ATD")!=0)&&(ansvercmp(RX_text_tmp, "\r\n")!=0));
	CALL SUBOPT_0x13
	__POINTW1FN _0x0,156
	CALL SUBOPT_0x19
	BREQ _0xBE
	CALL SUBOPT_0x13
	CALL SUBOPT_0x1A
	BRNE _0xBF
_0xBE:
	RJMP _0xBC
_0xBF:
	RJMP _0xBB
_0xBC:
; 0000 02D4         delay_ms(200);
	CALL SUBOPT_0xC
; 0000 02D5         #asm("wdr")
	wdr
; 0000 02D6         if (okststusM590()==0)
	CALL _okststusM590
	CPI  R30,0
	BREQ PC+3
	JMP _0xC0
; 0000 02D7             do{
_0xC2:
; 0000 02D8                getstring(RX_text_tmp,tmpbufsize);
	CALL SUBOPT_0x13
	CALL SUBOPT_0x14
; 0000 02D9                if (ansvercmp(RX_text_tmp, "ERROR")==0) break;
	CALL SUBOPT_0x13
	CALL SUBOPT_0x16
	BREQ _0xC3
; 0000 02DA                 #asm("wdr")
	wdr
; 0000 02DB                 if ((ansvercmp(RX_text_tmp,"CONNECT")==0)){
	CALL SUBOPT_0x13
	__POINTW1FN _0x0,160
	CALL SUBOPT_0x19
	BRNE _0xC5
; 0000 02DC                     #asm("wdr")
	wdr
; 0000 02DD                     delay_ms(200);
	CALL SUBOPT_0xC
; 0000 02DE                     m590command("ATH");
	CALL SUBOPT_0x21
; 0000 02DF                     status=0;
; 0000 02E0                 }
; 0000 02E1                 if ((ansvercmp(RX_text_tmp,"NO CARRIER")==0)){
_0xC5:
	CALL SUBOPT_0x13
	__POINTW1FN _0x0,172
	CALL SUBOPT_0x19
	BRNE _0xC6
; 0000 02E2                     #asm("wdr")
	wdr
; 0000 02E3                     delay_ms(200);
	CALL SUBOPT_0xC
; 0000 02E4                     m590command("ATH");
	CALL SUBOPT_0x21
; 0000 02E5                     status=0;
; 0000 02E6                 }
; 0000 02E7                 if ((ansvercmp(RX_text_tmp,"BUSY")==0)){
_0xC6:
	CALL SUBOPT_0x13
	__POINTW1FN _0x0,183
	CALL SUBOPT_0x19
	BRNE _0xC7
; 0000 02E8                     #asm("wdr")
	wdr
; 0000 02E9                     delay_ms(200);
	CALL SUBOPT_0xC
; 0000 02EA                     m590command("ATH");
	CALL SUBOPT_0x22
; 0000 02EB                     status=1;
; 0000 02EC                 }
; 0000 02ED                 if ((ansvercmp(RX_text_tmp,"NO ANSWER")==0)){
_0xC7:
	CALL SUBOPT_0x13
	__POINTW1FN _0x0,188
	CALL SUBOPT_0x19
	BRNE _0xC8
; 0000 02EE                     #asm("wdr")
	wdr
; 0000 02EF                     delay_ms(200);
	CALL SUBOPT_0xC
; 0000 02F0                     m590command("ATH");
	CALL SUBOPT_0x22
; 0000 02F1                     status=1;
; 0000 02F2                 }
; 0000 02F3             }while (status==3);
_0xC8:
	CPI  R17,3
	BRNE _0xC3
	RJMP _0xC2
_0xC3:
; 0000 02F4 
; 0000 02F5 
; 0000 02F6 return status;
_0xC0:
	JMP  _0x20C0006
; 0000 02F7 }
;
;char alarmSMS(void){
; 0000 02F9 char alarmSMS(void){
_alarmSMS:
; 0000 02FA         char status;
; 0000 02FB 
; 0000 02FC         printf("AT+CMGS=\"%s\"\r",alarmphone);
	ST   -Y,R17
;	status -> R17
	__POINTW1FN _0x0,198
	CALL SUBOPT_0x20
; 0000 02FD         putchar('\n');
; 0000 02FE         #asm("wdr")
	wdr
; 0000 02FF 
; 0000 0300         while (getchar()!='>'){#asm("wdr")};
_0xC9:
	CALL _getchar
	CPI  R30,LOW(0x3E)
	BREQ _0xCB
	wdr
	RJMP _0xC9
_0xCB:
; 0000 0301         getchar();
	CALL _getchar
; 0000 0302         delay_ms(200);
	CALL SUBOPT_0xC
; 0000 0303         printf("ALARM: ");
	__POINTW1FN _0x0,212
	CALL SUBOPT_0x17
; 0000 0304 
; 0000 0305         if (IGNITION==1) {
	LDI  R26,0
	SBIC 0x9,4
	LDI  R26,1
	CPI  R26,LOW(0x1)
	BRNE _0xCC
; 0000 0306             printf("IGNITION ON!");
	__POINTW1FN _0x0,220
	RJMP _0x1EB
; 0000 0307         }else if (DOORPIN==0){
_0xCC:
	SBIC 0x9,5
	RJMP _0xCE
; 0000 0308             printf("DOOR OPEN!");
	__POINTW1FN _0x0,233
	RJMP _0x1EB
; 0000 0309         }else{
_0xCE:
; 0000 030A             printf("SHOCK!");
	__POINTW1FN _0x0,244
_0x1EB:
	ST   -Y,R31
	ST   -Y,R30
	CALL SUBOPT_0x23
; 0000 030B         }
; 0000 030C         delay_ms(200);
	CALL SUBOPT_0xC
; 0000 030D         #asm("wdr")
	wdr
; 0000 030E         putchar(0x1A); //ctrl+Z
	LDI  R30,LOW(26)
	CALL SUBOPT_0x18
; 0000 030F         putchar('\n');
; 0000 0310         #asm("wdr")
	wdr
; 0000 0311         status=okststusM590();
	CALL _okststusM590
	MOV  R17,R30
; 0000 0312         if (status==0) {
	CPI  R17,0
	BRNE _0xD0
; 0000 0313             alarmsending=1;
	SBI  0x1E,1
; 0000 0314             countalarmsend=0;
	CLR  R10
	CLR  R11
; 0000 0315         }
; 0000 0316 
; 0000 0317 
; 0000 0318 return status;
_0xD0:
	JMP  _0x20C0006
; 0000 0319 }
;
;char statusSMS(void){
; 0000 031B char statusSMS(void){
_statusSMS:
; 0000 031C         char status=2;
; 0000 031D         #asm("wdr")
	ST   -Y,R17
;	status -> R17
	LDI  R17,2
	wdr
; 0000 031E         read_adc();
	CALL _read_adc
; 0000 031F         adcdata=read_adc();
	CALL SUBOPT_0x24
; 0000 0320         #asm("wdr")
	wdr
; 0000 0321         volt = (float) adcdata * voltdev;
	CALL SUBOPT_0x25
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	LDI  R26,LOW(_voltdev)
	LDI  R27,HIGH(_voltdev)
	CALL __EEPROMRDD
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CALL SUBOPT_0x26
; 0000 0322         #asm("wdr")
	wdr
; 0000 0323         ftoa(volt,1,voltstr);
	LDS  R30,_volt
	LDS  R31,_volt+1
	LDS  R22,_volt+2
	LDS  R23,_volt+3
	CALL __PUTPARD1
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R30,LOW(_voltstr)
	LDI  R31,HIGH(_voltstr)
	ST   -Y,R31
	ST   -Y,R30
	CALL _ftoa
; 0000 0324         #asm("wdr")
	wdr
; 0000 0325 
; 0000 0326         printf("AT+CMGS=\"%s\"\r",phone);
	CALL SUBOPT_0x27
; 0000 0327         putchar('\n');
; 0000 0328 
; 0000 0329         #asm("wdr")
	wdr
; 0000 032A         while (getchar()!='>'){#asm("wdr")};
_0xD3:
	CALL _getchar
	CPI  R30,LOW(0x3E)
	BREQ _0xD5
	wdr
	RJMP _0xD3
_0xD5:
; 0000 032B         getchar();
	CALL _getchar
; 0000 032C         #asm("wdr")
	wdr
; 0000 032D         delay_ms(200);
	CALL SUBOPT_0xC
; 0000 032E         #asm("wdr")
	wdr
; 0000 032F         printf("STATUS: ");
	__POINTW1FN _0x0,251
	CALL SUBOPT_0x17
; 0000 0330         if (alarmflag){
	SBIS 0x1E,0
	RJMP _0xD6
; 0000 0331             printf("ALLARM, ");
	__POINTW1FN _0x0,260
	RJMP _0x1EC
; 0000 0332         }else{
_0xD6:
; 0000 0333             printf("NO ALLARM, ");
	__POINTW1FN _0x0,269
_0x1EC:
	ST   -Y,R31
	ST   -Y,R30
	CALL SUBOPT_0x23
; 0000 0334         }
; 0000 0335         #asm("wdr")
	wdr
; 0000 0336         if (IGNITION) {
	SBIS 0x9,4
	RJMP _0xD8
; 0000 0337             printf("IGNITION ON, ");
	__POINTW1FN _0x0,281
	RJMP _0x1ED
; 0000 0338         }else{
_0xD8:
; 0000 0339             printf("IGNITION OFF, ");
	__POINTW1FN _0x0,295
_0x1ED:
	ST   -Y,R31
	ST   -Y,R30
	CALL SUBOPT_0x23
; 0000 033A         }
; 0000 033B         #asm("wdr")
	wdr
; 0000 033C         if (DOORPIN==0){
	SBIC 0x9,5
	RJMP _0xDA
; 0000 033D             printf("DOOR OPEN, ");
	__POINTW1FN _0x0,310
	RJMP _0x1EE
; 0000 033E         }else{
_0xDA:
; 0000 033F             printf("DOOR CLOSE, ");
	__POINTW1FN _0x0,322
_0x1EE:
	ST   -Y,R31
	ST   -Y,R30
	CALL SUBOPT_0x23
; 0000 0340         }
; 0000 0341         #asm("wdr")
	wdr
; 0000 0342         printf("VOLTAGE: %sV", voltstr);
	__POINTW1FN _0x0,335
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(_voltstr)
	LDI  R31,HIGH(_voltstr)
	CALL SUBOPT_0x28
; 0000 0343         #asm("wdr")
	wdr
; 0000 0344         delay_ms(200);
	CALL SUBOPT_0xC
; 0000 0345         #asm("wdr")
	wdr
; 0000 0346         putchar(0x1A); //ctrl+Z
	LDI  R30,LOW(26)
	CALL SUBOPT_0x18
; 0000 0347         putchar('\n');
; 0000 0348         #asm("wdr")
	wdr
; 0000 0349        status=okststusM590();
	JMP  _0x20C0005
; 0000 034A 
; 0000 034B return status;
; 0000 034C }
;
;char statusSMSOK(void){
; 0000 034E char statusSMSOK(void){
_statusSMSOK:
; 0000 034F         char status=2;
; 0000 0350 
; 0000 0351         printf("AT+CMGS=\"%s\"\r",phone);
	ST   -Y,R17
;	status -> R17
	LDI  R17,2
	CALL SUBOPT_0x27
; 0000 0352         putchar('\n');
; 0000 0353 
; 0000 0354         #asm("wdr")
	wdr
; 0000 0355         while (getchar()!='>'){#asm("wdr")};
_0xDC:
	CALL _getchar
	CPI  R30,LOW(0x3E)
	BREQ _0xDE
	wdr
	RJMP _0xDC
_0xDE:
; 0000 0356         getchar();
	CALL _getchar
; 0000 0357         #asm("wdr")
	wdr
; 0000 0358         delay_ms(200);
	CALL SUBOPT_0xC
; 0000 0359         #asm("wdr")
	wdr
; 0000 035A         printf("COMMAND OK");
	__POINTW1FN _0x0,348
	CALL SUBOPT_0x17
; 0000 035B         delay_ms(100);
	CALL SUBOPT_0xD
; 0000 035C         #asm("wdr")
	wdr
; 0000 035D         putchar(0x1A); //ctrl+Z
	LDI  R30,LOW(26)
	CALL SUBOPT_0x18
; 0000 035E         putchar('\n');
; 0000 035F         #asm("wdr")
	wdr
; 0000 0360        status=okststusM590();
	JMP  _0x20C0005
; 0000 0361 
; 0000 0362 return status;
; 0000 0363 }
;
;
;char billingSMS(void){
; 0000 0366 char billingSMS(void){
_billingSMS:
; 0000 0367 
; 0000 0368         char status=2;
; 0000 0369         unsigned char count;
; 0000 036A         char *ptr_to_ram;
; 0000 036B         m590command("AT+CNMI=0,0");
	CALL __SAVELOCR4
;	status -> R17
;	count -> R16
;	*ptr_to_ram -> R18,R19
	LDI  R17,2
	__POINTW1FN _0x0,359
	CALL SUBOPT_0x1F
; 0000 036C         delay_ms(200);
; 0000 036D         printf("ATD%s;\r",ballanscomand);
	__POINTW1FN _0x0,148
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(_ballanscomand)
	LDI  R31,HIGH(_ballanscomand)
	CALL SUBOPT_0x28
; 0000 036E 
; 0000 036F         putchar('\n');
	CALL SUBOPT_0x1B
; 0000 0370         delay_ms(200);
	CALL SUBOPT_0xC
; 0000 0371 
; 0000 0372         #asm("wdr")
	wdr
; 0000 0373         status=0;
	LDI  R17,LOW(0)
; 0000 0374          do{
_0xE0:
; 0000 0375             getstring(RX_text_tmp,tmpbufsize);
	CALL SUBOPT_0x13
	CALL SUBOPT_0x14
; 0000 0376             if (ansvercmp(RX_text_tmp, "ERROR")==0) break;
	CALL SUBOPT_0x13
	CALL SUBOPT_0x16
	BREQ _0xE1
; 0000 0377             #asm("wdr")
	wdr
; 0000 0378         }while ((ansvercmp(RX_text_tmp, "ATD")!=0)&&(ansvercmp(RX_text_tmp, "\r\n")!=0));
	CALL SUBOPT_0x13
	__POINTW1FN _0x0,156
	CALL SUBOPT_0x19
	BREQ _0xE3
	CALL SUBOPT_0x13
	CALL SUBOPT_0x1A
	BRNE _0xE4
_0xE3:
	RJMP _0xE1
_0xE4:
	RJMP _0xE0
_0xE1:
; 0000 0379 
; 0000 037A         do {
_0xE6:
; 0000 037B             getstring(RX_text,RXbufersize);
	CALL SUBOPT_0x29
	CALL SUBOPT_0x2A
; 0000 037C             if (ansvercmp(RX_text, "OK")==0) status=1;
	CALL SUBOPT_0x29
	CALL SUBOPT_0x15
	BRNE _0xE8
	LDI  R17,LOW(1)
; 0000 037D             #asm("wdr")
_0xE8:
	wdr
; 0000 037E             if (ansvercmp(RX_text, "ERROR")==0) status=1;
	CALL SUBOPT_0x29
	CALL SUBOPT_0x16
	BRNE _0xE9
	LDI  R17,LOW(1)
; 0000 037F             #asm("wdr")
_0xE9:
	wdr
; 0000 0380             if(ansvercmp(RX_text,"+CUSD")==0) {
	CALL SUBOPT_0x29
	__POINTW1FN _0x0,371
	CALL SUBOPT_0x19
	BRNE _0xEA
; 0000 0381                 status= okststusM590();
	CALL _okststusM590
	MOV  R17,R30
; 0000 0382             }
; 0000 0383         }while (status==2);
_0xEA:
	CPI  R17,2
	BREQ _0xE6
; 0000 0384         #asm("wdr")
	wdr
; 0000 0385         if (status==0) {
	CPI  R17,0
	BREQ PC+3
	JMP _0xEB
; 0000 0386             ptr_to_ram=RX_text;
	__POINTWRM 18,19,_RX_text
; 0000 0387 
; 0000 0388             while (*ptr_to_ram!='"') {
_0xEC:
	MOVW R26,R18
	LD   R26,X
	CPI  R26,LOW(0x22)
	BREQ _0xEE
; 0000 0389 
; 0000 038A                 ptr_to_ram++;
	__ADDWRN 18,19,1
; 0000 038B             }
	RJMP _0xEC
_0xEE:
; 0000 038C             ptr_to_ram++;
	__ADDWRN 18,19,1
; 0000 038D              //ptr_to_ram+=10;
; 0000 038E             count=1;
	LDI  R16,LOW(1)
; 0000 038F             while (ptr_to_ram[count]!='"') count++;
_0xEF:
	MOVW R26,R18
	CLR  R30
	ADD  R26,R16
	ADC  R27,R30
	LD   R26,X
	CPI  R26,LOW(0x22)
	BREQ _0xF1
	SUBI R16,-1
	RJMP _0xEF
_0xF1:
; 0000 0390 ptr_to_ram[count]='\0';
	MOVW R26,R18
	CLR  R30
	ADD  R26,R16
	ADC  R27,R30
	ST   X,R30
; 0000 0391 
; 0000 0392 
; 0000 0393             printf("AT+CMGS=\"%s\"\r",phone);
	CALL SUBOPT_0x27
; 0000 0394             putchar('\n');
; 0000 0395             #asm("wdr")
	wdr
; 0000 0396             while (getchar()!='>') {#asm("wdr")};
_0xF2:
	CALL _getchar
	CPI  R30,LOW(0x3E)
	BREQ _0xF4
	wdr
	RJMP _0xF2
_0xF4:
; 0000 0397             getchar();
	CALL _getchar
; 0000 0398             #asm("wdr")
	wdr
; 0000 0399             delay_ms(200);
	CALL SUBOPT_0xC
; 0000 039A             #asm("wdr")
	wdr
; 0000 039B             printf("BILLING:%s",ptr_to_ram);
	__POINTW1FN _0x0,377
	ST   -Y,R31
	ST   -Y,R30
	MOVW R30,R18
	CALL SUBOPT_0x28
; 0000 039C             putchar(0x0D);
	LDI  R30,LOW(13)
	ST   -Y,R30
	CALL _putchar
; 0000 039D             #asm("wdr")
	wdr
; 0000 039E             delay_ms(200);
	CALL SUBOPT_0xC
; 0000 039F             #asm("wdr")
	wdr
; 0000 03A0             putchar(0x1A); //ctrl+Z
	LDI  R30,LOW(26)
	CALL SUBOPT_0x18
; 0000 03A1             putchar('\n');
; 0000 03A2             status=okststusM590();
	CALL _okststusM590
	MOV  R17,R30
; 0000 03A3         };
_0xEB:
; 0000 03A4 
; 0000 03A5         delay_ms(200);
	CALL SUBOPT_0xC
; 0000 03A6         m590command("AT+CNMI=2,2");
	__POINTW1FN _0x0,121
	CALL SUBOPT_0x2B
; 0000 03A7 
; 0000 03A8 return status;
	MOV  R30,R17
	CALL __LOADLOCR4
_0x20C0008:
	ADIW R28,4
	RET
; 0000 03A9 }
;
;char helpSMS(void){
; 0000 03AB char helpSMS(void){
_helpSMS:
; 0000 03AC         char status;
; 0000 03AD         printf("AT+CMGS=\"%s\"\r",phone);
	ST   -Y,R17
;	status -> R17
	CALL SUBOPT_0x27
; 0000 03AE         putchar('\n');
; 0000 03AF 
; 0000 03B0         #asm("wdr")
	wdr
; 0000 03B1         while (getchar()!='>'){#asm("wdr")};
_0xF5:
	CALL _getchar
	CPI  R30,LOW(0x3E)
	BREQ _0xF7
	wdr
	RJMP _0xF5
_0xF7:
; 0000 03B2         getchar();
	CALL _getchar
; 0000 03B3         delay_ms(200);
	CALL SUBOPT_0xC
; 0000 03B4         printf("HELP: ");
	__POINTW1FN _0x0,388
	CALL SUBOPT_0x17
; 0000 03B5         #asm("wdr")
	wdr
; 0000 03B6         printf("\"*pasw#STATUS\" ");
	__POINTW1FN _0x0,395
	CALL SUBOPT_0x17
; 0000 03B7         #asm("wdr")
	wdr
; 0000 03B8         printf("\"*pasw#BILLING\" ");
	__POINTW1FN _0x0,411
	CALL SUBOPT_0x17
; 0000 03B9         #asm("wdr")
	wdr
; 0000 03BA         printf("\"*pasw#BALANS\" ");
	__POINTW1FN _0x0,428
	CALL SUBOPT_0x17
; 0000 03BB         #asm("wdr")
	wdr
; 0000 03BC        // printf("\"*pasw#CLEARSMS\" ");
; 0000 03BD         #asm("wdr")
	wdr
; 0000 03BE         printf("\"*pasw#RELEY\" ");
	__POINTW1FN _0x0,444
	CALL SUBOPT_0x17
; 0000 03BF         #asm("wdr")
	wdr
; 0000 03C0         printf("\"*pasw#RELEY:02\" ");
	__POINTW1FN _0x0,459
	CALL SUBOPT_0x17
; 0000 03C1         #asm("wdr")
	wdr
; 0000 03C2         printf("\"*pasw#RELEY:02M\" ");
	__POINTW1FN _0x0,477
	CALL SUBOPT_0x17
; 0000 03C3         #asm("wdr")
	wdr
; 0000 03C4         printf("RELEY: %s,",reley1command);
	__POINTW1FN _0x0,496
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(_reley1command)
	LDI  R31,HIGH(_reley1command)
	CALL SUBOPT_0x28
; 0000 03C5         #asm("wdr")
	wdr
; 0000 03C6         printf("%s,",reley2command);
	__POINTW1FN _0x0,503
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(_reley2command)
	LDI  R31,HIGH(_reley2command)
	CALL SUBOPT_0x28
; 0000 03C7            #asm("wdr")
	wdr
; 0000 03C8         printf("%s,",reley3command);
	__POINTW1FN _0x0,503
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(_reley3command)
	LDI  R31,HIGH(_reley3command)
	CALL SUBOPT_0x28
; 0000 03C9            #asm("wdr")
	wdr
; 0000 03CA         printf("%s ",reley4command);
	__POINTW1FN _0x0,507
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(_reley4command)
	LDI  R31,HIGH(_reley4command)
	CALL SUBOPT_0x28
; 0000 03CB         //printf("\"*pasw#SETPASS:pasw\" ");
; 0000 03CC         //printf("\"*pasw#SETPHONE:+71234567890\" ");
; 0000 03CD         delay_ms(200);
	CALL SUBOPT_0xC
; 0000 03CE         putchar(0x1A); //ctrl+Z
	LDI  R30,LOW(26)
	CALL SUBOPT_0x18
; 0000 03CF         putchar('\n');
; 0000 03D0         status=okststusM590();
_0x20C0005:
	CALL _okststusM590
	MOV  R17,R30
; 0000 03D1 
; 0000 03D2 return status;
_0x20C0006:
	MOV  R30,R17
_0x20C0007:
	LD   R17,Y+
	RET
; 0000 03D3 }
;
;
;
;void parseSMS(void){
; 0000 03D7 void parseSMS(void){
_parseSMS:
	PUSH R15
; 0000 03D8     unsigned char counter=0;
; 0000 03D9    unsigned char counter1;
; 0000 03DA     char password[5];
; 0000 03DB     bit durflag;
; 0000 03DC     char *ptr_to_ram;
; 0000 03DD     char *comand;
; 0000 03DE     char *argument;
; 0000 03DF 
; 0000 03E0 
; 0000 03E1                counter=0;
	SBIW R28,7
	CALL __SAVELOCR6
;	counter -> R17
;	counter1 -> R16
;	password -> Y+8
;	durflag -> R15.0
;	*ptr_to_ram -> R18,R19
;	*comand -> R20,R21
;	*argument -> Y+6
	LDI  R17,0
	LDI  R17,LOW(0)
; 0000 03E2                counter1=0;
	LDI  R16,LOW(0)
; 0000 03E3                #asm("wdr")
	wdr
; 0000 03E4                do {
_0xF9:
; 0000 03E5                 if (RX_text[counter]=='"') break;
	CALL SUBOPT_0xA
	SUBI R30,LOW(-_RX_text)
	SBCI R31,HIGH(-_RX_text)
	LD   R30,Z
	CPI  R30,LOW(0x22)
	BREQ _0xFA
; 0000 03E6 		#asm("wdr")
	wdr
; 0000 03E7                 counter++;
	SUBI R17,-1
; 0000 03E8                } while (counter<RXbufersize) ;
	CPI  R17,254
	BRLO _0xF9
_0xFA:
; 0000 03E9                counter++;
	SUBI R17,-1
; 0000 03EA                do{
_0xFD:
; 0000 03EB                     if (RX_text[counter]!='"'){
	CALL SUBOPT_0xA
	SUBI R30,LOW(-_RX_text)
	SBCI R31,HIGH(-_RX_text)
	LD   R30,Z
	CPI  R30,LOW(0x22)
	BREQ _0xFF
; 0000 03EC                         phone[counter1] = RX_text[counter];
	CALL SUBOPT_0x2C
	SUBI R26,LOW(-_phone)
	SBCI R27,HIGH(-_phone)
	CALL SUBOPT_0xA
	SUBI R30,LOW(-_RX_text)
	SBCI R31,HIGH(-_RX_text)
	LD   R30,Z
	ST   X,R30
; 0000 03ED                         counter1++;
	SUBI R16,-1
; 0000 03EE                         counter++;
	SUBI R17,-1
; 0000 03EF                         #asm("wdr")
	wdr
; 0000 03F0                         if (counter1>12) break;
	CPI  R16,13
	BRSH _0xFE
; 0000 03F1                     }else break ;
	RJMP _0x101
_0xFF:
	RJMP _0xFE
; 0000 03F2 		    #asm("wdr")
_0x101:
	wdr
; 0000 03F3 
; 0000 03F4                }while (counter<RXbufersize);
	CPI  R17,254
	BRLO _0xFD
_0xFE:
; 0000 03F5                phone[counter1]='\0';
	CALL SUBOPT_0x2D
	SUBI R30,LOW(-_phone)
	SBCI R31,HIGH(-_phone)
	LDI  R26,LOW(0)
	STD  Z+0,R26
; 0000 03F6                getstring(RX_text,RXbufersize);
	CALL SUBOPT_0x29
	CALL SUBOPT_0x2A
; 0000 03F7                clearFIFO();
	CALL _clearFIFO
; 0000 03F8                #asm("wdr")
	wdr
; 0000 03F9                if (RX_text[0]=='*'){
	LDS  R26,_RX_text
	CPI  R26,LOW(0x2A)
	BREQ PC+3
	JMP _0x102
; 0000 03FA                     for (counter=0; counter<=3; counter++){
	LDI  R17,LOW(0)
_0x104:
	CPI  R17,4
	BRSH _0x105
; 0000 03FB                         password[counter]=RX_text[counter+1];
	CALL SUBOPT_0xA
	MOVW R26,R28
	ADIW R26,8
	ADD  R26,R30
	ADC  R27,R31
	__ADDW1MN _RX_text,1
	LD   R30,Z
	ST   X,R30
; 0000 03FC                     }
	SUBI R17,-1
	RJMP _0x104
_0x105:
; 0000 03FD                     password[4]=0;
	LDI  R30,LOW(0)
	STD  Y+12,R30
; 0000 03FE                     #asm("wdr")
	wdr
; 0000 03FF                     if ((strcmp(password,masterpass)==0)||(strcmp(password,userpass)==0)){
	MOVW R30,R28
	ADIW R30,8
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(_masterpass)
	LDI  R31,HIGH(_masterpass)
	ST   -Y,R31
	ST   -Y,R30
	CALL _strcmp
	CPI  R30,0
	BREQ _0x107
	MOVW R30,R28
	ADIW R30,8
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(_userpass)
	LDI  R31,HIGH(_userpass)
	ST   -Y,R31
	ST   -Y,R30
	CALL _strcmp
	CPI  R30,0
	BREQ _0x107
	JMP  _0x106
_0x107:
; 0000 0400 
; 0000 0401                         counter=0;
	LDI  R17,LOW(0)
; 0000 0402 
; 0000 0403                         ptr_to_ram=RX_text;
	__POINTWRM 18,19,_RX_text
; 0000 0404 			#asm("wdr")
	wdr
; 0000 0405                         strtoup(ptr_to_ram);
	ST   -Y,R19
	ST   -Y,R18
	CALL _strtoup
; 0000 0406                         ptr_to_ram+=6; //*PASS#
	__ADDWRN 18,19,6
; 0000 0407 
; 0000 0408                         #asm("wdr")
	wdr
; 0000 0409                         if(ansvercmp(ptr_to_ram,"STATUS")==0){
	ST   -Y,R19
	ST   -Y,R18
	__POINTW1FN _0x0,511
	CALL SUBOPT_0x19
	BRNE _0x109
; 0000 040A                             statusSMS();
	CALL _statusSMS
; 0000 040B                         }else if(ansvercmp(ptr_to_ram,"BALANS")==0){
	JMP  _0x10A
_0x109:
	ST   -Y,R19
	ST   -Y,R18
	__POINTW1FN _0x0,518
	CALL SUBOPT_0x19
	BRNE _0x10B
; 0000 040C                             billingSMS();
	CALL _billingSMS
; 0000 040D                         }else if(ansvercmp(ptr_to_ram,"BILLING")==0){
	JMP  _0x10C
_0x10B:
	ST   -Y,R19
	ST   -Y,R18
	__POINTW1FN _0x0,525
	CALL SUBOPT_0x19
	BRNE _0x10D
; 0000 040E                             billingSMS();
	CALL _billingSMS
; 0000 040F                         /*}else if(ansvercmp(ptr_to_ram,"CLEARSMS")==0){
; 0000 0410                             m590command("AT+CMGD=1,4");*/
; 0000 0411                         }else if(ansvercmp(ptr_to_ram,"HELP")==0){
	JMP  _0x10E
_0x10D:
	ST   -Y,R19
	ST   -Y,R18
	__POINTW1FN _0x0,533
	CALL SUBOPT_0x19
	BRNE _0x10F
; 0000 0412                             helpSMS();
	CALL _helpSMS
; 0000 0413                         }else{
	JMP  _0x110
_0x10F:
; 0000 0414                             if (strstrf(ptr_to_ram,":")!=NULL){
	ST   -Y,R19
	ST   -Y,R18
	__POINTW1FN _0x0,36
	CALL SUBOPT_0x1C
	BRNE PC+3
	JMP _0x111
; 0000 0415                                 comand=  strtok(ptr_to_ram,":");
	ST   -Y,R19
	ST   -Y,R18
	CALL SUBOPT_0x2E
	MOVW R20,R30
; 0000 0416                                 argument=  strtok(NULL,":");
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	CALL SUBOPT_0x2E
	STD  Y+6,R30
	STD  Y+6+1,R31
; 0000 0417                                 if(strcmpf(comand,"SETPASS")==0){
	ST   -Y,R21
	ST   -Y,R20
	__POINTW1FN _0x0,538
	ST   -Y,R31
	ST   -Y,R30
	CALL _strcmpf
	CPI  R30,0
	BRNE _0x112
; 0000 0418                                    // password setting
; 0000 0419                                     for (counter=0; counter<=3; counter++){
	LDI  R17,LOW(0)
_0x114:
	CPI  R17,4
	BRSH _0x115
; 0000 041A                                         #asm("cli")
	cli
; 0000 041B                                         eeuserpass[counter] = argument[counter];
	CALL SUBOPT_0xA
	SUBI R30,LOW(-_eeuserpass)
	SBCI R31,HIGH(-_eeuserpass)
	CALL SUBOPT_0x2F
	CALL __EEPROMWRB
; 0000 041C                                         #asm("sei")
	sei
; 0000 041D                                         #asm("wdr")
	wdr
; 0000 041E                                         userpass[counter] = argument[counter];
	CALL SUBOPT_0xA
	SUBI R30,LOW(-_userpass)
	SBCI R31,HIGH(-_userpass)
	CALL SUBOPT_0x2F
	ST   X,R30
; 0000 041F                                     }
	SUBI R17,-1
	RJMP _0x114
_0x115:
; 0000 0420                                     #asm("wdr")
	wdr
; 0000 0421                                     statusSMSOK();
	JMP  _0x1EF
; 0000 0422                                 //}else if((strcmp(password,masterpass)==0)&&(strcmpf(comand,"SETPHONE")==0)){ //masrerpassword only
; 0000 0423                                 }else if (strcmpf(comand,"SETPHONE")==0){
_0x112:
	ST   -Y,R21
	ST   -Y,R20
	__POINTW1FN _0x0,546
	ST   -Y,R31
	ST   -Y,R30
	CALL _strcmpf
	CPI  R30,0
	BRNE _0x117
; 0000 0424                                    // phone allarm setting
; 0000 0425                                     durflag=0;
	CLT
	BLD  R15,0
; 0000 0426 
; 0000 0427                                     if ((argument[0] == '+')||(argument[0] == '8')) durflag=1;
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LD   R26,X
	CPI  R26,LOW(0x2B)
	BREQ _0x119
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LD   R26,X
	CPI  R26,LOW(0x38)
	BRNE _0x118
_0x119:
	SET
	BLD  R15,0
; 0000 0428                                     #asm("wdr")
_0x118:
	wdr
; 0000 0429                                     counter=0;
	LDI  R17,LOW(0)
; 0000 042A                                     if (durflag==1){
	LDI  R26,0
	SBRC R15,0
	LDI  R26,1
	CPI  R26,LOW(0x1)
	BRNE _0x11B
; 0000 042B                                             while ((argument[counter]!='\r')&&(counter<=12)){
_0x11C:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	CLR  R30
	ADD  R26,R17
	ADC  R27,R30
	LD   R26,X
	CPI  R26,LOW(0xD)
	BREQ _0x11F
	CPI  R17,13
	BRLO _0x120
_0x11F:
	RJMP _0x11E
_0x120:
; 0000 042C                                                 #asm("cli")
	cli
; 0000 042D                                                 eealarmphone[counter] = argument[counter];
	CALL SUBOPT_0xA
	SUBI R30,LOW(-_eealarmphone)
	SBCI R31,HIGH(-_eealarmphone)
	CALL SUBOPT_0x2F
	CALL __EEPROMWRB
; 0000 042E                                                 #asm("sei")
	sei
; 0000 042F                                                 #asm("wdr")
	wdr
; 0000 0430                                                 alarmphone[counter] = argument[counter];
	CALL SUBOPT_0xA
	SUBI R30,LOW(-_alarmphone)
	SBCI R31,HIGH(-_alarmphone)
	CALL SUBOPT_0x2F
	ST   X,R30
; 0000 0431                                                 counter++;
	SUBI R17,-1
; 0000 0432                                             }
	RJMP _0x11C
_0x11E:
; 0000 0433                                             statusSMSOK();
	CALL _statusSMSOK
; 0000 0434                                     }
; 0000 0435                                 }else if(strstr(comand,reley1command)!=NULL){
_0x11B:
	JMP  _0x121
_0x117:
	ST   -Y,R21
	ST   -Y,R20
	CALL SUBOPT_0x30
	BRNE PC+3
	JMP _0x122
; 0000 0436                                         reley1ontime=0;
	CALL SUBOPT_0x31
; 0000 0437                                         if ( (argument[0] >= '0') && (argument[0] <= '9') ){
	BRLO _0x124
	CALL SUBOPT_0x32
	BRLO _0x125
_0x124:
	RJMP _0x123
_0x125:
; 0000 0438                                             reley1ontime=argument[0]-'0';
	CALL SUBOPT_0x33
	CALL SUBOPT_0x34
; 0000 0439                                             #asm("wdr")
	wdr
; 0000 043A                                             if ( (argument[1] >= '0') && (argument[1] <= '9') ){
	CALL SUBOPT_0x35
	CPI  R26,LOW(0x30)
	BRLO _0x127
	CALL SUBOPT_0x35
	CPI  R26,LOW(0x3A)
	BRLO _0x128
_0x127:
	RJMP _0x126
_0x128:
; 0000 043B                                                 reley1ontime*=10;
	CALL SUBOPT_0x36
	LDI  R30,LOW(10)
	CALL SUBOPT_0x37
; 0000 043C                                                 #asm("wdr")
	wdr
; 0000 043D                                                 reley1ontime+=argument[1]-'0';
	CALL SUBOPT_0x38
	CALL SUBOPT_0x39
; 0000 043E                                                 #asm("wdr")
	wdr
; 0000 043F                                                 if ( (argument[2] >= '0') && (argument[2] <= '9') ){
	CALL SUBOPT_0x3A
	CPI  R26,LOW(0x30)
	BRLO _0x12A
	CALL SUBOPT_0x3A
	CPI  R26,LOW(0x3A)
	BRLO _0x12B
_0x12A:
	RJMP _0x129
_0x12B:
; 0000 0440                                                     reley1ontime*=10;
	CALL SUBOPT_0x36
	LDI  R30,LOW(10)
	CALL SUBOPT_0x37
; 0000 0441                                                     #asm("wdr")
	wdr
; 0000 0442                                                     reley1ontime+=argument[2]-'0';
	CALL SUBOPT_0x3B
	CALL SUBOPT_0x39
; 0000 0443                                                     #asm("wdr")
	wdr
; 0000 0444                                                 }else if  (argument[2] == 'M')
	RJMP _0x12C
_0x129:
	CALL SUBOPT_0x3A
	CPI  R26,LOW(0x4D)
	BRNE _0x12D
; 0000 0445                                                     reley1ontime*=60;
	CALL SUBOPT_0x36
	LDI  R30,LOW(60)
	CALL SUBOPT_0x37
; 0000 0446                                                 #asm("wdr")
_0x12D:
_0x12C:
	wdr
; 0000 0447                                             }else if  (argument[1] == 'M') {
	RJMP _0x12E
_0x126:
	CALL SUBOPT_0x35
	CPI  R26,LOW(0x4D)
	BRNE _0x12F
; 0000 0448                                                 reley1ontime*=60;
	CALL SUBOPT_0x36
	LDI  R30,LOW(60)
	CALL SUBOPT_0x37
; 0000 0449                                             };
_0x12F:
_0x12E:
; 0000 044A                                         };
_0x123:
; 0000 044B                                         #asm("wdr")
	wdr
; 0000 044C                                         if (reley1ontime>0){
	CALL SUBOPT_0x36
	CALL __CPW02
	BRSH _0x130
; 0000 044D                                             #asm("cli")
	cli
; 0000 044E                                             reley1counter= reley1ontime;
	LDS  R30,_reley1ontime
	LDS  R31,_reley1ontime+1
	CALL SUBOPT_0x3C
; 0000 044F                                             #asm("sei")
	sei
; 0000 0450                                         }else{
	RJMP _0x131
_0x130:
; 0000 0451                                             #asm("cli")
	cli
; 0000 0452                                             reley1counter = reley1delay;
	CALL SUBOPT_0x3D
; 0000 0453                                             #asm("sei")
	sei
; 0000 0454                                         }
_0x131:
; 0000 0455                                         #asm("wdr")
	wdr
; 0000 0456                                 }else if(strstr(comand,reley2command)!=NULL){
	JMP  _0x132
_0x122:
	ST   -Y,R21
	ST   -Y,R20
	CALL SUBOPT_0x3E
	BRNE PC+3
	JMP _0x133
; 0000 0457                                         reley1ontime=0;
	CALL SUBOPT_0x31
; 0000 0458                                         if ( (argument[0] >= '0') && (argument[0] <= '9') ){
	BRLO _0x135
	CALL SUBOPT_0x32
	BRLO _0x136
_0x135:
	RJMP _0x134
_0x136:
; 0000 0459                                             reley2ontime=argument[0]-'0';
	CALL SUBOPT_0x33
	CALL SUBOPT_0x3F
; 0000 045A                                             #asm("wdr")
	wdr
; 0000 045B                                             if ( (argument[1] >= '0') && (argument[1] <= '9') ){
	CALL SUBOPT_0x35
	CPI  R26,LOW(0x30)
	BRLO _0x138
	CALL SUBOPT_0x35
	CPI  R26,LOW(0x3A)
	BRLO _0x139
_0x138:
	RJMP _0x137
_0x139:
; 0000 045C                                                 reley2ontime*=10;
	CALL SUBOPT_0x40
	LDI  R30,LOW(10)
	CALL SUBOPT_0x41
; 0000 045D                                                 #asm("wdr")
	wdr
; 0000 045E                                                 reley2ontime+=argument[1]-'0';
	CALL SUBOPT_0x38
	CALL SUBOPT_0x42
; 0000 045F                                                 #asm("wdr")
	wdr
; 0000 0460                                                 if ( (argument[2] >= '0') && (argument[2] <= '9') ){
	CALL SUBOPT_0x3A
	CPI  R26,LOW(0x30)
	BRLO _0x13B
	CALL SUBOPT_0x3A
	CPI  R26,LOW(0x3A)
	BRLO _0x13C
_0x13B:
	RJMP _0x13A
_0x13C:
; 0000 0461                                                     reley2ontime*=10;
	CALL SUBOPT_0x40
	LDI  R30,LOW(10)
	CALL SUBOPT_0x41
; 0000 0462                                                     #asm("wdr")
	wdr
; 0000 0463                                                     reley2ontime+=argument[2]-'0';
	CALL SUBOPT_0x3B
	CALL SUBOPT_0x42
; 0000 0464                                                     #asm("wdr")
	wdr
; 0000 0465                                                 }else if  (argument[2] == 'M')
	RJMP _0x13D
_0x13A:
	CALL SUBOPT_0x3A
	CPI  R26,LOW(0x4D)
	BRNE _0x13E
; 0000 0466                                                     reley2ontime*=60;
	CALL SUBOPT_0x40
	LDI  R30,LOW(60)
	CALL SUBOPT_0x41
; 0000 0467                                                 #asm("wdr")
_0x13E:
_0x13D:
	wdr
; 0000 0468                                             }else if  (argument[1] == 'M') {
	RJMP _0x13F
_0x137:
	CALL SUBOPT_0x35
	CPI  R26,LOW(0x4D)
	BRNE _0x140
; 0000 0469                                                 reley2ontime*=60;
	CALL SUBOPT_0x40
	LDI  R30,LOW(60)
	CALL SUBOPT_0x41
; 0000 046A                                             };
_0x140:
_0x13F:
; 0000 046B                                         };
_0x134:
; 0000 046C                                         #asm("wdr")
	wdr
; 0000 046D                                         if (reley2ontime>0){
	CALL SUBOPT_0x40
	CALL __CPW02
	BRSH _0x141
; 0000 046E                                             #asm("cli")
	cli
; 0000 046F                                             reley2counter= reley2ontime;
	LDS  R30,_reley2ontime
	LDS  R31,_reley2ontime+1
	CALL SUBOPT_0x43
; 0000 0470                                             #asm("sei")
	sei
; 0000 0471                                         }else{
	RJMP _0x142
_0x141:
; 0000 0472                                             #asm("cli")
	cli
; 0000 0473                                             reley2counter = reley2delay;
	CALL SUBOPT_0x44
; 0000 0474                                             #asm("sei")
	sei
; 0000 0475                                         }
_0x142:
; 0000 0476                                         #asm("wdr")
	wdr
; 0000 0477                                 }else if(strstr(comand,reley3command)!=NULL){
	JMP  _0x143
_0x133:
	ST   -Y,R21
	ST   -Y,R20
	CALL SUBOPT_0x45
	BRNE PC+3
	JMP _0x144
; 0000 0478                                         reley3ontime=0;
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	CALL SUBOPT_0x46
; 0000 0479                                         if ( (argument[0] >= '0') && (argument[0] <= '9') ){
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LD   R26,X
	CPI  R26,LOW(0x30)
	BRLO _0x146
	CALL SUBOPT_0x32
	BRLO _0x147
_0x146:
	RJMP _0x145
_0x147:
; 0000 047A                                             reley3ontime=argument[0]-'0';
	CALL SUBOPT_0x33
	CALL SUBOPT_0x46
; 0000 047B                                             #asm("wdr")
	wdr
; 0000 047C                                             if ( (argument[1] >= '0') && (argument[1] <= '9') ){
	CALL SUBOPT_0x35
	CPI  R26,LOW(0x30)
	BRLO _0x149
	CALL SUBOPT_0x35
	CPI  R26,LOW(0x3A)
	BRLO _0x14A
_0x149:
	RJMP _0x148
_0x14A:
; 0000 047D                                                 reley3ontime*=10;
	CALL SUBOPT_0x47
	LDI  R30,LOW(10)
	CALL SUBOPT_0x48
; 0000 047E                                                 #asm("wdr")
	wdr
; 0000 047F                                                 reley3ontime+=argument[1]-'0';
	CALL SUBOPT_0x38
	CALL SUBOPT_0x49
; 0000 0480                                                 #asm("wdr")
	wdr
; 0000 0481                                                 if ( (argument[2] >= '0') && (argument[2] <= '9') ){
	CALL SUBOPT_0x3A
	CPI  R26,LOW(0x30)
	BRLO _0x14C
	CALL SUBOPT_0x3A
	CPI  R26,LOW(0x3A)
	BRLO _0x14D
_0x14C:
	RJMP _0x14B
_0x14D:
; 0000 0482                                                     reley3ontime*=10;
	CALL SUBOPT_0x47
	LDI  R30,LOW(10)
	CALL SUBOPT_0x48
; 0000 0483                                                     #asm("wdr")
	wdr
; 0000 0484                                                     reley3ontime+=argument[2]-'0';
	CALL SUBOPT_0x3B
	CALL SUBOPT_0x49
; 0000 0485                                                     #asm("wdr")
	wdr
; 0000 0486                                                 }else if  (argument[2] == 'M')
	RJMP _0x14E
_0x14B:
	CALL SUBOPT_0x3A
	CPI  R26,LOW(0x4D)
	BRNE _0x14F
; 0000 0487                                                     reley3ontime*=60;
	CALL SUBOPT_0x47
	LDI  R30,LOW(60)
	CALL SUBOPT_0x48
; 0000 0488                                                 #asm("wdr")
_0x14F:
_0x14E:
	wdr
; 0000 0489                                             }else if  (argument[1] == 'M') {
	RJMP _0x150
_0x148:
	CALL SUBOPT_0x35
	CPI  R26,LOW(0x4D)
	BRNE _0x151
; 0000 048A                                                 reley3ontime*=60;
	CALL SUBOPT_0x47
	LDI  R30,LOW(60)
	CALL SUBOPT_0x48
; 0000 048B                                             };
_0x151:
_0x150:
; 0000 048C                                         };
_0x145:
; 0000 048D                                         #asm("wdr")
	wdr
; 0000 048E                                         if (reley3ontime>0){
	CALL SUBOPT_0x47
	CALL __CPW02
	BRSH _0x152
; 0000 048F                                             #asm("cli")
	cli
; 0000 0490                                             reley3counter= reley3ontime;
	LDS  R30,_reley3ontime
	LDS  R31,_reley3ontime+1
	CALL SUBOPT_0x4A
; 0000 0491                                             #asm("sei")
	sei
; 0000 0492                                         }else{
	RJMP _0x153
_0x152:
; 0000 0493                                             #asm("cli")
	cli
; 0000 0494                                             reley3counter = reley3delay;
	CALL SUBOPT_0x4B
; 0000 0495                                             #asm("sei")
	sei
; 0000 0496                                         }
_0x153:
; 0000 0497                                         #asm("wdr")
	wdr
; 0000 0498                                         statusSMSOK();
	RJMP _0x1EF
; 0000 0499                                 }else if(strstr(comand,reley4command)!=NULL){
_0x144:
	ST   -Y,R21
	ST   -Y,R20
	CALL SUBOPT_0x4C
	BRNE PC+3
	JMP _0x155
; 0000 049A                                         reley4ontime=0;
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	CALL SUBOPT_0x4D
; 0000 049B                                         if ( (argument[0] >= '0') && (argument[0] <= '9') ){
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LD   R26,X
	CPI  R26,LOW(0x30)
	BRLO _0x157
	CALL SUBOPT_0x32
	BRLO _0x158
_0x157:
	RJMP _0x156
_0x158:
; 0000 049C                                             reley4ontime=argument[0]-'0';
	CALL SUBOPT_0x33
	CALL SUBOPT_0x4D
; 0000 049D                                             #asm("wdr")
	wdr
; 0000 049E                                             if ( (argument[1] >= '0') && (argument[1] <= '9') ){
	CALL SUBOPT_0x35
	CPI  R26,LOW(0x30)
	BRLO _0x15A
	CALL SUBOPT_0x35
	CPI  R26,LOW(0x3A)
	BRLO _0x15B
_0x15A:
	RJMP _0x159
_0x15B:
; 0000 049F                                                 reley4ontime*=10;
	CALL SUBOPT_0x4E
	LDI  R30,LOW(10)
	CALL SUBOPT_0x4F
; 0000 04A0                                                 #asm("wdr")
	wdr
; 0000 04A1                                                 reley4ontime+=argument[1]-'0';
	CALL SUBOPT_0x38
	CALL SUBOPT_0x50
; 0000 04A2                                                 #asm("wdr")
	wdr
; 0000 04A3                                                 if ( (argument[2] >= '0') && (argument[2] <= '9') ){
	CALL SUBOPT_0x3A
	CPI  R26,LOW(0x30)
	BRLO _0x15D
	CALL SUBOPT_0x3A
	CPI  R26,LOW(0x3A)
	BRLO _0x15E
_0x15D:
	RJMP _0x15C
_0x15E:
; 0000 04A4                                                     reley4ontime*=10;
	CALL SUBOPT_0x4E
	LDI  R30,LOW(10)
	CALL SUBOPT_0x4F
; 0000 04A5                                                     #asm("wdr")
	wdr
; 0000 04A6                                                     reley4ontime+=argument[2]-'0';
	CALL SUBOPT_0x3B
	CALL SUBOPT_0x50
; 0000 04A7                                                     #asm("wdr")
	wdr
; 0000 04A8                                                 }else if  (argument[2] == 'M')
	RJMP _0x15F
_0x15C:
	CALL SUBOPT_0x3A
	CPI  R26,LOW(0x4D)
	BRNE _0x160
; 0000 04A9                                                     reley4ontime*=60;
	CALL SUBOPT_0x4E
	LDI  R30,LOW(60)
	CALL SUBOPT_0x4F
; 0000 04AA                                                 #asm("wdr")
_0x160:
_0x15F:
	wdr
; 0000 04AB                                             }else if  (argument[1] == 'M') {
	RJMP _0x161
_0x159:
	CALL SUBOPT_0x35
	CPI  R26,LOW(0x4D)
	BRNE _0x162
; 0000 04AC                                                 reley4ontime*=60;
	CALL SUBOPT_0x4E
	LDI  R30,LOW(60)
	CALL SUBOPT_0x4F
; 0000 04AD                                             };
_0x162:
_0x161:
; 0000 04AE                                         };
_0x156:
; 0000 04AF                                         #asm("wdr")
	wdr
; 0000 04B0                                         if (reley4ontime>0){
	CALL SUBOPT_0x4E
	CALL __CPW02
	BRSH _0x163
; 0000 04B1                                             #asm("cli")
	cli
; 0000 04B2                                             reley4counter= reley4ontime;
	LDS  R30,_reley4ontime
	LDS  R31,_reley4ontime+1
	CALL SUBOPT_0x51
; 0000 04B3                                             #asm("sei")
	sei
; 0000 04B4                                         }else{
	RJMP _0x164
_0x163:
; 0000 04B5                                             #asm("cli")
	cli
; 0000 04B6                                             reley4counter = reley4delay;
	CALL SUBOPT_0x52
; 0000 04B7                                             #asm("sei")
	sei
; 0000 04B8                                         }
_0x164:
; 0000 04B9                                         #asm("wdr")
	wdr
; 0000 04BA                                        statusSMSOK();
_0x1EF:
	CALL _statusSMSOK
; 0000 04BB                                 }
; 0000 04BC                             }else{
_0x155:
_0x143:
_0x132:
_0x121:
	RJMP _0x165
_0x111:
; 0000 04BD                                 if(strstr(ptr_to_ram,reley1command)!=NULL){
	ST   -Y,R19
	ST   -Y,R18
	CALL SUBOPT_0x30
	BREQ _0x166
; 0000 04BE                                     #asm("cli")
	cli
; 0000 04BF                                     reley1counter=reley1delay;
	CALL SUBOPT_0x3D
; 0000 04C0                                     #asm("sei")
	sei
; 0000 04C1                                 }else if(strstr(ptr_to_ram,reley2command)!=NULL){
	RJMP _0x167
_0x166:
	ST   -Y,R19
	ST   -Y,R18
	CALL SUBOPT_0x3E
	BREQ _0x168
; 0000 04C2                                     #asm("cli")
	cli
; 0000 04C3                                     reley2counter=reley2delay;
	CALL SUBOPT_0x44
; 0000 04C4                                     #asm("sei")
	sei
; 0000 04C5                                 }else if(strstr(ptr_to_ram,reley3command)!=NULL){
	RJMP _0x169
_0x168:
	ST   -Y,R19
	ST   -Y,R18
	CALL SUBOPT_0x45
	BREQ _0x16A
; 0000 04C6                                     #asm("cli")
	cli
; 0000 04C7                                     reley3counter=reley3delay;
	CALL SUBOPT_0x4B
; 0000 04C8                                     #asm("sei")
	sei
; 0000 04C9                                 }else if(strstr(ptr_to_ram,reley4command)!=NULL){
	RJMP _0x16B
_0x16A:
	ST   -Y,R19
	ST   -Y,R18
	CALL SUBOPT_0x4C
	BREQ _0x16C
; 0000 04CA                                     #asm("cli")
	cli
; 0000 04CB                                     reley4counter=reley4delay;
	CALL SUBOPT_0x52
; 0000 04CC                                     #asm("sei")
	sei
; 0000 04CD                                 }
; 0000 04CE                             }
_0x16C:
_0x16B:
_0x169:
_0x167:
_0x165:
; 0000 04CF                         }
_0x110:
_0x10E:
_0x10C:
_0x10A:
; 0000 04D0                     }
; 0000 04D1                }
_0x106:
; 0000 04D2         #asm("wdr")
_0x102:
	wdr
; 0000 04D3 }
	CALL __LOADLOCR6
	ADIW R28,13
	POP  R15
	RET
;
;#include <sleep.h>
;
;
;void main(void)
; 0000 04D9 {
_main:
; 0000 04DA // Declare your local variables here
; 0000 04DB 
; 0000 04DC // Crystal Oscillator division factor: 1
; 0000 04DD #pragma optsize-
; 0000 04DE CLKPR=0x80;
	LDI  R30,LOW(128)
	STS  97,R30
; 0000 04DF CLKPR=0x00;
	LDI  R30,LOW(0)
	STS  97,R30
; 0000 04E0 #ifdef _OPTIMIZE_SIZE_
; 0000 04E1 #pragma optsize+
; 0000 04E2 #endif
; 0000 04E3 
; 0000 04E4 // Input/Output Ports initialization
; 0000 04E5 // Port B initialization
; 0000 04E6 // Func7=In Func6=In Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out
; 0000 04E7 // State7=T State6=T State5=0 State4=0 State3=0 State2=0 State1=0 State0=0
; 0000 04E8 PORTB=0x00;
	OUT  0x5,R30
; 0000 04E9 DDRB=0x3F;
	LDI  R30,LOW(63)
	OUT  0x4,R30
; 0000 04EA 
; 0000 04EB /*
; 0000 04EC   //=================================
; 0000 04ED     M590_POWERPIN=1;
; 0000 04EE 
; 0000 04EF     #asm("wdr")
; 0000 04F0     delay_ms(500);
; 0000 04F1     #asm("wdr")
; 0000 04F2     delay_ms(500);
; 0000 04F3 
; 0000 04F4     #asm("wdr")
; 0000 04F5     delay_ms(500);
; 0000 04F6     #asm("wdr")
; 0000 04F7     delay_ms(500);
; 0000 04F8     #asm("wdr")
; 0000 04F9     M590_RELEY3PIN=1;
; 0000 04FA     while(1);
; 0000 04FB   //====================================
; 0000 04FC */
; 0000 04FD 
; 0000 04FE // Port C initialization
; 0000 04FF // Func6=In Func5=In Func4=In Func3=In Func2=Out Func1=Out Func0=Out
; 0000 0500 // State6=T State5=T State4=T State3=T State2=0 State1=0 State0=0
; 0000 0501 PORTC=0x00;
	LDI  R30,LOW(0)
	OUT  0x8,R30
; 0000 0502 DDRC=0x07;
	LDI  R30,LOW(7)
	OUT  0x7,R30
; 0000 0503 
; 0000 0504 // Port D initialization
; 0000 0505 // Func7=In Func6=Out Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
; 0000 0506 // State7=T State6=0 State5=T State4=T State3=T State2=T State1=T State0=T
; 0000 0507 PORTD=0x00;
	LDI  R30,LOW(0)
	OUT  0xB,R30
; 0000 0508 DDRD=0x40;
	LDI  R30,LOW(64)
	OUT  0xA,R30
; 0000 0509 
; 0000 050A // Timer/Counter 0 initialization
; 0000 050B // Clock source: System Clock
; 0000 050C // Clock value: Timer 0 Stopped
; 0000 050D // Mode: Normal top=FFh
; 0000 050E // OC0A output: Disconnected
; 0000 050F // OC0B output: Disconnected
; 0000 0510 TCCR0A=0x00;
	LDI  R30,LOW(0)
	OUT  0x24,R30
; 0000 0511 TCCR0B=0x00;
	OUT  0x25,R30
; 0000 0512 TCNT0=0x00;
	OUT  0x26,R30
; 0000 0513 OCR0A=0x00;
	OUT  0x27,R30
; 0000 0514 OCR0B=0x00;
	OUT  0x28,R30
; 0000 0515 
; 0000 0516 // Timer/Counter 1 initialization
; 0000 0517 // Clock source: System Clock
; 0000 0518 // Clock value: 15,625 kHz  (7,813 kHz for 8 MHz)
; 0000 0519 // Mode: Normal top=FFFFh
; 0000 051A // OC1A output: Discon.
; 0000 051B // OC1B output: Discon.
; 0000 051C // Noise Canceler: Off
; 0000 051D // Input Capture on Falling Edge
; 0000 051E // Timer 1 Overflow Interrupt: On
; 0000 051F // Input Capture Interrupt: Off
; 0000 0520 // Compare A Match Interrupt: Off
; 0000 0521 // Compare B Match Interrupt: Off
; 0000 0522 TCCR1A=0x00;
	STS  128,R30
; 0000 0523 TCCR1B=0x05;
	LDI  R30,LOW(5)
	STS  129,R30
; 0000 0524 
; 0000 0525 #ifdef C8MHZ
; 0000 0526     TCNT1H=0xE1;
; 0000 0527     TCNT1L=0x7B; //1Hz for 8MHz
; 0000 0528 #else
; 0000 0529     TCNT1H=0xC2;
	CALL SUBOPT_0x7
; 0000 052A     TCNT1L=0xF7; //1Hz for 16MHz
; 0000 052B #endif
; 0000 052C 
; 0000 052D 
; 0000 052E 
; 0000 052F ICR1H=0x00;
	LDI  R30,LOW(0)
	STS  135,R30
; 0000 0530 ICR1L=0x00;
	STS  134,R30
; 0000 0531 OCR1AH=0x00;
	STS  137,R30
; 0000 0532 OCR1AL=0x00;
	STS  136,R30
; 0000 0533 OCR1BH=0x00;
	STS  139,R30
; 0000 0534 OCR1BL=0x00;
	STS  138,R30
; 0000 0535 
; 0000 0536 // Timer/Counter 2 initialization
; 0000 0537 // Clock source: System Clock
; 0000 0538 // Clock value: Timer 2 Stopped
; 0000 0539 // Mode: Normal top=FFh
; 0000 053A // OC2A output: Disconnected
; 0000 053B // OC2B output: Disconnected
; 0000 053C ASSR=0x00;
	STS  182,R30
; 0000 053D TCCR2A=0x00;
	STS  176,R30
; 0000 053E TCCR2B=0x00;
	STS  177,R30
; 0000 053F TCNT2=0x00;
	STS  178,R30
; 0000 0540 OCR2A=0x00;
	STS  179,R30
; 0000 0541 OCR2B=0x00;
	STS  180,R30
; 0000 0542 
; 0000 0543 // External Interrupt(s) initialization
; 0000 0544 // INT0: Off
; 0000 0545 // INT1: On
; 0000 0546 // INT1 Mode: Rising Edge
; 0000 0547 // Interrupt on any change on pins PCINT0-7: Off
; 0000 0548 // Interrupt on any change on pins PCINT8-14: Off
; 0000 0549 // Interrupt on any change on pins PCINT16-23: Off
; 0000 054A EICRA=0x0C;
	LDI  R30,LOW(12)
	STS  105,R30
; 0000 054B EIMSK=0x02;
	LDI  R30,LOW(2)
	OUT  0x1D,R30
; 0000 054C EIFR=0x02;
	OUT  0x1C,R30
; 0000 054D PCICR=0x00;
	LDI  R30,LOW(0)
	STS  104,R30
; 0000 054E 
; 0000 054F 
; 0000 0550 
; 0000 0551 
; 0000 0552 
; 0000 0553 // Timer/Counter 0 Interrupt(s) initialization
; 0000 0554 TIMSK0=0x00;
	STS  110,R30
; 0000 0555 // Timer/Counter 1 Interrupt(s) initialization
; 0000 0556 TIMSK1=0x01;
	LDI  R30,LOW(1)
	STS  111,R30
; 0000 0557 // Timer/Counter 2 Interrupt(s) initialization
; 0000 0558 TIMSK2=0x00;
	LDI  R30,LOW(0)
	STS  112,R30
; 0000 0559 
; 0000 055A // USART initialization
; 0000 055B // Communication Parameters: 8 Data, 1 Stop, No Parity
; 0000 055C // USART Receiver: On
; 0000 055D // USART Transmitter: On
; 0000 055E // USART0 Mode: Asynchronous
; 0000 055F // USART Baud Rate: 9600
; 0000 0560 UCSR0A=0x00;
	STS  192,R30
; 0000 0561 UCSR0B=0x98;
	LDI  R30,LOW(152)
	STS  193,R30
; 0000 0562 UCSR0C=0x06;
	LDI  R30,LOW(6)
	STS  194,R30
; 0000 0563 UBRR0H=0x00;
	LDI  R30,LOW(0)
	STS  197,R30
; 0000 0564 #ifdef C8MHZ
; 0000 0565     UBRR0L=0x33; //8MHz
; 0000 0566 #else
; 0000 0567     UBRR0L=0x67; //16MHz
	LDI  R30,LOW(103)
	STS  196,R30
; 0000 0568 #endif
; 0000 0569 
; 0000 056A 
; 0000 056B // Analog Comparator initialization
; 0000 056C // Analog Comparator: Off
; 0000 056D // Analog Comparator Input Capture by Timer/Counter 1: Off
; 0000 056E ACSR=0x80;
	LDI  R30,LOW(128)
	OUT  0x30,R30
; 0000 056F ADCSRB=0x00;
	LDI  R30,LOW(0)
	STS  123,R30
; 0000 0570 
; 0000 0571 // ADC initialization
; 0000 0572 // ADC Clock frequency: 125,000 kHz   (62,500  kHz for 8 MHz)
; 0000 0573 // ADC Voltage Reference: Int., cap. on AREF
; 0000 0574 // ADC Auto Trigger Source: Free Running
; 0000 0575 // Digital input buffers on ADC0: Off, ADC1: Off, ADC2: Off, ADC3: On
; 0000 0576 // ADC4: Off, ADC5: Off
; 0000 0577 DIDR0=0x37;
	LDI  R30,LOW(55)
	STS  126,R30
; 0000 0578 ADMUX=ADC_VREF_TYPE & 0xff;
	LDI  R30,LOW(192)
	STS  124,R30
; 0000 0579 ADCSRA=0xA7;
	LDI  R30,LOW(167)
	STS  122,R30
; 0000 057A ADCSRB&=0xF8;
	LDI  R26,LOW(123)
	LDI  R27,HIGH(123)
	LD   R30,X
	LDI  R31,0
	ANDI R30,LOW(0xF8)
	ANDI R31,HIGH(0xF8)
	ST   X,R30
; 0000 057B 
; 0000 057C 
; 0000 057D // Watchdog Timer initialization
; 0000 057E // Watchdog Timer Prescaler: OSC/1024k
; 0000 057F // Watchdog Timer interrupt: Off
; 0000 0580 #pragma optsize-
; 0000 0581 #asm("wdr")
	wdr
; 0000 0582 WDTCSR=0x39;
	LDI  R30,LOW(57)
	STS  96,R30
; 0000 0583 WDTCSR=0x29;
	LDI  R30,LOW(41)
	STS  96,R30
; 0000 0584 #ifdef _OPTIMIZE_SIZE_
; 0000 0585 #pragma optsize+
; 0000 0586 #endif
; 0000 0587 
; 0000 0588 #asm("wdr")
	wdr
; 0000 0589 
; 0000 058A // Global enable interrupts
; 0000 058B 
; 0000 058C 
; 0000 058D 
; 0000 058E RELEY1PIN =0;
	CBI  0x5,2
; 0000 058F RELEY2PIN=0;
	CBI  0x5,3
; 0000 0590 RELEY3PIN =0;
	CBI  0x5,4
; 0000 0591 RELEY4PIN=0;
	CBI  0x5,5
; 0000 0592 
; 0000 0593 reley1counter=0;
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	CALL SUBOPT_0x3C
; 0000 0594 reley2counter=0;
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	CALL SUBOPT_0x43
; 0000 0595 reley3counter=0;
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	CALL SUBOPT_0x4A
; 0000 0596 reley4counter=0;
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	CALL SUBOPT_0x51
; 0000 0597 
; 0000 0598 #asm("wdr")
	wdr
; 0000 0599 eeprom2var();
	CALL _eeprom2var
; 0000 059A 
; 0000 059B #asm("sei")
	sei
; 0000 059C m590init();
	CALL _m590init
; 0000 059D sleep_enable();
	CALL _sleep_enable
; 0000 059E count10min=0;
	CLR  R6
	CLR  R7
; 0000 059F count1dey=0;
	CLR  R8
	CLR  R9
; 0000 05A0 alarmsending=0;
	CBI  0x1E,1
; 0000 05A1 lovlevelbat=0;
	CBI  0x1E,3
; 0000 05A2 lovbatsending=0;
	CBI  0x1E,2
; 0000 05A3 #asm("cli")
	cli
; 0000 05A4 alarmflag=0;
	CBI  0x1E,0
; 0000 05A5 flag1sec=0;
	CLR  R5
; 0000 05A6 #asm("sei")
	sei
; 0000 05A7 
; 0000 05A8 while (1)
_0x17D:
; 0000 05A9     {
; 0000 05AA       if (rx_counter0==0) idle();
	CALL SUBOPT_0x2
	BRNE _0x180
	CALL _idle
; 0000 05AB       #asm("wdr")
_0x180:
	wdr
; 0000 05AC       #asm("wdr")
	wdr
; 0000 05AD 
; 0000 05AE 
; 0000 05AF       if (rx_buffer_overflow0==1) clearFIFO();
	LDI  R26,0
	SBIC 0x1E,4
	LDI  R26,1
	CPI  R26,LOW(0x1)
	BRNE _0x181
	CALL _clearFIFO
; 0000 05B0       #asm("wdr")
_0x181:
	wdr
; 0000 05B1 
; 0000 05B2        if (alarmflag){
	SBIS 0x1E,0
	RJMP _0x182
; 0000 05B3 
; 0000 05B4             LEDPIN=1;
	SBI  0x8,2
; 0000 05B5             #asm("cli")
	cli
; 0000 05B6             alarmflag=0;
	CBI  0x1E,0
; 0000 05B7             alarmimeout=2; //3 sec
	LDI  R30,LOW(2)
	STS  _alarmimeout,R30
; 0000 05B8             #asm("sei")
	sei
; 0000 05B9             while (alarmimeout!=0){
_0x187:
	LDS  R30,_alarmimeout
	CPI  R30,0
	BREQ _0x189
; 0000 05BA                 #asm("wdr")
	wdr
; 0000 05BB             };
	RJMP _0x187
_0x189:
; 0000 05BC 
; 0000 05BD             if(ALARMPIN==1){
	LDI  R26,0
	SBIC 0x9,7
	LDI  R26,1
	CPI  R26,LOW(0x1)
	BREQ PC+3
	JMP _0x18A
; 0000 05BE                 clearFIFO();
	CALL _clearFIFO
; 0000 05BF                 M590_SLEEPPIN=1;
	SBI  0xB,6
; 0000 05C0                 delay_ms(200);
	CALL SUBOPT_0xC
; 0000 05C1                 #asm("wdr")
	wdr
; 0000 05C2                 while(1) {
_0x18D:
; 0000 05C3                     netststus=netstatusM590();
	CALL _netstatusM590
	MOV  R12,R30
; 0000 05C4 		    if (netststus==255) resetsistem();
	LDI  R30,LOW(255)
	CP   R30,R12
	BRNE _0x190
	CALL _resetsistem
; 0000 05C5                     if(netststus==1) break;
_0x190:
	LDI  R30,LOW(1)
	CP   R30,R12
	BREQ _0x18F
; 0000 05C6                     if(netststus==5) break;
	LDI  R30,LOW(5)
	CP   R30,R12
	BREQ _0x18F
; 0000 05C7                     LEDPIN=0;
	CBI  0x8,2
; 0000 05C8                     delay_ms(500);
	CALL SUBOPT_0x1D
; 0000 05C9                     #asm("wdr")
	wdr
; 0000 05CA                     delay_ms(500);
	CALL SUBOPT_0x1D
; 0000 05CB                     #asm("wdr")
	wdr
; 0000 05CC                     LEDPIN=1;
	SBI  0x8,2
; 0000 05CD                     delay_ms(500);
	CALL SUBOPT_0x1D
; 0000 05CE                     #asm("wdr")
	wdr
; 0000 05CF                     delay_ms(500);
	CALL SUBOPT_0x1D
; 0000 05D0                     #asm("wdr")
	wdr
; 0000 05D1                 };
	RJMP _0x18D
_0x18F:
; 0000 05D2                 #asm("wdr")
	wdr
; 0000 05D3 
; 0000 05D4                 LEDPIN=1;
	SBI  0x8,2
; 0000 05D5                 #asm("wdr")
	wdr
; 0000 05D6                 countalarmdial=2;
	LDI  R30,LOW(2)
	MOV  R4,R30
; 0000 05D7 
; 0000 05D8                 do {
_0x19A:
; 0000 05D9                     LEDPIN=1;
	SBI  0x8,2
; 0000 05DA                     if (alarmDial()==0) break;
	CALL _alarmDial
	CPI  R30,0
	BREQ _0x19B
; 0000 05DB                     #asm("wdr")
	wdr
; 0000 05DC                     countalarmdial--;
	DEC  R4
; 0000 05DD                     LEDPIN=0;
	CBI  0x8,2
; 0000 05DE                 }while (countalarmdial>0);
	LDI  R30,LOW(0)
	CP   R30,R4
	BRLO _0x19A
_0x19B:
; 0000 05DF 
; 0000 05E0                 if ((IGNITION==1)||(DOORPIN==0)) alarmsending=0;
	LDI  R26,0
	SBIC 0x9,4
	LDI  R26,1
	CPI  R26,LOW(0x1)
	BREQ _0x1A2
	LDI  R26,0
	SBIC 0x9,5
	LDI  R26,1
	CPI  R26,LOW(0x0)
	BRNE _0x1A1
_0x1A2:
	CBI  0x1E,1
; 0000 05E1                 if (alarmsending==0){
_0x1A1:
	SBIC 0x1E,1
	RJMP _0x1A6
; 0000 05E2                     alarmSMS();
	CALL _alarmSMS
; 0000 05E3                     #asm("wdr")
	wdr
; 0000 05E4                 }
; 0000 05E5 
; 0000 05E6                 M590_SLEEPPIN=0;
_0x1A6:
	CBI  0xB,6
; 0000 05E7                 LEDPIN=0;
	CBI  0x8,2
; 0000 05E8             }
; 0000 05E9             LEDPIN=0;
_0x18A:
	CBI  0x8,2
; 0000 05EA       }else if (rx_counter0!=0) {
	JMP  _0x1AD
_0x182:
	CALL SUBOPT_0x2
	BREQ _0x1AE
; 0000 05EB         M590_SLEEPPIN=1;
	SBI  0xB,6
; 0000 05EC         LEDPIN=1;
	SBI  0x8,2
; 0000 05ED 
; 0000 05EE         getstring(RX_text,RXbufersize);
	CALL SUBOPT_0x29
	CALL SUBOPT_0x2A
; 0000 05EF 
; 0000 05F0         if (ansvercmp(RX_text, "+CMT")==0){ //SMS
	CALL SUBOPT_0x29
	__POINTW1FN _0x0,555
	CALL SUBOPT_0x19
	BRNE _0x1B3
; 0000 05F1                 parseSMS();
	CALL _parseSMS
; 0000 05F2                 #asm("wdr")
	wdr
; 0000 05F3         }else if (ansvercmp(RX_text, "RING")==0){ //RING
	RJMP _0x1B4
_0x1B3:
	CALL SUBOPT_0x29
	__POINTW1FN _0x0,560
	CALL SUBOPT_0x19
	BRNE _0x1B5
; 0000 05F4             	m590command("ATH");
	__POINTW1FN _0x0,168
	CALL SUBOPT_0x2B
; 0000 05F5 	        #asm("wdr")
	wdr
; 0000 05F6         };
_0x1B5:
_0x1B4:
; 0000 05F7 
; 0000 05F8         delay_ms(200);
	CALL SUBOPT_0xC
; 0000 05F9         LEDPIN=0;
	CBI  0x8,2
; 0000 05FA         #asm("wdr")
	wdr
; 0000 05FB         M590_SLEEPPIN=0;
	CBI  0xB,6
; 0000 05FC       }else if (flag1sec){
	JMP  _0x1BA
_0x1AE:
	TST  R5
	BRNE PC+3
	JMP _0x1BB
; 0000 05FD             #asm("cli")
	cli
; 0000 05FE             flag1sec=0;
	CLR  R5
; 0000 05FF             #asm("sei")
	sei
; 0000 0600 
; 0000 0601 
; 0000 0602 
; 0000 0603            #asm("wdr")
	wdr
; 0000 0604            if  (count10min==600) {  //10min
	LDI  R30,LOW(600)
	LDI  R31,HIGH(600)
	CP   R30,R6
	CPC  R31,R7
	BREQ PC+3
	JMP _0x1BC
; 0000 0605                 count10min=0;
	CLR  R6
	CLR  R7
; 0000 0606 
; 0000 0607                 LEDPIN=1;
	SBI  0x8,2
; 0000 0608                 #asm("wdr")
	wdr
; 0000 0609                 M590_SLEEPPIN=1;
	SBI  0xB,6
; 0000 060A                 delay_ms(200);
	CALL SUBOPT_0xC
; 0000 060B                 #asm("wdr")
	wdr
; 0000 060C                 delay_ms(200);
	CALL SUBOPT_0xC
; 0000 060D                 #asm("wdr")
	wdr
; 0000 060E                 delay_ms(200);
	CALL SUBOPT_0xC
; 0000 060F                 #asm("wdr")
	wdr
; 0000 0610                 delay_ms(200);
	CALL SUBOPT_0xC
; 0000 0611                 #asm("wdr")
	wdr
; 0000 0612 
; 0000 0613                 if (m590command("AT")==255) resetsistem();
	CALL SUBOPT_0x1E
	CPI  R30,LOW(0xFF)
	BRNE _0x1C1
	CALL _resetsistem
; 0000 0614                 if ((reley1counter==0)&&(reley2counter==0)&&(reley3counter==0)&&(reley4counter==0)) count1dey++;
_0x1C1:
	LDS  R26,_reley1counter
	LDS  R27,_reley1counter+1
	SBIW R26,0
	BRNE _0x1C3
	LDS  R26,_reley2counter
	LDS  R27,_reley2counter+1
	SBIW R26,0
	BRNE _0x1C3
	LDS  R26,_reley3counter
	LDS  R27,_reley3counter+1
	SBIW R26,0
	BRNE _0x1C3
	LDS  R26,_reley4counter
	LDS  R27,_reley4counter+1
	SBIW R26,0
	BREQ _0x1C4
_0x1C3:
	RJMP _0x1C2
_0x1C4:
	MOVW R30,R8
	ADIW R30,1
	MOVW R8,R30
; 0000 0615                 if (count1dey==144){  // - 
_0x1C2:
	LDI  R30,LOW(144)
	LDI  R31,HIGH(144)
	CP   R30,R8
	CPC  R31,R9
	BRNE _0x1C5
; 0000 0616                     #asm("wdr")
	wdr
; 0000 0617                     //  
; 0000 0618                     m590command("AT+CMGD=1,4");
	__POINTW1FN _0x0,565
	CALL SUBOPT_0x2B
; 0000 0619                     resetsistem();
	CALL _resetsistem
; 0000 061A                 }
; 0000 061B                 #asm("wdr")
_0x1C5:
	wdr
; 0000 061C                 if (IGNITION==0) {
	SBIC 0x9,4
	RJMP _0x1C6
; 0000 061D                     adcdata=read_adc();
	CALL SUBOPT_0x24
; 0000 061E                     #asm("wdr")
	wdr
; 0000 061F                     volt = (float) adcdata * voltdev;
	CALL SUBOPT_0x25
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	LDI  R26,LOW(_voltdev)
	LDI  R27,HIGH(_voltdev)
	CALL __EEPROMRDD
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CALL SUBOPT_0x26
; 0000 0620                     if (volt>11.7){ //bat <10%
	LDS  R26,_volt
	LDS  R27,_volt+1
	LDS  R24,_volt+2
	LDS  R25,_volt+3
	__GETD1N 0x413B3333
	CALL __CMPF12
	BREQ PC+2
	BRCC PC+3
	JMP  _0x1C7
; 0000 0621                         lovbatsending=0;
	CBI  0x1E,2
; 0000 0622                         lovlevelbat=0;
	CBI  0x1E,3
; 0000 0623                     }else {
	RJMP _0x1CC
_0x1C7:
; 0000 0624                         if ((lovlevelbat==1)&&(lovbatsending==0)){
	LDI  R26,0
	SBIC 0x1E,3
	LDI  R26,1
	CPI  R26,LOW(0x1)
	BRNE _0x1CE
	LDI  R26,0
	SBIC 0x1E,2
	LDI  R26,1
	CPI  R26,LOW(0x0)
	BREQ _0x1CF
_0x1CE:
	RJMP _0x1CD
_0x1CF:
; 0000 0625                             delay_ms(200);
	CALL SUBOPT_0xC
; 0000 0626                             #asm("wdr")
	wdr
; 0000 0627                             clearFIFO();
	CALL _clearFIFO
; 0000 0628                             counter=0;
	CLR  R13
; 0000 0629                             for (counter=0; counter<=strlen(alarmphone); counter++){
	CLR  R13
_0x1D1:
	LDI  R30,LOW(_alarmphone)
	LDI  R31,HIGH(_alarmphone)
	CALL SUBOPT_0x11
	MOV  R26,R13
	LDI  R27,0
	CP   R30,R26
	CPC  R31,R27
	BRLO _0x1D2
; 0000 062A                                 phone[counter] = alarmphone[counter];
	MOV  R26,R13
	LDI  R27,0
	SUBI R26,LOW(-_phone)
	SBCI R27,HIGH(-_phone)
	MOV  R30,R13
	LDI  R31,0
	SUBI R30,LOW(-_alarmphone)
	SBCI R31,HIGH(-_alarmphone)
	LD   R30,Z
	ST   X,R30
; 0000 062B                                 #asm("wdr")
	wdr
; 0000 062C                             }
	INC  R13
	RJMP _0x1D1
_0x1D2:
; 0000 062D                             while(1) {
_0x1D3:
; 0000 062E                                 netststus=netstatusM590();
	CALL _netstatusM590
	MOV  R12,R30
; 0000 062F 				                if (netststus==255) resetsistem();
	LDI  R30,LOW(255)
	CP   R30,R12
	BRNE _0x1D6
	CALL _resetsistem
; 0000 0630                                 if(netststus==1) break;
_0x1D6:
	LDI  R30,LOW(1)
	CP   R30,R12
	BREQ _0x1D5
; 0000 0631                                 if(netststus==5) break;
	LDI  R30,LOW(5)
	CP   R30,R12
	BREQ _0x1D5
; 0000 0632                                 LEDPIN=0;
	CBI  0x8,2
; 0000 0633                                 delay_ms(500);
	CALL SUBOPT_0x1D
; 0000 0634                                 #asm("wdr")
	wdr
; 0000 0635                                 delay_ms(500);
	CALL SUBOPT_0x1D
; 0000 0636                                 #asm("wdr")
	wdr
; 0000 0637                                 LEDPIN=1;
	SBI  0x8,2
; 0000 0638                                 delay_ms(500);
	CALL SUBOPT_0x1D
; 0000 0639                                 #asm("wdr")
	wdr
; 0000 063A                                 delay_ms(500);
	CALL SUBOPT_0x1D
; 0000 063B                                 #asm("wdr")
	wdr
; 0000 063C                             };
	RJMP _0x1D3
_0x1D5:
; 0000 063D                             statusSMS();
	CALL _statusSMS
; 0000 063E                             #asm("wdr")
	wdr
; 0000 063F                             lovbatsending=1;
	SBI  0x1E,2
; 0000 0640                         }
; 0000 0641                         lovlevelbat=1;
_0x1CD:
	SBI  0x1E,3
; 0000 0642                     }
_0x1CC:
; 0000 0643                 }
; 0000 0644                 M590_SLEEPPIN=0;
_0x1C6:
	CBI  0xB,6
; 0000 0645                 LEDPIN=0;
	CBI  0x8,2
; 0000 0646            } else count10min++;
	RJMP _0x1E5
_0x1BC:
	MOVW R30,R6
	ADIW R30,1
	MOVW R6,R30
; 0000 0647 
; 0000 0648            #asm("wdr")
_0x1E5:
	wdr
; 0000 0649 
; 0000 064A            if (alarmsending==1){
	LDI  R26,0
	SBIC 0x1E,1
	LDI  R26,1
	CPI  R26,LOW(0x1)
	BRNE _0x1E6
; 0000 064B                 #asm("wdr")
	wdr
; 0000 064C                 countalarmsend++;
	MOVW R30,R10
	ADIW R30,1
	MOVW R10,R30
	SBIW R30,1
; 0000 064D                 if  (countalarmsend>=180) { //3min
	LDI  R30,LOW(180)
	LDI  R31,HIGH(180)
	CP   R10,R30
	CPC  R11,R31
	BRLO _0x1E7
; 0000 064E                 countalarmsend=0;
	CLR  R10
	CLR  R11
; 0000 064F                 alarmsending=0;
	CBI  0x1E,1
; 0000 0650                 }
; 0000 0651            }
_0x1E7:
; 0000 0652            #asm("wdr")
_0x1E6:
	wdr
; 0000 0653       }
; 0000 0654       #asm("wdr")
_0x1BB:
_0x1BA:
_0x1AD:
	wdr
; 0000 0655     };
	JMP  _0x17D
; 0000 0656 }
_0x1EA:
	RJMP _0x1EA

	.CSEG
_strcmp:
    ld   r30,y+
    ld   r31,y+
    ld   r26,y+
    ld   r27,y+
strcmp0:
    ld   r22,x+
    ld   r23,z+
    cp   r22,r23
    brne strcmp1
    tst  r22
    brne strcmp0
strcmp3:
    clr  r30
    ret
strcmp1:
    sub  r22,r23
    breq strcmp3
    ldi  r30,1
    brcc strcmp2
    subi r30,2
strcmp2:
    ret
_strcmpf:
    ld   r30,y+
    ld   r31,y+
    ld   r26,y+
    ld   r27,y+
strcmpf0:
    ld   r1,x+
	lpm  r0,z+
    cp   r0,r1
    brne strcmpf1
    tst  r0
    brne strcmpf0
strcmpf3:
    clr  r30
    ret
strcmpf1:
    sub  r1,r0
    breq strcmpf3
    ldi  r30,1
    brcc strcmpf2
    subi r30,2
strcmpf2:
    ret
_strcpyf:
    ld   r30,y+
    ld   r31,y+
    ld   r26,y+
    ld   r27,y+
    movw r24,r26
strcpyf0:
	lpm  r0,z+
    st   x+,r0
    tst  r0
    brne strcpyf0
    movw r30,r24
    ret
_strlen:
    ld   r26,y+
    ld   r27,y+
    clr  r30
    clr  r31
strlen0:
    ld   r22,x+
    tst  r22
    breq strlen1
    adiw r30,1
    rjmp strlen0
strlen1:
    ret
_strlenf:
    clr  r26
    clr  r27
    ld   r30,y+
    ld   r31,y+
strlenf0:
    lpm  r0,z+
    tst  r0
    breq strlenf1
    adiw r26,1
    rjmp strlenf0
strlenf1:
    movw r30,r26
    ret
_strncmpf:
    clr  r0
    clr  r1
    ld   r22,y+
    ld   r30,y+
    ld   r31,y+
    ld   r26,y+
    ld   r27,y+
strncmpf0:
    tst  r22
    breq strncmpf1
    dec  r22
    ld   r1,x+
	lpm  r0,z+
    cp   r0,r1
    brne strncmpf1
    tst  r0
    brne strncmpf0
strncmpf3:
    clr  r30
    ret
strncmpf1:
    sub  r1,r0
    breq strncmpf3
    ldi  r30,1
    brcc strncmpf2
    subi r30,2
strncmpf2:
    ret
_strpbrkf:
    ldd  r27,y+3
    ldd  r26,y+2
strpbrkf0:
    ld   r22,x
    tst  r22
    breq strpbrkf2
    ldd  r31,y+1
    ld   r30,y
strpbrkf1:
    lpm
    tst  r0
    breq strpbrkf3
    adiw r30,1
    cp   r22,r0
    brne strpbrkf1
    movw r30,r26
    rjmp strpbrkf4
strpbrkf3:
    adiw r26,1
    rjmp strpbrkf0
strpbrkf2:
    clr  r30
    clr  r31
strpbrkf4:
	JMP  _0x20C0001
_strstr:
    ldd  r26,y+2
    ldd  r27,y+3
    movw r24,r26
strstr0:
    ld   r30,y
    ldd  r31,y+1
strstr1:
    ld   r23,z+
    tst  r23
    brne strstr2
    movw r30,r24
    rjmp strstr3
strstr2:
    ld   r22,x+
    cp   r22,r23
    breq strstr1
    adiw r24,1
    movw r26,r24
    tst  r22
    brne strstr0
    clr  r30
    clr  r31
strstr3:
	JMP  _0x20C0001
_strstrf:
    ldd  r26,y+2
    ldd  r27,y+3
    movw r24,r26
strstrf0:
    ld   r30,y
    ldd  r31,y+1
strstrf1:
    lpm  r0,z+
    tst  r0
    brne strstrf2
    movw r30,r24
    rjmp strstrf3
strstrf2:
    ld   r22,x+
    cp   r22,r0
    breq strstrf1
    adiw r24,1
    movw r26,r24
    tst  r22
    brne strstrf0
    clr  r30
    clr  r31
strstrf3:
	JMP  _0x20C0001
_strspnf:
    ldd  r27,y+3
    ldd  r26,y+2
    clr  r24
    clr  r25
strspnf0:
    ld   r22,x+
    tst  r22
    breq strspnf2
    ldd  r31,y+1
    ld   r30,y
strspnf1:
    lpm  r0,z+
    tst  r0
    breq strspnf2
    cp   r22,r0
    brne strspnf1
    adiw r24,1
    rjmp strspnf0
strspnf2:
    movw r30,r24
	JMP  _0x20C0001
_strtok:
	ST   -Y,R17
	ST   -Y,R16
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	SBIW R30,0
	BRNE _0x2000003
	LDS  R30,_p_S1000024
	LDS  R31,_p_S1000024+1
	SBIW R30,0
	BRNE _0x2000004
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	RJMP _0x20C0004
_0x2000004:
	LDS  R30,_p_S1000024
	LDS  R31,_p_S1000024+1
	STD  Y+4,R30
	STD  Y+4+1,R31
_0x2000003:
	CALL SUBOPT_0x12
	CALL SUBOPT_0x12
	CALL _strspnf
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	ADD  R30,R26
	ADC  R31,R27
	STD  Y+4,R30
	STD  Y+4+1,R31
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	LD   R30,X
	CPI  R30,0
	BRNE _0x2000005
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	STS  _p_S1000024,R30
	STS  _p_S1000024+1,R31
	RJMP _0x20C0004
_0x2000005:
	CALL SUBOPT_0x12
	CALL SUBOPT_0x12
	CALL _strpbrkf
	MOVW R16,R30
	SBIW R30,0
	BREQ _0x2000006
	MOVW R26,R16
	__ADDWRN 16,17,1
	LDI  R30,LOW(0)
	ST   X,R30
_0x2000006:
	__PUTWMRN _p_S1000024,0,16,17
	LDD  R30,Y+4
	LDD  R31,Y+4+1
_0x20C0004:
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,6
	RET
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x01
	.EQU __sm_mask=0x0E
	.EQU __sm_adc_noise_red=0x02
	.EQU __sm_powerdown=0x04
	.EQU __sm_powersave=0x06
	.EQU __sm_standby=0x0C
	.EQU __sm_ext_standby=0x0E
	.SET power_ctrl_reg=smcr
	#endif

	.CSEG
_putchar:
_0x2020003:
	LDS  R30,192
	LDI  R31,0
	ANDI R30,LOW(0x20)
	BREQ _0x2020003
	LD   R30,Y
	STS  198,R30
	ADIW R28,1
	RET
__put_G101:
	ST   -Y,R17
	ST   -Y,R16
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	CALL __GETW1P
	SBIW R30,0
	BREQ _0x2020013
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	CALL __GETW1P
	MOVW R16,R30
	SBIW R30,0
	BREQ _0x2020015
	__CPWRN 16,17,2
	BRLO _0x2020016
	MOVW R30,R16
	SBIW R30,1
	MOVW R16,R30
	ST   X+,R30
	ST   X,R31
_0x2020015:
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
	SBIW R30,1
	LDD  R26,Y+6
	STD  Z+0,R26
_0x2020016:
	RJMP _0x2020017
_0x2020013:
	LDD  R30,Y+6
	ST   -Y,R30
	RCALL _putchar
_0x2020017:
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,7
	RET
__print_G101:
	SBIW R28,6
	CALL __SAVELOCR6
	LDI  R17,0
_0x2020018:
	LDD  R30,Y+18
	LDD  R31,Y+18+1
	ADIW R30,1
	STD  Y+18,R30
	STD  Y+18+1,R31
	SBIW R30,1
	LPM  R30,Z
	MOV  R18,R30
	CPI  R30,0
	BRNE PC+3
	JMP _0x202001A
	CALL SUBOPT_0xA
	SBIW R30,0
	BRNE _0x202001E
	CPI  R18,37
	BRNE _0x202001F
	LDI  R17,LOW(1)
	RJMP _0x2020020
_0x202001F:
	CALL SUBOPT_0x53
_0x2020020:
	RJMP _0x202001D
_0x202001E:
	CPI  R30,LOW(0x1)
	LDI  R26,HIGH(0x1)
	CPC  R31,R26
	BRNE _0x2020021
	CPI  R18,37
	BRNE _0x2020022
	CALL SUBOPT_0x53
	RJMP _0x20200BF
_0x2020022:
	LDI  R17,LOW(2)
	LDI  R20,LOW(0)
	LDI  R16,LOW(0)
	CPI  R18,45
	BRNE _0x2020023
	LDI  R16,LOW(1)
	RJMP _0x202001D
_0x2020023:
	CPI  R18,43
	BRNE _0x2020024
	LDI  R20,LOW(43)
	RJMP _0x202001D
_0x2020024:
	CPI  R18,32
	BRNE _0x2020025
	LDI  R20,LOW(32)
	RJMP _0x202001D
_0x2020025:
	RJMP _0x2020026
_0x2020021:
	CPI  R30,LOW(0x2)
	LDI  R26,HIGH(0x2)
	CPC  R31,R26
	BRNE _0x2020027
_0x2020026:
	LDI  R21,LOW(0)
	LDI  R17,LOW(3)
	CPI  R18,48
	BRNE _0x2020028
	CALL SUBOPT_0x2C
	LDI  R30,LOW(128)
	LDI  R31,HIGH(128)
	OR   R30,R26
	MOV  R16,R30
	RJMP _0x202001D
_0x2020028:
	RJMP _0x2020029
_0x2020027:
	CPI  R30,LOW(0x3)
	LDI  R26,HIGH(0x3)
	CPC  R31,R26
	BREQ PC+3
	JMP _0x202001D
_0x2020029:
	CPI  R18,48
	BRLO _0x202002C
	CPI  R18,58
	BRLO _0x202002D
_0x202002C:
	RJMP _0x202002B
_0x202002D:
	MOV  R26,R21
	LDI  R27,0
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	MULS R30,R26
	MOVW R30,R0
	MOV  R21,R30
	MOV  R22,R21
	CLR  R23
	MOV  R26,R18
	LDI  R27,0
	LDI  R30,LOW(48)
	LDI  R31,HIGH(48)
	CALL __SWAPW12
	SUB  R30,R26
	SBC  R31,R27
	MOVW R26,R22
	ADD  R30,R26
	MOV  R21,R30
	RJMP _0x202001D
_0x202002B:
	CALL SUBOPT_0x54
	CPI  R30,LOW(0x63)
	LDI  R26,HIGH(0x63)
	CPC  R31,R26
	BRNE _0x2020031
	CALL SUBOPT_0x55
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	LDD  R26,Z+4
	ST   -Y,R26
	CALL SUBOPT_0x56
	RJMP _0x2020032
_0x2020031:
	CPI  R30,LOW(0x73)
	LDI  R26,HIGH(0x73)
	CPC  R31,R26
	BRNE _0x2020034
	CALL SUBOPT_0x55
	CALL SUBOPT_0x57
	CALL SUBOPT_0x11
	MOV  R17,R30
	RJMP _0x2020035
_0x2020034:
	CPI  R30,LOW(0x70)
	LDI  R26,HIGH(0x70)
	CPC  R31,R26
	BRNE _0x2020037
	CALL SUBOPT_0x55
	CALL SUBOPT_0x57
	ST   -Y,R31
	ST   -Y,R30
	CALL _strlenf
	MOV  R17,R30
	CALL SUBOPT_0x2C
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	OR   R30,R26
	MOV  R16,R30
_0x2020035:
	CALL SUBOPT_0x2C
	LDI  R30,LOW(2)
	LDI  R31,HIGH(2)
	OR   R30,R26
	MOV  R16,R30
	CALL SUBOPT_0x2C
	LDI  R30,LOW(65407)
	LDI  R31,HIGH(65407)
	AND  R30,R26
	MOV  R16,R30
	LDI  R19,LOW(0)
	RJMP _0x2020038
_0x2020037:
	CPI  R30,LOW(0x64)
	LDI  R26,HIGH(0x64)
	CPC  R31,R26
	BREQ _0x202003B
	CPI  R30,LOW(0x69)
	LDI  R26,HIGH(0x69)
	CPC  R31,R26
	BRNE _0x202003C
_0x202003B:
	CALL SUBOPT_0x2C
	LDI  R30,LOW(4)
	LDI  R31,HIGH(4)
	OR   R30,R26
	MOV  R16,R30
	RJMP _0x202003D
_0x202003C:
	CPI  R30,LOW(0x75)
	LDI  R26,HIGH(0x75)
	CPC  R31,R26
	BRNE _0x202003E
_0x202003D:
	LDI  R30,LOW(_tbl10_G101*2)
	LDI  R31,HIGH(_tbl10_G101*2)
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDI  R17,LOW(5)
	RJMP _0x202003F
_0x202003E:
	CPI  R30,LOW(0x58)
	LDI  R26,HIGH(0x58)
	CPC  R31,R26
	BRNE _0x2020041
	CALL SUBOPT_0x2C
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	OR   R30,R26
	MOV  R16,R30
	RJMP _0x2020042
_0x2020041:
	CPI  R30,LOW(0x78)
	LDI  R26,HIGH(0x78)
	CPC  R31,R26
	BREQ PC+3
	JMP _0x2020073
_0x2020042:
	LDI  R30,LOW(_tbl16_G101*2)
	LDI  R31,HIGH(_tbl16_G101*2)
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDI  R17,LOW(4)
_0x202003F:
	CALL SUBOPT_0x2C
	CALL SUBOPT_0x58
	BREQ _0x2020044
	CALL SUBOPT_0x55
	CALL SUBOPT_0x59
	LDD  R26,Y+11
	TST  R26
	BRPL _0x2020045
	LDD  R30,Y+10
	LDD  R31,Y+10+1
	CALL __ANEGW1
	STD  Y+10,R30
	STD  Y+10+1,R31
	LDI  R20,LOW(45)
_0x2020045:
	CPI  R20,0
	BREQ _0x2020046
	SUBI R17,-LOW(1)
	RJMP _0x2020047
_0x2020046:
	CALL SUBOPT_0x2C
	CALL SUBOPT_0x5A
_0x2020047:
	RJMP _0x2020048
_0x2020044:
	CALL SUBOPT_0x55
	CALL SUBOPT_0x59
_0x2020048:
_0x2020038:
	CALL SUBOPT_0x2D
	ANDI R30,LOW(0x1)
	BRNE _0x2020049
_0x202004A:
	CP   R17,R21
	BRSH _0x202004C
	CALL SUBOPT_0x2C
	LDI  R30,LOW(128)
	LDI  R31,HIGH(128)
	AND  R30,R26
	AND  R31,R27
	SBIW R30,0
	BREQ _0x202004D
	CALL SUBOPT_0x2C
	CALL SUBOPT_0x58
	BREQ _0x202004E
	CALL SUBOPT_0x2C
	CALL SUBOPT_0x5A
	MOV  R18,R20
	SUBI R17,LOW(1)
	RJMP _0x202004F
_0x202004E:
	LDI  R18,LOW(48)
_0x202004F:
	RJMP _0x2020050
_0x202004D:
	LDI  R18,LOW(32)
_0x2020050:
	CALL SUBOPT_0x53
	SUBI R21,LOW(1)
	RJMP _0x202004A
_0x202004C:
_0x2020049:
	MOV  R19,R17
	CALL SUBOPT_0x2C
	LDI  R30,LOW(2)
	LDI  R31,HIGH(2)
	AND  R30,R26
	AND  R31,R27
	SBIW R30,0
	BREQ _0x2020051
_0x2020052:
	CPI  R19,0
	BREQ _0x2020054
	CALL SUBOPT_0x2C
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	AND  R30,R26
	AND  R31,R27
	SBIW R30,0
	BREQ _0x2020055
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	ADIW R30,1
	STD  Y+6,R30
	STD  Y+6+1,R31
	SBIW R30,1
	LPM  R30,Z
	RJMP _0x20200C0
_0x2020055:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LD   R30,X+
	STD  Y+6,R26
	STD  Y+6+1,R27
_0x20200C0:
	ST   -Y,R30
	CALL SUBOPT_0x56
	CPI  R21,0
	BREQ _0x2020057
	SUBI R21,LOW(1)
_0x2020057:
	SUBI R19,LOW(1)
	RJMP _0x2020052
_0x2020054:
	RJMP _0x2020058
_0x2020051:
_0x202005A:
	LDI  R18,LOW(48)
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	CALL __GETW1PF
	STD  Y+8,R30
	STD  Y+8+1,R31
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	ADIW R30,2
	STD  Y+6,R30
	STD  Y+6+1,R31
_0x202005C:
	LDD  R30,Y+8
	LDD  R31,Y+8+1
	LDD  R26,Y+10
	LDD  R27,Y+10+1
	CP   R26,R30
	CPC  R27,R31
	BRLO _0x202005E
	SUBI R18,-LOW(1)
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	LDD  R30,Y+10
	LDD  R31,Y+10+1
	SUB  R30,R26
	SBC  R31,R27
	STD  Y+10,R30
	STD  Y+10+1,R31
	RJMP _0x202005C
_0x202005E:
	CPI  R18,58
	BRLO _0x202005F
	CALL SUBOPT_0x2C
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	AND  R30,R26
	AND  R31,R27
	SBIW R30,0
	BREQ _0x2020060
	CALL SUBOPT_0x54
	ADIW R30,7
	RJMP _0x20200C1
_0x2020060:
	CALL SUBOPT_0x54
	ADIW R30,39
_0x20200C1:
	MOV  R18,R30
_0x202005F:
	CALL SUBOPT_0x2C
	LDI  R30,LOW(16)
	LDI  R31,HIGH(16)
	AND  R30,R26
	AND  R31,R27
	SBIW R30,0
	BRNE _0x2020063
	CPI  R18,49
	BRSH _0x2020065
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	SBIW R26,1
	BRNE _0x2020064
_0x2020065:
	RJMP _0x20200C2
_0x2020064:
	CP   R21,R19
	BRLO _0x2020069
	CALL SUBOPT_0x2D
	ANDI R30,LOW(0x1)
	BREQ _0x202006A
_0x2020069:
	RJMP _0x2020068
_0x202006A:
	LDI  R18,LOW(32)
	CALL SUBOPT_0x2C
	LDI  R30,LOW(128)
	LDI  R31,HIGH(128)
	AND  R30,R26
	AND  R31,R27
	SBIW R30,0
	BREQ _0x202006B
	LDI  R18,LOW(48)
_0x20200C2:
	MOV  R26,R16
	LDI  R27,0
	LDI  R30,LOW(16)
	LDI  R31,HIGH(16)
	OR   R30,R26
	MOV  R16,R30
	CALL SUBOPT_0x2C
	CALL SUBOPT_0x58
	BREQ _0x202006C
	CALL SUBOPT_0x2C
	CALL SUBOPT_0x5A
	ST   -Y,R20
	CALL SUBOPT_0x56
	CPI  R21,0
	BREQ _0x202006D
	SUBI R21,LOW(1)
_0x202006D:
_0x202006C:
_0x202006B:
_0x2020063:
	CALL SUBOPT_0x53
	CPI  R21,0
	BREQ _0x202006E
	SUBI R21,LOW(1)
_0x202006E:
_0x2020068:
	SUBI R19,LOW(1)
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	SBIW R26,2
	BRLO _0x202005B
	RJMP _0x202005A
_0x202005B:
_0x2020058:
	CALL SUBOPT_0x2D
	ANDI R30,LOW(0x1)
	BREQ _0x202006F
_0x2020070:
	CPI  R21,0
	BREQ _0x2020072
	SUBI R21,LOW(1)
	LDI  R30,LOW(32)
	ST   -Y,R30
	CALL SUBOPT_0x56
	RJMP _0x2020070
_0x2020072:
_0x202006F:
_0x2020073:
_0x2020032:
_0x20200BF:
	LDI  R17,LOW(0)
_0x202001D:
	RJMP _0x2020018
_0x202001A:
	CALL __LOADLOCR6
	ADIW R28,20
	RET
_printf:
	PUSH R15
	MOV  R15,R24
	SBIW R28,2
	ST   -Y,R17
	ST   -Y,R16
	MOVW R26,R28
	CALL __ADDW2R15
	MOVW R16,R26
	LDI  R30,0
	STD  Y+2,R30
	STD  Y+2+1,R30
	MOVW R26,R28
	ADIW R26,4
	CALL __ADDW2R15
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	ST   -Y,R17
	ST   -Y,R16
	MOVW R30,R28
	ADIW R30,6
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	RCALL __print_G101
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,4
	POP  R15
	RET

	.CSEG
_ftoa:
	SBIW R28,4
	LDI  R30,LOW(0)
	ST   Y,R30
	STD  Y+1,R30
	STD  Y+2,R30
	LDI  R30,LOW(63)
	STD  Y+3,R30
	ST   -Y,R17
	ST   -Y,R16
	LDD  R30,Y+11
	LDD  R31,Y+11+1
	CPI  R30,LOW(0xFFFF)
	LDI  R26,HIGH(0xFFFF)
	CPC  R31,R26
	BRNE _0x204000D
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x2040000,0
	ST   -Y,R31
	ST   -Y,R30
	CALL _strcpyf
	RJMP _0x20C0003
_0x204000D:
	CPI  R30,LOW(0x7FFF)
	LDI  R26,HIGH(0x7FFF)
	CPC  R31,R26
	BRNE _0x204000C
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	ST   -Y,R31
	ST   -Y,R30
	__POINTW1FN _0x2040000,1
	ST   -Y,R31
	ST   -Y,R30
	CALL _strcpyf
	RJMP _0x20C0003
_0x204000C:
	LDD  R26,Y+12
	TST  R26
	BRPL _0x204000F
	__GETD1S 9
	CALL __ANEGF1
	CALL SUBOPT_0x5B
	CALL SUBOPT_0x5C
	LDI  R30,LOW(45)
	ST   X,R30
_0x204000F:
	LDD  R26,Y+8
	CPI  R26,LOW(0x7)
	BRLO _0x2040010
	LDI  R30,LOW(6)
	STD  Y+8,R30
_0x2040010:
	LDD  R17,Y+8
_0x2040011:
	MOV  R30,R17
	SUBI R17,1
	CPI  R30,0
	BREQ _0x2040013
	CALL SUBOPT_0x5D
	CALL SUBOPT_0x5E
	CALL SUBOPT_0x5F
	RJMP _0x2040011
_0x2040013:
	CALL SUBOPT_0x60
	CALL __ADDF12
	CALL SUBOPT_0x5B
	LDI  R17,LOW(0)
	__GETD1N 0x3F800000
	CALL SUBOPT_0x5F
_0x2040014:
	CALL SUBOPT_0x60
	CALL __CMPF12
	BRLO _0x2040016
	CALL SUBOPT_0x5D
	CALL SUBOPT_0x61
	CALL SUBOPT_0x5F
	SUBI R17,-LOW(1)
	RJMP _0x2040014
_0x2040016:
	CPI  R17,0
	BRNE _0x2040017
	CALL SUBOPT_0x5C
	LDI  R30,LOW(48)
	ST   X,R30
	RJMP _0x2040018
_0x2040017:
_0x2040019:
	MOV  R30,R17
	SUBI R17,1
	CPI  R30,0
	BREQ _0x204001B
	CALL SUBOPT_0x5D
	CALL SUBOPT_0x5E
	__GETD2N 0x3F000000
	CALL __ADDF12
	CALL __PUTPARD1
	CALL _floor
	CALL SUBOPT_0x5F
	CALL SUBOPT_0x60
	CALL __DIVF21
	CALL __CFD1U
	MOV  R16,R30
	CALL SUBOPT_0x5C
	CALL SUBOPT_0x2D
	ADIW R30,48
	ST   X,R30
	CALL SUBOPT_0x2D
	CALL SUBOPT_0x5D
	CALL __CWD1
	CALL __CDF1
	CALL __MULF12
	CALL SUBOPT_0x62
	CALL SUBOPT_0x63
	RJMP _0x2040019
_0x204001B:
_0x2040018:
	LDD  R30,Y+8
	CPI  R30,0
	BREQ _0x20C0002
	CALL SUBOPT_0x5C
	LDI  R30,LOW(46)
	ST   X,R30
_0x204001D:
	LDD  R30,Y+8
	SUBI R30,LOW(1)
	STD  Y+8,R30
	SUBI R30,-LOW(1)
	BREQ _0x204001F
	CALL SUBOPT_0x62
	CALL SUBOPT_0x61
	CALL SUBOPT_0x5B
	__GETD1S 9
	CALL __CFD1U
	MOV  R16,R30
	CALL SUBOPT_0x5C
	CALL SUBOPT_0x2D
	ADIW R30,48
	ST   X,R30
	CALL SUBOPT_0x2D
	CALL SUBOPT_0x62
	CALL __CWD1
	CALL __CDF1
	CALL SUBOPT_0x63
	RJMP _0x204001D
_0x204001F:
_0x20C0002:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LDI  R30,LOW(0)
	ST   X,R30
_0x20C0003:
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,13
	RET

	.DSEG

	.CSEG
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x01
	.EQU __sm_mask=0x0E
	.EQU __sm_adc_noise_red=0x02
	.EQU __sm_powerdown=0x04
	.EQU __sm_powersave=0x06
	.EQU __sm_standby=0x0C
	.EQU __sm_ext_standby=0x0E
	.SET power_ctrl_reg=smcr
	#endif

	.CSEG
_sleep_enable:
   in   r30,power_ctrl_reg
   sbr  r30,__se_bit
   out  power_ctrl_reg,r30
	RET
_idle:
   in   r30,power_ctrl_reg
   cbr  r30,__sm_mask
   out  power_ctrl_reg,r30
   sleep
	RET

	.CSEG

	.CSEG
_ftrunc:
   ldd  r23,y+3
   ldd  r22,y+2
   ldd  r31,y+1
   ld   r30,y
   bst  r23,7
   lsl  r23
   sbrc r22,7
   sbr  r23,1
   mov  r25,r23
   subi r25,0x7e
   breq __ftrunc0
   brcs __ftrunc0
   cpi  r25,24
   brsh __ftrunc1
   clr  r26
   clr  r27
   clr  r24
__ftrunc2:
   sec
   ror  r24
   ror  r27
   ror  r26
   dec  r25
   brne __ftrunc2
   and  r30,r26
   and  r31,r27
   and  r22,r24
   rjmp __ftrunc1
__ftrunc0:
   clt
   clr  r23
   clr  r30
   clr  r31
   clr  r22
__ftrunc1:
   cbr  r22,0x80
   lsr  r23
   brcc __ftrunc3
   sbr  r22,0x80
__ftrunc3:
   bld  r23,7
   ld   r26,y+
   ld   r27,y+
   ld   r24,y+
   ld   r25,y+
   cp   r30,r26
   cpc  r31,r27
   cpc  r22,r24
   cpc  r23,r25
   bst  r25,7
   ret
_floor:
	__GETD1S 0
	CALL __PUTPARD1
	CALL _ftrunc
	__PUTD1S 0
    brne __floor1
__floor0:
	__GETD1S 0
	RJMP _0x20C0001
__floor1:
    brtc __floor0
	__GETD2S 0
	__GETD1N 0x3F800000
	CALL __SWAPD12
	CALL __SUBF12
_0x20C0001:
	ADIW R28,4
	RET

	.DSEG
_RX_text:
	.BYTE 0xFE
_RX_text_tmp:
	.BYTE 0x40
_uarttimeout:
	.BYTE 0x1
_alarmimeout:
	.BYTE 0x1
_adcdata:
	.BYTE 0x2
_volt:
	.BYTE 0x4
_voltstr:
	.BYTE 0x6
_masterpass:
	.BYTE 0x5
_userpass:
	.BYTE 0x5
_alarmphone:
	.BYTE 0xD
_ballanscomand:
	.BYTE 0x9
_reley1command:
	.BYTE 0x7
_reley1delay:
	.BYTE 0x1
_reley1ontime:
	.BYTE 0x2
_reley1counter:
	.BYTE 0x2
_reley2command:
	.BYTE 0x7
_reley2delay:
	.BYTE 0x1
_reley2ontime:
	.BYTE 0x2
_reley2counter:
	.BYTE 0x2
_reley3command:
	.BYTE 0x7
_reley3delay:
	.BYTE 0x1
_reley3ontime:
	.BYTE 0x2
_reley3counter:
	.BYTE 0x2
_reley4command:
	.BYTE 0x7
_reley4delay:
	.BYTE 0x1
_reley4ontime:
	.BYTE 0x2
_reley4counter:
	.BYTE 0x2
_phone:
	.BYTE 0xD

	.ESEG
_eemasterpass:
	.DB  LOW(0x32334557),HIGH(0x32334557),BYTE3(0x32334557),BYTE4(0x32334557)
	.DB  0x0
_eeuserpass:
	.DB  LOW(0x34333231),HIGH(0x34333231),BYTE3(0x34333231),BYTE4(0x34333231)
	.DB  0x0
_eealarmphone:
	.DB  LOW(0x3030372B),HIGH(0x3030372B),BYTE3(0x3030372B),BYTE4(0x3030372B)
	.DB  LOW(0x30303030),HIGH(0x30303030),BYTE3(0x30303030),BYTE4(0x30303030)
	.DB  LOW(0x30303030),HIGH(0x30303030),BYTE3(0x30303030),BYTE4(0x30303030)
	.DB  0x0
_eeballanscomand:
	.DB  LOW(0x3030312A),HIGH(0x3030312A),BYTE3(0x3030312A),BYTE4(0x3030312A)
	.DB  LOW(0x23),HIGH(0x23),BYTE3(0x23),BYTE4(0x23)
	.DB  0x0
_eereley1command:
	.DB  LOW(0x4E45504F),HIGH(0x4E45504F),BYTE3(0x4E45504F),BYTE4(0x4E45504F)
	.DW  0x0
	.DB  0x0
_eereley1delay:
	.DB  0x1
_eereley2command:
	.DB  LOW(0x534F4C43),HIGH(0x534F4C43),BYTE3(0x534F4C43),BYTE4(0x534F4C43)
	.DW  0x45
	.DB  0x0
_eereley2delay:
	.DB  0x1
_eereley3command:
	.DB  LOW(0x54414548),HIGH(0x54414548),BYTE3(0x54414548),BYTE4(0x54414548)
	.DW  0x0
	.DB  0x0
_eereley3delay:
	.DB  0xF0
_eereley4command:
	.DB  LOW(0x4D4143),HIGH(0x4D4143),BYTE3(0x4D4143),BYTE4(0x4D4143)
	.DW  0x0
	.DB  0x0
_eereley4delay:
	.DB  0xF0
_voltdev:
	.DB  LOW(0x3CDC0000),HIGH(0x3CDC0000),BYTE3(0x3CDC0000),BYTE4(0x3CDC0000)

	.DSEG
_rx_buffer0:
	.BYTE 0x200
_rx_wr_index0:
	.BYTE 0x2
_rx_rd_index0:
	.BYTE 0x2
_rx_counter0:
	.BYTE 0x2
_p_S1000024:
	.BYTE 0x2
__seed_G102:
	.BYTE 0x4

	.CSEG
;OPTIMIZER ADDED SUBROUTINE, CALLED 20 TIMES, CODE SIZE REDUCTION:35 WORDS
SUBOPT_0x0:
	MOV  R26,R17
	LDI  R27,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:21 WORDS
SUBOPT_0x1:
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
	CPI  R30,LOW(0x200)
	LDI  R26,HIGH(0x200)
	CPC  R31,R26
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:18 WORDS
SUBOPT_0x2:
	LDS  R30,_rx_counter0
	LDS  R31,_rx_counter0+1
	SBIW R30,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x3:
	LDS  R30,_rx_rd_index0
	LDS  R31,_rx_rd_index0+1
	SUBI R30,LOW(-_rx_buffer0)
	SBCI R31,HIGH(-_rx_buffer0)
	LD   R17,Z
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x4:
	LDI  R26,LOW(_rx_rd_index0)
	LDI  R27,HIGH(_rx_rd_index0)
	RJMP SUBOPT_0x1

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x5:
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	STS  _rx_rd_index0,R30
	STS  _rx_rd_index0+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x6:
	LDI  R26,LOW(_rx_counter0)
	LDI  R27,HIGH(_rx_counter0)
	LD   R30,X+
	LD   R31,X+
	SBIW R30,1
	ST   -X,R31
	ST   -X,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x7:
	LDI  R30,LOW(194)
	STS  133,R30
	LDI  R30,LOW(247)
	STS  132,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x8:
	LD   R30,X+
	LD   R31,X+
	SBIW R30,1
	ST   -X,R31
	ST   -X,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x9:
	LDI  R26,LOW(122)
	LDI  R27,HIGH(122)
	LD   R30,X
	LDI  R31,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 18 TIMES, CODE SIZE REDUCTION:31 WORDS
SUBOPT_0xA:
	MOV  R30,R17
	LDI  R31,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:18 WORDS
SUBOPT_0xB:
	CALL __EEPROMRDB
	MOVW R26,R0
	ST   X,R30
	SUBI R17,-1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 44 TIMES, CODE SIZE REDUCTION:169 WORDS
SUBOPT_0xC:
	LDI  R30,LOW(200)
	LDI  R31,HIGH(200)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:13 WORDS
SUBOPT_0xD:
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:12 WORDS
SUBOPT_0xE:
	MOVW R30,R18
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADD  R26,R30
	ADC  R27,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0xF:
	ST   X,R30
	__ADDWRN 18,19,1
	RJMP SUBOPT_0xE

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x10:
	MOVW R30,R18
	SBIW R30,1
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADD  R26,R30
	ADC  R27,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x11:
	ST   -Y,R31
	ST   -Y,R30
	JMP  _strlen

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x12:
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 42 TIMES, CODE SIZE REDUCTION:79 WORDS
SUBOPT_0x13:
	LDI  R30,LOW(_RX_text_tmp)
	LDI  R31,HIGH(_RX_text_tmp)
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 11 TIMES, CODE SIZE REDUCTION:37 WORDS
SUBOPT_0x14:
	LDI  R30,LOW(64)
	LDI  R31,HIGH(64)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _getstring

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x15:
	__POINTW1FN _0x0,0
	ST   -Y,R31
	ST   -Y,R30
	CALL _ansvercmp
	CPI  R30,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:32 WORDS
SUBOPT_0x16:
	__POINTW1FN _0x0,3
	ST   -Y,R31
	ST   -Y,R30
	CALL _ansvercmp
	CPI  R30,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 12 TIMES, CODE SIZE REDUCTION:41 WORDS
SUBOPT_0x17:
	ST   -Y,R31
	ST   -Y,R30
	LDI  R24,0
	CALL _printf
	ADIW R28,2
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:22 WORDS
SUBOPT_0x18:
	ST   -Y,R30
	CALL _putchar
	LDI  R30,LOW(10)
	ST   -Y,R30
	JMP  _putchar

;OPTIMIZER ADDED SUBROUTINE, CALLED 24 TIMES, CODE SIZE REDUCTION:66 WORDS
SUBOPT_0x19:
	ST   -Y,R31
	ST   -Y,R30
	CALL _ansvercmp
	CPI  R30,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x1A:
	__POINTW1FN _0x0,9
	RJMP SUBOPT_0x19

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:11 WORDS
SUBOPT_0x1B:
	LDI  R30,LOW(10)
	ST   -Y,R30
	JMP  _putchar

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:15 WORDS
SUBOPT_0x1C:
	ST   -Y,R31
	ST   -Y,R30
	CALL _strstrf
	SBIW R30,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 22 TIMES, CODE SIZE REDUCTION:81 WORDS
SUBOPT_0x1D:
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x1E:
	__POINTW1FN _0x0,79
	ST   -Y,R31
	ST   -Y,R30
	JMP  _m590command

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:21 WORDS
SUBOPT_0x1F:
	ST   -Y,R31
	ST   -Y,R30
	CALL _m590command
	RJMP SUBOPT_0xC

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x20:
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(_alarmphone)
	LDI  R31,HIGH(_alarmphone)
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	LDI  R24,4
	CALL _printf
	ADIW R28,6
	RJMP SUBOPT_0x1B

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x21:
	__POINTW1FN _0x0,168
	ST   -Y,R31
	ST   -Y,R30
	CALL _m590command
	LDI  R17,LOW(0)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x22:
	__POINTW1FN _0x0,168
	ST   -Y,R31
	ST   -Y,R30
	CALL _m590command
	LDI  R17,LOW(1)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x23:
	LDI  R24,0
	CALL _printf
	ADIW R28,2
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x24:
	CALL _read_adc
	STS  _adcdata,R30
	STS  _adcdata+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x25:
	LDS  R30,_adcdata
	LDS  R31,_adcdata+1
	CALL __CWD1
	CALL __CDF1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x26:
	CALL __MULF12
	STS  _volt,R30
	STS  _volt+1,R31
	STS  _volt+2,R22
	STS  _volt+3,R23
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:39 WORDS
SUBOPT_0x27:
	__POINTW1FN _0x0,198
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(_phone)
	LDI  R31,HIGH(_phone)
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	LDI  R24,4
	CALL _printf
	ADIW R28,6
	RJMP SUBOPT_0x1B

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:33 WORDS
SUBOPT_0x28:
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	LDI  R24,4
	CALL _printf
	ADIW R28,6
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:11 WORDS
SUBOPT_0x29:
	LDI  R30,LOW(_RX_text)
	LDI  R31,HIGH(_RX_text)
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x2A:
	LDI  R30,LOW(254)
	LDI  R31,HIGH(254)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _getstring

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x2B:
	ST   -Y,R31
	ST   -Y,R30
	JMP  _m590command

;OPTIMIZER ADDED SUBROUTINE, CALLED 19 TIMES, CODE SIZE REDUCTION:33 WORDS
SUBOPT_0x2C:
	MOV  R26,R16
	LDI  R27,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:11 WORDS
SUBOPT_0x2D:
	MOV  R30,R16
	LDI  R31,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x2E:
	__POINTW1FN _0x0,36
	ST   -Y,R31
	ST   -Y,R30
	JMP  _strtok

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:15 WORDS
SUBOPT_0x2F:
	MOVW R0,R30
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	CLR  R30
	ADD  R26,R17
	ADC  R27,R30
	LD   R30,X
	MOVW R26,R0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x30:
	LDI  R30,LOW(_reley1command)
	LDI  R31,HIGH(_reley1command)
	ST   -Y,R31
	ST   -Y,R30
	CALL _strstr
	SBIW R30,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x31:
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	STS  _reley1ontime,R30
	STS  _reley1ontime+1,R31
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LD   R26,X
	CPI  R26,LOW(0x30)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x32:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LD   R26,X
	CPI  R26,LOW(0x3A)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:12 WORDS
SUBOPT_0x33:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LD   R30,X
	LDI  R31,0
	SBIW R30,48
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x34:
	STS  _reley1ontime,R30
	STS  _reley1ontime+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 12 TIMES, CODE SIZE REDUCTION:19 WORDS
SUBOPT_0x35:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADIW R26,1
	LD   R26,X
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x36:
	LDS  R26,_reley1ontime
	LDS  R27,_reley1ontime+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x37:
	CALL __MULB1W2U
	RJMP SUBOPT_0x34

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:15 WORDS
SUBOPT_0x38:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADIW R26,1
	LD   R30,X
	LDI  R31,0
	SBIW R30,48
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x39:
	RCALL SUBOPT_0x36
	ADD  R30,R26
	ADC  R31,R27
	RJMP SUBOPT_0x34

;OPTIMIZER ADDED SUBROUTINE, CALLED 12 TIMES, CODE SIZE REDUCTION:19 WORDS
SUBOPT_0x3A:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADIW R26,2
	LD   R26,X
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:15 WORDS
SUBOPT_0x3B:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADIW R26,2
	LD   R30,X
	LDI  R31,0
	SBIW R30,48
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x3C:
	STS  _reley1counter,R30
	STS  _reley1counter+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x3D:
	LDS  R30,_reley1delay
	LDI  R31,0
	RJMP SUBOPT_0x3C

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x3E:
	LDI  R30,LOW(_reley2command)
	LDI  R31,HIGH(_reley2command)
	ST   -Y,R31
	ST   -Y,R30
	CALL _strstr
	SBIW R30,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x3F:
	STS  _reley2ontime,R30
	STS  _reley2ontime+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x40:
	LDS  R26,_reley2ontime
	LDS  R27,_reley2ontime+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x41:
	CALL __MULB1W2U
	RJMP SUBOPT_0x3F

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x42:
	RCALL SUBOPT_0x40
	ADD  R30,R26
	ADC  R31,R27
	RJMP SUBOPT_0x3F

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x43:
	STS  _reley2counter,R30
	STS  _reley2counter+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x44:
	LDS  R30,_reley2delay
	LDI  R31,0
	RJMP SUBOPT_0x43

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x45:
	LDI  R30,LOW(_reley3command)
	LDI  R31,HIGH(_reley3command)
	ST   -Y,R31
	ST   -Y,R30
	CALL _strstr
	SBIW R30,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:11 WORDS
SUBOPT_0x46:
	STS  _reley3ontime,R30
	STS  _reley3ontime+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x47:
	LDS  R26,_reley3ontime
	LDS  R27,_reley3ontime+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x48:
	CALL __MULB1W2U
	RJMP SUBOPT_0x46

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x49:
	RCALL SUBOPT_0x47
	ADD  R30,R26
	ADC  R31,R27
	RJMP SUBOPT_0x46

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x4A:
	STS  _reley3counter,R30
	STS  _reley3counter+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x4B:
	LDS  R30,_reley3delay
	LDI  R31,0
	RJMP SUBOPT_0x4A

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x4C:
	LDI  R30,LOW(_reley4command)
	LDI  R31,HIGH(_reley4command)
	ST   -Y,R31
	ST   -Y,R30
	CALL _strstr
	SBIW R30,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:11 WORDS
SUBOPT_0x4D:
	STS  _reley4ontime,R30
	STS  _reley4ontime+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x4E:
	LDS  R26,_reley4ontime
	LDS  R27,_reley4ontime+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x4F:
	CALL __MULB1W2U
	RJMP SUBOPT_0x4D

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x50:
	RCALL SUBOPT_0x4E
	ADD  R30,R26
	ADC  R31,R27
	RJMP SUBOPT_0x4D

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x51:
	STS  _reley4counter,R30
	STS  _reley4counter+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x52:
	LDS  R30,_reley4delay
	LDI  R31,0
	RJMP SUBOPT_0x51

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:24 WORDS
SUBOPT_0x53:
	ST   -Y,R18
	LDD  R30,Y+15
	LDD  R31,Y+15+1
	ST   -Y,R31
	ST   -Y,R30
	MOVW R30,R28
	ADIW R30,15
	ST   -Y,R31
	ST   -Y,R30
	JMP  __put_G101

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x54:
	MOV  R30,R18
	LDI  R31,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x55:
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	SBIW R30,4
	STD  Y+16,R30
	STD  Y+16+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:21 WORDS
SUBOPT_0x56:
	LDD  R30,Y+15
	LDD  R31,Y+15+1
	ST   -Y,R31
	ST   -Y,R30
	MOVW R30,R28
	ADIW R30,15
	ST   -Y,R31
	ST   -Y,R30
	JMP  __put_G101

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x57:
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	ADIW R26,4
	CALL __GETW1P
	STD  Y+6,R30
	STD  Y+6+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x58:
	LDI  R30,LOW(4)
	LDI  R31,HIGH(4)
	AND  R30,R26
	AND  R31,R27
	SBIW R30,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x59:
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	ADIW R26,4
	CALL __GETW1P
	STD  Y+10,R30
	STD  Y+10+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x5A:
	LDI  R30,LOW(65531)
	LDI  R31,HIGH(65531)
	AND  R30,R26
	MOV  R16,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x5B:
	__PUTD1S 9
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:13 WORDS
SUBOPT_0x5C:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADIW R26,1
	STD  Y+6,R26
	STD  Y+6+1,R27
	SBIW R26,1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x5D:
	__GETD2S 2
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x5E:
	__GETD1N 0x3DCCCCCD
	CALL __MULF12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x5F:
	__PUTD1S 2
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x60:
	__GETD1S 2
	__GETD2S 9
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x61:
	__GETD1N 0x41200000
	CALL __MULF12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x62:
	__GETD2S 9
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x63:
	CALL __SWAPD12
	CALL __SUBF12
	RJMP SUBOPT_0x5B


	.CSEG
_delay_ms:
	ld   r30,y+
	ld   r31,y+
	adiw r30,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0xFA0
	wdr
	sbiw r30,1
	brne __delay_ms0
__delay_ms1:
	ret

__ADDW2R15:
	CLR  R0
	ADD  R26,R15
	ADC  R27,R0
	RET

__ANEGW1:
	NEG  R31
	NEG  R30
	SBCI R31,0
	RET

__ANEGD1:
	COM  R31
	COM  R22
	COM  R23
	NEG  R30
	SBCI R31,-1
	SBCI R22,-1
	SBCI R23,-1
	RET

__CWD1:
	MOV  R22,R31
	ADD  R22,R22
	SBC  R22,R22
	MOV  R23,R22
	RET

__MULB1W2U:
	MOV  R22,R30
	MUL  R22,R26
	MOVW R30,R0
	MUL  R22,R27
	ADD  R31,R0
	RET

__GETW1P:
	LD   R30,X+
	LD   R31,X
	SBIW R26,1
	RET

__GETW1PF:
	LPM  R0,Z+
	LPM  R31,Z
	MOV  R30,R0
	RET

__PUTPARD1:
	ST   -Y,R23
	ST   -Y,R22
	ST   -Y,R31
	ST   -Y,R30
	RET

__SWAPD12:
	MOV  R1,R24
	MOV  R24,R22
	MOV  R22,R1
	MOV  R1,R25
	MOV  R25,R23
	MOV  R23,R1

__SWAPW12:
	MOV  R1,R27
	MOV  R27,R31
	MOV  R31,R1

__SWAPB12:
	MOV  R1,R26
	MOV  R26,R30
	MOV  R30,R1
	RET

__EEPROMRDD:
	ADIW R26,2
	RCALL __EEPROMRDW
	MOVW R22,R30
	SBIW R26,2

__EEPROMRDW:
	ADIW R26,1
	RCALL __EEPROMRDB
	MOV  R31,R30
	SBIW R26,1

__EEPROMRDB:
	SBIC EECR,EEWE
	RJMP __EEPROMRDB
	PUSH R31
	IN   R31,SREG
	CLI
	OUT  EEARL,R26
	OUT  EEARH,R27
	SBI  EECR,EERE
	IN   R30,EEDR
	OUT  SREG,R31
	POP  R31
	RET

__EEPROMWRB:
	SBIS EECR,EEWE
	RJMP __EEPROMWRB1
	WDR
	RJMP __EEPROMWRB
__EEPROMWRB1:
	IN   R25,SREG
	CLI
	OUT  EEARL,R26
	OUT  EEARH,R27
	SBI  EECR,EERE
	IN   R24,EEDR
	CP   R30,R24
	BREQ __EEPROMWRB0
	OUT  EEDR,R30
	SBI  EECR,EEMWE
	SBI  EECR,EEWE
__EEPROMWRB0:
	OUT  SREG,R25
	RET

__ANEGF1:
	SBIW R30,0
	SBCI R22,0
	SBCI R23,0
	BREQ __ANEGF10
	SUBI R23,0x80
__ANEGF10:
	RET

__ROUND_REPACK:
	TST  R21
	BRPL __REPACK
	CPI  R21,0x80
	BRNE __ROUND_REPACK0
	SBRS R30,0
	RJMP __REPACK
__ROUND_REPACK0:
	ADIW R30,1
	ADC  R22,R25
	ADC  R23,R25
	BRVS __REPACK1

__REPACK:
	LDI  R21,0x80
	EOR  R21,R23
	BRNE __REPACK0
	PUSH R21
	RJMP __ZERORES
__REPACK0:
	CPI  R21,0xFF
	BREQ __REPACK1
	LSL  R22
	LSL  R0
	ROR  R21
	ROR  R22
	MOV  R23,R21
	RET
__REPACK1:
	PUSH R21
	TST  R0
	BRMI __REPACK2
	RJMP __MAXRES
__REPACK2:
	RJMP __MINRES

__UNPACK:
	LDI  R21,0x80
	MOV  R1,R25
	AND  R1,R21
	LSL  R24
	ROL  R25
	EOR  R25,R21
	LSL  R21
	ROR  R24

__UNPACK1:
	LDI  R21,0x80
	MOV  R0,R23
	AND  R0,R21
	LSL  R22
	ROL  R23
	EOR  R23,R21
	LSL  R21
	ROR  R22
	RET

__CFD1U:
	SET
	RJMP __CFD1U0
__CFD1:
	CLT
__CFD1U0:
	PUSH R21
	RCALL __UNPACK1
	CPI  R23,0x80
	BRLO __CFD10
	CPI  R23,0xFF
	BRCC __CFD10
	RJMP __ZERORES
__CFD10:
	LDI  R21,22
	SUB  R21,R23
	BRPL __CFD11
	NEG  R21
	CPI  R21,8
	BRTC __CFD19
	CPI  R21,9
__CFD19:
	BRLO __CFD17
	SER  R30
	SER  R31
	SER  R22
	LDI  R23,0x7F
	BLD  R23,7
	RJMP __CFD15
__CFD17:
	CLR  R23
	TST  R21
	BREQ __CFD15
__CFD18:
	LSL  R30
	ROL  R31
	ROL  R22
	ROL  R23
	DEC  R21
	BRNE __CFD18
	RJMP __CFD15
__CFD11:
	CLR  R23
__CFD12:
	CPI  R21,8
	BRLO __CFD13
	MOV  R30,R31
	MOV  R31,R22
	MOV  R22,R23
	SUBI R21,8
	RJMP __CFD12
__CFD13:
	TST  R21
	BREQ __CFD15
__CFD14:
	LSR  R23
	ROR  R22
	ROR  R31
	ROR  R30
	DEC  R21
	BRNE __CFD14
__CFD15:
	TST  R0
	BRPL __CFD16
	RCALL __ANEGD1
__CFD16:
	POP  R21
	RET

__CDF1U:
	SET
	RJMP __CDF1U0
__CDF1:
	CLT
__CDF1U0:
	SBIW R30,0
	SBCI R22,0
	SBCI R23,0
	BREQ __CDF10
	CLR  R0
	BRTS __CDF11
	TST  R23
	BRPL __CDF11
	COM  R0
	RCALL __ANEGD1
__CDF11:
	MOV  R1,R23
	LDI  R23,30
	TST  R1
__CDF12:
	BRMI __CDF13
	DEC  R23
	LSL  R30
	ROL  R31
	ROL  R22
	ROL  R1
	RJMP __CDF12
__CDF13:
	MOV  R30,R31
	MOV  R31,R22
	MOV  R22,R1
	PUSH R21
	RCALL __REPACK
	POP  R21
__CDF10:
	RET

__SWAPACC:
	PUSH R20
	MOVW R20,R30
	MOVW R30,R26
	MOVW R26,R20
	MOVW R20,R22
	MOVW R22,R24
	MOVW R24,R20
	MOV  R20,R0
	MOV  R0,R1
	MOV  R1,R20
	POP  R20
	RET

__UADD12:
	ADD  R30,R26
	ADC  R31,R27
	ADC  R22,R24
	RET

__NEGMAN1:
	COM  R30
	COM  R31
	COM  R22
	SUBI R30,-1
	SBCI R31,-1
	SBCI R22,-1
	RET

__SUBF12:
	PUSH R21
	RCALL __UNPACK
	CPI  R25,0x80
	BREQ __ADDF129
	LDI  R21,0x80
	EOR  R1,R21

	RJMP __ADDF120

__ADDF12:
	PUSH R21
	RCALL __UNPACK
	CPI  R25,0x80
	BREQ __ADDF129

__ADDF120:
	CPI  R23,0x80
	BREQ __ADDF128
__ADDF121:
	MOV  R21,R23
	SUB  R21,R25
	BRVS __ADDF129
	BRPL __ADDF122
	RCALL __SWAPACC
	RJMP __ADDF121
__ADDF122:
	CPI  R21,24
	BRLO __ADDF123
	CLR  R26
	CLR  R27
	CLR  R24
__ADDF123:
	CPI  R21,8
	BRLO __ADDF124
	MOV  R26,R27
	MOV  R27,R24
	CLR  R24
	SUBI R21,8
	RJMP __ADDF123
__ADDF124:
	TST  R21
	BREQ __ADDF126
__ADDF125:
	LSR  R24
	ROR  R27
	ROR  R26
	DEC  R21
	BRNE __ADDF125
__ADDF126:
	MOV  R21,R0
	EOR  R21,R1
	BRMI __ADDF127
	RCALL __UADD12
	BRCC __ADDF129
	ROR  R22
	ROR  R31
	ROR  R30
	INC  R23
	BRVC __ADDF129
	RJMP __MAXRES
__ADDF128:
	RCALL __SWAPACC
__ADDF129:
	RCALL __REPACK
	POP  R21
	RET
__ADDF127:
	SUB  R30,R26
	SBC  R31,R27
	SBC  R22,R24
	BREQ __ZERORES
	BRCC __ADDF1210
	COM  R0
	RCALL __NEGMAN1
__ADDF1210:
	TST  R22
	BRMI __ADDF129
	LSL  R30
	ROL  R31
	ROL  R22
	DEC  R23
	BRVC __ADDF1210

__ZERORES:
	CLR  R30
	CLR  R31
	CLR  R22
	CLR  R23
	POP  R21
	RET

__MINRES:
	SER  R30
	SER  R31
	LDI  R22,0x7F
	SER  R23
	POP  R21
	RET

__MAXRES:
	SER  R30
	SER  R31
	LDI  R22,0x7F
	LDI  R23,0x7F
	POP  R21
	RET

__MULF12:
	PUSH R21
	RCALL __UNPACK
	CPI  R23,0x80
	BREQ __ZERORES
	CPI  R25,0x80
	BREQ __ZERORES
	EOR  R0,R1
	SEC
	ADC  R23,R25
	BRVC __MULF124
	BRLT __ZERORES
__MULF125:
	TST  R0
	BRMI __MINRES
	RJMP __MAXRES
__MULF124:
	PUSH R0
	PUSH R17
	PUSH R18
	PUSH R19
	PUSH R20
	CLR  R17
	CLR  R18
	CLR  R25
	MUL  R22,R24
	MOVW R20,R0
	MUL  R24,R31
	MOV  R19,R0
	ADD  R20,R1
	ADC  R21,R25
	MUL  R22,R27
	ADD  R19,R0
	ADC  R20,R1
	ADC  R21,R25
	MUL  R24,R30
	RCALL __MULF126
	MUL  R27,R31
	RCALL __MULF126
	MUL  R22,R26
	RCALL __MULF126
	MUL  R27,R30
	RCALL __MULF127
	MUL  R26,R31
	RCALL __MULF127
	MUL  R26,R30
	ADD  R17,R1
	ADC  R18,R25
	ADC  R19,R25
	ADC  R20,R25
	ADC  R21,R25
	MOV  R30,R19
	MOV  R31,R20
	MOV  R22,R21
	MOV  R21,R18
	POP  R20
	POP  R19
	POP  R18
	POP  R17
	POP  R0
	TST  R22
	BRMI __MULF122
	LSL  R21
	ROL  R30
	ROL  R31
	ROL  R22
	RJMP __MULF123
__MULF122:
	INC  R23
	BRVS __MULF125
__MULF123:
	RCALL __ROUND_REPACK
	POP  R21
	RET

__MULF127:
	ADD  R17,R0
	ADC  R18,R1
	ADC  R19,R25
	RJMP __MULF128
__MULF126:
	ADD  R18,R0
	ADC  R19,R1
__MULF128:
	ADC  R20,R25
	ADC  R21,R25
	RET

__DIVF21:
	PUSH R21
	RCALL __UNPACK
	CPI  R23,0x80
	BRNE __DIVF210
	TST  R1
__DIVF211:
	BRPL __DIVF219
	RJMP __MINRES
__DIVF219:
	RJMP __MAXRES
__DIVF210:
	CPI  R25,0x80
	BRNE __DIVF218
__DIVF217:
	RJMP __ZERORES
__DIVF218:
	EOR  R0,R1
	SEC
	SBC  R25,R23
	BRVC __DIVF216
	BRLT __DIVF217
	TST  R0
	RJMP __DIVF211
__DIVF216:
	MOV  R23,R25
	PUSH R17
	PUSH R18
	PUSH R19
	PUSH R20
	CLR  R1
	CLR  R17
	CLR  R18
	CLR  R19
	CLR  R20
	CLR  R21
	LDI  R25,32
__DIVF212:
	CP   R26,R30
	CPC  R27,R31
	CPC  R24,R22
	CPC  R20,R17
	BRLO __DIVF213
	SUB  R26,R30
	SBC  R27,R31
	SBC  R24,R22
	SBC  R20,R17
	SEC
	RJMP __DIVF214
__DIVF213:
	CLC
__DIVF214:
	ROL  R21
	ROL  R18
	ROL  R19
	ROL  R1
	ROL  R26
	ROL  R27
	ROL  R24
	ROL  R20
	DEC  R25
	BRNE __DIVF212
	MOVW R30,R18
	MOV  R22,R1
	POP  R20
	POP  R19
	POP  R18
	POP  R17
	TST  R22
	BRMI __DIVF215
	LSL  R21
	ROL  R30
	ROL  R31
	ROL  R22
	DEC  R23
	BRVS __DIVF217
__DIVF215:
	RCALL __ROUND_REPACK
	POP  R21
	RET

__CMPF12:
	TST  R25
	BRMI __CMPF120
	TST  R23
	BRMI __CMPF121
	CP   R25,R23
	BRLO __CMPF122
	BRNE __CMPF121
	CP   R26,R30
	CPC  R27,R31
	CPC  R24,R22
	BRLO __CMPF122
	BREQ __CMPF123
__CMPF121:
	CLZ
	CLC
	RET
__CMPF122:
	CLZ
	SEC
	RET
__CMPF123:
	SEZ
	CLC
	RET
__CMPF120:
	TST  R23
	BRPL __CMPF122
	CP   R25,R23
	BRLO __CMPF121
	BRNE __CMPF122
	CP   R30,R26
	CPC  R31,R27
	CPC  R22,R24
	BRLO __CMPF122
	BREQ __CMPF123
	RJMP __CMPF121

__CPW02:
	CLR  R0
	CP   R0,R26
	CPC  R0,R27
	RET

__SAVELOCR6:
	ST   -Y,R21
__SAVELOCR5:
	ST   -Y,R20
__SAVELOCR4:
	ST   -Y,R19
__SAVELOCR3:
	ST   -Y,R18
__SAVELOCR2:
	ST   -Y,R17
	ST   -Y,R16
	RET

__LOADLOCR6:
	LDD  R21,Y+5
__LOADLOCR5:
	LDD  R20,Y+4
__LOADLOCR4:
	LDD  R19,Y+3
__LOADLOCR3:
	LDD  R18,Y+2
__LOADLOCR2:
	LDD  R17,Y+1
	LD   R16,Y
	RET

;END OF CODE MARKER
__END_OF_CODE:
