#include <mega16.h>
#include <stdio.h>
#include <delay.h>
#include <i2c.h>
#include <ds1307.h>
#include <alcd.h>
#include <buttons.h>


// I2C Bus functions
#asm
   .equ __lcd_port=0x12; PORTD
   .equ __i2c_port=0x18;PORTB
   .equ __sda_bit=0
   .equ __scl_bit=1
#endasm


// Declare your global variables here
typedef unsigned char byte;
char hour=0,min=0,sek=0,day=0,month=0,year=0,week_day=0;
bit time_flag=0;
unsigned int count=0;
const byte N=120;
byte alarm[N][6];
byte i=0;
char input=0XFF;
unsigned char l;
byte t=0,h,h1=0,h2=0,j=1,dur1=10,dur2=20;


void ChangeAlarm(void);
void show_time(void);
void dec2bin(char);




flash unsigned int mask_bit_int[8]={0x0001,0x0002,0x0004,0x0008,0x0010,0x0020,0x0040,0x0080};

int set=0xFF,out1=0xFF,out2=0xFF;

flash char s1[]="Set Alarm       ",
           s2[]="Show Alarm      ",
           s3[]="Erase Alarm     ",
           s4[]="Set Date        ",
           s5[]="Set Time        ",
         s041[]="Set Output 1    ",
         s042[]="Set Output 2    ",
          s05[]="Duration        ",
           s6[]="   ! ",
           s7[]="no alarms       ",
           s8[]=" 00000000",
           s9[]="erase all?      ",
          s10[]="up=yes, down=no ",
          s11[]="                ",
          s12[]="Alarm ",
          s13[]="    unset",
          s14[]="      set";
            
           
interrupt [EXT_INT2] void ext_int2_isr(void)
{
// Place your code here
    time_flag=1;
    h1++;
    h2++;
    
}

interrupt [TIM1_COMPA] void timer1_compa_isr(void)
{
TCNT1H=0;
TCNT1L=0;
// Place your code here
ChangeAlarm();
}

// 

#define MASK_BUTTONS     (1<<DOWN)|(1<<CANCEL)|(1<<UP)|(1<<ENTER)
#define ClearBit(reg, bit)       (reg) &= (~(1<<(bit)))
#define SetBit(reg, bit)          (reg) |= (1<<(bit))    
#define BitIsClear(reg, bit)    ((reg & (1<<(bit))) == 0)
#define BitIsSet(reg, bit)       ((reg & (1<<(bit))) != 0)

volatile unsigned char pressedKey = 0;
unsigned char comp = 0;


//_______________________________________
void BUT_Init(void)
{
  DDRX_BUTTON &= ~(MASK_BUTTONS); 
  PORT_BUTTON |= MASK_BUTTONS;
}

//_______________________________________
void BUT_Debrief(void)
{
unsigned char key;

  //   
  if (BitIsClear(PIN_BUTTON, ENTER))     
    key = KEY_ENTER;
  else if (BitIsClear(PIN_BUTTON, CANCEL))    
    key = KEY_CANCEL;
  else if (BitIsClear(PIN_BUTTON, UP))        
    key = KEY_UP;        
  else if (BitIsClear(PIN_BUTTON, DOWN))      
    key = KEY_DOWN;
  else {
    key = KEY_NULL;
  }

  //    - 
  if (key) {
  
    //    
    //     
    if (comp == THRESHOLD) {
      comp = THRESHOLD+10; 
      pressedKey = key;
      return;
    }
    else if (comp < (THRESHOLD+5)) comp++;
    
  } 
  else comp=0;
}

//__________________________
unsigned char BUT_GetKey(void)
{
  unsigned char key = pressedKey;
  pressedKey = KEY_NULL;
  return key;
}

void show_time()
{

///************  **********//////////
  
         /////////////////  
         if(time_flag==1)        
         {
            
          rtc_get_time(&hour,&min,&sek);  // 
          rtc_get_date(&week_day,&day,&month,&year);  // 

          lcd_gotoxy(0,0);           
          lcd_putchar(hour/10+0x30);    // 
          lcd_putchar(hour%10+0x30);        
          lcd_putchar(':');
          lcd_putchar(min/10+0x30);     //
          lcd_putchar(min%10+0x30);
          lcd_putchar(':');
          lcd_putchar(sek/10+0x30);     //
          lcd_putchar(sek%10+0x30);
          lcd_putsf(s6);          
          lcd_putchar(i/100+0x30);
          lcd_putchar((i%100)/10+0x30);
          lcd_putchar((i%100)%10+0x30);
          lcd_gotoxy(0,1);
          lcd_putchar(day/10+0x30);     //
          lcd_putchar(day%10+0x30);
          lcd_putchar('/');
          lcd_putchar(month/10+0x30);   //
          lcd_putchar(month%10+0x30);
          
          lcd_putchar(' ');  
          lcd_putchar(' ');
          lcd_putsf(s8);
          lcd_gotoxy(8,1); 
          dec2bin(set); 
               
    
        
          time_flag=0;                  //  
         }
}

void show_alarm()
{     
       if (i==0){
        lcd_putsf(s7);
       } else {
    
      lcd_gotoxy(0,0);           
          lcd_putchar(alarm[t-1][2]/10+0x30);    // 
          lcd_putchar(alarm[t-1][2]%10+0x30);        
          lcd_putchar(':');
          lcd_putchar(alarm[t-1][3]/10+0x30);     //
          lcd_putchar(alarm[t-1][3]%10+0x30);
          lcd_putchar(':');
          lcd_putchar(alarm[t-1][4]/10+0x30);     //
          lcd_putchar(alarm[t-1][4]%10+0x30);
          lcd_putchar(' ');
                
          lcd_putchar(alarm[t-1][1]/10+0x30);     //
          lcd_putchar(alarm[t-1][1]%10+0x30);
          lcd_putchar('/');
          lcd_putchar(alarm[t-1][0]/10+0x30);     //
          lcd_putchar(alarm[t-1][0]%10+0x30);
          lcd_putchar(' ');
            
       
           
          lcd_gotoxy(0,1);
        
          

          
          lcd_putchar(t/100+0x30);
          lcd_putchar((t%100)/10+0x30);
          lcd_putchar((t%100)%10+0x30);
          lcd_putchar('/');
          lcd_putchar(i/100+0x30);
          lcd_putchar((i%100)/10+0x30);
          lcd_putchar((i%100)%10+0x30);
          lcd_putsf(s8);
          lcd_gotoxy(8,1); 
          dec2bin(alarm[t-1][5]); 
          
          }
    
}

void erase_mas()
{
for (h=0;h<N;h++)
               for (j=0;j<6;j++)
                 alarm[h][j]=0;
t=i=0;                 
}

void erase_alarm()
{    if (i==0) lcd_putsf(s7); else{
     lcd_gotoxy(0,0);
     lcd_putsf(s9);
     lcd_gotoxy(0,1);
     lcd_putsf(s10);
     }
}

void set_date()
{

lcd_gotoxy(0,0);
lcd_putsf(s4);
lcd_gotoxy(0,1);
lcd_putchar(day/10+0x30);
lcd_putchar(day%10+0x30);
lcd_putchar('-');
lcd_putchar(month/10+0x30);
lcd_putchar(month%10+0x30);
lcd_putchar('-');
lcd_putchar(year/10+0x30);
lcd_putchar(year%10+0x30); 
             
}

void set_time()
{
lcd_gotoxy(0,0);
lcd_putsf(s5);
lcd_gotoxy(0,1);

lcd_putchar(hour/10+0x30);
lcd_putchar(hour%10+0x30);        
lcd_putchar(':');
lcd_putchar(min/10+0x30);
lcd_putchar(min%10+0x30);
lcd_putsf(s11);
}                           

void clear()
{
lcd_gotoxy(0,1); 
lcd_putsf(s11);
}

void dec2bin(char n)
{
if (0 == n) {
return;
} else {

if (n%2) lcd_putchar('1'); else lcd_putchar('0');
dec2bin(n/2);

}
} 
             
//      
void fDisplayMenu(unsigned int countmenu)
{        
                                 
        switch(countmenu)
        {// 
        {
                case 0: count=7; break;
                case 1:{
                j=1; 
                lcd_putsf(s1);
                clear(); 
                break; //set alarm
                }
                case 2: {
                lcd_putsf(s2);
                clear();  
                break; //show alarm   
                }
                case 3:  {
                lcd_putsf(s3);
                clear();  
                break; //erase alarm
                }
                case 4: set_date(); break; //set date
                case 5: set_time(); break; //set time 
                
                case 6:{ 
                j=1;
                lcd_putsf(s041);
                clear(); 
                break; //set out  1
                }     
                
                case 7:{ 
                j=1;
                lcd_putsf(s042);
                clear(); 
                break; //set out 2
                } 
                
                case 8: count=1; break;
                
        }        
        
        //  
        {
        case 9:
        {
         count=10;
         if (j>1) j--;
         break;
        }
        
        
        case 10:
        {   
        lcd_putsf(s12);
        lcd_putchar(j+0x30);
        if ((~(set) & mask_bit_int[j-1])>0) lcd_putsf(s13); else lcd_putsf(s14);     
        break; 
        }
        
        case 100:
        {      
         count=10;
         if ((~(set) & mask_bit_int[j-1])>0) set=set | mask_bit_int[j-1]; else set=set & ~(mask_bit_int[j-1]);
         break;
        }
        
        case 11:
        {   
        count=10; 
        if (j<8) j++;   
        break; 
        }
        
        
        }
               
        // 
        { 
                case 19:
                { 
                count=20;
                if (t>1) t--;
                break;  
                }    
                
                case 20: 
                {                
                show_alarm();
                break;
                } 
                
                case 200: count=20; break;
                
                case 21:
                { 
                count=20;
                if (t<i) t++;
                break;  
                } 
                }
                
        // 
        {
                case 29:
                {
                 erase_mas();
                 lcd_clear();
                 count=30;
                 break;
                }
               
                case 30: erase_alarm(); break;
                
                case 31:
                {
                 lcd_clear();
                 count=3;
                 break;
                }  
                }
                
        //  
        {
                //
                
                case 39: // 
                {
                count=40;
                if (day>1) day--; else day=31;
                break;
                }
                
                case 40: {   // 
                set_date(); 
                _lcd_write_data(0xe);
                lcd_gotoxy(1,1);
                break;
                }
                
                case 41:     // 
                {
                count=40;
                if (day<31) day++; else day=1;
                break;
                }
                  
                
                //
                
                
                case 399: // 
                {
                count=400;
                if (month>1) month--; else month=12;
                break;
                }
                
                case 400: {
                set_date(); 
                _lcd_write_data(0xe);
                lcd_gotoxy(4,1);
                break;
                }
                
                case 401: // 
                {
                count=400;
                if (month<12) month++; else month=1;
                break;
                }
                
                
                //
                
                case 3999: // 
                {
                count=4000;
                if (year>0) year--;
                break;
                }
                
                case 4000: {
                set_date(); 
                _lcd_write_data(0xe);
                lcd_gotoxy(7,1);
                break;
                }
                
                case 4001: // 
                {
                count=4000;
                if (year<99) year++;
                break;
                }
                

                case 40000:   // 
                { 
                count=4;
                rtc_set_date(week_day,day,month,year);
                break;
                }
                }

        //  
        {
                case 49: // 
                {
                count=50;
                if (hour>0) hour--; else hour=23;
                break;
                }
                
                case 50: {   // 
                set_time();
                lcd_gotoxy(1,1); 
                _lcd_write_data(0xe);
                break;
                }
                
                case 51: // 
                {
                count=50;
                if (hour<23) hour++; else hour=0;
                break;
                }
                
                case 499: // 
                {
                count=500;
                if (min>0) min--; else min=59;
                break;
                }
                
                case 500: {   // 
                set_time(); 
                _lcd_write_data(0xe);
                lcd_gotoxy(4,1);
                break;
                }
                
                case 501: // 
                {
                count=500;
                if (min<59) min++; else min=0;
                break;
                }
                
                case 5000:   // 
                { 
                count=5;
                rtc_set_time(hour,min,0);
             
                break;
                }
                
                }
                
        //1
        { 
        
        case 59:
        {
         count=60;
         if (j>1) j--;
         break;
        }
        
        
        case 60:
        {   
        lcd_putsf(s12);
        lcd_putchar(j+0x30);
        if ((~(out1) & mask_bit_int[j-1])>0) lcd_putsf(s13); else lcd_putsf(s14);     
        break; 
        }
        
        case 600:
        {      
         count=60;
         if ((~(out1) & mask_bit_int[j-1])>0) out1=out1 | mask_bit_int[j-1]; else out1=out1 & ~(mask_bit_int[j-1]);
         break;
        }
        
        case 61:
        {   
        count=60; 
        if (j<8) j++; else count=63;  
        break; 
        } 
        
        //  1
        {
        case 62:
        {     
        count=60;
        clear();
        break;
        }

        
        case 63:
        {
        lcd_putsf(s05);     
        lcd_gotoxy(0,1); 
        lcd_putchar(dur1/10+0x30);   
        lcd_putchar(dur1%10+0x30);
        break;
        }
        
        case 64:
        {     
        count=63;
        break;
        }
        
        case 629:
        {     
        if (dur1>1) dur1--; else dur1=90;
        count=630;
        break;
        }
        
        case 630:
        { 
        lcd_putsf(s05);     
        lcd_gotoxy(0,1); 
        lcd_putchar(dur1/10+0x30);   
        lcd_putchar(dur1%10+0x30);    
        lcd_gotoxy(1,1);
        _lcd_write_data(0xe);
        break;
        }
        
        case 6300:
        {     
        count=63;
        break;
        }
        
        case 631:
        {     
        if (dur1<90) dur1++; else dur1=1;
        count=630;
        break;
        }
        
        }
        }
        
        //2
        { 
        
        case 69:
        {
         count=70;
         if (j>1) j--;
         break;
        }
        
        
        case 70:
        {   
        lcd_putsf(s12);
        lcd_putchar(j+0x30);
        if ((~(out2) & mask_bit_int[j-1])>0) lcd_putsf(s13); else lcd_putsf(s14);     
        break; 
        }
        
        case 700:
        {      
         count=70;
         if ((~(out2) & mask_bit_int[j-1])>0) out2=out2 | mask_bit_int[j-1]; else out2=out2 & ~(mask_bit_int[j-1]);
         break;
        }
        
        case 71:
        {   
        count=70; 
        if (j<8) j++; else count=73;  
        break; 
        } 
        
        //  2
        {
        case 72:
        {     
        count=70;
        clear();
        break;
        }

        
        case 73:
        {
        lcd_putsf(s05);     
        lcd_gotoxy(0,1); 
        lcd_putchar(dur2/10+0x30);   
        lcd_putchar(dur2%10+0x30);
        break;
        }
        
        case 74:
        {     
        count=73;
        break;
        }
        
        case 729:
        {     
        if (dur2>1) dur2--; else dur2=90;
        count=730;
        break;
        }
        
        case 730:
        { 
        lcd_putsf(s05);     
        lcd_gotoxy(0,1); 
        lcd_putchar(dur2/10+0x30);   
        lcd_putchar(dur2%10+0x30);    
        lcd_gotoxy(1,1);
        _lcd_write_data(0xe);
        break;
        }
        
        case 7300:
        {     
        count=73;
        break;
        }
        
        case 731:
        {     
        if (dur2<90) dur2++; else dur2=1;
        count=730;
        break;
        }
        
        }
        }
        
                


        default: 
        {   
        break;
        }
        }   
            
        delay_ms(70);
        _lcd_write_data(0xc);         
}

void fMenu()
{                   
        
        count=1;
        while(1)
        {       
                lcd_gotoxy(0,0);              
                BUT_Debrief();
                l = BUT_GetKey();
                
                 if (l==1)
                 {
                 count*=10;
                 }
                 
                 if (l==2)
                 {
                 if(count<10)
                                break;
                        if(count>=10)
                        {                  
                                count/=10; 
                        } 
                 } 
                 
                 if (l==3)
                 {
                 count--;
                 }
                 
                 if (l==4)
                 {
                 count++;
                 }
                 
                
                
                //        count
               
                fDisplayMenu(count);                        
        };
        
}

void addalarm()
{
rtc_get_time(&hour,&min,&sek);  // 
rtc_get_date(&week_day,&day,&month,&year);  //   
  
if (i==N) i=0;
      
      
alarm[i][0]=month;
alarm[i][1]=day;
alarm[i][2]=hour;
alarm[i][3]=min;
alarm[i][4]=sek; 
alarm[i][5]=input;
      
     

      

i++;
t=i;
delay_ms(200);

}

void ChangeAlarm()
{
 if (PINA==0XFF) input=0XFF;
 if ((PINA!=input)&&(PINA!=0XFF)) 
 {
  input=PINA;

  if ((set & ~(input))>0) 
  {
  
  addalarm();
   
   if ((out1 & ~(input))>0)
   { 
    PORTB |= 1<<3;
    h1=0;
   }
   
   if ((out2 & ~(input))>0)
   { 
    PORTB |= 1<<4;
    h2=0;
   }
  
  }
  
           
 }

if (h1>(dur1-1))
  {
   PORTB &= ~(1<<3);
   h1=0;
  }

if (h2>(dur2-1))
  {
   PORTB &= ~(1<<4);
   h2=0;
  }   
   
}

void main(void)
{
{
delay_ms(80);


// Declare your local variables here

// Input/Output Ports initialization
// Port A initialization
// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State7=P State6=P State5=P State4=P State3=P State2=P State1=P State0=P 
PORTA=0xFF;
DDRA=0x00;

// Port B initialization
// Func7=Out Func6=Out Func5=Out Func4=Out Func3=Out Func2=In Func1=In Func0=In 
// State7=0 State6=0 State5=0 State4=0 State3=0 State2=P State1=P State0=P 
PORTB=0x07;
DDRB=0xF8;

// Port C initialization
// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State7=P State6=P State5=P State4=P State3=P State2=P State1=P State0=P 
PORTC=0xFF;
DDRC=0x00;


// Port D initialization
// Func7=Out Func6=Out Func5=Out Func4=Out Func3=In Func2=Out Func1=Out Func0=Out 
// State7=0 State6=0 State5=0 State4=0 State3=P State2=0 State1=0 State0=0 
PORTD=0x08;
DDRD=0xF7;

// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: Timer 0 Stopped
// Mode: Normal top=0xFF
// OC0 output: Disconnected
TCCR0=0x00;
TCNT0=0xEC;
OCR0=0x00;

// Timer/Counter 1 initialization
// Clock source: System Clock
// Clock value: 125,000 kHz
// Mode: Normal top=0xFFFF
// OC1A output: Discon.
// OC1B output: Discon.
// Noise Canceler: Off
// Input Capture on Falling Edge
// Timer1 Overflow Interrupt: Off
// Input Capture Interrupt: Off
// Compare A Match Interrupt: On
// Compare B Match Interrupt: Off
TCCR1A=0x00;
TCCR1B=0x03;
TCNT1H=0x00;
TCNT1L=0x00;
ICR1H=0x00;
ICR1L=0x00;
OCR1AH=0x1E;
OCR1AL=0x85;
OCR1BH=0x00;
OCR1BL=0x00;

// Timer/Counter 2 initialization
// Clock source: System Clock
// Clock value: Timer2 Stopped
// Mode: Normal top=0xFF
// OC2 output: Disconnected
ASSR=0x00;
TCCR2=0x00;
TCNT2=0x00;
OCR2=0x00;

// External Interrupt(s) initialization
// INT0: Off
// INT1: Off
// INT2: On
// INT2 Mode: Falling Edge
GICR|=0x20;
MCUCR=0x00;
MCUCSR=0x00;
GIFR=0x20;

// Timer(s)/Counter(s) Interrupt(s) initialization
TIMSK=0x10;

// USART initialization
// USART disabled
UCSRB=0x00;

// Analog Comparator initialization
// Analog Comparator: Off
// Analog Comparator Input Capture by Timer/Counter 1: Off
ACSR=0x80;
SFIOR=0x00;

// ADC initialization
// ADC disabled
ADCSRA=0x00;

// SPI initialization
// SPI disabled
SPCR=0x00;



// TWI initialization
// TWI disabled
TWCR=0x00;

// I2C Bus initialization
i2c_init();

// DS1307 Real Time Clock initialization
// Square wave output on pin SQW/OUT: On
// Square wave frequency: 1Hz
rtc_init(0,1,0);
h = rtc_read(0x00);   //   
    delay_ms(1);
    if(h > 127)
    {
    rtc_write(0x00, 0x00); //,     1
    }
    
// Alphanumeric LCD initialization
// Connections specified in the
// Project|Configure|C Compiler|Libraries|Alphanumeric LCD menu:
// RS - PORTD Bit 0
// RD - PORTD Bit 1
// EN - PORTD Bit 2
// D4 - PORTD Bit 4
// D5 - PORTD Bit 5
// D6 - PORTD Bit 6
// D7 - PORTD Bit 7
// Characters/line: 16
lcd_init(16);
BUT_Init();
/*
rtc_set_time(15,56,14);
rtc_set_date(0,01,01,02);
*/
// Global enable interrupts
#asm("sei")
}
while (1)
      {
      // Place your code here
       show_time();
      
       BUT_Debrief();
       l = BUT_GetKey(); 
       
      if (l==1)
       { 
       lcd_clear();
       fMenu();
       }
      
      
              
      }
}