
;CodeVisionAVR C Compiler V2.05.3 Standard
;(C) Copyright 1998-2011 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type                : ATmega16
;Program type             : Application
;Clock frequency          : 8,000000 MHz
;Memory model             : Small
;Optimize for             : Size
;(s)printf features       : int, width
;(s)scanf features        : int, width
;External RAM size        : 0
;Data Stack size          : 256 byte(s)
;Heap size                : 0 byte(s)
;Promote 'char' to 'int'  : Yes
;'char' is unsigned       : Yes
;8 bit enums              : Yes
;Global 'const' stored in FLASH     : No
;Enhanced function parameter passing: Yes
;Enhanced core instructions         : On
;Smart register allocation          : On
;Automatic register allocation      : On

	#pragma AVRPART ADMIN PART_NAME ATmega16
	#pragma AVRPART MEMORY PROG_FLASH 16384
	#pragma AVRPART MEMORY EEPROM 512
	#pragma AVRPART MEMORY INT_SRAM SIZE 1119
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x60

	#define CALL_SUPPORTED 1

	.LISTMAC
	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU USR=0xB
	.EQU UDR=0xC
	.EQU SPSR=0xE
	.EQU SPDR=0xF
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E
	.EQU EEARH=0x1F
	.EQU WDTCR=0x21
	.EQU MCUCR=0x35
	.EQU GICR=0x3B
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.EQU __SRAM_START=0x0060
	.EQU __SRAM_END=0x045F
	.EQU __DSTACK_SIZE=0x0100
	.EQU __HEAP_SIZE=0x0000
	.EQU __CLEAR_SRAM_SIZE=__SRAM_END-__SRAM_START+1

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ANDI R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ORI  R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __CLRD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+(@1))
	LDI  R31,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	LDI  R22,BYTE3(2*@0+(@1))
	LDI  R23,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTW2FN
	LDI  R26,LOW(2*@0+(@1))
	LDI  R27,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD2FN
	LDI  R26,LOW(2*@0+(@1))
	LDI  R27,HIGH(2*@0+(@1))
	LDI  R24,BYTE3(2*@0+(@1))
	LDI  R25,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+(@2))
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+(@3))
	LDI  R@1,HIGH(@2+(@3))
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+(@3))
	LDI  R@1,HIGH(@2*2+(@3))
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+(@1)
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+(@1)
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	LDS  R22,@0+(@1)+2
	LDS  R23,@0+(@1)+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+(@2)
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+(@3)
	LDS  R@1,@2+(@3)+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+(@1)
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	LDS  R24,@0+(@1)+2
	LDS  R25,@0+(@1)+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+(@1),R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	STS  @0+(@1)+2,R22
	STS  @0+(@1)+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+(@1),R0
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+(@1),R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+(@1),R@2
	STS  @0+(@1)+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTBSR
	STD  Y+@1,R@0
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	CALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __GETD1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X+
	LD   R22,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	CALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __GETBRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	LD   R@0,X
	.ENDM

	.MACRO __GETWRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	LD   R@0,X+
	LD   R@1,X
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __CLRD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R30
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	ST   Z,R@0
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRR0
	MULS R@0,R@1
	.ENDM

	.MACRO __MULBRRU0
	MUL  R@0,R@1
	.ENDM

	.MACRO __MULBNWRU
	LDI  R26,@2
	MUL  R26,R@0
	MOVW R30,R0
	MUL  R26,R@1
	ADD  R31,R0
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _hour=R5
	.DEF _min=R4
	.DEF _sek=R7
	.DEF _day=R6
	.DEF _month=R9
	.DEF _year=R8
	.DEF _week_day=R11
	.DEF _count=R12
	.DEF _i=R10

	.CSEG
	.ORG 0x00

;START OF CODE MARKER
__START_OF_CODE:

;INTERRUPT VECTORS
	JMP  __RESET
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  _timer1_compa_isr
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  _ext_int2_isr
	JMP  0x00
	JMP  0x00

_mask_bit_int:
	.DB  0x1,0x0,0x2,0x0,0x4,0x0,0x8,0x0
	.DB  0x10,0x0,0x20,0x0,0x40,0x0,0x80,0x0
_s1:
	.DB  0x53,0x65,0x74,0x20,0x41,0x6C,0x61,0x72
	.DB  0x6D,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x0
_s2:
	.DB  0x53,0x68,0x6F,0x77,0x20,0x41,0x6C,0x61
	.DB  0x72,0x6D,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x0
_s3:
	.DB  0x45,0x72,0x61,0x73,0x65,0x20,0x41,0x6C
	.DB  0x61,0x72,0x6D,0x20,0x20,0x20,0x20,0x20
	.DB  0x0
_s4:
	.DB  0x53,0x65,0x74,0x20,0x44,0x61,0x74,0x65
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x0
_s5:
	.DB  0x53,0x65,0x74,0x20,0x54,0x69,0x6D,0x65
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x0
_s041:
	.DB  0x53,0x65,0x74,0x20,0x4F,0x75,0x74,0x70
	.DB  0x75,0x74,0x20,0x31,0x20,0x20,0x20,0x20
	.DB  0x0
_s042:
	.DB  0x53,0x65,0x74,0x20,0x4F,0x75,0x74,0x70
	.DB  0x75,0x74,0x20,0x32,0x20,0x20,0x20,0x20
	.DB  0x0
_s05:
	.DB  0x44,0x75,0x72,0x61,0x74,0x69,0x6F,0x6E
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x0
_s6:
	.DB  0x20,0x20,0x20,0x21,0x20,0x0
_s7:
	.DB  0x6E,0x6F,0x20,0x61,0x6C,0x61,0x72,0x6D
	.DB  0x73,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x0
_s8:
	.DB  0x20,0x30,0x30,0x30,0x30,0x30,0x30,0x30
	.DB  0x30,0x0
_s9:
	.DB  0x65,0x72,0x61,0x73,0x65,0x20,0x61,0x6C
	.DB  0x6C,0x3F,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x0
_s10:
	.DB  0x75,0x70,0x3D,0x79,0x65,0x73,0x2C,0x20
	.DB  0x64,0x6F,0x77,0x6E,0x3D,0x6E,0x6F,0x20
	.DB  0x0
_s11:
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20
	.DB  0x0
_s12:
	.DB  0x41,0x6C,0x61,0x72,0x6D,0x20,0x0
_s13:
	.DB  0x20,0x20,0x20,0x20,0x75,0x6E,0x73,0x65
	.DB  0x74,0x0
_s14:
	.DB  0x20,0x20,0x20,0x20,0x20,0x20,0x73,0x65
	.DB  0x74,0x0
_tbl10_G100:
	.DB  0x10,0x27,0xE8,0x3,0x64,0x0,0xA,0x0
	.DB  0x1,0x0
_tbl16_G100:
	.DB  0x0,0x10,0x0,0x1,0x10,0x0,0x1,0x0

;REGISTER BIT VARIABLES INITIALIZATION
__REG_BIT_VARS:
	.DW  0x0000

_0x3:
	.DB  0x78
_0x4:
	.DB  0xFF
_0x5:
	.DB  0x1
_0x6:
	.DB  0xA
_0x7:
	.DB  0x14
_0x8:
	.DB  0xFF
_0x9:
	.DB  0xFF
_0xA:
	.DB  0xFF
_0xBB:
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0
_0x2040003:
	.DB  0x80,0xC0

__GLOBAL_INI_TBL:
	.DW  0x01
	.DW  0x02
	.DW  __REG_BIT_VARS*2

	.DW  0x01
	.DW  _input
	.DW  _0x4*2

	.DW  0x01
	.DW  _j
	.DW  _0x5*2

	.DW  0x01
	.DW  _dur1
	.DW  _0x6*2

	.DW  0x01
	.DW  _dur2
	.DW  _0x7*2

	.DW  0x01
	.DW  _set
	.DW  _0x8*2

	.DW  0x01
	.DW  _out1
	.DW  _0x9*2

	.DW  0x01
	.DW  _out2
	.DW  _0xA*2

	.DW  0x0A
	.DW  0x04
	.DW  _0xBB*2

	.DW  0x02
	.DW  __base_y_G102
	.DW  _0x2040003*2

_0xFFFFFFFF:
	.DW  0

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  GICR,R31
	OUT  GICR,R30
	OUT  MCUCR,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;CLEAR R2-R14
	LDI  R24,(14-2)+1
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(__CLEAR_SRAM_SIZE)
	LDI  R25,HIGH(__CLEAR_SRAM_SIZE)
	LDI  R26,__SRAM_START
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;HARDWARE STACK POINTER INITIALIZATION
	LDI  R30,LOW(__SRAM_END-__HEAP_SIZE)
	OUT  SPL,R30
	LDI  R30,HIGH(__SRAM_END-__HEAP_SIZE)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(__SRAM_START+__DSTACK_SIZE)
	LDI  R29,HIGH(__SRAM_START+__DSTACK_SIZE)

	JMP  _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x160

	.CSEG
;#include <mega16.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x40
	.EQU __sm_mask=0xB0
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0xA0
	.EQU __sm_ext_standby=0xB0
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif
;#include <stdio.h>
;#include <delay.h>
;#include <i2c.h>
;#include <ds1307.h>
;#include <alcd.h>
;#include <buttons.h>
;
;
;// I2C Bus functions
;#asm
   .equ __lcd_port=0x12; PORTD
   .equ __i2c_port=0x18;PORTB
   .equ __sda_bit=0
   .equ __scl_bit=1
; 0000 0010 #endasm
;
;
;// Declare your global variables here
;typedef unsigned char byte;
;char hour=0,min=0,sek=0,day=0,month=0,year=0,week_day=0;
;bit time_flag=0;
;unsigned int count=0;
;const byte N=120;

	.DSEG
;byte alarm[N][6];
;byte i=0;
;char input=0XFF;
;unsigned char l;
;byte t=0,h,h1=0,h2=0,j=1,dur1=10,dur2=20;
;
;
;void ChangeAlarm(void);
;void show_time(void);
;void dec2bin(char);
;
;
;
;
;flash unsigned int mask_bit_int[8]={0x0001,0x0002,0x0004,0x0008,0x0010,0x0020,0x0040,0x0080};
;
;int set=0xFF,out1=0xFF,out2=0xFF;
;
;flash char s1[]="Set Alarm       ",
;           s2[]="Show Alarm      ",
;           s3[]="Erase Alarm     ",
;           s4[]="Set Date        ",
;           s5[]="Set Time        ",
;         s041[]="Set Output 1    ",
;         s042[]="Set Output 2    ",
;          s05[]="Duration        ",
;           s6[]="   ! ",
;           s7[]="no alarms       ",
;           s8[]=" 00000000",
;           s9[]="erase all?      ",
;          s10[]="up=yes, down=no ",
;          s11[]="                ",
;          s12[]="Alarm ",
;          s13[]="    unset",
;          s14[]="      set";
;
;
;interrupt [EXT_INT2] void ext_int2_isr(void)
; 0000 003F {

	.CSEG
_ext_int2_isr:
	ST   -Y,R30
	IN   R30,SREG
	ST   -Y,R30
; 0000 0040 // Place your code here
; 0000 0041     time_flag=1;
	SET
	BLD  R2,0
; 0000 0042     h1++;
	LDS  R30,_h1
	SUBI R30,-LOW(1)
	STS  _h1,R30
; 0000 0043     h2++;
	LDS  R30,_h2
	SUBI R30,-LOW(1)
	STS  _h2,R30
; 0000 0044 
; 0000 0045 }
	LD   R30,Y+
	OUT  SREG,R30
	LD   R30,Y+
	RETI
;
;interrupt [TIM1_COMPA] void timer1_compa_isr(void)
; 0000 0048 {
_timer1_compa_isr:
	ST   -Y,R0
	ST   -Y,R1
	ST   -Y,R15
	ST   -Y,R22
	ST   -Y,R23
	ST   -Y,R24
	ST   -Y,R25
	ST   -Y,R26
	ST   -Y,R27
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 0049 TCNT1H=0;
	LDI  R30,LOW(0)
	OUT  0x2D,R30
; 0000 004A TCNT1L=0;
	OUT  0x2C,R30
; 0000 004B // Place your code here
; 0000 004C ChangeAlarm();
	RCALL _ChangeAlarm
; 0000 004D }
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	LD   R25,Y+
	LD   R24,Y+
	LD   R23,Y+
	LD   R22,Y+
	LD   R15,Y+
	LD   R1,Y+
	LD   R0,Y+
	RETI
;
;// 
;
;#define MASK_BUTTONS     (1<<DOWN)|(1<<CANCEL)|(1<<UP)|(1<<ENTER)
;#define ClearBit(reg, bit)       (reg) &= (~(1<<(bit)))
;#define SetBit(reg, bit)          (reg) |= (1<<(bit))
;#define BitIsClear(reg, bit)    ((reg & (1<<(bit))) == 0)
;#define BitIsSet(reg, bit)       ((reg & (1<<(bit))) != 0)
;
;volatile unsigned char pressedKey = 0;
;unsigned char comp = 0;
;
;
;//_______________________________________
;void BUT_Init(void)
; 0000 005D {
_BUT_Init:
; 0000 005E   DDRX_BUTTON &= ~(MASK_BUTTONS);
	IN   R30,0x14
	ANDI R30,LOW(0xF0)
	OUT  0x14,R30
; 0000 005F   PORT_BUTTON |= MASK_BUTTONS;
	IN   R30,0x15
	ORI  R30,LOW(0xF)
	OUT  0x15,R30
; 0000 0060 }
	RET
;
;//_______________________________________
;void BUT_Debrief(void)
; 0000 0064 {
_BUT_Debrief:
; 0000 0065 unsigned char key;
; 0000 0066 
; 0000 0067   //   
; 0000 0068   if (BitIsClear(PIN_BUTTON, ENTER))
	ST   -Y,R17
;	key -> R17
	SBIC 0x13,3
	RJMP _0xB
; 0000 0069     key = KEY_ENTER;
	LDI  R17,LOW(1)
; 0000 006A   else if (BitIsClear(PIN_BUTTON, CANCEL))
	RJMP _0xC
_0xB:
	SBIC 0x13,0
	RJMP _0xD
; 0000 006B     key = KEY_CANCEL;
	LDI  R17,LOW(2)
; 0000 006C   else if (BitIsClear(PIN_BUTTON, UP))
	RJMP _0xE
_0xD:
	SBIC 0x13,1
	RJMP _0xF
; 0000 006D     key = KEY_UP;
	LDI  R17,LOW(3)
; 0000 006E   else if (BitIsClear(PIN_BUTTON, DOWN))
	RJMP _0x10
_0xF:
	SBIC 0x13,2
	RJMP _0x11
; 0000 006F     key = KEY_DOWN;
	LDI  R17,LOW(4)
; 0000 0070   else {
	RJMP _0x12
_0x11:
; 0000 0071     key = KEY_NULL;
	LDI  R17,LOW(0)
; 0000 0072   }
_0x12:
_0x10:
_0xE:
_0xC:
; 0000 0073 
; 0000 0074   //    - 
; 0000 0075   if (key) {
	CPI  R17,0
	BREQ _0x13
; 0000 0076 
; 0000 0077     //    
; 0000 0078     //    
; 0000 0079     if (comp == THRESHOLD) {
	LDS  R30,_comp
	CPI  R30,0
	BRNE _0x14
; 0000 007A       comp = THRESHOLD+10;
	LDI  R30,LOW(10)
	STS  _comp,R30
; 0000 007B       pressedKey = key;
	STS  _pressedKey,R17
; 0000 007C       return;
	RJMP _0x20C0006
; 0000 007D     }
; 0000 007E     else if (comp < (THRESHOLD+5)) comp++;
_0x14:
	LDS  R26,_comp
	CPI  R26,LOW(0x5)
	BRSH _0x16
	LDS  R30,_comp
	SUBI R30,-LOW(1)
	STS  _comp,R30
; 0000 007F 
; 0000 0080   }
_0x16:
; 0000 0081   else comp=0;
	RJMP _0x17
_0x13:
	LDI  R30,LOW(0)
	STS  _comp,R30
; 0000 0082 }
_0x17:
	RJMP _0x20C0006
;
;//__________________________
;unsigned char BUT_GetKey(void)
; 0000 0086 {
_BUT_GetKey:
; 0000 0087   unsigned char key = pressedKey;
; 0000 0088   pressedKey = KEY_NULL;
	ST   -Y,R17
;	key -> R17
	LDS  R17,_pressedKey
	LDI  R30,LOW(0)
	STS  _pressedKey,R30
; 0000 0089   return key;
	MOV  R30,R17
_0x20C0006:
	LD   R17,Y+
	RET
; 0000 008A }
;
;void show_time()
; 0000 008D {
_show_time:
; 0000 008E 
; 0000 008F ///************  **********//////////
; 0000 0090 
; 0000 0091          /////////////////  
; 0000 0092          if(time_flag==1)
	SBRS R2,0
	RJMP _0x18
; 0000 0093          {
; 0000 0094 
; 0000 0095           rtc_get_time(&hour,&min,&sek);  // 
	CALL SUBOPT_0x0
; 0000 0096           rtc_get_date(&week_day,&day,&month,&year);  // 
; 0000 0097 
; 0000 0098           lcd_gotoxy(0,0);
	CALL SUBOPT_0x1
; 0000 0099           lcd_putchar(hour/10+0x30);    // 
	CALL SUBOPT_0x2
; 0000 009A           lcd_putchar(hour%10+0x30);
; 0000 009B           lcd_putchar(':');
; 0000 009C           lcd_putchar(min/10+0x30);     //
; 0000 009D           lcd_putchar(min%10+0x30);
; 0000 009E           lcd_putchar(':');
	LDI  R26,LOW(58)
	CALL _lcd_putchar
; 0000 009F           lcd_putchar(sek/10+0x30);     //
	MOV  R26,R7
	CALL SUBOPT_0x3
; 0000 00A0           lcd_putchar(sek%10+0x30);
	MOV  R26,R7
	CALL SUBOPT_0x4
; 0000 00A1           lcd_putsf(s6);
	LDI  R26,LOW(_s6*2)
	LDI  R27,HIGH(_s6*2)
	CALL _lcd_putsf
; 0000 00A2           lcd_putchar(i/100+0x30);
	CALL SUBOPT_0x5
; 0000 00A3           lcd_putchar((i%100)/10+0x30);
; 0000 00A4           lcd_putchar((i%100)%10+0x30);
; 0000 00A5           lcd_gotoxy(0,1);
	CALL SUBOPT_0x6
; 0000 00A6           lcd_putchar(day/10+0x30);     //
	MOV  R26,R6
	CALL SUBOPT_0x3
; 0000 00A7           lcd_putchar(day%10+0x30);
	MOV  R26,R6
	CALL SUBOPT_0x4
; 0000 00A8           lcd_putchar('/');
	LDI  R26,LOW(47)
	CALL _lcd_putchar
; 0000 00A9           lcd_putchar(month/10+0x30);   //
	MOV  R26,R9
	CALL SUBOPT_0x3
; 0000 00AA           lcd_putchar(month%10+0x30);
	MOV  R26,R9
	CALL SUBOPT_0x4
; 0000 00AB 
; 0000 00AC           lcd_putchar(' ');
	LDI  R26,LOW(32)
	CALL SUBOPT_0x7
; 0000 00AD           lcd_putchar(' ');
; 0000 00AE           lcd_putsf(s8);
	CALL SUBOPT_0x8
; 0000 00AF           lcd_gotoxy(8,1);
; 0000 00B0           dec2bin(set);
	LDS  R26,_set
	RCALL _dec2bin
; 0000 00B1 
; 0000 00B2 
; 0000 00B3 
; 0000 00B4           time_flag=0;                  //  
	CLT
	BLD  R2,0
; 0000 00B5          }
; 0000 00B6 }
_0x18:
	RET
;
;void show_alarm()
; 0000 00B9 {
_show_alarm:
; 0000 00BA        if (i==0){
	TST  R10
	BRNE _0x19
; 0000 00BB         lcd_putsf(s7);
	LDI  R26,LOW(_s7*2)
	LDI  R27,HIGH(_s7*2)
	CALL _lcd_putsf
; 0000 00BC        } else {
	RJMP _0x1A
_0x19:
; 0000 00BD 
; 0000 00BE       lcd_gotoxy(0,0);
	CALL SUBOPT_0x1
; 0000 00BF           lcd_putchar(alarm[t-1][2]/10+0x30);    // 
	CALL SUBOPT_0x9
	CALL SUBOPT_0x3
; 0000 00C0           lcd_putchar(alarm[t-1][2]%10+0x30);
	CALL SUBOPT_0x9
	CALL SUBOPT_0xA
; 0000 00C1           lcd_putchar(':');
; 0000 00C2           lcd_putchar(alarm[t-1][3]/10+0x30);     //
	__ADDW1MN _alarm,3
	LD   R26,Z
	CALL SUBOPT_0x3
; 0000 00C3           lcd_putchar(alarm[t-1][3]%10+0x30);
	CALL SUBOPT_0xB
	__ADDW1MN _alarm,3
	LD   R26,Z
	CALL SUBOPT_0xA
; 0000 00C4           lcd_putchar(':');
; 0000 00C5           lcd_putchar(alarm[t-1][4]/10+0x30);     //
	__ADDW1MN _alarm,4
	LD   R26,Z
	CALL SUBOPT_0x3
; 0000 00C6           lcd_putchar(alarm[t-1][4]%10+0x30);
	CALL SUBOPT_0xB
	__ADDW1MN _alarm,4
	CALL SUBOPT_0xC
	CALL SUBOPT_0x7
; 0000 00C7           lcd_putchar(' ');
; 0000 00C8 
; 0000 00C9           lcd_putchar(alarm[t-1][1]/10+0x30);     //
	CALL SUBOPT_0xB
	__ADDW1MN _alarm,1
	LD   R26,Z
	CALL SUBOPT_0x3
; 0000 00CA           lcd_putchar(alarm[t-1][1]%10+0x30);
	CALL SUBOPT_0xB
	__ADDW1MN _alarm,1
	CALL SUBOPT_0xC
	CALL _lcd_putchar
; 0000 00CB           lcd_putchar('/');
	LDI  R26,LOW(47)
	CALL _lcd_putchar
; 0000 00CC           lcd_putchar(alarm[t-1][0]/10+0x30);     //
	CALL SUBOPT_0xB
	SUBI R30,LOW(-_alarm)
	SBCI R31,HIGH(-_alarm)
	LD   R26,Z
	CALL SUBOPT_0x3
; 0000 00CD           lcd_putchar(alarm[t-1][0]%10+0x30);
	CALL SUBOPT_0xB
	SUBI R30,LOW(-_alarm)
	SBCI R31,HIGH(-_alarm)
	CALL SUBOPT_0xC
	CALL SUBOPT_0x7
; 0000 00CE           lcd_putchar(' ');
; 0000 00CF 
; 0000 00D0 
; 0000 00D1 
; 0000 00D2           lcd_gotoxy(0,1);
	CALL SUBOPT_0x6
; 0000 00D3 
; 0000 00D4 
; 0000 00D5 
; 0000 00D6 
; 0000 00D7           lcd_putchar(t/100+0x30);
	LDS  R26,_t
	LDI  R27,0
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	CALL SUBOPT_0xD
; 0000 00D8           lcd_putchar((t%100)/10+0x30);
	CALL SUBOPT_0xD
; 0000 00D9           lcd_putchar((t%100)%10+0x30);
	CALL __MODW21
	SUBI R30,-LOW(48)
	MOV  R26,R30
	CALL _lcd_putchar
; 0000 00DA           lcd_putchar('/');
	LDI  R26,LOW(47)
	CALL _lcd_putchar
; 0000 00DB           lcd_putchar(i/100+0x30);
	CALL SUBOPT_0x5
; 0000 00DC           lcd_putchar((i%100)/10+0x30);
; 0000 00DD           lcd_putchar((i%100)%10+0x30);
; 0000 00DE           lcd_putsf(s8);
	CALL SUBOPT_0x8
; 0000 00DF           lcd_gotoxy(8,1);
; 0000 00E0           dec2bin(alarm[t-1][5]);
	CALL SUBOPT_0xB
	__ADDW1MN _alarm,5
	LD   R26,Z
	RCALL _dec2bin
; 0000 00E1 
; 0000 00E2           }
_0x1A:
; 0000 00E3 
; 0000 00E4 }
	RET
;
;void erase_mas()
; 0000 00E7 {
_erase_mas:
; 0000 00E8 for (h=0;h<N;h++)
	LDI  R30,LOW(0)
	STS  _h,R30
_0x1C:
	LDS  R26,_h
	CPI  R26,LOW(0x78)
	BRSH _0x1D
; 0000 00E9                for (j=0;j<6;j++)
	LDI  R30,LOW(0)
	STS  _j,R30
_0x1F:
	LDS  R26,_j
	CPI  R26,LOW(0x6)
	BRSH _0x20
; 0000 00EA                  alarm[h][j]=0;
	LDS  R30,_h
	LDI  R26,LOW(6)
	MUL  R30,R26
	MOVW R30,R0
	SUBI R30,LOW(-_alarm)
	SBCI R31,HIGH(-_alarm)
	MOVW R26,R30
	CALL SUBOPT_0xE
	ADD  R26,R30
	ADC  R27,R31
	LDI  R30,LOW(0)
	ST   X,R30
	CALL SUBOPT_0xF
	RJMP _0x1F
_0x20:
; 0000 00EB t=i=0;
	LDS  R30,_h
	SUBI R30,-LOW(1)
	STS  _h,R30
	RJMP _0x1C
_0x1D:
	LDI  R30,LOW(0)
	MOV  R10,R30
	STS  _t,R30
; 0000 00EC }
	RET
;
;void erase_alarm()
; 0000 00EF {    if (i==0) lcd_putsf(s7); else{
_erase_alarm:
	TST  R10
	BRNE _0x21
	LDI  R26,LOW(_s7*2)
	LDI  R27,HIGH(_s7*2)
	RJMP _0xAF
_0x21:
; 0000 00F0      lcd_gotoxy(0,0);
	CALL SUBOPT_0x1
; 0000 00F1      lcd_putsf(s9);
	LDI  R26,LOW(_s9*2)
	LDI  R27,HIGH(_s9*2)
	CALL SUBOPT_0x10
; 0000 00F2      lcd_gotoxy(0,1);
; 0000 00F3      lcd_putsf(s10);
	LDI  R26,LOW(_s10*2)
	LDI  R27,HIGH(_s10*2)
_0xAF:
	CALL _lcd_putsf
; 0000 00F4      }
; 0000 00F5 }
	RET
;
;void set_date()
; 0000 00F8 {
_set_date:
; 0000 00F9 
; 0000 00FA lcd_gotoxy(0,0);
	CALL SUBOPT_0x1
; 0000 00FB lcd_putsf(s4);
	LDI  R26,LOW(_s4*2)
	LDI  R27,HIGH(_s4*2)
	CALL SUBOPT_0x10
; 0000 00FC lcd_gotoxy(0,1);
; 0000 00FD lcd_putchar(day/10+0x30);
	MOV  R26,R6
	CALL SUBOPT_0x3
; 0000 00FE lcd_putchar(day%10+0x30);
	MOV  R26,R6
	CALL SUBOPT_0x4
; 0000 00FF lcd_putchar('-');
	LDI  R26,LOW(45)
	CALL _lcd_putchar
; 0000 0100 lcd_putchar(month/10+0x30);
	MOV  R26,R9
	CALL SUBOPT_0x3
; 0000 0101 lcd_putchar(month%10+0x30);
	MOV  R26,R9
	CALL SUBOPT_0x4
; 0000 0102 lcd_putchar('-');
	LDI  R26,LOW(45)
	CALL _lcd_putchar
; 0000 0103 lcd_putchar(year/10+0x30);
	MOV  R26,R8
	CALL SUBOPT_0x3
; 0000 0104 lcd_putchar(year%10+0x30);
	MOV  R26,R8
	CALL SUBOPT_0x4
; 0000 0105 
; 0000 0106 }
	RET
;
;void set_time()
; 0000 0109 {
_set_time:
; 0000 010A lcd_gotoxy(0,0);
	CALL SUBOPT_0x1
; 0000 010B lcd_putsf(s5);
	LDI  R26,LOW(_s5*2)
	LDI  R27,HIGH(_s5*2)
	CALL SUBOPT_0x10
; 0000 010C lcd_gotoxy(0,1);
; 0000 010D 
; 0000 010E lcd_putchar(hour/10+0x30);
	CALL SUBOPT_0x2
; 0000 010F lcd_putchar(hour%10+0x30);
; 0000 0110 lcd_putchar(':');
; 0000 0111 lcd_putchar(min/10+0x30);
; 0000 0112 lcd_putchar(min%10+0x30);
; 0000 0113 lcd_putsf(s11);
	RJMP _0x20C0005
; 0000 0114 }
;
;void clear()
; 0000 0117 {
_clear:
; 0000 0118 lcd_gotoxy(0,1);
	CALL SUBOPT_0x6
; 0000 0119 lcd_putsf(s11);
_0x20C0005:
	LDI  R26,LOW(_s11*2)
	LDI  R27,HIGH(_s11*2)
	CALL _lcd_putsf
; 0000 011A }
	RET
;
;void dec2bin(char n)
; 0000 011D {
_dec2bin:
; 0000 011E if (0 == n) {
	ST   -Y,R26
;	n -> Y+0
	LD   R30,Y
	CPI  R30,0
	BREQ _0x20C0004
; 0000 011F return;
; 0000 0120 } else {
; 0000 0121 
; 0000 0122 if (n%2) lcd_putchar('1'); else lcd_putchar('0');
	LD   R26,Y
	CLR  R27
	LDI  R30,LOW(2)
	LDI  R31,HIGH(2)
	CALL __MODW21
	SBIW R30,0
	BREQ _0x25
	LDI  R26,LOW(49)
	RJMP _0xB0
_0x25:
	LDI  R26,LOW(48)
_0xB0:
	CALL _lcd_putchar
; 0000 0123 dec2bin(n/2);
	LD   R26,Y
	LDI  R27,0
	LDI  R30,LOW(2)
	LDI  R31,HIGH(2)
	CALL __DIVW21
	MOV  R26,R30
	RCALL _dec2bin
; 0000 0124 
; 0000 0125 }
; 0000 0126 }
_0x20C0004:
	ADIW R28,1
	RET
;
;//     
;void fDisplayMenu(unsigned int countmenu)
; 0000 012A {
_fDisplayMenu:
; 0000 012B 
; 0000 012C         switch(countmenu)
	ST   -Y,R27
	ST   -Y,R26
;	countmenu -> Y+0
	LD   R30,Y
	LDD  R31,Y+1
; 0000 012D         {// 
; 0000 012E         {
; 0000 012F                 case 0: count=7; break;
	SBIW R30,0
	BRNE _0x2A
	LDI  R30,LOW(7)
	LDI  R31,HIGH(7)
	MOVW R12,R30
	RJMP _0x29
; 0000 0130                 case 1:{
_0x2A:
	CPI  R30,LOW(0x1)
	LDI  R26,HIGH(0x1)
	CPC  R31,R26
	BRNE _0x2B
; 0000 0131                 j=1;
	LDI  R30,LOW(1)
	STS  _j,R30
; 0000 0132                 lcd_putsf(s1);
	LDI  R26,LOW(_s1*2)
	LDI  R27,HIGH(_s1*2)
	CALL SUBOPT_0x11
; 0000 0133                 clear();
; 0000 0134                 break; //set alarm
	RJMP _0x29
; 0000 0135                 }
; 0000 0136                 case 2: {
_0x2B:
	CPI  R30,LOW(0x2)
	LDI  R26,HIGH(0x2)
	CPC  R31,R26
	BRNE _0x2C
; 0000 0137                 lcd_putsf(s2);
	LDI  R26,LOW(_s2*2)
	LDI  R27,HIGH(_s2*2)
	CALL SUBOPT_0x11
; 0000 0138                 clear();
; 0000 0139                 break; //show alarm
	RJMP _0x29
; 0000 013A                 }
; 0000 013B                 case 3:  {
_0x2C:
	CPI  R30,LOW(0x3)
	LDI  R26,HIGH(0x3)
	CPC  R31,R26
	BRNE _0x2D
; 0000 013C                 lcd_putsf(s3);
	LDI  R26,LOW(_s3*2)
	LDI  R27,HIGH(_s3*2)
	CALL SUBOPT_0x11
; 0000 013D                 clear();
; 0000 013E                 break; //erase alarm
	RJMP _0x29
; 0000 013F                 }
; 0000 0140                 case 4: set_date(); break; //set date
_0x2D:
	CPI  R30,LOW(0x4)
	LDI  R26,HIGH(0x4)
	CPC  R31,R26
	BRNE _0x2E
	RCALL _set_date
	RJMP _0x29
; 0000 0141                 case 5: set_time(); break; //set time
_0x2E:
	CPI  R30,LOW(0x5)
	LDI  R26,HIGH(0x5)
	CPC  R31,R26
	BRNE _0x2F
	RCALL _set_time
	RJMP _0x29
; 0000 0142 
; 0000 0143                 case 6:{
_0x2F:
	CPI  R30,LOW(0x6)
	LDI  R26,HIGH(0x6)
	CPC  R31,R26
	BRNE _0x30
; 0000 0144                 j=1;
	LDI  R30,LOW(1)
	STS  _j,R30
; 0000 0145                 lcd_putsf(s041);
	LDI  R26,LOW(_s041*2)
	LDI  R27,HIGH(_s041*2)
	CALL SUBOPT_0x11
; 0000 0146                 clear();
; 0000 0147                 break; //set out  1
	RJMP _0x29
; 0000 0148                 }
; 0000 0149 
; 0000 014A                 case 7:{
_0x30:
	CPI  R30,LOW(0x7)
	LDI  R26,HIGH(0x7)
	CPC  R31,R26
	BRNE _0x31
; 0000 014B                 j=1;
	LDI  R30,LOW(1)
	STS  _j,R30
; 0000 014C                 lcd_putsf(s042);
	LDI  R26,LOW(_s042*2)
	LDI  R27,HIGH(_s042*2)
	CALL SUBOPT_0x11
; 0000 014D                 clear();
; 0000 014E                 break; //set out 2
	RJMP _0x29
; 0000 014F                 }
; 0000 0150 
; 0000 0151                 case 8: count=1; break;
_0x31:
	CPI  R30,LOW(0x8)
	LDI  R26,HIGH(0x8)
	CPC  R31,R26
	BRNE _0x32
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	MOVW R12,R30
	RJMP _0x29
; 0000 0152 
; 0000 0153         }
; 0000 0154 
; 0000 0155         //  
; 0000 0156         {
; 0000 0157         case 9:
_0x32:
	CPI  R30,LOW(0x9)
	LDI  R26,HIGH(0x9)
	CPC  R31,R26
	BRNE _0x33
; 0000 0158         {
; 0000 0159          count=10;
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL SUBOPT_0x12
; 0000 015A          if (j>1) j--;
	BRLO _0x34
	CALL SUBOPT_0x13
; 0000 015B          break;
_0x34:
	RJMP _0x29
; 0000 015C         }
; 0000 015D 
; 0000 015E 
; 0000 015F         case 10:
_0x33:
	CPI  R30,LOW(0xA)
	LDI  R26,HIGH(0xA)
	CPC  R31,R26
	BRNE _0x35
; 0000 0160         {
; 0000 0161         lcd_putsf(s12);
	CALL SUBOPT_0x14
; 0000 0162         lcd_putchar(j+0x30);
; 0000 0163         if ((~(set) & mask_bit_int[j-1])>0) lcd_putsf(s13); else lcd_putsf(s14);
	CALL SUBOPT_0x15
	CALL SUBOPT_0x16
	BRSH _0x36
	LDI  R26,LOW(_s13*2)
	LDI  R27,HIGH(_s13*2)
	RJMP _0xB1
_0x36:
	LDI  R26,LOW(_s14*2)
	LDI  R27,HIGH(_s14*2)
_0xB1:
	CALL _lcd_putsf
; 0000 0164         break;
	RJMP _0x29
; 0000 0165         }
; 0000 0166 
; 0000 0167         case 100:
_0x35:
	CPI  R30,LOW(0x64)
	LDI  R26,HIGH(0x64)
	CPC  R31,R26
	BRNE _0x38
; 0000 0168         {
; 0000 0169          count=10;
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	MOVW R12,R30
; 0000 016A          if ((~(set) & mask_bit_int[j-1])>0) set=set | mask_bit_int[j-1]; else set=set & ~(mask_bit_int[j-1]);
	CALL SUBOPT_0x15
	CALL SUBOPT_0x16
	BRSH _0x39
	CALL SUBOPT_0xE
	CALL SUBOPT_0x17
	CALL SUBOPT_0x18
	OR   R30,R26
	OR   R31,R27
	RJMP _0xB2
_0x39:
	CALL SUBOPT_0xE
	CALL SUBOPT_0x17
	COM  R30
	COM  R31
	CALL SUBOPT_0x18
	AND  R30,R26
	AND  R31,R27
_0xB2:
	STS  _set,R30
	STS  _set+1,R31
; 0000 016B          break;
	RJMP _0x29
; 0000 016C         }
; 0000 016D 
; 0000 016E         case 11:
_0x38:
	CPI  R30,LOW(0xB)
	LDI  R26,HIGH(0xB)
	CPC  R31,R26
	BRNE _0x3B
; 0000 016F         {
; 0000 0170         count=10;
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL SUBOPT_0x19
; 0000 0171         if (j<8) j++;
	BRSH _0x3C
	CALL SUBOPT_0xF
; 0000 0172         break;
_0x3C:
	RJMP _0x29
; 0000 0173         }
; 0000 0174 
; 0000 0175 
; 0000 0176         }
; 0000 0177 
; 0000 0178         // 
; 0000 0179         {
; 0000 017A                 case 19:
_0x3B:
	CPI  R30,LOW(0x13)
	LDI  R26,HIGH(0x13)
	CPC  R31,R26
	BRNE _0x3D
; 0000 017B                 {
; 0000 017C                 count=20;
	LDI  R30,LOW(20)
	LDI  R31,HIGH(20)
	MOVW R12,R30
; 0000 017D                 if (t>1) t--;
	LDS  R26,_t
	CPI  R26,LOW(0x2)
	BRLO _0x3E
	LDS  R30,_t
	SUBI R30,LOW(1)
	STS  _t,R30
; 0000 017E                 break;
_0x3E:
	RJMP _0x29
; 0000 017F                 }
; 0000 0180 
; 0000 0181                 case 20:
_0x3D:
	CPI  R30,LOW(0x14)
	LDI  R26,HIGH(0x14)
	CPC  R31,R26
	BRNE _0x3F
; 0000 0182                 {
; 0000 0183                 show_alarm();
	RCALL _show_alarm
; 0000 0184                 break;
	RJMP _0x29
; 0000 0185                 }
; 0000 0186 
; 0000 0187                 case 200: count=20; break;
_0x3F:
	CPI  R30,LOW(0xC8)
	LDI  R26,HIGH(0xC8)
	CPC  R31,R26
	BRNE _0x40
	LDI  R30,LOW(20)
	LDI  R31,HIGH(20)
	MOVW R12,R30
	RJMP _0x29
; 0000 0188 
; 0000 0189                 case 21:
_0x40:
	CPI  R30,LOW(0x15)
	LDI  R26,HIGH(0x15)
	CPC  R31,R26
	BRNE _0x41
; 0000 018A                 {
; 0000 018B                 count=20;
	LDI  R30,LOW(20)
	LDI  R31,HIGH(20)
	MOVW R12,R30
; 0000 018C                 if (t<i) t++;
	LDS  R26,_t
	CP   R26,R10
	BRSH _0x42
	LDS  R30,_t
	SUBI R30,-LOW(1)
	STS  _t,R30
; 0000 018D                 break;
_0x42:
	RJMP _0x29
; 0000 018E                 }
; 0000 018F                 }
; 0000 0190 
; 0000 0191         // 
; 0000 0192         {
; 0000 0193                 case 29:
_0x41:
	CPI  R30,LOW(0x1D)
	LDI  R26,HIGH(0x1D)
	CPC  R31,R26
	BRNE _0x43
; 0000 0194                 {
; 0000 0195                  erase_mas();
	RCALL _erase_mas
; 0000 0196                  lcd_clear();
	CALL _lcd_clear
; 0000 0197                  count=30;
	LDI  R30,LOW(30)
	LDI  R31,HIGH(30)
	MOVW R12,R30
; 0000 0198                  break;
	RJMP _0x29
; 0000 0199                 }
; 0000 019A 
; 0000 019B                 case 30: erase_alarm(); break;
_0x43:
	CPI  R30,LOW(0x1E)
	LDI  R26,HIGH(0x1E)
	CPC  R31,R26
	BRNE _0x44
	RCALL _erase_alarm
	RJMP _0x29
; 0000 019C 
; 0000 019D                 case 31:
_0x44:
	CPI  R30,LOW(0x1F)
	LDI  R26,HIGH(0x1F)
	CPC  R31,R26
	BRNE _0x45
; 0000 019E                 {
; 0000 019F                  lcd_clear();
	CALL _lcd_clear
; 0000 01A0                  count=3;
	LDI  R30,LOW(3)
	LDI  R31,HIGH(3)
	MOVW R12,R30
; 0000 01A1                  break;
	RJMP _0x29
; 0000 01A2                 }
; 0000 01A3                 }
; 0000 01A4 
; 0000 01A5         //  
; 0000 01A6         {
; 0000 01A7                 //
; 0000 01A8 
; 0000 01A9                 case 39: // 
_0x45:
	CPI  R30,LOW(0x27)
	LDI  R26,HIGH(0x27)
	CPC  R31,R26
	BRNE _0x46
; 0000 01AA                 {
; 0000 01AB                 count=40;
	LDI  R30,LOW(40)
	LDI  R31,HIGH(40)
	MOVW R12,R30
; 0000 01AC                 if (day>1) day--; else day=31;
	LDI  R30,LOW(1)
	CP   R30,R6
	BRSH _0x47
	DEC  R6
	RJMP _0x48
_0x47:
	LDI  R30,LOW(31)
	MOV  R6,R30
; 0000 01AD                 break;
_0x48:
	RJMP _0x29
; 0000 01AE                 }
; 0000 01AF 
; 0000 01B0                 case 40: {   // 
_0x46:
	CPI  R30,LOW(0x28)
	LDI  R26,HIGH(0x28)
	CPC  R31,R26
	BRNE _0x49
; 0000 01B1                 set_date();
	CALL SUBOPT_0x1A
; 0000 01B2                 _lcd_write_data(0xe);
; 0000 01B3                 lcd_gotoxy(1,1);
	CALL SUBOPT_0x1B
; 0000 01B4                 break;
	RJMP _0x29
; 0000 01B5                 }
; 0000 01B6 
; 0000 01B7                 case 41:     // 
_0x49:
	CPI  R30,LOW(0x29)
	LDI  R26,HIGH(0x29)
	CPC  R31,R26
	BRNE _0x4A
; 0000 01B8                 {
; 0000 01B9                 count=40;
	LDI  R30,LOW(40)
	LDI  R31,HIGH(40)
	MOVW R12,R30
; 0000 01BA                 if (day<31) day++; else day=1;
	LDI  R30,LOW(31)
	CP   R6,R30
	BRSH _0x4B
	INC  R6
	RJMP _0x4C
_0x4B:
	LDI  R30,LOW(1)
	MOV  R6,R30
; 0000 01BB                 break;
_0x4C:
	RJMP _0x29
; 0000 01BC                 }
; 0000 01BD 
; 0000 01BE 
; 0000 01BF                 //
; 0000 01C0 
; 0000 01C1 
; 0000 01C2                 case 399: // 
_0x4A:
	CPI  R30,LOW(0x18F)
	LDI  R26,HIGH(0x18F)
	CPC  R31,R26
	BRNE _0x4D
; 0000 01C3                 {
; 0000 01C4                 count=400;
	LDI  R30,LOW(400)
	LDI  R31,HIGH(400)
	MOVW R12,R30
; 0000 01C5                 if (month>1) month--; else month=12;
	LDI  R30,LOW(1)
	CP   R30,R9
	BRSH _0x4E
	DEC  R9
	RJMP _0x4F
_0x4E:
	LDI  R30,LOW(12)
	MOV  R9,R30
; 0000 01C6                 break;
_0x4F:
	RJMP _0x29
; 0000 01C7                 }
; 0000 01C8 
; 0000 01C9                 case 400: {
_0x4D:
	CPI  R30,LOW(0x190)
	LDI  R26,HIGH(0x190)
	CPC  R31,R26
	BRNE _0x50
; 0000 01CA                 set_date();
	CALL SUBOPT_0x1A
; 0000 01CB                 _lcd_write_data(0xe);
; 0000 01CC                 lcd_gotoxy(4,1);
	LDI  R30,LOW(4)
	CALL SUBOPT_0x1C
; 0000 01CD                 break;
	RJMP _0x29
; 0000 01CE                 }
; 0000 01CF 
; 0000 01D0                 case 401: // 
_0x50:
	CPI  R30,LOW(0x191)
	LDI  R26,HIGH(0x191)
	CPC  R31,R26
	BRNE _0x51
; 0000 01D1                 {
; 0000 01D2                 count=400;
	LDI  R30,LOW(400)
	LDI  R31,HIGH(400)
	MOVW R12,R30
; 0000 01D3                 if (month<12) month++; else month=1;
	LDI  R30,LOW(12)
	CP   R9,R30
	BRSH _0x52
	INC  R9
	RJMP _0x53
_0x52:
	LDI  R30,LOW(1)
	MOV  R9,R30
; 0000 01D4                 break;
_0x53:
	RJMP _0x29
; 0000 01D5                 }
; 0000 01D6 
; 0000 01D7 
; 0000 01D8                 //
; 0000 01D9 
; 0000 01DA                 case 3999: // 
_0x51:
	CPI  R30,LOW(0xF9F)
	LDI  R26,HIGH(0xF9F)
	CPC  R31,R26
	BRNE _0x54
; 0000 01DB                 {
; 0000 01DC                 count=4000;
	LDI  R30,LOW(4000)
	LDI  R31,HIGH(4000)
	MOVW R12,R30
; 0000 01DD                 if (year>0) year--;
	LDI  R30,LOW(0)
	CP   R30,R8
	BRSH _0x55
	DEC  R8
; 0000 01DE                 break;
_0x55:
	RJMP _0x29
; 0000 01DF                 }
; 0000 01E0 
; 0000 01E1                 case 4000: {
_0x54:
	CPI  R30,LOW(0xFA0)
	LDI  R26,HIGH(0xFA0)
	CPC  R31,R26
	BRNE _0x56
; 0000 01E2                 set_date();
	CALL SUBOPT_0x1A
; 0000 01E3                 _lcd_write_data(0xe);
; 0000 01E4                 lcd_gotoxy(7,1);
	LDI  R30,LOW(7)
	CALL SUBOPT_0x1C
; 0000 01E5                 break;
	RJMP _0x29
; 0000 01E6                 }
; 0000 01E7 
; 0000 01E8                 case 4001: // 
_0x56:
	CPI  R30,LOW(0xFA1)
	LDI  R26,HIGH(0xFA1)
	CPC  R31,R26
	BRNE _0x57
; 0000 01E9                 {
; 0000 01EA                 count=4000;
	LDI  R30,LOW(4000)
	LDI  R31,HIGH(4000)
	MOVW R12,R30
; 0000 01EB                 if (year<99) year++;
	LDI  R30,LOW(99)
	CP   R8,R30
	BRSH _0x58
	INC  R8
; 0000 01EC                 break;
_0x58:
	RJMP _0x29
; 0000 01ED                 }
; 0000 01EE 
; 0000 01EF 
; 0000 01F0                 case 40000:   // 
_0x57:
	CPI  R30,LOW(0x9C40)
	LDI  R26,HIGH(0x9C40)
	CPC  R31,R26
	BRNE _0x59
; 0000 01F1                 {
; 0000 01F2                 count=4;
	LDI  R30,LOW(4)
	LDI  R31,HIGH(4)
	MOVW R12,R30
; 0000 01F3                 rtc_set_date(week_day,day,month,year);
	ST   -Y,R11
	ST   -Y,R6
	ST   -Y,R9
	MOV  R26,R8
	CALL _rtc_set_date
; 0000 01F4                 break;
	RJMP _0x29
; 0000 01F5                 }
; 0000 01F6                 }
; 0000 01F7 
; 0000 01F8         //  
; 0000 01F9         {
; 0000 01FA                 case 49: // 
_0x59:
	CPI  R30,LOW(0x31)
	LDI  R26,HIGH(0x31)
	CPC  R31,R26
	BRNE _0x5A
; 0000 01FB                 {
; 0000 01FC                 count=50;
	LDI  R30,LOW(50)
	LDI  R31,HIGH(50)
	MOVW R12,R30
; 0000 01FD                 if (hour>0) hour--; else hour=23;
	LDI  R30,LOW(0)
	CP   R30,R5
	BRSH _0x5B
	DEC  R5
	RJMP _0x5C
_0x5B:
	LDI  R30,LOW(23)
	MOV  R5,R30
; 0000 01FE                 break;
_0x5C:
	RJMP _0x29
; 0000 01FF                 }
; 0000 0200 
; 0000 0201                 case 50: {   // 
_0x5A:
	CPI  R30,LOW(0x32)
	LDI  R26,HIGH(0x32)
	CPC  R31,R26
	BRNE _0x5D
; 0000 0202                 set_time();
	RCALL _set_time
; 0000 0203                 lcd_gotoxy(1,1);
	CALL SUBOPT_0x1B
; 0000 0204                 _lcd_write_data(0xe);
	LDI  R26,LOW(14)
	CALL __lcd_write_data
; 0000 0205                 break;
	RJMP _0x29
; 0000 0206                 }
; 0000 0207 
; 0000 0208                 case 51: // 
_0x5D:
	CPI  R30,LOW(0x33)
	LDI  R26,HIGH(0x33)
	CPC  R31,R26
	BRNE _0x5E
; 0000 0209                 {
; 0000 020A                 count=50;
	LDI  R30,LOW(50)
	LDI  R31,HIGH(50)
	MOVW R12,R30
; 0000 020B                 if (hour<23) hour++; else hour=0;
	LDI  R30,LOW(23)
	CP   R5,R30
	BRSH _0x5F
	INC  R5
	RJMP _0x60
_0x5F:
	CLR  R5
; 0000 020C                 break;
_0x60:
	RJMP _0x29
; 0000 020D                 }
; 0000 020E 
; 0000 020F                 case 499: // 
_0x5E:
	CPI  R30,LOW(0x1F3)
	LDI  R26,HIGH(0x1F3)
	CPC  R31,R26
	BRNE _0x61
; 0000 0210                 {
; 0000 0211                 count=500;
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	MOVW R12,R30
; 0000 0212                 if (min>0) min--; else min=59;
	LDI  R30,LOW(0)
	CP   R30,R4
	BRSH _0x62
	DEC  R4
	RJMP _0x63
_0x62:
	LDI  R30,LOW(59)
	MOV  R4,R30
; 0000 0213                 break;
_0x63:
	RJMP _0x29
; 0000 0214                 }
; 0000 0215 
; 0000 0216                 case 500: {   // 
_0x61:
	CPI  R30,LOW(0x1F4)
	LDI  R26,HIGH(0x1F4)
	CPC  R31,R26
	BRNE _0x64
; 0000 0217                 set_time();
	RCALL _set_time
; 0000 0218                 _lcd_write_data(0xe);
	LDI  R26,LOW(14)
	CALL __lcd_write_data
; 0000 0219                 lcd_gotoxy(4,1);
	LDI  R30,LOW(4)
	CALL SUBOPT_0x1C
; 0000 021A                 break;
	RJMP _0x29
; 0000 021B                 }
; 0000 021C 
; 0000 021D                 case 501: // 
_0x64:
	CPI  R30,LOW(0x1F5)
	LDI  R26,HIGH(0x1F5)
	CPC  R31,R26
	BRNE _0x65
; 0000 021E                 {
; 0000 021F                 count=500;
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	MOVW R12,R30
; 0000 0220                 if (min<59) min++; else min=0;
	LDI  R30,LOW(59)
	CP   R4,R30
	BRSH _0x66
	INC  R4
	RJMP _0x67
_0x66:
	CLR  R4
; 0000 0221                 break;
_0x67:
	RJMP _0x29
; 0000 0222                 }
; 0000 0223 
; 0000 0224                 case 5000:   // 
_0x65:
	CPI  R30,LOW(0x1388)
	LDI  R26,HIGH(0x1388)
	CPC  R31,R26
	BRNE _0x68
; 0000 0225                 {
; 0000 0226                 count=5;
	LDI  R30,LOW(5)
	LDI  R31,HIGH(5)
	MOVW R12,R30
; 0000 0227                 rtc_set_time(hour,min,0);
	ST   -Y,R5
	ST   -Y,R4
	LDI  R26,LOW(0)
	CALL _rtc_set_time
; 0000 0228 
; 0000 0229                 break;
	RJMP _0x29
; 0000 022A                 }
; 0000 022B 
; 0000 022C                 }
; 0000 022D 
; 0000 022E         //1
; 0000 022F         {
; 0000 0230 
; 0000 0231         case 59:
_0x68:
	CPI  R30,LOW(0x3B)
	LDI  R26,HIGH(0x3B)
	CPC  R31,R26
	BRNE _0x69
; 0000 0232         {
; 0000 0233          count=60;
	LDI  R30,LOW(60)
	LDI  R31,HIGH(60)
	CALL SUBOPT_0x12
; 0000 0234          if (j>1) j--;
	BRLO _0x6A
	CALL SUBOPT_0x13
; 0000 0235          break;
_0x6A:
	RJMP _0x29
; 0000 0236         }
; 0000 0237 
; 0000 0238 
; 0000 0239         case 60:
_0x69:
	CPI  R30,LOW(0x3C)
	LDI  R26,HIGH(0x3C)
	CPC  R31,R26
	BRNE _0x6B
; 0000 023A         {
; 0000 023B         lcd_putsf(s12);
	CALL SUBOPT_0x14
; 0000 023C         lcd_putchar(j+0x30);
; 0000 023D         if ((~(out1) & mask_bit_int[j-1])>0) lcd_putsf(s13); else lcd_putsf(s14);
	CALL SUBOPT_0x1D
	CALL SUBOPT_0x16
	BRSH _0x6C
	LDI  R26,LOW(_s13*2)
	LDI  R27,HIGH(_s13*2)
	RJMP _0xB3
_0x6C:
	LDI  R26,LOW(_s14*2)
	LDI  R27,HIGH(_s14*2)
_0xB3:
	CALL _lcd_putsf
; 0000 023E         break;
	RJMP _0x29
; 0000 023F         }
; 0000 0240 
; 0000 0241         case 600:
_0x6B:
	CPI  R30,LOW(0x258)
	LDI  R26,HIGH(0x258)
	CPC  R31,R26
	BRNE _0x6E
; 0000 0242         {
; 0000 0243          count=60;
	LDI  R30,LOW(60)
	LDI  R31,HIGH(60)
	MOVW R12,R30
; 0000 0244          if ((~(out1) & mask_bit_int[j-1])>0) out1=out1 | mask_bit_int[j-1]; else out1=out1 & ~(mask_bit_int[j-1]);
	CALL SUBOPT_0x1D
	CALL SUBOPT_0x16
	BRSH _0x6F
	CALL SUBOPT_0xE
	CALL SUBOPT_0x17
	CALL SUBOPT_0x1E
	OR   R30,R26
	OR   R31,R27
	RJMP _0xB4
_0x6F:
	CALL SUBOPT_0xE
	CALL SUBOPT_0x17
	COM  R30
	COM  R31
	CALL SUBOPT_0x1E
	AND  R30,R26
	AND  R31,R27
_0xB4:
	STS  _out1,R30
	STS  _out1+1,R31
; 0000 0245          break;
	RJMP _0x29
; 0000 0246         }
; 0000 0247 
; 0000 0248         case 61:
_0x6E:
	CPI  R30,LOW(0x3D)
	LDI  R26,HIGH(0x3D)
	CPC  R31,R26
	BRNE _0x71
; 0000 0249         {
; 0000 024A         count=60;
	LDI  R30,LOW(60)
	LDI  R31,HIGH(60)
	CALL SUBOPT_0x19
; 0000 024B         if (j<8) j++; else count=63;
	BRSH _0x72
	CALL SUBOPT_0xF
	RJMP _0x73
_0x72:
	LDI  R30,LOW(63)
	LDI  R31,HIGH(63)
	MOVW R12,R30
; 0000 024C         break;
_0x73:
	RJMP _0x29
; 0000 024D         }
; 0000 024E 
; 0000 024F         //  1
; 0000 0250         {
; 0000 0251         case 62:
_0x71:
	CPI  R30,LOW(0x3E)
	LDI  R26,HIGH(0x3E)
	CPC  R31,R26
	BRNE _0x74
; 0000 0252         {
; 0000 0253         count=60;
	LDI  R30,LOW(60)
	LDI  R31,HIGH(60)
	MOVW R12,R30
; 0000 0254         clear();
	RCALL _clear
; 0000 0255         break;
	RJMP _0x29
; 0000 0256         }
; 0000 0257 
; 0000 0258 
; 0000 0259         case 63:
_0x74:
	CPI  R30,LOW(0x3F)
	LDI  R26,HIGH(0x3F)
	CPC  R31,R26
	BRNE _0x75
; 0000 025A         {
; 0000 025B         lcd_putsf(s05);
	CALL SUBOPT_0x1F
; 0000 025C         lcd_gotoxy(0,1);
; 0000 025D         lcd_putchar(dur1/10+0x30);
	LDS  R26,_dur1
	CALL SUBOPT_0x3
; 0000 025E         lcd_putchar(dur1%10+0x30);
	LDS  R26,_dur1
	CALL SUBOPT_0x4
; 0000 025F         break;
	RJMP _0x29
; 0000 0260         }
; 0000 0261 
; 0000 0262         case 64:
_0x75:
	CPI  R30,LOW(0x40)
	LDI  R26,HIGH(0x40)
	CPC  R31,R26
	BRNE _0x76
; 0000 0263         {
; 0000 0264         count=63;
	LDI  R30,LOW(63)
	LDI  R31,HIGH(63)
	MOVW R12,R30
; 0000 0265         break;
	RJMP _0x29
; 0000 0266         }
; 0000 0267 
; 0000 0268         case 629:
_0x76:
	CPI  R30,LOW(0x275)
	LDI  R26,HIGH(0x275)
	CPC  R31,R26
	BRNE _0x77
; 0000 0269         {
; 0000 026A         if (dur1>1) dur1--; else dur1=90;
	LDS  R26,_dur1
	CPI  R26,LOW(0x2)
	BRLO _0x78
	LDS  R30,_dur1
	SUBI R30,LOW(1)
	RJMP _0xB5
_0x78:
	LDI  R30,LOW(90)
_0xB5:
	STS  _dur1,R30
; 0000 026B         count=630;
	LDI  R30,LOW(630)
	LDI  R31,HIGH(630)
	MOVW R12,R30
; 0000 026C         break;
	RJMP _0x29
; 0000 026D         }
; 0000 026E 
; 0000 026F         case 630:
_0x77:
	CPI  R30,LOW(0x276)
	LDI  R26,HIGH(0x276)
	CPC  R31,R26
	BRNE _0x7A
; 0000 0270         {
; 0000 0271         lcd_putsf(s05);
	CALL SUBOPT_0x1F
; 0000 0272         lcd_gotoxy(0,1);
; 0000 0273         lcd_putchar(dur1/10+0x30);
	LDS  R26,_dur1
	CALL SUBOPT_0x3
; 0000 0274         lcd_putchar(dur1%10+0x30);
	LDS  R26,_dur1
	CALL SUBOPT_0x4
; 0000 0275         lcd_gotoxy(1,1);
	CALL SUBOPT_0x1B
; 0000 0276         _lcd_write_data(0xe);
	LDI  R26,LOW(14)
	CALL __lcd_write_data
; 0000 0277         break;
	RJMP _0x29
; 0000 0278         }
; 0000 0279 
; 0000 027A         case 6300:
_0x7A:
	CPI  R30,LOW(0x189C)
	LDI  R26,HIGH(0x189C)
	CPC  R31,R26
	BRNE _0x7B
; 0000 027B         {
; 0000 027C         count=63;
	LDI  R30,LOW(63)
	LDI  R31,HIGH(63)
	MOVW R12,R30
; 0000 027D         break;
	RJMP _0x29
; 0000 027E         }
; 0000 027F 
; 0000 0280         case 631:
_0x7B:
	CPI  R30,LOW(0x277)
	LDI  R26,HIGH(0x277)
	CPC  R31,R26
	BRNE _0x7C
; 0000 0281         {
; 0000 0282         if (dur1<90) dur1++; else dur1=1;
	LDS  R26,_dur1
	CPI  R26,LOW(0x5A)
	BRSH _0x7D
	LDS  R30,_dur1
	SUBI R30,-LOW(1)
	RJMP _0xB6
_0x7D:
	LDI  R30,LOW(1)
_0xB6:
	STS  _dur1,R30
; 0000 0283         count=630;
	LDI  R30,LOW(630)
	LDI  R31,HIGH(630)
	MOVW R12,R30
; 0000 0284         break;
	RJMP _0x29
; 0000 0285         }
; 0000 0286 
; 0000 0287         }
; 0000 0288         }
; 0000 0289 
; 0000 028A         //2
; 0000 028B         {
; 0000 028C 
; 0000 028D         case 69:
_0x7C:
	CPI  R30,LOW(0x45)
	LDI  R26,HIGH(0x45)
	CPC  R31,R26
	BRNE _0x7F
; 0000 028E         {
; 0000 028F          count=70;
	LDI  R30,LOW(70)
	LDI  R31,HIGH(70)
	CALL SUBOPT_0x12
; 0000 0290          if (j>1) j--;
	BRLO _0x80
	CALL SUBOPT_0x13
; 0000 0291          break;
_0x80:
	RJMP _0x29
; 0000 0292         }
; 0000 0293 
; 0000 0294 
; 0000 0295         case 70:
_0x7F:
	CPI  R30,LOW(0x46)
	LDI  R26,HIGH(0x46)
	CPC  R31,R26
	BRNE _0x81
; 0000 0296         {
; 0000 0297         lcd_putsf(s12);
	CALL SUBOPT_0x14
; 0000 0298         lcd_putchar(j+0x30);
; 0000 0299         if ((~(out2) & mask_bit_int[j-1])>0) lcd_putsf(s13); else lcd_putsf(s14);
	CALL SUBOPT_0x20
	CALL SUBOPT_0x16
	BRSH _0x82
	LDI  R26,LOW(_s13*2)
	LDI  R27,HIGH(_s13*2)
	RJMP _0xB7
_0x82:
	LDI  R26,LOW(_s14*2)
	LDI  R27,HIGH(_s14*2)
_0xB7:
	CALL _lcd_putsf
; 0000 029A         break;
	RJMP _0x29
; 0000 029B         }
; 0000 029C 
; 0000 029D         case 700:
_0x81:
	CPI  R30,LOW(0x2BC)
	LDI  R26,HIGH(0x2BC)
	CPC  R31,R26
	BRNE _0x84
; 0000 029E         {
; 0000 029F          count=70;
	LDI  R30,LOW(70)
	LDI  R31,HIGH(70)
	MOVW R12,R30
; 0000 02A0          if ((~(out2) & mask_bit_int[j-1])>0) out2=out2 | mask_bit_int[j-1]; else out2=out2 & ~(mask_bit_int[j-1]);
	CALL SUBOPT_0x20
	CALL SUBOPT_0x16
	BRSH _0x85
	CALL SUBOPT_0xE
	CALL SUBOPT_0x17
	CALL SUBOPT_0x21
	OR   R30,R26
	OR   R31,R27
	RJMP _0xB8
_0x85:
	CALL SUBOPT_0xE
	CALL SUBOPT_0x17
	COM  R30
	COM  R31
	CALL SUBOPT_0x21
	AND  R30,R26
	AND  R31,R27
_0xB8:
	STS  _out2,R30
	STS  _out2+1,R31
; 0000 02A1          break;
	RJMP _0x29
; 0000 02A2         }
; 0000 02A3 
; 0000 02A4         case 71:
_0x84:
	CPI  R30,LOW(0x47)
	LDI  R26,HIGH(0x47)
	CPC  R31,R26
	BRNE _0x87
; 0000 02A5         {
; 0000 02A6         count=70;
	LDI  R30,LOW(70)
	LDI  R31,HIGH(70)
	CALL SUBOPT_0x19
; 0000 02A7         if (j<8) j++; else count=73;
	BRSH _0x88
	CALL SUBOPT_0xF
	RJMP _0x89
_0x88:
	LDI  R30,LOW(73)
	LDI  R31,HIGH(73)
	MOVW R12,R30
; 0000 02A8         break;
_0x89:
	RJMP _0x29
; 0000 02A9         }
; 0000 02AA 
; 0000 02AB         //  2
; 0000 02AC         {
; 0000 02AD         case 72:
_0x87:
	CPI  R30,LOW(0x48)
	LDI  R26,HIGH(0x48)
	CPC  R31,R26
	BRNE _0x8A
; 0000 02AE         {
; 0000 02AF         count=70;
	LDI  R30,LOW(70)
	LDI  R31,HIGH(70)
	MOVW R12,R30
; 0000 02B0         clear();
	RCALL _clear
; 0000 02B1         break;
	RJMP _0x29
; 0000 02B2         }
; 0000 02B3 
; 0000 02B4 
; 0000 02B5         case 73:
_0x8A:
	CPI  R30,LOW(0x49)
	LDI  R26,HIGH(0x49)
	CPC  R31,R26
	BRNE _0x8B
; 0000 02B6         {
; 0000 02B7         lcd_putsf(s05);
	CALL SUBOPT_0x1F
; 0000 02B8         lcd_gotoxy(0,1);
; 0000 02B9         lcd_putchar(dur2/10+0x30);
	LDS  R26,_dur2
	CALL SUBOPT_0x3
; 0000 02BA         lcd_putchar(dur2%10+0x30);
	LDS  R26,_dur2
	CALL SUBOPT_0x4
; 0000 02BB         break;
	RJMP _0x29
; 0000 02BC         }
; 0000 02BD 
; 0000 02BE         case 74:
_0x8B:
	CPI  R30,LOW(0x4A)
	LDI  R26,HIGH(0x4A)
	CPC  R31,R26
	BRNE _0x8C
; 0000 02BF         {
; 0000 02C0         count=73;
	LDI  R30,LOW(73)
	LDI  R31,HIGH(73)
	MOVW R12,R30
; 0000 02C1         break;
	RJMP _0x29
; 0000 02C2         }
; 0000 02C3 
; 0000 02C4         case 729:
_0x8C:
	CPI  R30,LOW(0x2D9)
	LDI  R26,HIGH(0x2D9)
	CPC  R31,R26
	BRNE _0x8D
; 0000 02C5         {
; 0000 02C6         if (dur2>1) dur2--; else dur2=90;
	LDS  R26,_dur2
	CPI  R26,LOW(0x2)
	BRLO _0x8E
	LDS  R30,_dur2
	SUBI R30,LOW(1)
	RJMP _0xB9
_0x8E:
	LDI  R30,LOW(90)
_0xB9:
	STS  _dur2,R30
; 0000 02C7         count=730;
	LDI  R30,LOW(730)
	LDI  R31,HIGH(730)
	MOVW R12,R30
; 0000 02C8         break;
	RJMP _0x29
; 0000 02C9         }
; 0000 02CA 
; 0000 02CB         case 730:
_0x8D:
	CPI  R30,LOW(0x2DA)
	LDI  R26,HIGH(0x2DA)
	CPC  R31,R26
	BRNE _0x90
; 0000 02CC         {
; 0000 02CD         lcd_putsf(s05);
	CALL SUBOPT_0x1F
; 0000 02CE         lcd_gotoxy(0,1);
; 0000 02CF         lcd_putchar(dur2/10+0x30);
	LDS  R26,_dur2
	CALL SUBOPT_0x3
; 0000 02D0         lcd_putchar(dur2%10+0x30);
	LDS  R26,_dur2
	CALL SUBOPT_0x4
; 0000 02D1         lcd_gotoxy(1,1);
	CALL SUBOPT_0x1B
; 0000 02D2         _lcd_write_data(0xe);
	LDI  R26,LOW(14)
	CALL __lcd_write_data
; 0000 02D3         break;
	RJMP _0x29
; 0000 02D4         }
; 0000 02D5 
; 0000 02D6         case 7300:
_0x90:
	CPI  R30,LOW(0x1C84)
	LDI  R26,HIGH(0x1C84)
	CPC  R31,R26
	BRNE _0x91
; 0000 02D7         {
; 0000 02D8         count=73;
	LDI  R30,LOW(73)
	LDI  R31,HIGH(73)
	MOVW R12,R30
; 0000 02D9         break;
	RJMP _0x29
; 0000 02DA         }
; 0000 02DB 
; 0000 02DC         case 731:
_0x91:
	CPI  R30,LOW(0x2DB)
	LDI  R26,HIGH(0x2DB)
	CPC  R31,R26
	BRNE _0x95
; 0000 02DD         {
; 0000 02DE         if (dur2<90) dur2++; else dur2=1;
	LDS  R26,_dur2
	CPI  R26,LOW(0x5A)
	BRSH _0x93
	LDS  R30,_dur2
	SUBI R30,-LOW(1)
	RJMP _0xBA
_0x93:
	LDI  R30,LOW(1)
_0xBA:
	STS  _dur2,R30
; 0000 02DF         count=730;
	LDI  R30,LOW(730)
	LDI  R31,HIGH(730)
	MOVW R12,R30
; 0000 02E0         break;
; 0000 02E1         }
; 0000 02E2 
; 0000 02E3         }
; 0000 02E4         }
; 0000 02E5 
; 0000 02E6 
; 0000 02E7 
; 0000 02E8 
; 0000 02E9         default:
_0x95:
; 0000 02EA         {
; 0000 02EB         break;
; 0000 02EC         }
; 0000 02ED         }
_0x29:
; 0000 02EE 
; 0000 02EF         delay_ms(70);
	LDI  R26,LOW(70)
	CALL SUBOPT_0x22
; 0000 02F0         _lcd_write_data(0xc);
	LDI  R26,LOW(12)
	CALL __lcd_write_data
; 0000 02F1 }
	JMP  _0x20C0003
;
;void fMenu()
; 0000 02F4 {
_fMenu:
; 0000 02F5 
; 0000 02F6         count=1;
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	MOVW R12,R30
; 0000 02F7         while(1)
_0x96:
; 0000 02F8         {
; 0000 02F9                 lcd_gotoxy(0,0);
	CALL SUBOPT_0x1
; 0000 02FA                 BUT_Debrief();
	CALL SUBOPT_0x23
; 0000 02FB                 l = BUT_GetKey();
; 0000 02FC 
; 0000 02FD                  if (l==1)
	BRNE _0x99
; 0000 02FE                  {
; 0000 02FF                  count*=10;
	MOVW R30,R12
	LDI  R26,LOW(10)
	LDI  R27,HIGH(10)
	CALL __MULW12U
	MOVW R12,R30
; 0000 0300                  }
; 0000 0301 
; 0000 0302                  if (l==2)
_0x99:
	LDS  R26,_l
	CPI  R26,LOW(0x2)
	BRNE _0x9A
; 0000 0303                  {
; 0000 0304                  if(count<10)
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CP   R12,R30
	CPC  R13,R31
	BRLO _0x98
; 0000 0305                                 break;
; 0000 0306                         if(count>=10)
	CP   R12,R30
	CPC  R13,R31
	BRLO _0x9C
; 0000 0307                         {
; 0000 0308                                 count/=10;
	MOVW R26,R12
	CALL __DIVW21U
	MOVW R12,R30
; 0000 0309                         }
; 0000 030A                  }
_0x9C:
; 0000 030B 
; 0000 030C                  if (l==3)
_0x9A:
	LDS  R26,_l
	CPI  R26,LOW(0x3)
	BRNE _0x9D
; 0000 030D                  {
; 0000 030E                  count--;
	MOVW R30,R12
	SBIW R30,1
	MOVW R12,R30
; 0000 030F                  }
; 0000 0310 
; 0000 0311                  if (l==4)
_0x9D:
	LDS  R26,_l
	CPI  R26,LOW(0x4)
	BRNE _0x9E
; 0000 0312                  {
; 0000 0313                  count++;
	MOVW R30,R12
	ADIW R30,1
	MOVW R12,R30
; 0000 0314                  }
; 0000 0315 
; 0000 0316 
; 0000 0317 
; 0000 0318                 //        count
; 0000 0319 
; 0000 031A                 fDisplayMenu(count);
_0x9E:
	MOVW R26,R12
	RCALL _fDisplayMenu
; 0000 031B         };
	RJMP _0x96
_0x98:
; 0000 031C 
; 0000 031D }
	RET
;
;void addalarm()
; 0000 0320 {
_addalarm:
; 0000 0321 rtc_get_time(&hour,&min,&sek);  // 
	CALL SUBOPT_0x0
; 0000 0322 rtc_get_date(&week_day,&day,&month,&year);  // 
; 0000 0323 
; 0000 0324 if (i==N) i=0;
	LDI  R30,LOW(120)
	CP   R30,R10
	BRNE _0x9F
	CLR  R10
; 0000 0325 
; 0000 0326 
; 0000 0327 alarm[i][0]=month;
_0x9F:
	CALL SUBOPT_0x24
	SUBI R30,LOW(-_alarm)
	SBCI R31,HIGH(-_alarm)
	ST   Z,R9
; 0000 0328 alarm[i][1]=day;
	CALL SUBOPT_0x24
	__ADDW1MN _alarm,1
	ST   Z,R6
; 0000 0329 alarm[i][2]=hour;
	CALL SUBOPT_0x24
	__ADDW1MN _alarm,2
	ST   Z,R5
; 0000 032A alarm[i][3]=min;
	CALL SUBOPT_0x24
	__ADDW1MN _alarm,3
	ST   Z,R4
; 0000 032B alarm[i][4]=sek;
	CALL SUBOPT_0x24
	__ADDW1MN _alarm,4
	ST   Z,R7
; 0000 032C alarm[i][5]=input;
	CALL SUBOPT_0x24
	__ADDW1MN _alarm,5
	LDS  R26,_input
	STD  Z+0,R26
; 0000 032D 
; 0000 032E 
; 0000 032F 
; 0000 0330 
; 0000 0331 
; 0000 0332 i++;
	INC  R10
; 0000 0333 t=i;
	STS  _t,R10
; 0000 0334 delay_ms(200);
	LDI  R26,LOW(200)
	CALL SUBOPT_0x22
; 0000 0335 
; 0000 0336 }
	RET
;
;void ChangeAlarm()
; 0000 0339 {
_ChangeAlarm:
; 0000 033A  if (PINA==0XFF) input=0XFF;
	IN   R30,0x19
	CPI  R30,LOW(0xFF)
	BRNE _0xA0
	LDI  R30,LOW(255)
	STS  _input,R30
; 0000 033B  if ((PINA!=input)&&(PINA!=0XFF))
_0xA0:
	IN   R30,0x19
	MOV  R26,R30
	LDS  R30,_input
	CP   R30,R26
	BREQ _0xA2
	IN   R30,0x19
	CPI  R30,LOW(0xFF)
	BRNE _0xA3
_0xA2:
	RJMP _0xA1
_0xA3:
; 0000 033C  {
; 0000 033D   input=PINA;
	IN   R30,0x19
	STS  _input,R30
; 0000 033E 
; 0000 033F   if ((set & ~(input))>0)
	COM  R30
	CALL SUBOPT_0x18
	CALL SUBOPT_0x25
	BRGE _0xA4
; 0000 0340   {
; 0000 0341 
; 0000 0342   addalarm();
	RCALL _addalarm
; 0000 0343 
; 0000 0344    if ((out1 & ~(input))>0)
	LDS  R30,_input
	COM  R30
	CALL SUBOPT_0x1E
	CALL SUBOPT_0x25
	BRGE _0xA5
; 0000 0345    {
; 0000 0346     PORTB |= 1<<3;
	SBI  0x18,3
; 0000 0347     h1=0;
	LDI  R30,LOW(0)
	STS  _h1,R30
; 0000 0348    }
; 0000 0349 
; 0000 034A    if ((out2 & ~(input))>0)
_0xA5:
	LDS  R30,_input
	COM  R30
	CALL SUBOPT_0x21
	CALL SUBOPT_0x25
	BRGE _0xA6
; 0000 034B    {
; 0000 034C     PORTB |= 1<<4;
	SBI  0x18,4
; 0000 034D     h2=0;
	LDI  R30,LOW(0)
	STS  _h2,R30
; 0000 034E    }
; 0000 034F 
; 0000 0350   }
_0xA6:
; 0000 0351 
; 0000 0352 
; 0000 0353  }
_0xA4:
; 0000 0354 
; 0000 0355 if (h1>(dur1-1))
_0xA1:
	LDS  R30,_dur1
	LDI  R31,0
	SBIW R30,1
	LDS  R26,_h1
	LDI  R27,0
	CP   R30,R26
	CPC  R31,R27
	BRGE _0xA7
; 0000 0356   {
; 0000 0357    PORTB &= ~(1<<3);
	CBI  0x18,3
; 0000 0358    h1=0;
	LDI  R30,LOW(0)
	STS  _h1,R30
; 0000 0359   }
; 0000 035A 
; 0000 035B if (h2>(dur2-1))
_0xA7:
	LDS  R30,_dur2
	LDI  R31,0
	SBIW R30,1
	LDS  R26,_h2
	LDI  R27,0
	CP   R30,R26
	CPC  R31,R27
	BRGE _0xA8
; 0000 035C   {
; 0000 035D    PORTB &= ~(1<<4);
	CBI  0x18,4
; 0000 035E    h2=0;
	LDI  R30,LOW(0)
	STS  _h2,R30
; 0000 035F   }
; 0000 0360 
; 0000 0361 }
_0xA8:
	RET
;
;void main(void)
; 0000 0364 {
_main:
; 0000 0365 {
; 0000 0366 delay_ms(80);
	LDI  R26,LOW(80)
	CALL SUBOPT_0x22
; 0000 0367 
; 0000 0368 
; 0000 0369 // Declare your local variables here
; 0000 036A 
; 0000 036B // Input/Output Ports initialization
; 0000 036C // Port A initialization
; 0000 036D // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
; 0000 036E // State7=P State6=P State5=P State4=P State3=P State2=P State1=P State0=P
; 0000 036F PORTA=0xFF;
	LDI  R30,LOW(255)
	OUT  0x1B,R30
; 0000 0370 DDRA=0x00;
	LDI  R30,LOW(0)
	OUT  0x1A,R30
; 0000 0371 
; 0000 0372 // Port B initialization
; 0000 0373 // Func7=Out Func6=Out Func5=Out Func4=Out Func3=Out Func2=In Func1=In Func0=In
; 0000 0374 // State7=0 State6=0 State5=0 State4=0 State3=0 State2=P State1=P State0=P
; 0000 0375 PORTB=0x07;
	LDI  R30,LOW(7)
	OUT  0x18,R30
; 0000 0376 DDRB=0xF8;
	LDI  R30,LOW(248)
	OUT  0x17,R30
; 0000 0377 
; 0000 0378 // Port C initialization
; 0000 0379 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
; 0000 037A // State7=P State6=P State5=P State4=P State3=P State2=P State1=P State0=P
; 0000 037B PORTC=0xFF;
	LDI  R30,LOW(255)
	OUT  0x15,R30
; 0000 037C DDRC=0x00;
	LDI  R30,LOW(0)
	OUT  0x14,R30
; 0000 037D 
; 0000 037E 
; 0000 037F // Port D initialization
; 0000 0380 // Func7=Out Func6=Out Func5=Out Func4=Out Func3=In Func2=Out Func1=Out Func0=Out
; 0000 0381 // State7=0 State6=0 State5=0 State4=0 State3=P State2=0 State1=0 State0=0
; 0000 0382 PORTD=0x08;
	LDI  R30,LOW(8)
	OUT  0x12,R30
; 0000 0383 DDRD=0xF7;
	LDI  R30,LOW(247)
	OUT  0x11,R30
; 0000 0384 
; 0000 0385 // Timer/Counter 0 initialization
; 0000 0386 // Clock source: System Clock
; 0000 0387 // Clock value: Timer 0 Stopped
; 0000 0388 // Mode: Normal top=0xFF
; 0000 0389 // OC0 output: Disconnected
; 0000 038A TCCR0=0x00;
	LDI  R30,LOW(0)
	OUT  0x33,R30
; 0000 038B TCNT0=0xEC;
	LDI  R30,LOW(236)
	OUT  0x32,R30
; 0000 038C OCR0=0x00;
	LDI  R30,LOW(0)
	OUT  0x3C,R30
; 0000 038D 
; 0000 038E // Timer/Counter 1 initialization
; 0000 038F // Clock source: System Clock
; 0000 0390 // Clock value: 125,000 kHz
; 0000 0391 // Mode: Normal top=0xFFFF
; 0000 0392 // OC1A output: Discon.
; 0000 0393 // OC1B output: Discon.
; 0000 0394 // Noise Canceler: Off
; 0000 0395 // Input Capture on Falling Edge
; 0000 0396 // Timer1 Overflow Interrupt: Off
; 0000 0397 // Input Capture Interrupt: Off
; 0000 0398 // Compare A Match Interrupt: On
; 0000 0399 // Compare B Match Interrupt: Off
; 0000 039A TCCR1A=0x00;
	OUT  0x2F,R30
; 0000 039B TCCR1B=0x03;
	LDI  R30,LOW(3)
	OUT  0x2E,R30
; 0000 039C TCNT1H=0x00;
	LDI  R30,LOW(0)
	OUT  0x2D,R30
; 0000 039D TCNT1L=0x00;
	OUT  0x2C,R30
; 0000 039E ICR1H=0x00;
	OUT  0x27,R30
; 0000 039F ICR1L=0x00;
	OUT  0x26,R30
; 0000 03A0 OCR1AH=0x1E;
	LDI  R30,LOW(30)
	OUT  0x2B,R30
; 0000 03A1 OCR1AL=0x85;
	LDI  R30,LOW(133)
	OUT  0x2A,R30
; 0000 03A2 OCR1BH=0x00;
	LDI  R30,LOW(0)
	OUT  0x29,R30
; 0000 03A3 OCR1BL=0x00;
	OUT  0x28,R30
; 0000 03A4 
; 0000 03A5 // Timer/Counter 2 initialization
; 0000 03A6 // Clock source: System Clock
; 0000 03A7 // Clock value: Timer2 Stopped
; 0000 03A8 // Mode: Normal top=0xFF
; 0000 03A9 // OC2 output: Disconnected
; 0000 03AA ASSR=0x00;
	OUT  0x22,R30
; 0000 03AB TCCR2=0x00;
	OUT  0x25,R30
; 0000 03AC TCNT2=0x00;
	OUT  0x24,R30
; 0000 03AD OCR2=0x00;
	OUT  0x23,R30
; 0000 03AE 
; 0000 03AF // External Interrupt(s) initialization
; 0000 03B0 // INT0: Off
; 0000 03B1 // INT1: Off
; 0000 03B2 // INT2: On
; 0000 03B3 // INT2 Mode: Falling Edge
; 0000 03B4 GICR|=0x20;
	IN   R30,0x3B
	ORI  R30,0x20
	OUT  0x3B,R30
; 0000 03B5 MCUCR=0x00;
	LDI  R30,LOW(0)
	OUT  0x35,R30
; 0000 03B6 MCUCSR=0x00;
	OUT  0x34,R30
; 0000 03B7 GIFR=0x20;
	LDI  R30,LOW(32)
	OUT  0x3A,R30
; 0000 03B8 
; 0000 03B9 // Timer(s)/Counter(s) Interrupt(s) initialization
; 0000 03BA TIMSK=0x10;
	LDI  R30,LOW(16)
	OUT  0x39,R30
; 0000 03BB 
; 0000 03BC // USART initialization
; 0000 03BD // USART disabled
; 0000 03BE UCSRB=0x00;
	LDI  R30,LOW(0)
	OUT  0xA,R30
; 0000 03BF 
; 0000 03C0 // Analog Comparator initialization
; 0000 03C1 // Analog Comparator: Off
; 0000 03C2 // Analog Comparator Input Capture by Timer/Counter 1: Off
; 0000 03C3 ACSR=0x80;
	LDI  R30,LOW(128)
	OUT  0x8,R30
; 0000 03C4 SFIOR=0x00;
	LDI  R30,LOW(0)
	OUT  0x30,R30
; 0000 03C5 
; 0000 03C6 // ADC initialization
; 0000 03C7 // ADC disabled
; 0000 03C8 ADCSRA=0x00;
	OUT  0x6,R30
; 0000 03C9 
; 0000 03CA // SPI initialization
; 0000 03CB // SPI disabled
; 0000 03CC SPCR=0x00;
	OUT  0xD,R30
; 0000 03CD 
; 0000 03CE 
; 0000 03CF 
; 0000 03D0 // TWI initialization
; 0000 03D1 // TWI disabled
; 0000 03D2 TWCR=0x00;
	OUT  0x36,R30
; 0000 03D3 
; 0000 03D4 // I2C Bus initialization
; 0000 03D5 i2c_init();
	CALL _i2c_init
; 0000 03D6 
; 0000 03D7 // DS1307 Real Time Clock initialization
; 0000 03D8 // Square wave output on pin SQW/OUT: On
; 0000 03D9 // Square wave frequency: 1Hz
; 0000 03DA rtc_init(0,1,0);
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R26,LOW(0)
	CALL _rtc_init
; 0000 03DB h = rtc_read(0x00);   //   
	LDI  R26,LOW(0)
	CALL _rtc_read
	STS  _h,R30
; 0000 03DC     delay_ms(1);
	LDI  R26,LOW(1)
	CALL SUBOPT_0x22
; 0000 03DD     if(h > 127)
	LDS  R26,_h
	CPI  R26,LOW(0x80)
	BRLO _0xA9
; 0000 03DE     {
; 0000 03DF     rtc_write(0x00, 0x00); //,     1
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R26,LOW(0)
	CALL _rtc_write
; 0000 03E0     }
; 0000 03E1 
; 0000 03E2 // Alphanumeric LCD initialization
; 0000 03E3 // Connections specified in the
; 0000 03E4 // Project|Configure|C Compiler|Libraries|Alphanumeric LCD menu:
; 0000 03E5 // RS - PORTD Bit 0
; 0000 03E6 // RD - PORTD Bit 1
; 0000 03E7 // EN - PORTD Bit 2
; 0000 03E8 // D4 - PORTD Bit 4
; 0000 03E9 // D5 - PORTD Bit 5
; 0000 03EA // D6 - PORTD Bit 6
; 0000 03EB // D7 - PORTD Bit 7
; 0000 03EC // Characters/line: 16
; 0000 03ED lcd_init(16);
_0xA9:
	LDI  R26,LOW(16)
	CALL _lcd_init
; 0000 03EE BUT_Init();
	RCALL _BUT_Init
; 0000 03EF /*
; 0000 03F0 rtc_set_time(15,56,14);
; 0000 03F1 rtc_set_date(0,01,01,02);
; 0000 03F2 */
; 0000 03F3 // Global enable interrupts
; 0000 03F4 #asm("sei")
	sei
; 0000 03F5 }
; 0000 03F6 while (1)
_0xAA:
; 0000 03F7       {
; 0000 03F8       // Place your code here
; 0000 03F9        show_time();
	RCALL _show_time
; 0000 03FA 
; 0000 03FB        BUT_Debrief();
	CALL SUBOPT_0x23
; 0000 03FC        l = BUT_GetKey();
; 0000 03FD 
; 0000 03FE       if (l==1)
	BRNE _0xAD
; 0000 03FF        {
; 0000 0400        lcd_clear();
	CALL _lcd_clear
; 0000 0401        fMenu();
	RCALL _fMenu
; 0000 0402        }
; 0000 0403 
; 0000 0404 
; 0000 0405 
; 0000 0406       }
_0xAD:
	RJMP _0xAA
; 0000 0407 }
_0xAE:
	RJMP _0xAE
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x40
	.EQU __sm_mask=0xB0
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0xA0
	.EQU __sm_ext_standby=0xB0
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif

	.CSEG

	.CSEG
_rtc_read:
	ST   -Y,R26
	ST   -Y,R17
	CALL SUBOPT_0x26
	CALL SUBOPT_0x27
	LDI  R26,LOW(0)
	CALL _i2c_read
	MOV  R17,R30
	CALL _i2c_stop
	MOV  R30,R17
	LDD  R17,Y+0
	RJMP _0x20C0003
_rtc_write:
	ST   -Y,R26
	CALL SUBOPT_0x26
	LD   R26,Y
	CALL SUBOPT_0x28
	RJMP _0x20C0003
_rtc_init:
	ST   -Y,R26
	LDD  R30,Y+2
	ANDI R30,LOW(0x3)
	STD  Y+2,R30
	LDD  R30,Y+1
	CPI  R30,0
	BREQ _0x2020003
	LDD  R30,Y+2
	ORI  R30,0x10
	STD  Y+2,R30
_0x2020003:
	LD   R30,Y
	CPI  R30,0
	BREQ _0x2020004
	LDD  R30,Y+2
	ORI  R30,0x80
	STD  Y+2,R30
_0x2020004:
	CALL SUBOPT_0x29
	LDI  R26,LOW(7)
	CALL _i2c_write
	LDD  R26,Y+2
	CALL SUBOPT_0x28
	RJMP _0x20C0002
_rtc_get_time:
	ST   -Y,R27
	ST   -Y,R26
	CALL SUBOPT_0x29
	LDI  R26,LOW(0)
	CALL _i2c_write
	CALL SUBOPT_0x27
	CALL SUBOPT_0x2A
	LD   R26,Y
	LDD  R27,Y+1
	ST   X,R30
	CALL SUBOPT_0x2A
	CALL SUBOPT_0x2B
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	ST   X,R30
	CALL _i2c_stop
	ADIW R28,6
	RET
_rtc_set_time:
	ST   -Y,R26
	CALL SUBOPT_0x29
	LDI  R26,LOW(0)
	CALL SUBOPT_0x2C
	CALL SUBOPT_0x2D
	CALL SUBOPT_0x2E
	CALL SUBOPT_0x28
	RJMP _0x20C0002
_rtc_get_date:
	ST   -Y,R27
	ST   -Y,R26
	CALL SUBOPT_0x29
	LDI  R26,LOW(3)
	CALL _i2c_write
	CALL SUBOPT_0x27
	LDI  R26,LOW(1)
	CALL _i2c_read
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ST   X,R30
	CALL SUBOPT_0x2A
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	ST   X,R30
	CALL SUBOPT_0x2A
	CALL SUBOPT_0x2B
	LD   R26,Y
	LDD  R27,Y+1
	ST   X,R30
	CALL _i2c_stop
	ADIW R28,8
	RET
_rtc_set_date:
	ST   -Y,R26
	CALL SUBOPT_0x29
	LDI  R26,LOW(3)
	CALL _i2c_write
	LDD  R26,Y+3
	CALL SUBOPT_0x2E
	CALL SUBOPT_0x2D
	CALL SUBOPT_0x2C
	CALL SUBOPT_0x28
	ADIW R28,4
	RET
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x40
	.EQU __sm_mask=0xB0
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0xA0
	.EQU __sm_ext_standby=0xB0
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif

	.DSEG

	.CSEG
__lcd_write_nibble_G102:
	ST   -Y,R26
	IN   R30,0x12
	ANDI R30,LOW(0xF)
	MOV  R26,R30
	LD   R30,Y
	ANDI R30,LOW(0xF0)
	OR   R30,R26
	OUT  0x12,R30
	__DELAY_USB 5
	SBI  0x12,2
	__DELAY_USB 13
	CBI  0x12,2
	__DELAY_USB 13
	RJMP _0x20C0001
__lcd_write_data:
	ST   -Y,R26
	LD   R26,Y
	RCALL __lcd_write_nibble_G102
    ld    r30,y
    swap  r30
    st    y,r30
	LD   R26,Y
	RCALL __lcd_write_nibble_G102
	__DELAY_USB 133
	RJMP _0x20C0001
_lcd_gotoxy:
	ST   -Y,R26
	LD   R30,Y
	LDI  R31,0
	SUBI R30,LOW(-__base_y_G102)
	SBCI R31,HIGH(-__base_y_G102)
	LD   R30,Z
	LDD  R26,Y+1
	ADD  R26,R30
	RCALL __lcd_write_data
	LDD  R30,Y+1
	STS  __lcd_x,R30
	LD   R30,Y
	STS  __lcd_y,R30
_0x20C0003:
	ADIW R28,2
	RET
_lcd_clear:
	LDI  R26,LOW(2)
	RCALL __lcd_write_data
	LDI  R26,LOW(3)
	CALL SUBOPT_0x22
	LDI  R26,LOW(12)
	RCALL __lcd_write_data
	LDI  R26,LOW(1)
	RCALL __lcd_write_data
	LDI  R26,LOW(3)
	CALL SUBOPT_0x22
	LDI  R30,LOW(0)
	STS  __lcd_y,R30
	STS  __lcd_x,R30
	RET
_lcd_putchar:
	ST   -Y,R26
	LD   R26,Y
	CPI  R26,LOW(0xA)
	BREQ _0x2040005
	LDS  R30,__lcd_maxx
	LDS  R26,__lcd_x
	CP   R26,R30
	BRLO _0x2040004
_0x2040005:
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDS  R26,__lcd_y
	SUBI R26,-LOW(1)
	STS  __lcd_y,R26
	RCALL _lcd_gotoxy
	LD   R26,Y
	CPI  R26,LOW(0xA)
	BRNE _0x2040007
	RJMP _0x20C0001
_0x2040007:
_0x2040004:
	LDS  R30,__lcd_x
	SUBI R30,-LOW(1)
	STS  __lcd_x,R30
	SBI  0x12,0
	LD   R26,Y
	RCALL __lcd_write_data
	CBI  0x12,0
	RJMP _0x20C0001
_lcd_putsf:
	ST   -Y,R27
	ST   -Y,R26
	ST   -Y,R17
_0x204000B:
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ADIW R30,1
	STD  Y+1,R30
	STD  Y+1+1,R31
	SBIW R30,1
	LPM  R30,Z
	MOV  R17,R30
	CPI  R30,0
	BREQ _0x204000D
	MOV  R26,R17
	RCALL _lcd_putchar
	RJMP _0x204000B
_0x204000D:
	LDD  R17,Y+0
_0x20C0002:
	ADIW R28,3
	RET
_lcd_init:
	ST   -Y,R26
	IN   R30,0x11
	ORI  R30,LOW(0xF0)
	OUT  0x11,R30
	SBI  0x11,2
	SBI  0x11,0
	SBI  0x11,1
	CBI  0x12,2
	CBI  0x12,0
	CBI  0x12,1
	LD   R30,Y
	STS  __lcd_maxx,R30
	SUBI R30,-LOW(128)
	__PUTB1MN __base_y_G102,2
	LD   R30,Y
	SUBI R30,-LOW(192)
	__PUTB1MN __base_y_G102,3
	LDI  R26,LOW(20)
	CALL SUBOPT_0x22
	CALL SUBOPT_0x2F
	CALL SUBOPT_0x2F
	CALL SUBOPT_0x2F
	LDI  R26,LOW(32)
	RCALL __lcd_write_nibble_G102
	__DELAY_USW 200
	LDI  R26,LOW(40)
	RCALL __lcd_write_data
	LDI  R26,LOW(4)
	RCALL __lcd_write_data
	LDI  R26,LOW(133)
	RCALL __lcd_write_data
	LDI  R26,LOW(6)
	RCALL __lcd_write_data
	RCALL _lcd_clear
_0x20C0001:
	ADIW R28,1
	RET

	.CSEG

	.CSEG

	.CSEG
_bcd2bin:
	ST   -Y,R26
    ld   r30,y
    swap r30
    andi r30,0xf
    mov  r26,r30
    lsl  r26
    lsl  r26
    add  r30,r26
    lsl  r30
    ld   r26,y+
    andi r26,0xf
    add  r30,r26
    ret
_bin2bcd:
	ST   -Y,R26
    ld   r26,y+
    clr  r30
bin2bcd0:
    subi r26,10
    brmi bin2bcd1
    subi r30,-16
    rjmp bin2bcd0
bin2bcd1:
    subi r26,-10
    add  r30,r26
    ret

	.DSEG
_alarm:
	.BYTE 0x2D0
_input:
	.BYTE 0x1
_l:
	.BYTE 0x1
_t:
	.BYTE 0x1
_h:
	.BYTE 0x1
_h1:
	.BYTE 0x1
_h2:
	.BYTE 0x1
_j:
	.BYTE 0x1
_dur1:
	.BYTE 0x1
_dur2:
	.BYTE 0x1
_set:
	.BYTE 0x2
_out1:
	.BYTE 0x2
_out2:
	.BYTE 0x2
_pressedKey:
	.BYTE 0x1
_comp:
	.BYTE 0x1
__base_y_G102:
	.BYTE 0x4
__lcd_x:
	.BYTE 0x1
__lcd_y:
	.BYTE 0x1
__lcd_maxx:
	.BYTE 0x1

	.CSEG
;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:23 WORDS
SUBOPT_0x0:
	LDI  R30,LOW(5)
	LDI  R31,HIGH(5)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(4)
	LDI  R31,HIGH(4)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R26,LOW(7)
	LDI  R27,HIGH(7)
	CALL _rtc_get_time
	LDI  R30,LOW(11)
	LDI  R31,HIGH(11)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(6)
	LDI  R31,HIGH(6)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(9)
	LDI  R31,HIGH(9)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R26,LOW(8)
	LDI  R27,HIGH(8)
	JMP  _rtc_get_date

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:12 WORDS
SUBOPT_0x1:
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R26,LOW(0)
	JMP  _lcd_gotoxy

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:42 WORDS
SUBOPT_0x2:
	MOV  R26,R5
	LDI  R27,0
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL __DIVW21
	SUBI R30,-LOW(48)
	MOV  R26,R30
	CALL _lcd_putchar
	MOV  R26,R5
	CLR  R27
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL __MODW21
	SUBI R30,-LOW(48)
	MOV  R26,R30
	CALL _lcd_putchar
	LDI  R26,LOW(58)
	CALL _lcd_putchar
	MOV  R26,R4
	LDI  R27,0
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL __DIVW21
	SUBI R30,-LOW(48)
	MOV  R26,R30
	CALL _lcd_putchar
	MOV  R26,R4
	CLR  R27
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL __MODW21
	SUBI R30,-LOW(48)
	MOV  R26,R30
	JMP  _lcd_putchar

;OPTIMIZER ADDED SUBROUTINE, CALLED 15 TIMES, CODE SIZE REDUCTION:123 WORDS
SUBOPT_0x3:
	LDI  R27,0
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL __DIVW21
	SUBI R30,-LOW(48)
	MOV  R26,R30
	JMP  _lcd_putchar

;OPTIMIZER ADDED SUBROUTINE, CALLED 10 TIMES, CODE SIZE REDUCTION:60 WORDS
SUBOPT_0x4:
	CLR  R27
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL __MODW21
	SUBI R30,-LOW(48)
	MOV  R26,R30
	JMP  _lcd_putchar

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:37 WORDS
SUBOPT_0x5:
	MOV  R26,R10
	LDI  R27,0
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	CALL __DIVW21
	SUBI R30,-LOW(48)
	MOV  R26,R30
	CALL _lcd_putchar
	MOV  R26,R10
	CLR  R27
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	CALL __MODW21
	MOVW R26,R30
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL __DIVW21
	SUBI R30,-LOW(48)
	MOV  R26,R30
	CALL _lcd_putchar
	MOV  R26,R10
	CLR  R27
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	CALL __MODW21
	MOVW R26,R30
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL __MODW21
	SUBI R30,-LOW(48)
	MOV  R26,R30
	JMP  _lcd_putchar

;OPTIMIZER ADDED SUBROUTINE, CALLED 10 TIMES, CODE SIZE REDUCTION:24 WORDS
SUBOPT_0x6:
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R26,LOW(1)
	JMP  _lcd_gotoxy

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x7:
	CALL _lcd_putchar
	LDI  R26,LOW(32)
	JMP  _lcd_putchar

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x8:
	LDI  R26,LOW(_s8*2)
	LDI  R27,HIGH(_s8*2)
	CALL _lcd_putsf
	LDI  R30,LOW(8)
	ST   -Y,R30
	LDI  R26,LOW(1)
	JMP  _lcd_gotoxy

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:8 WORDS
SUBOPT_0x9:
	LDS  R30,_t
	LDI  R31,0
	SBIW R30,1
	LDI  R26,LOW(6)
	LDI  R27,HIGH(6)
	CALL __MULW12U
	__ADDW1MN _alarm,2
	LD   R26,Z
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:19 WORDS
SUBOPT_0xA:
	LDI  R27,0
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL __MODW21
	SUBI R30,-LOW(48)
	MOV  R26,R30
	CALL _lcd_putchar
	LDI  R26,LOW(58)
	CALL _lcd_putchar
	LDS  R30,_t
	LDI  R31,0
	SBIW R30,1
	LDI  R26,LOW(6)
	LDI  R27,HIGH(6)
	CALL __MULW12U
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:45 WORDS
SUBOPT_0xB:
	LDS  R30,_t
	LDI  R31,0
	SBIW R30,1
	LDI  R26,LOW(6)
	LDI  R27,HIGH(6)
	CALL __MULW12U
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:13 WORDS
SUBOPT_0xC:
	LD   R26,Z
	LDI  R27,0
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL __MODW21
	SUBI R30,-LOW(48)
	MOV  R26,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:11 WORDS
SUBOPT_0xD:
	CALL __DIVW21
	SUBI R30,-LOW(48)
	MOV  R26,R30
	CALL _lcd_putchar
	LDS  R26,_t
	CLR  R27
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	CALL __MODW21
	MOVW R26,R30
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 13 TIMES, CODE SIZE REDUCTION:33 WORDS
SUBOPT_0xE:
	LDS  R30,_j
	LDI  R31,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0xF:
	LDS  R30,_j
	SUBI R30,-LOW(1)
	STS  _j,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x10:
	CALL _lcd_putsf
	RJMP SUBOPT_0x6

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x11:
	CALL _lcd_putsf
	JMP  _clear

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x12:
	MOVW R12,R30
	LDS  R26,_j
	CPI  R26,LOW(0x2)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x13:
	LDS  R30,_j
	SUBI R30,LOW(1)
	STS  _j,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:11 WORDS
SUBOPT_0x14:
	LDI  R26,LOW(_s12*2)
	LDI  R27,HIGH(_s12*2)
	CALL _lcd_putsf
	LDS  R26,_j
	SUBI R26,-LOW(48)
	JMP  _lcd_putchar

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x15:
	LDS  R30,_set
	LDS  R31,_set+1
	COM  R30
	COM  R31
	MOVW R22,R30
	RJMP SUBOPT_0xE

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:57 WORDS
SUBOPT_0x16:
	SBIW R30,1
	LDI  R26,LOW(_mask_bit_int*2)
	LDI  R27,HIGH(_mask_bit_int*2)
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	CALL __GETW1PF
	AND  R30,R22
	AND  R31,R23
	MOVW R26,R30
	CALL __CPW02
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:32 WORDS
SUBOPT_0x17:
	SBIW R30,1
	LDI  R26,LOW(_mask_bit_int*2)
	LDI  R27,HIGH(_mask_bit_int*2)
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	CALL __GETW1PF
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x18:
	LDS  R26,_set
	LDS  R27,_set+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x19:
	MOVW R12,R30
	LDS  R26,_j
	CPI  R26,LOW(0x8)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x1A:
	CALL _set_date
	LDI  R26,LOW(14)
	JMP  __lcd_write_data

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x1B:
	LDI  R30,LOW(1)
	ST   -Y,R30
	LDI  R26,LOW(1)
	JMP  _lcd_gotoxy

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x1C:
	ST   -Y,R30
	LDI  R26,LOW(1)
	JMP  _lcd_gotoxy

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x1D:
	LDS  R30,_out1
	LDS  R31,_out1+1
	COM  R30
	COM  R31
	MOVW R22,R30
	RJMP SUBOPT_0xE

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x1E:
	LDS  R26,_out1
	LDS  R27,_out1+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x1F:
	LDI  R26,LOW(_s05*2)
	LDI  R27,HIGH(_s05*2)
	RJMP SUBOPT_0x10

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x20:
	LDS  R30,_out2
	LDS  R31,_out2+1
	COM  R30
	COM  R31
	MOVW R22,R30
	RJMP SUBOPT_0xE

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x21:
	LDS  R26,_out2
	LDS  R27,_out2+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:15 WORDS
SUBOPT_0x22:
	LDI  R27,0
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x23:
	CALL _BUT_Debrief
	CALL _BUT_GetKey
	STS  _l,R30
	LDS  R26,_l
	CPI  R26,LOW(0x1)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x24:
	MOV  R30,R10
	LDI  R26,LOW(6)
	MUL  R30,R26
	MOVW R30,R0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x25:
	LDI  R31,0
	AND  R30,R26
	AND  R31,R27
	MOVW R26,R30
	CALL __CPW02
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x26:
	CALL _i2c_start
	LDI  R26,LOW(208)
	CALL _i2c_write
	LDD  R26,Y+1
	JMP  _i2c_write

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x27:
	CALL _i2c_stop
	CALL _i2c_start
	LDI  R26,LOW(209)
	JMP  _i2c_write

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x28:
	CALL _i2c_write
	JMP  _i2c_stop

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x29:
	CALL _i2c_start
	LDI  R26,LOW(208)
	JMP  _i2c_write

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x2A:
	LDI  R26,LOW(1)
	CALL _i2c_read
	MOV  R26,R30
	JMP  _bcd2bin

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x2B:
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	ST   X,R30
	LDI  R26,LOW(0)
	CALL _i2c_read
	MOV  R26,R30
	JMP  _bcd2bin

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x2C:
	CALL _i2c_write
	LD   R26,Y
	RCALL _bin2bcd
	MOV  R26,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x2D:
	CALL _i2c_write
	LDD  R26,Y+1
	RCALL _bin2bcd
	MOV  R26,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x2E:
	CALL _i2c_write
	LDD  R26,Y+2
	RCALL _bin2bcd
	MOV  R26,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x2F:
	LDI  R26,LOW(48)
	CALL __lcd_write_nibble_G102
	__DELAY_USW 200
	RET


	.CSEG
	.equ __i2c_dir=__i2c_port-1
	.equ __i2c_pin=__i2c_port-2

_i2c_init:
	cbi  __i2c_port,__scl_bit
	cbi  __i2c_port,__sda_bit
	sbi  __i2c_dir,__scl_bit
	cbi  __i2c_dir,__sda_bit
	rjmp __i2c_delay2
_i2c_start:
	cbi  __i2c_dir,__sda_bit
	cbi  __i2c_dir,__scl_bit
	clr  r30
	nop
	sbis __i2c_pin,__sda_bit
	ret
	sbis __i2c_pin,__scl_bit
	ret
	rcall __i2c_delay1
	sbi  __i2c_dir,__sda_bit
	rcall __i2c_delay1
	sbi  __i2c_dir,__scl_bit
	ldi  r30,1
__i2c_delay1:
	ldi  r22,13
	rjmp __i2c_delay2l
_i2c_stop:
	sbi  __i2c_dir,__sda_bit
	sbi  __i2c_dir,__scl_bit
	rcall __i2c_delay2
	cbi  __i2c_dir,__scl_bit
	rcall __i2c_delay1
	cbi  __i2c_dir,__sda_bit
__i2c_delay2:
	ldi  r22,27
__i2c_delay2l:
	dec  r22
	brne __i2c_delay2l
	ret
_i2c_read:
	ldi  r23,8
__i2c_read0:
	cbi  __i2c_dir,__scl_bit
	rcall __i2c_delay1
__i2c_read3:
	sbis __i2c_pin,__scl_bit
	rjmp __i2c_read3
	rcall __i2c_delay1
	clc
	sbic __i2c_pin,__sda_bit
	sec
	sbi  __i2c_dir,__scl_bit
	rcall __i2c_delay2
	rol  r30
	dec  r23
	brne __i2c_read0
	mov  r23,r26
	tst  r23
	brne __i2c_read1
	cbi  __i2c_dir,__sda_bit
	rjmp __i2c_read2
__i2c_read1:
	sbi  __i2c_dir,__sda_bit
__i2c_read2:
	rcall __i2c_delay1
	cbi  __i2c_dir,__scl_bit
	rcall __i2c_delay2
	sbi  __i2c_dir,__scl_bit
	rcall __i2c_delay1
	cbi  __i2c_dir,__sda_bit
	rjmp __i2c_delay1

_i2c_write:
	ldi  r23,8
__i2c_write0:
	lsl  r26
	brcc __i2c_write1
	cbi  __i2c_dir,__sda_bit
	rjmp __i2c_write2
__i2c_write1:
	sbi  __i2c_dir,__sda_bit
__i2c_write2:
	rcall __i2c_delay2
	cbi  __i2c_dir,__scl_bit
	rcall __i2c_delay1
__i2c_write3:
	sbis __i2c_pin,__scl_bit
	rjmp __i2c_write3
	rcall __i2c_delay1
	sbi  __i2c_dir,__scl_bit
	dec  r23
	brne __i2c_write0
	cbi  __i2c_dir,__sda_bit
	rcall __i2c_delay1
	cbi  __i2c_dir,__scl_bit
	rcall __i2c_delay2
	ldi  r30,1
	sbic __i2c_pin,__sda_bit
	clr  r30
	sbi  __i2c_dir,__scl_bit
	rjmp __i2c_delay1

_delay_ms:
	adiw r26,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0x7D0
	wdr
	sbiw r26,1
	brne __delay_ms0
__delay_ms1:
	ret

__ANEGW1:
	NEG  R31
	NEG  R30
	SBCI R31,0
	RET

__MULW12U:
	MUL  R31,R26
	MOV  R31,R0
	MUL  R30,R27
	ADD  R31,R0
	MUL  R30,R26
	MOV  R30,R0
	ADD  R31,R1
	RET

__DIVW21U:
	CLR  R0
	CLR  R1
	LDI  R25,16
__DIVW21U1:
	LSL  R26
	ROL  R27
	ROL  R0
	ROL  R1
	SUB  R0,R30
	SBC  R1,R31
	BRCC __DIVW21U2
	ADD  R0,R30
	ADC  R1,R31
	RJMP __DIVW21U3
__DIVW21U2:
	SBR  R26,1
__DIVW21U3:
	DEC  R25
	BRNE __DIVW21U1
	MOVW R30,R26
	MOVW R26,R0
	RET

__DIVW21:
	RCALL __CHKSIGNW
	RCALL __DIVW21U
	BRTC __DIVW211
	RCALL __ANEGW1
__DIVW211:
	RET

__MODW21:
	CLT
	SBRS R27,7
	RJMP __MODW211
	COM  R26
	COM  R27
	ADIW R26,1
	SET
__MODW211:
	SBRC R31,7
	RCALL __ANEGW1
	RCALL __DIVW21U
	MOVW R30,R26
	BRTC __MODW212
	RCALL __ANEGW1
__MODW212:
	RET

__CHKSIGNW:
	CLT
	SBRS R31,7
	RJMP __CHKSW1
	RCALL __ANEGW1
	SET
__CHKSW1:
	SBRS R27,7
	RJMP __CHKSW2
	COM  R26
	COM  R27
	ADIW R26,1
	BLD  R0,0
	INC  R0
	BST  R0,0
__CHKSW2:
	RET

__GETW1PF:
	LPM  R0,Z+
	LPM  R31,Z
	MOV  R30,R0
	RET

__CPW02:
	CLR  R0
	CP   R0,R26
	CPC  R0,R27
	RET

;END OF CODE MARKER
__END_OF_CODE:
