#include "stm32f10x.h"
#include <stdio.h>

void delay_ms(uint32_t);
void InitAll(void);
uint8_t getchar1 (void);
uint8_t getchar2 (void);
uint8_t getchar3 (void);

// USART1 Receiver buffer
#define RX_BUFFER_SIZE1 128
uint8_t rx_buffer1[RX_BUFFER_SIZE1];

#if RX_BUFFER_SIZE1<256
uint8_t rx_wr_index1,rx_rd_index1,rx_counter1;
#else
uint16_t rx_wr_index1,rx_rd_index1,rx_counter1;
#endif
// This flag is set on USART1 Receiver buffer overflow
uint8_t rx_buffer_overflow1;

uint8_t rx_buffer2[64];
uint8_t rx_wr_index2,rx_rd_index2,rx_counter2;

uint8_t rx_buffer3[64];
uint8_t rx_wr_index3,rx_rd_index3,rx_counter3;

//*****s1**s2**b
//bt***rx**tx
//pc***rx**tx

#define led_b_on() 			GPIO_SetBits(GPIOB, GPIO_Pin_3)
#define led_b_off()			GPIO_ResetBits(GPIOB, GPIO_Pin_3)

#define led_b_s1_on() 		GPIO_SetBits(GPIOC, GPIO_Pin_14)
#define led_b_s1_off() 		GPIO_ResetBits(GPIOC, GPIO_Pin_14)

#define led_b_s2_on() 		GPIO_SetBits(GPIOB, GPIO_Pin_7)
#define led_b_s2_off() 		GPIO_ResetBits(GPIOB, GPIO_Pin_7)
 
#define led_b_rx_on() 		GPIO_SetBits(GPIOC, GPIO_Pin_13)
#define led_b_rx_off() 		GPIO_ResetBits(GPIOC, GPIO_Pin_13)

#define led_b_tx_on() 		GPIO_SetBits(GPIOB, GPIO_Pin_6)
#define led_b_tx_off() 		GPIO_ResetBits(GPIOB, GPIO_Pin_6)

#define led_u_rx_on() 		GPIO_SetBits(GPIOB, GPIO_Pin_9)
#define led_u_rx_off() 		GPIO_ResetBits(GPIOB, GPIO_Pin_9)

#define led_u_tx_on() 		GPIO_SetBits(GPIOB, GPIO_Pin_5)
#define led_u_tx_off() 		GPIO_ResetBits(GPIOB, GPIO_Pin_5)

#define bt_reset() 		{GPIO_ResetBits(GPIOA, GPIO_Pin_0); delay_ms(20); GPIO_SetBits(GPIOA, GPIO_Pin_0);} 
#define bt_mode_cmd() 	{GPIO_SetBits(GPIOA, GPIO_Pin_7); delay_ms(5); bt_reset();}
#define bt_mode_data() 	{GPIO_ResetBits(GPIOA, GPIO_Pin_7); delay_ms(5); bt_reset();}

#define but1		GPIO_ReadInputDataBit(GPIOC, GPIO_Pin_15)
#define but2		GPIO_ReadInputDataBit(GPIOB, GPIO_Pin_8)
#define but3		GPIO_ReadInputDataBit(GPIOB, GPIO_Pin_4)
#define but4		GPIO_ReadInputDataBit(GPIOA, GPIO_Pin_15)

uint8_t target = 1;	//  USART   : 1 - , 2 -  (. - sendchar)
					// 1 - , 2 -  BT 
uint8_t main_clk_fail = 0;

//   
#define mode_data	0
#define mode_cmd	1
uint8_t mode = mode_data;

uint8_t change_mode_cnt = 0;	//   +        

uint8_t byte1 = 0;				//      

int main(void) 
	{
	RCC_ClocksTypeDef RCC_Clocks;

	InitAll();
	
	if (main_clk_fail) 
		{
		led_b_on(); delay_ms(100); 
		led_b_off(); delay_ms(100); 
		led_b_on(); delay_ms(100);
		led_b_off(); delay_ms(100); 
		led_b_on(); delay_ms(100);
		led_b_off(); delay_ms(100); 
		led_b_on(); delay_ms(100);
		led_b_off(); delay_ms(100); 
		led_b_on(); delay_ms(100);
		led_b_off();
		} 	

	led_u_rx_on(); led_u_tx_on();
	delay_ms(700);
	led_b_rx_on(); led_b_tx_on();
	delay_ms(700);
	led_b_s1_on(); led_b_s2_on();
	delay_ms(700);
	led_u_rx_off(); led_u_tx_off();
	led_b_rx_off(); led_b_tx_off();
	led_b_s1_off(); led_b_s2_off();
	led_b_on();
	delay_ms(200);
	led_b_off();
	
	TIM_Cmd(TIM1, ENABLE);
	IWDG_Enable();
	
	printf ("\rSTM32 On-line\r");
	if (main_clk_fail) printf ("Main Clock Failed(((\r"); 
	RCC_GetClocksFreq (&RCC_Clocks);
	printf ("RCC_Clocks.SYSCLK_Frequency: %07ldHz\r", RCC_Clocks.SYSCLK_Frequency);
	printf ("RCC_Clocks.HCLK_Frequency:   %07ldHz\r", RCC_Clocks.HCLK_Frequency);
	printf ("RCC_Clocks.PCLK1_Frequency:  %07ldHz\r", RCC_Clocks.PCLK1_Frequency);
	printf ("RCC_Clocks.PCLK2_Frequency:  %07ldHz\r", RCC_Clocks.PCLK2_Frequency);

	bt_mode_cmd();
	delay_ms(3000);
 	target = 1;
	printf ("\rCurrent BT Configuration:\r");
	target = 2;
	printf ("AT+VERSION?\r\n");
	//delay_ms(1000);
	//printf ("AT+RNAME?\r\n");
	delay_ms(1000);
	printf ("AT+ROLE?\r\n");
	delay_ms(1000);
	printf ("AT+CLASS?\r\n");
	delay_ms(1000);
	printf ("AT+ADDR?\r\n");
	delay_ms(1000);
	printf ("AT+NAME?\r\n");
	delay_ms(1000);
	printf ("AT+IAC?\r\n");
	delay_ms(1000);
	printf ("AT+INQM?\r\n");
	delay_ms(1000);
	printf ("AT+PSWD?\r\n");
	delay_ms(1000);
	printf ("AT+UART?\r\n");
	delay_ms(1000);
	printf ("AT+CMODE?\r\n");
	delay_ms(1000);
	printf ("AT+BIND?\r\n");
	delay_ms(1000);
	printf ("AT+POLAR?\r\n");
	delay_ms(1000);
	printf ("AT+MPIO?\r\n");
	delay_ms(1000);
	printf ("AT+IPSCAN?\r\n");
	delay_ms(1000);
	printf ("AT+SNIFF?\r\n");
	delay_ms(1000);
	printf ("AT+SENM?\r\n");
	delay_ms(1000);
	printf ("AT+MRAD?\r\n");
	delay_ms(1000);
	printf ("AT+STATE?\r\n");

	
	//printf ("AT+BIND=2011,2,470160\r\n");	// TEST-BOARD Address
	//printf ("AT+BIND=2012,2,1\r\n");	// ORBIT-LED Address
	//printf ("AT+BIND=2012,2,2\r\n");	// GREEN Clock Address
	delay_ms(1000);

	bt_mode_data();
	delay_ms(3000);

	while (1)
		{
		IWDG_ReloadCounter();	//  100   IWDG
		
		if (mode == mode_data && change_mode_cnt >= 3)
			{
			change_mode_cnt = 0;
			mode = mode_cmd;
			}
		
		/*if (rx_counter2)
			{
			target = 2;
			putchar (getchar2());
			} 

		if (rx_counter3)
			{
			target = 1;
			putchar (getchar3());
			}*/
		
		if (mode == mode_cmd && rx_counter1>1)
			{
			delay_ms(20);
			byte1 = getchar1();
			if (byte1 == 'c')
				{
				byte1 = getchar1();
				switch (byte1)
					{
					case '0': {mode = mode_data; delay_ms(100); target = 1; printf ("\rData Mode OK\r");}; break;		//    
					case '1': {bt_reset(); delay_ms(100); target = 1; printf ("\rBT Reset OK\r");}; break;				//   
					case '2': {bt_mode_cmd(); delay_ms(100); target = 1; printf ("\rBT Command Mode OK\r");}; break;	//  -   
					case '3': {bt_mode_data(); delay_ms(100); target = 1; printf ("\rBT Data Mode OK\r");}; break;		//  -   
					case '4':   {
								delay_ms(100); target = 1; printf ("\rBT Reinit...\r");
								bt_mode_cmd();
								delay_ms(3000);
								target = 2;
								printf ("AT+ORGL\r\n");
								delay_ms(1000);
								printf ("AT+NAME=BASE_STATION\r\n");
								delay_ms(1000);
								printf ("AT+ROLE=1\r\n");
								delay_ms(1000);
								printf ("AT+CMODE=0\r\n");
								delay_ms(1000);
								bt_mode_data();
								delay_ms(1000);
								target = 1; printf ("\rBT Reinit Completed\r");
								}; break;
					case '5': 	{
								delay_ms(100); target = 1; printf ("\rSetting New Bind Address...\r");
								bt_mode_cmd();
								delay_ms(3000);
								target = 2;
								printf ("AT+BIND=");
								putchar(getchar1());
								putchar(getchar1());
								putchar(getchar1());
								putchar(getchar1());
								putchar(',');
								putchar(getchar1());
								putchar(getchar1());
								putchar(',');
								putchar(getchar1());
								putchar(getchar1());
								putchar(getchar1());
								putchar(getchar1());
								putchar(getchar1());
								putchar(getchar1());
								putchar(0x0d);
								putchar(0x0a);
								delay_ms(1000);
								printf ("AT+BIND?\r\n");	
								delay_ms(1000);
								bt_mode_data();
								delay_ms(1000);
								target = 1; printf ("\rSetting New Bind Address Completed\r");
								}; break;
					case '6': 	{
								if (GPIO_ReadInputDataBit(GPIOA, GPIO_Pin_6) == 1) {target = 1; printf ("\rConnection Passed\r");}
									else {target = 1; printf ("\rConnection Failed\r");};  
								}; break;
					case '7': {}; break;
					case '8': {}; break;
					case '9': 	{
								target = 1; printf ("\rMCU Reset...\r");
								TIM_Cmd(TIM1, DISABLE);
								while (1);
								}; break;
					}
				}
			}
		}
	}


void InitAll(void) 
	{
  	ErrorStatus HSEStartUpStatus; 
	USART_InitTypeDef USART_InitStructure;
	GPIO_InitTypeDef GPIO_InitStructure;
//	EXTI_InitTypeDef EXTI_InitStructure;
	
	// RCC    
	RCC_DeInit();												/* RCC system reset(for debug purpose) */  
	RCC_HSEConfig(RCC_HSE_ON);									/* Enable HSE */  
	HSEStartUpStatus = RCC_WaitForHSEStartUp(); 				/* Wait till HSE is ready */  
	if (HSEStartUpStatus == SUCCESS)   
		{     
		FLASH_PrefetchBufferCmd(FLASH_PrefetchBuffer_Enable);	/* Enable Prefetch Buffer */        
		FLASH_SetLatency(FLASH_Latency_2);						/* Flash 2 wait state */        
		RCC_HCLKConfig(RCC_SYSCLK_Div1);						/* HCLK = SYSCLK */       
		RCC_PCLK2Config(RCC_HCLK_Div1);       					/* PCLK2 = HCLK */
		RCC_PCLK1Config(RCC_HCLK_Div1);       					/* PCLK1 = HCLK/2 */ 
		RCC_PLLConfig(RCC_PLLSource_PREDIV1, RCC_PLLMul_6);     /* PLLCLK = 4.433619MHz * 6 = 26.601714 MHz */   
		RCC_PLLCmd(ENABLE);       								/* Enable PLL */
		while (RCC_GetFlagStatus(RCC_FLAG_PLLRDY) == RESET);   	/* Wait till PLL is ready */     
		RCC_SYSCLKConfig(RCC_SYSCLKSource_PLLCLK);       		/* Select PLL as system clock source */ 
		while (RCC_GetSYSCLKSource() != 0x08);   				/* Wait till PLL is used as system clock source */
		}	
		else main_clk_fail = 1;
	
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_AFIO, ENABLE);	//       NVIC
	
	// GPIO
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA|RCC_APB2Periph_GPIOB|RCC_APB2Periph_GPIOC, ENABLE);
	// PORTA
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_0|GPIO_Pin_7;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  	GPIO_Init(GPIOA, &GPIO_InitStructure);
	
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_1|GPIO_Pin_6|GPIO_Pin_15|GPIO_Pin_3|GPIO_Pin_10;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
  	GPIO_Init(GPIOA, &GPIO_InitStructure);

	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_2|GPIO_Pin_9;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
  	GPIO_Init(GPIOA, &GPIO_InitStructure);

	// PORTB
	GPIO_PinRemapConfig(GPIO_Remap_SWJ_JTAGDisable, ENABLE);//  ,  JTAG'
	
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_3|GPIO_Pin_5|GPIO_Pin_6|GPIO_Pin_7|GPIO_Pin_9;
  	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  	GPIO_Init(GPIOB, &GPIO_InitStructure); 
	
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_4|GPIO_Pin_8;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;								
  	GPIO_Init(GPIOC, &GPIO_InitStructure);
	
	// PORTC
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_13|GPIO_Pin_14;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  	GPIO_Init(GPIOC, &GPIO_InitStructure);
	
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_15;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
  	GPIO_Init(GPIOC, &GPIO_InitStructure);
	
	// USART1
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_USART1, ENABLE);

	USART_InitStructure.USART_BaudRate = 38400;
  	USART_InitStructure.USART_WordLength = USART_WordLength_8b;
  	USART_InitStructure.USART_StopBits = USART_StopBits_1;
  	USART_InitStructure.USART_Parity = USART_Parity_No ;
  	USART_InitStructure.USART_Mode = USART_Mode_Rx|USART_Mode_Tx;
  	USART_InitStructure.USART_HardwareFlowControl = USART_HardwareFlowControl_None;
	USART_Init(USART1, &USART_InitStructure);

	USART_Cmd(USART1, ENABLE);

	USART_ITConfig(USART1, USART_IT_RXNE, ENABLE);

	NVIC_EnableIRQ(USART1_IRQn);
	NVIC_SetPriority(USART1_IRQn, 1);

	// USART2
	RCC_APB1PeriphClockCmd(RCC_APB1Periph_USART2, ENABLE);

	USART_InitStructure.USART_BaudRate = 38400;
  	USART_InitStructure.USART_WordLength = USART_WordLength_8b;
  	USART_InitStructure.USART_StopBits = USART_StopBits_1;
  	USART_InitStructure.USART_Parity = USART_Parity_No ;
  	USART_InitStructure.USART_Mode = USART_Mode_Rx|USART_Mode_Tx;
  	USART_InitStructure.USART_HardwareFlowControl = USART_HardwareFlowControl_None;
	USART_Init(USART2, &USART_InitStructure);

	USART_Cmd(USART2, ENABLE);

	USART_ITConfig(USART2, USART_IT_RXNE, ENABLE);
	
	NVIC_EnableIRQ(USART2_IRQn);
	NVIC_SetPriority(USART2_IRQn, 1);
	
	// 

	// TIM1	-   
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_TIM1, ENABLE);
	
	TIM_PrescalerConfig(TIM1, 26602, TIM_PSCReloadMode_Update);	// ,  1
	TIM_SetAutoreload(TIM1, 1);									//   1 (1 )
	TIM_ARRPreloadConfig(TIM1, ENABLE);							// . 
	TIM_InternalClockConfig(TIM1);								//  
	TIM_CounterModeConfig(TIM1, TIM_CounterMode_Up);			//  
	TIM_ITConfig(TIM1, TIM_IT_Update, ENABLE);					// .   
	//TIM_Cmd(TIM1, ENABLE);										//  
	
	NVIC_EnableIRQ(TIM1_UP_TIM16_IRQn);
	NVIC_SetPriority(TIM1_UP_TIM16_IRQn, 4);
	
/*	// TIM3 -   ()
	RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM3, ENABLE);
	
	TIM_PrescalerConfig(TIM3, 1000, TIM_PSCReloadMode_Update);	// 
	TIM_SetAutoreload(TIM3, 1);									//   36
	TIM_ARRPreloadConfig(TIM3, ENABLE);							// . 
	TIM_InternalClockConfig(TIM3);								//  
	TIM_CounterModeConfig(TIM3, TIM_CounterMode_Up);			//  
	TIM_ITConfig(TIM3, TIM_IT_Update, ENABLE);					// .   
	TIM_Cmd(TIM3, ENABLE);										//  

	NVIC_EnableIRQ(TIM3_IRQn);
	NVIC_SetPriority(TIM3_IRQn, 0);								//   -   

	// TIM4 - RC5
	RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM4, ENABLE);
	
	TIM_PrescalerConfig(TIM4, 1152, TIM_PSCReloadMode_Update);	// 
	TIM_SetAutoreload(TIM4, 256);								//   256
	TIM_ARRPreloadConfig(TIM4, ENABLE);							// . 
	TIM_InternalClockConfig(TIM4);								//  
	TIM_CounterModeConfig(TIM4, TIM_CounterMode_Up);			//  
	TIM_ITConfig(TIM4, TIM_IT_Update, ENABLE);					// .   
	TIM_Cmd(TIM4, ENABLE);

	NVIC_EnableIRQ(TIM4_IRQn);
	NVIC_SetPriority(TIM4_IRQn, 2);

	//   RC5
	EXTI_InitStructure.EXTI_Line = EXTI_Line15;
   	EXTI_InitStructure.EXTI_Mode = EXTI_Mode_Interrupt;
   	EXTI_InitStructure.EXTI_Trigger = EXTI_Trigger_Rising_Falling;
   	EXTI_InitStructure.EXTI_LineCmd = ENABLE;
   	EXTI_Init(&EXTI_InitStructure);  

	NVIC_SetPriority(EXTI15_10_IRQn, 3);
	NVIC_EnableIRQ(EXTI15_10_IRQn);	
*/	
	// IWDG,       1
	IWDG_WriteAccessCmd(IWDG_WriteAccess_Enable);	//    IWDG
	IWDG_SetPrescaler(IWDG_Prescaler_16);			//  : .  40,  4,8,16..256
	IWDG_SetReload(0x9C4);							//   , 0xFFF - 
	IWDG_WriteAccessCmd(IWDG_WriteAccess_Disable);	//   
	//IWDG_Enable();									//  IWDG 
	
	}

void delay_ms(uint32_t ms)
	{
	volatile uint32_t nCount;
	RCC_ClocksTypeDef RCC_Clocks;
	
	RCC_GetClocksFreq (&RCC_Clocks);
	
	nCount=(RCC_Clocks.HCLK_Frequency/10000)*ms;
	for (; nCount!=0; nCount--);
	}
	
int sendchar (int data)
	{
	uint32_t i = 5000;
	
	if (target == 1) 
		{
		led_u_tx_on();
		USART_SendData(USART1, data);
		}
	if (target == 2) 
		{
		led_b_tx_on();
		USART_SendData(USART2, data);
		}
	while (--i) __NOP();
	led_u_tx_off();
	led_b_tx_off();
	return 0;
	}	

uint8_t blue_cnt = 0;
uint8_t iwdg_cnt = 0;
void TIM1_UP_TIM16_IRQHandler (void)
	{
	if (TIM_GetITStatus(TIM1, TIM_SR_UIF) != RESET)
		{
		TIM_ClearITPendingBit(TIM1, TIM_SR_UIF);

		if (++iwdg_cnt == 100) {IWDG_ReloadCounter(); iwdg_cnt = 0;}
		
		if (GPIO_ReadInputDataBit(GPIOA, GPIO_Pin_1) == 1) led_b_s1_on();
			else led_b_s1_off();  

		if (GPIO_ReadInputDataBit(GPIOA, GPIO_Pin_6) == 1) led_b_s2_on();
			else led_b_s2_off();
		
		if (mode == mode_data)
			{
			if (GPIO_ReadInputDataBit(GPIOA, GPIO_Pin_6) == 1) led_b_on();
				else led_b_off();
			}
			else
				{
				blue_cnt++;
				if (blue_cnt == 50) led_b_on();
				if (blue_cnt == 100) {led_b_off(); blue_cnt = 0;} 
				} 
		}
	}

void USART1_IRQHandler (void)
	{
	uint8_t data;

	led_u_rx_on();

	USART_ClearITPendingBit(USART1, USART_IT_RXNE);
	data = USART_ReceiveData(USART1);
	if (data == '+' && mode == mode_data) change_mode_cnt++;
		else change_mode_cnt = 0; 
	if (mode == mode_data) 
		{
		led_b_tx_on();
		USART_SendData(USART2, data);
		led_b_tx_off();

		//rx_buffer2[rx_wr_index2]=data;
		//if (++rx_wr_index2 == 64) rx_wr_index2=0;
		//if (++rx_counter2 == 64) rx_counter2=0;
		}
	if (mode == mode_cmd)
		{
		rx_buffer1[rx_wr_index1]=data;
		if (++rx_wr_index1 == RX_BUFFER_SIZE1) rx_wr_index1=0;
		if (++rx_counter1 == RX_BUFFER_SIZE1) rx_counter1=0;
		}
	led_u_rx_off();
	}

void USART2_IRQHandler (void)
	{
	uint8_t data;
	
	led_b_rx_on();
	
	USART_ClearITPendingBit(USART2, USART_IT_RXNE);
	data = USART_ReceiveData(USART2);

	led_u_tx_on();
	USART_SendData(USART1, data);
	led_u_tx_off();

	//rx_buffer3[rx_wr_index3]=data;
	//if (++rx_wr_index3 == 64) rx_wr_index3=0;
	//if (++rx_counter3 == 64) rx_counter3=0;
	
	led_b_rx_off();
	}

uint8_t getchar1 (void)
	{
	uint8_t data = 0;

	if (rx_counter1)
		{
		data=rx_buffer1[rx_rd_index1];
		if (++rx_rd_index1 == RX_BUFFER_SIZE1) rx_rd_index1=0;
		NVIC_DisableIRQ(USART1_IRQn);
		--rx_counter1;
		NVIC_EnableIRQ(USART1_IRQn);
		return data;
		}
		else return 0xff;
	}

uint8_t getchar2 (void)
	{
	uint8_t data = 0;

	if (rx_counter2)
		{
		data=rx_buffer2[rx_rd_index2];
		if (++rx_rd_index2 == 64) rx_rd_index2=0;
		NVIC_DisableIRQ(USART1_IRQn);
		--rx_counter2;
		NVIC_EnableIRQ(USART1_IRQn);
		return data;
		}
		else return 0xff;
	}

uint8_t getchar3 (void)
	{
	uint8_t data = 0;

	if (rx_counter3)
		{
		data=rx_buffer3[rx_rd_index3];
		if (++rx_rd_index3 == 64) rx_rd_index3=0;
		NVIC_DisableIRQ(USART2_IRQn);
		--rx_counter3;
		NVIC_EnableIRQ(USART2_IRQn);
		return data;
		}
		else return 0xff;
	}
