/*****************************************************************************
         .
:  ..
: 17.3.2013
*****************************************************************************/


#include <16F676.h>
#device adc=10
#FUSES NOWDT                     //No Watch Dog Timer
#FUSES INTRC_IO                  //Internal RC Osc, no CLKOUTXT      
#FUSES PUT                       //Power Up Timer
#FUSES NOMCLR                    //Master Clear pin used for I/O
#FUSES NOBROWNOUT                //No brownout reset
#use delay(clock=4000000)
#use fast_io(a)
#use fast_io(c)

int8 j,i;
int8 timer,t1=255,t2=0,t3=0,t4=0;
int16 c=0,adc_i=0,d1,d2,d3, u_min;
//-----------------------------------------------------------------------------
//     
//-----------------------------------------------------------------------------
#define lcd_sclk  PIN_C1      // lcd sclk  pin 
#define lcd_sda   PIN_C2      // lcd sda   pin 
#define lcd_dc    PIN_C5      // lcd d/c   pin
#define lcd_res   PIN_C3      // lcd res   pin

const int8 tab[]={
0x3E, 0x51, 0x49, 0x45, 0x3E,  //0    0
0x00, 0x42, 0x7F, 0x40, 0x00,  //5    1
0x42, 0x61, 0x51, 0x49, 0x46,  //10   2
0x21, 0x41, 0x45, 0x4B, 0x31,  //15   3
0x18, 0x14, 0x12, 0x7F, 0x10,  //20   4
0x27, 0x45, 0x45, 0x45, 0x39,  //25   5
0x3C, 0x4A, 0x49, 0x49, 0x30,  //30   6
0x01, 0x71, 0x09, 0x05, 0x03,  //35   7
0x36, 0x49, 0x49, 0x49, 0x36,  //40   8
0x06, 0x49, 0x49, 0x29, 0x1E,  //45   9
0x00, 0x36, 0x36, 0x00, 0x00,  //50   :
0x14, 0x08, 0x3E, 0x08, 0x14,  //55   *
0x00, 0x00, 0xA0, 0x60, 0x00,  //60   ,
0x7E, 0x11, 0x11, 0x11, 0x7E,  //65   A
0x1F, 0x20, 0x40, 0x20, 0x1F,  //70   V
0x7F, 0x08, 0x04, 0x04, 0x78,  //75   h
0x5C, 0x62, 0x02, 0x62, 0x5C,
};
//-----------------------------------------------------------------------------                 
void lcd_write_8bit(int8 data, int1 target) // serial write data or command 
{
   static int8 i;
   if(target) output_high(lcd_dc); //write data
   else output_low(lcd_dc);        //write com
   for (i=8;i>0;i--)
   {
        output_low(lcd_sclk);
        if (data&0x80) output_high(lcd_sda);
        else output_low(lcd_sda);  
        output_high(lcd_sclk);
        data<<=1;
   }
}
//-----------------------------------------------------------------------------
void lcd_gotoxy(int8 x, int8 y)         // Nokia LCD 3310 Position cursor
{   
   lcd_write_8bit(0x40|(y&0x07),0);     // Y : 0100 0yyy Y=0-5 possible
   lcd_write_8bit(0x80|(x&0x7f),0);     // X : 1xxx xxxx X=0-83 possible
}
//-----------------------------------------------------------------------------
void lcd_clear() 
{
   lcd_gotoxy(0,0);         // 84*6=504      clear LCD
   for (i=84; i>0; i--)
   for (j=48; j>0; j--)
   lcd_write_8bit(0x00,1);
}
//-----------------------------------------------------------------------------
void lcd_init(void)
{
    delay_ms(10);
    output_high(lcd_dc);            
    output_low(lcd_res);            // reset chip during 10ms
    delay_ms(250);                   
    output_high(lcd_res);
    lcd_write_8bit(0x21,0);         // set extended instruction set
    lcd_write_8bit(0xc2,0);         // Vop  v3: 0xc2 (2v6-5v)  
    lcd_write_8bit(0x13,0);         // bias
    lcd_write_8bit(0x20,0);         // horizontal mode, X incremented automatically
    lcd_write_8bit(0x09,0);         // all on
    lcd_clear();                    // reset DDRA
    lcd_write_8bit(0x08,0);         // mod control blank change (all off)
    lcd_write_8bit(0x0c,0);         // mod control normal change
}
//-----------------------------------------------------------------------------
void lcd_print_ch (int8 c)
{
    for(j=0;j<5;j++) lcd_write_8bit(tab[c+j],1);
    lcd_write_8bit(0x00,1);
}
//-----------------------------------------------------------------------------
//   
//-----------------------------------------------------------------------------
#int_TIMER1
void  TIMER1_isr(void) 
{
    set_timer1(3036);
    timer++;
}
//-----------------------------------------------------------------------------
int16 get_adc(int1 m)
{
    int16 adc_rez,adc_temp;
    adc_rez=0;
    if(m) set_adc_channel(2);
    else  set_adc_channel(0);
    delay_us(20);
    for(j=0;j<8;j++) 
    {
        adc_temp = read_adc();
        adc_rez+=adc_temp;
    }
    adc_rez/=8;
    if(!m) adc_rez*=5;
    return adc_rez;
}
//-----------------------------------------------------------------------------
void d_calc(int16 data)
{
    d1=(data/1000);         //  
    d2=((data/100)%10);     //  
    d3=((data/10)%10);      //  
}
//-----------------------------------------------------------------------------
void d_print(char x,char y)
{
    lcd_gotoxy(x,y);
    lcd_print_ch(d1*5);
    lcd_print_ch(60);
    lcd_print_ch(d2*5);
    lcd_print_ch(d3*5);
}
//-----------------------------------------------------------------------------
void cap_test()
{
    c=c+(adc_i/6);
    d_calc(c/10);
    d_print(20,2);
    lcd_print_ch(65);
    lcd_print_ch(55); 
    lcd_print_ch(75);//A*h
}
//-----------------------------------------------------------------------------
void time_test()
{
    if(t1==9)
    {
        t1=0;
        if(t2==5)
        {
            t2=0;
            if(t3==9)
            {
                t3=0;
                t4++;
            }
            else t3++;
        }
        else t2++;
    }
    else t1++;
    lcd_gotoxy(48,4);lcd_print_ch(t4*5);lcd_print_ch(t3*5);
    lcd_print_ch(50);lcd_print_ch(t2*5);lcd_print_ch(t1*5);
}

//-----------------------------------------------------------------------------
//  
//-----------------------------------------------------------------------------
void main()
{
    int16 adc_u,u1,i1,r;  
    int8 sec=255;
    
    setup_adc_ports(sAN0|sAN2|VSS_VREF);
    setup_adc(ADC_CLOCK_INTERNAL);
    setup_timer_1(T1_INTERNAL|T1_DIV_BY_8);      //524 ms overflow
    setup_comparator(NC_NC);
    set_tris_a(0xff);port_a_pullups(0x38);
    set_tris_c(0); output_c(0);
    lcd_init();
    set_timer1(3036);
    enable_interrupts(INT_TIMER1);    
    enable_interrupts(GLOBAL);
    
    //    
    if(!input(pin_a4))
    {
        output_high(pin_c4);
        timer=0;
        while(timer!=20){}
        u1=get_adc(0); 
        i1=get_adc(1); 
        output_low(pin_c4);
        output_high(pin_c0);
        timer=0;
        while(timer!=6){}
        adc_u=get_adc(0); 
        adc_i=get_adc(1);   
        output_low(pin_c0);
        disable_interrupts(GLOBAL);
        
        u1-=adc_u;
        u1*=100;
        adc_i-=i1;
        r=u1/adc_i;
        d_calc(r*10);
        d_print(26,2);
        lcd_print_ch(80);
        while(1) {}
    }

    //  
    lcd_gotoxy(30,0);lcd_print_ch(70); //V
    lcd_gotoxy(72,0);lcd_print_ch(65); //A
    lcd_gotoxy(30,4);lcd_print_ch(70); //V
    time_test();cap_test();
          
    //  
    u_min=3500;
    d_calc(u_min);
    d_print(6,4);
    output_high(pin_c0);
   
    while(1)
    {
        timer=0; sec++;
        //,    U  I 
        adc_u=get_adc(0); 
        adc_i=get_adc(1);
        d_calc(adc_u);
        d_print(6,0);
        d_calc(adc_i);
        d_print(48,0);
          
        // ,   
        if(!input(pin_a5))
        {
            if(u_min==2500) u_min=3500;
            else u_min-=50;
            d_calc(u_min);
            d_print(6,4);
        }
        //     
        if (adc_u<=u_min)
        {
            output_low(pin_c0);
            lcd_clear();
            cap_test();
            while(1) {} 
        }
        //  
        if(sec==60) 
        { 
            sec=0;
            time_test();//   
            cap_test(); //    
        }
        //  
         while(timer!=2) {}
    }
    
}

