#include <stdio.h>
#include <windows.h>
#include "CyUSBSerial.h"
  
int main(int argc, char* argv[])
{
    CY_VID_PID cyVidPid;								// we uses Cypress VID/PID here
    cyVidPid.vid = 0x04B4;	
    cyVidPid.pid = 0x0004; 
	CY_RETURN_STATUS rStatus;							// return values from USB Serial APIs

	// STEP I: DISCOVER USB-SPI DEVICE
	unsigned char deviceID[16];							// storage for discovered device IDs
	CY_DEVICE_INFO cyDeviceInfoList[16];				// ... and their info lists
	UINT8 cyNumDevices;									// # of discovered devices
    rStatus = CyGetDeviceInfoVidPid (cyVidPid, deviceID, (PCY_DEVICE_INFO)&cyDeviceInfoList, &cyNumDevices, 16);

    int deviceIndexAtSCB0 = -1;							// device index for API calls
    for (int index = 0; index < cyNumDevices; index++)
	{              
        if (cyDeviceInfoList[index].deviceBlock == SerialBlock_SCB0 &&
			cyDeviceInfoList[index].deviceType[0] == CY_TYPE_SPI)
		{
            deviceIndexAtSCB0 = index;
			break;
		}
	}
	if (deviceIndexAtSCB0 < 0)							// exit if no appropriate device is found
	{
		printf("Device not found.\n");
		return(1);
	}

	// STEP II: OPEN CONNECTION WITH USB-SPI DEVICE
    printf ("Opening USB-SPI device with device number %d...\n", deviceIndexAtSCB0);
	CY_HANDLE cyHandle;									// CY7C65211 device handle 
    rStatus = CyOpen (deviceIndexAtSCB0, 0, &cyHandle);	// open the device, use interface #0
    if (rStatus != CY_SUCCESS){
        printf ("SPI Device open failed...\n");
        return rStatus;
	}

	// STEP III: CONFIGURE USB-SPI DEVICE FOR SPI COMMUNICATION
    printf("Setting SPI configuration...\n");
	CY_SPI_CONFIG cySPIConfig;
	cySPIConfig.frequency = 1000000;
    cySPIConfig.dataWidth = 8;
    cySPIConfig.protocol = CY_SPI_MOTOROLA;
	cySPIConfig.isMsbFirst = true;
	cySPIConfig.isMaster = true;
    cySPIConfig.isContinuousMode = true;
    cySPIConfig.isSelectPrecede = false; 
    cySPIConfig.isCpha = false;
    cySPIConfig.isCpol = false; 
    rStatus = CySetSpiConfig (cyHandle, &cySPIConfig);
    if (rStatus != CY_SUCCESS){
        printf ("CySetSpiConfig returned failure code.\n");
        return rStatus;
    }

	CY_DATA_BUFFER cyDatabufferWrite, cyDatabufferRead; 
	unsigned char wBuffer[4], rBuffer[4];
    cyDatabufferWrite.buffer = wBuffer;
    cyDatabufferRead.buffer = rBuffer;

	// STEP IV: SENSOR COMMUNICATION
	cyDatabufferWrite.length = 2;						// write 2 bytes
	wBuffer[0] = 0x20;									// CTRL_REG1 address
	wBuffer[1] = 0x88;									// power up, SPI mode
	rStatus = CySpiReadWrite (cyHandle, NULL, &cyDatabufferWrite, 5000);

	cyDatabufferWrite.length = 3;						// write 3 bytes
	wBuffer[0] = 0x79;									// RPDS_L address
	wBuffer[1] = 0x30;									// set -13*4096 hPa
	wBuffer[2] = 0xFF;									// pressure correction
	rStatus = CySpiReadWrite (cyHandle, NULL, &cyDatabufferWrite, 5000);

	cyDatabufferWrite.length = 2;						// write 2 bytes
	wBuffer[0] = 0x21;									// CTRL_REG2 address
	wBuffer[1] = 0x01;									// start conversion
	rStatus = CySpiReadWrite (cyHandle, NULL, &cyDatabufferWrite, 5000);

	cyDatabufferWrite.length = 4;						// write 4 bytes
	cyDatabufferRead.length = 4;						// and read 3 bytes
	wBuffer[0] = 0xE8;									// PRESS_OUT_XL address
	memset (&wBuffer[1], 0x00, 3);						// fill out with 0's
	memset (&rBuffer[0], 0x00, 4);						
	rStatus = CySpiReadWrite (cyHandle, &cyDatabufferRead, &cyDatabufferWrite, 5000);

	int pressHp = ((rBuffer[3] << 16) + (rBuffer[2] << 8) + rBuffer[1]) >> 12;
	int pressMm = (pressHp * 3) >> 2;
	printf("Pressure = %d hPa  = %d mmHg\n", pressHp, pressMm);
    
	// STEP V: CLOSING USB-SPI DEVICE
	CyClose(cyHandle);									// close the device
    return 0;
}



