#include <stdio.h>
#include <windows.h>
#include "CyUSBSerial.h"

int main(int argc, char* argv[])
{
    CY_VID_PID cyVidPid;								// we uses Cypress VID/PID here
    cyVidPid.vid = 0x04B4;
    cyVidPid.pid = 0x0004;
	CY_RETURN_STATUS rStatus;							// return values from USB Serial APIs

	// STEP I: DISCOVER USB-I2C DEVICE
	unsigned char deviceID[16];							// storage for discovered device IDs
	CY_DEVICE_INFO cyDeviceInfoList[16];				// ... and their info lists
	UINT8 cyNumDevices;									// # of discovered devices
    rStatus = CyGetDeviceInfoVidPid (cyVidPid, deviceID, (PCY_DEVICE_INFO)&cyDeviceInfoList, &cyNumDevices, 16);

    int deviceIndexAtSCB0 = -1;							// device index for API calls
    for (int index = 0; index < cyNumDevices; index++)
	{
        if (cyDeviceInfoList[index].deviceBlock == SerialBlock_SCB0 &&
			cyDeviceInfoList[index].deviceType[0] == CY_TYPE_I2C)
		{
            deviceIndexAtSCB0 = index;
			break;
		}
	}
	if (deviceIndexAtSCB0 < 0)							// exit if no appropriate device is found
	{
		printf("Device not found.\n");
		return(1);
	}

	// STEP II: OPEN CONNECTION WITH USB-I2C DEVICE
    printf ("Opening USB-I2C device with device number %d...\n", deviceIndexAtSCB0);
	CY_HANDLE cyHandle;									// CY7C65211 device handle
    rStatus = CyOpen (deviceIndexAtSCB0, 0, &cyHandle);	// open the device, use interface #0
    if (rStatus != CY_SUCCESS){
        printf ("I2C Device open failed...\n");
        return rStatus;
	}

	// STEP III: CONFIGURE USB-I2C DEVICE FOR I2C COMMUNICATION
    printf("Setting I2C configuration...\n");
	CY_I2C_CONFIG cyI2CConfig;							// set I2C configuration
    cyI2CConfig.frequency = 100000;						// set 100 KHz I2C clocking frequency
	cyI2CConfig.slaveAddress = 0x60;					// device slave I2C address (NOT USED)
    cyI2CConfig.isMaster = 1;							// set master mode
	cyI2CConfig.isClockStretch = false;					// no clock stretching
    rStatus = CySetI2cConfig (cyHandle, &cyI2CConfig);	// apply settings
    if (rStatus != CY_SUCCESS){
        printf ("CySetI2cConfig returned failure code.\n");
        return rStatus;
	}

	CY_I2C_DATA_CONFIG cyI2CDataConfig;
	cyI2CDataConfig.slaveAddress = 0x5C;				// sensor slave address
	cyI2CDataConfig.isStopBit = true;					// use stop bit after write operation
    cyI2CDataConfig.isNakBit = true;					// send NAK for the last received byte

	unsigned char I2CBuffer[4];							// I2C I/O buffer
	memset(I2CBuffer, 0, 4);							// fill it with 0's
	CY_DATA_BUFFER cyDatabuffer;
	cyDatabuffer.buffer = I2CBuffer;

	// STEP IV: SENSOR COMMUNICATION
	cyDatabuffer.length = 2;							// write 2 bytes
	I2CBuffer[0] = 0x20;								// CTRL_REG1 address
	I2CBuffer[1] = 0x80;								// power up
	rStatus = CyI2cWrite (cyHandle, &cyI2CDataConfig, &cyDatabuffer, 5000);

	cyDatabuffer.length = 3;							// write 3 bytes
	I2CBuffer[0] = 0xB9;								// RPDS_L address
	I2CBuffer[1] = 0x30;								// set -13*4096 hPa
	I2CBuffer[2] = 0xFF;
	rStatus = CyI2cWrite (cyHandle, &cyI2CDataConfig, &cyDatabuffer, 5000);

	cyDatabuffer.length = 2;							// write 2 bytes
	I2CBuffer[0] = 0x21;								// CTRL_REG2 address
	I2CBuffer[1] = 0x01;								// do conversion
	rStatus = CyI2cWrite (cyHandle, &cyI2CDataConfig, &cyDatabuffer, 5000);

	cyI2CDataConfig.isStopBit = false;					// no stop after reg. address
	cyDatabuffer.length = 1;							// write 1 byte
	I2CBuffer[0] = 0xA8;								// PRESS_OUT_XL address
	rStatus = CyI2cWrite (cyHandle, &cyI2CDataConfig, &cyDatabuffer, 5000);
	cyI2CDataConfig.isStopBit = true;					// generate stop at the end
	cyDatabuffer.length = 3;							// read 3 bytes
	rStatus = CyI2cRead (cyHandle, &cyI2CDataConfig, &cyDatabuffer, 5000);

	int pressHp = (I2CBuffer[2]*256*256 + I2CBuffer[1]*256 + I2CBuffer[0])/4096;
	int pressMm = (int)(pressHp * 0.75);
	printf("Pressure = %d hPa  = %d mmHg\n", pressHp, pressMm);

	// PART V: CLOSING USB-I2C DEVICE
	CyClose(cyHandle);									// close the device
    return 0;
}

