/*****************************************************
Chip type               : ATmega8
Program type            : Application
AVR Core Clock frequency: 8,000000 MHz
Memory model            : Small
External RAM size       : 0
Data Stack size         : 256
*****************************************************/

#include <mega8.h>

#include <delay.h>

#define led1 PORTD.3
#define led2 PORTD.2
#define led3 PORTD.4
#define led4 PORTD.1
#define led5 PORTB.6
#define led6 PORTD.0

#define but !PINC.5

#define temp1 0
#define temp2 1
#define temp3 2
#define temp4 3
#define temp5 6
#define temp6 7

unsigned char temp_index = 1;

unsigned int temp_array[6];

unsigned char screen_buf[4];


void print2screen (unsigned char dig1, unsigned char dig2, unsigned char sign)
	{
        
        switch (dig1)
        	{                       //B_fedcab                    g-A_____
                case 0: screen_buf[0] = 0b11000000; screen_buf[1] = 0b11011111; break;
                case 1: screen_buf[0] = 0b11111010; screen_buf[1] = 0b11011111; break;
                case 2: screen_buf[0] = 0b11100100; screen_buf[1] = 0b01011111; break;
                case 3: screen_buf[0] = 0b11110000; screen_buf[1] = 0b01011111; break;
                case 4: screen_buf[0] = 0b11011010; screen_buf[1] = 0b01011111; break;
                case 5: screen_buf[0] = 0b11010001; screen_buf[1] = 0b01011111; break;
                case 6: screen_buf[0] = 0b11000001; screen_buf[1] = 0b01011111; break;
                case 7: screen_buf[0] = 0b11111000; screen_buf[1] = 0b11011111; break;
                case 8: screen_buf[0] = 0b11000000; screen_buf[1] = 0b01011111; break;
                case 9: screen_buf[0] = 0b11010000; screen_buf[1] = 0b01011111;
                }
        switch (dig2)
        	{                       //B_fedcab                    g-A_____
                case 0: screen_buf[2] = 0b01000000; screen_buf[3] = 0b11111111; break;
                case 1: screen_buf[2] = 0b01111010; screen_buf[3] = 0b11111111; break;
                case 2: screen_buf[2] = 0b01100100; screen_buf[3] = 0b01111111; break;
                case 3: screen_buf[2] = 0b01110000; screen_buf[3] = 0b01111111; break;
                case 4: screen_buf[2] = 0b01011010; screen_buf[3] = 0b01111111; break;
                case 5: screen_buf[2] = 0b01010001; screen_buf[3] = 0b01111111; break;
                case 6: screen_buf[2] = 0b01000001; screen_buf[3] = 0b01111111; break;
                case 7: screen_buf[2] = 0b01111000; screen_buf[3] = 0b11111111; break;
                case 8: screen_buf[2] = 0b01000000; screen_buf[3] = 0b01111111; break;
                case 9: screen_buf[2] = 0b01010000; screen_buf[3] = 0b01111111;
                }
        if (sign) 
        	{
                screen_buf[1] &= 0b10111111; screen_buf[3] &= 0b10111111;
                }  
        }


unsigned char disp_cnt = 0;
unsigned char but_cnt = 0, but1_cnt = 0;
// Timer 0 overflow interrupt service routine
interrupt [TIM0_OVF] void timer0_ovf_isr(void)
        {
        TCNT0=0xE6;
        #asm("wdr")
        
        disp_cnt++;
        if (disp_cnt == 1)
        	{
                PORTB |= 0b10111111;
                PORTD |= 0b11100000;
                PORTB &= screen_buf[0];
                PORTD &= screen_buf[1];
                }
        if (disp_cnt == 2)
        	{
                PORTB |= 0b10111111;
                PORTD |= 0b11100000;
                PORTB &= screen_buf[2];
                PORTD &= screen_buf[3];
                disp_cnt = 0;
                }
                
        if (++but_cnt == 20)
                {
                but_cnt = 0;
			
                if (but && but1_cnt == 0)
                        {
                        but1_cnt++;
                        if (++temp_index == 7) temp_index = 1;
                        }
                if (but && ++but1_cnt == 20) but1_cnt = 0;
                if (!but) but1_cnt = 0;
        	}
        }

#define ADC_VREF_TYPE 0xC0

// Read the AD conversion result
unsigned int read_adc(unsigned char adc_input)
{
ADMUX=adc_input | (ADC_VREF_TYPE & 0xff);
// Delay needed for the stabilization of the ADC input voltage
delay_us(10);
// Start the AD conversion
ADCSRA|=0x40;
// Wait for the AD conversion to complete
while ((ADCSRA & 0x10)==0);
ADCSRA|=0x10;
return ADCW;
}

// Declare your global variables here

void main(void)
{
// Declare your local variables here

// Input/Output Ports initialization
// Port B initialization
// Func7=Out Func6=Out Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out 
// State7=1 State6=0 State5=1 State4=1 State3=1 State2=1 State1=1 State0=1 
PORTB=0xBF;
DDRB=0xFF;

// Port C initialization
// Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State6=T State5=P State4=T State3=T State2=T State1=T State0=T 
PORTC=0x20;
DDRC=0x00;

// Port D initialization
// Func7=Out Func6=Out Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out 
// State7=1 State6=1 State5=1 State4=0 State3=0 State2=0 State1=0 State0=0 
PORTD=0xE0;
DDRD=0xFF;

// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: 7,813 kHz
TCCR0=0x05;
TCNT0=0xE6;

// Timer/Counter 1 initialization
// Clock source: System Clock
// Clock value: Timer1 Stopped
// Mode: Normal top=0xFFFF
// OC1A output: Discon.
// OC1B output: Discon.
// Noise Canceler: Off
// Input Capture on Falling Edge
// Timer1 Overflow Interrupt: Off
// Input Capture Interrupt: Off
// Compare A Match Interrupt: Off
// Compare B Match Interrupt: Off
TCCR1A=0x00;
TCCR1B=0x00;
TCNT1H=0x00;
TCNT1L=0x00;
ICR1H=0x00;
ICR1L=0x00;
OCR1AH=0x00;
OCR1AL=0x00;
OCR1BH=0x00;
OCR1BL=0x00;

// Timer/Counter 2 initialization
// Clock source: System Clock
// Clock value: Timer2 Stopped
// Mode: Normal top=0xFF
// OC2 output: Disconnected
ASSR=0x00;
TCCR2=0x00;
TCNT2=0x00;
OCR2=0x00;

// External Interrupt(s) initialization
// INT0: Off
// INT1: Off
MCUCR=0x00;

// Timer(s)/Counter(s) Interrupt(s) initialization
TIMSK=0x01;

// USART initialization
// USART disabled
UCSRB=0x00;

// Analog Comparator initialization
// Analog Comparator: Off
// Analog Comparator Input Capture by Timer/Counter 1: Off
ACSR=0x80;
SFIOR=0x00;

// ADC initialization
// ADC Clock frequency: 62,500 kHz
// ADC Voltage Reference: Int., cap. on AREF
ADMUX=ADC_VREF_TYPE & 0xff;
ADCSRA=0x87;

// SPI initialization
// SPI disabled
SPCR=0x00;

// TWI initialization
// TWI disabled
TWCR=0x00;

// Watchdog Timer initialization
// Watchdog Timer Prescaler: OSC/2048k
#pragma optsize-
WDTCR=0x1F;
WDTCR=0x0F;
#ifdef _OPTIMIZE_SIZE_
#pragma optsize+
#endif

print2screen (0, 0, 0);

// Global enable interrupts
#asm("sei")

led1 = 1; led2 = 0; led3 = 0; led4 = 0; led5 = 0; led6 = 0; 
delay_ms(100);
led1 = 0; led2 = 1; led3 = 0; led4 = 0; led5 = 0; led6 = 0;
delay_ms(100);
led1 = 0; led2 = 0; led3 = 1; led4 = 0; led5 = 0; led6 = 0;
delay_ms(100);
led1 = 0; led2 = 0; led3 = 0; led4 = 1; led5 = 0; led6 = 0;
delay_ms(100);
led1 = 0; led2 = 0; led3 = 0; led4 = 0; led5 = 1; led6 = 0;
delay_ms(100);
led1 = 0; led2 = 0; led3 = 0; led4 = 0; led5 = 0; led6 = 1;
delay_ms(100);
led1 = 0; led2 = 0; led3 = 0; led4 = 0; led5 = 0; led6 = 0;

while (1)
	{
      	switch (temp_index)
        	{
                case 1: {
                        temp_array[0] = (read_adc(temp1)+read_adc(temp1)+read_adc(temp1)+read_adc(temp1)+read_adc(temp1)+read_adc(temp1)+read_adc(temp1)+read_adc(temp1)+read_adc(temp1)+read_adc(temp1))/4; 
        			if (temp_array[0] %10 >= 5) temp_array[0] = temp_array[0]/10+1;
        				else temp_array[0] = temp_array[0]/10;
                        led1 = 1; led2 = 0; led3 = 0; led4 = 0; led5 = 0; led6 = 0; 
                        if (temp_array[0]<50) print2screen((50-temp_array[0])/10, (50-temp_array[0])%10, 1);
                        	else print2screen ((temp_array[0]-50)/10, (temp_array[0]-50)%10, 0);
                        } break;
                case 2: {
                        temp_array[1] = (read_adc(temp2)+read_adc(temp2)+read_adc(temp2)+read_adc(temp2)+read_adc(temp2)+read_adc(temp2)+read_adc(temp2)+read_adc(temp2)+read_adc(temp2)+read_adc(temp2))/4; 
        			if (temp_array[1] %10 >= 5) temp_array[1] = temp_array[1]/10+1;
        				else temp_array[1] = temp_array[1]/10;
                        led1 = 0; led2 = 1; led3 = 0; led4 = 0; led5 = 0; led6 = 0; 
                        if (temp_array[1]<50) print2screen((50-temp_array[1])/10, (50-temp_array[1])%10, 1);
                        	else print2screen ((temp_array[1]-50)/10, (temp_array[1]-50)%10, 0);
                        } break;
                case 3: {
                        temp_array[2] = (read_adc(temp3)+read_adc(temp3)+read_adc(temp3)+read_adc(temp3)+read_adc(temp3)+read_adc(temp3)+read_adc(temp3)+read_adc(temp3)+read_adc(temp3)+read_adc(temp3))/4; 
       			 	if (temp_array[2] %10 >= 5) temp_array[2] = temp_array[2]/10+1;
        				else temp_array[2] = temp_array[2]/10;
                        led1 = 0; led2 = 0; led3 = 1; led4 = 0; led5 = 0; led6 = 0; 
                        if (temp_array[2]<50) print2screen((50-temp_array[2])/10, (50-temp_array[2])%10, 1);
                        	else print2screen ((temp_array[2]-50)/10, (temp_array[2]-50)%10, 0);
                        } break;
                case 4: {
                        temp_array[3] = (read_adc(temp4)+read_adc(temp4)+read_adc(temp4)+read_adc(temp4)+read_adc(temp4)+read_adc(temp4)+read_adc(temp4)+read_adc(temp4)+read_adc(temp4)+read_adc(temp4))/4; 
        			if (temp_array[3] %10 >= 5) temp_array[3] = temp_array[3]/10+1;
        				else temp_array[3] = temp_array[3]/10;
                        led1 = 0; led2 = 0; led3 = 0; led4 = 1; led5 = 0; led6 = 0; 
                        if (temp_array[3]<50) print2screen((50-temp_array[3])/10, (50-temp_array[3])%10, 1);
                        	else print2screen ((temp_array[3]-50)/10, (temp_array[3]-50)%10, 0);
                        } break;
                case 5: {
                        temp_array[4] = (read_adc(temp5)+read_adc(temp5)+read_adc(temp5)+read_adc(temp5)+read_adc(temp5)+read_adc(temp5)+read_adc(temp5)+read_adc(temp5)+read_adc(temp5)+read_adc(temp5))/4; 
        			if (temp_array[4] %10 >= 5) temp_array[4] = temp_array[4]/10+1;
        				else temp_array[4] = temp_array[4]/10;
                        led1 = 0; led2 = 0; led3 = 0; led4 = 0; led5 = 1; led6 = 0; 
                        if (temp_array[4]<50) print2screen((50-temp_array[4])/10, (50-temp_array[4])%10, 1);
                        	else print2screen ((temp_array[4]-50)/10, (temp_array[4]-50)%10, 0);
                        } break;
                case 6: {
                        temp_array[5] = (read_adc(temp6)+read_adc(temp6)+read_adc(temp6)+read_adc(temp6)+read_adc(temp6)+read_adc(temp6)+read_adc(temp6)+read_adc(temp6)+read_adc(temp6)+read_adc(temp6))/4; 
        			if (temp_array[5] %10 >= 5) temp_array[5] = temp_array[5]/10+1;
        				else temp_array[5] = temp_array[5]/10;  
                        led1 = 0; led2 = 0; led3 = 0; led4 = 0; led5 = 0; led6 = 1; 
                        if (temp_array[5]<50) print2screen((50-temp_array[5])/10, (50-temp_array[5])%10, 1);
                        	else print2screen ((temp_array[5]-50)/10, (temp_array[5]-50)%10, 0);
                        } 
                } 
        delay_ms(500);
	}
}
