	INCLUDE MKL05Z4.inc		; CPU register definitions
	AREA	STACK, NOINIT, READWRITE, ALIGN=3	
stmem	SPACE	0x100			; stack size
top_of_stack		

	AREA    |.ARM.__at_0x400|, CODE, READONLY
	DCB     0xFF, 0xFF, 0xFF, 0xFF
	DCB     0xFF, 0xFF, 0xFF, 0xFF
	DCB     0xFF, 0xFF, 0xFF, 0xFF
	DCB     0xFE, 0xFF, 0xFF, 0xFF	; disable FLASH security

	EXPORT	__Vectors
	AREA    RESET, DATA, READONLY	; Vector Table mapped to address 0 at reset
__Vectors
	DCD     top_of_stack  		; Top of Stack
	DCD     Reset_Handler  		; Reset Handler
	DCD     Default_Handler  	; NMI Handler
	DCD     Default_Handler  	; Hard Fault Handler		
	DCD     0  			; Reserved
	DCD     0  			; Reserved
	DCD     0  			; Reserved
	DCD     0  			; Reserved
	DCD     0  			; Reserved
	DCD     0  			; Reserved
	DCD     0  			; Reserved
	DCD     Default_Handler  	; SVCall Handler
	DCD     0  			; Reserved
	DCD     0  			; Reserved
	DCD     Default_Handler  	; PendSV Handler	
	DCD     Default_Handler  	; SysTick Handler

	; External Interrupts
	DCD     Default_Handler  	; DMA channel 0 transfer complete/error interrupt
	DCD     Default_Handler  	; DMA channel 1 transfer complete/error interrupt
	DCD     Default_Handler  	; DMA channel 2 transfer complete/error interrupt
	DCD     Default_Handler  	; DMA channel 3 transfer complete/error interrupt
 	DCD     Default_Handler  	; Reserved interrupt 20
 	DCD     Default_Handler  	; FTFA command complete/read collision interrupt
 	DCD     Default_Handler  	; Low Voltage Detect, Low Voltage Warning
	DCD     LLWU_ISR  		; Low Leakage Wakeup
	DCD     I2C_ISR  		; I2C0 interrupt
 	DCD     Default_Handler  	; Reserved interrupt 25
 	DCD     Default_Handler  	; SPI0 interrupt
 	DCD     Default_Handler  	; Reserved interrupt 27
	DCD     Default_Handler  	; UART0 status/error interrupt
 	DCD     Default_Handler  	; Reserved interrupt 29
 	DCD     Default_Handler  	; Reserved interrupt 30
  	DCD     Default_Handler 	; ADC0 interrupt
 	DCD     Default_Handler  	; CMP0 interrupt
	DCD     Default_Handler  	; TPM0 fault, overflow and channels interrupt
  	DCD     Default_Handler  	; TPM1 fault, overflow and channels interrupt
 	DCD     Default_Handler  	; Reserved interrupt 35
 	DCD     Default_Handler  	; RTC interrupt
  	DCD     Default_Handler  	; RTC seconds interrupt
	DCD     Default_Handler  	; PIT timer interrupt
  	DCD     Default_Handler  	; Reserved interrupt 39
  	DCD     Default_Handler  	; Reserved interrupt 40
  	DCD     Default_Handler  	; DAC0 interrupt
  	DCD     Default_Handler  	; TSI0 interrupt
  	DCD     Default_Handler  	; MCG interrupt
  	DCD     LPTMR0_ISR  		; LPTimer interrupt
	DCD     Default_Handler  	; Reserved interrupt 45
  	DCD     Default_Handler  	; Port A interrupt
  	DCD     Default_Handler  	; Port B interrupt

	EXPORT	Reset_Handler
	PRESERVE8
	THUMB				; use thumb instruction set	
	AREA    |.text|, CODE, READONLY
Reset_Handler	PROC
	IMPORT	start
	ENTRY	
	IOANDB	SIM_COPC, 0xF3		; turn off COP (watchdog)

	ldr	R0, =start		; jump to main code
	bx 	R0
	ENDP

;--------------------------------------------------------------------
LLWU_ISR	
LPTMR0_ISR	PROC			; low-power timer ISR
	IOORB	LPTMR0_CSR, 0xC1	; clear timer interrupt
	SETH	GPIOA_PTOR, 0x03E0	; toggle LCD pins of PORT_A
	SETH	GPIOB_PTOR, 0x0CFF	; toggle LCD pins of PORT_B	
	subs	R7, #1			; update LCD refresh counter
	bne	L1			; time to update LCD?
	movs	R7, #60			; YES - restore the counter
	SETW	SCB_SCR, 0x0		; disable VLPS/LSS sleep mode
L1	bx	LR
	ENDP

;--------------------------------------------------------------------
I2C_ISR	PROC
	SETB	I2C0_S, 0x02		; clear I2C interrupt flag
	bx	LR
	ENDP
	
;--------------------------------------------------------------------
Default_Handler	PROC			; default ISR placeholder
	b	.
	ENDP
	ALIGN
	END
