	INCLUDE MKL05Z4.inc		; CPU register definitions
	EXPORT	start
	
	IMPORT	MCG_setup
	IMPORT	SMC_setup
	IMPORT	PORTS_setup
	IMPORT	I2C_setup
	IMPORT	LPTMR0_setup
	
	PRESERVE8
	THUMB				; use thumb instruction set
	AREA    |.text|, CODE, READONLY
;----------------------------------------------------------------------------
start	PROC				; main user code
	CALL	MCG_setup		; configure clock for VLPR mode
	CALL	SMC_setup		; enable clocks to peripherals
	CALL	PORTS_setup		; I/O ports setup
	CALL	I2C_setup		; setup I2C module
	CALL	LPTMR0_setup		; setup low-power timer
	
	CALL	Request_Conversion	; request first temp conversion

	ldr	R0, =Table7Seg1		; set table pointers to LCD
	mov	R8, R0			;  7-seg tables
	ldr	R0, =Table7Seg2		; pointer for the 2nd digit
	mov	R9, R0
	movs	R7, #60			; LCD refresh 1/2 period in msec

loop					; MAIN LOOP
	SETW	SCB_SCR, 0x06		; enable VLPS/LSS sleep mode
	wfi				; enter deep sleep mode
	CALL    Read_Temp       	; read TEMP from sensor 
	CALL    Request_Conversion      ; request new conversion  	
	CALL    Display_Temp  		; update TEMP on LCD
	b	loop
	ENDP

;----------------------------------------------------------------------------
Request_Conversion	PROC		; request one-shot TEMP conversion
	ldr	R2, =I2C0_C1
	movs	R1, #0xD0		
	strb	R1, [R2]		; enable I2C module TX, and interrupt
	movs	R1, #0xF0
	strb	R1, [R2]		; generate START condition
	
	SETB	I2C0_D, 0x90		; send slave address
	wfi
	movs	R1, #0x01
	strb	R1, [R0]		; send sensor config address
	wfi
	movs	R1, #0xE1
	strb	R1, [R0]		; request one-shot conversion
	wfi

	movs	R1, #0xD0
	strb	R1, [R2]		; generate STOP condition
	movs	R1, #0
	strb	R1, [R2]		; disable I2C module
	bx	LR
	ENDP
	
;----------------------------------------------------------------------------
Read_Temp	PROC			; read TEMP form sensor in R2
	ldr	R2, =I2C0_C1
	movs	R1, #0xD0
	strb	R1, [R2]		; enable I2C module and interrupt
	movs	R1, #0xF0
	strb	R1, [R2]		; generate START condition
	
	SETB	I2C0_D, 0x90		; send slave address + write
	wfi
	movs	R1, #0
	strb	R1, [R0]		; send temp register address
	wfi
	movs	R1, #0xF4		
	strb	R1, [R2]		; generate RESTART condition
	movs	R1, #0x91
	strb	R1, [R0]		; send slave address + read
	wfi
	
	movs	R1, #0xE0
	strb	R1, [R2]		; set receive mode	
	ldrb	R3, [R0]		; initiate master receive 
	wfi
	movs	R1, #0xE8
	strb	R1, [R2]		; prepare to send NACK	
	ldrb	R3, [R0]		; save 1st byte in R3 
	wfi	
	
	movs	R1, #0xD0
 	strb	R1, [R2]		; generate STOP condition
	ldrb	R1, [R0]		; save 2nd byte in R1
	revsh	R3, R3
	orrs	R3, R1			; R3 = temp	

	movs	R1, #0
	strb	R1, [R2]		; disable I2C module
	bx	LR
	ENDP
	
;----------------------------------------------------------------------------
Display_Temp	PROC			; convert R3 into BCD and display
	adds	R3, #0x80		; rounding
	asrs	R3, #8			; leave only int part

	movs	R5, #26			; bin to BCD conversion	
	muls	R5, R3, R5		; works fine for R3 < 69
	lsrs	R5, #8			; R5 = tens of temp

	movs	R6, #10
	muls	R6, R5, R6		; R6 = R5*10
	subs	R6, R3, R6		; R6 = units of temp

	lsls	R3, R5, #2		; R3 = digit offset in table_1
	add	R3, R8			; R3 = data address of 1st digit
	ldrh	R1, [R3]		; R1 = 1st digit code for PORT_A
	ldrh	R2, [R3, #2]		; R2 = 1st digit code for PORT_B

	lsls	R3, R6, #2		; R3 = digit offset in table_2
	add	R3, R9			; R3 = data address of 2nd digit
	ldrh	R0, [R3]		; R0 = 2nd digit code for PORT_A
	ldrh	R3, [R3, #2]		; R3 = 2nd digit code for PORT_B
	orrs	R1, R0			; R1 = code to load to PORT_A
	orrs	R2, R3			; R2 = code to load to PORT_B
	
	ldr	R0, =GPIOA_PDOR
	ldr	R3, =GPIOB_PDOR	
	strh	R1, [R0]		; load data to PORT_A
	strh	R2, [R3]		; load data to PORT_B
	bx	LR
	ENDP	

;----------------------------------------------------------------------------
	ALIGN
Table7Seg1;	PORT_A	PORT_B		; table for the 1st digit
	DCW	0x00E0,	0x0403		; 0
	DCW	0x0080,	0x0400		; 1
	DCW	0x00E0,	0x0005		; 2
	DCW	0x00C0,	0x0405		; 3
	DCW	0x0080,	0x0406		; 4
	DCW	0x0040,	0x0407		; 5
	DCW	0x0060,	0x0407		; 6
	DCW	0x0080,	0x0401		; 7
	DCW	0x00E0,	0x0407		; 8
	DCW	0x00C0,	0x0407		; 9
	DCW	0x00A0,	0x0407		; A
	DCW	0x0060,	0x0406		; b
	DCW	0x0060,	0x0003		; C
	DCW	0x00E0,	0x0404		; d
	DCW	0x0060,	0x0007		; E
	DCW	0x0020,	0x0007		; F

Table7Seg2;	PORT_A	PORT_B		; table for the 2nd digit
	DCW	0x0200,	0x00F8		; 0
	DCW	0x0000,	0x0018		; 1
	DCW	0x0100,	0x00E8		; 2
	DCW	0x0100,	0x00B8		; 3
	DCW	0x0300,	0x0018		; 4
	DCW	0x0300,	0x00B0		; 5
	DCW	0x0300,	0x00F0		; 6
	DCW	0x0000,	0x0038		; 7
	DCW	0x0300,	0x00F8		; 8
	DCW	0x0300,	0x00B8		; 9
	DCW	0x0300,	0x0078		; A
	DCW	0x0300,	0x00D0		; b
	DCW	0x0200,	0x00E0		; C
	DCW	0x0100,	0x00D8		; d
	DCW	0x0300,	0x00E0		; E
	DCW	0x0300,	0x0060		; F

	ALIGN 
	END
	