	INCLUDE MKL05Z4.inc		; CPU register definitions
	PRESERVE8
	THUMB				; use thumb instruction set
	AREA    |.text|, CODE, READONLY
	
MCG_setup	PROC			; switch to the FBI clock mode
	EXPORT	MCG_setup
	SETB	MCG_SC, 0		; select 1:1 clock divider
	
	SETB	MCG_C1, 0x44		; set CLKS bit and preserve IREFS
	ldr	R0, =MCG_S		; wait for the CLKST bit is set 
	movs	R2, #0x04		;   in the MSC status register
	movs	R3, #0xFF		; max # of repetitions (for debugging)
L1	ldrb	R1, [R0]		; start checking loop
	bics	R1, R2			; check the CLKST bit
	bne	.+6
	subs	R3, #1
	bne	L1

	SETB	MCG_C2, 0x03		; select fast internal ref clock & LP mode
	ldr	R0, =MCG_S		; wait for the IRCST bit is set
	movs	R2, #1			;   in the MSC status register
	movs	R3, #0xFF		; max # of repetitions (for debugging)
L2	ldrb	R1, [R0]
	bics	R1, R2			; check the IRCST bit
	bne	.+6
	subs	R3, #1
	bne	L2	

	SETW	SIM_CLKDIV1, 0x40000	; setup 0.8 MHz bus clock	
	bx	LR
	ENDP

;-------------------------------------------------------------------------------
SMC_setup	PROC			; System Mode Controller configuration
	EXPORT	SMC_setup
	SETB	SMC_PMPROT, 0x20	; allow VLPR, VLPW, VLPS modes
	SETB	SMC_PMCTRL, 0x42	; enter VLPS mode in STOP
	
;	SETB	SMC_PMPROT, 0x28	; allow VLPR, VLPW, VLPS, and LLS modes	
;	SETB	SMC_PMCTRL, 0x43	; enter LLS mode in STOP
;	SETB	LLWU_ME, 0x01		; enable LLWU module 0 (LPTMR0) wakeup
;	SETW	NVIC_ISER, 1<<7		; enable LLWU interrupt in NVIC
	bx	LR
	ENDP

;-------------------------------------------------------------------------------
PORTS_setup	PROC			; I/O Ports configuration
	EXPORT	PORTS_setup
	IOORH	SIM_SCGC5, 0x0600	; enable clock for I/O ports and LPTMR
	SETW	PORTA_GPCLR, 0x001A0300	; set ALT3 on RESET and I2C pins	
	SETW	PORTA_GPCLR, 0x13E00100	; configure PORTA for GPIO
	SETW	PORTB_GPCLR, 0x2CFF0100	; configure PORTB for GPIO
	SETH	GPIOA_PDDR, 0x13F8	; configure PORTA pins for output
	SETH	GPIOB_PDDR, 0x2CFF	; configure PORTB pins for output
	SETH	GPIOA_PDOR, 0		; init port output
	SETH	GPIOB_PDOR, 0
	bx	LR
	ENDP

;-------------------------------------------------------------------------------
LPTMR0_setup	PROC			; Low-Power Timer configuration
	EXPORT	LPTMR0_setup
	IOORB	SIM_SCGC5, 0x01		; enable clock for LPTMR	
	SETH	LPTMR0_CMR, 60		; setup for 60 msec interval
	SETB	LPTMR0_PSR, 0x05	; set LPO as clock source, no prescaler		
	SETB	LPTMR0_CSR, 0x41	; start timer in autoreset, enable interrupt
	SETW	NVIC_ISER, 0x10000000	; enable LPTMR0 interrupt in NVIC
	bx	LR
	ENDP

;-------------------------------------------------------------------------------
I2C_setup	PROC			; configuration of I2C module as master
	EXPORT	I2C_setup
	IOORB	SIM_SCGC4, 0x40		; enable clock for I2C module
	SETB	I2C0_F, 0x00		; div by 20 I2C clock rate
	SETW	NVIC_ISER, 1<<8		; enable I2C interrupt in NVIC
	bx	LR
	ENDP

	ALIGN
	END
	